/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetector;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public final class GroovySourceRootDetector
extends JavaSourceRootDetector {
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String getLanguageName() {
        String string = GroovyBundle.message("file.template.group.title.groovy", new Object[0]);
        if (string == null) {
            GroovySourceRootDetector.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected String getFileExtension() {
        return "groovy";
    }

    @NotNull
    protected NullableFunction<CharSequence, String> getPackageNameFetcher() {
        NullableFunction nullableFunction = charSequence -> GroovySourceRootDetector.getPackageName(charSequence);
        if (nullableFunction == null) {
            GroovySourceRootDetector.$$$reportNull$$$0(1);
        }
        return nullableFunction;
    }

    @Nullable
    public static String getPackageName(CharSequence text) {
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
        IElementType firstToken = lexer.getTokenType();
        if (firstToken != GroovyTokenTypes.kPACKAGE) {
            return "";
        }
        lexer.advance();
        GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
        StringBuilder buffer = new StringBuilder();
        while (lexer.getTokenType() == GroovyTokenTypes.mIDENT) {
            buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
            lexer.advance();
            GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
            if (lexer.getTokenType() != GroovyTokenTypes.mDOT) break;
            buffer.append('.');
            lexer.advance();
            GroovySourceRootDetector.skipWhitespacesAndComments((Lexer)lexer);
        }
        String packageName = buffer.toString();
        if (packageName.isEmpty() || StringUtil.endsWithChar((CharSequence)packageName, (char)'.')) {
            return null;
        }
        return packageName;
    }

    private static void skipWhitespacesAndComments(Lexer lexer) {
        while (TokenSets.ALL_COMMENT_TOKENS.contains(lexer.getTokenType()) || TokenSets.WHITE_SPACES_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/GroovySourceRootDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNameFetcher";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

