/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.utils;

import com.intellij.openapi.diagnostic.Logger;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J'\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/startup/importSettings/utils/CuteBenchmarker;", "", "processName", "", "<init>", "(Ljava/lang/String;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "segments", "", "", "start", "", "segmentName", "finish", "timedSection", "T", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nCuteBenchmarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CuteBenchmarker.kt\ncom/intellij/ide/startup/importSettings/utils/CuteBenchmarker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,36:1\n13#2:37\n*S KotlinDebug\n*F\n+ 1 CuteBenchmarker.kt\ncom/intellij/ide/startup/importSettings/utils/CuteBenchmarker\n*L\n7#1:37\n*E\n"})
public final class CuteBenchmarker {
    @NotNull
    private final String processName;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, Long> segments;

    public CuteBenchmarker(@NotNull String processName) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        this.processName = processName;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CuteBenchmarker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.segments = new LinkedHashMap();
    }

    public final void start(@NotNull String segmentName) {
        Intrinsics.checkNotNullParameter((Object)segmentName, (String)"segmentName");
        if (this.segments.get(segmentName) != null) {
            this.logger.warn("Segment was already started: " + this.processName + "." + segmentName);
            return;
        }
        this.logger.info("Started: " + this.processName + "." + segmentName);
        this.segments.put(segmentName, System.nanoTime());
    }

    public final void finish(@NotNull String segmentName) {
        Intrinsics.checkNotNullParameter((Object)segmentName, (String)"segmentName");
        if (this.segments.get(segmentName) == null) {
            this.logger.warn("Segment wasn't started: " + this.processName + "." + segmentName);
            return;
        }
        this.segments.put(segmentName, null);
        this.logger.info("Finished: " + this.processName + "." + segmentName);
    }

    public final <T> T timedSection(@NotNull String segmentName, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)segmentName, (String)"segmentName");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.start(segmentName);
        Object res2 = action.invoke();
        this.finish(segmentName);
        return (T)res2;
    }
}

