/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.run.ui.grid.GridModelUpdater;
import com.intellij.database.run.ui.grid.GridModelUpdaterUtil;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HierarchicalGridStorageAndModelUpdater
implements GridModelUpdater {
    private final GridModelUpdater myGridModelUpdater;
    private final HierarchicalColumnsDataGridModel myModel;
    private final GridMutationModel myMutationModel;
    private final Project myProject;
    private final int myColumnsLimit;

    public HierarchicalGridStorageAndModelUpdater(@NotNull HierarchicalColumnsDataGridModel model, @NotNull GridMutationModel mutationModel, @Nullable MutationsStorage storage, @Nullable Project project) {
        if (model == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(0);
        }
        if (mutationModel == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(1);
        }
        this.myMutationModel = mutationModel;
        this.myGridModelUpdater = new GridStorageAndModelUpdater(model, mutationModel, storage);
        this.myModel = model;
        this.myProject = project;
        this.myColumnsLimit = Registry.intValue((String)"grid.tables.columns.limit", (int)2000);
    }

    public HierarchicalGridStorageAndModelUpdater(@NotNull HierarchicalColumnsDataGridModel model, @NotNull GridMutationModel mutationModel, @Nullable MutationsStorage storage) {
        if (model == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(2);
        }
        if (mutationModel == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(3);
        }
        this.myMutationModel = mutationModel;
        this.myGridModelUpdater = new GridStorageAndModelUpdater(model, mutationModel, storage);
        this.myModel = model;
        this.myProject = null;
        this.myColumnsLimit = Registry.intValue((String)"grid.tables.columns.limit", (int)2000);
    }

    @Override
    public void removeRows(int firstRowIndex, int rowCount) {
        this.myGridModelUpdater.removeRows(firstRowIndex, rowCount);
    }

    @Override
    public void setColumns(@NotNull List<? extends GridColumn> columns) {
        if (columns == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(4);
        }
        this.myGridModelUpdater.setColumns(columns);
    }

    @Override
    public void setRows(int firstRowIndex, @NotNull List<? extends GridRow> rows, @NotNull GridRequestSource source) {
        if (rows == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(5);
        }
        if (source == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(6);
        }
        this.myGridModelUpdater.setRows(firstRowIndex, rows, source);
        if (firstRowIndex == 0) {
            boolean typesUpdated = this.myModel.updateColumnTypes();
            if (!typesUpdated) {
                return;
            }
            this.myMutationModel.notifyColumnsAdded(ModelIndexSet.forColumns(this.myMutationModel, GridModelUpdaterUtil.getColumnsIndicesRange(0, this.myMutationModel.getColumnCount())));
        }
    }

    @Override
    public void addRows(List<? extends GridRow> rows) {
        this.myGridModelUpdater.addRows(rows);
    }

    @Override
    public void afterLastRowAdded() {
        this.myGridModelUpdater.afterLastRowAdded();
    }

    public void setColumns(@NotNull List<? extends GridColumn> columns, HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode root) {
        if (columns == null) {
            HierarchicalGridStorageAndModelUpdater.$$$reportNull$$$0(7);
        }
        this.myModel.setOriginalColumnNamesHierarchy(root);
        if (this.myModel.getColumnCount() >= this.myColumnsLimit) {
            NotificationGroupManager.getInstance().getNotificationGroup("Kotlin Notebook output error").createNotification(DataGridBundle.message("hierarchical.grid.too.many.columns.error", new Object[0]), DataGridBundle.message("notification.content.could.not.display.table.with.d.columns", this.myModel.getColumnCount()), NotificationType.WARNING).notify(this.myProject);
            throw new TooManyColumnsException(String.format("Attempt to create grid with %d columns", this.myModel.getColumnCount()));
        }
        this.myGridModelUpdater.setColumns(columns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutationModel";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/HierarchicalGridStorageAndModelUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setColumns";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setRows";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TooManyColumnsException
    extends RuntimeException {
        public TooManyColumnsException(String message) {
            super(message);
        }
    }
}

