/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.toolsets.vcs;

import com.intellij.mcpserver.McpCallInfoKt;
import com.intellij.mcpserver.McpToolset;
import com.intellij.mcpserver.annotations.McpDescription;
import com.intellij.mcpserver.annotations.McpTool;
import com.intellij.mcpserver.toolsets.vcs.VcsToolset$VcsRoot$;
import com.intellij.mcpserver.toolsets.vcs.VcsToolset$VcsRoots$;
import com.intellij.mcpserver.util.Fs_utilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u0005H\u0087@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset;", "Lcom/intellij/mcpserver/McpToolset;", "<init>", "()V", "get_repositories", "Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoots;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "VcsRoots", "VcsRoot", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nVcsToolset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsToolset.kt\ncom/intellij/mcpserver/toolsets/vcs/VcsToolset\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,37:1\n374#2:38\n11879#3,9:39\n13805#3:48\n13806#3:50\n11888#3:51\n1#4:49\n37#5,2:52\n*S KotlinDebug\n*F\n+ 1 VcsToolset.kt\ncom/intellij/mcpserver/toolsets/vcs/VcsToolset\n*L\n31#1:38\n34#1:39,9\n34#1:48\n34#1:50\n34#1:51\n34#1:49\n35#1:52,2\n*E\n"})
public final class VcsToolset
implements McpToolset {
    /*
     * WARNING - void declaration
     */
    @McpTool
    @McpDescription(description="Retrieves the list of VCS roots in the project.\n    |This is useful to detect all repositories in a multi-repository project.")
    @Nullable
    public final Object get_repositories(@NotNull Continuation<? super VcsRoots> $completion) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean $i$f$currentCoroutineContext = false;
        Project project = McpCallInfoKt.getProject($completion.getContext());
        Path projectDirectory = Fs_utilKt.getProjectDirectory(project);
        com.intellij.openapi.vcs.VcsRoot[] vcsRootArray = ProjectLevelVcsManager.Companion.getInstance(project).getAllVcsRoots();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPath(...)");
            String string = Fs_utilKt.relativizeIfPossible(projectDirectory, virtualFile);
            Object object = it.getVcs();
            if (object == null || (object = object.getName()) == null) {
                object = "<Unknown VCS>";
            }
            VcsRoot it$iv$iv = new VcsRoot(string, (String)object);
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List vcs = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = vcs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new VcsRoots(thisCollection$iv.toArray(new VcsRoot[0]));
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ%\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot;", "", "pathRelativeToProject", "", "vcsName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPathRelativeToProject$annotations", "()V", "getPathRelativeToProject", "()Ljava/lang/String;", "getVcsName$annotations", "getVcsName", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_mcpserver", "$serializer", "Companion", "intellij.mcpserver"})
    public static final class VcsRoot {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String pathRelativeToProject;
        @NotNull
        private final String vcsName;

        public VcsRoot(@NotNull String pathRelativeToProject, @NotNull String vcsName) {
            Intrinsics.checkNotNullParameter((Object)pathRelativeToProject, (String)"pathRelativeToProject");
            Intrinsics.checkNotNullParameter((Object)vcsName, (String)"vcsName");
            this.pathRelativeToProject = pathRelativeToProject;
            this.vcsName = vcsName;
        }

        @NotNull
        public final String getPathRelativeToProject() {
            return this.pathRelativeToProject;
        }

        @McpDescription(description="Path of repository relative to the project directory. Empty string means the project root")
        public static /* synthetic */ void getPathRelativeToProject$annotations() {
        }

        @NotNull
        public final String getVcsName() {
            return this.vcsName;
        }

        @McpDescription(description="VCS used by this repository")
        public static /* synthetic */ void getVcsName$annotations() {
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_mcpserver(VcsRoot self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.pathRelativeToProject);
            output.encodeStringElement(serialDesc, 1, self.vcsName);
        }

        public /* synthetic */ VcsRoot(int seen0, String pathRelativeToProject, String vcsName, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)VcsRoot$$serializer.INSTANCE.getDescriptor());
            }
            this.pathRelativeToProject = pathRelativeToProject;
            this.vcsName = vcsName;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot;", "intellij.mcpserver"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<VcsRoot> serializer() {
                return (KSerializer)VcsRoot$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0016R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoots;", "", "roots", "", "Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot;", "<init>", "([Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(I[Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getRoots", "()[Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot;", "[Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoot;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_mcpserver", "$serializer", "Companion", "intellij.mcpserver"})
    public static final class VcsRoots {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final VcsRoot[] roots;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public VcsRoots(@NotNull VcsRoot[] roots) {
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            this.roots = roots;
        }

        @NotNull
        public final VcsRoot[] getRoots() {
            return this.roots;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_mcpserver(VcsRoots self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.roots);
        }

        public /* synthetic */ VcsRoots(int seen0, VcsRoot[] roots, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)VcsRoots$$serializer.INSTANCE.getDescriptor());
            }
            this.roots = roots;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ReferenceArraySerializer(Reflection.getOrCreateKotlinClass(VcsRoot.class), (KSerializer)VcsRoot$$serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoots$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/mcpserver/toolsets/vcs/VcsToolset$VcsRoots;", "intellij.mcpserver"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<VcsRoots> serializer() {
                return (KSerializer)VcsRoots$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

