/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.impl;

import com.intellij.mcpserver.clientConfiguration.ClaudeCodeMcpClient;
import com.intellij.mcpserver.clientConfiguration.ClaudeMcpClient;
import com.intellij.mcpserver.clientConfiguration.CursorClient;
import com.intellij.mcpserver.clientConfiguration.MCPClientNames;
import com.intellij.mcpserver.clientConfiguration.McpClient;
import com.intellij.mcpserver.clientConfiguration.VSCodeClient;
import com.intellij.mcpserver.clientConfiguration.WindsurfClient;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.containers.UtilKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/mcpserver/impl/McpClientDetector;", "", "<init>", "()V", "detectMcpClients", "", "Lcom/intellij/mcpserver/clientConfiguration/McpClient;", "project", "Lcom/intellij/openapi/project/Project;", "detectGlobalMcpClients", "detectProjectMcpClients", "looksLikeMcpJson", "", "file", "Ljava/nio/file/Path;", "detectVSCode", "detectClaudeCode", "detectClaudeDesktop", "detectCursorGlobal", "detectWindsurf", "detectProjectLevelClient", "configDirName", "", "clientName", "Lcom/intellij/mcpserver/clientConfiguration/MCPClientNames;", "detectCursorProject", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nMcpClientDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpClientDetector.kt\ncom/intellij/mcpserver/impl/McpClientDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n1#2:167\n*E\n"})
public final class McpClientDetector {
    @NotNull
    public static final McpClientDetector INSTANCE = new McpClientDetector();

    private McpClientDetector() {
    }

    @NotNull
    public final List<McpClient> detectMcpClients(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List detectedClients = new ArrayList();
        detectedClients.addAll((Collection)this.detectGlobalMcpClients());
        detectedClients.addAll((Collection)this.detectProjectMcpClients(project));
        return detectedClients;
    }

    @NotNull
    public final List<McpClient> detectGlobalMcpClients() {
        Object object;
        Object $this$detectGlobalMcpClients_u24lambda_u243;
        Object $this$detectGlobalMcpClients_u24lambda_u242;
        Object $this$detectGlobalMcpClients_u24lambda_u241;
        Object $this$detectGlobalMcpClients_u24lambda_u240;
        List globalClients = new ArrayList();
        McpClientDetector mcpClientDetector = this;
        try {
            $this$detectGlobalMcpClients_u24lambda_u240 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)globalClients, (Object)super.detectVSCode());
            $this$detectGlobalMcpClients_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$detectGlobalMcpClients_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        mcpClientDetector = this;
        try {
            $this$detectGlobalMcpClients_u24lambda_u241 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)globalClients, (Object)super.detectCursorGlobal());
            $this$detectGlobalMcpClients_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$detectGlobalMcpClients_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        mcpClientDetector = this;
        try {
            $this$detectGlobalMcpClients_u24lambda_u242 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)globalClients, (Object)super.detectClaudeDesktop());
            $this$detectGlobalMcpClients_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$detectGlobalMcpClients_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        mcpClientDetector = this;
        try {
            $this$detectGlobalMcpClients_u24lambda_u243 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)globalClients, (Object)super.detectClaudeCode());
            $this$detectGlobalMcpClients_u24lambda_u243 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$detectGlobalMcpClients_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        mcpClientDetector = this;
        try {
            McpClientDetector $this$detectGlobalMcpClients_u24lambda_u244 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)globalClients, (Object)$this$detectGlobalMcpClients_u24lambda_u244.detectWindsurf());
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return globalClients;
    }

    private final List<McpClient> detectProjectMcpClients(Project project) {
        Object object;
        Object $this$detectProjectMcpClients_u24lambda_u241;
        Object $this$detectProjectMcpClients_u24lambda_u240;
        List projectClients = new ArrayList();
        McpClientDetector mcpClientDetector = this;
        try {
            $this$detectProjectMcpClients_u24lambda_u240 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)projectClients, (Object)super.detectVSCode(project));
            $this$detectProjectMcpClients_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$detectProjectMcpClients_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        mcpClientDetector = this;
        try {
            $this$detectProjectMcpClients_u24lambda_u241 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)projectClients, (Object)super.detectCursorProject(project));
            $this$detectProjectMcpClients_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$detectProjectMcpClients_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        mcpClientDetector = this;
        try {
            McpClientDetector $this$detectProjectMcpClients_u24lambda_u242 = mcpClientDetector;
            boolean bl = false;
            UtilKt.addIfNotNull((List)projectClients, (Object)$this$detectProjectMcpClients_u24lambda_u242.detectClaudeCode(project));
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return projectClients;
    }

    private final boolean looksLikeMcpJson(Path file) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Object object;
                Object $this$looksLikeMcpJson_u24lambda_u240;
                Object object2 = this;
                try {
                    $this$looksLikeMcpJson_u24lambda_u240 = object2;
                    boolean bl = false;
                    $this$looksLikeMcpJson_u24lambda_u240 = Result.constructor-impl((Object)PathsKt.readText$default((Path)file, null, (int)1, null));
                }
                catch (Throwable bl) {
                    $this$looksLikeMcpJson_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = $this$looksLikeMcpJson_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) {
                    object = object2;
                } else {
                    Throwable it = throwable;
                    boolean bl = false;
                    object = "";
                }
                String content = (String)object;
                return StringsKt.contains$default((CharSequence)content, (CharSequence)"mcpServers", (boolean)false, (int)2, null);
            }
        }
        return false;
    }

    private final McpClient detectVSCode() {
        String configPath;
        if (SystemInfo.isMac) {
            v0 = "~/Library/Application Support/Code/User/mcp.json";
        } else if (SystemInfo.isWindows) {
            String string = System.getenv("APPDATA");
            if (string != null) {
                String it = string;
                boolean bl = false;
                v0 = it + "/Code/User/mcp.json";
            } else {
                v0 = null;
            }
        } else {
            v0 = configPath = SystemInfo.isLinux ? "~/.config/Code/User/mcp.json" : null;
        }
        if (configPath == null) {
            return null;
        }
        Path path = Paths.get(OSAgnosticPathUtil.expandUserHome((String)configPath), new String[0]);
        Intrinsics.checkNotNull((Object)path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return new VSCodeClient(path);
            }
        }
        return null;
    }

    private final McpClient detectClaudeCode() {
        String configPath;
        Object object = SystemInfo.isMac ? "~/.claude.json" : (SystemInfo.isWindows ? null : (configPath = SystemInfo.isLinux ? "~/.claude.json" : null));
        if (configPath == null) {
            return null;
        }
        Path path = Paths.get(OSAgnosticPathUtil.expandUserHome((String)configPath), new String[0]);
        Intrinsics.checkNotNull((Object)path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isRegularFile(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return new ClaudeCodeMcpClient(path);
            }
        }
        return null;
    }

    private final McpClient detectClaudeDesktop() {
        String configPath;
        if (SystemInfo.isMac) {
            v0 = "~/Library/Application Support/Claude/claude_desktop_config.json";
        } else if (SystemInfo.isWindows) {
            String string = System.getenv("APPDATA");
            if (string != null) {
                String it = string;
                boolean bl = false;
                v0 = it + "/Claude/claude_desktop_config.json";
            } else {
                v0 = null;
            }
        } else {
            v0 = configPath = SystemInfo.isLinux ? "~/.config/Claude/claude_desktop_config.json" : null;
        }
        if (configPath == null) {
            return null;
        }
        Path path = Paths.get(OSAgnosticPathUtil.expandUserHome((String)configPath), new String[0]);
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && path.getParent().toFile().isDirectory()) {
            Intrinsics.checkNotNull((Object)path);
            return new ClaudeMcpClient(path);
        }
        return null;
    }

    private final McpClient detectCursorGlobal() {
        Path path = Paths.get(OSAgnosticPathUtil.expandUserHome((String)"~/.cursor/mcp.json"), new String[0]);
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && path.getParent().toFile().isDirectory()) {
            Intrinsics.checkNotNull((Object)path);
            return new CursorClient(path);
        }
        return null;
    }

    private final McpClient detectWindsurf() {
        Path path = Paths.get(OSAgnosticPathUtil.expandUserHome((String)"~/.codeium/windsurf/mcp_config.json"), new String[0]);
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && path.getParent().toFile().isDirectory()) {
            Intrinsics.checkNotNull((Object)path);
            return new WindsurfClient(path);
        }
        return null;
    }

    private final McpClient detectProjectLevelClient(Project project, String configDirName, MCPClientNames clientName) {
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        String projectBasePath = string;
        String[] stringArray = new String[]{configDirName, "mcp.json"};
        Path configPath = Paths.get(projectBasePath, stringArray);
        Intrinsics.checkNotNull((Object)configPath);
        if (this.looksLikeMcpJson(configPath)) {
            return new McpClient(clientName, configPath);
        }
        return null;
    }

    private final McpClient detectVSCode(Project project) {
        String configDirName = ".vscode";
        return this.detectProjectLevelClient(project, configDirName, MCPClientNames.VS_CODE_PROJECT);
    }

    private final McpClient detectCursorProject(Project project) {
        String configDirName = ".cursor";
        return this.detectProjectLevelClient(project, configDirName, MCPClientNames.CURSOR_PROJECT);
    }

    private final McpClient detectClaudeCode(Project project) {
        String string = project.getBasePath();
        if (string == null) {
            return null;
        }
        String projectBasePath = string;
        String[] stringArray = new String[]{".mcp.json"};
        Path claudeCodeConfigPath = Paths.get(projectBasePath, stringArray);
        Intrinsics.checkNotNull((Object)claudeCodeConfigPath);
        if (this.looksLikeMcpJson(claudeCodeConfigPath)) {
            return new McpClient(MCPClientNames.CLAUDE_CODE_PROJECT, claudeCodeConfigPath);
        }
        return null;
    }
}

