/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.filters.lines.BaseLineFilter;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class TryFinallyLineFilter
extends BaseLineFilter {
    private final Set<Label> myCatchLabels = new HashSet<Label>();
    private State myState = State.INITIAL;
    private boolean myCatchLabelVisited = false;

    public boolean isApplicable(InstrumentationData context) {
        return true;
    }

    protected boolean shouldRemoveLine() {
        return this.myState == State.F1_ASTORE || this.myState == State.F2_GOTO && this.myCatchLabelVisited || this.myState == State.F3_THROW;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitTryCatchBlock((Label)var1_1, (Label)var2_2, handler, type);
        this.myCatchLabels.add((Label)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        void var1_1;
        super.visitLabel(label);
        this.myCatchLabelVisited = this.myCatchLabels.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int varIndex) {
        void var1_1;
        void var2_2;
        this.mv.visitVarInsn(opcode, (int)var2_2);
        if (opcode == 58 && this.myCatchLabelVisited) {
            this.myState = State.F1_ASTORE;
            return;
        }
        if (var1_1 == 25 && this.myState == State.INITIAL) {
            this.myState = State.F3_ALOAD;
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        void var2_2;
        this.mv.visitJumpInsn(opcode, (Label)var2_2);
        if (var1_1 != 167) {
            this.setHasInstructions();
            return;
        }
        if (this.myState == State.INITIAL) {
            this.myState = State.F2_GOTO;
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        this.mv.visitInsn(opcode);
        if (var1_1 == 191 && this.myState == State.F3_ALOAD) {
            this.myState = State.F3_THROW;
            return;
        }
        this.setHasInstructions();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        super.visitLineNumber((int)var1_1, (Label)var2_2);
        this.myState = State.INITIAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        F1_ASTORE,
        F2_GOTO,
        F3_ALOAD,
        F3_THROW;

    }
}

