/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class IdeaForkJoinWorkerThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    private static final AtomicLong bits = new AtomicLong();
    private static final ThreadLocal<Integer> FJP_THREAD_NUM = new ThreadLocal();

    public static void setupForkJoinCommonPool(boolean headless) {
        boolean parallelismWasNotSpecified;
        System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", IdeaForkJoinWorkerThreadFactory.class.getName());
        boolean bl = parallelismWasNotSpecified = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism") == null;
        if (parallelismWasNotSpecified) {
            int N_CPU = Runtime.getRuntime().availableProcessors();
            if (headless || N_CPU == 2) {
                System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(N_CPU));
            }
        }
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        final int n = IdeaForkJoinWorkerThreadFactory.setNextBit();
        ForkJoinWorkerThread thread = new ForkJoinWorkerThread(pool){

            @Override
            protected void onTermination(Throwable exception) {
                IdeaForkJoinWorkerThreadFactory.clearBit(n);
                super.onTermination(exception);
            }
        };
        thread.setName("JobScheduler FJ pool " + n + "/" + pool.getParallelism());
        FJP_THREAD_NUM.set(n);
        return thread;
    }

    private static int setNextBit() {
        long oldValue = bits.getAndUpdate(value -> value + 1L | value);
        return Long.numberOfTrailingZeros(oldValue + 1L);
    }

    private static void clearBit(int n) {
        bits.updateAndGet(value -> value & (1L << n ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static int getThreadNum() {
        Integer i = FJP_THREAD_NUM.get();
        return i == null ? 0 : i;
    }
}

