/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.Replacements;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KotlinSafeCallOperatorFilter
implements IFilter {
    KotlinSafeCallOperatorFilter() {
    }

    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        for (ArrayList<JumpInsnNode> chain : KotlinSafeCallOperatorFilter.findChains(methodNode)) {
            AbstractInsnNode ifNonNullInstruction = chain.get((int)0).label.getPrevious();
            if (chain.size() == 1 && ifNonNullInstruction.getOpcode() != 199) continue;
            AbstractInsnNode nullTarget = AbstractMatcher.skipNonOpcodes(chain.get((int)0).label);
            for (JumpInsnNode ifNullInstruction : chain) {
                Replacements replacements = new Replacements();
                replacements.add(ifNullInstruction, ifNullInstruction, 0);
                replacements.add(nullTarget, nullTarget, 0);
                output.replaceBranches(ifNullInstruction, replacements);
            }
            if (ifNonNullInstruction.getOpcode() != 199) continue;
            Replacements replacements = new Replacements();
            replacements.add(nullTarget, nullTarget, 0);
            replacements.add(ifNonNullInstruction, ifNonNullInstruction, 1);
            output.replaceBranches(ifNonNullInstruction, replacements);
        }
    }

    private static Collection<ArrayList<JumpInsnNode>> findChains(MethodNode methodNode) {
        HashMap<LabelNode, ArrayList<JumpInsnNode>> chains = new HashMap<LabelNode, ArrayList<JumpInsnNode>>();
        for (AbstractInsnNode i : methodNode.instructions) {
            AbstractInsnNode p2;
            AbstractInsnNode p1;
            if (i.getOpcode() != 198) continue;
            JumpInsnNode jump = (JumpInsnNode)i;
            LabelNode label = jump.label;
            AbstractInsnNode target = AbstractMatcher.skipNonOpcodes(label);
            ArrayList<JumpInsnNode> chain = (ArrayList<JumpInsnNode>)chains.get(label);
            if (target.getOpcode() == 87) {
                if (i.getPrevious().getOpcode() != 89) {
                    continue;
                }
            } else if (target.getOpcode() != 1 ? !KotlinSafeCallOperatorFilter.isUnoptimizedSafeCallFollowedByElvis(jump, target, chain) : (p1 = KotlinSafeCallOperatorFilter.preceding(i, 25)) == null || chain != null && ((p2 = KotlinSafeCallOperatorFilter.preceding(p1, 58)) == null || ((VarInsnNode)p1).var != ((VarInsnNode)p2).var)) continue;
            if (chain == null) {
                chain = new ArrayList<JumpInsnNode>();
                chains.put(label, chain);
            }
            chain.add(jump);
        }
        return chains.values();
    }

    private static boolean isUnoptimizedSafeCallFollowedByElvis(JumpInsnNode jump, AbstractInsnNode target, ArrayList<JumpInsnNode> chain) {
        if (target.getType() == 7 || target.getType() == 11 || target.getType() == 12) {
            return false;
        }
        AbstractInsnNode p1 = KotlinSafeCallOperatorFilter.preceding(jump, 25);
        if (p1 == null) {
            return false;
        }
        if (chain == null) {
            AbstractInsnNode gotoInstruction = KotlinSafeCallOperatorFilter.preceding(jump.label, 167);
            AbstractInsnNode loadInstruction1 = KotlinSafeCallOperatorFilter.preceding(gotoInstruction, 25);
            AbstractInsnNode ifNullInstruction = KotlinSafeCallOperatorFilter.preceding(loadInstruction1, 198);
            AbstractInsnNode loadInstruction2 = KotlinSafeCallOperatorFilter.preceding(ifNullInstruction, 25);
            AbstractInsnNode storeInstruction = KotlinSafeCallOperatorFilter.preceding(loadInstruction2, 58);
            return storeInstruction != null && ((JumpInsnNode)ifNullInstruction).label == jump.label && ((VarInsnNode)loadInstruction1).var == ((VarInsnNode)loadInstruction2).var && ((VarInsnNode)loadInstruction1).var == ((VarInsnNode)storeInstruction).var;
        }
        AbstractInsnNode p2 = KotlinSafeCallOperatorFilter.preceding(p1, 58);
        return p2 != null && ((VarInsnNode)p1).var == ((VarInsnNode)p2).var;
    }

    private static AbstractInsnNode preceding(AbstractInsnNode i, int opcode) {
        if (i == null) {
            return null;
        }
        do {
            if ((i = i.getPrevious()) != null) continue;
            return null;
        } while (i.getType() == 8 || i.getType() == 15 || i.getType() == 14);
        return i.getOpcode() == opcode ? i : null;
    }
}

