/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public final class InstrumenterClassWriter
extends ClassWriter {
    private final InstrumentationClassFinder myFinder;

    public InstrumenterClassWriter(ClassReader reader, int flags, InstrumentationClassFinder finder) {
        super(reader, flags);
        this.myFinder = finder;
    }

    public InstrumenterClassWriter(int flags, InstrumentationClassFinder finder) {
        super(flags);
        this.myFinder = finder;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        try {
            InstrumentationClassFinder.PseudoClass cls1 = this.myFinder.loadClass(type1);
            InstrumentationClassFinder.PseudoClass cls2 = this.myFinder.loadClass(type2);
            if (cls1.isAssignableFrom(cls2)) {
                return cls1.getName();
            }
            if (cls2.isAssignableFrom(cls1)) {
                return cls2.getName();
            }
            if (cls1.isInterface() || cls2.isInterface()) {
                return "java/lang/Object";
            }
            InstrumentationClassFinder.PseudoClass c = cls1;
            while (!(c = c.getSuperClass()).isAssignableFrom(cls2)) {
            }
            return c.getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public static int getClassFileVersion(ClassReader reader) {
        return reader.readInt(4);
    }

    public static int getAsmClassWriterFlags(int classFileVersion) {
        return (classFileVersion & 0xFFFF) >= 50 ? 2 : 1;
    }
}

