/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SpellingRules;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;

class QuantifierNounCompatibility {
    private static final NodePattern units = NodePattern.or(Semantics.timeUnits, NodePattern.N.lemma("star|mile"));
    private static final NodePattern hasPlural = NodePattern.custom(n -> !n.tree().treeSupport().inflectNode((Node)n, "NN", "NNS").isEmpty());
    private static final NodePattern nounUsedInsteadOfVerb = NodePattern.N.noDependents("cop").noPotentialPos("VB.*").andOr(NodePattern.N.withDependent("nsubj"), NodePattern.N.withHeadRelation("ccomp|acl"));
    static final NodePattern definitelySg = NodePattern.N.pos("NN").noPos("NNP|NNS").andNot(NodePattern.N.pos("JJ.*").withDependent("det", NodePattern.N.form("the"))).andNot(Semantics.color).andNot(CommonPatterns.beforeSlashOrParenth).andNot(Semantics.nounMissingPluralPos).andNot(NodePattern.N.withDependent("conj", NodePattern.N.withDependent("compound")).trace("(compound1 and compound2) head vs. compound1 and (compound2 head)")).andNot(NodePattern.N.withDependent("amod", NodePattern.N.withDependent("cc"))).andNot(nounUsedInsteadOfVerb).noDependents("appos", NodePattern.N.directlyAfterHead().pos("NNS")).andNot(NodePattern.N.potentialPos("JJ.*").directlyBefore(CommonPatterns.comma.withHead("punct", EnglishTreePatterns.oblWithoutCase.withDependent("amod")))).andNot(Semantics.adjectivesPossiblyDenotingGroups).noForm("several|class|fold|means|baht|staff|(meta|geo)?data").andNot(NodePattern.N.inFormSequence(0, "coup", "d..tats")).andNot(EnglishTreePatterns.anyPercent);
    static final NodePattern possiblyUncountable = NodePattern.or(Semantics.possiblyUncountableLemma.andNot(Semantics.definitelyCountable), NodePattern.N.form("up").withDependent("compound"));
    private static final NodePattern plural = NodePattern.custom(n -> Number.nounNumber(n) == Number.plural);
    private static final NodePattern inBraces = NodePattern.N.inFormSequence(1, "\\{", ".*", "}");
    private static final NodePattern informalLotOfNN = NodePattern.N.inFormSequence(1, "a", "lot", "of").withDependent("cop").withDependent("nsubj|expl", NodePattern.N.form("it|that|t?here"));
    private static final NodePattern pluralRequiringGroup = NodePattern.or(Semantics.numberDelegatingGroup, Semantics.plainGroup, NodePattern.N.lemma("group"), EnglishTreePatterns.anyPercent.withHead("nsubj.*", NodePattern.custom(p -> Number.verbNumber(EnglishTreePatterns.findFiniteVerb(p)) == Number.plural))).noDependents("compound", NodePattern.not(NodePattern.N.directlyBefore(EnglishTreePatterns.perCent))).andNot(informalLotOfNN);
    private static final NodePattern noSuggestUncountable = NodePattern.N.lemma("response|flight|gym|company|suggestion|dawn|country|comment|manufacture|kind");
    private static final NodePattern definitelyPluralizableGroupMember = NodePattern.not(possiblyUncountable.andNot(noSuggestUncountable)).andNot(NodePattern.N.potentialPos("VBG")).andNot(Semantics.possiblyNonPluralizableGroup);
    static final NodePattern groupNumberIssue = pluralRequiringGroup.withDependent("nmod", definitelySg.and(definitelyPluralizableGroupMember));
    private static final String year = "[12]\\d\\d\\d";
    private static final String phone = "911|112";
    private static final String order = "\\d+[a-z]+";
    private static final String roman = "[IVXLCDM]+";
    private static final String resolution = "\\d+x\\d+";
    private static final NodePattern zero = NodePattern.N.form("zero|0");
    private static final NodePattern zeroExceptions = zero.withHead(NodePattern.or(possiblyUncountable, NodePattern.N.withDependent("nmod:poss")));
    private static final NodePattern httpStatusCode = NodePattern.N.form("[12345]\\d{2}").andOr(NodePattern.N.withHead("nummod", NodePattern.N.form("error|response|page")), NodePattern.N.inFormSequence(0, "205", "reset", "content"), NodePattern.N.inFormSequence(0, "308", "permanent", "redirect"), NodePattern.N.inFormSequence(0, "400", "bad", "request"), NodePattern.N.inFormSequence(0, "402", "payment"), NodePattern.N.inFormSequence(0, "409", "conflict"), NodePattern.N.inFormSequence(0, "411", "length"), NodePattern.N.inFormSequence(0, "412|428", "precondition"), NodePattern.N.inFormSequence(0, "413", "payload"), NodePattern.N.inFormSequence(0, "421", "misdirected", "request"), NodePattern.N.inFormSequence(0, "422", "unprocess[ia]ble", "content"), NodePattern.N.inFormSequence(0, "424", "failed", "dependency"), NodePattern.N.inFormSequence(0, "426", "upgrade"), NodePattern.N.inFormSequence(0, "502", "bad", "gateway"), NodePattern.N.inFormSequence(0, "504", "gateway"));
    static final NodePattern pluralNummod = NodePattern.or(CommonPatterns.withNumberLikeForm, CommonPatterns.letterWord.pos(".*")).beforeHead().noForm("\\+\\d+|-?0*1|0\\d+|\\d.*[^\\d,_.].*|one|times|twice|half|a|unit|every|any|en|.*[:/].*|.*\\..*|[12]\\d\\d\\d|911|112|\\d+[a-z]+|\\d+x\\d+|[IVXLCDM]+").andNot(httpStatusCode).andNot(zeroExceptions).noLemma("part|half|third|quarter|most|rest|majority|minority").andNot(NodePattern.N.inFormSequence(1, "a", ".*,.*")).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("[-+);.]|to|x|by|VAC|due|per"), EnglishTreePatterns.aposOrQuote))).andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("[-=:]|[$\u00a3\u20ac\u00a5\u20bd]"), EnglishTreePatterns.aposOrQuote))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nummod"))).andNot(inBraces).andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalizedMiddle)).andNot(SpellingRules.numberWithSeparateSuffix).andNot(CommonPatterns.afterSkipping(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.form("[12]\\d\\d\\d"))).noDependents("conj", NodePattern.N.form("half")).noDependents("nmod").noDependents("compound", NodePattern.N.noPos("CD"));
    private static final NodePattern misparsedCompoundConjStart = NodePattern.N.directlyBefore(NodePattern.N.withHead("cc", NodePattern.N.potentialPos("NN.*").noDependents("case|nsubj(:pass|:outer)?|csubj(:pass)?|expl").andOr(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.withDependent("amod|compound")), NodePattern.N.directlyBefore(NodePattern.N.pos("NN.*")))));
    private static final NodePattern misparsedCompoundConjEnd = NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("compound")).withDependent("cc").directlyBefore(NodePattern.N.pos("NN.*"));
    static final NodePattern quantifiedNpVsCcompAmbiguity = NodePattern.N.directlyBeforeHead().markAs("SubjCandidate").withHead(NodePattern.N.potentialPos("VBZ").and((node, match) -> {
        Node subj = match.getMarkedNode("SubjCandidate");
        List<Tree.Reading> readings = node.tagIndependently().tokenReadings().stream().filter(r -> r.pos() != null && r.lemma() != null && r.pos().startsWith("V")).toList();
        return SemCompatibility.forSubject(node.copyWithForm(node.form(), readings), subj) != SemCompatibility.Unlikely ? match : null;
    }).noDependents("case").andNot(NodePattern.N.withHeadRelation("nsubj")).andNot(NodePattern.N.withHead("obj", NodePattern.or(NodePattern.N.lemma("have"), EnglishValences.definitelyTransitive)))).andNot(CommonPatterns.possiblySkipUp("amod", NodePattern.N.withDependent("det|advmod", NodePattern.N.form("this"))));
    private static final NodePattern amountNoun = NodePattern.N.form("quota|allowance");
    static final NodePattern misparsedALotOfNounVerb = NodePattern.N.withDependent("compound").potentialPos("VB.*").withHead(NodePattern.or(NodePattern.ROOT.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl"), NodePattern.N.withHead("nsubj", NodePattern.N.noPos("VB.*").noDependents("cop")))).trace("misparsed A lot of Noun Verb");

    QuantifierNounCompatibility() {
    }

    private static NodePattern fewerLower() {
        NodePattern fewer = NodePattern.N.form("fewer").noDependents("obl:npmod").andOr(NodePattern.N.withHead("amod", NodePattern.or(Semantics.definitelyUncountableNoun, possiblyUncountable.pos("NN"))).and(QuantifierNounCompatibility.wrongQuantifier("uncountable", "less")), NodePattern.N.withHead("amod", WordConfusion.lowerHigherNoun).noDependents().andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("nummod"))).and(QuantifierNounCompatibility.wrongQuantifier("singular", "lower")), NodePattern.N.withDependent("cop").withDependent("nsubj", WordConfusion.lowerHigherNoun.message("Use 'lower' with singular nouns like '$_'")).correct(NodeCorrector.replace("lower")));
        NodePattern fewest = NodePattern.N.form("fewest").withHead("amod", WordConfusion.lowerHigherNoun).and(QuantifierNounCompatibility.wrongQuantifier("singular", "lowest"));
        return NodePattern.or(fewer, fewest);
    }

    private static NodePattern lessFewer() {
        NodePattern less = NodePattern.N.form("less").markAs("Less").noDependents("obl.*", NodePattern.N.form("%")).andNot(CommonPatterns.capitalized.withHead(NodePattern.N.form("files"))).andNot(NodePattern.N.inFormSequence(1, "or", "less")).andOr(NodePattern.N.beforeHead().andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("amod"))).withHead("amod", plural.noForm("taxes").noHeadRelation("parataxis").and(QuantifierNounCompatibility.toSingularUncountableOr(NodePattern.markedNodeMatches("Less", NodePattern.or(NodePattern.N.inFormSequence(0, "less", "and", "less").correct(NodeCorrector.replace("fewer").join(NodeCorrector.replace(NodePointer.neighbor(2), "fewer"))), NodePattern.N.correct(NodeCorrector.replace("fewer"))))))).andNot(NodePattern.N.directlyBeforeHead().directlyAfter(NodePattern.N.pos("NN.*"))).message("'less' can only occur with singular uncountable nouns"), NodePattern.N.withHead("conj", plural.andNot(possiblyUncountable).andNot(units)).and(QuantifierNounCompatibility.wrongQuantifier("countable", "fewer")));
        NodePattern least = NodePattern.N.form("least").markAs("Least").withHead("amod", plural.noForm("problems|regrets|resources|changes|percentages|squares").andOptionally(possiblyUncountable.correct(NodeCorrector.inflect("NN"))).noDependents("amod", NodePattern.N.after("Least"))).correct(NodeCorrector.replace("fewest")).message("'least' can only occur with singular uncountable nouns");
        return NodePattern.or(less, least);
    }

    private static NodePattern various() {
        return NodePattern.N.form("various").withHead("amod", definitelySg.andNot(possiblyUncountable).includeIntoReport().noHeadRelation("nmod:poss").andNot(CommonPatterns.skipConjUp(NodePattern.N.withHead("amod|compound", NodePattern.N.pos("NNS")))).and(QuantifierNounCompatibility::toPlural)).message("Use plural nouns after 'various'");
    }

    private static NodePattern all() {
        return NodePattern.N.form("all").beforeHead().markAs("All").noDependents().withHead("det", CommonPatterns.skipUp("amod|compound", definitelySg.andNot(possiblyUncountable.andNot(noSuggestUncountable).andNot(EnglishTreePatterns.typeSynonyms)).includeIntoReport().andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nmod:poss|appos|amod"))).andNot(NodePattern.N.anyMatchUntil("All", EnglishTreePatterns.quotations)).noDependents("compound", NodePattern.N.pos("NNP?S").after("All").noDependents("amod").trace("ambiguous all NNS NN")).noDependents("case", NodePattern.N.after("All")).andNot(NodePattern.N.withHead("obj", EnglishTreePatterns.compound)).andNot(NodePattern.N.withHead("nsubj.*", NodePattern.N.withHeadRelation("csubj"))).andNot(Semantics.timeUnits).andNot(NodePattern.not(CommonPatterns.capitalizedMiddle).withDependent("compound", CommonPatterns.capitalizedMiddle)).andNot(NodePattern.N.potentialPos("CD")).andNot(NodePattern.N.inFormSequence(0, "ratio", "\\d+.*")).andNot(NodePattern.N.inFormSequence(0, "way", "to")).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VBN"))).andNot(Articles.allowMissingArticle.andNot(CommonPatterns.firstPhrase)).and(QuantifierNounCompatibility::toPlural))).andNot(CommonPatterns.capitalizedMiddle.withHead(NodePattern.not(CommonPatterns.capitalizedMiddle))).andNot(NodePattern.N.inFormSequence(2, "first|most", "of", "all")).andNot(NodePattern.N.inFormSequence(1, "in", "all", "likelihood")).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("hail"), CommonPatterns.HYPHEN_NODE))).andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.lemma("be"), CommonPatterns.HYPHEN_NODE))).includeIntoReport().message("Use plural nouns after 'all'");
    }

    private static NodePattern numberAmountOf() {
        NodePattern numberOf = definitelySg.withDependent("case", NodePattern.N.form("of").markAs("Of")).markAs("Sg").withHead("nmod", NodePattern.N.lemma("number").directlyBefore("Of").noDependents("compound").noDependents("nmod", NodePattern.or(NodePattern.N.noDependents("case"), NodePattern.N.before("Sg"))).noDependents("conj", NodePattern.N.afterHead().before("Sg"))).noDependents("compound|nummod", EnglishTreePatterns.number).andNot(NodePattern.or(NodePattern.N.withDependent("appos", NodePattern.N.pos("NNS")), NodePattern.N.withNextSibling(NodePattern.N.pos("NNS").withHeadRelation("appos"))).trace("compound misparsed as appos")).andOr(possiblyUncountable.andOr(NodePattern.N.withHead(NodePattern.N.inFormSequence(1, "a", "number", "of").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "much", "a good deal of"))).message("Use 'much' with uncountable nouns like '$_'"), NodePattern.or(WordConfusion.lowerHigherNoun.withHead(NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), ""))), NodePattern.N.noLemma("build|port").withHead(NodePattern.N.correct(NodeCorrector.replace("amount")))).message("Don\u2019t use 'number' with uncountable nouns")), NodePattern.not(possiblyUncountable).noDependents("det|nmod:poss").and(QuantifierNounCompatibility::toPlural).message("Use plural nouns after 'number of'"));
        NodePattern amountOf = NodePattern.N.inFormSequence(0, "amounts?|deal|smidge", "of").markAs("Amount").withDependent("nmod", plural.markAs("Plural").andNot(Semantics.uncountableOnlyWhenPlural).andNot(EnglishTreePatterns.typeSynonyms.withHead(NodePattern.N.pos("NNS"))).noLemma("calorie|resource|baht|dollar|euro|pound|ruble|ether|bitcoin|rupee|peso|yen|yuan|franc|krone|zloty|forint|koruna|leu|naira|shilling|lira|rupiah|taka|dong|dram|lari|hryvnia|hryvna|dirham|dinar|note|banknote").withDependent("case", NodePattern.N.form("of")).and(QuantifierNounCompatibility.toSingularUncountableOr(NodePattern.markedNodeMatches("Amount", NodePattern.N.pos("NNS").correct(NodeCorrector.replace("numbers"))), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Amount"), "number"))))).message("Use 'number' with countable noun '$Plural'?");
        return NodePattern.or(numberOf, amountOf);
    }

    private static NodePattern much() {
        NodePattern muchOf = NodePattern.N.inFormSequence(0, "much", "of").markAs("Much").withDependent("obl", plural.andNot(units).withDependent("case", NodePattern.N.form("of").markAs("Of")).message("'much' can only occur with singular uncountable nouns").and(QuantifierNounCompatibility.toSingularUncountableOr(NodePattern.markedNodeMatches("Of", NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("nmod:poss"))).correct(NodeCorrector.replace(NodePointer.marked("Much"), "many")), NodePattern.markedNodeMatches("Of", NodePattern.N.directlyBefore(NodePattern.N.form("the").markAs("The"))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Much"), NodePointer.marked("The"), "many")).correct(NodeCorrector.replace(NodePointer.marked("Much"), "many")), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.marked("Much"), NodePointer.marked("Of"), "many")))));
        NodePattern much = NodePattern.N.form("much").markAs("Much").andOr(NodePattern.N.beforeHead().withHead("amod", NodePattern.N.markAs("Noun")), NodePattern.N.directlyBefore(NodePattern.N.form("more").beforeHead().markAs("More").withHead("amod", NodePattern.N.noDependents("amod", NodePattern.N.noPotentialPos("NN").beforeHead().after("More")).markAs("Noun"))), NodePattern.N.withHeadRelation("advmod").withNextSibling(NodePattern.N.withHeadRelation("obj").noDependents("det|nmod:poss").markAs("Noun"))).and(NodePattern.markedNodeMatches("Noun", plural.message("Use 'many' with plural nouns like '$_'").and(QuantifierNounCompatibility.toSingularUncountableOr(NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Much"), "many")))))).andNot(quantifiedNpVsCcompAmbiguity).andNot(CommonPatterns.afterSkipping(NodePattern.N.pos("RB"), NodePattern.N.form("was|[i'\u2019`\u2018]s"))).noDependents("mark|advmod", NodePattern.N.form("how"));
        return NodePattern.or(much, muchOf);
    }

    static NodePattern pattern() {
        return NodePattern.or(QuantifierNounCompatibility.fewerLower(), QuantifierNounCompatibility.lessFewer(), QuantifierNounCompatibility.manyFewSeveral(), QuantifierNounCompatibility.various(), QuantifierNounCompatibility.all(), QuantifierNounCompatibility.eachPlural(), QuantifierNounCompatibility.much(), QuantifierNounCompatibility.numberAmountOf(), QuantifierNounCompatibility.xOfSg(), QuantifierNounCompatibility.bothSg(), QuantifierNounCompatibility.enoughSg(), QuantifierNounCompatibility.otherSingular(), QuantifierNounCompatibility.numSingular(), QuantifierNounCompatibility.numBillions(), QuantifierNounCompatibility.oneThisThese(), QuantifierNounCompatibility.noThis());
    }

    private static NodePattern manyFewSeveral() {
        NodePattern head = definitelySg.noLemma("dozen|hundred|thousand|million|billion|(ga)?zillion").andNot(CommonPatterns.capitalized.directlyBefore(NodePattern.N.form("of")).withNeighbor(2, CommonPatterns.capitalized)).noForm("present").noPotentialPos("VBN").andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("root|ccomp|xcomp")).potentialPos("VB")).andOr(NodePattern.N.noHeadRelation("compound"), NodePattern.N.withPhraseStart(CommonPatterns.openingParen)).andNot(misparsedCompoundConjStart).andNot(misparsedCompoundConjEnd).noForm("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])").markAs("Noun");
        return EnglishTreePatterns.manyFewSeveral.beforeHead().andOr(NodePattern.N.withHead("amod", head), NodePattern.N.withHead("advmod", NodePattern.N.pos("JJR").withHead("amod", head))).andNot(NodePattern.N.inFormSequence(0, "many", "a|an|as")).andNot(NodePattern.N.inFormSequence(0, "many", "to", "many")).andNot(EnglishTreePatterns.aFew.withHead("amod", NodePattern.N.withHeadRelation("advcl").potentialPos("VB[PD]?"))).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.directlyBefore(WordSeparation.adjectiveWithNumber)).and((det, match) -> {
            boolean fixNumber;
            Node noun = match.getMarkedNode("Noun");
            boolean fixDet = Semantics.possiblyUncountableLemma.andNot(Semantics.definitelyCountable).andNot(noSuggestUncountable).matches(noun);
            boolean bl = fixNumber = !Semantics.definitelyUncountableNoun.matches(noun) && !det.neighbor(1).hasForm("more");
            if (fixDet) {
                Pair<List<NodeCorrector>, List<Node>> toSg = new AgreementSet(noun, Number.singular).changeNumber(Set.of(det));
                NodeCorrector muchSome = NodeCorrector.replace(det, det.hasForm("many") ? "much" : (det.hasForm("few") ? "little" : "some"));
                match = match.withCorrectors(QuantifierNounCompatibility.joinCorrectors(muchSome, (List)toSg.getLeft())).withReportedNode(det);
                if (det.hasForm("many") && det.allDependents().isEmpty() && !det.neighbor(1).hasForm("more")) {
                    match = match.withCorrectors(QuantifierNounCompatibility.joinCorrectors(NodeCorrector.replace(det, "a lot of"), (List)toSg.getLeft()));
                }
                if (EnglishTreePatterns.aFew.matches(det)) {
                    match = match.withCorrectors(QuantifierNounCompatibility.joinCorrectors(NodeCorrector.replaceNodes(det.neighbor(-1), det, "some"), (List)toSg.getLeft()));
                    match = match.withReportedNode(det.neighbor(-1));
                }
            }
            match = fixNumber ? QuantifierNounCompatibility.toPlural(noun, match).withReportedNode(noun).withMessage("Use plural nouns after " + det.quotedPresentableText()) : match.withMessage(det.quotedPresentableText() + " is not used with uncountable nouns like " + noun.quotedPresentableText());
            return match;
        });
    }

    private static NodePattern xOfSg() {
        NodePattern percentOfInanimate = NodePattern.N.withHead(EnglishTreePatterns.anyPercent).and(n -> {
            Semantics.Animacy animacy = Semantics.animacy(n);
            return animacy == null || animacy == Semantics.Animacy.inanimate;
        });
        return definitelySg.withDependent("case", NodePattern.N.form("of")).andNot(NodePattern.N.potentialPos("CD")).andNot(CommonPatterns.capitalized).andNot(NodePattern.N.potentialPos("JJ.*|VBN").withDependent("det", NodePattern.N.form("the")).andNot(Semantics.unlikelyToBeAdj)).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations.noSpaceBefore())).markAs("Sg").andOr(definitelyPluralizableGroupMember.withHead("nmod", NodePattern.or(pluralRequiringGroup, NodePattern.N.form("none"))).andNot(amountNoun).andNot(percentOfInanimate), NodePattern.N.withHead("nmod", NodePattern.or(NodePattern.N.form("each|every|either|neither|several|few"), NodePattern.N.form("both").noDependents("conj").andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj"))), NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion").andNot(NodePattern.markedNodeMatches("Sg", possiblyUncountable)), NodePattern.N.form("one").noDependents("det", NodePattern.N.form("the")).noDependents("nmod", NodePattern.or(possiblyUncountable.noDependents("det", NodePattern.N.noForm("an?")), Semantics.anyGroup, NodePattern.N.withDependent("amod", NodePattern.N.lemma("same"))))))).noForm("mine|upside").andNot(NodePattern.N.inFormSequence(0, "stop", "and", "go")).andNot(NodePattern.N.inFormSequence(0, "back", "and", "forth")).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VBN").andNot(NodePattern.ROOT))).andNot(NodePattern.N.withHead(NodePattern.N.lemma("lot").withHead("obj", NodePattern.N.lemma("remind")))).andNot(NodePattern.N.withHead(NodePattern.N.form("pair")).andOr(NodePattern.N.withDependent("conj"), NodePattern.N.withHead(NodePattern.N.withDependent("conj")))).andNot(misparsedALotOfNounVerb).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("obl:npmod")).trace("separate advmod 'a lot' in 'X reminds me a lot of Y'")).andNot(misparsedCompoundConjStart).noDependents("det", NodePattern.N.form("any|each|every")).and(hasPlural).andNot(NodePattern.N.directlyBefore(NodePattern.ROOT.potentialPos("NNS").andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("det")))).trace("wrong local and exp trees")).and((node, match) -> {
            Node head = Objects.requireNonNull(node.head());
            String x = (EnglishTreePatterns.perCent.matches(head) ? "per " : "") + head.presentableText();
            return QuantifierNounCompatibility.toPlural(node, match).withMessage("Use plural nouns after '" + x + " of'");
        });
    }

    private static NodePattern bothSg() {
        return definitelySg.withDependent("det", NodePattern.N.form("both").markAs("Both")).noDependents("conj").andNot(EnglishTreePatterns.unlikelyToBeNoun).withPhraseEnd(NodePattern.N.noMatchUntil("Both", NodePattern.N.form("and"))).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations.noSpaceBefore())).and((node, match) -> QuantifierNounCompatibility.toPlural(node, match).withMessage("Use plural nouns after 'both'"));
    }

    private static NodePattern enoughSg() {
        return definitelySg.andNot(possiblyUncountable).andNot(amountNoun).withDependent("amod", NodePattern.N.form("enough").andNot(NodePattern.N.directlyAfter(NodePattern.N.potentialPos("JJ")))).and((node, match) -> {
            if (!SubjectVerbAgreement.errorPattern.matches(node)) {
                List similar = ((StreamEx)((StreamEx)node.similarWordsOfPos("NN").without((Object)"mono").filter(Semantics.isPossiblyUncountableNoun)).limit(2L)).toList();
                match = match.withCorrector(NodeCorrector.replace(node, similar));
            }
            return QuantifierNounCompatibility.toPlural(node, match).withMessage("Use plural or uncountable nouns after 'enough'");
        });
    }

    private static NodePattern toSingularUncountableOr(NodePattern ... toCountableQualifier) {
        return NodePattern.N.andOptionally(NodePattern.not(Semantics.definitelyUncountableNoun).and(toCountableQualifier.length > 1 ? NodePattern.or(toCountableQualifier) : toCountableQualifier[0])).andOptionally(possiblyUncountable.andNot(noSuggestUncountable).andNot(Semantics.uncountableOnlyWhenPlural).andNot(NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", CommonPatterns.possiblySkipDown("cop|aux|aux:pass", NodePattern.custom(cop -> Number.verbNumber(cop) == Number.plural)))).andNot(EnglishTreePatterns.typeSynonyms).correct(NodeCorrector.inflect("NN")));
    }

    private static NodePattern noThis() {
        return NodePattern.N.form("no").includeIntoReport().directlyBefore(NodePattern.N.form("this|these").includeIntoReport().directlyBeforeHead().withHead("det", NodePattern.not(SubjectVerbAgreement.errorPattern).markAs("Noun")).message("'$_' doesn\u2019t seem to fit after 'no'").correct(NodeCorrector.replace("such"))).andOptionally(NodePattern.markedNodeMatches("Noun", NodePattern.N.pos("NNS")).correct(NodeCorrector.replace("none of"))).andOptionally(NodePattern.markedNodeMatches("Noun", NodePattern.N.withDependent("cop").noDependents("nsubj|expl", NodePattern.N.form("there"))).correct(NodeCorrector.replace("not"))).andOptionally(NodePattern.N.withNeighbor(-2, NodePattern.N.form("there").markAs("Start")).andOr(NodePattern.N.inFormSequence(2, "there", "['\u2019`\u2018i]s", "no", "this").correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.phraseEnd(NodePointer.marked("Noun")), m -> List.of("this " + m.getMarkedNode("Noun").form() + " does not exist"))), NodePattern.N.inFormSequence(2, "there", "are", "no", "these").correct(NodeCorrector.replaceNodes(NodePointer.marked("Start"), NodePointer.phraseEnd(NodePointer.marked("Noun")), m -> List.of("these " + m.getMarkedNode("Noun").form() + " do not exist"))))).andOptionally(CommonPatterns.firstWord.correct(NodeCorrector.insertAfter(",")));
    }

    private static List<NodeCorrector> joinCorrectors(NodeCorrector first, List<NodeCorrector> second) {
        return second.isEmpty() ? List.of(first) : StreamEx.of(second).map(c -> first.join((NodeCorrector)c)).toList();
    }

    private static NodePattern eachPlural() {
        NodePattern possessiveWithMisattachedQuantifier = NodePattern.N.withHead("nmod:poss", NodePattern.N.pos("NN")).withDependent("case", NodePattern.N.afterHead());
        NodePattern plural = QuantifierNounCompatibility.plural.noDependents("nummod|cop|aux|aux:pass").noDependents("compound", NodePattern.N.noPos()).noDependents("case", NodePattern.N.after("Det").beforeHead()).noDependents("amod", NodePattern.N.form("few|several"));
        return AgreementSet.sgRequiringDet.markAs("Det").includeIntoReport().andNot(NodePattern.N.inFormSequence(0, "each", "others?")).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE.noSpaceAfter())).withHead("det|cc:preconj", plural.andNot(possessiveWithMisattachedQuantifier)).and((node, match) -> {
            Node cc;
            String pair;
            String string = node.hasForm("either") ? "or" : (pair = node.hasForm("neither") ? "nor" : null);
            if (pair != null && node.forward().anyMatch(n -> n.hasForm(pair))) {
                return null;
            }
            Node head = Objects.requireNonNull(node.head());
            List<Node> conj = head.findDependents("conj");
            if (pair != null && conj.size() == 1 && (cc = conj.getFirst().findSingleDependent("cc")) != null && cc.hasForm("and")) {
                match = match.withCorrector(NodeCorrector.replace(cc, pair)).withReportedNode(cc);
            }
            if (!pluralRequiringGroup.matches(head.head()) && !head.hasDependent("conj")) {
                match = new AgreementSet(head, Number.singular).changeNumber(match);
            }
            return match.withReportedNode(head).withMessage("Use singular nouns after '" + node.form() + "'");
        }).and(NodePattern.or(NodePattern.N.form("neither").correct(NodeCorrector.replace("none of the")), NodePattern.N.form("another").correct(NodeCorrector.replace("other")), NodePattern.N.correct(NodeCorrector.replace("all"))));
    }

    private static NodePattern numBillions() {
        return NodePattern.N.form("dozens|hundreds|thousands|[bmz]illions").markAs("Noun").and(NodePattern.or(NodePattern.N.withDependent("nummod", NodePattern.N.before("Noun")), NodePattern.N.withHead("compound", NodePattern.N.withDependent("nummod", NodePattern.N.before("Noun"))), NodePattern.N.withDependent("compound", EnglishTreePatterns.number))).and((node, match) -> {
            Node next = node.nextNode();
            String singular = node.form().substring(0, node.form().length() - 1);
            Node end = next != null && next.hasForm("of") ? next : node;
            return match.withCorrector(NodeCorrector.replaceNodes(node, end, singular)).withMessage("Use singular '" + singular + "' after numbers");
        });
    }

    private static NodePattern oneThisThese() {
        NodePattern suchAsX = NodePattern.N.directlyAfter(NodePattern.N.form("as")).withHead(NodePattern.N.withHead("nmod", NodePattern.N.withDependent("amod", NodePattern.N.form("such"))));
        return NodePattern.or(NodePattern.N.form("this|that").withHead("det|nummod", NodePattern.or(plural, NodePattern.N.form("sports|physics|maths|arts|mechanics|materials|robotics")).andNot(NodePattern.ROOT.potentialPos("VBZ")).noDependents("cc", NodePattern.not(CommonPatterns.firstChildPhrase)).noHeadRelation("nmod:tmod")).noDependents("conj").andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("so"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("many|much"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("det"))).andNot(suchAsX).andNot(NodePattern.N.form("that").withHead("det", NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("ccomp"))))).andOr(NodePattern.N.withHead("det", NodePattern.N.withDependent("cop", NodePattern.N.pos("VBP"))).message("Don\u2019t use '$_' with plural nouns").and(QuantifierNounCompatibility::toPlural), NodePattern.custom((node, match) -> QuantifierNounCompatibility.fixAgreement(node, match, Number.singular))), NodePattern.N.form("one|0*1").beforeHead().markAs("One").withHead("nummod", plural.noDependents("compound").noDependents("nummod", NodePattern.N.after("One")).noDependents("amod", NodePattern.N.withDependent("conj")).andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT)).noLemma("one")).noDependents("nmod|conj|compound|nummod|fixed").noDependents(NodePattern.N.afterHead()).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cc"))).andNot(NodePattern.N.inFormSequence(2, "all", "in", "one")).andNot(NodePattern.N.inFormSequence(0, "1", "bits|\\+")).andNot(inBraces).andNot(NodePattern.N.form("one").withHead(NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("conj")))).and((one, match) -> QuantifierNounCompatibility.fixAgreement(one, match, Number.singular)).andOptionally(NodePattern.N.withHead(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?")).correct(NodeCorrector.replace("some"))).andOptionally(NodePattern.N.form("one").withHead(NodePattern.N.withDependent("det|nmod:poss")).correct(NodeCorrector.insertAfter(" of"))).andOr(CommonPatterns.afterSkipping(NodePattern.N.form("="), NodePattern.N.form("[<>]")), NodePattern.N.correct(NodeCorrector.replace(""))), NodePattern.N.form("these|those").withHead("det", definitelySg.noPos("CD|VBG").noForm("manis").andNot(NodePattern.N.potentialPos("VBP").andOr(NodePattern.N.withHeadRelation("ccomp"), NodePattern.N.withHead("obj", NodePattern.N.lemma("hope|make")))).noDependents("amod").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("and")).withDependent("conj")).noDependents("compound", NodePattern.N.pos("JJ")).andNot(EnglishTreePatterns.objOnNonVerb).andNot(SubjectVerbAgreement.hasClauseCompoundAmbiguity)).andNot(suchAsX).and((node, match) -> QuantifierNounCompatibility.fixAgreement(node, match, Number.plural))).andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("nmod:poss|compound|obl:.*").beforeHead())).trace("oneThisThese");
    }

    private static NodeMatch fixAgreement(Node spec, NodeMatch match, Number primary) {
        Node noun = spec.head();
        Number secondary = primary == Number.singular ? Number.plural : Number.singular;
        return match.withReportedNodes(spec, noun).withMessage("Use " + String.valueOf((Object)primary) + " nouns after '" + spec.form() + "'").withCorrectors((List)new AgreementSet(noun, primary).changeNumber().getLeft()).withCorrectors((List)new AgreementSet(noun, secondary).changeNumber().getLeft());
    }

    private static NodePattern otherSingular() {
        NodePattern orOther = NodePattern.N.directlyAfter(NodePattern.N.form("or")).withHead("amod", NodePattern.N.withHead("conj", NodePattern.N.pos("NN.*").andOr(NodePattern.not(CommonPatterns.skipUp("nmod", NodePattern.ROOT.pos("NN.*"))), NodePattern.ROOT.withDependent("nmod:poss", NodePattern.N.withDependent("conj", NodePattern.N.withPhraseStart(NodePattern.N.form("or|/")))))));
        NodePattern uncountable = possiblyUncountable.andNot(noSuggestUncountable);
        return definitelySg.andOr(NodePattern.not(uncountable), NodePattern.N.form("reason")).includeIntoReport().andNot(CommonPatterns.possiblySkipDown("amod", NodePattern.N.withDependent("det|nmod:poss|nummod"))).noDependents("compound", plural).andNot(misparsedCompoundConjStart).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHead("amod|compound", NodePattern.N.pos("NNS")))).markAs("Head").withDependent("amod", NodePattern.N.form("other").includeIntoReport().andNot(NodePattern.N.directlyBefore(NodePattern.N.form("than|-"))).andNot(orOther).noMatchUntil("Head", CommonPatterns.parenthesis).andOr(NodePattern.N.directlyAfterHead().withHead(EnglishTreePatterns.someAnyEveryNoX.message("Did you mean '$_ else'?")).correct(NodeCorrector.replace("else")), NodePattern.N.beforeHead().and((node, match) -> {
            Node head = Objects.requireNonNull(node.head());
            List toSgAround = (List)new AgreementSet(head, Number.singular).changeNumber().getLeft();
            ArrayList<NodeCorrector> correctors = new ArrayList<NodeCorrector>(QuantifierNounCompatibility.joinCorrectors(NodeCorrector.replace(node, "another"), toSgAround));
            NodeMatch withThe = Articles.forceThe().match(head);
            if (withThe != null) {
                for (NodeCorrector corrector : withThe.correctors()) {
                    correctors.addAll(QuantifierNounCompatibility.joinCorrectors(corrector, toSgAround));
                }
            }
            return match.withCorrectors(correctors);
        }).withHead(NodePattern.or(CommonPatterns.skipUp("nsubj", NodePattern.N.withDependent("cop", NodePattern.N.pos("VBZ"))), NodePattern.custom(QuantifierNounCompatibility::toPlural))).message("Use 'another' with singular nouns"))).andNot(NodePattern.N.withHead("conj", NodePattern.N.withHead("compound", NodePattern.or(plural, uncountable))));
    }

    private static NodePattern numSingular() {
        NodePattern numberCompoundAmbiguity = NodePattern.N.withDependent("compound", NodePattern.N.onlyPos("NN").directlyBeforeHead());
        NodePattern missingHyphenBefore = NodePattern.N.form("dozen|hundred|thousand|million|billion|(ga)?zillion").withDependent("compound", NodePattern.N.directlyBeforeHead().pos("CD"));
        NodePattern pluralizationUnlikely = NodePattern.N.form("population").withDependent("nummod", NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion"));
        return definitelySg.noPos("IN").withDependent("nummod", pluralNummod.markAs("Num")).andNot(Semantics.possiblyCountableCollective).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.noSpaceHyphen, CommonPatterns.dot.noSpaceBefore().noSpaceAfter().directlyBefore(CommonPatterns.letterWord)))).noForm("bit|pax|max|sigma|score|free|vol|support|rate|baht|dollar|euro|pound|ruble|ether|bitcoin|rupee|peso|yen|yuan|franc|krone|zloty|forint|koruna|leu|naira|shilling|lira|rupiah|taka|dong|dram|lari|hryvnia|hryvna|dirham|dinar|jan|feb|mar|apr|may|jun|jul|aug|sept|oct|nov|dec|((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])").noLemma("two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen|sixteen|seventeen|eightteen|nineteen|twenty|thirty|fourty|fifty|sixty|seventy|eighty|ninety|dozen|hundred|thousand|million|billion|(ga)?zillion").andNot(EnglishTreePatterns.anyPercent).andNot(NodePattern.N.inFormSequence(0, "year", "old")).andNot(NodePattern.N.inFormSequence(1, "zero", "hour")).andNot(NodePattern.N.inFormSequence(1, "[1-9]|1[0-5]|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|thirteen|fourteen|fifteen", "ball")).andNot(NodePattern.N.inFormSequence(2, "force", "\\d\\d?", "gale")).andNot(NodePattern.N.form("intake|exhaust").noHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound")).andNot(NodePattern.N.beforeHead().withHead("obl:.*", NodePattern.not(NodePattern.N.form("ago")))).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("compound|appos|nmod:poss|ccomp|parataxis"))).noDependents("det", NodePattern.N.form("an?")).noDependents("nummod", NodePattern.N.afterHead()).noDependents("det", NodePattern.N.after("Num")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.inFormSequence(0, "this|that", "is|was")).noDependents("compound", NodePattern.or(NodePattern.N.pos("NN[PS]"), NodePattern.N.form("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])"), NodePattern.N.before("Num"), NodePattern.N.pos("NN").directlyAfter(EnglishTreePatterns.compound))).andNot(NodePattern.N.inFormSequence(0, "walk", "in")).andNot(NodePattern.N.form("version|release|edition|update|publication|plan").noDependents(zero)).andNot(SubjectVerbAgreement.hasClauseCompoundAmbiguity).and(hasPlural).andNot(NodePattern.N.potentialPos("VBP?").withHead("conj", NodePattern.N.pos("VB.*"))).andOr(NodePattern.N.inFormSequence(1, "\\d{1,3}", "year").and(EnglishTreePatterns.typoReplacement("years old")), NodePattern.N.form("percentage").and(EnglishTreePatterns.typoReplacement("percent")), NodePattern.custom((noun, match) -> {
            Node numeral = match.getMarkedNode("Num");
            String num = numeral.form();
            if (noun == numeral.nextNode() && noun.hasHeadRelation("obj|obl|nmod|root") && num.matches("\\d+")) {
                NodeCorrector moveAfter = NodeCorrector.removeNode(numeral).join(NodeCorrector.insertAfter(noun, " " + num));
                NodeCorrector addTh = NodeCorrector.insertAfter(numeral, num.endsWith("1") ? "st" : (num.endsWith("2") ? "nd" : (num.endsWith("3") ? "rd" : "th")));
                match = match.withCorrector(moveAfter).withCorrector(addTh).withReportedNode(numeral);
            }
            if (!pluralizationUnlikely.matches(noun)) {
                match = QuantifierNounCompatibility.toPlural(noun, match);
            }
            if (missingHyphenBefore.matches(numeral)) {
                List toSgAround = (List)new AgreementSet(noun, Number.singular).changeNumber(Set.of(noun)).getLeft();
                match = match.withCorrectors(QuantifierNounCompatibility.joinCorrectors(CommonPatterns.hyphenateNeighbors(numeral.neighbor(-1), numeral), toSgAround));
            }
            if (numberCompoundAmbiguity.matches(noun)) {
                match = QuantifierNounCompatibility.toPlural(noun.neighbor(-1), match);
            }
            return match.withMessage("Use plural nouns after '" + num + "'");
        }));
    }

    private static NodeMatch toPlural(Node node, NodeMatch match) {
        NodeMatch changed = new AgreementSet(node, Number.plural).changeNumber(match);
        if (changed == match && !AgreementSet.onlySgNominal.matches(node)) {
            return match.withCorrector(NodeCorrector.inflect(node, "NN", "NNS"));
        }
        return changed;
    }

    private static NodePattern wrongQuantifier(String nounKind, String replacement) {
        return NodePattern.N.withHead(NodePattern.N.message("Use '" + replacement + "' with " + nounKind + " nouns like '$_'")).correct(NodeCorrector.replace(replacement));
    }
}

