/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonTokenSets;
import com.intellij.json.syntax.JsonSyntaxElementTypes;
import com.intellij.json.syntax.JsonSyntaxLexer;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import org.jetbrains.annotations.NotNull;

public final class JsonNamesValidator
implements NamesValidator {
    private final Lexer myLexer = new JsonSyntaxLexer();

    public synchronized boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            JsonNamesValidator.$$$reportNull$$$0(0);
        }
        this.myLexer.start((CharSequence)name);
        SyntaxElementType tokenType = this.myLexer.getTokenType();
        return tokenType != null && JsonTokenSets.JSON_KEYWORDS.contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    public synchronized boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            JsonNamesValidator.$$$reportNull$$$0(1);
        }
        if (!StringUtil.startsWithChar((CharSequence)name, (char)'\'') && !StringUtil.startsWithChar((CharSequence)name, (char)'\"')) {
            name = "\"" + (String)name;
        }
        if (!StringUtil.endsWithChar((CharSequence)name, (char)'\"') && !StringUtil.endsWithChar((CharSequence)name, (char)'\'')) {
            name = (String)name + "\"";
        }
        this.myLexer.start((CharSequence)name);
        SyntaxElementType type = this.myLexer.getTokenType();
        return this.myLexer.getTokenEnd() == ((String)name).length() && (type == JsonSyntaxElementTypes.DOUBLE_QUOTED_STRING || type == JsonSyntaxElementTypes.SINGLE_QUOTED_STRING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "name";
        objectArray2[1] = "com/intellij/json/JsonNamesValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

