/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.local.tunnels;

import com.intellij.platform.eel.ConfigurableClientSocket;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.channels.EelReceiveChannel;
import com.intellij.platform.eel.channels.EelSendChannel;
import com.intellij.platform.eel.impl.local.tunnels.ConfigurableClientSocketImpl;
import com.intellij.platform.eel.provider.utils.EelChannelUtilsKt;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J7\u0010\u0011\u001a\u00020\u00122'\u0010\u0013\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0014\u00a2\u0006\u0002\b\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001bR\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/eel/impl/local/tunnels/SocketAdapter;", "Lcom/intellij/platform/eel/EelTunnelsApi$Connection;", "channel", "Ljava/nio/channels/SocketChannel;", "<init>", "(Ljava/nio/channels/SocketChannel;)V", "socket", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "sendChannel", "Lcom/intellij/platform/eel/channels/EelSendChannel;", "getSendChannel", "()Lcom/intellij/platform/eel/channels/EelSendChannel;", "receiveChannel", "Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "getReceiveChannel", "()Lcom/intellij/platform/eel/channels/EelReceiveChannel;", "configureSocket", "", "block", "Lkotlin/Function2;", "Lcom/intellij/platform/eel/ConfigurableClientSocket;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.eel.impl"})
public final class SocketAdapter
implements EelTunnelsApi.Connection {
    private final Socket socket;
    @NotNull
    private final EelSendChannel sendChannel;
    @NotNull
    private final EelReceiveChannel receiveChannel;

    public SocketAdapter(@NotNull SocketChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.socket = channel.socket();
        this.sendChannel = EelChannelUtilsKt.asEelChannel((WritableByteChannel)channel);
        this.receiveChannel = EelChannelUtilsKt.consumeAsEelChannel((ReadableByteChannel)channel);
    }

    @NotNull
    public EelSendChannel getSendChannel() {
        return this.sendChannel;
    }

    @NotNull
    public EelReceiveChannel getReceiveChannel() {
        return this.receiveChannel;
    }

    @Nullable
    public Object configureSocket(@NotNull Function2<? super ConfigurableClientSocket, ? super Continuation<? super Unit>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        Socket socket = this.socket;
        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket");
        Object object = block.invoke((Object)new ConfigurableClientSocketImpl(socket), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        if (this.socket.isClosed()) {
            return Unit.INSTANCE;
        }
        if (this.socket.getSoLinger() != 0) {
            this.socket.shutdownOutput();
            this.socket.shutdownInput();
        }
        this.socket.close();
        return Unit.INSTANCE;
    }
}

