/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.plugins.api.MavenSoftAwareReferenceProvider;
import org.jetbrains.idea.reposearch.DependencySearchService;

public class MavenDependencyReferenceProvider
extends PsiReferenceProvider
implements MavenSoftAwareReferenceProvider {
    private boolean mySoft = true;
    private boolean myCanHasVersion = true;

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
        TextRange range;
        String text;
        int firstDelim;
        if (element == null) {
            MavenDependencyReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            MavenDependencyReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((firstDelim = (text = (range = ElementManipulators.getValueTextRange((PsiElement)element)).substring(element.getText())).indexOf(58)) == -1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GroupReference(element, range, this.mySoft)};
            if (psiReferenceArray == null) {
                MavenDependencyReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        int secondDelim = this.myCanHasVersion ? text.indexOf(58, firstDelim + 1) : -1;
        int start = range.getStartOffset();
        if (secondDelim == -1) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GroupReference(element, new TextRange(start, start + firstDelim), this.mySoft), new ArtifactReference(text.substring(0, firstDelim), element, new TextRange(start + firstDelim + 1, range.getEndOffset()), this.mySoft)};
            if (psiReferenceArray == null) {
                MavenDependencyReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        int lastDelim = text.indexOf(58, secondDelim + 1);
        if (lastDelim == -1) {
            lastDelim = text.length();
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new GroupReference(element, new TextRange(start, start + firstDelim), this.mySoft), new ArtifactReference(text.substring(0, firstDelim), element, new TextRange(start + firstDelim + 1, start + secondDelim), this.mySoft), new VersionReference(text.substring(0, firstDelim), text.substring(firstDelim + 1, secondDelim), element, new TextRange(start + secondDelim + 1, start + lastDelim), this.mySoft)};
        if (psiReferenceArray == null) {
            MavenDependencyReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @Override
    public void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isCanHasVersion() {
        return this.myCanHasVersion;
    }

    public void setCanHasVersion(boolean canHasVersion) {
        this.myCanHasVersion = canHasVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class GroupReference
    extends PsiReferenceBase<PsiElement> {
        GroupReference(PsiElement element, TextRange range, boolean soft) {
            super(element, range, soft);
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = DependencySearchService.getInstance((Project)this.getElement().getProject()).getGroupIds("").toArray();
            if (objectArray == null) {
                GroupReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$GroupReference", "getVariants"));
        }
    }

    public static class ArtifactReference
    extends PsiReferenceBase<PsiElement> {
        private final String myGroupId;

        public ArtifactReference(@NotNull String groupId, @NotNull PsiElement element, @NotNull TextRange range, boolean soft) {
            if (groupId == null) {
                ArtifactReference.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ArtifactReference.$$$reportNull$$$0(1);
            }
            if (range == null) {
                ArtifactReference.$$$reportNull$$$0(2);
            }
            super(element, range, soft);
            this.myGroupId = groupId;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        public Object @NotNull [] getVariants() {
            if (StringUtil.isEmptyOrSpaces((String)this.myGroupId)) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    ArtifactReference.$$$reportNull$$$0(3);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            Object[] objectArray = DependencySearchService.getInstance((Project)this.getElement().getProject()).getArtifactIds(this.myGroupId).toArray();
            if (objectArray == null) {
                ArtifactReference.$$$reportNull$$$0(4);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$ArtifactReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$ArtifactReference";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class VersionReference
    extends PsiReferenceBase<PsiElement> {
        private final String myGroupId;
        private final String myArtifactId;

        public VersionReference(@NotNull String groupId, @NotNull String artifactId, @NotNull PsiElement element, @NotNull TextRange range, boolean soft) {
            if (groupId == null) {
                VersionReference.$$$reportNull$$$0(0);
            }
            if (artifactId == null) {
                VersionReference.$$$reportNull$$$0(1);
            }
            if (element == null) {
                VersionReference.$$$reportNull$$$0(2);
            }
            if (range == null) {
                VersionReference.$$$reportNull$$$0(3);
            }
            super(element, range, soft);
            this.myGroupId = groupId;
            this.myArtifactId = artifactId;
        }

        @Nullable
        public PsiElement resolve() {
            return null;
        }

        public Object @NotNull [] getVariants() {
            if (StringUtil.isEmptyOrSpaces((String)this.myGroupId) || StringUtil.isEmptyOrSpaces((String)this.myArtifactId)) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    VersionReference.$$$reportNull$$$0(4);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            Object[] objectArray = DependencySearchService.getInstance((Project)this.getElement().getProject()).getVersions(this.myGroupId, this.myArtifactId).toArray();
            if (objectArray == null) {
                VersionReference.$$$reportNull$$$0(5);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenDependencyReferenceProvider$VersionReference";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

