/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

final class ShSemanticEditorPosition {
    private final HighlighterIterator myIterator;

    private ShSemanticEditorPosition(@NotNull Editor editor, int offset) {
        if (editor == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(0);
        }
        this.myIterator = editor.getHighlighter().createIterator(offset);
    }

    void moveBefore() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
    }

    void moveBeforeOptionalMix(IElementType ... elements) {
        if (elements == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(1);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
    }

    void moveAfterOptionalMix(IElementType ... elements) {
        if (elements == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(2);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
    }

    boolean isAtAnyOf(IElementType ... syntaxElements) {
        if (syntaxElements == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(3);
        }
        if (!this.myIterator.atEnd()) {
            IElementType currElement = this.myIterator.getTokenType();
            for (IElementType element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAt(@NotNull IElementType elementType) {
        if (elementType == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(4);
        }
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    int getStartOffset() {
        return !this.myIterator.atEnd() ? this.myIterator.getStart() : -1;
    }

    @NotNull
    static ShSemanticEditorPosition createEditorPosition(@NotNull Editor editor, int offset) {
        if (editor == null) {
            ShSemanticEditorPosition.$$$reportNull$$$0(5);
        }
        return new ShSemanticEditorPosition(editor, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/formatter/ShSemanticEditorPosition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeOptionalMix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "moveAfterOptionalMix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtAnyOf";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAt";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditorPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

