/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleFileType;
import org.jetbrains.plugins.gradle.service.completion.GradleCompletionConsumer;
import org.jetbrains.plugins.gradle.service.completion.GradleLookupWeigher;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.completion.api.GroovyCompletionConsumer;
import org.jetbrains.plugins.groovy.lang.completion.api.GroovyCompletionCustomizer;
import org.jetbrains.plugins.groovy.lang.completion.impl.AccumulatingGroovyCompletionConsumer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/completion/GradleCompletionCustomizer;", "Lorg/jetbrains/plugins/groovy/lang/completion/api/GroovyCompletionCustomizer;", "<init>", "()V", "customizeCompletionConsumer", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "completionParameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "resultSet", "generateCompletionConsumer", "Lorg/jetbrains/plugins/groovy/lang/completion/api/GroovyCompletionConsumer;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.gradle.java"})
public final class GradleCompletionCustomizer
implements GroovyCompletionCustomizer {
    @NotNull
    public CompletionResultSet customizeCompletionConsumer(@NotNull CompletionParameters completionParameters, @NotNull CompletionResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)completionParameters, (String)"completionParameters");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        if (Intrinsics.areEqual((Object)completionParameters.getOriginalFile().getFileType(), (Object)((Object)GradleFileType.INSTANCE)) || Intrinsics.areEqual((Object)completionParameters.getOriginalFile().getFileType(), (Object)GroovyFileType.GROOVY_FILE_TYPE) && Intrinsics.areEqual((Object)completionParameters.getOriginalFile().getVirtualFile().getExtension(), (Object)"gradle")) {
            CompletionSorter completionSorter = CompletionSorter.defaultSorter((CompletionParameters)completionParameters, (PrefixMatcher)resultSet.getPrefixMatcher());
            Intrinsics.checkNotNullExpressionValue((Object)completionSorter, (String)"defaultSorter(...)");
            CompletionSorter sorter = completionSorter;
            LookupElementWeigher[] lookupElementWeigherArray = new LookupElementWeigher[]{new GradleLookupWeigher()};
            CompletionResultSet completionResultSet = resultSet.withRelevanceSorter(sorter.weighBefore("priority", lookupElementWeigherArray));
            Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withRelevanceSorter(...)");
            return completionResultSet;
        }
        return resultSet;
    }

    @Nullable
    public GroovyCompletionConsumer generateCompletionConsumer(@NotNull PsiElement element, @NotNull CompletionResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        PsiFile file = element.getContainingFile();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)"gradle", (boolean)false, (int)2, null)) {
            return new GradleCompletionConsumer(element, (GroovyCompletionConsumer)new AccumulatingGroovyCompletionConsumer(resultSet));
        }
        return null;
    }
}

