/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;

public interface ChangeListGroupingStrategy {
    public static final ChangeListGroupingStrategy USER = new ChangeListGroupingStrategy(){

        @Override
        public String toString() {
            return VcsBundle.message((String)"user.group.title", (Object[])new Object[0]);
        }

        @Override
        public String getGroupName(CommittedChangeList changeList) {
            return changeList.getCommitterName();
        }

        @Override
        public void beforeStart() {
        }

        @Override
        public boolean changedSinceApply() {
            return false;
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return (o1, o2) -> {
                int rc = o1.getCommitterName().compareToIgnoreCase(o2.getCommitterName());
                if (rc == 0) {
                    return -o1.getCommitDate().compareTo(o2.getCommitDate());
                }
                return rc;
            };
        }
    };

    public void beforeStart();

    public boolean changedSinceApply();

    @Nls
    public String getGroupName(CommittedChangeList var1);

    public Comparator<CommittedChangeList> getComparator();

    @Nls
    public String toString();
}

