/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a)\u0010\u0000\u001a\u00020\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0007\"H\u0010\b\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00040\tj\u0002`\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"sum", "", "Lkotlin/sequences/Sequence;", "type", "Lkotlin/reflect/KType;", "skipNaN", "", "sumNullableT", "sumTypeConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnType;", "getSumTypeConversion", "()Lkotlin/jvm/functions/Function2;", "core"})
public final class SumKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> sumTypeConversion = SumKt::sumTypeConversion$lambda$0;

    @JvmName(name="sumNullableT")
    @PublishedApi
    @NotNull
    public static final Number sumNullableT(@NotNull Sequence<? extends Number> $this$sum, @NotNull KType type, boolean skipNaN) {
        Number number;
        Intrinsics.checkNotNullParameter($this$sum, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isMarkedNullable()) {
            throw new IllegalStateException(("Encountered nullable type " + RenderingKt.renderType(type) + " in sum function. This should not occur.").toString());
        }
        KType kType = type;
        if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Double.TYPE))) {
            number = SequencesKt.sumOfDouble((Sequence)SequencesKt.filterNot($this$sum, arg_0 -> SumKt.sum$lambda$0(skipNaN, arg_0)));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Float.TYPE))) {
            number = Float.valueOf(SequencesKt.sumOfFloat((Sequence)SequencesKt.filterNot($this$sum, arg_0 -> SumKt.sum$lambda$1(skipNaN, arg_0))));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Integer.TYPE))) {
            number = SequencesKt.sumOfInt($this$sum);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Short.TYPE))) {
            number = SequencesKt.sumOfShort($this$sum);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Byte.TYPE))) {
            number = SequencesKt.sumOfByte($this$sum);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE))) {
            number = SequencesKt.sumOfLong($this$sum);
        } else {
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigInteger.class)) || Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigDecimal.class))) {
                throw new IllegalArgumentException("Cannot calculate the sum for big numbers in DataFrame. Only primitive numbers are supported.");
            }
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Number.class))) {
                throw new IllegalStateException("Encountered non-specific Number type in sum function. This should not occur.".toString());
            }
            if (Intrinsics.areEqual((Object)kType, (Object)TypeUtilsKt.getNothingType())) {
                number = 0.0;
            } else {
                throw new IllegalArgumentException("Unable to compute the sum for " + RenderingKt.renderType(type) + ", Only primitive numbers are supported.");
            }
        }
        return number;
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getSumTypeConversion() {
        return sumTypeConversion;
    }

    private static final boolean sum$lambda$0(boolean $skipNaN, double it) {
        return $skipNaN && Double.isNaN(it);
    }

    private static final boolean sum$lambda$1(boolean $skipNaN, float it) {
        return $skipNaN && Float.isNaN(it);
    }

    private static final KType sumTypeConversion$lambda$0(KType type, boolean bl) {
        KType kType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KType type2 = KTypes.withNullability((KType)type, (boolean)false);
        if (Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Short.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Byte.TYPE))) {
            kType = Reflection.typeOf(Integer.TYPE);
        } else if (Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Integer.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Long.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Double.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Float.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Number.class))) {
            kType = type2;
        } else if (Intrinsics.areEqual((Object)type2, (Object)TypeUtilsKt.getNothingType())) {
            kType = Reflection.typeOf(Double.TYPE);
        } else {
            throw new IllegalStateException(("Unable to compute the sum for " + RenderingKt.renderType(type2) + ", Only primitive numbers are supported.").toString());
        }
        return kType;
    }
}

