/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isJvmInterface(@Nullable DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type) {
        return JvmCodegenUtil.isJvmInterface(type.getConstructor().getDeclarationDescriptor());
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor) {
        ClassDescriptor expectedThisClass;
        ReceiverParameterDescriptor dispatchReceiver;
        if (descriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(0);
        }
        if ((dispatchReceiver = descriptor.getDispatchReceiverParameter()) != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module2) {
        Name stableName = module2.getStableName();
        if (stableName == null) {
            return JvmCodegenUtil.prepareModuleName(module2.getName());
        }
        return JvmCodegenUtil.prepareModuleName(stableName);
    }

    @NotNull
    public static String prepareModuleName(@NotNull Name name) {
        if (name == null) {
            JvmCodegenUtil.$$$reportNull$$$0(1);
        }
        String string = StringsKt.removeSurrounding((String)name.asString(), (CharSequence)"<", (CharSequence)">");
        if (string == null) {
            JvmCodegenUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getMappingFileName(@NotNull String moduleName) {
        if (moduleName == null) {
            JvmCodegenUtil.$$$reportNull$$$0(3);
        }
        String string = "META-INF/" + moduleName + "." + "kotlin_module";
        if (string == null) {
            JvmCodegenUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isDeclarationOfBigArityFunctionInvoke(@Nullable DeclarationDescriptor descriptor) {
        return descriptor instanceof FunctionInvokeDescriptor && ((FunctionInvokeDescriptor)descriptor).hasBigArity();
    }

    public static boolean isDeclarationOfBigArityCreateCoroutineMethod(@Nullable DeclarationDescriptor descriptor) {
        return descriptor instanceof SimpleFunctionDescriptor && descriptor.getName().asString().equals("create") && ((SimpleFunctionDescriptor)descriptor).getValueParameters().size() >= 22 && descriptor.getContainingDeclaration() instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)descriptor.getContainingDeclaration()).isSuspend();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterForConstructorCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareModuleName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

