/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.highlighting.beforeResolve;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinHighlighterAttributeUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.idea.highlighter.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J#\u0010\u001a\u001a\u00020\b\"\f\b\u0000\u0010\u001b*\u00020\u001c*\u00020\u001d2\u0006\u0010\f\u001a\u0002H\u001bH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/base/highlighting/beforeResolve/DeclarationHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/visitor/AbstractHighlightingVisitor;", "Lcom/intellij/openapi/project/DumbAware;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "<init>", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "visitTypeAlias", "", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitDestructuringDeclaration", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "highlightMutability", "D", "Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;)V", "kotlin.highlighting.shared"})
public final class DeclarationHighlightingVisitor
extends AbstractHighlightingVisitor
implements DumbAware {
    public DeclarationHighlightingVisitor(@NotNull HighlightInfoHolder holder2) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        super(holder2);
    }

    public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        this.highlightNamedDeclaration((KtNamedDeclaration)typeAlias, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_ALIAS());
        super.visitTypeAlias(typeAlias);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isData()) {
            this.highlightNamedDeclaration((KtNamedDeclaration)declaration, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getDATA_OBJECT());
        } else {
            this.highlightNamedDeclaration((KtNamedDeclaration)declaration, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getOBJECT());
        }
        super.visitObjectDeclaration(declaration);
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.highlightNamedDeclaration((KtNamedDeclaration)klass, KotlinHighlighterAttributeUtils.textAttributesForClass(klass));
        super.visitClass(klass);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.highlightNamedDeclaration((KtNamedDeclaration)property, KotlinHighlighterAttributeUtils.textAttributesForKtPropertyDeclaration(property));
        this.highlightMutability((KtValVarKeywordOwner)property);
        super.visitProperty(property);
    }

    public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
        Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
        boolean isVar = destructuringDeclaration.isVar();
        for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
            AbstractHighlightingVisitor abstractHighlightingVisitor = this;
            Intrinsics.checkNotNull((Object)entry);
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)abstractHighlightingVisitor, (PsiElement)((PsiElement)entry), (HighlightInfoType)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getLOCAL_VARIABLE(), null, (int)4, null);
            if (!isVar) continue;
            AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, (PsiElement)((PsiElement)entry), (HighlightInfoType)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getMUTABLE_VARIABLE(), null, (int)4, null);
        }
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        this.highlightNamedDeclaration((KtNamedDeclaration)parameter, KotlinHighlighterAttributeUtils.textAttributesForKtParameterDeclaration(parameter));
        this.highlightMutability((KtValVarKeywordOwner)parameter);
        super.visitParameter(parameter);
    }

    private final <D extends KtValVarKeywordOwner & KtNamedDeclaration> void highlightMutability(D declaration) {
        if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)declaration.getValOrVarKeyword()), (Object)KtTokens.VAR_KEYWORD)) {
            this.highlightNamedDeclaration(declaration, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getMUTABLE_VARIABLE());
        }
    }
}

