#
# Copyright (C) 2017 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to iterative over data columns.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.ALL)

# There are two methods of acquiring column data, three functions are given
# here (1) and old method (2) a new method (3) an helper function that compares
# the results of both to ensure consistency.
def test_get_col_desc_old_way(data):

    print("START test_get_column_descriptions_old_way_of_getting")
    try:
        for name, description in data.get_column_descriptions().items():
            print("{:_<45}: {}".format(name, description))
    except:
        print("FAIL. test_get_column_descriptions_old_way_of_getting" + "\n")

        return False
    return True


def test_get_col_desc_new_way(data):

    print("\n" + "START test_get_column_description_new_way_of_getting")
    try:
        for row in data.bottomup:
            for col in row:
                print("{:.<45}: {}".format(col, row.get_description(col)))
            break
    except:
        print("FAIL. test_get_column_description_new_way_of_getting" + "\n")

        return False
    return True


def test_old_new_equivalent(data):

    """
    This test checks that new getter does not miss any column's description.
    """

    print("\n" + "START test_new_getter_col_desc_equivalent_old_getter")
    old_getter_result = data.get_column_descriptions()
    hashset_for_test = dict.fromkeys(old_getter_result.keys(), False)
    count_not_match = 1
    count_not_find = 1

    all_datasets = [data.bottomup, data.topdown, data.map]
    for dataset in all_datasets:
        for row in dataset:
            for col in row:
                if col in old_getter_result and row.get_description(col) == old_getter_result[col]:
                    hashset_for_test[col] = True
                else:
                    if not col in old_getter_result:
                        print("Didn't find : {}".format(col))
                        count_not_find += 1
                    elif row.get_description(col) != old_getter_result[col]:
                        print("Didn't match : {}".format(col))
                        count_not_match += 1

            # Because for all rows, columns are the same.
            break

        print("Results of this test:")
        print(
            "Count of all columns {:6} Count of didn't find {:6} Count of didn't match {:6}".format(
                len(old_getter_result.keys()), count_not_find, count_not_match
            )
        )

    return all(hashset_for_test)


if __name__ == "__main__":

    num_of_tests = 3
    failed_tests = []

    if not test_get_col_desc_old_way(data):
        failed_tests.append("test_get_column_descriptions_old_way_of_getting")
    elif not test_get_col_desc_new_way(data):
        failed_tests.append("test_get_column_description_new_way_of_getting")
    elif not test_old_new_equivalent(data):
        failed_tests.append("test_old_new_equivalent")

    if failed_tests:
        print("Failed Tests:")
        for each in failed_tests:
            print(each)
