import { type Writable } from 'node:stream';
import { type StyledChar } from '@alcalzone/ansi-tokenize';
export type CursorPosition = {
    row: number;
    col: number;
};
/**
 * Position terminal cursor for IME support.
 * Calculates relative distance from the end of output to the cursor position.
 */
export declare function positionImeCursor(lineCount: number, cursorPosition: CursorPosition): string;
export type LogUpdate = {
    clear: () => void;
    done: () => void;
    sync: (str: string, cursorPosition?: CursorPosition) => void;
    (str: string, styledOutput: StyledChar[][], debugRainbowColor?: string, cursorPosition?: CursorPosition): void;
};
declare const logUpdate: {
    create: (stream: Writable, { showCursor, alternateBuffer, alternateBufferAlreadyActive, incremental, getRows, getColumns, }?: {
        showCursor?: boolean;
        alternateBuffer?: boolean;
        alternateBufferAlreadyActive?: boolean;
        incremental?: boolean;
        getRows?: () => number;
        getColumns?: () => number;
    }) => LogUpdate;
};
export default logUpdate;
