﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/awstransfer/Transfer_EXPORTS.h>
#include <aws/awstransfer/model/ListedExecution.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Transfer {
namespace Model {
class ListExecutionsResult {
 public:
  AWS_TRANSFER_API ListExecutionsResult() = default;
  AWS_TRANSFER_API ListExecutionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_TRANSFER_API ListExecutionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> <code>ListExecutions</code> returns the <code>NextToken</code> parameter in
   * the output. You can then pass the <code>NextToken</code> parameter in a
   * subsequent command to continue listing additional executions.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListExecutionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier for the workflow.</p>
   */
  inline const Aws::String& GetWorkflowId() const { return m_workflowId; }
  template <typename WorkflowIdT = Aws::String>
  void SetWorkflowId(WorkflowIdT&& value) {
    m_workflowIdHasBeenSet = true;
    m_workflowId = std::forward<WorkflowIdT>(value);
  }
  template <typename WorkflowIdT = Aws::String>
  ListExecutionsResult& WithWorkflowId(WorkflowIdT&& value) {
    SetWorkflowId(std::forward<WorkflowIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Returns the details for each execution, in a <code>ListedExecution</code>
   * array.</p>
   */
  inline const Aws::Vector<ListedExecution>& GetExecutions() const { return m_executions; }
  template <typename ExecutionsT = Aws::Vector<ListedExecution>>
  void SetExecutions(ExecutionsT&& value) {
    m_executionsHasBeenSet = true;
    m_executions = std::forward<ExecutionsT>(value);
  }
  template <typename ExecutionsT = Aws::Vector<ListedExecution>>
  ListExecutionsResult& WithExecutions(ExecutionsT&& value) {
    SetExecutions(std::forward<ExecutionsT>(value));
    return *this;
  }
  template <typename ExecutionsT = ListedExecution>
  ListExecutionsResult& AddExecutions(ExecutionsT&& value) {
    m_executionsHasBeenSet = true;
    m_executions.emplace_back(std::forward<ExecutionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListExecutionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_workflowId;
  bool m_workflowIdHasBeenSet = false;

  Aws::Vector<ListedExecution> m_executions;
  bool m_executionsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Transfer
}  // namespace Aws
