from __future__ import (absolute_import, division, print_function)
# Copyright (c) 2022 Fortinet
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

__metaclass__ = type

import json


SCHEMA_DATA = '''
{
    "adom_options": {
        "stated": false,
        "options": {
            "assign_excluded": {"choices": ["disable", "enable"], "type": "str"},
            "specify_assign_pkg_list": {"choices": ["disable", "enable"], "type": "str"},
            "assign_name": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "str"}
        }
    },
    "antivirus_mmschecksum": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "entries": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "options": {
                    "checksum": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "name": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "int"},
            "name": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"}
        }
    },
    "antivirus_mmschecksum_entries": {
        "stated": true,
        "options": {
            "checksum": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "name": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "str"},
            "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "antivirus_notification": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "entries": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "prefix": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "int"},
            "name": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"}
        }
    },
    "antivirus_notification_entries": {
        "stated": true,
        "options": {
            "name": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "str"},
            "prefix": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "antivirus_profile": {
        "stated": true,
        "options": {
            "analytics-bl-filetype": {"type": "str"},
            "analytics-db": {"choices": ["disable", "enable"], "type": "str"},
            "analytics-max-upload": {"type": "int"},
            "analytics-wl-filetype": {"type": "str"},
            "av-block-log": {"choices": ["disable", "enable"], "type": "str"},
            "av-virus-log": {"choices": ["disable", "enable"], "type": "str"},
            "comment": {"type": "str"},
            "extended-log": {"choices": ["disable", "enable"], "type": "str"},
            "ftgd-analytics": {"choices": ["disable", "suspicious", "everything"], "type": "str"},
            "inspection-mode": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["proxy", "flow-based"], "type": "str"},
            "mobile-malware-db": {"choices": ["disable", "enable"], "type": "str"},
            "name": {"required": true, "type": "str"},
            "replacemsg-group": {"type": "str"},
            "scan-mode": {"choices": ["quick", "full", "legacy", "default"], "type": "str"},
            "feature-set": {"v_range": [["6.4.0", ""]], "choices": ["proxy", "flow"], "type": "str"},
            "cifs": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "quarantine", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "content-disarm": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "cover-page": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "detect-only": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "error-action": {"v_range": [["6.4.5", ""]], "choices": ["block", "log-only", "ignore"], "type": "str"},
                    "office-action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "office-dde": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "office-embed": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "office-hylink": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "office-linked": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "office-macro": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "original-file-destination": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["fortisandbox", "quarantine", "discard"],
                        "type": "str"
                    },
                    "pdf-act-form": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-act-gotor": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-act-java": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-act-launch": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-act-movie": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-act-sound": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-embedfile": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-hyperlink": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdf-javacode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "analytics-suspicious": {"v_range": [["7.4.7", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "ftp": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "http": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor", "strict-file"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-optimize": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "unknown-content-encoding": {
                        "v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]],
                        "choices": ["block", "inspect", "bypass"],
                        "type": "str"
                    },
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "imap": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "executables": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["default", "virus"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "mapi": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "executables": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["default", "virus"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "quarantine", "avquery", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "nac-quar": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "expiry": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                    "infected": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["none", "quar-src-ip", "quar-interface"], "type": "str"},
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "nntp": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "outbreak-prevention": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "external-blocklist": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ftgd-service": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "pop3": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "executables": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["default", "virus"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "smtp": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "content-disarm": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "executables": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["default", "virus"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "ssh": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["avmonitor", "quarantine", "scan"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                        "type": "str"
                    },
                    "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
                    "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
                    "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
                }
            },
            "smb": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]],
                "type": "dict",
                "options": {
                    "archive-block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "archive-log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]],
                        "type": "list",
                        "choices": [
                            "encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"
                        ],
                        "elements": "str"
                    },
                    "emulator": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]],
                        "type": "list",
                        "choices": ["scan", "quarantine", "avquery", "avmonitor"],
                        "elements": "str"
                    },
                    "outbreak-prevention": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]],
                        "choices": ["disabled", "files", "full-archive"],
                        "type": "str"
                    }
                }
            },
            "analytics-accept-filetype": {"v_range": [["7.0.0", ""]], "type": "str"},
            "analytics-ignore-filetype": {"v_range": [["7.0.0", ""]], "type": "str"},
            "ems-threat-feed": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "external-blocklist-archive-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-blocklist-enable-all": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "outbreak-prevention-archive-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr-error-action": {"v_range": [["7.0.5", ""]], "choices": ["log-only", "block", "ignore"], "type": "str"},
            "fortindr-timeout-action": {"v_range": [["7.0.5", ""]], "choices": ["log-only", "block", "ignore"], "type": "str"},
            "fortisandbox-error-action": {"v_range": [["7.2.0", ""]], "choices": ["log-only", "block", "ignore"], "type": "str"},
            "fortisandbox-max-upload": {"v_range": [["7.2.0", ""]], "type": "int"},
            "fortisandbox-mode": {"v_range": [["7.2.0", ""]], "choices": ["inline", "analytics-suspicious", "analytics-everything"], "type": "str"},
            "fortisandbox-timeout-action": {"v_range": [["7.2.0", ""]], "choices": ["log-only", "block", "ignore"], "type": "str"},
            "fortiai-error-action": {"v_range": [["7.0.1", ""]], "choices": ["block", "log-only", "ignore"], "type": "str"},
            "fortiai-timeout-action": {"v_range": [["7.0.2", ""]], "choices": ["block", "log-only", "ignore"], "type": "str"}
        }
    },
    "antivirus_profile_cifs": {
        "stated": false,
        "options": {
            "archive-block": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "emulator": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "options": {"v_range": [["6.2.0", ""]], "type": "list", "choices": ["scan", "quarantine", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {
                "v_range": [["6.2.0", ""]],
                "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                "type": "str"
            },
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_contentdisarm": {
        "stated": false,
        "options": {
            "cover-page": {"choices": ["disable", "enable"], "type": "str"},
            "detect-only": {"choices": ["disable", "enable"], "type": "str"},
            "office-embed": {"choices": ["disable", "enable"], "type": "str"},
            "office-hylink": {"choices": ["disable", "enable"], "type": "str"},
            "office-linked": {"choices": ["disable", "enable"], "type": "str"},
            "office-macro": {"choices": ["disable", "enable"], "type": "str"},
            "original-file-destination": {"choices": ["fortisandbox", "quarantine", "discard"], "type": "str"},
            "pdf-act-form": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-act-gotor": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-act-java": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-act-launch": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-act-movie": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-act-sound": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-embedfile": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-hyperlink": {"choices": ["disable", "enable"], "type": "str"},
            "pdf-javacode": {"choices": ["disable", "enable"], "type": "str"},
            "office-action": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "office-dde": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "error-action": {"v_range": [["6.4.2", ""]], "choices": ["block", "log-only", "ignore"], "type": "str"},
            "analytics-suspicious": {"v_range": [["7.4.7", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "antivirus_profile_ftp": {
        "stated": false,
        "options": {
            "archive-block": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "emulator": {"choices": ["disable", "enable"], "type": "str"},
            "options": {"type": "list", "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {"choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"], "type": "str"},
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_http": {
        "stated": false,
        "options": {
            "archive-block": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "content-disarm": {"choices": ["disable", "enable"], "type": "str"},
            "emulator": {"choices": ["disable", "enable"], "type": "str"},
            "options": {"type": "list", "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor", "strict-file"], "elements": "str"},
            "outbreak-prevention": {"choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"], "type": "str"},
            "av-optimize": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "unknown-content-encoding": {"v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]], "choices": ["block", "inspect", "bypass"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_imap": {
        "stated": false,
        "options": {
            "archive-block": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "content-disarm": {"choices": ["disable", "enable"], "type": "str"},
            "emulator": {"choices": ["disable", "enable"], "type": "str"},
            "executables": {"choices": ["default", "virus"], "type": "str"},
            "options": {"type": "list", "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {"choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"], "type": "str"},
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_mapi": {
        "stated": false,
        "options": {
            "archive-block": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "emulator": {"choices": ["disable", "enable"], "type": "str"},
            "executables": {"choices": ["default", "virus"], "type": "str"},
            "options": {"type": "list", "choices": ["scan", "quarantine", "avquery", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {"choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"], "type": "str"},
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_nacquar": {
        "stated": false,
        "options": {
            "expiry": {"type": "str"},
            "infected": {"choices": ["none", "quar-src-ip", "quar-interface"], "type": "str"},
            "log": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "antivirus_profile_nntp": {
        "stated": false,
        "options": {
            "archive-block": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "emulator": {"choices": ["disable", "enable"], "type": "str"},
            "options": {"type": "list", "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {"choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"], "type": "str"},
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_outbreakprevention": {
        "stated": false,
        "options": {
            "external-blocklist": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ftgd-service": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "antivirus_profile_pop3": {
        "stated": false,
        "options": {
            "archive-block": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "content-disarm": {"choices": ["disable", "enable"], "type": "str"},
            "emulator": {"choices": ["disable", "enable"], "type": "str"},
            "executables": {"choices": ["default", "virus"], "type": "str"},
            "options": {"type": "list", "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {"choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"], "type": "str"},
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_smb": {
        "stated": false,
        "options": {
            "archive-block": {
                "v_range": [["6.0.0", "7.2.1"]],
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "v_range": [["6.0.0", "7.2.1"]],
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "emulator": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "options": {"v_range": [["6.0.0", "7.2.1"]], "type": "list", "choices": ["scan", "quarantine", "avquery", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disabled", "files", "full-archive"], "type": "str"}
        }
    },
    "antivirus_profile_smtp": {
        "stated": false,
        "options": {
            "archive-block": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "content-disarm": {"choices": ["disable", "enable"], "type": "str"},
            "emulator": {"choices": ["disable", "enable"], "type": "str"},
            "executables": {"choices": ["default", "virus"], "type": "str"},
            "options": {"type": "list", "choices": ["scan", "file-filter", "quarantine", "avquery", "avmonitor"], "elements": "str"},
            "outbreak-prevention": {"choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"], "type": "str"},
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "antivirus_profile_ssh": {
        "stated": false,
        "options": {
            "archive-block": {
                "v_range": [["6.2.2", ""]],
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "archive-log": {
                "v_range": [["6.2.2", ""]],
                "type": "list",
                "choices": ["encrypted", "corrupted", "multipart", "nested", "mailbomb", "unhandled", "partiallycorrupted", "fileslimit", "timeout"],
                "elements": "str"
            },
            "emulator": {"v_range": [["6.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "options": {"v_range": [["6.2.2", ""]], "type": "list", "choices": ["avmonitor", "quarantine", "scan"], "elements": "str"},
            "outbreak-prevention": {
                "v_range": [["6.2.2", ""]],
                "choices": ["disabled", "files", "full-archive", "disable", "block", "monitor"],
                "type": "str"
            },
            "av-scan": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "external-blocklist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "quarantine": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortindr": {"v_range": [["7.0.5", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortisandbox": {"v_range": [["7.2.0", ""]], "choices": ["disable", "block", "monitor"], "type": "str"},
            "fortiai": {"v_range": [["7.0.1", ""]], "choices": ["disable", "monitor", "block"], "type": "str"},
            "malware-stream": {"v_range": [["7.6.3", ""]], "choices": ["disable", "monitor", "block"], "type": "str"}
        }
    },
    "apcfgprofile": {
        "stated": true,
        "options": {
            "ac-ip": {"v_range": [["6.4.6", ""]], "type": "str"},
            "ac-port": {"v_range": [["6.4.6", ""]], "type": "int"},
            "ac-timer": {"v_range": [["6.4.6", ""]], "type": "int"},
            "ac-type": {"v_range": [["6.4.6", ""]], "choices": ["default", "specify", "apcfg"], "type": "str"},
            "command-list": {
                "v_range": [["6.4.6", ""]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.4.6", ""]], "type": "int"},
                    "name": {"v_range": [["6.4.6", ""]], "type": "str"},
                    "passwd-value": {"v_range": [["6.4.6", ""]], "no_log": true, "type": "raw"},
                    "type": {"v_range": [["6.4.6", ""]], "choices": ["non-password", "password"], "type": "str"},
                    "value": {"v_range": [["6.4.6", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "comment": {"v_range": [["6.4.6", ""]], "type": "str"},
            "name": {"v_range": [["6.4.6", ""]], "required": true, "type": "str"},
            "ap-family": {"v_range": [["6.4.8", "6.4.15"], ["7.0.2", ""]], "choices": ["fap", "fap-u", "fap-c"], "type": "str"}
        }
    },
    "apcfgprofile_commandlist": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.4.6", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.4.6", ""]], "type": "str"},
            "passwd-value": {"v_range": [["6.4.6", ""]], "no_log": true, "type": "raw"},
            "type": {"v_range": [["6.4.6", ""]], "choices": ["non-password", "password"], "type": "str"},
            "value": {"v_range": [["6.4.6", ""]], "type": "str"}
        }
    },
    "application_casi_profile": {
        "stated": true,
        "options": {
            "app-replacemsg": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "comment": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "entries": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["pass", "block", "reset"], "type": "str"},
                    "application": {"v_range": [["6.2.0", "6.2.13"]], "type": "raw"},
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "log": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "name": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "str"},
            "replacemsg-group": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
        }
    },
    "application_casi_profile_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["pass", "block", "reset"], "type": "str"},
            "application": {"v_range": [["6.2.0", "6.2.13"]], "type": "raw"},
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "log": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "application_categories": {"stated": true, "options": {"id": {"required": true, "type": "int"}}},
    "application_custom": {
        "stated": true,
        "options": {
            "behavior": {"type": "str"},
            "category": {"type": "str"},
            "comment": {"type": "str"},
            "id": {"type": "int"},
            "name": {"type": "str"},
            "protocol": {"type": "str"},
            "signature": {"type": "str"},
            "tag": {"required": true, "type": "str"},
            "technology": {"type": "str"},
            "vendor": {"type": "str"}
        }
    },
    "application_group": {
        "stated": true,
        "options": {
            "application": {"type": "raw"},
            "category": {"type": "raw"},
            "comment": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "type": {"choices": ["application", "category", "filter"], "type": "str"},
            "behavior": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "popularity": {"v_range": [["7.0.0", ""]], "type": "list", "choices": ["1", "2", "3", "4", "5"], "elements": "str"},
            "protocols": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "risk": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "technology": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "vendor": {"v_range": [["7.0.0", ""]], "type": "raw"}
        }
    },
    "application_internetservice": {
        "stated": false,
        "options": {
            "entry": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "ip-number": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "ip-range-number": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "port": {"v_range": [["6.2.0", "6.2.13"]], "type": "raw"},
                    "protocol": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
            "name": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "offset": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
            "reputation": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
        }
    },
    "application_internetservice_entry": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "ip-number": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
            "ip-range-number": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
            "port": {"v_range": [["6.2.0", "6.2.13"]], "type": "raw"},
            "protocol": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
        }
    },
    "application_internetservicecustom": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "disable-entry": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "ip-range": {
                        "v_range": [["6.2.0", "6.2.13"]],
                        "type": "list",
                        "options": {
                            "end-ip": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
                            "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                            "start-ip": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "port": {"v_range": [["6.2.0", "6.2.13"]], "type": "raw"},
                    "protocol": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
                },
                "elements": "dict"
            },
            "entry": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "dst": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "port-range": {
                        "v_range": [["6.2.0", "6.2.13"]],
                        "type": "list",
                        "options": {
                            "end-port": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                            "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                            "start-port": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "protocol": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
                },
                "elements": "dict"
            },
            "master-service-id": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "name": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "str"}
        }
    },
    "application_internetservicecustom_disableentry": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "ip-range": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "end-ip": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "start-ip": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
                },
                "elements": "dict"
            },
            "port": {"v_range": [["6.2.0", "6.2.13"]], "type": "raw"},
            "protocol": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
        }
    },
    "application_internetservicecustom_disableentry_iprange": {
        "stated": true,
        "options": {
            "end-ip": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "start-ip": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
        }
    },
    "application_internetservicecustom_entry": {
        "stated": true,
        "options": {
            "dst": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "port-range": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "end-port": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "start-port": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
                },
                "elements": "dict"
            },
            "protocol": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
        }
    },
    "application_internetservicecustom_entry_portrange": {
        "stated": true,
        "options": {
            "end-port": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "start-port": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
        }
    },
    "application_list": {
        "stated": true,
        "options": {
            "app-replacemsg": {"choices": ["disable", "enable"], "type": "str"},
            "comment": {"type": "str"},
            "deep-app-inspection": {"choices": ["disable", "enable"], "type": "str"},
            "entries": {
                "type": "list",
                "options": {
                    "action": {"choices": ["pass", "block", "reset"], "type": "str"},
                    "application": {"type": "raw"},
                    "behavior": {"type": "raw"},
                    "category": {"type": "raw"},
                    "id": {"type": "int"},
                    "log": {"choices": ["disable", "enable"], "type": "str"},
                    "log-packet": {"choices": ["disable", "enable"], "type": "str"},
                    "parameters": {
                        "type": "list",
                        "options": {
                            "id": {"type": "int"},
                            "value": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                            "members": {
                                "v_range": [["6.4.0", ""]],
                                "type": "list",
                                "options": {
                                    "id": {"v_range": [["6.4.0", ""]], "type": "int"},
                                    "name": {"v_range": [["6.4.0", ""]], "type": "str"},
                                    "value": {"v_range": [["6.4.0", ""]], "type": "str"}
                                },
                                "elements": "dict"
                            }
                        },
                        "elements": "dict"
                    },
                    "per-ip-shaper": {"type": "str"},
                    "popularity": {"type": "list", "choices": ["1", "2", "3", "4", "5"], "elements": "str"},
                    "protocols": {"type": "raw"},
                    "quarantine": {"choices": ["none", "attacker"], "type": "str"},
                    "quarantine-expiry": {"type": "str"},
                    "quarantine-log": {"choices": ["disable", "enable"], "type": "str"},
                    "rate-count": {"type": "int"},
                    "rate-duration": {"type": "int"},
                    "rate-mode": {"choices": ["periodical", "continuous"], "type": "str"},
                    "rate-track": {"choices": ["none", "src-ip", "dest-ip", "dhcp-client-mac", "dns-domain"], "type": "str"},
                    "risk": {"type": "raw"},
                    "session-ttl": {"type": "int"},
                    "shaper": {"type": "str"},
                    "shaper-reverse": {"type": "str"},
                    "sub-category": {"type": "raw"},
                    "technology": {"type": "raw"},
                    "vendor": {"type": "raw"},
                    "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
                    "exclusion": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "extended-log": {"choices": ["disable", "enable"], "type": "str"},
            "name": {"required": true, "type": "str"},
            "options": {"type": "list", "choices": ["allow-dns", "allow-icmp", "allow-http", "allow-ssl", "allow-quic"], "elements": "str"},
            "other-application-action": {"choices": ["pass", "block"], "type": "str"},
            "other-application-log": {"choices": ["disable", "enable"], "type": "str"},
            "p2p-black-list": {"type": "list", "choices": ["skype", "edonkey", "bittorrent"], "elements": "str"},
            "replacemsg-group": {"type": "str"},
            "unknown-application-action": {"choices": ["pass", "block"], "type": "str"},
            "unknown-application-log": {"choices": ["disable", "enable"], "type": "str"},
            "control-default-network-services": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "default-network-services": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "port": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "services": {
                        "v_range": [["6.2.0", ""]],
                        "type": "list",
                        "choices": ["http", "ssh", "telnet", "ftp", "dns", "smtp", "pop3", "imap", "snmp", "nntp", "https"],
                        "elements": "str"
                    },
                    "violation-action": {"v_range": [["6.2.0", ""]], "choices": ["block", "monitor", "pass"], "type": "str"}
                },
                "elements": "dict"
            },
            "enforce-default-app-port": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "force-inclusion-ssl-di-sigs": {"v_range": [["6.2.5", ""]], "choices": ["disable", "enable"], "type": "str"},
            "p2p-block-list": {"v_range": [["7.0.0", ""]], "type": "list", "choices": ["skype", "edonkey", "bittorrent"], "elements": "str"}
        }
    },
    "application_list_defaultnetworkservices": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "port": {"v_range": [["6.2.0", ""]], "type": "int"},
            "services": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "choices": ["http", "ssh", "telnet", "ftp", "dns", "smtp", "pop3", "imap", "snmp", "nntp", "https"],
                "elements": "str"
            },
            "violation-action": {"v_range": [["6.2.0", ""]], "choices": ["block", "monitor", "pass"], "type": "str"}
        }
    },
    "application_list_entries": {
        "stated": true,
        "options": {
            "action": {"choices": ["pass", "block", "reset"], "type": "str"},
            "application": {"type": "raw"},
            "behavior": {"type": "raw"},
            "category": {"type": "raw"},
            "id": {"required": true, "type": "int"},
            "log": {"choices": ["disable", "enable"], "type": "str"},
            "log-packet": {"choices": ["disable", "enable"], "type": "str"},
            "parameters": {
                "type": "list",
                "options": {
                    "id": {"type": "int"},
                    "value": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "members": {
                        "v_range": [["6.4.0", ""]],
                        "type": "list",
                        "options": {
                            "id": {"v_range": [["6.4.0", ""]], "type": "int"},
                            "name": {"v_range": [["6.4.0", ""]], "type": "str"},
                            "value": {"v_range": [["6.4.0", ""]], "type": "str"}
                        },
                        "elements": "dict"
                    }
                },
                "elements": "dict"
            },
            "per-ip-shaper": {"type": "str"},
            "popularity": {"type": "list", "choices": ["1", "2", "3", "4", "5"], "elements": "str"},
            "protocols": {"type": "raw"},
            "quarantine": {"choices": ["none", "attacker"], "type": "str"},
            "quarantine-expiry": {"type": "str"},
            "quarantine-log": {"choices": ["disable", "enable"], "type": "str"},
            "rate-count": {"type": "int"},
            "rate-duration": {"type": "int"},
            "rate-mode": {"choices": ["periodical", "continuous"], "type": "str"},
            "rate-track": {"choices": ["none", "src-ip", "dest-ip", "dhcp-client-mac", "dns-domain"], "type": "str"},
            "risk": {"type": "raw"},
            "session-ttl": {"type": "int"},
            "shaper": {"type": "str"},
            "shaper-reverse": {"type": "str"},
            "sub-category": {"type": "raw"},
            "technology": {"type": "raw"},
            "vendor": {"type": "raw"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
            "exclusion": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "type": "raw"}
        }
    },
    "application_list_entries_parameters": {
        "stated": true,
        "options": {
            "id": {"required": true, "type": "int"},
            "value": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "members": {
                "v_range": [["6.4.0", ""]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.4.0", ""]], "type": "int"},
                    "name": {"v_range": [["6.4.0", ""]], "type": "str"},
                    "value": {"v_range": [["6.4.0", ""]], "type": "str"}
                },
                "elements": "dict"
            }
        }
    },
    "application_list_entries_parameters_members": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.4.0", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.4.0", ""]], "type": "str"},
            "value": {"v_range": [["6.4.0", ""]], "type": "str"}
        }
    },
    "arrpprofile": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.0.3", ""]], "type": "str"},
            "darrp-optimize": {"v_range": [["7.0.3", ""]], "type": "int"},
            "darrp-optimize-schedules": {"v_range": [["7.0.3", ""]], "type": "raw"},
            "include-dfs-channel": {"v_range": [["7.0.3", ""]], "choices": ["no", "disable", "yes", "enable"], "type": "str"},
            "include-weather-channel": {"v_range": [["7.0.3", ""]], "choices": ["no", "disable", "yes", "enable"], "type": "str"},
            "monitor-period": {"v_range": [["7.0.3", ""]], "type": "int"},
            "name": {"v_range": [["7.0.3", ""]], "required": true, "type": "str"},
            "override-darrp-optimize": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "selection-period": {"v_range": [["7.0.3", ""]], "type": "int"},
            "threshold-ap": {"v_range": [["7.0.3", ""]], "type": "int"},
            "threshold-channel-load": {"v_range": [["7.0.3", ""]], "type": "int"},
            "threshold-noise-floor": {"v_range": [["7.0.3", ""]], "type": "str"},
            "threshold-rx-errors": {"v_range": [["7.0.3", ""]], "type": "int"},
            "threshold-spectral-rssi": {"v_range": [["7.0.3", ""]], "type": "str"},
            "threshold-tx-retries": {"v_range": [["7.0.3", ""]], "type": "int"},
            "weight-channel-load": {"v_range": [["7.0.3", ""]], "type": "int"},
            "weight-dfs-channel": {"v_range": [["7.0.3", ""]], "type": "int"},
            "weight-managed-ap": {"v_range": [["7.0.3", ""]], "type": "int"},
            "weight-noise-floor": {"v_range": [["7.0.3", ""]], "type": "int"},
            "weight-rogue-ap": {"v_range": [["7.0.3", ""]], "type": "int"},
            "weight-spectral-rssi": {"v_range": [["7.0.3", ""]], "type": "int"},
            "weight-weather-channel": {"v_range": [["7.0.3", ""]], "type": "int"}
        }
    },
    "authentication_scheme": {
        "stated": true,
        "options": {
            "domain-controller": {"v_range": [["6.2.1", ""]], "type": "str"},
            "fsso-agent-for-ntlm": {"v_range": [["6.2.1", ""]], "type": "str"},
            "fsso-guest": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "kerberos-keytab": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "str"},
            "method": {
                "v_range": [["6.2.1", ""]],
                "type": "list",
                "choices": [
                    "ntlm", "basic", "digest", "form", "negotiate", "fsso", "rsso", "ssh-publickey", "saml", "cert", "x-auth-user", "saml-sp",
                    "entra-sso"
                ],
                "elements": "str"
            },
            "name": {"v_range": [["6.2.1", ""]], "required": true, "type": "str"},
            "negotiate-ntlm": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "require-tfa": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-ca": {"v_range": [["6.2.1", ""]], "type": "str"},
            "user-database": {"v_range": [["6.2.1", ""]], "type": "raw"},
            "ems-device-owner": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "saml-server": {"v_range": [["7.0.0", ""]], "type": "str"},
            "saml-timeout": {"v_range": [["7.0.0", ""]], "type": "int"},
            "user-cert": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-idp": {"v_range": [["7.6.2", ""]], "type": "raw"},
            "digest-algo": {"v_range": [["7.6.3", ""]], "type": "list", "choices": ["md5", "sha-256"], "elements": "str"},
            "group-attr-type": {"v_range": [["7.6.3", ""]], "choices": ["display-name", "external-id"], "type": "str"}
        }
    },
    "bleprofile": {
        "stated": true,
        "options": {
            "advertising": {"type": "list", "choices": ["ibeacon", "eddystone-uid", "eddystone-url"], "elements": "str"},
            "beacon-interval": {"type": "int"},
            "ble-scanning": {"choices": ["disable", "enable"], "type": "str"},
            "comment": {"type": "str"},
            "eddystone-instance": {"type": "str"},
            "eddystone-namespace": {"type": "str"},
            "eddystone-url": {"type": "str"},
            "eddystone-url-encode-hex": {"type": "str"},
            "ibeacon-uuid": {"type": "str"},
            "major-id": {"type": "int"},
            "minor-id": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "txpower": {"choices": ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"], "type": "str"},
            "scan-interval": {"v_range": [["7.4.1", ""]], "type": "int"},
            "scan-period": {"v_range": [["7.4.1", ""]], "type": "int"},
            "scan-threshold": {"v_range": [["7.4.1", ""]], "type": "str"},
            "scan-time": {"v_range": [["7.4.1", ""]], "type": "int"},
            "scan-type": {"v_range": [["7.4.1", ""]], "choices": ["active", "passive"], "type": "str"},
            "scan-window": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "bonjourprofile": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "policy-list": {
                "type": "list",
                "options": {
                    "description": {"type": "str"},
                    "from-vlan": {"type": "str"},
                    "policy-id": {"type": "int"},
                    "services": {
                        "type": "list",
                        "choices": [
                            "airplay", "afp", "bit-torrent", "ftp", "ichat", "itunes", "printers", "samba", "scanners", "ssh", "chromecast", "all",
                            "miracast"
                        ],
                        "elements": "str"
                    },
                    "to-vlan": {"type": "str"}
                },
                "elements": "dict"
            },
            "micro-location": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "bonjourprofile_policylist": {
        "stated": true,
        "options": {
            "description": {"type": "str"},
            "from-vlan": {"type": "str"},
            "policy-id": {"required": true, "type": "int"},
            "services": {
                "type": "list",
                "choices": [
                    "airplay", "afp", "bit-torrent", "ftp", "ichat", "itunes", "printers", "samba", "scanners", "ssh", "chromecast", "all", "miracast"
                ],
                "elements": "str"
            },
            "to-vlan": {"type": "str"}
        }
    },
    "casb_profile": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "saas-application": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "access-rule": {
                        "v_range": [["7.4.1", ""]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["7.4.1", ""]], "choices": ["block", "bypass", "monitor"], "type": "str"},
                            "bypass": {
                                "v_range": [["7.4.1", ""]],
                                "type": "list",
                                "choices": ["av", "dlp", "web-filter", "file-filter", "video-filter"],
                                "elements": "str"
                            },
                            "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                            "attribute-filter": {
                                "v_range": [["7.6.2", ""]],
                                "type": "list",
                                "options": {
                                    "action": {"v_range": [["7.6.2", ""]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                                    "attribute-match": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                                    "id": {"v_range": [["7.6.2", ""]], "type": "int"}
                                },
                                "elements": "dict"
                            }
                        },
                        "elements": "dict"
                    },
                    "custom-control": {
                        "v_range": [["7.4.1", ""]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                            "option": {
                                "v_range": [["7.4.1", ""]],
                                "type": "list",
                                "options": {
                                    "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                                    "user-input": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"}
                                },
                                "elements": "dict"
                            },
                            "attribute-filter": {
                                "v_range": [["7.6.2", ""]],
                                "type": "list",
                                "options": {
                                    "action": {"v_range": [["7.6.2", ""]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                                    "attribute-match": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                                    "id": {"v_range": [["7.6.2", ""]], "type": "int"}
                                },
                                "elements": "dict"
                            }
                        },
                        "elements": "dict"
                    },
                    "domain-control": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "domain-control-domains": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
                    "log": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "safe-search": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "safe-search-control": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
                    "tenant-control": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tenant-control-tenants": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
                    "status": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "advanced-tenant-control": {
                        "v_range": [["7.6.2", ""]],
                        "type": "list",
                        "options": {
                            "attribute": {
                                "v_range": [["7.6.2", ""]],
                                "type": "list",
                                "options": {
                                    "input": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                                    "name": {"v_range": [["7.6.2", ""]], "type": "str"}
                                },
                                "elements": "dict"
                            },
                            "name": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"}
                        },
                        "elements": "dict"
                    }
                },
                "elements": "dict"
            },
            "comment": {"v_range": [["7.4.3", ""]], "type": "str"}
        }
    },
    "casb_profile_saasapplication": {
        "stated": true,
        "options": {
            "access-rule": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["7.4.1", ""]], "choices": ["block", "bypass", "monitor"], "type": "str"},
                    "bypass": {
                        "v_range": [["7.4.1", ""]],
                        "type": "list",
                        "choices": ["av", "dlp", "web-filter", "file-filter", "video-filter"],
                        "elements": "str"
                    },
                    "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "attribute-filter": {
                        "v_range": [["7.6.2", ""]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["7.6.2", ""]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                            "attribute-match": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                            "id": {"v_range": [["7.6.2", ""]], "type": "int"}
                        },
                        "elements": "dict"
                    }
                },
                "elements": "dict"
            },
            "custom-control": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "option": {
                        "v_range": [["7.4.1", ""]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                            "user-input": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"}
                        },
                        "elements": "dict"
                    },
                    "attribute-filter": {
                        "v_range": [["7.6.2", ""]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["7.6.2", ""]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                            "attribute-match": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                            "id": {"v_range": [["7.6.2", ""]], "type": "int"}
                        },
                        "elements": "dict"
                    }
                },
                "elements": "dict"
            },
            "domain-control": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "domain-control-domains": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
            "log": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "safe-search": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "safe-search-control": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
            "tenant-control": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tenant-control-tenants": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
            "status": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "advanced-tenant-control": {
                "v_range": [["7.6.2", ""]],
                "type": "list",
                "options": {
                    "attribute": {
                        "v_range": [["7.6.2", ""]],
                        "type": "list",
                        "options": {
                            "input": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                            "name": {"v_range": [["7.6.2", ""]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "name": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"}
                },
                "elements": "dict"
            }
        }
    },
    "casb_profile_saasapplication_accessrule": {
        "stated": true,
        "options": {
            "action": {"v_range": [["7.4.1", ""]], "choices": ["block", "bypass", "monitor"], "type": "str"},
            "bypass": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "choices": ["av", "dlp", "web-filter", "file-filter", "video-filter"],
                "elements": "str"
            },
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "attribute-filter": {
                "v_range": [["7.6.2", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["7.6.2", ""]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                    "attribute-match": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                    "id": {"v_range": [["7.6.2", ""]], "type": "int"}
                },
                "elements": "dict"
            }
        }
    },
    "casb_profile_saasapplication_customcontrol": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "option": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "user-input": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"}
                },
                "elements": "dict"
            },
            "attribute-filter": {
                "v_range": [["7.6.2", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["7.6.2", ""]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                    "attribute-match": {"v_range": [["7.6.2", ""]], "type": "list", "elements": "str"},
                    "id": {"v_range": [["7.6.2", ""]], "type": "int"}
                },
                "elements": "dict"
            }
        }
    },
    "casb_profile_saasapplication_customcontrol_option": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "user-input": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"}
        }
    },
    "casb_saasapplication": {
        "stated": true,
        "options": {
            "casb-name": {"v_range": [["7.4.1", ""]], "type": "str"},
            "description": {"v_range": [["7.4.1", ""]], "type": "str"},
            "domains": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "type": {"v_range": [["7.4.1", ""]], "choices": ["built-in", "customized"], "type": "str"},
            "uuid": {"v_range": [["7.4.1", ""]], "type": "str"},
            "status": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "input-attributes": {
                "v_range": [["7.6.2", ""]],
                "type": "list",
                "options": {
                    "attr-type": {"v_range": [["7.6.2", ""]], "choices": ["tenant"], "type": "str"},
                    "default": {"v_range": [["7.6.2", ""]], "choices": ["string", "string-list"], "type": "str"},
                    "description": {"v_range": [["7.6.2", ""]], "type": "str"},
                    "fallback-input": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "name": {"v_range": [["7.6.2", ""]], "type": "str"},
                    "required": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["7.6.2", ""]], "choices": ["string", "string-list", "integer", "integer-list", "boolean"], "type": "str"}
                },
                "elements": "dict"
            },
            "output-attributes": {
                "v_range": [["7.6.2", ""]],
                "type": "list",
                "options": {
                    "attr-type": {"v_range": [["7.6.2", ""]], "choices": ["tenant"], "type": "str"},
                    "description": {"v_range": [["7.6.2", ""]], "type": "str"},
                    "name": {"v_range": [["7.6.2", ""]], "type": "str"},
                    "required": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["7.6.2", ""]], "choices": ["string", "string-list", "integer", "integer-list", "boolean"], "type": "str"},
                    "optional": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            }
        }
    },
    "casb_useractivity": {
        "stated": true,
        "options": {
            "application": {"v_range": [["7.4.1", ""]], "type": "str"},
            "casb-name": {"v_range": [["7.4.1", ""]], "type": "str"},
            "category": {
                "v_range": [["7.4.1", ""]],
                "choices": ["activity-control", "tenant-control", "domain-control", "safe-search-control", "other"],
                "type": "str"
            },
            "control-options": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "operations": {
                        "v_range": [["7.4.1", ""]],
                        "type": "list",
                        "options": {
                            "action": {
                                "v_range": [["7.4.1", ""]],
                                "choices": ["append", "prepend", "replace", "new", "new-on-not-found", "delete"],
                                "type": "str"
                            },
                            "case-sensitive": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "direction": {"v_range": [["7.4.1", ""]], "choices": ["request", "response"], "type": "str"},
                            "header-name": {"v_range": [["7.4.1", ""]], "type": "str"},
                            "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                            "search-key": {"v_range": [["7.4.1", ""]], "no_log": true, "type": "str"},
                            "search-pattern": {"v_range": [["7.4.1", ""]], "choices": ["simple", "substr", "regexp"], "type": "str"},
                            "target": {"v_range": [["7.4.1", ""]], "choices": ["header", "path", "body"], "type": "str"},
                            "value-from-input": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "values": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"}
                        },
                        "elements": "dict"
                    },
                    "status": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "description": {"v_range": [["7.4.1", ""]], "type": "str"},
            "match": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "rules": {
                        "v_range": [["7.4.1", ""]],
                        "type": "list",
                        "options": {
                            "case-sensitive": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "domains": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
                            "header-name": {"v_range": [["7.4.1", ""]], "type": "str"},
                            "id": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "match-pattern": {"v_range": [["7.4.1", ""]], "choices": ["simple", "substr", "regexp"], "type": "str"},
                            "match-value": {"v_range": [["7.4.1", ""]], "type": "str"},
                            "methods": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
                            "negate": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "type": {
                                "v_range": [["7.4.1", ""]],
                                "choices": ["domains", "host", "path", "header", "header-value", "method", "body"],
                                "type": "str"
                            },
                            "body-type": {"v_range": [["7.6.2", ""]], "choices": ["json"], "type": "str"},
                            "jq": {"v_range": [["7.6.2", ""]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "strategy": {"v_range": [["7.4.1", ""]], "choices": ["or", "and"], "type": "str"},
                    "tenant-extraction": {
                        "v_range": [["7.6.2", ""]],
                        "type": "dict",
                        "options": {
                            "filters": {
                                "v_range": [["7.6.2", ""]],
                                "type": "list",
                                "options": {
                                    "body-type": {"v_range": [["7.6.2", ""]], "choices": ["json"], "type": "str"},
                                    "direction": {"v_range": [["7.6.2", ""]], "choices": ["request", "response"], "type": "str"},
                                    "header-name": {"v_range": [["7.6.2", ""]], "type": "str"},
                                    "id": {"v_range": [["7.6.2", ""]], "type": "int"},
                                    "place": {"v_range": [["7.6.2", ""]], "choices": ["path", "header", "body"], "type": "str"}
                                },
                                "elements": "dict"
                            },
                            "jq": {"v_range": [["7.6.2", ""]], "type": "str"},
                            "status": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "type": {"v_range": [["7.6.2", ""]], "choices": ["json-query"], "type": "str"}
                        }
                    }
                },
                "elements": "dict"
            },
            "match-strategy": {"v_range": [["7.4.1", ""]], "choices": ["or", "and"], "type": "str"},
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "type": {"v_range": [["7.4.1", ""]], "choices": ["built-in", "customized"], "type": "str"},
            "uuid": {"v_range": [["7.4.1", ""]], "type": "str"},
            "status": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "casb_useractivity_controloptions": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "operations": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "action": {
                        "v_range": [["7.4.1", ""]],
                        "choices": ["append", "prepend", "replace", "new", "new-on-not-found", "delete"],
                        "type": "str"
                    },
                    "case-sensitive": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "direction": {"v_range": [["7.4.1", ""]], "choices": ["request", "response"], "type": "str"},
                    "header-name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "search-key": {"v_range": [["7.4.1", ""]], "no_log": true, "type": "str"},
                    "search-pattern": {"v_range": [["7.4.1", ""]], "choices": ["simple", "substr", "regexp"], "type": "str"},
                    "target": {"v_range": [["7.4.1", ""]], "choices": ["header", "path", "body"], "type": "str"},
                    "value-from-input": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "values": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"}
                },
                "elements": "dict"
            },
            "status": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "casb_useractivity_controloptions_operations": {
        "stated": true,
        "options": {
            "action": {"v_range": [["7.4.1", ""]], "choices": ["append", "prepend", "replace", "new", "new-on-not-found", "delete"], "type": "str"},
            "case-sensitive": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "direction": {"v_range": [["7.4.1", ""]], "choices": ["request", "response"], "type": "str"},
            "header-name": {"v_range": [["7.4.1", ""]], "type": "str"},
            "name": {"v_range": [["7.4.1", ""]], "required": true, "type": "str"},
            "search-key": {"v_range": [["7.4.1", ""]], "no_log": true, "type": "str"},
            "search-pattern": {"v_range": [["7.4.1", ""]], "choices": ["simple", "substr", "regexp"], "type": "str"},
            "target": {"v_range": [["7.4.1", ""]], "choices": ["header", "path", "body"], "type": "str"},
            "value-from-input": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "values": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"}
        }
    },
    "casb_useractivity_match": {
        "stated": true,
        "options": {
            "id": {"v_range": [["7.4.1", ""]], "required": true, "type": "int"},
            "rules": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {
                    "case-sensitive": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "domains": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
                    "header-name": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "id": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "match-pattern": {"v_range": [["7.4.1", ""]], "choices": ["simple", "substr", "regexp"], "type": "str"},
                    "match-value": {"v_range": [["7.4.1", ""]], "type": "str"},
                    "methods": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
                    "negate": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {
                        "v_range": [["7.4.1", ""]],
                        "choices": ["domains", "host", "path", "header", "header-value", "method", "body"],
                        "type": "str"
                    },
                    "body-type": {"v_range": [["7.6.2", ""]], "choices": ["json"], "type": "str"},
                    "jq": {"v_range": [["7.6.2", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "strategy": {"v_range": [["7.4.1", ""]], "choices": ["or", "and"], "type": "str"},
            "tenant-extraction": {
                "v_range": [["7.6.2", ""]],
                "type": "dict",
                "options": {
                    "filters": {
                        "v_range": [["7.6.2", ""]],
                        "type": "list",
                        "options": {
                            "body-type": {"v_range": [["7.6.2", ""]], "choices": ["json"], "type": "str"},
                            "direction": {"v_range": [["7.6.2", ""]], "choices": ["request", "response"], "type": "str"},
                            "header-name": {"v_range": [["7.6.2", ""]], "type": "str"},
                            "id": {"v_range": [["7.6.2", ""]], "type": "int"},
                            "place": {"v_range": [["7.6.2", ""]], "choices": ["path", "header", "body"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "jq": {"v_range": [["7.6.2", ""]], "type": "str"},
                    "status": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["7.6.2", ""]], "choices": ["json-query"], "type": "str"}
                }
            }
        }
    },
    "casb_useractivity_match_rules": {
        "stated": true,
        "options": {
            "case-sensitive": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "domains": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
            "header-name": {"v_range": [["7.4.1", ""]], "type": "str"},
            "id": {"v_range": [["7.4.1", ""]], "required": true, "type": "int"},
            "match-pattern": {"v_range": [["7.4.1", ""]], "choices": ["simple", "substr", "regexp"], "type": "str"},
            "match-value": {"v_range": [["7.4.1", ""]], "type": "str"},
            "methods": {"v_range": [["7.4.1", ""]], "type": "list", "elements": "str"},
            "negate": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["7.4.1", ""]], "choices": ["domains", "host", "path", "header", "header-value", "method", "body"], "type": "str"},
            "body-type": {"v_range": [["7.6.2", ""]], "choices": ["json"], "type": "str"},
            "jq": {"v_range": [["7.6.2", ""]], "type": "str"}
        }
    },
    "certificate_template": {
        "stated": true,
        "options": {
            "city": {"type": "str"},
            "country": {"type": "str"},
            "digest-type": {"choices": ["sha1", "sha256"], "type": "str"},
            "email": {"type": "str"},
            "id-type": {"choices": ["host-ip", "domain-name", "email"], "type": "str"},
            "key-size": {"choices": ["512", "1024", "1536", "2048", "4096"], "type": "str"},
            "key-type": {"choices": ["rsa", "ec"], "type": "str"},
            "name": {"required": true, "type": "str"},
            "organization": {"type": "str"},
            "organization-unit": {"type": "raw"},
            "scep-password": {"no_log": true, "type": "raw"},
            "scep-server": {"type": "str"},
            "state": {"type": "str"},
            "subject-name": {"type": "str"},
            "type": {"choices": ["external", "local"], "type": "str"},
            "curve-name": {"v_range": [["6.2.1", ""]], "choices": ["secp256r1", "secp384r1", "secp521r1"], "type": "str"},
            "scep-ca-identifier": {"v_range": [["7.0.4", ""]], "type": "str"}
        }
    },
    "cifs_domaincontroller": {
        "stated": true,
        "options": {
            "domain-name": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "ip": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "ip6": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "password": {"v_range": [["6.2.0", "7.6.2"]], "no_log": true, "type": "raw"},
            "port": {"v_range": [["6.2.0", "7.6.2"]], "type": "int"},
            "server-name": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "username": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"}
        }
    },
    "cifs_profile": {
        "stated": true,
        "options": {
            "domain-controller": {"v_range": [["6.2.0", ""]], "type": "str"},
            "name": {"v_range": [["6.2.0", ""]], "required": true, "type": "str"},
            "server-credential-type": {"v_range": [["6.2.0", ""]], "choices": ["none", "credential-replication", "credential-keytab"], "type": "str"},
            "server-keytab": {
                "v_range": [["6.2.0", ""]],
                "no_log": true,
                "type": "list",
                "options": {
                    "keytab": {"v_range": [["6.2.0", ""]], "no_log": true, "type": "str"},
                    "principal": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "password": {"v_range": [["6.2.2", ""]], "no_log": true, "type": "raw"}
                },
                "elements": "dict"
            },
            "file-filter": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                "type": "dict",
                "options": {
                    "entries": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["block", "log"], "type": "str"},
                            "comment": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                            "direction": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["incoming", "outgoing", "any"], "type": "str"},
                            "file-type": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "raw"},
                            "filter": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                            "protocol": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "list", "choices": ["cifs"], "elements": "str"}
                        },
                        "elements": "dict"
                    },
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                }
            }
        }
    },
    "cifs_profile_filefilter": {
        "stated": false,
        "options": {
            "entries": {
                "v_range": [["6.2.0", "7.6.2"]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["block", "log"], "type": "str"},
                    "comment": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
                    "direction": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["incoming", "outgoing", "any"], "type": "str"},
                    "file-type": {"v_range": [["6.2.0", "7.6.2"]], "type": "raw"},
                    "filter": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
                    "protocol": {"v_range": [["6.2.0", "7.6.2"]], "type": "list", "choices": ["cifs"], "elements": "str"}
                },
                "elements": "dict"
            },
            "log": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "cifs_profile_filefilter_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["block", "log"], "type": "str"},
            "comment": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "direction": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["incoming", "outgoing", "any"], "type": "str"},
            "file-type": {"v_range": [["6.2.0", "7.6.2"]], "type": "raw"},
            "filter": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "protocol": {"v_range": [["6.2.0", "7.6.2"]], "type": "list", "choices": ["cifs"], "elements": "str"}
        }
    },
    "cifs_profile_serverkeytab": {
        "stated": true,
        "options": {
            "keytab": {"v_range": [["6.2.0", ""]], "no_log": true, "type": "str"},
            "principal": {"v_range": [["6.2.0", ""]], "type": "str"},
            "password": {"v_range": [["6.2.2", ""]], "no_log": true, "type": "raw"}
        }
    },
    "cloud_orchestaws": {
        "stated": true,
        "options": {
            "connector": {"v_range": [["7.4.0", ""]], "type": "str"},
            "name": {"v_range": [["7.4.0", ""]], "required": true, "type": "str"},
            "region-name": {
                "v_range": [["7.4.0", ""]],
                "choices": [
                    "us-east-1", "us-east-2", "us-west-1", "us-west-2", "eu-west-1", "eu-west-2", "eu-west-3", "eu-north-1", "eu-south-1", "eu-south-2",
                    "eu-central-1", "eu-central-2", "ca-central-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ap-southeast-4", "ap-south-1",
                    "ap-south-2", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "af-south-1", "me-central-1", "me-south-1", "sa-east-1",
                    "ap-east-1", "us-gov-east-1", "us-gov-west-1", "ca-west-1", "il-central-1", "ap-southeast-5", "ap-southeast-7", "mx-central-1"
                ],
                "type": "str"
            },
            "template-configuration": {"v_range": [["7.4.0", ""]], "type": "str"}
        }
    },
    "cloud_orchestawsconnector": {
        "stated": true,
        "options": {
            "access-key-id": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "access-key-secret": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "raw"},
            "name": {"v_range": [["7.4.0", ""]], "required": true, "type": "str"},
            "use-metadata-iam": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "cloud_orchestawstemplate_autoscaleexistingvpc": {
        "stated": true,
        "options": {
            "custom-asset-container": {"v_range": [["7.4.0", ""]], "type": "str"},
            "custom-asset-directory": {"v_range": [["7.4.0", ""]], "type": "str"},
            "custom-identifier": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-autoscale-admin-password": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "raw"},
            "faz-autoscale-admin-username": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-custom-private-ipaddress": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-instance-type": {
                "v_range": [["7.4.0", ""]],
                "choices": [
                    "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.12xlarge", "t2.medium",
                    "t2.large", "t2.xlarge"
                ],
                "type": "str"
            },
            "faz-integration-options": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "faz-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "fgt-admin-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "fgt-admin-port": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgt-instance-type": {
                "v_range": [["7.4.0", ""]],
                "choices": ["t2.small", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge"],
                "type": "str"
            },
            "fgt-psk-secret": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "fgtasg-cool-down": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-desired-capacity-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-desired-capacity-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-health-check-grace-period": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-max-size-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-max-size-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-min-size-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-min-size-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-scale-in-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-scale-out-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fos-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "get-license-grace-period": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-delay-allowance": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-interval": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-loss-count": {"v_range": [["7.4.0", ""]], "type": "int"},
            "internal-balancer-dns-name": {"v_range": [["7.4.0", ""]], "type": "str"},
            "internal-balancing-options": {
                "v_range": [["7.4.0", ""]],
                "choices": ["add a new internal load balancer", "use a load balancer specified below", "do not need one"],
                "type": "str"
            },
            "internal-target-group-health-check-path": {"v_range": [["7.4.0", ""]], "type": "str"},
            "key-pair-name": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "lifecycle-hook-timeout": {"v_range": [["7.4.0", ""]], "type": "int"},
            "loadbalancing-health-check-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "loadbalancing-traffic-port": {"v_range": [["7.4.0", ""]], "type": "int"},
            "loadbalancing-traffic-protocol": {"v_range": [["7.4.0", ""]], "choices": ["HTTPS", "HTTP", "TCP"], "type": "str"},
            "name": {"v_range": [["7.4.0", ""]], "required": true, "type": "str"},
            "notification-email": {"v_range": [["7.4.0", ""]], "type": "str"},
            "primary-election-timeout": {"v_range": [["7.4.0", ""]], "type": "int"},
            "private-subnet-route-table": {"v_range": [["7.4.0", ""]], "type": "str"},
            "private-subnet1": {"v_range": [["7.4.0", ""]], "type": "str"},
            "private-subnet2": {"v_range": [["7.4.0", ""]], "type": "str"},
            "public-subnet1": {"v_range": [["7.4.0", ""]], "type": "str"},
            "public-subnet2": {"v_range": [["7.4.0", ""]], "type": "str"},
            "resource-tag-prefix": {"v_range": [["7.4.0", ""]], "type": "str"},
            "s3-bucket-name": {"v_range": [["7.4.0", ""]], "type": "str"},
            "s3-key-prefix": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "sync-recovery-count": {"v_range": [["7.4.0", ""]], "type": "int"},
            "terminate-unhealthy-vm": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "use-custom-asset-location": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "vpc-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "vpc-endpoint-id": {"v_range": [["7.4.0", ""]], "type": "str"},
            "vpc-id": {"v_range": [["7.4.0", ""]], "type": "str"}
        }
    },
    "cloud_orchestawstemplate_autoscalenewvpc": {
        "stated": true,
        "options": {
            "availability-zones": {"v_range": [["7.4.0", ""]], "type": "str"},
            "custom-asset-container": {"v_range": [["7.4.0", ""]], "type": "str"},
            "custom-asset-directory": {"v_range": [["7.4.0", ""]], "type": "str"},
            "custom-identifier": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-autoscale-admin-password": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "raw"},
            "faz-autoscale-admin-username": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-custom-private-ipaddress": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-instance-type": {
                "v_range": [["7.4.0", ""]],
                "choices": [
                    "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.12xlarge", "t2.medium",
                    "t2.large", "t2.xlarge"
                ],
                "type": "str"
            },
            "faz-integration-options": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "faz-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "fgt-admin-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "fgt-admin-port": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgt-instance-type": {
                "v_range": [["7.4.0", ""]],
                "choices": ["t2.small", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge"],
                "type": "str"
            },
            "fgt-psk-secret": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "fgtasg-cool-down": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-desired-capacity-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-desired-capacity-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-health-check-grace-period": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-max-size-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-max-size-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-min-size-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-min-size-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-scale-in-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-scale-out-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fos-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "get-license-grace-period": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-delay-allowance": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-interval": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-loss-count": {"v_range": [["7.4.0", ""]], "type": "int"},
            "internal-balancer-dns-name": {"v_range": [["7.4.0", ""]], "type": "str"},
            "internal-balancing-options": {
                "v_range": [["7.4.0", ""]],
                "choices": ["add a new internal load balancer", "use a load balancer specified below", "do not need one"],
                "type": "str"
            },
            "internal-target-group-health-check-path": {"v_range": [["7.4.0", ""]], "type": "str"},
            "key-pair-name": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "lifecycle-hook-timeout": {"v_range": [["7.4.0", ""]], "type": "int"},
            "loadbalancing-health-check-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "loadbalancing-traffic-port": {"v_range": [["7.4.0", ""]], "type": "int"},
            "loadbalancing-traffic-protocol": {"v_range": [["7.4.0", ""]], "choices": ["HTTPS", "HTTP", "TCP"], "type": "str"},
            "name": {"v_range": [["7.4.0", ""]], "required": true, "type": "str"},
            "notification-email": {"v_range": [["7.4.0", ""]], "type": "str"},
            "primary-election-timeout": {"v_range": [["7.4.0", ""]], "type": "int"},
            "private-subnet1-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "private-subnet2-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "public-subnet1-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "public-subnet2-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "resource-tag-prefix": {"v_range": [["7.4.0", ""]], "type": "str"},
            "s3-bucket-name": {"v_range": [["7.4.0", ""]], "type": "str"},
            "s3-key-prefix": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "sync-recovery-count": {"v_range": [["7.4.0", ""]], "type": "int"},
            "terminate-unhealthy-vm": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "use-custom-asset-location": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "vpc-cidr": {"v_range": [["7.4.0", ""]], "type": "str"}
        }
    },
    "cloud_orchestawstemplate_autoscaletgwnewvpc": {
        "stated": true,
        "options": {
            "availability-zones": {"v_range": [["7.4.0", ""]], "type": "str"},
            "bgp-asn": {"v_range": [["7.4.0", ""]], "type": "int"},
            "custom-asset-container": {"v_range": [["7.4.0", ""]], "type": "str"},
            "custom-asset-directory": {"v_range": [["7.4.0", ""]], "type": "str"},
            "custom-identifier": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-autoscale-admin-password": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "raw"},
            "faz-autoscale-admin-username": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-custom-private-ipaddress": {"v_range": [["7.4.0", ""]], "type": "str"},
            "faz-instance-type": {
                "v_range": [["7.4.0", ""]],
                "choices": [
                    "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.12xlarge", "t2.medium",
                    "t2.large", "t2.xlarge"
                ],
                "type": "str"
            },
            "faz-integration-options": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "faz-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "fgt-admin-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "fgt-admin-port": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgt-instance-type": {
                "v_range": [["7.4.0", ""]],
                "choices": ["t2.small", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge"],
                "type": "str"
            },
            "fgt-psk-secret": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "fgtasg-cool-down": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-desired-capacity-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-desired-capacity-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-health-check-grace-period": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-max-size-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-max-size-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-min-size-byol": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-min-size-payg": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-scale-in-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fgtasg-scale-out-threshold": {"v_range": [["7.4.0", ""]], "type": "int"},
            "fos-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "get-license-grace-period": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-delay-allowance": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-interval": {"v_range": [["7.4.0", ""]], "type": "int"},
            "heartbeat-loss-count": {"v_range": [["7.4.0", ""]], "type": "int"},
            "key-pair-name": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "lifecycle-hook-timeout": {"v_range": [["7.4.0", ""]], "type": "int"},
            "name": {"v_range": [["7.4.0", ""]], "required": true, "type": "str"},
            "notification-email": {"v_range": [["7.4.0", ""]], "type": "str"},
            "primary-election-timeout": {"v_range": [["7.4.0", ""]], "type": "int"},
            "public-subnet1-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "public-subnet2-cidr": {"v_range": [["7.4.0", ""]], "type": "str"},
            "resource-tag-prefix": {"v_range": [["7.4.0", ""]], "type": "str"},
            "s3-bucket-name": {"v_range": [["7.4.0", ""]], "type": "str"},
            "s3-key-prefix": {"v_range": [["7.4.0", ""]], "no_log": true, "type": "str"},
            "sync-recovery-count": {"v_range": [["7.4.0", ""]], "type": "int"},
            "terminate-unhealthy-vm": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "transit-gateway-id": {"v_range": [["7.4.0", ""]], "type": "str"},
            "transit-gateway-support-options": {"v_range": [["7.4.0", ""]], "choices": ["create one", "use an existing one"], "type": "str"},
            "use-custom-asset-location": {"v_range": [["7.4.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "vpc-cidr": {"v_range": [["7.4.0", ""]], "type": "str"}
        }
    },
    "cloud_orchestration": {
        "stated": true,
        "options": {
            "configuration": {"v_range": [["7.4.0", ""]], "type": "str"},
            "description": {"v_range": [["7.4.0", ""]], "type": "str"},
            "name": {"v_range": [["7.4.0", ""]], "required": true, "type": "str"},
            "type": {"v_range": [["7.4.0", ""]], "choices": ["aws"], "type": "str"}
        }
    },
    "credentialstore_domaincontroller": {
        "stated": true,
        "options": {
            "domain-name": {"v_range": [["6.4.0", ""]], "type": "str"},
            "ip": {"v_range": [["6.4.0", ""]], "type": "str"},
            "ip6": {"v_range": [["6.4.0", ""]], "type": "str"},
            "password": {"v_range": [["6.4.0", ""]], "no_log": true, "type": "raw"},
            "port": {"v_range": [["6.4.0", ""]], "type": "int"},
            "server-name": {"v_range": [["6.4.0", ""]], "type": "str"},
            "username": {"v_range": [["6.4.0", ""]], "type": "str"},
            "hostname": {"v_range": [["6.4.2", ""]], "type": "str"}
        }
    },
    "devprof_device_profile_fortianalyzer": {
        "stated": false,
        "options": {
            "managed-sn": {"type": "str"},
            "target": {"choices": ["none", "this-fmg", "managed", "others"], "type": "str"},
            "target-ip": {"type": "str"},
            "target-sn": {"type": "raw"}
        }
    },
    "devprof_device_profile_fortiguard": {
        "stated": false,
        "options": {
            "target": {"choices": ["none", "direct", "this-fmg"], "type": "str"},
            "target-ip": {"type": "str"},
            "auto-firmware-upgrade": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "auto-firmware-upgrade-day": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "choices": ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"],
                "elements": "str"
            },
            "auto-firmware-upgrade-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
            "auto-firmware-upgrade-end-hour": {"v_range": [["7.4.1", ""]], "type": "int"},
            "auto-firmware-upgrade-start-hour": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "devprof_import": {
        "stated": true,
        "options": {
            "device": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "devprof": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_log_fortianalyzer_setting": {
        "stated": false,
        "options": {
            "certificate": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "conn-timeout": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "enc-algorithm": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["default", "high", "low", "disable", "high-medium", "low-medium"],
                "type": "str"
            },
            "hmac-algorithm": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["sha256", "sha1"], "type": "str"},
            "ips-archive": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "monitor-failure-retry-period": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "monitor-keepalive-period": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "reliable": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-min-proto-version": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["default", "TLSv1", "TLSv1-1", "TLSv1-2", "SSLv3", "TLSv1-3"],
                "type": "str"
            },
            "upload-day": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "upload-interval": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["daily", "weekly", "monthly"],
                "type": "str"
            },
            "upload-option": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["store-and-upload", "realtime", "1-minute", "5-minute"],
                "type": "str"
            },
            "upload-time": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "access-config": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "certificate-verification": {
                "v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["disable", "enable"],
                "type": "str"
            },
            "max-log-rate": {"v_range": [["6.2.2", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "priority": {"v_range": [["6.2.2", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["low", "default"], "type": "str"},
            "interface": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "type": "str"},
            "interface-select-method": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "preshared-key": {"v_range": [["7.0.0", ""]], "no_log": true, "type": "str"},
            "alt-server": {"v_range": [["7.2.2", ""]], "type": "str"},
            "fallback-to-primary": {"v_range": [["7.2.5", "7.2.11"], ["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "server-cert-ca": {"v_range": [["7.2.5", "7.2.11"], ["7.4.2", ""]], "type": "str"},
            "serial": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "source-ip": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "status": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "__change_ip": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "server": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "devprof_log_fortianalyzercloud_setting": {
        "stated": false,
        "options": {
            "__change_ip": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "access-config": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "certificate": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "conn-timeout": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "enc-algorithm": {
                "v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["high", "low", "high-medium", "low-medium"],
                "type": "str"
            },
            "hmac-algorithm": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["sha256", "sha1"], "type": "str"},
            "ips-archive": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "monitor-failure-retry-period": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "monitor-keepalive-period": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "source-ip": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "ssl-min-proto-version": {
                "v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["default", "TLSv1-1", "TLSv1-2", "SSLv3", "TLSv1", "TLSv1-3"],
                "type": "str"
            },
            "status": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "upload-day": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "upload-interval": {
                "v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["daily", "weekly", "monthly"],
                "type": "str"
            },
            "upload-option": {
                "v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["store-and-upload", "realtime", "1-minute", "5-minute"],
                "type": "str"
            },
            "upload-time": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "max-log-rate": {"v_range": [["6.2.2", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "priority": {"v_range": [["6.2.2", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["low", "default"], "type": "str"},
            "interface": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "type": "str"},
            "interface-select-method": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "preshared-key": {"v_range": [["7.0.0", ""]], "no_log": true, "type": "str"},
            "certificate-verification": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "serial": {"v_range": [["7.0.3", ""]], "type": "raw"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "devprof_log_syslogd_filter": {
        "stated": false,
        "options": {
            "severity": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["emergency", "alert", "critical", "error", "warning", "notification", "information", "debug"],
                "type": "str"
            },
            "anomaly": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude-list": {
                "v_range": [["7.0.4", "7.0.14"]],
                "type": "list",
                "options": {
                    "category": {
                        "v_range": [["7.0.4", "7.0.14"]],
                        "choices": ["app-ctrl", "attack", "dlp", "event", "traffic", "virus", "voip", "webfilter", "netscan", "spam", "anomaly", "waf"],
                        "type": "str"
                    },
                    "fields": {
                        "v_range": [["7.0.4", "7.0.14"]],
                        "type": "list",
                        "options": {
                            "args": {"v_range": [["7.0.4", "7.0.14"]], "type": "raw"},
                            "field": {"v_range": [["7.0.4", "7.0.14"]], "type": "str"},
                            "negate": {"v_range": [["7.0.4", "7.0.14"]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "id": {"v_range": [["7.0.4", "7.0.14"]], "type": "int"}
                },
                "elements": "dict"
            },
            "forward-traffic": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "free-style": {
                "v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]],
                "type": "list",
                "options": {
                    "category": {
                        "v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]],
                        "choices": [
                            "traffic", "event", "virus", "webfilter", "attack", "spam", "voip", "dlp", "app-ctrl", "anomaly", "waf", "gtp", "dns", "ssh",
                            "ssl", "file-filter", "icap", "ztna", "virtual-patch", "debug"
                        ],
                        "type": "str"
                    },
                    "filter": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"},
                    "filter-type": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["include", "exclude"], "type": "str"},
                    "id": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "gtp": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "local-traffic": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "multicast-traffic": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sniffer-traffic": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "voip": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ztna-traffic": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "filter-type": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["include", "exclude"], "type": "str"},
            "filter": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"},
            "cifs": {"v_range": [["7.0.4", "7.0.14"]], "choices": ["disable", "enable"], "type": "str"},
            "ssl": {"v_range": [["7.0.4", "7.0.14"]], "choices": ["disable", "enable"], "type": "str"},
            "dns": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "ssh": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "netscan-discovery": {"v_range": [["7.0.4", "7.0.14"]], "choices": ["disable", "enable"], "type": "str"},
            "netscan-vulnerability": {"v_range": [["7.0.4", "7.0.14"]], "choices": ["disable", "enable"], "type": "str"},
            "forti-switch": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-transaction": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "debug": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "devprof_log_syslogd_filter_excludelist": {
        "stated": true,
        "options": {
            "category": {
                "v_range": [["7.0.4", "7.0.14"]],
                "choices": ["app-ctrl", "attack", "dlp", "event", "traffic", "virus", "voip", "webfilter", "netscan", "spam", "anomaly", "waf"],
                "type": "str"
            },
            "fields": {
                "v_range": [["7.0.4", "7.0.14"]],
                "type": "list",
                "options": {
                    "args": {"v_range": [["7.0.4", "7.0.14"]], "type": "raw"},
                    "field": {"v_range": [["7.0.4", "7.0.14"]], "type": "str"},
                    "negate": {"v_range": [["7.0.4", "7.0.14"]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["7.0.4", "7.0.14"]], "required": true, "type": "int"}
        }
    },
    "devprof_log_syslogd_filter_excludelist_fields": {
        "stated": true,
        "options": {
            "args": {"v_range": [["7.0.4", "7.0.14"]], "type": "raw"},
            "field": {"v_range": [["7.0.4", "7.0.14"]], "type": "str"},
            "negate": {"v_range": [["7.0.4", "7.0.14"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "devprof_log_syslogd_filter_freestyle": {
        "stated": true,
        "options": {
            "category": {
                "v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]],
                "choices": [
                    "traffic", "event", "virus", "webfilter", "attack", "spam", "voip", "dlp", "app-ctrl", "anomaly", "waf", "gtp", "dns", "ssh", "ssl",
                    "file-filter", "icap", "ztna", "virtual-patch", "debug"
                ],
                "type": "str"
            },
            "filter": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"},
            "filter-type": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["include", "exclude"], "type": "str"},
            "id": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "required": true, "type": "int"}
        }
    },
    "devprof_log_syslogd_setting": {
        "stated": false,
        "options": {
            "certificate": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "enc-algorithm": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["high", "low", "disable", "high-medium"],
                "type": "str"
            },
            "facility": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": [
                    "kernel", "user", "mail", "daemon", "auth", "syslog", "lpr", "news", "uucp", "cron", "authpriv", "ftp", "ntp", "audit", "alert",
                    "clock", "local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7"
                ],
                "type": "str"
            },
            "mode": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["udp", "legacy-reliable", "reliable"], "type": "str"},
            "port": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "server": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "ssl-min-proto-version": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["default", "TLSv1-1", "TLSv1-2", "SSLv3", "TLSv1", "TLSv1-3"],
                "type": "str"
            },
            "status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "reliable": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "6.4.15"]], "choices": ["disable", "enable"], "type": "str"},
            "csv": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "max-log-rate": {"v_range": [["6.2.2", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "priority": {"v_range": [["6.2.2", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["low", "default"], "type": "str"},
            "interface": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "type": "str"},
            "interface-select-method": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "format": {"v_range": [["6.4.6", "6.4.15"], ["7.0.1", ""]], "choices": ["default", "csv", "cef", "rfc5424", "json"], "type": "str"},
            "syslog-type": {"v_range": [["6.2.0", "6.2.0"]], "type": "int"},
            "custom-field-name": {
                "v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]],
                "type": "list",
                "options": {
                    "custom": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"},
                    "id": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "int"},
                    "name": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "source-ip": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "source-ip-interface": {"v_range": [["7.6.0", ""]], "type": "raw"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "devprof_log_syslogd_setting_customfieldname": {
        "stated": true,
        "options": {
            "custom": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"},
            "id": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"}
        }
    },
    "devprof_system_centralmanagement": {
        "stated": false,
        "options": {
            "include-default-servers": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["disable", "enable"],
                "type": "str"
            },
            "server-list": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "type": "list",
                "options": {
                    "addr-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["fqdn", "ipv4", "ipv6"], "type": "str"},
                    "fqdn": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
                    "server-address": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "server-address6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "server-type": {
                        "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                        "type": "list",
                        "choices": ["update", "rating", "iot-query", "iot-collect", "vpatch-query"],
                        "elements": "str"
                    }
                },
                "elements": "dict"
            },
            "ltefw-upgrade-time": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "vdom": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "allow-remote-firmware-upgrade": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "local-cert": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "allow-push-firmware": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ltefw-upgrade-frequency": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["everyHour", "every12hour", "everyDay", "everyWeek"],
                "type": "str"
            },
            "mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["normal", "backup"], "type": "str"},
            "serial-number": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "fmg-source-ip6": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "allow-monitor": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "allow-push-configuration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ca-cert": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "fmg-update-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["443", "8890"], "type": "str"},
            "use-elbc-vdom": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "allow-remote-lte-firmware-upgrade": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "interface": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "schedule-script-restore": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "schedule-config-restore": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "interface-select-method": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "type": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["fortimanager", "fortiguard", "none"], "type": "str"},
            "fmg-source-ip": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "fortigate-cloud-sso-default-profile": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "fmg": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "enc-algorithm": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["default", "high", "low"], "type": "str"},
            "allow-remote-modem-firmware-upgrade": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "modem-upgrade-frequency": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["everyHour", "every12hour", "everyDay", "everyWeek"],
                "type": "str"
            },
            "modem-upgrade-time": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"},
            "fmg-update-http-header": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "devprof_system_centralmanagement_serverlist": {
        "stated": true,
        "options": {
            "addr-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["fqdn", "ipv4", "ipv6"], "type": "str"},
            "fqdn": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "required": true, "type": "int"},
            "server-address": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "server-address6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "server-type": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "type": "list",
                "choices": ["update", "rating", "iot-query", "iot-collect", "vpatch-query"],
                "elements": "str"
            }
        }
    },
    "devprof_system_dns": {
        "stated": false,
        "options": {
            "cache-notfound-responses": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "choices": ["disable", "enable"], "type": "str"},
            "dns-cache-limit": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "int"},
            "dns-cache-ttl": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "int"},
            "domain": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "raw"},
            "ip6-primary": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "str"},
            "ip6-secondary": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "str"},
            "primary": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "str"},
            "secondary": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "str"},
            "dns-over-tls": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"]], "choices": ["disable", "enable", "enforce"], "type": "str"},
            "retry": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "int"},
            "server-hostname": {"v_range": [["6.2.1", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "raw"},
            "ssl-certificate": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "str"},
            "timeout": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"]], "type": "int"},
            "interface": {"v_range": [["6.2.5", "6.2.5"], ["6.2.7", "6.2.13"], ["6.4.1", "6.4.1"]], "type": "str"},
            "interface-select-method": {
                "v_range": [["6.2.5", "6.2.5"], ["6.2.7", "6.2.13"], ["6.4.1", "6.4.1"]],
                "choices": ["auto", "sdwan", "specify"],
                "type": "str"
            }
        }
    },
    "devprof_system_emailserver": {
        "stated": false,
        "options": {
            "authenticate": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "password": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "no_log": true, "type": "raw"},
            "port": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "reply-to": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "security": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "starttls", "smtps"], "type": "str"},
            "server": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "source-ip": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "source-ip6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "ssl-min-proto-version": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["default", "TLSv1", "TLSv1-1", "TLSv1-2", "SSLv3", "TLSv1-3"],
                "type": "str"
            },
            "type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["custom"], "type": "str"},
            "username": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "validate-server": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "interface": {"v_range": [["7.0.0", ""]], "type": "str"},
            "interface-select-method": {"v_range": [["7.0.0", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "devprof_system_global": {
        "stated": false,
        "options": {
            "admin-https-redirect": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-port": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "admin-scp": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-sport": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "admin-ssh-port": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "admin-ssh-v1": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-telnet-port": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.2.4"], ["7.2.6", "7.4.1"], ["7.4.3", ""]],
                "type": "int"
            },
            "admintimeout": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "gui-ipv6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-lines-per-page": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "gui-theme": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": [
                    "blue", "green", "melongene", "red", "mariner", "neutrino", "jade", "graphite", "dark-matter", "onyx", "eclipse", "retro", "fpx",
                    "jet-stream", "security-fabric"
                ],
                "type": "str"
            },
            "language": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["english", "simch", "japanese", "korean", "spanish", "trach", "french", "portuguese"],
                "type": "str"
            },
            "switch-controller": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.2.0"], ["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["disable", "enable"],
                "type": "str"
            },
            "gui-device-latitude": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "gui-device-longitude": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "hostname": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "timezone": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": [
                    "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21",
                    "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43",
                    "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65",
                    "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87"
                ],
                "elements": "str"
            },
            "check-reset-range": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "strict"], "type": "str"},
            "pmtu-discovery": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-allow-incompatible-fabric-fgt": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-restrict-local": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["disable", "enable", "all", "non-console-only"],
                "type": "str"
            },
            "gui-workflow-management": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "send-pmtu-icmp": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tcp-halfclose-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-server-cert": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "dnsproxy-worker-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "show-backplane-intf": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-custom-language": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ldapconntimeout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "auth-https-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "revision-backup-on-logout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "arp-max-entry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "long-vdom-name": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pre-login-banner": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "qsfpdd-split8-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "max-route-cache-size": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "fortitoken-cloud-push-status": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-hostkey-override": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "proxy-hardware-acceleration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "switch-controller-reserved-network": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "ssd-trim-date": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "wad-worker-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ssh-hostkey": {"v_range": [["7.4.3", ""]], "no_log": true, "type": "str"},
            "wireless-controller-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "fgd-alert-subscription": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": ["advisory", "latest-threat", "latest-virus", "latest-attack", "new-antivirus-db", "new-attack-db"],
                "elements": "str"
            },
            "forticontroller-proxy-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "dh-params": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["1024", "1536", "2048", "3072", "4096", "6144", "8192"],
                "type": "str"
            },
            "memory-use-threshold-green": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "proxy-cert-use-mgmt-vdom": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "proxy-auth-lifetime-timeout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "gui-auto-upgrade-setup-warning": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-cdn-usage": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "two-factor-email-expiry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "udp-idle-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "interface-subnet-usage": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "forticontroller-proxy": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-enc-algo": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": [
                    "chacha20-poly1305@openssh.com", "aes128-ctr", "aes192-ctr", "aes256-ctr", "arcfour256", "arcfour128", "aes128-cbc", "3des-cbc",
                    "blowfish-cbc", "cast128-cbc", "aes192-cbc", "aes256-cbc", "arcfour", "rijndael-cbc@lysator.liu.se", "aes128-gcm@openssh.com",
                    "aes256-gcm@openssh.com"
                ],
                "elements": "str"
            },
            "block-session-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "quic-pmtud": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-https-ssl-ciphersuites": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": [
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-AES-128-CCM-SHA256",
                    "TLS-AES-128-CCM-8-SHA256"
                ],
                "elements": "str"
            },
            "security-rating-result-submission": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "user-device-store-max-unified-mem": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "management-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "fortigslb-integration": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-https-ssl-versions": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": ["tlsv1-0", "tlsv1-1", "tlsv1-2", "sslv3", "tlsv1-3"],
                "elements": "str"
            },
            "cert-chain-max": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "qsfp28-40g-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "strong-crypto": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "multi-factor-authentication": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["optional", "mandatory"], "type": "str"},
            "fds-statistics": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-display-hostname": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "two-factor-ftk-expiry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "wad-source-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-static-key-ciphers": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "daily-restart": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "snat-route-change": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tcp-rst-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "anti-replay": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "loose", "strict"], "type": "str"},
            "ssl-min-proto-version": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["TLSv1", "TLSv1-1", "TLSv1-2", "SSLv3", "TLSv1-3"],
                "type": "str"
            },
            "speedtestd-server-port": {"v_range": [["7.4.3", ""]], "type": "int"},
            "cpu-use-threshold": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-host": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "csr-ca-attribute": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortiservice-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ssd-trim-hour": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "purdue-level": {"v_range": [["7.4.3", ""]], "choices": ["1", "2", "3", "4", "5", "1.5", "2.5", "3.5", "5.5"], "type": "str"},
            "management-vdom": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "quic-ack-thresold": {"v_range": [["7.4.3", ""]], "type": "int"},
            "qsfpdd-100g-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "ips-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "vip-arp-range": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["restricted", "unlimited"], "type": "str"},
            "internet-service-database": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["mini", "standard", "full", "on-demand"],
                "type": "str"
            },
            "revision-image-auto-backup": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sflowd-max-children-num": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-https-pki-required": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "special-file-23-support": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "npu-neighbor-update": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "log-single-cpu-high": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "management-ip": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "proxy-resource-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-ble-button": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-firmware-upgrade-warning": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "dp-tcp-normal-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ipv6-allow-traffic-redirect": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cli-audit-log": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "memory-use-threshold-extreme": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ha-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "restart-time": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "speedtestd-ctrl-port": {"v_range": [["7.4.3", ""]], "type": "int"},
            "gui-wireless-opensecurity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "memory-use-threshold-red": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "dp-fragment-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "wad-restart-start-time": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "proxy-re-authentication-time": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "gui-app-detection-sdwan": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "scanunit-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "tftp": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "xstools-update-frequency": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "clt-cert-req": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortiextender-vlan-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "auth-http-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "per-user-bal": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-date-format": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["yyyy/MM/dd", "dd/MM/yyyy", "MM/dd/yyyy", "yyyy-MM-dd", "dd-MM-yyyy", "MM-dd-yyyy"],
                "type": "str"
            },
            "log-uuid-address": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cloud-communication": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "lldp-reception": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "two-factor-ftm-expiry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "quic-udp-payload-size-shaping-per-cid": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "autorun-log-fsck": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "vpn-ems-sn-check": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-ssh-password": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "airplane-mode": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "batch-cmdb": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ip-src-port-range": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "strict-dirty-session-check": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "user-device-store-max-devices": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "dp-udp-idle-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "internal-switch-speed": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": ["auto", "10full", "10half", "100full", "100half", "1000full", "1000auto"],
                "elements": "str"
            },
            "forticonverter-config-upload": {"v_range": [["7.4.3", ""]], "choices": ["disable", "once"], "type": "str"},
            "ipsec-round-robin": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "wad-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "wifi-ca-certificate": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "wimax-4g-usb": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "miglog-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "faz-disk-buffer-size": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ssh-kex-algo": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": [
                    "diffie-hellman-group1-sha1", "diffie-hellman-group14-sha1", "diffie-hellman-group-exchange-sha1",
                    "diffie-hellman-group-exchange-sha256", "curve25519-sha256@libssh.org", "ecdh-sha2-nistp256", "ecdh-sha2-nistp384",
                    "ecdh-sha2-nistp521", "diffie-hellman-group14-sha256", "diffie-hellman-group16-sha512", "diffie-hellman-group18-sha512"
                ],
                "elements": "str"
            },
            "auto-auth-extension-device": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "forticarrier-bypass": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "reset-sessionless-tcp": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "early-tcp-npu-session": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-unauthenticated-request-limit": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "gui-local-out": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tcp-option": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "proxy-auth-timeout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "fortiextender-discovery-lockdown": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "lldp-transmission": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "split-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "gui-certificates": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cfg-save": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["automatic", "manual", "revert"], "type": "str"},
            "auth-keepalive": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "split-port-mode": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "options": {
                    "interface": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
                    "split-mode": {
                        "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                        "choices": ["disable", "4x10G", "4x25G", "4x50G", "8x50G", "4x100G", "2x200G", "8x25G"],
                        "type": "str"
                    }
                },
                "elements": "dict"
            },
            "admin-forticloud-sso-login": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "post-login-banner": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "br-fdb-max-entry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ip-fragment-mem-thresholds": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "fortiextender-provision-on-authorization": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "reboot-upon-config-restore": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "syslog-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "fortiextender-data-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "quic-tls-handshake-timeout": {"v_range": [["7.4.3", ""]], "type": "int"},
            "forticonverter-integration": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "proxy-keep-alive-mode": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["session", "traffic", "re-authentication"],
                "type": "str"
            },
            "cmdbsvr-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "wad-memory-change-granularity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "dhcp-lease-backup-interval": {"v_range": [["7.4.3", ""]], "type": "int"},
            "check-protocol-header": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["loose", "strict"], "type": "str"},
            "av-failopen-session": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ipsec-ha-seqjump-rate": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-hsts-max-age": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "igmp-state-limit": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-login-max": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ipv6-allow-multicast-probe": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "virtual-switch-vlan": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-lockout-threshold": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "dp-pinhole-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "wireless-controller": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "bfd-affinity": {"v_range": [["7.4.3", ""]], "type": "str"},
            "ssd-trim-freq": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["daily", "weekly", "monthly", "hourly", "never"],
                "type": "str"
            },
            "two-factor-sms-expiry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "traffic-priority": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["tos", "dscp"], "type": "str"},
            "proxy-and-explicit-proxy": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sslvpn-web-mode": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-hostkey-password": {"v_range": [["7.4.3", ""]], "no_log": true, "type": "raw"},
            "wad-csvc-db-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ipv6-allow-anycast-probe": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "honor-df": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "hyper-scale-vdom-num": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "wad-csvc-cs-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "internal-switch-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["switch", "interface", "hub"], "type": "str"},
            "cfg-revert-timeout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-concurrent": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ipv6-allow-local-in-silent-drop": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tcp-halfopen-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "dp-rsync-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "management-port-use-admin-sport": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-forticare-registration-setup-warning": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-replacement-message-groups": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "security-rating-run-on-schedule": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-lockout-duration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "optimize-flow-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "private-data-encryption": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "wireless-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["ac", "client", "wtp", "fwfap"], "type": "str"},
            "alias": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "ssh-hostkey-algo": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": ["ssh-rsa", "ecdsa-sha2-nistp521", "rsa-sha2-256", "rsa-sha2-512", "ssh-ed25519", "ecdsa-sha2-nistp384", "ecdsa-sha2-nistp256"],
                "elements": "str"
            },
            "fortitoken-cloud": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "av-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "proxy-worker-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ipsec-asic-offload": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "miglogd-children": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "sslvpn-max-worker-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ssh-mac-algo": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": [
                    "hmac-md5", "hmac-md5-etm@openssh.com", "hmac-md5-96", "hmac-md5-96-etm@openssh.com", "hmac-sha1", "hmac-sha1-etm@openssh.com",
                    "hmac-sha2-256", "hmac-sha2-256-etm@openssh.com", "hmac-sha2-512", "hmac-sha2-512-etm@openssh.com", "hmac-ripemd160",
                    "hmac-ripemd160@openssh.com", "hmac-ripemd160-etm@openssh.com", "umac-64@openssh.com", "umac-128@openssh.com",
                    "umac-64-etm@openssh.com", "umac-128-etm@openssh.com"
                ],
                "elements": "str"
            },
            "url-filter-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "wifi-certificate": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "radius-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "sys-perf-log-interval": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "gui-fortigate-cloud-sandbox": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "auth-cert": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "fortiextender": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-reset-button": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "av-failopen": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["off", "pass", "one-shot", "idledrop"], "type": "str"},
            "user-device-store-max-users": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "auth-session-limit": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["block-new", "logout-inactive"], "type": "str"},
            "ipv6-allow-local-in-slient-drop": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "quic-congestion-control-algo": {"v_range": [["7.4.3", ""]], "choices": ["cubic", "bbr", "bbr2", "reno"], "type": "str"},
            "auth-ike-saml-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "wad-restart-end-time": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "http-request-limit": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "irq-time-accounting": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["auto", "force"], "type": "str"},
            "remoteauthtimeout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-https-ssl-banned-ciphers": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "type": "list",
                "choices": [
                    "RSA", "DHE", "ECDHE", "DSS", "ECDSA", "AES", "AESGCM", "CAMELLIA", "3DES", "SHA1", "SHA256", "SHA384", "STATIC", "CHACHA20", "ARIA",
                    "AESCCM"
                ],
                "elements": "str"
            },
            "allow-traffic-redirect": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "legacy-poe-device-support": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "wad-restart-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["none", "time", "memory"], "type": "str"},
            "fds-statistics-period": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-telnet": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ipv6-accept-dad": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "tcp-timewait-timer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "admin-console-timeout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "default-service-source-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "quic-max-datagram-size": {"v_range": [["7.4.3", ""]], "type": "int"},
            "refresh": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "extender-controller-reserved-network": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "url-filter-affinity": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "policy-auth-concurrent": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ipsec-hmac-offload": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "traffic-priority-level": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["high", "medium", "low"], "type": "str"},
            "ipsec-qat-offload": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssd-trim-min": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "gui-date-time-source": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["system", "browser"], "type": "str"},
            "log-ssl-connection": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ndp-max-entry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "vdom-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["no-vdom", "multi-vdom", "split-vdom"], "type": "str"},
            "internet-service-download-list": {"v_range": [["7.4.3", ""]], "type": "raw"},
            "fortitoken-cloud-sync-interval": {"v_range": [["7.4.3", ""]], "no_log": true, "type": "int"},
            "ssd-trim-weekday": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"],
                "type": "str"
            },
            "two-factor-fac-expiry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "gui-rest-api-cache": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-forticloud-sso-default-profile": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "proxy-auth-lifetime": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "device-idle-timeout": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "login-timestamp": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "speedtest-server": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "edit-vdom-prompt": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-cdn-domain-override": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "admin-ssh-grace-time": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "sslvpn-ems-sn-check": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "user-server-cert": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "gui-allow-default-hostname": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "proxy-re-authentication-mode": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["session", "traffic", "absolute"],
                "type": "str"
            },
            "ipsec-soft-dec-async": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "admin-maintainer": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "dst": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fec-port": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ssh-kex-sha1": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-mac-weak": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sslvpn-cipher-hardware-acceleration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sys-file-check-interval": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "ssh-hmac-md5": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-cbc-cipher": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-fortiguard-resource-fetch": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sslvpn-kxp-hardware-acceleration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sslvpn-plugin-version-check": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortiipam-integration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-firmware-upgrade-setup-warning": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "log-uuid-policy": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "per-user-bwl": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gui-fortisandbox-cloud": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortitoken-cloud-service": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "hw-switch-ether-filter": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "virtual-server-count": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", "7.6.2"]], "type": "int"},
            "endpoint-control-fds-access": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "proxy-cipher-hardware-acceleration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "proxy-kxp-hardware-acceleration": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "virtual-server-hardware-acceleration": {
                "v_range": [["7.2.6", "7.2.11"], ["7.4.3", "7.6.2"]],
                "choices": ["disable", "enable"],
                "type": "str"
            },
            "user-history-password-threshold": {"v_range": [["7.6.0", ""]], "no_log": true, "type": "int"},
            "delay-tcp-npu-session": {"v_range": [["7.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "auth-session-auto-backup-interval": {"v_range": [["7.6.0", ""]], "choices": ["1min", "5min", "15min", "30min", "1hr"], "type": "str"},
            "ip-conflict-detection": {"v_range": [["7.4.7", ""]], "choices": ["disable", "enable"], "type": "str"},
            "gtpu-dynamic-source-port": {"v_range": [["7.4.6", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ip-fragment-timeout": {"v_range": [["7.6.0", ""]], "type": "int"},
            "ipv6-fragment-timeout": {"v_range": [["7.6.0", ""]], "type": "int"},
            "scim-server-cert": {"v_range": [["7.6.0", ""]], "type": "raw"},
            "scim-http-port": {"v_range": [["7.6.0", ""]], "type": "int"},
            "auth-session-auto-backup": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "scim-https-port": {"v_range": [["7.6.0", ""]], "type": "int"},
            "httpd-max-worker-count": {"v_range": [["7.6.0", ""]], "type": "int"},
            "rest-api-key-url-query": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "single-vdom-npuvlink": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "slbc-fragment-mem-thresholds": {"v_range": [["7.6.2", ""]], "type": "int"},
            "upgrade-report": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "application-bandwidth-tracking": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortitoken-cloud-region": {"v_range": [["7.4.7", "7.4.7"]], "no_log": true, "type": "str"},
            "black-box-interval": {"v_range": [["7.2.10", "7.2.11"], ["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"},
            "black-box": {"v_range": [["7.2.10", "7.2.11"], ["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tls-session-cache": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "wad-p2s-max-body-size": {"v_range": [["7.6.3", ""]], "type": "int"},
            "telemetry-controller": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "telemetry-data-port": {"v_range": [["7.6.3", ""]], "type": "int"},
            "user-device-store-max-device-mem": {"v_range": [["7.6.3", ""]], "type": "int"},
            "sslvpn-affinity": {"v_range": [["7.6.3", ""]], "type": "str"}
        }
    },
    "devprof_system_ntp": {
        "stated": false,
        "options": {
            "ntpserver": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "type": "list",
                "options": {
                    "authentication": {
                        "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                        "choices": ["disable", "enable"],
                        "type": "str"
                    },
                    "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
                    "key": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "no_log": true, "type": "raw"},
                    "key-id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "no_log": true, "type": "int"},
                    "ntpv3": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "server": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "interface": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", "7.0.2"], ["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
                    "interface-select-method": {
                        "v_range": [["6.2.7", "6.2.13"], ["6.4.3", "7.0.2"], ["7.2.6", "7.2.11"], ["7.4.3", ""]],
                        "choices": ["auto", "sdwan", "specify"],
                        "type": "str"
                    },
                    "ip-type": {"v_range": [["7.4.2", ""]], "choices": ["IPv6", "IPv4", "Both"], "type": "str"},
                    "key-type": {"v_range": [["7.4.3", ""]], "choices": ["SHA1", "SHA256", "MD5"], "type": "str"},
                    "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "ntpsync": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "source-ip6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "syncinterval": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["fortiguard", "custom"], "type": "str"},
            "authentication": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "key": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "no_log": true, "type": "raw"},
            "key-id": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "no_log": true, "type": "int"},
            "key-type": {"v_range": [["6.2.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["MD5", "SHA1", "SHA256"], "type": "str"},
            "interface": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "raw"},
            "server-mode": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "source-ip": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_ntp_ntpserver": {
        "stated": true,
        "options": {
            "authentication": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "required": true, "type": "int"},
            "key": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "no_log": true, "type": "raw"},
            "key-id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "no_log": true, "type": "int"},
            "ntpv3": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "server": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "interface": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", "7.0.2"], ["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "interface-select-method": {
                "v_range": [["6.2.7", "6.2.13"], ["6.4.3", "7.0.2"], ["7.2.6", "7.2.11"], ["7.4.3", ""]],
                "choices": ["auto", "sdwan", "specify"],
                "type": "str"
            },
            "ip-type": {"v_range": [["7.4.2", ""]], "choices": ["IPv6", "IPv4", "Both"], "type": "str"},
            "key-type": {"v_range": [["7.4.3", ""]], "choices": ["SHA1", "SHA256", "MD5"], "type": "str"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "devprof_system_replacemsg_admin": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_alertmail": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_auth": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_devicedetectionportal": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_ec": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.2.1"]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.2.1"]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.2.1"]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.2.1"]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_fortiguardwf": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_ftp": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_http": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_mail": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_mms": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.6.2"]], "type": "str"},
            "charset": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.6.2"]], "choices": ["us-ascii", "utf-8"], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.6.2"]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.6.2"]], "choices": ["none", "http", "8bit"], "type": "str"},
            "image": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.6.2"]], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", "7.6.2"]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_nacquar": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_nntp": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_spam": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_sslvpn": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_trafficquota": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_utm": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "text", "html", "wml"], "type": "str"},
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_replacemsg_webproxy": {
        "stated": false,
        "options": {
            "buffer": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "format": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["none", "text", "html", "wml", "opt:none"],
                "type": "str"
            },
            "header": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["none", "http", "8bit", "opt:none"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"}
        }
    },
    "devprof_system_snmp_community": {
        "stated": true,
        "options": {
            "events": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "type": "list",
                "choices": [
                    "cpu-high", "mem-low", "log-full", "intf-ip", "vpn-tun-up", "vpn-tun-down", "ha-switch", "ha-hb-failure", "ips-signature",
                    "ips-anomaly", "av-virus", "av-oversize", "av-pattern", "av-fragmented", "fm-if-change", "fm-conf-change", "temperature-high",
                    "voltage-alert", "ha-member-up", "ha-member-down", "ent-conf-change", "av-conserve", "av-bypass", "av-oversize-passed",
                    "av-oversize-blocked", "ips-pkg-update", "power-supply-failure", "amc-bypass", "faz-disconnect", "fan-failure", "bgp-established",
                    "bgp-backward-transition", "wc-ap-up", "wc-ap-down", "fswctl-session-up", "fswctl-session-down", "ips-fail-open",
                    "load-balance-real-server-down", "device-new", "enter-intf-bypass", "exit-intf-bypass", "per-cpu-high", "power-blade-down",
                    "confsync_failure", "dhcp", "pool-usage", "power-redundancy-degrade", "power-redundancy-failure", "ospf-nbr-state-change",
                    "ospf-virtnbr-state-change", "disk-failure", "disk-overload", "faz-main-failover", "faz-alt-failover", "slbc", "faz", "power-supply",
                    "ippool", "interface", "security_level_change", "cert-expiry", "dio"
                ],
                "elements": "str"
            },
            "hosts": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "type": "list",
                "options": {
                    "ha-direct": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "host-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["any", "query", "trap"], "type": "str"},
                    "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
                    "ip": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "source-ip": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "interface-select-method": {"v_range": [["7.6.0", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
                    "interface": {"v_range": [["7.6.0", ""]], "type": "raw"},
                    "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "hosts6": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "type": "list",
                "options": {
                    "ha-direct": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "host-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["any", "query", "trap"], "type": "str"},
                    "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
                    "ipv6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "source-ipv6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
                    "interface": {"v_range": [["7.6.0", ""]], "type": "raw"},
                    "interface-select-method": {"v_range": [["7.6.0", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
                    "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "query-v1-port": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "query-v1-status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "query-v2c-port": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "query-v2c-status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "trap-v1-lport": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "trap-v1-rport": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "trap-v1-status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "trap-v2c-lport": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "trap-v2c-rport": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "trap-v2c-status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "mib-view": {"v_range": [["7.2.0", ""]], "type": "str"},
            "vdoms": {"v_range": [["7.2.0", ""]], "type": "raw"}
        }
    },
    "devprof_system_snmp_community_hosts": {
        "stated": true,
        "options": {
            "ha-direct": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "host-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["any", "query", "trap"], "type": "str"},
            "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "required": true, "type": "int"},
            "ip": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "source-ip": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "interface-select-method": {"v_range": [["7.6.0", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "interface": {"v_range": [["7.6.0", ""]], "type": "raw"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "devprof_system_snmp_community_hosts6": {
        "stated": true,
        "options": {
            "ha-direct": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "host-type": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["any", "query", "trap"], "type": "str"},
            "id": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "required": true, "type": "int"},
            "ipv6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "source-ipv6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "interface": {"v_range": [["7.6.0", ""]], "type": "raw"},
            "interface-select-method": {"v_range": [["7.6.0", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "devprof_system_snmp_sysinfo": {
        "stated": false,
        "options": {
            "status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "append-index": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "trap-high-cpu-threshold": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "trap-log-full-threshold": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "engine-id": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "trap-freeable-memory-threshold": {"v_range": [["7.4.3", ""]], "type": "int"},
            "contact-info": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "engine-id-type": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "choices": ["text", "hex", "mac"], "type": "str"},
            "description": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "trap-free-memory-threshold": {"v_range": [["7.4.3", ""]], "type": "int"},
            "trap-low-memory-threshold": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "int"},
            "location": {"v_range": [["7.2.6", "7.2.11"], ["7.4.3", ""]], "type": "str"},
            "non-mgmt-vdom-query": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "devprof_system_snmp_user": {
        "stated": true,
        "options": {
            "auth-proto": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["md5", "sha", "sha224", "sha256", "sha384", "sha512"],
                "type": "str"
            },
            "auth-pwd": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "raw"},
            "events": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "type": "list",
                "choices": [
                    "cpu-high", "mem-low", "log-full", "intf-ip", "vpn-tun-up", "vpn-tun-down", "ha-switch", "fm-conf-change", "ips-signature",
                    "ips-anomaly", "temperature-high", "voltage-alert", "av-virus", "av-oversize", "av-pattern", "av-fragmented", "ha-hb-failure",
                    "fan-failure", "ha-member-up", "ha-member-down", "ent-conf-change", "av-conserve", "av-bypass", "av-oversize-passed",
                    "av-oversize-blocked", "ips-pkg-update", "fm-if-change", "power-supply-failure", "amc-bypass", "faz-disconnect", "bgp-established",
                    "bgp-backward-transition", "wc-ap-up", "wc-ap-down", "fswctl-session-up", "fswctl-session-down", "ips-fail-open",
                    "load-balance-real-server-down", "device-new", "enter-intf-bypass", "exit-intf-bypass", "per-cpu-high", "power-blade-down",
                    "confsync_failure", "dhcp", "pool-usage", "power-redundancy-degrade", "power-redundancy-failure", "ospf-nbr-state-change",
                    "ospf-virtnbr-state-change", "disk-failure", "disk-overload", "faz-main-failover", "faz-alt-failover", "slbc", "faz", "power-supply",
                    "ippool", "interface", "security_level_change", "cert-expiry", "dio"
                ],
                "elements": "str"
            },
            "ha-direct": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "required": true, "type": "str"},
            "notify-hosts": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "raw"},
            "notify-hosts6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "priv-proto": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["aes", "des", "aes256", "aes256cisco"],
                "type": "str"
            },
            "priv-pwd": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "raw"},
            "queries": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "query-port": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "security-level": {
                "v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]],
                "choices": ["no-auth-no-priv", "auth-no-priv", "auth-priv"],
                "type": "str"
            },
            "source-ip": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "source-ipv6": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "str"},
            "status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "trap-lport": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "trap-rport": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "type": "int"},
            "trap-status": {"v_range": [["6.0.0", "6.2.5"], ["6.2.7", "6.4.1"], ["6.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "mib-view": {"v_range": [["7.2.0", ""]], "type": "str"},
            "vdoms": {"v_range": [["7.2.0", ""]], "type": "raw"},
            "interface": {"v_range": [["7.6.0", ""]], "type": "raw"},
            "interface-select-method": {"v_range": [["7.6.0", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "vrf-select": {"v_range": [["7.6.2", ""]], "type": "int"}
        }
    },
    "diameterfilter_profile": {
        "stated": true,
        "options": {
            "cmd-flags-reserve-set": {"v_range": [["7.4.2", ""]], "choices": ["block", "reset", "monitor", "allow"], "type": "str"},
            "command-code-invalid": {"v_range": [["7.4.2", ""]], "choices": ["block", "reset", "monitor", "allow"], "type": "str"},
            "command-code-range": {"v_range": [["7.4.2", ""]], "type": "str"},
            "comment": {"v_range": [["7.4.2", ""]], "type": "str"},
            "log-packet": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "message-length-invalid": {"v_range": [["7.4.2", ""]], "choices": ["block", "reset", "monitor", "allow"], "type": "str"},
            "missing-request-action": {"v_range": [["7.4.2", ""]], "choices": ["block", "reset", "monitor", "allow"], "type": "str"},
            "monitor-all-messages": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["7.4.2", ""]], "required": true, "type": "str"},
            "protocol-version-invalid": {"v_range": [["7.4.2", ""]], "choices": ["block", "reset", "monitor", "allow"], "type": "str"},
            "request-error-flag-set": {"v_range": [["7.4.2", ""]], "choices": ["block", "reset", "monitor", "allow"], "type": "str"},
            "track-requests-answers": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dlp_datatype": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.2.0", ""]], "type": "str"},
            "look-ahead": {"v_range": [["7.2.0", ""]], "type": "int"},
            "look-back": {"v_range": [["7.2.0", ""]], "type": "int"},
            "name": {"v_range": [["7.2.0", ""]], "required": true, "type": "str"},
            "pattern": {"v_range": [["7.2.0", ""]], "type": "str"},
            "transform": {"v_range": [["7.2.0", ""]], "type": "str"},
            "verify": {"v_range": [["7.2.0", ""]], "type": "str"},
            "verify-transformed-pattern": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "match-around": {"v_range": [["7.4.0", ""]], "type": "str"},
            "match-ahead": {"v_range": [["7.4.2", ""]], "type": "int"},
            "match-back": {"v_range": [["7.4.2", ""]], "type": "int"},
            "verify2": {"v_range": [["7.4.2", ""]], "type": "str"},
            "fgd-id": {"v_range": [["7.6.0", ""]], "type": "int"}
        }
    },
    "dlp_dictionary": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.2.0", ""]], "type": "str"},
            "entries": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "options": {
                    "comment": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "id": {"v_range": [["7.2.0", ""]], "type": "int"},
                    "ignore-case": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pattern": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "repeat": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["7.2.0", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "match-type": {"v_range": [["7.2.0", ""]], "choices": ["match-all", "match-any"], "type": "str"},
            "name": {"v_range": [["7.2.0", ""]], "required": true, "type": "str"},
            "uuid": {"v_range": [["7.2.0", ""]], "type": "str"},
            "match-around": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fgd-id": {"v_range": [["7.6.0", ""]], "type": "int"}
        }
    },
    "dlp_dictionary_entries": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.2.0", ""]], "type": "str"},
            "id": {"v_range": [["7.2.0", ""]], "required": true, "type": "int"},
            "ignore-case": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pattern": {"v_range": [["7.2.0", ""]], "type": "str"},
            "repeat": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["7.2.0", ""]], "type": "str"}
        }
    },
    "dlp_exactdatamatch": {
        "stated": true,
        "options": {
            "columns": {
                "v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]],
                "type": "list",
                "options": {
                    "index": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"},
                    "optional": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "list", "elements": "str"}
                },
                "elements": "dict"
            },
            "data": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "list", "elements": "str"},
            "name": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "required": true, "type": "str"},
            "optional": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"}
        }
    },
    "dlp_exactdatamatch_columns": {
        "stated": true,
        "options": {
            "index": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"},
            "optional": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "list", "elements": "str"}
        }
    },
    "dlp_filepattern": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "entries": {
                "type": "list",
                "options": {
                    "file-type": {
                        "choices": [
                            "unknown", "ignored", "exe", "elf", "bat", "javascript", "html", "hta", "msoffice", "gzip", "rar", "tar", "lzh", "upx",
                            "zip", "cab", "bzip2", "bzip", "activemime", "mime", "hlp", "arj", "base64", "binhex", "uue", "fsg", "aspack", "msc",
                            "petite", "jpeg", "gif", "tiff", "png", "bmp", "msi", "mpeg", "mov", "mp3", "wma", "wav", "pdf", "avi", "rm", "torrent",
                            "hibun", "7z", "xz", "msofficex", "mach-o", "dmg", ".net", "xar", "chm", "iso", "crx", "sis", "prc", "class", "jad", "cod",
                            "flac", "registry", "hwp", "rpm", "c/cpp", "pfile", "lzip", "wasm", "sylk", "shellscript", "dll", "jnlp"
                        ],
                        "type": "str"
                    },
                    "filter-type": {"choices": ["pattern", "type"], "type": "str"},
                    "pattern": {"type": "str"}
                },
                "elements": "dict"
            },
            "id": {"required": true, "type": "int"},
            "name": {"type": "str"}
        }
    },
    "dlp_filepattern_entries": {
        "stated": true,
        "options": {
            "file-type": {
                "choices": [
                    "unknown", "ignored", "exe", "elf", "bat", "javascript", "html", "hta", "msoffice", "gzip", "rar", "tar", "lzh", "upx", "zip", "cab",
                    "bzip2", "bzip", "activemime", "mime", "hlp", "arj", "base64", "binhex", "uue", "fsg", "aspack", "msc", "petite", "jpeg", "gif",
                    "tiff", "png", "bmp", "msi", "mpeg", "mov", "mp3", "wma", "wav", "pdf", "avi", "rm", "torrent", "hibun", "7z", "xz", "msofficex",
                    "mach-o", "dmg", ".net", "xar", "chm", "iso", "crx", "sis", "prc", "class", "jad", "cod", "flac", "registry", "hwp", "rpm", "c/cpp",
                    "pfile", "lzip", "wasm", "sylk", "shellscript", "dll", "jnlp"
                ],
                "type": "str"
            },
            "filter-type": {"choices": ["pattern", "type"], "type": "str"},
            "pattern": {"type": "str"}
        }
    },
    "dlp_fpsensitivity": {"stated": true, "options": {"name": {"v_range": [["6.0.0", "7.2.1"]], "required": true, "type": "str"}}},
    "dlp_label": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.6.3", ""]], "type": "str"},
            "connector": {"v_range": [["7.6.3", ""]], "type": "list", "elements": "str"},
            "entries": {
                "v_range": [["7.6.3", ""]],
                "type": "list",
                "options": {
                    "guid": {"v_range": [["7.6.3", ""]], "type": "str"},
                    "id": {"v_range": [["7.6.3", ""]], "type": "int"},
                    "mpip-label-name": {"v_range": [["7.6.3", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "mpip-type": {"v_range": [["7.6.3", ""]], "choices": ["local", "remote"], "type": "str"},
            "name": {"v_range": [["7.6.3", ""]], "required": true, "type": "str"},
            "type": {"v_range": [["7.6.3", ""]], "choices": ["mpip"], "type": "str"}
        }
    },
    "dlp_label_entries": {
        "stated": true,
        "options": {
            "guid": {"v_range": [["7.6.3", ""]], "type": "str"},
            "id": {"v_range": [["7.6.3", ""]], "required": true, "type": "int"},
            "mpip-label-name": {"v_range": [["7.6.3", ""]], "type": "str"}
        }
    },
    "dlp_profile": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.2.0", ""]], "type": "str"},
            "dlp-log": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "extended-log": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "feature-set": {"v_range": [["7.2.0", ""]], "choices": ["flow", "proxy"], "type": "str"},
            "full-archive-proto": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "choices": ["smtp", "pop3", "imap", "http-post", "http-get", "ftp", "nntp", "mapi", "ssh", "cifs"],
                "elements": "str"
            },
            "nac-quar-log": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["7.2.0", ""]], "required": true, "type": "str"},
            "replacemsg-group": {"v_range": [["7.2.0", ""]], "type": "str"},
            "rule": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["7.2.0", ""]], "choices": ["log-only", "block", "quarantine-ip", "allow"], "type": "str"},
                    "archive": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "expiry": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "file-size": {"v_range": [["7.2.0", ""]], "type": "int"},
                    "file-type": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "filter-by": {"v_range": [["7.2.0", ""]], "choices": ["fingerprint", "sensor", "encrypted", "none", "mip", "label"], "type": "str"},
                    "id": {"v_range": [["7.2.0", ""]], "type": "int"},
                    "label": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "match-percentage": {"v_range": [["7.2.0", ""]], "type": "int"},
                    "name": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "proto": {
                        "v_range": [["7.2.0", ""]],
                        "type": "list",
                        "choices": ["smtp", "pop3", "imap", "http-post", "http-get", "ftp", "nntp", "mapi", "ssh", "cifs"],
                        "elements": "str"
                    },
                    "sensitivity": {"v_range": [["7.2.0", ""]], "type": "raw"},
                    "sensor": {"v_range": [["7.2.0", ""]], "type": "raw"},
                    "severity": {"v_range": [["7.2.0", ""]], "choices": ["info", "low", "medium", "high", "critical"], "type": "str"},
                    "type": {"v_range": [["7.2.0", ""]], "choices": ["file", "message"], "type": "str"}
                },
                "elements": "dict"
            },
            "summary-proto": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "choices": ["smtp", "pop3", "imap", "http-post", "http-get", "ftp", "nntp", "mapi", "ssh", "cifs"],
                "elements": "str"
            }
        }
    },
    "dlp_profile_rule": {
        "stated": true,
        "options": {
            "action": {"v_range": [["7.2.0", ""]], "choices": ["log-only", "block", "quarantine-ip", "allow"], "type": "str"},
            "archive": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "expiry": {"v_range": [["7.2.0", ""]], "type": "str"},
            "file-size": {"v_range": [["7.2.0", ""]], "type": "int"},
            "file-type": {"v_range": [["7.2.0", ""]], "type": "str"},
            "filter-by": {"v_range": [["7.2.0", ""]], "choices": ["fingerprint", "sensor", "encrypted", "none", "mip", "label"], "type": "str"},
            "id": {"v_range": [["7.2.0", ""]], "required": true, "type": "int"},
            "label": {"v_range": [["7.2.0", ""]], "type": "str"},
            "match-percentage": {"v_range": [["7.2.0", ""]], "type": "int"},
            "name": {"v_range": [["7.2.0", ""]], "type": "str"},
            "proto": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "choices": ["smtp", "pop3", "imap", "http-post", "http-get", "ftp", "nntp", "mapi", "ssh", "cifs"],
                "elements": "str"
            },
            "sensitivity": {"v_range": [["7.2.0", ""]], "type": "raw"},
            "sensor": {"v_range": [["7.2.0", ""]], "type": "raw"},
            "severity": {"v_range": [["7.2.0", ""]], "choices": ["info", "low", "medium", "high", "critical"], "type": "str"},
            "type": {"v_range": [["7.2.0", ""]], "choices": ["file", "message"], "type": "str"}
        }
    },
    "dlp_sensitivity": {"stated": true, "options": {"name": {"v_range": [["6.2.0", ""]], "required": true, "type": "str"}}},
    "dlp_sensor": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "dlp-log": {"choices": ["disable", "enable"], "type": "str"},
            "extended-log": {"choices": ["disable", "enable"], "type": "str"},
            "filter": {
                "type": "list",
                "options": {
                    "action": {
                        "choices": ["log-only", "block", "exempt", "ban", "ban-sender", "quarantine-ip", "quarantine-port", "none", "allow"],
                        "type": "str"
                    },
                    "archive": {"choices": ["disable", "enable", "summary-only"], "type": "str"},
                    "company-identifier": {"type": "str"},
                    "expiry": {"type": "str"},
                    "file-size": {"type": "int"},
                    "file-type": {"type": "str"},
                    "filter-by": {
                        "choices": [
                            "credit-card", "ssn", "regexp", "file-type", "file-size", "fingerprint", "watermark", "encrypted", "file-type-and-size"
                        ],
                        "type": "str"
                    },
                    "fp-sensitivity": {"v_range": [["6.0.0", "7.2.1"]], "type": "raw"},
                    "id": {"type": "int"},
                    "match-percentage": {"type": "int"},
                    "name": {"type": "str"},
                    "proto": {
                        "type": "list",
                        "choices": [
                            "imap", "smtp", "pop3", "ftp", "nntp", "mm1", "mm3", "mm4", "mm7", "mapi", "aim", "icq", "msn", "yahoo", "http-get",
                            "http-post", "ssh", "cifs"
                        ],
                        "elements": "str"
                    },
                    "regexp": {"type": "str"},
                    "severity": {"choices": ["info", "low", "medium", "high", "critical"], "type": "str"},
                    "type": {"choices": ["file", "message"], "type": "str"},
                    "sensitivity": {"v_range": [["6.2.0", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "flow-based": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "full-archive-proto": {
                "type": "list",
                "choices": [
                    "imap", "smtp", "pop3", "ftp", "nntp", "mm1", "mm3", "mm4", "mm7", "mapi", "aim", "icq", "msn", "yahoo", "http-get", "http-post",
                    "ssh", "cifs"
                ],
                "elements": "str"
            },
            "nac-quar-log": {"choices": ["disable", "enable"], "type": "str"},
            "name": {"required": true, "type": "str"},
            "options": {"v_range": [["6.0.0", "7.2.0"]], "choices": ["strict-file"], "type": "str"},
            "replacemsg-group": {"type": "str"},
            "summary-proto": {
                "type": "list",
                "choices": [
                    "imap", "smtp", "pop3", "ftp", "nntp", "mm1", "mm3", "mm4", "mm7", "mapi", "aim", "icq", "msn", "yahoo", "http-get", "http-post",
                    "ssh", "cifs"
                ],
                "elements": "str"
            },
            "feature-set": {"v_range": [["6.4.0", ""]], "choices": ["proxy", "flow"], "type": "str"},
            "entries": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "options": {
                    "count": {"v_range": [["7.2.0", ""]], "type": "int"},
                    "dictionary": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "id": {"v_range": [["7.2.0", ""]], "type": "int"},
                    "status": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "eval": {"v_range": [["7.2.0", ""]], "type": "str"},
            "match-type": {"v_range": [["7.2.0", ""]], "choices": ["match-all", "match-any", "match-eval"], "type": "str"},
            "fgd-id": {"v_range": [["7.6.0", ""]], "type": "int"}
        }
    },
    "dlp_sensor_entries": {
        "stated": true,
        "options": {
            "count": {"v_range": [["7.2.0", ""]], "type": "int"},
            "dictionary": {"v_range": [["7.2.0", ""]], "type": "str"},
            "id": {"v_range": [["7.2.0", ""]], "required": true, "type": "int"},
            "status": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dlp_sensor_filter": {
        "stated": true,
        "options": {
            "action": {
                "choices": ["log-only", "block", "exempt", "ban", "ban-sender", "quarantine-ip", "quarantine-port", "none", "allow"],
                "type": "str"
            },
            "archive": {"choices": ["disable", "enable", "summary-only"], "type": "str"},
            "company-identifier": {"type": "str"},
            "expiry": {"type": "str"},
            "file-size": {"type": "int"},
            "file-type": {"type": "str"},
            "filter-by": {
                "choices": ["credit-card", "ssn", "regexp", "file-type", "file-size", "fingerprint", "watermark", "encrypted", "file-type-and-size"],
                "type": "str"
            },
            "fp-sensitivity": {"v_range": [["6.0.0", "7.2.1"]], "type": "raw"},
            "id": {"required": true, "type": "int"},
            "match-percentage": {"type": "int"},
            "name": {"type": "str"},
            "proto": {
                "type": "list",
                "choices": [
                    "imap", "smtp", "pop3", "ftp", "nntp", "mm1", "mm3", "mm4", "mm7", "mapi", "aim", "icq", "msn", "yahoo", "http-get", "http-post",
                    "ssh", "cifs"
                ],
                "elements": "str"
            },
            "regexp": {"type": "str"},
            "severity": {"choices": ["info", "low", "medium", "high", "critical"], "type": "str"},
            "type": {"choices": ["file", "message"], "type": "str"},
            "sensitivity": {"v_range": [["6.2.0", ""]], "type": "raw"}
        }
    },
    "dnsfilter_domainfilter": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "entries": {
                "type": "list",
                "options": {
                    "action": {"choices": ["block", "allow", "monitor"], "type": "str"},
                    "domain": {"type": "str"},
                    "id": {"type": "int"},
                    "status": {"choices": ["disable", "enable"], "type": "str"},
                    "type": {"choices": ["simple", "regex", "wildcard"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"required": true, "type": "int"},
            "name": {"type": "str"}
        }
    },
    "dnsfilter_domainfilter_entries": {
        "stated": true,
        "options": {
            "action": {"choices": ["block", "allow", "monitor"], "type": "str"},
            "domain": {"type": "str"},
            "id": {"required": true, "type": "int"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "type": {"choices": ["simple", "regex", "wildcard"], "type": "str"}
        }
    },
    "dnsfilter_profile": {
        "stated": true,
        "options": {
            "block-action": {"choices": ["block", "redirect", "block-sevrfail"], "type": "str"},
            "block-botnet": {"choices": ["disable", "enable"], "type": "str"},
            "comment": {"type": "str"},
            "external-ip-blocklist": {"type": "raw"},
            "log-all-domain": {"choices": ["disable", "enable"], "type": "str"},
            "name": {"required": true, "type": "str"},
            "redirect-portal": {"type": "str"},
            "safe-search": {"choices": ["disable", "enable"], "type": "str"},
            "sdns-domain-log": {"choices": ["disable", "enable"], "type": "str"},
            "sdns-ftgd-err-log": {"choices": ["disable", "enable"], "type": "str"},
            "youtube-restrict": {"choices": ["strict", "moderate", "none"], "type": "str"},
            "dns-translation": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "options": {
                    "dst": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "id": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "netmask": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "src": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "status": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "addr-type": {"v_range": [["6.2.2", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
                    "dst6": {"v_range": [["6.2.2", ""]], "type": "str"},
                    "prefix": {"v_range": [["6.2.2", ""]], "type": "int"},
                    "src6": {"v_range": [["6.2.2", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "redirect-portal6": {"v_range": [["6.2.0", ""]], "type": "str"},
            "log-all-url": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "sdns-url-log": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "domain-filter": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {"domain-filter-table": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}}
            },
            "ftgd-dns": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "filters": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["monitor", "block"], "type": "str"},
                            "category": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "id": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                            "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["error-allow", "ftgd-disable"],
                        "elements": "str"
                    }
                }
            },
            "urlfilter": {
                "v_range": [["6.2.8", "6.2.13"]],
                "type": "dict",
                "options": {"urlfilter-table": {"v_range": [["6.2.8", "6.2.13"]], "type": "int"}}
            },
            "transparent-dns-database": {"v_range": [["7.4.1", ""]], "type": "raw"},
            "strip-ech": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dnsfilter_profile_dnstranslation": {
        "stated": true,
        "options": {
            "dst": {"v_range": [["6.2.0", ""]], "type": "str"},
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "netmask": {"v_range": [["6.2.0", ""]], "type": "str"},
            "src": {"v_range": [["6.2.0", ""]], "type": "str"},
            "status": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "addr-type": {"v_range": [["6.2.2", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
            "dst6": {"v_range": [["6.2.2", ""]], "type": "str"},
            "prefix": {"v_range": [["6.2.2", ""]], "type": "int"},
            "src6": {"v_range": [["6.2.2", ""]], "type": "str"}
        }
    },
    "dnsfilter_profile_domainfilter": {"stated": false, "options": {"domain-filter-table": {"type": "int"}}},
    "dnsfilter_profile_ftgddns": {
        "stated": false,
        "options": {
            "filters": {
                "type": "list",
                "options": {
                    "action": {"choices": ["monitor", "block"], "type": "str"},
                    "category": {"type": "str"},
                    "id": {"type": "int"},
                    "log": {"choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "options": {"type": "list", "choices": ["error-allow", "ftgd-disable"], "elements": "str"}
        }
    },
    "dnsfilter_profile_ftgddns_filters": {
        "stated": true,
        "options": {
            "action": {"choices": ["monitor", "block"], "type": "str"},
            "category": {"type": "str"},
            "id": {"required": true, "type": "int"},
            "log": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dnsfilter_profile_urlfilter": {"stated": false, "options": {"urlfilter-table": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}}},
    "dnsfilter_urlfilter": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "entries": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "monitor", "block"], "type": "str"},
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
                    "status": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["wildcard", "regex", "simple"], "type": "str"},
                    "url": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "name": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
        }
    },
    "dnsfilter_urlfilter_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "monitor", "block"], "type": "str"},
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"},
            "status": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["wildcard", "regex", "simple"], "type": "str"},
            "url": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
        }
    },
    "dvm_cmd_add_device": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "device": {
                "type": "dict",
                "options": {
                    "adm_pass": {"no_log": true, "type": "raw"},
                    "adm_usr": {"type": "str"},
                    "desc": {"type": "str"},
                    "device action": {"type": "str"},
                    "faz.quota": {"type": "int"},
                    "ip": {"type": "str"},
                    "meta fields": {"type": "raw"},
                    "mgmt_mode": {"choices": ["unreg", "fmg", "faz", "fmgfaz"], "type": "str"},
                    "mr": {"type": "int"},
                    "name": {"type": "str"},
                    "os_type": {
                        "choices": ["unknown", "fos", "fsw", "foc", "fml", "faz", "fwb", "fch", "fct", "log", "fmg", "fsa", "fdd", "fac", "fpx", "fna"],
                        "type": "str"
                    },
                    "os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0"], "type": "str"},
                    "patch": {"type": "int"},
                    "platform_str": {"type": "str"},
                    "sn": {"type": "str"},
                    "device blueprint": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "authorization template": {"v_range": [["7.4.1", ""]], "type": "str"}
                }
            },
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"},
            "groups": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"}
        }
    },
    "dvm_cmd_add_devlist": {
        "stated": true,
        "options": {
            "add-dev-list": {
                "type": "list",
                "options": {
                    "adm_pass": {"no_log": true, "type": "raw"},
                    "adm_usr": {"type": "str"},
                    "desc": {"type": "str"},
                    "device action": {"type": "str"},
                    "faz.quota": {"type": "int"},
                    "ip": {"type": "str"},
                    "meta fields": {"type": "raw"},
                    "mgmt_mode": {"choices": ["unreg", "fmg", "faz", "fmgfaz"], "type": "str"},
                    "mr": {"type": "int"},
                    "name": {"type": "str"},
                    "os_type": {
                        "choices": ["unknown", "fos", "fsw", "foc", "fml", "faz", "fwb", "fch", "fct", "log", "fmg", "fsa", "fdd", "fac", "fpx", "fna"],
                        "type": "str"
                    },
                    "os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0"], "type": "str"},
                    "patch": {"type": "int"},
                    "platform_str": {"type": "str"},
                    "sn": {"type": "str"},
                    "device blueprint": {"v_range": [["7.2.0", ""]], "type": "str"},
                    "authorization template": {"v_range": [["7.4.1", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "adom": {"type": "str"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"}
        }
    },
    "dvm_cmd_changehaseq": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "device": {"type": "str"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"},
            "new_master": {"type": "str"}
        }
    },
    "dvm_cmd_del_device": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "device": {"type": "str"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"}
        }
    },
    "dvm_cmd_del_devlist": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "del-dev-member-list": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"}
        }
    },
    "dvm_cmd_discover_device": {
        "stated": true,
        "options": {
            "device": {"type": "dict", "options": {"adm_pass": {"no_log": true, "type": "str"}, "adm_usr": {"type": "str"}, "ip": {"type": "str"}}}
        }
    },
    "dvm_cmd_import_devlist": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"},
            "import-adom-members": {
                "type": "list",
                "options": {"adom": {"type": "str"}, "dev": {"type": "str"}, "vdom": {"type": "str"}},
                "elements": "dict"
            },
            "import-adoms": {
                "type": "list",
                "options": {
                    "desc": {"type": "str"},
                    "flags": {
                        "type": "list",
                        "choices": [
                            "migration", "db_export", "no_vpn_console", "backup", "other_devices", "central_sdwan", "is_autosync", "per_device_wtp",
                            "policy_check_on_install", "install_on_policy_check_fail", "auto_push_cfg", "per_device_fsw", "install_deselect_all"
                        ],
                        "elements": "str"
                    },
                    "log_db_retention_hours": {"type": "int"},
                    "log_disk_quota": {"type": "int"},
                    "log_disk_quota_alert_thres": {"type": "int"},
                    "log_disk_quota_split_ratio": {"type": "int"},
                    "log_file_retention_hours": {"type": "int"},
                    "meta fields": {"type": "dict"},
                    "mig_mr": {"type": "int"},
                    "mig_os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0"], "type": "str"},
                    "mode": {"choices": ["ems", "gms", "provider"], "type": "str"},
                    "mr": {"type": "int"},
                    "name": {"type": "str"},
                    "os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0"], "type": "str"},
                    "restricted_prds": {
                        "type": "raw",
                        "choices": [
                            "fos", "foc", "fml", "fch", "fwb", "log", "fct", "faz", "fsa", "fsw", "fmg", "fdd", "fac", "fpx", "fna", "fdc", "ffw", "fsr",
                            "fad", "fap", "fxt", "fts", "fai", "fwc", "fis", "fed", "fabric", "fpa", "fca", "ftc", "fss", "sim", "fra"
                        ]
                    },
                    "state": {"type": "int"},
                    "uuid": {"type": "str"},
                    "create_time": {"v_range": [["6.4.1", ""]], "type": "int"},
                    "workspace_mode": {"v_range": [["6.4.3", ""]], "type": "int"},
                    "tz": {"v_range": [["7.4.0", ""]], "type": "int"},
                    "lock_override": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "primary_dns_ip4": {"v_range": [["7.4.3", ""]], "type": "str"},
                    "primary_dns_ip6_1": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "primary_dns_ip6_2": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "primary_dns_ip6_3": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "primary_dns_ip6_4": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "secondary_dns_ip4": {"v_range": [["7.4.3", ""]], "type": "str"},
                    "secondary_dns_ip6_1": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "secondary_dns_ip6_2": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "secondary_dns_ip6_3": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "secondary_dns_ip6_4": {"v_range": [["7.4.3", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "import-devices": {
                "type": "list",
                "options": {
                    "adm_pass": {"no_log": true, "type": "raw"},
                    "adm_usr": {"type": "str"},
                    "app_ver": {"type": "str"},
                    "av_ver": {"type": "str"},
                    "beta": {"type": "int"},
                    "branch_pt": {"type": "int"},
                    "build": {"type": "int"},
                    "checksum": {"type": "str"},
                    "conf_status": {"choices": ["unknown", "insync", "outofsync"], "type": "str"},
                    "conn_mode": {"choices": ["active", "passive"], "type": "str"},
                    "conn_status": {"choices": ["UNKNOWN", "up", "down"], "type": "str"},
                    "db_status": {"choices": ["unknown", "nomod", "mod"], "type": "str"},
                    "desc": {"type": "str"},
                    "dev_status": {
                        "choices": [
                            "none", "unknown", "checkedin", "inprogress", "installed", "aborted", "sched", "retry", "canceled", "pending", "retrieved",
                            "changed_conf", "sync_fail", "timeout", "rev_revert", "auto_updated"
                        ],
                        "type": "str"
                    },
                    "fap_cnt": {"type": "int"},
                    "faz.full_act": {"type": "int"},
                    "faz.perm": {"type": "int"},
                    "faz.quota": {"type": "int"},
                    "faz.used": {"type": "int"},
                    "fex_cnt": {"type": "int"},
                    "flags": {
                        "type": "list",
                        "choices": [
                            "has_hdd", "vdom_enabled", "discover", "reload", "interim_build", "offline_mode", "is_model", "fips_mode", "linked_to_model",
                            "ip-conflict", "faz-autosync", "need_reset", "backup_mode", "azure_vwan_nva", "fgsp_configured", "cnf_mode", "sase_managed",
                            "override_management_intf", "sdwan_management", "deny_api_access"
                        ],
                        "elements": "str"
                    },
                    "foslic_cpu": {"type": "int"},
                    "foslic_dr_site": {"choices": ["disable", "enable"], "type": "str"},
                    "foslic_inst_time": {"type": "int"},
                    "foslic_last_sync": {"type": "int"},
                    "foslic_ram": {"type": "int"},
                    "foslic_type": {"choices": ["temporary", "trial", "regular", "trial_expired"], "type": "str"},
                    "foslic_utm": {"type": "list", "choices": ["fw", "av", "ips", "app", "url", "utm", "fwb"], "elements": "str"},
                    "fsw_cnt": {"type": "int"},
                    "ha_group_id": {"type": "int"},
                    "ha_group_name": {"type": "str"},
                    "ha_mode": {"choices": ["standalone", "AP", "AA", "ELBC", "DUAL", "enabled", "unknown", "fmg-enabled", "autoscale"], "type": "str"},
                    "ha_slave": {
                        "type": "list",
                        "options": {
                            "idx": {"type": "int"},
                            "name": {"type": "str"},
                            "prio": {"type": "int"},
                            "role": {"choices": ["slave", "master"], "type": "str"},
                            "sn": {"type": "str"},
                            "status": {"type": "int"},
                            "conf_status": {"v_range": [["7.0.10", "7.0.14"], ["7.2.1", ""]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "hdisk_size": {"type": "int"},
                    "hostname": {"type": "str"},
                    "hw_rev_major": {"type": "int"},
                    "hw_rev_minor": {"type": "int"},
                    "ip": {"type": "str"},
                    "ips_ext": {"type": "int"},
                    "ips_ver": {"type": "str"},
                    "last_checked": {"type": "int"},
                    "last_resync": {"type": "int"},
                    "latitude": {"type": "str"},
                    "lic_flags": {"type": "int"},
                    "lic_region": {"type": "str"},
                    "location_from": {"type": "str"},
                    "logdisk_size": {"type": "int"},
                    "longitude": {"type": "str"},
                    "maxvdom": {"type": "int"},
                    "meta fields": {"type": "dict"},
                    "mgmt_id": {"v_range": [["6.0.0", "7.2.0"]], "type": "int"},
                    "mgmt_if": {"type": "str"},
                    "mgmt_mode": {"choices": ["unreg", "fmg", "faz", "fmgfaz"], "type": "str"},
                    "mgt_vdom": {"type": "str"},
                    "mr": {"type": "int"},
                    "name": {"type": "str"},
                    "os_type": {
                        "choices": [
                            "unknown", "fos", "fsw", "foc", "fml", "faz", "fwb", "fch", "fct", "log", "fmg", "fsa", "fdd", "fac", "fpx", "fna", "fdc",
                            "ffw", "fsr", "fad", "fap", "fxt", "fts", "fai", "fwc", "fis", "fed", "fpa", "fca", "ftc", "fss", "fra", "sim"
                        ],
                        "type": "str"
                    },
                    "os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0"], "type": "str"},
                    "patch": {"type": "int"},
                    "platform_str": {"type": "str"},
                    "psk": {"type": "str"},
                    "sn": {"type": "str"},
                    "vdom": {
                        "type": "list",
                        "options": {
                            "comments": {"type": "str"},
                            "name": {"type": "str"},
                            "opmode": {"choices": ["nat", "transparent"], "type": "str"},
                            "rtm_prof_id": {"type": "int"},
                            "status": {"type": "str"},
                            "vpn_id": {"v_range": [["6.2.2", ""]], "type": "int"},
                            "meta fields": {"v_range": [["6.4.3", ""]], "type": "dict"},
                            "vdom_type": {"v_range": [["7.2.0", ""]], "choices": ["traffic", "admin"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "version": {"type": "int"},
                    "vm_cpu": {"type": "int"},
                    "vm_cpu_limit": {"type": "int"},
                    "vm_lic_expire": {"type": "int"},
                    "vm_mem": {"type": "int"},
                    "vm_mem_limit": {"type": "int"},
                    "vm_status": {"type": "raw"},
                    "module_sn": {"v_range": [["6.2.1", ""]], "type": "str"},
                    "prefer_img_ver": {"v_range": [["6.2.1", ""]], "type": "str"},
                    "prio": {"v_range": [["6.4.1", ""]], "type": "int"},
                    "role": {"v_range": [["6.4.1", ""]], "choices": ["master", "ha-slave", "autoscale-slave"], "type": "str"},
                    "hyperscale": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "type": "int"},
                    "nsxt_service_name": {"v_range": [["6.4.4", ""]], "type": "str"},
                    "private_key": {"v_range": [["6.2.7", "6.2.13"], ["6.4.4", ""]], "no_log": true, "type": "str"},
                    "private_key_status": {"v_range": [["6.2.7", "6.2.13"], ["6.4.4", ""]], "no_log": true, "type": "int"},
                    "vm_lic_overdue_since": {"v_range": [["6.4.12", "6.4.15"], ["7.0.8", "7.0.14"], ["7.2.3", ""]], "type": "int"},
                    "first_tunnel_up": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "int"},
                    "eip": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "mgmt_uuid": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "hw_generation": {"v_range": [["7.2.4", "7.2.11"], ["7.4.1", ""]], "type": "int"},
                    "relver_info": {"v_range": [["7.4.3", ""]], "type": "str"},
                    "cluster_worker": {"v_range": [["7.6.0", ""]], "type": "str"},
                    "ha.vsn": {"v_range": [["7.2.6", "7.2.11"], ["7.4.4", ""]], "type": "str"},
                    "ha_upgrade_mode": {"v_range": [["7.4.4", ""]], "type": "int"},
                    "vm_payg_status": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "type": "int"},
                    "sov_sase_license": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
                },
                "elements": "dict"
            },
            "import-group-members": {
                "type": "list",
                "options": {"adom": {"type": "str"}, "dev": {"type": "str"}, "grp": {"type": "str"}, "vdom": {"type": "str"}},
                "elements": "dict"
            }
        }
    },
    "dvm_cmd_reload_devlist": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"},
            "from": {"choices": ["um", "fgfm", "apache", "dvm", "fwm", "xml", "json"], "type": "str"},
            "reload-dev-member-list": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "tag": {"type": "str"}
        }
    },
    "dvm_cmd_update_device": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "device": {"type": "str"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"}
        }
    },
    "dvm_cmd_update_devlist": {
        "stated": true,
        "options": {
            "adom": {"type": "str"},
            "flags": {"type": "list", "choices": ["none", "create_task", "nonblocking", "log_dev"], "elements": "str"},
            "update-dev-member-list": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"}
        }
    },
    "dvmdb_adom": {
        "stated": true,
        "options": {
            "desc": {"type": "str"},
            "flags": {
                "type": "list",
                "choices": [
                    "migration", "db_export", "no_vpn_console", "backup", "other_devices", "central_sdwan", "is_autosync", "per_device_wtp",
                    "policy_check_on_install", "install_on_policy_check_fail", "auto_push_cfg", "per_device_fsw", "install_deselect_all"
                ],
                "elements": "str"
            },
            "log_db_retention_hours": {"type": "int"},
            "log_disk_quota": {"type": "int"},
            "log_disk_quota_alert_thres": {"type": "int"},
            "log_disk_quota_split_ratio": {"type": "int"},
            "log_file_retention_hours": {"type": "int"},
            "meta fields": {"type": "dict"},
            "mig_mr": {"type": "int"},
            "mig_os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0"], "type": "str"},
            "mode": {"choices": ["ems", "gms", "provider"], "type": "str"},
            "mr": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0"], "type": "str"},
            "restricted_prds": {
                "type": "raw",
                "choices": [
                    "fos", "foc", "fml", "fch", "fwb", "log", "fct", "faz", "fsa", "fsw", "fmg", "fdd", "fac", "fpx", "fna", "fdc", "ffw", "fsr", "fad",
                    "fap", "fxt", "fts", "fai", "fwc", "fis", "fed", "fabric", "fpa", "fca", "ftc", "fss", "sim", "fra"
                ]
            },
            "state": {"type": "int"},
            "uuid": {"type": "str"},
            "create_time": {"v_range": [["6.4.1", ""]], "type": "int"},
            "workspace_mode": {"v_range": [["6.4.3", ""]], "type": "int"},
            "tz": {"v_range": [["7.4.0", ""]], "type": "int"},
            "lock_override": {"v_range": [["7.4.1", ""]], "type": "int"},
            "primary_dns_ip4": {"v_range": [["7.4.3", ""]], "type": "str"},
            "primary_dns_ip6_1": {"v_range": [["7.4.3", ""]], "type": "int"},
            "primary_dns_ip6_2": {"v_range": [["7.4.3", ""]], "type": "int"},
            "primary_dns_ip6_3": {"v_range": [["7.4.3", ""]], "type": "int"},
            "primary_dns_ip6_4": {"v_range": [["7.4.3", ""]], "type": "int"},
            "secondary_dns_ip4": {"v_range": [["7.4.3", ""]], "type": "str"},
            "secondary_dns_ip6_1": {"v_range": [["7.4.3", ""]], "type": "int"},
            "secondary_dns_ip6_2": {"v_range": [["7.4.3", ""]], "type": "int"},
            "secondary_dns_ip6_3": {"v_range": [["7.4.3", ""]], "type": "int"},
            "secondary_dns_ip6_4": {"v_range": [["7.4.3", ""]], "type": "int"}
        }
    },
    "dvmdb_adom_objectmember": {"stated": true, "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}},
    "dvmdb_device": {
        "stated": false,
        "options": {
            "adm_pass": {"no_log": true, "type": "raw"},
            "adm_usr": {"type": "str"},
            "app_ver": {"type": "str"},
            "av_ver": {"type": "str"},
            "beta": {"type": "int"},
            "branch_pt": {"type": "int"},
            "build": {"type": "int"},
            "checksum": {"type": "str"},
            "conf_status": {"choices": ["unknown", "insync", "outofsync"], "type": "str"},
            "conn_mode": {"choices": ["active", "passive"], "type": "str"},
            "conn_status": {"choices": ["UNKNOWN", "up", "down"], "type": "str"},
            "db_status": {"choices": ["unknown", "nomod", "mod"], "type": "str"},
            "desc": {"type": "str"},
            "dev_status": {
                "choices": [
                    "none", "unknown", "checkedin", "inprogress", "installed", "aborted", "sched", "retry", "canceled", "pending", "retrieved",
                    "changed_conf", "sync_fail", "timeout", "rev_revert", "auto_updated"
                ],
                "type": "str"
            },
            "fap_cnt": {"type": "int"},
            "faz.full_act": {"type": "int"},
            "faz.perm": {"type": "int"},
            "faz.quota": {"type": "int"},
            "faz.used": {"type": "int"},
            "fex_cnt": {"type": "int"},
            "flags": {
                "type": "list",
                "choices": [
                    "has_hdd", "vdom_enabled", "discover", "reload", "interim_build", "offline_mode", "is_model", "fips_mode", "linked_to_model",
                    "ip-conflict", "faz-autosync", "need_reset", "backup_mode", "azure_vwan_nva", "fgsp_configured", "cnf_mode", "sase_managed",
                    "override_management_intf", "sdwan_management", "deny_api_access"
                ],
                "elements": "str"
            },
            "foslic_cpu": {"type": "int"},
            "foslic_dr_site": {"choices": ["disable", "enable"], "type": "str"},
            "foslic_inst_time": {"type": "int"},
            "foslic_last_sync": {"type": "int"},
            "foslic_ram": {"type": "int"},
            "foslic_type": {"choices": ["temporary", "trial", "regular", "trial_expired"], "type": "str"},
            "foslic_utm": {"type": "list", "choices": ["fw", "av", "ips", "app", "url", "utm", "fwb"], "elements": "str"},
            "fsw_cnt": {"type": "int"},
            "ha_group_id": {"type": "int"},
            "ha_group_name": {"type": "str"},
            "ha_mode": {"choices": ["standalone", "AP", "AA", "ELBC", "DUAL", "enabled", "unknown", "fmg-enabled", "autoscale"], "type": "str"},
            "ha_slave": {
                "type": "list",
                "options": {
                    "idx": {"type": "int"},
                    "name": {"type": "str"},
                    "prio": {"type": "int"},
                    "role": {"choices": ["slave", "master"], "type": "str"},
                    "sn": {"type": "str"},
                    "status": {"type": "int"},
                    "conf_status": {"v_range": [["7.0.10", "7.0.14"], ["7.2.1", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "hdisk_size": {"type": "int"},
            "hostname": {"type": "str"},
            "hw_rev_major": {"type": "int"},
            "hw_rev_minor": {"type": "int"},
            "ip": {"type": "str"},
            "ips_ext": {"type": "int"},
            "ips_ver": {"type": "str"},
            "last_checked": {"type": "int"},
            "last_resync": {"type": "int"},
            "latitude": {"type": "str"},
            "lic_flags": {"type": "int"},
            "lic_region": {"type": "str"},
            "location_from": {"type": "str"},
            "logdisk_size": {"type": "int"},
            "longitude": {"type": "str"},
            "maxvdom": {"type": "int"},
            "meta fields": {"type": "dict"},
            "mgmt_id": {"v_range": [["6.0.0", "7.2.0"]], "type": "int"},
            "mgmt_if": {"type": "str"},
            "mgmt_mode": {"choices": ["unreg", "fmg", "faz", "fmgfaz"], "type": "str"},
            "mgt_vdom": {"type": "str"},
            "mr": {"type": "int"},
            "name": {"type": "str"},
            "os_type": {
                "choices": [
                    "unknown", "fos", "fsw", "foc", "fml", "faz", "fwb", "fch", "fct", "log", "fmg", "fsa", "fdd", "fac", "fpx", "fna", "fdc", "ffw",
                    "fsr", "fad", "fap", "fxt", "fts", "fai", "fwc", "fis", "fed", "fpa", "fca", "ftc", "fss", "fra", "sim"
                ],
                "type": "str"
            },
            "os_ver": {"choices": ["unknown", "0.0", "1.0", "2.0", "3.0", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0"], "type": "str"},
            "patch": {"type": "int"},
            "platform_str": {"type": "str"},
            "psk": {"type": "str"},
            "sn": {"type": "str"},
            "vdom": {
                "type": "list",
                "options": {
                    "comments": {"type": "str"},
                    "name": {"type": "str"},
                    "opmode": {"choices": ["nat", "transparent"], "type": "str"},
                    "rtm_prof_id": {"type": "int"},
                    "status": {"type": "str"},
                    "vpn_id": {"v_range": [["6.2.2", ""]], "type": "int"},
                    "meta fields": {"v_range": [["6.4.3", ""]], "type": "dict"},
                    "vdom_type": {"v_range": [["7.2.0", ""]], "choices": ["traffic", "admin"], "type": "str"}
                },
                "elements": "dict"
            },
            "version": {"type": "int"},
            "vm_cpu": {"type": "int"},
            "vm_cpu_limit": {"type": "int"},
            "vm_lic_expire": {"type": "int"},
            "vm_mem": {"type": "int"},
            "vm_mem_limit": {"type": "int"},
            "vm_status": {"type": "raw"},
            "module_sn": {"v_range": [["6.2.1", ""]], "type": "str"},
            "prefer_img_ver": {"v_range": [["6.2.1", ""]], "type": "str"},
            "prio": {"v_range": [["6.4.1", ""]], "type": "int"},
            "role": {"v_range": [["6.4.1", ""]], "choices": ["master", "ha-slave", "autoscale-slave"], "type": "str"},
            "hyperscale": {"v_range": [["6.2.7", "6.2.13"], ["6.4.3", ""]], "type": "int"},
            "nsxt_service_name": {"v_range": [["6.4.4", ""]], "type": "str"},
            "private_key": {"v_range": [["6.2.7", "6.2.13"], ["6.4.4", ""]], "no_log": true, "type": "str"},
            "private_key_status": {"v_range": [["6.2.7", "6.2.13"], ["6.4.4", ""]], "no_log": true, "type": "int"},
            "vm_lic_overdue_since": {"v_range": [["6.4.12", "6.4.15"], ["7.0.8", "7.0.14"], ["7.2.3", ""]], "type": "int"},
            "first_tunnel_up": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "int"},
            "eip": {"v_range": [["7.2.1", ""]], "type": "str"},
            "mgmt_uuid": {"v_range": [["7.2.1", ""]], "type": "str"},
            "hw_generation": {"v_range": [["7.2.4", "7.2.11"], ["7.4.1", ""]], "type": "int"},
            "relver_info": {"v_range": [["7.4.3", ""]], "type": "str"},
            "cluster_worker": {"v_range": [["7.6.0", ""]], "type": "str"},
            "ha.vsn": {"v_range": [["7.2.6", "7.2.11"], ["7.4.4", ""]], "type": "str"},
            "ha_upgrade_mode": {"v_range": [["7.4.4", ""]], "type": "int"},
            "vm_payg_status": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "type": "int"},
            "sov_sase_license": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
        }
    },
    "dvmdb_device_replace_sn": {"stated": true, "options": {"sn": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"}}},
    "dvmdb_device_vdom": {
        "stated": true,
        "options": {
            "comments": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "opmode": {"choices": ["nat", "transparent"], "type": "str"},
            "rtm_prof_id": {"type": "int"},
            "status": {"type": "str"},
            "vpn_id": {"v_range": [["6.2.2", ""]], "type": "int"},
            "meta fields": {"v_range": [["6.4.3", ""]], "type": "dict"},
            "vdom_type": {"v_range": [["7.2.0", ""]], "choices": ["traffic", "admin"], "type": "str"}
        }
    },
    "dvmdb_folder": {
        "stated": true,
        "options": {
            "desc": {"v_range": [["6.4.2", ""]], "type": "str"},
            "name": {"v_range": [["6.4.2", ""]], "required": true, "type": "str"},
            "parent": {"v_range": [["6.4.2", ""]], "type": "int"}
        }
    },
    "dvmdb_group": {
        "stated": true,
        "options": {
            "desc": {"type": "str"},
            "meta fields": {"type": "dict"},
            "name": {"required": true, "type": "str"},
            "os_type": {
                "choices": [
                    "unknown", "fos", "fsw", "foc", "fml", "faz", "fwb", "fch", "fct", "log", "fmg", "fsa", "fdd", "fac", "fpx", "fna", "fdc", "ffw",
                    "fsr", "fad", "fap", "fxt", "fts", "fai", "fwc", "fis", "fed", "fpa", "fca", "ftc", "fss", "fra", "sim"
                ],
                "type": "str"
            },
            "type": {"choices": ["normal", "default", "auto", "cluster", "fabric"], "type": "str"},
            "id": {"v_range": [["7.2.1", ""]], "type": "str"},
            "cluster_type": {"v_range": [["7.2.2", ""]], "choices": ["unknown", "vwan", "sase", "ums_aws", "ums_azure", "ums_gcp"], "type": "str"}
        }
    },
    "dvmdb_group_objectmember": {"stated": true, "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}},
    "dvmdb_metafields_adom": {
        "stated": false,
        "options": {
            "importance": {"choices": ["optional", "required"], "type": "str"},
            "length": {"type": "int"},
            "name": {"type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dvmdb_metafields_device": {
        "stated": false,
        "options": {
            "importance": {"choices": ["optional", "required"], "type": "str"},
            "length": {"type": "int"},
            "name": {"type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dvmdb_metafields_group": {
        "stated": false,
        "options": {
            "importance": {"choices": ["optional", "required"], "type": "str"},
            "length": {"type": "int"},
            "name": {"type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dvmdb_revision": {
        "stated": true,
        "options": {
            "created_by": {"type": "str"},
            "created_time": {"type": "int"},
            "desc": {"type": "str"},
            "locked": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "version": {"type": "int"}
        }
    },
    "dvmdb_script": {
        "stated": true,
        "options": {
            "content": {"type": "str"},
            "desc": {"type": "str"},
            "filter_build": {"type": "int"},
            "filter_device": {"type": "int"},
            "filter_hostname": {"type": "str"},
            "filter_ostype": {"choices": ["unknown", "fos"], "type": "str"},
            "filter_osver": {"choices": ["unknown", "4.00", "5.00", "6.00"], "type": "str"},
            "filter_platform": {"type": "str"},
            "filter_serial": {"type": "str"},
            "modification_time": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "script_schedule": {
                "type": "list",
                "options": {
                    "datetime": {"type": "str"},
                    "day_of_week": {"choices": ["unknown", "sun", "mon", "tue", "wed", "thu", "fri", "sat"], "type": "str"},
                    "device": {"type": "int"},
                    "name": {"type": "str"},
                    "run_on_db": {"choices": ["disable", "enable"], "type": "str"},
                    "type": {"choices": ["auto", "onetime", "daily", "weekly", "monthly"], "type": "str"}
                },
                "elements": "dict"
            },
            "target": {"choices": ["device_database", "remote_device", "adom_database"], "type": "str"},
            "type": {"choices": ["cli", "tcl", "cligrp"], "type": "str"}
        }
    },
    "dvmdb_script_execute": {
        "stated": true,
        "options": {
            "adom": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"},
            "package": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"},
            "scope": {
                "v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"},
                    "vdom": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "script": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"},
            "pblock": {"v_range": [["7.0.10", "7.0.14"], ["7.2.5", "7.2.11"], ["7.4.2", ""]], "type": "str"}
        }
    },
    "dvmdb_script_objectmember": {"stated": true, "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}},
    "dvmdb_script_scriptschedule": {
        "stated": true,
        "options": {
            "datetime": {"type": "str"},
            "day_of_week": {"choices": ["unknown", "sun", "mon", "tue", "wed", "thu", "fri", "sat"], "type": "str"},
            "device": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "run_on_db": {"choices": ["disable", "enable"], "type": "str"},
            "type": {"choices": ["auto", "onetime", "daily", "weekly", "monthly"], "type": "str"}
        }
    },
    "dvmdb_upgrade": {
        "stated": true,
        "options": {
            "scope member": {
                "v_range": [["7.4.1", ""]],
                "type": "list",
                "options": {"name": {"v_range": [["7.4.1", ""]], "type": "str"}, "vdom": {"v_range": [["7.4.1", ""]], "type": "str"}},
                "elements": "dict"
            }
        }
    },
    "dvmdb_workflow_approve": {"stated": true, "options": {"desc": {"type": "str"}}},
    "dvmdb_workflow_discard": {"stated": true, "options": {}},
    "dvmdb_workflow_drop": {"stated": true, "options": {}},
    "dvmdb_workflow_reject": {"stated": true, "options": {"desc": {"type": "str"}}},
    "dvmdb_workflow_repair": {"stated": true, "options": {"desc": {"type": "str"}}},
    "dvmdb_workflow_revert": {
        "stated": true,
        "options": {
            "desc": {"type": "str"},
            "fmgip": {"type": "str"},
            "mail_user": {"type": "raw"},
            "no_diff": {"type": "int"},
            "no_mail": {"type": "int"}
        }
    },
    "dvmdb_workflow_review": {"stated": true, "options": {}},
    "dvmdb_workflow_save": {"stated": true, "options": {}},
    "dvmdb_workflow_start": {"stated": true, "options": {"desc": {"type": "str"}, "name": {"type": "str"}}},
    "dvmdb_workflow_submit": {
        "stated": true,
        "options": {
            "desc": {"type": "str"},
            "fmgip": {"type": "str"},
            "mail_user": {"type": "raw"},
            "no_diff": {"type": "int"},
            "no_mail": {"type": "int"}
        }
    },
    "dvmdb_workspace_commit": {"stated": true, "options": {}},
    "dvmdb_workspace_commit_dev": {"stated": true, "options": {}},
    "dvmdb_workspace_commit_obj": {"stated": true, "options": {}},
    "dvmdb_workspace_commit_pkg": {"stated": true, "options": {}},
    "dvmdb_workspace_lock": {"stated": true, "options": {}},
    "dvmdb_workspace_lock_dev": {"stated": true, "options": {}},
    "dvmdb_workspace_lock_obj": {"stated": true, "options": {}},
    "dvmdb_workspace_lock_pkg": {"stated": true, "options": {}},
    "dvmdb_workspace_unlock": {"stated": true, "options": {}},
    "dvmdb_workspace_unlock_dev": {"stated": true, "options": {}},
    "dvmdb_workspace_unlock_obj": {"stated": true, "options": {}},
    "dvmdb_workspace_unlock_pkg": {"stated": true, "options": {}},
    "dynamic_address": {
        "stated": true,
        "options": {
            "default": {"type": "raw"},
            "description": {"type": "str"},
            "dynamic_addr_mapping": {"type": "list", "options": {"addr": {"type": "str"}, "id": {"type": "int"}}, "elements": "dict"},
            "name": {"required": true, "type": "str"}
        }
    },
    "dynamic_address_dynamicaddrmapping": {"stated": true, "options": {"addr": {"type": "str"}, "id": {"required": true, "type": "int"}}},
    "dynamic_certificate_local": {
        "stated": true,
        "options": {
            "description": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "local-cert": {"type": "str"}
                },
                "elements": "dict"
            },
            "name": {"required": true, "type": "str"}
        }
    },
    "dynamic_certificate_local_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "local-cert": {"type": "str"}
        }
    },
    "dynamic_input_interface": {
        "stated": true,
        "options": {
            "default-mapping": {"v_range": [["6.2.2", "6.4.0"]], "choices": ["disable", "enable"], "type": "str"},
            "defmap-intf": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"},
            "description": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"},
            "dynamic_mapping": {
                "v_range": [["6.2.2", "6.4.0"]],
                "type": "list",
                "options": {
                    "_scope": {
                        "v_range": [["6.2.2", "6.4.0"]],
                        "type": "list",
                        "options": {"name": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"}, "vdom": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"}},
                        "elements": "dict"
                    },
                    "local-intf": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"}
                },
                "elements": "dict"
            },
            "name": {"v_range": [["6.2.2", "6.4.0"]], "required": true, "type": "str"},
            "skip-unmapped": {"v_range": [["6.2.2", "6.4.0"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dynamic_input_interface_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {
                "v_range": [["6.2.2", "6.4.0"]],
                "type": "list",
                "options": {"name": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"}, "vdom": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"}},
                "elements": "dict"
            },
            "local-intf": {"v_range": [["6.2.2", "6.4.0"]], "type": "str"}
        }
    },
    "dynamic_interface": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "default-mapping": {"choices": ["disable", "enable"], "type": "str"},
            "defmap-intf": {"type": "str"},
            "defmap-intrazone-deny": {"choices": ["disable", "enable"], "type": "str"},
            "defmap-zonemember": {"type": "raw"},
            "description": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "egress-shaping-profile": {"type": "raw"},
                    "intrazone-deny": {"choices": ["disable", "enable"], "type": "str"},
                    "local-intf": {"type": "raw"},
                    "ingress-shaping-profile": {"v_range": [["6.2.2", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "egress-shaping-profile": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "single-intf": {"choices": ["disable", "enable"], "type": "str"},
            "ingress-shaping-profile": {"v_range": [["6.2.2", ""]], "type": "raw"},
            "platform_mapping": {
                "v_range": [["6.4.1", ""]],
                "type": "list",
                "options": {
                    "egress-shaping-profile": {"v_range": [["6.4.1", ""]], "type": "raw"},
                    "ingress-shaping-profile": {"v_range": [["6.4.1", ""]], "type": "raw"},
                    "intf-zone": {"v_range": [["6.4.1", ""]], "type": "str"},
                    "intrazone-deny": {"v_range": [["6.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "name": {"v_range": [["6.4.1", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "wildcard": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "wildcard-intf": {"v_range": [["7.0.1", ""]], "type": "str"},
            "zone-only": {"v_range": [["6.4.7", "6.4.15"], ["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dynamic_interface_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "egress-shaping-profile": {"type": "raw"},
            "intrazone-deny": {"choices": ["disable", "enable"], "type": "str"},
            "local-intf": {"type": "raw"},
            "ingress-shaping-profile": {"v_range": [["6.2.2", ""]], "type": "raw"}
        }
    },
    "dynamic_interface_platformmapping": {
        "stated": true,
        "options": {
            "egress-shaping-profile": {"v_range": [["6.4.1", ""]], "type": "raw"},
            "ingress-shaping-profile": {"v_range": [["6.4.1", ""]], "type": "raw"},
            "intf-zone": {"v_range": [["6.4.1", ""]], "type": "str"},
            "intrazone-deny": {"v_range": [["6.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["6.4.1", ""]], "required": true, "type": "str"}
        }
    },
    "dynamic_ippool": {"stated": true, "options": {"description": {"type": "str"}, "name": {"required": true, "type": "str"}}},
    "dynamic_multicast_interface": {
        "stated": true,
        "options": {
            "default-mapping": {"choices": ["disable", "enable"], "type": "str"},
            "defmap-intf": {"type": "str"},
            "description": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "local-intf": {"type": "str"}
                },
                "elements": "dict"
            },
            "name": {"required": true, "type": "str"},
            "zone-only": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "dynamic_multicast_interface_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "local-intf": {"type": "str"}
        }
    },
    "dynamic_vip": {"stated": true, "options": {"description": {"type": "str"}, "name": {"required": true, "type": "str"}}},
    "dynamic_virtualwanlink_members": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "cost": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-failtime": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-http-get": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "detect-http-match": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "detect-http-port": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-interval": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-protocol": {"v_range": [["6.0.0", "6.4.15"]], "choices": ["ping", "tcp-echo", "udp-echo", "http"], "type": "str"},
            "detect-recoverytime": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-server": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "detect-timeout": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "dynamic_mapping": {
                "v_range": [["6.0.0", "6.4.15"]],
                "type": "list",
                "options": {
                    "_scope": {
                        "v_range": [["6.0.0", "6.4.15"]],
                        "type": "list",
                        "options": {"name": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}, "vdom": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}},
                        "elements": "dict"
                    },
                    "comment": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "cost": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "detect-failtime": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "detect-http-get": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "detect-http-match": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "detect-http-port": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "detect-interval": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "detect-protocol": {"v_range": [["6.0.0", "6.4.15"]], "choices": ["ping", "tcp-echo", "udp-echo", "http"], "type": "str"},
                    "detect-recoverytime": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "detect-server": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "detect-timeout": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "gateway": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "gateway6": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "ingress-spillover-threshold": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "interface": {"v_range": [["6.0.0", "6.4.0"]], "type": "str"},
                    "priority": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "source": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "source6": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
                    "spillover-threshold": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "status": {"v_range": [["6.0.0", "6.4.15"]], "choices": ["disable", "enable"], "type": "str"},
                    "volume-ratio": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
                    "weight": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"}
                },
                "elements": "dict"
            },
            "gateway": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "gateway6": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "ingress-spillover-threshold": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "interface": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "name": {"v_range": [["6.0.0", "6.4.15"]], "required": true, "type": "str"},
            "priority": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "source": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "source6": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "spillover-threshold": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "status": {"v_range": [["6.0.0", "6.4.15"]], "choices": ["disable", "enable"], "type": "str"},
            "volume-ratio": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "weight": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"}
        }
    },
    "dynamic_virtualwanlink_members_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {
                "v_range": [["6.0.0", "6.4.15"]],
                "type": "list",
                "options": {"name": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}, "vdom": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}},
                "elements": "dict"
            },
            "comment": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "cost": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-failtime": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-http-get": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "detect-http-match": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "detect-http-port": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-interval": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-protocol": {"v_range": [["6.0.0", "6.4.15"]], "choices": ["ping", "tcp-echo", "udp-echo", "http"], "type": "str"},
            "detect-recoverytime": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "detect-server": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "detect-timeout": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "gateway": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "gateway6": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "ingress-spillover-threshold": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "interface": {"v_range": [["6.0.0", "6.4.0"]], "type": "str"},
            "priority": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "source": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "source6": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "spillover-threshold": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "status": {"v_range": [["6.0.0", "6.4.15"]], "choices": ["disable", "enable"], "type": "str"},
            "volume-ratio": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"},
            "weight": {"v_range": [["6.0.0", "6.4.15"]], "type": "int"}
        }
    },
    "dynamic_virtualwanlink_neighbor": {
        "stated": true,
        "options": {
            "description": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"},
            "dynamic_mapping": {
                "v_range": [["6.2.2", "6.4.15"]],
                "type": "list",
                "options": {
                    "_scope": {
                        "v_range": [["6.2.2", "6.4.15"]],
                        "type": "list",
                        "options": {"name": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"}, "vdom": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"}},
                        "elements": "dict"
                    },
                    "description": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"},
                    "ip": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"},
                    "role": {"v_range": [["6.2.2", "6.4.15"]], "choices": ["primary", "secondary", "standalone"], "type": "str"}
                },
                "elements": "dict"
            },
            "ip": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"},
            "name": {"v_range": [["6.2.2", "6.4.15"]], "required": true, "type": "str"},
            "role": {"v_range": [["6.2.2", "6.4.15"]], "choices": ["primary", "secondary", "standalone"], "type": "str"}
        }
    },
    "dynamic_virtualwanlink_neighbor_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {
                "v_range": [["6.2.2", "6.4.15"]],
                "type": "list",
                "options": {"name": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"}, "vdom": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"}},
                "elements": "dict"
            },
            "description": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"},
            "ip": {"v_range": [["6.2.2", "6.4.15"]], "type": "str"},
            "role": {"v_range": [["6.2.2", "6.4.15"]], "choices": ["primary", "secondary", "standalone"], "type": "str"}
        }
    },
    "dynamic_virtualwanlink_server": {
        "stated": true,
        "options": {
            "description": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"},
            "dynamic_mapping": {
                "v_range": [["6.0.0", "6.4.15"]],
                "type": "list",
                "options": {
                    "_scope": {
                        "v_range": [["6.0.0", "6.4.15"]],
                        "type": "list",
                        "options": {"name": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}, "vdom": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}},
                        "elements": "dict"
                    },
                    "server": {"v_range": [["6.0.0", "6.4.15"]], "type": "raw"}
                },
                "elements": "dict"
            },
            "name": {"v_range": [["6.0.0", "6.4.15"]], "required": true, "type": "str"},
            "server": {"v_range": [["6.0.0", "6.4.15"]], "type": "raw"}
        }
    },
    "dynamic_virtualwanlink_server_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {
                "v_range": [["6.0.0", "6.4.15"]],
                "type": "list",
                "options": {"name": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}, "vdom": {"v_range": [["6.0.0", "6.4.15"]], "type": "str"}},
                "elements": "dict"
            },
            "server": {"v_range": [["6.0.0", "6.4.15"]], "type": "raw"}
        }
    },
    "dynamic_vpntunnel": {
        "stated": true,
        "options": {
            "description": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "local-ipsec": {"type": "str"}
                },
                "elements": "dict"
            },
            "name": {"required": true, "type": "str"}
        }
    },
    "dynamic_vpntunnel_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "local-ipsec": {"type": "str"}
        }
    },
    "emailfilter_blockallowlist": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.0.0", ""]], "type": "str"},
            "entries": {
                "v_range": [["7.0.0", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["7.0.0", ""]], "choices": ["spam", "clear", "reject"], "type": "str"},
                    "addr-type": {"v_range": [["7.0.0", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
                    "email-pattern": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "id": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "ip4-subnet": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "ip6-subnet": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "pattern-type": {"v_range": [["7.0.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
                    "status": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["7.0.0", ""]], "choices": ["ip", "email", "email-to", "email-from", "subject"], "type": "str"},
                    "pattern": {"v_range": [["7.2.0", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["7.0.0", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["7.0.0", ""]], "type": "str"}
        }
    },
    "emailfilter_blockallowlist_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["7.0.0", ""]], "choices": ["spam", "clear", "reject"], "type": "str"},
            "addr-type": {"v_range": [["7.0.0", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
            "email-pattern": {"v_range": [["7.0.0", ""]], "type": "str"},
            "id": {"v_range": [["7.0.0", ""]], "required": true, "type": "int"},
            "ip4-subnet": {"v_range": [["7.0.0", ""]], "type": "str"},
            "ip6-subnet": {"v_range": [["7.0.0", ""]], "type": "str"},
            "pattern-type": {"v_range": [["7.0.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
            "status": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["7.0.0", ""]], "choices": ["ip", "email", "email-to", "email-from", "subject"], "type": "str"},
            "pattern": {"v_range": [["7.2.0", ""]], "type": "str"}
        }
    },
    "emailfilter_bwl": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", ""]], "type": "str"},
            "entries": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "clear", "reject"], "type": "str"},
                    "addr-type": {"v_range": [["6.2.0", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
                    "email-pattern": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "id": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "ip4-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "ip6-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "pattern-type": {"v_range": [["6.2.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
                    "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["6.2.0", ""]], "choices": ["ip", "email"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.2.0", ""]], "type": "str"}
        }
    },
    "emailfilter_bwl_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "clear", "reject"], "type": "str"},
            "addr-type": {"v_range": [["6.2.0", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
            "email-pattern": {"v_range": [["6.2.0", ""]], "type": "str"},
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "ip4-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
            "ip6-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
            "pattern-type": {"v_range": [["6.2.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
            "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["6.2.0", ""]], "choices": ["ip", "email"], "type": "str"}
        }
    },
    "emailfilter_bword": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", ""]], "type": "str"},
            "entries": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "clear"], "type": "str"},
                    "id": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "language": {
                        "v_range": [["6.2.0", ""]],
                        "choices": ["western", "simch", "trach", "japanese", "korean", "french", "thai", "spanish"],
                        "type": "str"
                    },
                    "pattern": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "pattern-type": {"v_range": [["6.2.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
                    "score": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "where": {"v_range": [["6.2.0", ""]], "choices": ["all", "subject", "body"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.2.0", ""]], "type": "str"}
        }
    },
    "emailfilter_bword_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "clear"], "type": "str"},
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "language": {
                "v_range": [["6.2.0", ""]],
                "choices": ["western", "simch", "trach", "japanese", "korean", "french", "thai", "spanish"],
                "type": "str"
            },
            "pattern": {"v_range": [["6.2.0", ""]], "type": "str"},
            "pattern-type": {"v_range": [["6.2.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
            "score": {"v_range": [["6.2.0", ""]], "type": "int"},
            "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "where": {"v_range": [["6.2.0", ""]], "choices": ["all", "subject", "body"], "type": "str"}
        }
    },
    "emailfilter_dnsbl": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", ""]], "type": "str"},
            "entries": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "reject"], "type": "str"},
                    "id": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "server": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.2.0", ""]], "type": "str"}
        }
    },
    "emailfilter_dnsbl_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "reject"], "type": "str"},
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "server": {"v_range": [["6.2.0", ""]], "type": "str"},
            "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_fortishield": {
        "stated": false,
        "options": {
            "spam-submit-force": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "spam-submit-srv": {"v_range": [["6.2.0", ""]], "type": "str"},
            "spam-submit-txt2htm": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_iptrust": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", ""]], "type": "str"},
            "entries": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "options": {
                    "addr-type": {"v_range": [["6.2.0", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
                    "id": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "ip4-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "ip6-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.2.0", ""]], "type": "str"}
        }
    },
    "emailfilter_iptrust_entries": {
        "stated": true,
        "options": {
            "addr-type": {"v_range": [["6.2.0", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "ip4-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
            "ip6-subnet": {"v_range": [["6.2.0", ""]], "type": "str"},
            "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_mheader": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", ""]], "type": "str"},
            "entries": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "clear"], "type": "str"},
                    "fieldbody": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "fieldname": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "id": {"v_range": [["6.2.0", ""]], "type": "int"},
                    "pattern-type": {"v_range": [["6.2.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
                    "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["6.2.0", ""]], "type": "str"}
        }
    },
    "emailfilter_mheader_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["spam", "clear"], "type": "str"},
            "fieldbody": {"v_range": [["6.2.0", ""]], "type": "str"},
            "fieldname": {"v_range": [["6.2.0", ""]], "type": "str"},
            "id": {"v_range": [["6.2.0", ""]], "required": true, "type": "int"},
            "pattern-type": {"v_range": [["6.2.0", ""]], "choices": ["wildcard", "regexp"], "type": "str"},
            "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_options": {"stated": false, "options": {"dns-timeout": {"v_range": [["6.2.0", ""]], "type": "int"}}},
    "emailfilter_profile": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.0", ""]], "type": "str"},
            "external": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["6.2.0", ""]], "required": true, "type": "str"},
            "options": {
                "v_range": [["6.2.0", ""]],
                "type": "list",
                "choices": [
                    "bannedword", "spambwl", "spamfsip", "spamfssubmit", "spamfschksum", "spamfsurl", "spamhelodns", "spamraddrdns", "spamrbl",
                    "spamhdrcheck", "spamfsphish", "spambal", "spamfgip", "spamfgsubmit", "spamfgchksum", "spamfgurl", "spamfgphish"
                ],
                "elements": "str"
            },
            "replacemsg-group": {"v_range": [["6.2.0", ""]], "type": "str"},
            "spam-bwl-table": {"v_range": [["6.2.0", ""]], "type": "str"},
            "spam-bword-table": {"v_range": [["6.2.0", ""]], "type": "str"},
            "spam-bword-threshold": {"v_range": [["6.2.0", ""]], "type": "int"},
            "spam-filtering": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "spam-iptrust-table": {"v_range": [["6.2.0", ""]], "type": "str"},
            "spam-log": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "spam-log-fortiguard-response": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "spam-mheader-table": {"v_range": [["6.2.0", ""]], "type": "str"},
            "spam-rbl-table": {"v_range": [["6.2.0", ""]], "type": "str"},
            "feature-set": {"v_range": [["6.4.0", ""]], "choices": ["proxy", "flow"], "type": "str"},
            "gmail": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "log-all": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "imap": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["pass", "tag"], "type": "str"},
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "log-all": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tag-msg": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                    "tag-type": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["subject", "header", "spaminfo"],
                        "elements": "str"
                    }
                }
            },
            "mapi": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["pass", "discard"], "type": "str"},
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "log-all": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "msn-hotmail": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "log-all": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "other-webmails": {
                "v_range": [["6.4.5", ""]],
                "type": "dict",
                "options": {"log-all": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}}
            },
            "pop3": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["pass", "tag"], "type": "str"},
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "log-all": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tag-msg": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                    "tag-type": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["subject", "header", "spaminfo"],
                        "elements": "str"
                    }
                }
            },
            "smtp": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["pass", "tag", "discard"], "type": "str"},
                    "hdrip": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "local-override": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "log-all": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tag-msg": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                    "tag-type": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["subject", "header", "spaminfo"],
                        "elements": "str"
                    }
                }
            },
            "file-filter": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                "type": "dict",
                "options": {
                    "entries": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["log", "block"], "type": "str"},
                            "comment": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                            "encryption": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.0"]], "choices": ["any", "yes"], "type": "str"},
                            "file-type": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "raw"},
                            "filter": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                            "password-protected": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["any", "yes"], "type": "str"},
                            "protocol": {
                                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                                "type": "list",
                                "choices": ["smtp", "imap", "pop3"],
                                "elements": "str"
                            }
                        },
                        "elements": "dict"
                    },
                    "log": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "scan-archive-contents": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "spam-bal-table": {"v_range": [["7.0.0", ""]], "type": "str"}
        }
    },
    "emailfilter_profile_filefilter": {
        "stated": false,
        "options": {
            "entries": {
                "v_range": [["6.2.0", "7.6.2"]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["log", "block"], "type": "str"},
                    "comment": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
                    "encryption": {"v_range": [["6.2.0", "7.2.0"]], "choices": ["any", "yes"], "type": "str"},
                    "file-type": {"v_range": [["6.2.0", "7.6.2"]], "type": "raw"},
                    "filter": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
                    "password-protected": {"v_range": [["6.2.1", "7.6.2"]], "choices": ["any", "yes"], "type": "str"},
                    "protocol": {"v_range": [["6.2.0", "7.6.2"]], "type": "list", "choices": ["smtp", "imap", "pop3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "log": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "scan-archive-contents": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_profile_filefilter_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["log", "block"], "type": "str"},
            "comment": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "encryption": {"v_range": [["6.2.0", "7.2.0"]], "choices": ["any", "yes"], "type": "str"},
            "file-type": {"v_range": [["6.2.0", "7.6.2"]], "type": "raw"},
            "filter": {"v_range": [["6.2.0", "7.6.2"]], "type": "str"},
            "password-protected": {"v_range": [["6.2.1", "7.6.2"]], "choices": ["any", "yes"], "type": "str"},
            "protocol": {"v_range": [["6.2.0", "7.6.2"]], "type": "list", "choices": ["smtp", "imap", "pop3"], "elements": "str"}
        }
    },
    "emailfilter_profile_gmail": {
        "stated": false,
        "options": {
            "log": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "log-all": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_profile_imap": {
        "stated": false,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["pass", "tag"], "type": "str"},
            "log": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tag-msg": {"v_range": [["6.2.0", ""]], "type": "str"},
            "tag-type": {"v_range": [["6.2.0", ""]], "type": "list", "choices": ["subject", "header", "spaminfo"], "elements": "str"},
            "log-all": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_profile_mapi": {
        "stated": false,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["pass", "discard"], "type": "str"},
            "log": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "log-all": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_profile_msnhotmail": {
        "stated": false,
        "options": {
            "log": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "log-all": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_profile_otherwebmails": {
        "stated": false,
        "options": {"log-all": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}}
    },
    "emailfilter_profile_pop3": {
        "stated": false,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["pass", "tag"], "type": "str"},
            "log": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tag-msg": {"v_range": [["6.2.0", ""]], "type": "str"},
            "tag-type": {"v_range": [["6.2.0", ""]], "type": "list", "choices": ["subject", "header", "spaminfo"], "elements": "str"},
            "log-all": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_profile_smtp": {
        "stated": false,
        "options": {
            "action": {"v_range": [["6.2.0", ""]], "choices": ["pass", "tag", "discard"], "type": "str"},
            "hdrip": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "local-override": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "log": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tag-msg": {"v_range": [["6.2.0", ""]], "type": "str"},
            "tag-type": {"v_range": [["6.2.0", ""]], "type": "list", "choices": ["subject", "header", "spaminfo"], "elements": "str"},
            "log-all": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "emailfilter_profile_yahoomail": {
        "stated": false,
        "options": {"log": {"v_range": [["6.2.0", "6.2.0"]], "choices": ["disable", "enable"], "type": "str"}}
    },
    "endpointcontrol_fctems": {
        "stated": true,
        "options": {
            "call-timeout": {"v_range": [["7.0.2", ""]], "type": "int"},
            "capabilities": {
                "v_range": [["7.0.2", ""]],
                "type": "list",
                "choices": [
                    "fabric-auth", "silent-approval", "websocket", "websocket-malware", "push-ca-certs", "common-tags-api", "tenant-id",
                    "single-vdom-connector", "client-avatars", "fgt-sysinfo-api", "ztna-server-info"
                ],
                "elements": "str"
            },
            "certificate-fingerprint": {"v_range": [["7.0.2", ""]], "type": "str"},
            "cloud-server-type": {"v_range": [["7.0.2", ""]], "choices": ["production", "alpha", "beta"], "type": "str"},
            "fortinetone-cloud-authentication": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "https-port": {"v_range": [["7.0.2", ""]], "type": "int"},
            "name": {"v_range": [["7.0.2", ""]], "required": true, "type": "str"},
            "out-of-sync-threshold": {"v_range": [["7.0.5", ""]], "type": "int"},
            "preserve-ssl-session": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pull-avatars": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pull-malware-hash": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pull-sysinfo": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pull-tags": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pull-vulnerabilities": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "server": {"v_range": [["7.0.2", ""]], "type": "str"},
            "source-ip": {"v_range": [["7.0.2", ""]], "type": "str"},
            "websocket-override": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status-check-interval": {"v_range": [["7.0.2", ""]], "type": "int"},
            "certificate": {"v_range": [["7.0.2", ""]], "type": "str"},
            "admin-username": {"v_range": [["7.0.2", "7.6.2"]], "type": "str"},
            "serial-number": {"v_range": [["7.0.2", ""]], "type": "str"},
            "admin-password": {"v_range": [["7.0.2", "7.6.2"]], "no_log": true, "type": "raw"},
            "interface": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "type": "str"},
            "interface-select-method": {"v_range": [["7.0.4", "7.0.14"], ["7.2.1", ""]], "choices": ["auto", "sdwan", "specify"], "type": "str"},
            "dirty-reason": {"v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]], "choices": ["none", "mismatched-ems-sn"], "type": "str"},
            "ems-id": {"v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]], "type": "int"},
            "status": {"v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ca-cn-info": {"v_range": [["7.0.6", "7.0.14"], ["7.2.2", ""]], "type": "str"},
            "trust-ca-cn": {"v_range": [["7.0.6", "7.0.14"], ["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tenant-id": {"v_range": [["7.2.1", ""]], "type": "str"},
            "send-tags-to-all-vdoms": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "verified-cn": {"v_range": [["7.4.2", ""]], "type": "str"},
            "verifying-ca": {"v_range": [["7.4.2", ""]], "type": "str"},
            "cloud-authentication-access-key": {"v_range": [["7.4.3", ""]], "no_log": true, "type": "str"}
        }
    },
    "exec_fgfm_reclaimdevtunnel": {
        "stated": true,
        "options": {"flags": {"v_range": [["6.0.0", "7.6.1"]], "type": "list", "choices": ["force", "get_info"], "elements": "str"}}
    },
    "extendercontroller_dataplan": {
        "stated": true,
        "options": {
            "apn": {"v_range": [["6.4.4", ""]], "type": "str"},
            "auth-type": {"v_range": [["6.4.4", ""]], "choices": ["none", "pap", "chap"], "type": "str"},
            "billing-date": {"v_range": [["6.4.4", ""]], "type": "int"},
            "capacity": {"v_range": [["6.4.4", ""]], "type": "int"},
            "carrier": {"v_range": [["6.4.4", ""]], "type": "str"},
            "iccid": {"v_range": [["6.4.4", ""]], "type": "str"},
            "modem-id": {"v_range": [["6.4.4", ""]], "choices": ["all", "modem1", "modem2"], "type": "str"},
            "monthly-fee": {"v_range": [["6.4.4", ""]], "type": "int"},
            "name": {"v_range": [["6.4.4", ""]], "required": true, "type": "str"},
            "overage": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "password": {"v_range": [["6.4.4", ""]], "no_log": true, "type": "raw"},
            "pdn": {"v_range": [["6.4.4", ""]], "choices": ["ipv4-only", "ipv6-only", "ipv4-ipv6"], "type": "str"},
            "preferred-subnet": {"v_range": [["6.4.4", ""]], "type": "int"},
            "private-network": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "signal-period": {"v_range": [["6.4.4", ""]], "type": "int"},
            "signal-threshold": {"v_range": [["6.4.4", ""]], "type": "int"},
            "slot": {"v_range": [["6.4.4", ""]], "choices": ["sim1", "sim2"], "type": "str"},
            "status": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["6.4.4", ""]], "choices": ["carrier", "slot", "iccid", "generic"], "type": "str"},
            "username": {"v_range": [["6.4.4", ""]], "type": "str"}
        }
    },
    "extendercontroller_extenderprofile": {
        "stated": true,
        "options": {
            "allowaccess": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["https", "ping", "ssh", "snmp", "http", "telnet"], "elements": "str"},
            "bandwidth-limit": {"v_range": [["7.0.2", ""]], "type": "int"},
            "cellular": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "controller-report": {
                        "v_range": [["7.0.2", ""]],
                        "type": "dict",
                        "options": {
                            "interval": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "signal-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                        }
                    },
                    "dataplan": {"v_range": [["7.0.2", ""]], "type": "raw"},
                    "modem1": {
                        "v_range": [["7.0.2", ""]],
                        "type": "dict",
                        "options": {
                            "auto-switch": {
                                "v_range": [["7.0.2", ""]],
                                "type": "dict",
                                "options": {
                                    "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
                                    "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                                    "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                                    "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
                                }
                            },
                            "conn-status": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "default-sim": {"v_range": [["7.0.2", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                            "gps": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "modem-id": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "preferred-carrier": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "redundant-intf": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "redundant-mode": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"},
                            "sim2-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim2-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"}
                        }
                    },
                    "modem2": {
                        "v_range": [["7.0.2", ""]],
                        "type": "dict",
                        "options": {
                            "auto-switch": {
                                "v_range": [["7.0.2", ""]],
                                "type": "dict",
                                "options": {
                                    "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
                                    "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                                    "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                                    "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
                                }
                            },
                            "conn-status": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "default-sim": {"v_range": [["7.0.2", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                            "gps": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "modem-id": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "preferred-carrier": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "redundant-intf": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "redundant-mode": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"},
                            "sim2-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim2-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"}
                        }
                    },
                    "sms-notification": {
                        "v_range": [["7.0.2", ""]],
                        "type": "dict",
                        "options": {
                            "alert": {
                                "v_range": [["7.0.2", ""]],
                                "type": "dict",
                                "options": {
                                    "data-exhausted": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "fgt-backup-mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "low-signal-strength": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "os-image-fallback": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "session-disconnect": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "system-reboot": {"v_range": [["7.0.2", ""]], "type": "str"}
                                }
                            },
                            "receiver": {
                                "v_range": [["7.0.2", ""]],
                                "type": "list",
                                "options": {
                                    "alert": {
                                        "v_range": [["7.0.2", ""]],
                                        "type": "list",
                                        "choices": [
                                            "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch",
                                            "os-image-fallback", "fgt-backup-mode-switch"
                                        ],
                                        "elements": "str"
                                    },
                                    "name": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "phone-number": {"v_range": [["7.0.2", ""]], "type": "str"},
                                    "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                                },
                                "elements": "dict"
                            },
                            "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                        }
                    }
                }
            },
            "enforce-bandwidth": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "extension": {"v_range": [["7.0.2", ""]], "choices": ["wan-extension", "lan-extension"], "type": "str"},
            "id": {"v_range": [["7.0.2", ""]], "required": true, "type": "int"},
            "lan-extension": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "backhaul": {
                        "v_range": [["7.0.2", ""]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "port": {
                                "v_range": [["7.0.2", ""]],
                                "choices": ["wan", "lte1", "lte2", "port1", "port2", "port3", "port4", "port5", "sfp"],
                                "type": "str"
                            },
                            "role": {"v_range": [["7.0.2", ""]], "choices": ["primary", "secondary"], "type": "str"},
                            "weight": {"v_range": [["7.0.2", ""]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "backhaul-interface": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "backhaul-ip": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "ipsec-tunnel": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "link-loadbalance": {"v_range": [["7.0.2", ""]], "choices": ["activebackup", "loadbalance"], "type": "str"}
                }
            },
            "login-password": {"v_range": [["7.0.2", ""]], "no_log": true, "type": "raw"},
            "login-password-change": {"v_range": [["7.0.2", ""]], "choices": ["no", "yes", "default"], "type": "str"},
            "model": {
                "v_range": [["7.0.2", ""]],
                "choices": [
                    "FX201E", "FX211E", "FX200F", "FXA11F", "FXE11F", "FXA21F", "FXE21F", "FXA22F", "FXE22F", "FX212F", "FX311F", "FX312F", "FX511F",
                    "FVG21F", "FVA21F", "FVG22F", "FVA22F", "FX04DA", "FX04DN", "FX04DI"
                ],
                "type": "str"
            },
            "name": {"v_range": [["7.0.2", ""]], "type": "str"}
        }
    },
    "extendercontroller_extenderprofile_cellular": {
        "stated": false,
        "options": {
            "controller-report": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "interval": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "signal-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "dataplan": {"v_range": [["7.0.2", ""]], "type": "raw"},
            "modem1": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "auto-switch": {
                        "v_range": [["7.0.2", ""]],
                        "type": "dict",
                        "options": {
                            "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                            "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
                        }
                    },
                    "conn-status": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "default-sim": {"v_range": [["7.0.2", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                    "gps": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "modem-id": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "preferred-carrier": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "redundant-intf": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "redundant-mode": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"},
                    "sim2-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim2-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"}
                }
            },
            "modem2": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "auto-switch": {
                        "v_range": [["7.0.2", ""]],
                        "type": "dict",
                        "options": {
                            "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                            "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
                        }
                    },
                    "conn-status": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "default-sim": {"v_range": [["7.0.2", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                    "gps": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "modem-id": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "preferred-carrier": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "redundant-intf": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "redundant-mode": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"},
                    "sim2-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim2-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"}
                }
            },
            "sms-notification": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "alert": {
                        "v_range": [["7.0.2", ""]],
                        "type": "dict",
                        "options": {
                            "data-exhausted": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "fgt-backup-mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "low-signal-strength": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "os-image-fallback": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "session-disconnect": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "system-reboot": {"v_range": [["7.0.2", ""]], "type": "str"}
                        }
                    },
                    "receiver": {
                        "v_range": [["7.0.2", ""]],
                        "type": "list",
                        "options": {
                            "alert": {
                                "v_range": [["7.0.2", ""]],
                                "type": "list",
                                "choices": [
                                    "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch", "os-image-fallback",
                                    "fgt-backup-mode-switch"
                                ],
                                "elements": "str"
                            },
                            "name": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "phone-number": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            }
        }
    },
    "extendercontroller_extenderprofile_cellular_controllerreport": {
        "stated": false,
        "options": {
            "interval": {"v_range": [["7.0.2", ""]], "type": "int"},
            "signal-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
            "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extendercontroller_extenderprofile_cellular_modem1": {
        "stated": false,
        "options": {
            "auto-switch": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                    "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
                }
            },
            "conn-status": {"v_range": [["7.0.2", ""]], "type": "int"},
            "default-sim": {"v_range": [["7.0.2", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
            "gps": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "modem-id": {"v_range": [["7.0.2", ""]], "type": "int"},
            "preferred-carrier": {"v_range": [["7.0.2", ""]], "type": "str"},
            "redundant-intf": {"v_range": [["7.0.2", ""]], "type": "str"},
            "redundant-mode": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"},
            "sim2-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim2-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"}
        }
    },
    "extendercontroller_extenderprofile_cellular_modem1_autoswitch": {
        "stated": false,
        "options": {
            "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
            "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
            "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
            "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
            "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
        }
    },
    "extendercontroller_extenderprofile_cellular_modem2": {
        "stated": false,
        "options": {
            "auto-switch": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                    "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
                }
            },
            "conn-status": {"v_range": [["7.0.2", ""]], "type": "int"},
            "default-sim": {"v_range": [["7.0.2", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
            "gps": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "modem-id": {"v_range": [["7.0.2", ""]], "type": "int"},
            "preferred-carrier": {"v_range": [["7.0.2", ""]], "type": "str"},
            "redundant-intf": {"v_range": [["7.0.2", ""]], "type": "str"},
            "redundant-mode": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"},
            "sim2-pin": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim2-pin-code": {"v_range": [["7.0.2", ""]], "type": "raw"}
        }
    },
    "extendercontroller_extenderprofile_cellular_modem2_autoswitch": {
        "stated": false,
        "options": {
            "dataplan": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect-period": {"v_range": [["7.0.2", ""]], "type": "int"},
            "disconnect-threshold": {"v_range": [["7.0.2", ""]], "type": "int"},
            "signal": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "switch-back": {"v_range": [["7.0.2", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
            "switch-back-time": {"v_range": [["7.0.2", ""]], "type": "str"},
            "switch-back-timer": {"v_range": [["7.0.2", ""]], "type": "int"}
        }
    },
    "extendercontroller_extenderprofile_cellular_smsnotification": {
        "stated": false,
        "options": {
            "alert": {
                "v_range": [["7.0.2", ""]],
                "type": "dict",
                "options": {
                    "data-exhausted": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "fgt-backup-mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "low-signal-strength": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "os-image-fallback": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "session-disconnect": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "system-reboot": {"v_range": [["7.0.2", ""]], "type": "str"}
                }
            },
            "receiver": {
                "v_range": [["7.0.2", ""]],
                "type": "list",
                "options": {
                    "alert": {
                        "v_range": [["7.0.2", ""]],
                        "type": "list",
                        "choices": [
                            "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch", "os-image-fallback",
                            "fgt-backup-mode-switch"
                        ],
                        "elements": "str"
                    },
                    "name": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "phone-number": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extendercontroller_extenderprofile_cellular_smsnotification_alert": {
        "stated": false,
        "options": {
            "data-exhausted": {"v_range": [["7.0.2", ""]], "type": "str"},
            "fgt-backup-mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
            "low-signal-strength": {"v_range": [["7.0.2", ""]], "type": "str"},
            "mode-switch": {"v_range": [["7.0.2", ""]], "type": "str"},
            "os-image-fallback": {"v_range": [["7.0.2", ""]], "type": "str"},
            "session-disconnect": {"v_range": [["7.0.2", ""]], "type": "str"},
            "system-reboot": {"v_range": [["7.0.2", ""]], "type": "str"}
        }
    },
    "extendercontroller_extenderprofile_cellular_smsnotification_receiver": {
        "stated": true,
        "options": {
            "alert": {
                "v_range": [["7.0.2", ""]],
                "type": "list",
                "choices": [
                    "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch", "os-image-fallback",
                    "fgt-backup-mode-switch"
                ],
                "elements": "str"
            },
            "name": {"v_range": [["7.0.2", ""]], "required": true, "type": "str"},
            "phone-number": {"v_range": [["7.0.2", ""]], "type": "str"},
            "status": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extendercontroller_extenderprofile_lanextension": {
        "stated": false,
        "options": {
            "backhaul": {
                "v_range": [["7.0.2", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "port": {
                        "v_range": [["7.0.2", ""]],
                        "choices": ["wan", "lte1", "lte2", "port1", "port2", "port3", "port4", "port5", "sfp"],
                        "type": "str"
                    },
                    "role": {"v_range": [["7.0.2", ""]], "choices": ["primary", "secondary"], "type": "str"},
                    "weight": {"v_range": [["7.0.2", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "backhaul-interface": {"v_range": [["7.0.2", ""]], "type": "str"},
            "backhaul-ip": {"v_range": [["7.0.2", ""]], "type": "str"},
            "ipsec-tunnel": {"v_range": [["7.0.2", ""]], "type": "str"},
            "link-loadbalance": {"v_range": [["7.0.2", ""]], "choices": ["activebackup", "loadbalance"], "type": "str"}
        }
    },
    "extendercontroller_extenderprofile_lanextension_backhaul": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.0.2", ""]], "required": true, "type": "str"},
            "port": {"v_range": [["7.0.2", ""]], "choices": ["wan", "lte1", "lte2", "port1", "port2", "port3", "port4", "port5", "sfp"], "type": "str"},
            "role": {"v_range": [["7.0.2", ""]], "choices": ["primary", "secondary"], "type": "str"},
            "weight": {"v_range": [["7.0.2", ""]], "type": "int"}
        }
    },
    "extendercontroller_simprofile": {
        "stated": true,
        "options": {
            "auto-switch_profile": {
                "v_range": [["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "dataplan": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect-period": {"v_range": [["6.4.5", ""]], "type": "int"},
                    "disconnect-threshold": {"v_range": [["6.4.5", ""]], "type": "int"},
                    "signal": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "switch-back": {"v_range": [["6.4.5", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                    "switch-back-time": {"v_range": [["6.4.5", ""]], "type": "str"},
                    "switch-back-timer": {"v_range": [["6.4.5", ""]], "type": "int"}
                }
            },
            "conn-status": {"v_range": [["6.4.4", ""]], "type": "int"},
            "default-sim": {"v_range": [["6.4.4", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
            "description": {"v_range": [["6.4.4", ""]], "type": "str"},
            "gps": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "modem-id": {"v_range": [["6.4.4", ""]], "type": "int"},
            "name": {"v_range": [["6.4.4", ""]], "required": true, "type": "str"},
            "preferred-carrier": {"v_range": [["6.4.4", ""]], "type": "str"},
            "redundant-intf": {"v_range": [["6.4.4", ""]], "type": "str"},
            "redundant-mode": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin-code": {"v_range": [["6.4.4", ""]], "type": "raw"},
            "sim2-pin": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim2-pin-code": {"v_range": [["6.4.4", ""]], "type": "raw"},
            "status": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extendercontroller_simprofile_autoswitchprofile": {
        "stated": false,
        "options": {
            "dataplan": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect-period": {"v_range": [["6.4.4", ""]], "type": "int"},
            "disconnect-threshold": {"v_range": [["6.4.4", ""]], "type": "int"},
            "signal": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "switch-back": {"v_range": [["6.4.4", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
            "switch-back-time": {"v_range": [["6.4.4", ""]], "type": "str"},
            "switch-back-timer": {"v_range": [["6.4.4", ""]], "type": "int"}
        }
    },
    "extendercontroller_template": {
        "stated": true,
        "options": {
            "dataplan": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "description": {"v_range": [["7.0.0", ""]], "type": "str"},
            "modem1_ifname": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "modem1_sim_profile": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "modem2_ifname": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "modem2_sim_profile": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "name": {"v_range": [["7.0.0", ""]], "required": true, "type": "str"}
        }
    },
    "extensioncontroller_dataplan": {
        "stated": true,
        "options": {
            "apn": {"v_range": [["7.2.1", ""]], "type": "str"},
            "auth-type": {"v_range": [["7.2.1", ""]], "choices": ["none", "pap", "chap"], "type": "str"},
            "billing-date": {"v_range": [["7.2.1", ""]], "type": "int"},
            "capacity": {"v_range": [["7.2.1", ""]], "type": "int"},
            "carrier": {"v_range": [["7.2.1", ""]], "type": "str"},
            "iccid": {"v_range": [["7.2.1", ""]], "type": "str"},
            "modem-id": {"v_range": [["7.2.1", ""]], "choices": ["all", "modem1", "modem2"], "type": "str"},
            "monthly-fee": {"v_range": [["7.2.1", ""]], "type": "int"},
            "name": {"v_range": [["7.2.1", ""]], "required": true, "type": "str"},
            "overage": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "password": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
            "pdn": {"v_range": [["7.2.1", ""]], "choices": ["ipv4-only", "ipv6-only", "ipv4-ipv6"], "type": "str"},
            "preferred-subnet": {"v_range": [["7.2.1", ""]], "type": "int"},
            "private-network": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "signal-period": {"v_range": [["7.2.1", ""]], "type": "int"},
            "signal-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
            "slot": {"v_range": [["7.2.1", ""]], "choices": ["sim1", "sim2"], "type": "str"},
            "type": {"v_range": [["7.2.1", ""]], "choices": ["carrier", "slot", "iccid", "generic"], "type": "str"},
            "username": {"v_range": [["7.2.1", ""]], "type": "str"}
        }
    },
    "extensioncontroller_extenderprofile": {
        "stated": true,
        "options": {
            "allowaccess": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["https", "ping", "ssh", "snmp", "http", "telnet"], "elements": "str"},
            "bandwidth-limit": {"v_range": [["7.2.1", ""]], "type": "int"},
            "cellular": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "controller-report": {
                        "v_range": [["7.2.1", ""]],
                        "type": "dict",
                        "options": {
                            "interval": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "signal-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                        }
                    },
                    "dataplan": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "modem1": {
                        "v_range": [["7.2.1", ""]],
                        "type": "dict",
                        "options": {
                            "auto-switch": {
                                "v_range": [["7.2.1", ""]],
                                "type": "dict",
                                "options": {
                                    "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
                                    "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                                    "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                                    "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
                                }
                            },
                            "conn-status": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "default-sim": {"v_range": [["7.2.1", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                            "gps": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "modem-id": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "preferred-carrier": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "redundant-intf": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "redundant-mode": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                            "sim2-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim2-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                            "multiple-PDN": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "pdn1-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "pdn2-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "pdn3-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "pdn4-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"}
                        }
                    },
                    "modem2": {
                        "v_range": [["7.2.1", ""]],
                        "type": "dict",
                        "options": {
                            "auto-switch": {
                                "v_range": [["7.2.1", ""]],
                                "type": "dict",
                                "options": {
                                    "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
                                    "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                                    "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                                    "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
                                }
                            },
                            "conn-status": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "default-sim": {"v_range": [["7.2.1", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                            "gps": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "modem-id": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "preferred-carrier": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "redundant-intf": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "redundant-mode": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim1-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                            "sim2-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "sim2-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                            "multiple-PDN": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "pdn1-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "pdn2-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "pdn3-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "pdn4-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"}
                        }
                    },
                    "sms-notification": {
                        "v_range": [["7.2.1", ""]],
                        "type": "dict",
                        "options": {
                            "alert": {
                                "v_range": [["7.2.1", ""]],
                                "type": "dict",
                                "options": {
                                    "data-exhausted": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "fgt-backup-mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "low-signal-strength": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "os-image-fallback": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "session-disconnect": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "system-reboot": {"v_range": [["7.2.1", ""]], "type": "str"}
                                }
                            },
                            "receiver": {
                                "v_range": [["7.2.1", ""]],
                                "type": "list",
                                "options": {
                                    "alert": {
                                        "v_range": [["7.2.1", ""]],
                                        "type": "list",
                                        "choices": [
                                            "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch",
                                            "os-image-fallback", "fgt-backup-mode-switch"
                                        ],
                                        "elements": "str"
                                    },
                                    "name": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "phone-number": {"v_range": [["7.2.1", ""]], "type": "str"},
                                    "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                                },
                                "elements": "dict"
                            },
                            "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                        }
                    }
                }
            },
            "enforce-bandwidth": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "extension": {"v_range": [["7.2.1", ""]], "choices": ["wan-extension", "lan-extension"], "type": "str"},
            "id": {"v_range": [["7.2.1", ""]], "required": true, "type": "int"},
            "lan-extension": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "backhaul": {
                        "v_range": [["7.2.1", ""]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "port": {
                                "v_range": [["7.2.1", ""]],
                                "choices": ["wan", "lte1", "lte2", "port1", "port2", "port3", "port4", "port5", "sfp"],
                                "type": "str"
                            },
                            "role": {"v_range": [["7.2.1", ""]], "choices": ["primary", "secondary"], "type": "str"},
                            "weight": {"v_range": [["7.2.1", ""]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "backhaul-interface": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "backhaul-ip": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "ipsec-tunnel": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "link-loadbalance": {"v_range": [["7.2.1", ""]], "choices": ["activebackup", "loadbalance"], "type": "str"},
                    "downlinks": {
                        "v_range": [["7.6.0", ""]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["7.6.0", ""]], "type": "str"},
                            "port": {"v_range": [["7.6.0", ""]], "choices": ["port1", "port2", "port3", "port4", "port5", "lan1", "lan2"], "type": "str"},
                            "pvid": {"v_range": [["7.6.0", ""]], "type": "int"},
                            "type": {"v_range": [["7.6.0", ""]], "choices": ["port", "vap"], "type": "str"},
                            "vap": {"v_range": [["7.6.0", ""]], "type": "raw"}
                        },
                        "elements": "dict"
                    },
                    "traffic-split-services": {
                        "v_range": [["7.6.2", ""]],
                        "type": "list",
                        "options": {
                            "address": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "name": {"v_range": [["7.6.2", ""]], "type": "str"},
                            "service": {"v_range": [["7.6.2", ""]], "type": "raw"},
                            "vsdb": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    }
                }
            },
            "login-password": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
            "login-password-change": {"v_range": [["7.2.1", ""]], "choices": ["no", "yes", "default"], "type": "str"},
            "model": {
                "v_range": [["7.2.1", ""]],
                "choices": [
                    "FX201E", "FX211E", "FX200F", "FXA11F", "FXE11F", "FXA21F", "FXE21F", "FXA22F", "FXE22F", "FX212F", "FX311F", "FX312F", "FX511F",
                    "FVG21F", "FVA21F", "FVG22F", "FVA22F", "FX04DA", "FX04DN", "FX04DI", "FXR51G", "FG", "BS10FW", "BS20GW", "BS20GN", "FXN51G",
                    "FXW51G", "FVG51G", "FXE11G"
                ],
                "type": "str"
            },
            "name": {"v_range": [["7.2.1", ""]], "type": "str"},
            "_is_factory_setting": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable", "ext"], "type": "str"},
            "wifi": {
                "v_range": [["7.4.3", ""]],
                "type": "dict",
                "options": {
                    "DFS": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "country": {
                        "v_range": [["7.4.3", ""]],
                        "choices": [
                            "AL", "DZ", "AR", "AM", "AU", "AT", "AZ", "BH", "BD", "BY", "BE", "BZ", "BO", "BA", "BR", "BN", "BG", "CA", "CL", "CN", "CO",
                            "CR", "HR", "CY", "CZ", "DK", "DO", "EC", "EG", "SV", "EE", "FI", "FR", "GE", "DE", "GR", "GT", "HN", "HK", "HU", "IS", "IN",
                            "ID", "IE", "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KR", "KW", "LV", "LB", "LI", "LT", "LU", "MO", "MK", "MY", "MT", "MX",
                            "MC", "MA", "NP", "NL", "AN", "NZ", "NO", "OM", "PK", "PA", "PG", "PE", "PH", "PL", "PT", "PR", "QA", "RO", "RU", "SA", "SG",
                            "SK", "SI", "ZA", "ES", "LK", "SE", "CH", "TW", "TH", "TT", "TN", "TR", "AE", "UA", "GB", "US", "PS", "UY", "UZ", "VE", "VN",
                            "YE", "ZW", "NA", "BS", "VC", "KH", "MV", "AF", "NG", "TZ", "ZM", "SN", "CI", "GH", "CM", "MW", "AO", "GA", "ML", "BJ", "MG",
                            "TD", "BW", "LY", "RW", "MZ", "GM", "LS", "MU", "CG", "UG", "BF", "SL", "SO", "CD", "NE", "CF", "SZ", "TG", "LR", "MR", "DJ",
                            "RE", "RS", "ME", "IQ", "MD", "KY", "BB", "BM", "TC", "VI", "PM", "MF", "GD", "IM", "FO", "GI", "GL", "TM", "MN", "VU", "FJ",
                            "LA", "GU", "WF", "MH", "BT", "FM", "PF", "NI", "PY", "HT", "GY", "AW", "KN", "GF", "AS", "MP", "PW", "MM", "LC", "GP", "ET",
                            "SR", "CX", "DM", "MQ", "YT", "BL", "--", "TL"
                        ],
                        "type": "str"
                    },
                    "radio-1": {
                        "v_range": [["7.4.3", ""]],
                        "type": "dict",
                        "options": {
                            "80211d": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "band": {"v_range": [["7.4.3", ""]], "choices": ["2.4GHz"], "type": "str"},
                            "bandwidth": {"v_range": [["7.4.3", ""]], "choices": ["auto", "20MHz", "40MHz", "80MHz"], "type": "str"},
                            "beacon-interval": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "bss-color": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "bss-color-mode": {"v_range": [["7.4.3", ""]], "choices": ["auto", "static"], "type": "str"},
                            "channel": {
                                "v_range": [["7.4.3", ""]],
                                "type": "list",
                                "choices": ["CH1", "CH2", "CH3", "CH4", "CH5", "CH6", "CH7", "CH8", "CH9", "CH10", "CH11"],
                                "elements": "str"
                            },
                            "extension-channel": {"v_range": [["7.4.3", ""]], "choices": ["auto", "higher", "lower"], "type": "str"},
                            "guard-interval": {"v_range": [["7.4.3", ""]], "choices": ["auto", "400ns", "800ns"], "type": "str"},
                            "lan-ext-vap": {"v_range": [["7.4.3", ""]], "type": "raw"},
                            "local-vaps": {"v_range": [["7.4.3", ""]], "type": "raw"},
                            "max-clients": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "mode": {"v_range": [["7.4.3", ""]], "choices": ["AP", "Client"], "type": "str"},
                            "operating-standard": {
                                "v_range": [["7.4.3", ""]],
                                "choices": [
                                    "auto", "11A-N-AC-AX", "11A-N-AC", "11A-N", "11A", "11N-AC-AX", "11AC-AX", "11AC", "11N-AC", "11B-G-N-AX", "11B-G-N",
                                    "11B-G", "11B", "11G-N-AX", "11N-AX", "11AX", "11G-N", "11N", "11G"
                                ],
                                "type": "str"
                            },
                            "power-level": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "radio-id": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "status": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                        }
                    },
                    "radio-2": {
                        "v_range": [["7.4.3", ""]],
                        "type": "dict",
                        "options": {
                            "80211d": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "band": {"v_range": [["7.4.3", ""]], "choices": ["5GHz"], "type": "str"},
                            "bandwidth": {"v_range": [["7.4.3", ""]], "choices": ["auto", "20MHz", "40MHz", "80MHz"], "type": "str"},
                            "beacon-interval": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "bss-color": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "bss-color-mode": {"v_range": [["7.4.3", ""]], "choices": ["auto", "static"], "type": "str"},
                            "channel": {
                                "v_range": [["7.4.3", ""]],
                                "type": "list",
                                "choices": [
                                    "CH36", "CH40", "CH44", "CH48", "CH52", "CH56", "CH60", "CH64", "CH100", "CH104", "CH108", "CH112", "CH116", "CH120",
                                    "CH124", "CH128", "CH132", "CH136", "CH140", "CH144", "CH149", "CH153", "CH157", "CH161", "CH165"
                                ],
                                "elements": "str"
                            },
                            "extension-channel": {"v_range": [["7.4.3", ""]], "choices": ["auto", "higher", "lower"], "type": "str"},
                            "guard-interval": {"v_range": [["7.4.3", ""]], "choices": ["auto", "400ns", "800ns"], "type": "str"},
                            "lan-ext-vap": {"v_range": [["7.4.3", ""]], "type": "raw"},
                            "local-vaps": {"v_range": [["7.4.3", ""]], "type": "raw"},
                            "max-clients": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "mode": {"v_range": [["7.4.3", ""]], "choices": ["AP", "Client"], "type": "str"},
                            "operating-standard": {
                                "v_range": [["7.4.3", ""]],
                                "choices": [
                                    "auto", "11A-N-AC-AX", "11A-N-AC", "11A-N", "11A", "11N-AC-AX", "11AC-AX", "11AC", "11N-AC", "11B-G-N-AX", "11B-G-N",
                                    "11B-G", "11B", "11G-N-AX", "11N-AX", "11AX", "11G-N", "11N", "11G"
                                ],
                                "type": "str"
                            },
                            "power-level": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "radio-id": {"v_range": [["7.4.3", ""]], "type": "int"},
                            "status": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                        }
                    }
                }
            }
        }
    },
    "extensioncontroller_extenderprofile_cellular": {
        "stated": false,
        "options": {
            "controller-report": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "interval": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "signal-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "dataplan": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "modem1": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "auto-switch": {
                        "v_range": [["7.2.1", ""]],
                        "type": "dict",
                        "options": {
                            "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                            "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
                        }
                    },
                    "conn-status": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "default-sim": {"v_range": [["7.2.1", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                    "gps": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "modem-id": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "preferred-carrier": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "redundant-intf": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "redundant-mode": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "sim2-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim2-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "multiple-PDN": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdn1-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "pdn2-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "pdn3-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "pdn4-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"}
                }
            },
            "modem2": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "auto-switch": {
                        "v_range": [["7.2.1", ""]],
                        "type": "dict",
                        "options": {
                            "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                            "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
                        }
                    },
                    "conn-status": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "default-sim": {"v_range": [["7.2.1", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
                    "gps": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "modem-id": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "preferred-carrier": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "redundant-intf": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "redundant-mode": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim1-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "sim2-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "sim2-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "multiple-PDN": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdn1-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "pdn2-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "pdn3-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "pdn4-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"}
                }
            },
            "sms-notification": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "alert": {
                        "v_range": [["7.2.1", ""]],
                        "type": "dict",
                        "options": {
                            "data-exhausted": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "fgt-backup-mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "low-signal-strength": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "os-image-fallback": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "session-disconnect": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "system-reboot": {"v_range": [["7.2.1", ""]], "type": "str"}
                        }
                    },
                    "receiver": {
                        "v_range": [["7.2.1", ""]],
                        "type": "list",
                        "options": {
                            "alert": {
                                "v_range": [["7.2.1", ""]],
                                "type": "list",
                                "choices": [
                                    "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch", "os-image-fallback",
                                    "fgt-backup-mode-switch"
                                ],
                                "elements": "str"
                            },
                            "name": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "phone-number": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            }
        }
    },
    "extensioncontroller_extenderprofile_cellular_controllerreport": {
        "stated": false,
        "options": {
            "interval": {"v_range": [["7.2.1", ""]], "type": "int"},
            "signal-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
            "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extensioncontroller_extenderprofile_cellular_modem1": {
        "stated": false,
        "options": {
            "auto-switch": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                    "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
                }
            },
            "conn-status": {"v_range": [["7.2.1", ""]], "type": "int"},
            "default-sim": {"v_range": [["7.2.1", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
            "gps": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "modem-id": {"v_range": [["7.2.1", ""]], "type": "int"},
            "preferred-carrier": {"v_range": [["7.2.1", ""]], "type": "str"},
            "redundant-intf": {"v_range": [["7.2.1", ""]], "type": "str"},
            "redundant-mode": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "sim2-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim2-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "multiple-PDN": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pdn1-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
            "pdn2-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
            "pdn3-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
            "pdn4-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"}
        }
    },
    "extensioncontroller_extenderprofile_cellular_modem1_autoswitch": {
        "stated": false,
        "options": {
            "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
            "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
            "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
            "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
            "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
        }
    },
    "extensioncontroller_extenderprofile_cellular_modem2": {
        "stated": false,
        "options": {
            "auto-switch": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
                    "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
                }
            },
            "conn-status": {"v_range": [["7.2.1", ""]], "type": "int"},
            "default-sim": {"v_range": [["7.2.1", ""]], "choices": ["sim1", "sim2", "carrier", "cost"], "type": "str"},
            "gps": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "modem-id": {"v_range": [["7.2.1", ""]], "type": "int"},
            "preferred-carrier": {"v_range": [["7.2.1", ""]], "type": "str"},
            "redundant-intf": {"v_range": [["7.2.1", ""]], "type": "str"},
            "redundant-mode": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim1-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "sim2-pin": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "sim2-pin-code": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "multiple-PDN": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "pdn1-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
            "pdn2-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
            "pdn3-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"},
            "pdn4-dataplan": {"v_range": [["7.6.2", ""]], "type": "raw"}
        }
    },
    "extensioncontroller_extenderprofile_cellular_modem2_autoswitch": {
        "stated": false,
        "options": {
            "dataplan": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "disconnect-period": {"v_range": [["7.2.1", ""]], "type": "int"},
            "disconnect-threshold": {"v_range": [["7.2.1", ""]], "type": "int"},
            "signal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "switch-back": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["time", "timer"], "elements": "str"},
            "switch-back-time": {"v_range": [["7.2.1", ""]], "type": "str"},
            "switch-back-timer": {"v_range": [["7.2.1", ""]], "type": "int"}
        }
    },
    "extensioncontroller_extenderprofile_cellular_smsnotification": {
        "stated": false,
        "options": {
            "alert": {
                "v_range": [["7.2.1", ""]],
                "type": "dict",
                "options": {
                    "data-exhausted": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "fgt-backup-mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "low-signal-strength": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "os-image-fallback": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "session-disconnect": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "system-reboot": {"v_range": [["7.2.1", ""]], "type": "str"}
                }
            },
            "receiver": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "alert": {
                        "v_range": [["7.2.1", ""]],
                        "type": "list",
                        "choices": [
                            "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch", "os-image-fallback",
                            "fgt-backup-mode-switch"
                        ],
                        "elements": "str"
                    },
                    "name": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "phone-number": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extensioncontroller_extenderprofile_cellular_smsnotification_alert": {
        "stated": false,
        "options": {
            "data-exhausted": {"v_range": [["7.2.1", ""]], "type": "str"},
            "fgt-backup-mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
            "low-signal-strength": {"v_range": [["7.2.1", ""]], "type": "str"},
            "mode-switch": {"v_range": [["7.2.1", ""]], "type": "str"},
            "os-image-fallback": {"v_range": [["7.2.1", ""]], "type": "str"},
            "session-disconnect": {"v_range": [["7.2.1", ""]], "type": "str"},
            "system-reboot": {"v_range": [["7.2.1", ""]], "type": "str"}
        }
    },
    "extensioncontroller_extenderprofile_cellular_smsnotification_receiver": {
        "stated": true,
        "options": {
            "alert": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "choices": [
                    "system-reboot", "data-exhausted", "session-disconnect", "low-signal-strength", "mode-switch", "os-image-fallback",
                    "fgt-backup-mode-switch"
                ],
                "elements": "str"
            },
            "name": {"v_range": [["7.2.1", ""]], "required": true, "type": "str"},
            "phone-number": {"v_range": [["7.2.1", ""]], "type": "str"},
            "status": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extensioncontroller_extenderprofile_lanextension": {
        "stated": false,
        "options": {
            "backhaul": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "port": {
                        "v_range": [["7.2.1", ""]],
                        "choices": ["wan", "lte1", "lte2", "port1", "port2", "port3", "port4", "port5", "sfp"],
                        "type": "str"
                    },
                    "role": {"v_range": [["7.2.1", ""]], "choices": ["primary", "secondary"], "type": "str"},
                    "weight": {"v_range": [["7.2.1", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "backhaul-interface": {"v_range": [["7.2.1", ""]], "type": "str"},
            "backhaul-ip": {"v_range": [["7.2.1", ""]], "type": "str"},
            "ipsec-tunnel": {"v_range": [["7.2.1", ""]], "type": "str"},
            "link-loadbalance": {"v_range": [["7.2.1", ""]], "choices": ["activebackup", "loadbalance"], "type": "str"},
            "downlinks": {
                "v_range": [["7.6.0", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.6.0", ""]], "type": "str"},
                    "port": {"v_range": [["7.6.0", ""]], "choices": ["port1", "port2", "port3", "port4", "port5", "lan1", "lan2"], "type": "str"},
                    "pvid": {"v_range": [["7.6.0", ""]], "type": "int"},
                    "type": {"v_range": [["7.6.0", ""]], "choices": ["port", "vap"], "type": "str"},
                    "vap": {"v_range": [["7.6.0", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "traffic-split-services": {
                "v_range": [["7.6.2", ""]],
                "type": "list",
                "options": {
                    "address": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "name": {"v_range": [["7.6.2", ""]], "type": "str"},
                    "service": {"v_range": [["7.6.2", ""]], "type": "raw"},
                    "vsdb": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            }
        }
    },
    "extensioncontroller_extenderprofile_lanextension_backhaul": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.2.1", ""]], "required": true, "type": "str"},
            "port": {"v_range": [["7.2.1", ""]], "choices": ["wan", "lte1", "lte2", "port1", "port2", "port3", "port4", "port5", "sfp"], "type": "str"},
            "role": {"v_range": [["7.2.1", ""]], "choices": ["primary", "secondary"], "type": "str"},
            "weight": {"v_range": [["7.2.1", ""]], "type": "int"}
        }
    },
    "extensioncontroller_extenderprofile_wifi": {
        "stated": false,
        "options": {
            "DFS": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "country": {
                "v_range": [["7.4.3", ""]],
                "choices": [
                    "AL", "DZ", "AR", "AM", "AU", "AT", "AZ", "BH", "BD", "BY", "BE", "BZ", "BO", "BA", "BR", "BN", "BG", "CA", "CL", "CN", "CO", "CR",
                    "HR", "CY", "CZ", "DK", "DO", "EC", "EG", "SV", "EE", "FI", "FR", "GE", "DE", "GR", "GT", "HN", "HK", "HU", "IS", "IN", "ID", "IE",
                    "IL", "IT", "JM", "JP", "JO", "KZ", "KE", "KR", "KW", "LV", "LB", "LI", "LT", "LU", "MO", "MK", "MY", "MT", "MX", "MC", "MA", "NP",
                    "NL", "AN", "NZ", "NO", "OM", "PK", "PA", "PG", "PE", "PH", "PL", "PT", "PR", "QA", "RO", "RU", "SA", "SG", "SK", "SI", "ZA", "ES",
                    "LK", "SE", "CH", "TW", "TH", "TT", "TN", "TR", "AE", "UA", "GB", "US", "PS", "UY", "UZ", "VE", "VN", "YE", "ZW", "NA", "BS", "VC",
                    "KH", "MV", "AF", "NG", "TZ", "ZM", "SN", "CI", "GH", "CM", "MW", "AO", "GA", "ML", "BJ", "MG", "TD", "BW", "LY", "RW", "MZ", "GM",
                    "LS", "MU", "CG", "UG", "BF", "SL", "SO", "CD", "NE", "CF", "SZ", "TG", "LR", "MR", "DJ", "RE", "RS", "ME", "IQ", "MD", "KY", "BB",
                    "BM", "TC", "VI", "PM", "MF", "GD", "IM", "FO", "GI", "GL", "TM", "MN", "VU", "FJ", "LA", "GU", "WF", "MH", "BT", "FM", "PF", "NI",
                    "PY", "HT", "GY", "AW", "KN", "GF", "AS", "MP", "PW", "MM", "LC", "GP", "ET", "SR", "CX", "DM", "MQ", "YT", "BL", "--", "TL"
                ],
                "type": "str"
            },
            "radio-1": {
                "v_range": [["7.4.3", ""]],
                "type": "dict",
                "options": {
                    "80211d": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "band": {"v_range": [["7.4.3", ""]], "choices": ["2.4GHz"], "type": "str"},
                    "bandwidth": {"v_range": [["7.4.3", ""]], "choices": ["auto", "20MHz", "40MHz", "80MHz"], "type": "str"},
                    "beacon-interval": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "bss-color": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "bss-color-mode": {"v_range": [["7.4.3", ""]], "choices": ["auto", "static"], "type": "str"},
                    "channel": {
                        "v_range": [["7.4.3", ""]],
                        "type": "list",
                        "choices": ["CH1", "CH2", "CH3", "CH4", "CH5", "CH6", "CH7", "CH8", "CH9", "CH10", "CH11"],
                        "elements": "str"
                    },
                    "extension-channel": {"v_range": [["7.4.3", ""]], "choices": ["auto", "higher", "lower"], "type": "str"},
                    "guard-interval": {"v_range": [["7.4.3", ""]], "choices": ["auto", "400ns", "800ns"], "type": "str"},
                    "lan-ext-vap": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
                    "local-vaps": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
                    "max-clients": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "mode": {"v_range": [["7.4.3", ""]], "choices": ["AP", "Client"], "type": "str"},
                    "operating-standard": {
                        "v_range": [["7.4.3", ""]],
                        "choices": [
                            "auto", "11A-N-AC-AX", "11A-N-AC", "11A-N", "11A", "11N-AC-AX", "11AC-AX", "11AC", "11N-AC", "11B-G-N-AX", "11B-G-N",
                            "11B-G", "11B", "11G-N-AX", "11N-AX", "11AX", "11G-N", "11N", "11G"
                        ],
                        "type": "str"
                    },
                    "power-level": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "radio-id": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "status": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "radio-2": {
                "v_range": [["7.4.3", ""]],
                "type": "dict",
                "options": {
                    "80211d": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "band": {"v_range": [["7.4.3", ""]], "choices": ["5GHz"], "type": "str"},
                    "bandwidth": {"v_range": [["7.4.3", ""]], "choices": ["auto", "20MHz", "40MHz", "80MHz"], "type": "str"},
                    "beacon-interval": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "bss-color": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "bss-color-mode": {"v_range": [["7.4.3", ""]], "choices": ["auto", "static"], "type": "str"},
                    "channel": {
                        "v_range": [["7.4.3", ""]],
                        "type": "list",
                        "choices": [
                            "CH36", "CH40", "CH44", "CH48", "CH52", "CH56", "CH60", "CH64", "CH100", "CH104", "CH108", "CH112", "CH116", "CH120",
                            "CH124", "CH128", "CH132", "CH136", "CH140", "CH144", "CH149", "CH153", "CH157", "CH161", "CH165"
                        ],
                        "elements": "str"
                    },
                    "extension-channel": {"v_range": [["7.4.3", ""]], "choices": ["auto", "higher", "lower"], "type": "str"},
                    "guard-interval": {"v_range": [["7.4.3", ""]], "choices": ["auto", "400ns", "800ns"], "type": "str"},
                    "lan-ext-vap": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
                    "local-vaps": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
                    "max-clients": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "mode": {"v_range": [["7.4.3", ""]], "choices": ["AP", "Client"], "type": "str"},
                    "operating-standard": {
                        "v_range": [["7.4.3", ""]],
                        "choices": [
                            "auto", "11A-N-AC-AX", "11A-N-AC", "11A-N", "11A", "11N-AC-AX", "11AC-AX", "11AC", "11N-AC", "11B-G-N-AX", "11B-G-N",
                            "11B-G", "11B", "11G-N-AX", "11N-AX", "11AX", "11G-N", "11N", "11G"
                        ],
                        "type": "str"
                    },
                    "power-level": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "radio-id": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "status": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            }
        }
    },
    "extensioncontroller_extenderprofile_wifi_radio1": {
        "stated": false,
        "options": {
            "80211d": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "band": {"v_range": [["7.4.3", ""]], "choices": ["2.4GHz"], "type": "str"},
            "bandwidth": {"v_range": [["7.4.3", ""]], "choices": ["auto", "20MHz", "40MHz", "80MHz"], "type": "str"},
            "beacon-interval": {"v_range": [["7.4.3", ""]], "type": "int"},
            "bss-color": {"v_range": [["7.4.3", ""]], "type": "int"},
            "bss-color-mode": {"v_range": [["7.4.3", ""]], "choices": ["auto", "static"], "type": "str"},
            "channel": {
                "v_range": [["7.4.3", ""]],
                "type": "list",
                "choices": ["CH1", "CH2", "CH3", "CH4", "CH5", "CH6", "CH7", "CH8", "CH9", "CH10", "CH11"],
                "elements": "str"
            },
            "extension-channel": {"v_range": [["7.4.3", ""]], "choices": ["auto", "higher", "lower"], "type": "str"},
            "guard-interval": {"v_range": [["7.4.3", ""]], "choices": ["auto", "400ns", "800ns"], "type": "str"},
            "lan-ext-vap": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
            "local-vaps": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
            "max-clients": {"v_range": [["7.4.3", ""]], "type": "int"},
            "mode": {"v_range": [["7.4.3", ""]], "choices": ["AP", "Client"], "type": "str"},
            "operating-standard": {
                "v_range": [["7.4.3", ""]],
                "choices": [
                    "auto", "11A-N-AC-AX", "11A-N-AC", "11A-N", "11A", "11N-AC-AX", "11AC-AX", "11AC", "11N-AC", "11B-G-N-AX", "11B-G-N", "11B-G", "11B",
                    "11G-N-AX", "11N-AX", "11AX", "11G-N", "11N", "11G"
                ],
                "type": "str"
            },
            "power-level": {"v_range": [["7.4.3", ""]], "type": "int"},
            "radio-id": {"v_range": [["7.4.3", ""]], "type": "int"},
            "status": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extensioncontroller_extenderprofile_wifi_radio2": {
        "stated": false,
        "options": {
            "80211d": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "band": {"v_range": [["7.4.3", ""]], "choices": ["5GHz"], "type": "str"},
            "bandwidth": {"v_range": [["7.4.3", ""]], "choices": ["auto", "20MHz", "40MHz", "80MHz"], "type": "str"},
            "beacon-interval": {"v_range": [["7.4.3", ""]], "type": "int"},
            "bss-color": {"v_range": [["7.4.3", ""]], "type": "int"},
            "bss-color-mode": {"v_range": [["7.4.3", ""]], "choices": ["auto", "static"], "type": "str"},
            "channel": {
                "v_range": [["7.4.3", ""]],
                "type": "list",
                "choices": [
                    "CH36", "CH40", "CH44", "CH48", "CH52", "CH56", "CH60", "CH64", "CH100", "CH104", "CH108", "CH112", "CH116", "CH120", "CH124",
                    "CH128", "CH132", "CH136", "CH140", "CH144", "CH149", "CH153", "CH157", "CH161", "CH165"
                ],
                "elements": "str"
            },
            "extension-channel": {"v_range": [["7.4.3", ""]], "choices": ["auto", "higher", "lower"], "type": "str"},
            "guard-interval": {"v_range": [["7.4.3", ""]], "choices": ["auto", "400ns", "800ns"], "type": "str"},
            "lan-ext-vap": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
            "local-vaps": {"v_range": [["7.4.3", ""]], "type": "list", "elements": "str"},
            "max-clients": {"v_range": [["7.4.3", ""]], "type": "int"},
            "mode": {"v_range": [["7.4.3", ""]], "choices": ["AP", "Client"], "type": "str"},
            "operating-standard": {
                "v_range": [["7.4.3", ""]],
                "choices": [
                    "auto", "11A-N-AC-AX", "11A-N-AC", "11A-N", "11A", "11N-AC-AX", "11AC-AX", "11AC", "11N-AC", "11B-G-N-AX", "11B-G-N", "11B-G", "11B",
                    "11G-N-AX", "11N-AX", "11AX", "11G-N", "11N", "11G"
                ],
                "type": "str"
            },
            "power-level": {"v_range": [["7.4.3", ""]], "type": "int"},
            "radio-id": {"v_range": [["7.4.3", ""]], "type": "int"},
            "status": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "extensioncontroller_extendervap": {
        "stated": true,
        "options": {
            "allowaccess": {
                "v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]],
                "type": "list",
                "choices": ["http", "ssh", "telnet", "snmp", "https", "ping"],
                "elements": "str"
            },
            "auth-server-address": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "str"},
            "auth-server-port": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"},
            "auth-server-secret": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "no_log": true, "type": "str"},
            "broadcast-ssid": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "bss-color-partial": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "dtim": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"},
            "end-ip": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "str"},
            "ip-address": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "list", "elements": "str"},
            "max-clients": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"},
            "mu-mimo": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "required": true, "type": "str"},
            "passphrase": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "no_log": true, "type": "list", "elements": "str"},
            "pmf": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disabled", "optional", "required"], "type": "str"},
            "rts-threshold": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "int"},
            "sae-password": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "no_log": true, "type": "list", "elements": "str"},
            "security": {
                "v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]],
                "choices": [
                    "OPEN", "WPA2-Personal", "WPA-WPA2-Personal", "WPA3-SAE", "WPA3-SAE-Transition", "WPA2-Enterprise", "WPA3-Enterprise-only",
                    "WPA3-Enterprise-transition", "WPA3-Enterprise-192-bit"
                ],
                "type": "str"
            },
            "ssid": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "str"},
            "start-ip": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "type": "str"},
            "target-wake-time": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["local-vap", "lan-ext-vap"], "type": "str"}
        }
    },
    "filefilter_profile": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.4.1", ""]], "type": "str"},
            "extended-log": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "feature-set": {"v_range": [["6.4.1", ""]], "choices": ["proxy", "flow"], "type": "str"},
            "log": {"v_range": [["6.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["6.4.1", ""]], "required": true, "type": "str"},
            "replacemsg-group": {"v_range": [["6.4.1", ""]], "type": "str"},
            "rules": {
                "v_range": [["6.4.1", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.4.1", ""]], "choices": ["log-only", "block"], "type": "str"},
                    "comment": {"v_range": [["6.4.1", ""]], "type": "str"},
                    "direction": {"v_range": [["6.4.1", ""]], "choices": ["any", "incoming", "outgoing"], "type": "str"},
                    "file-type": {"v_range": [["6.4.1", ""]], "type": "raw"},
                    "name": {"v_range": [["6.4.1", ""]], "type": "str"},
                    "password-protected": {"v_range": [["6.4.1", ""]], "choices": ["any", "yes"], "type": "str"},
                    "protocol": {
                        "v_range": [["6.4.1", ""]],
                        "type": "list",
                        "choices": ["imap", "smtp", "pop3", "http", "ftp", "mapi", "cifs", "ssh"],
                        "elements": "str"
                    }
                },
                "elements": "dict"
            },
            "scan-archive-contents": {"v_range": [["6.4.1", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "filefilter_profile_rules": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.4.1", ""]], "choices": ["log-only", "block"], "type": "str"},
            "comment": {"v_range": [["6.4.1", ""]], "type": "str"},
            "direction": {"v_range": [["6.4.1", ""]], "choices": ["any", "incoming", "outgoing"], "type": "str"},
            "file-type": {"v_range": [["6.4.1", ""]], "type": "raw"},
            "name": {"v_range": [["6.4.1", ""]], "required": true, "type": "str"},
            "password-protected": {"v_range": [["6.4.1", ""]], "choices": ["any", "yes"], "type": "str"},
            "protocol": {
                "v_range": [["6.4.1", ""]],
                "type": "list",
                "choices": ["imap", "smtp", "pop3", "http", "ftp", "mapi", "cifs", "ssh"],
                "elements": "str"
            }
        }
    },
    "firewall_accessproxy": {
        "stated": true,
        "options": {
            "api-gateway": {
                "v_range": [["7.0.0", ""]],
                "type": "list",
                "options": {
                    "http-cookie-age": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "http-cookie-domain": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "http-cookie-domain-from-host": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-cookie-generation": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "http-cookie-path": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "http-cookie-share": {"v_range": [["7.0.0", ""]], "choices": ["disable", "same-ip"], "type": "str"},
                    "https-cookie-secure": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "id": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "ldb-method": {
                        "v_range": [["7.0.0", ""]],
                        "choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"],
                        "type": "str"
                    },
                    "persistence": {"v_range": [["7.0.0", ""]], "choices": ["none", "http-cookie"], "type": "str"},
                    "realservers": {
                        "v_range": [["7.0.0", ""]],
                        "type": "list",
                        "options": {
                            "address": {"v_range": [["7.0.0", ""]], "type": "str"},
                            "health-check": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "health-check-proto": {"v_range": [["7.0.0", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                            "http-host": {"v_range": [["7.0.0", ""]], "type": "str"},
                            "id": {"v_range": [["7.0.0", ""]], "type": "int"},
                            "ip": {"v_range": [["7.0.0", ""]], "type": "str"},
                            "mappedport": {"v_range": [["7.0.0", ""]], "type": "raw"},
                            "port": {"v_range": [["7.0.0", ""]], "type": "int"},
                            "status": {"v_range": [["7.0.0", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                            "weight": {"v_range": [["7.0.0", ""]], "type": "int"},
                            "addr-type": {"v_range": [["7.0.2", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                            "domain": {"v_range": [["7.0.3", ""]], "type": "str"},
                            "holddown-interval": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "ssh-client-cert": {"v_range": [["7.0.1", ""]], "type": "str"},
                            "ssh-host-key": {"v_range": [["7.0.1", ""]], "no_log": true, "type": "raw"},
                            "ssh-host-key-validation": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "type": {"v_range": [["7.0.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "saml-server": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "service": {"v_range": [["7.0.0", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
                    "ssl-algorithm": {"v_range": [["7.0.0", ""]], "choices": ["high", "medium", "low", "custom"], "type": "str"},
                    "ssl-cipher-suites": {
                        "v_range": [["7.0.0", ""]],
                        "type": "list",
                        "options": {
                            "cipher": {
                                "v_range": [["7.0.0", ""]],
                                "choices": [
                                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                                    "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA", "TLS-AES-128-GCM-SHA256",
                                    "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                                ],
                                "type": "str"
                            },
                            "priority": {"v_range": [["7.0.0", ""]], "type": "int"},
                            "versions": {
                                "v_range": [["7.0.0", ""]],
                                "type": "list",
                                "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                                "elements": "str"
                            }
                        },
                        "elements": "dict"
                    },
                    "ssl-dh-bits": {"v_range": [["7.0.0", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
                    "ssl-max-version": {"v_range": [["7.0.0", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-min-version": {"v_range": [["7.0.0", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "url-map": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "url-map-type": {"v_range": [["7.0.0", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
                    "virtual-host": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "saml-redirect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-vpn-web-portal": {"v_range": [["7.0.3", ""]], "type": "str"},
                    "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "quic": {
                        "v_range": [["7.4.1", ""]],
                        "type": "dict",
                        "options": {
                            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                        }
                    }
                },
                "elements": "dict"
            },
            "client-cert": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "empty-cert-action": {"v_range": [["7.0.0", ""]], "choices": ["block", "accept", "accept-unmanageable"], "type": "str"},
            "ldb-method": {
                "v_range": [["7.0.0", ""]],
                "choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive"],
                "type": "str"
            },
            "name": {"v_range": [["7.0.0", ""]], "required": true, "type": "str"},
            "realservers": {
                "v_range": [["7.0.0", ""]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "ip": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "port": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "status": {"v_range": [["7.0.0", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"v_range": [["7.0.0", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "server-pubkey-auth": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "server-pubkey-auth-settings": {
                "v_range": [["7.0.0", ""]],
                "type": "dict",
                "options": {
                    "auth-ca": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "cert-extension": {
                        "v_range": [["7.0.0", ""]],
                        "type": "list",
                        "options": {
                            "critical": {"v_range": [["7.0.0", ""]], "choices": ["no", "yes"], "type": "str"},
                            "data": {"v_range": [["7.0.0", ""]], "type": "str"},
                            "name": {"v_range": [["7.0.0", ""]], "type": "str"},
                            "type": {"v_range": [["7.0.0", ""]], "choices": ["fixed", "user"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "permit-agent-forwarding": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "permit-port-forwarding": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "permit-pty": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "permit-user-rc": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "permit-x11-forwarding": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "source-address": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "vip": {"v_range": [["7.0.0", ""]], "type": "str"},
            "api-gateway6": {
                "v_range": [["7.0.1", ""]],
                "type": "list",
                "options": {
                    "http-cookie-age": {"v_range": [["7.0.1", ""]], "type": "int"},
                    "http-cookie-domain": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "http-cookie-domain-from-host": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-cookie-generation": {"v_range": [["7.0.1", ""]], "type": "int"},
                    "http-cookie-path": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "http-cookie-share": {"v_range": [["7.0.1", ""]], "choices": ["disable", "same-ip"], "type": "str"},
                    "https-cookie-secure": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "id": {"v_range": [["7.0.1", ""]], "type": "int"},
                    "ldb-method": {
                        "v_range": [["7.0.1", ""]],
                        "choices": ["static", "round-robin", "weighted", "first-alive", "http-host"],
                        "type": "str"
                    },
                    "persistence": {"v_range": [["7.0.1", ""]], "choices": ["none", "http-cookie"], "type": "str"},
                    "realservers": {
                        "v_range": [["7.0.1", ""]],
                        "type": "list",
                        "options": {
                            "addr-type": {"v_range": [["7.0.2", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                            "address": {"v_range": [["7.0.1", ""]], "type": "str"},
                            "domain": {"v_range": [["7.0.3", ""]], "type": "str"},
                            "health-check": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "health-check-proto": {"v_range": [["7.0.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                            "holddown-interval": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "http-host": {"v_range": [["7.0.1", ""]], "type": "str"},
                            "id": {"v_range": [["7.0.1", ""]], "type": "int"},
                            "ip": {"v_range": [["7.0.1", ""]], "type": "str"},
                            "mappedport": {"v_range": [["7.0.1", ""]], "type": "raw"},
                            "port": {"v_range": [["7.0.1", ""]], "type": "int"},
                            "ssh-client-cert": {"v_range": [["7.0.1", ""]], "type": "str"},
                            "ssh-host-key": {"v_range": [["7.0.1", ""]], "no_log": true, "type": "raw"},
                            "ssh-host-key-validation": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "status": {"v_range": [["7.0.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                            "type": {"v_range": [["7.0.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                            "weight": {"v_range": [["7.0.1", ""]], "type": "int"},
                            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "saml-redirect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "saml-server": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "service": {"v_range": [["7.0.1", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
                    "ssl-algorithm": {"v_range": [["7.0.1", ""]], "choices": ["high", "medium", "low"], "type": "str"},
                    "ssl-cipher-suites": {
                        "v_range": [["7.0.1", ""]],
                        "type": "list",
                        "options": {
                            "cipher": {
                                "v_range": [["7.0.1", ""]],
                                "choices": [
                                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                                    "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA", "TLS-AES-128-GCM-SHA256",
                                    "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                                ],
                                "type": "str"
                            },
                            "priority": {"v_range": [["7.0.1", ""]], "type": "int"},
                            "versions": {
                                "v_range": [["7.0.1", ""]],
                                "type": "list",
                                "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                                "elements": "str"
                            }
                        },
                        "elements": "dict"
                    },
                    "ssl-dh-bits": {"v_range": [["7.0.1", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
                    "ssl-max-version": {"v_range": [["7.0.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-min-version": {"v_range": [["7.0.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-vpn-web-portal": {"v_range": [["7.0.3", ""]], "type": "str"},
                    "url-map": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "url-map-type": {"v_range": [["7.0.1", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
                    "virtual-host": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "quic": {
                        "v_range": [["7.4.1", ""]],
                        "type": "dict",
                        "options": {
                            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                        }
                    }
                },
                "elements": "dict"
            },
            "auth-portal": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "auth-virtual-host": {"v_range": [["7.0.3", ""]], "type": "str"},
            "decrypted-traffic-mirror": {"v_range": [["7.0.2", ""]], "type": "str"},
            "log-blocked-traffic": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "add-vhost-domain-to-dnsdb": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "user-agent-detect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-supported-max-version": {"v_range": [["7.2.2", ""]], "choices": ["http1", "http2"], "type": "str"},
            "svr-pool-multiplex": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "svr-pool-server-max-request": {"v_range": [["7.2.2", ""]], "type": "int"},
            "svr-pool-ttl": {"v_range": [["7.2.2", ""]], "type": "int"},
            "svr-pool-server-max-concurrent-request": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_accessproxy6": {
        "stated": true,
        "options": {
            "add-vhost-domain-to-dnsdb": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "api-gateway": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "http-cookie-age": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "http-cookie-domain": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "http-cookie-domain-from-host": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-cookie-generation": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "http-cookie-path": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "http-cookie-share": {"v_range": [["7.2.1", ""]], "choices": ["disable", "same-ip"], "type": "str"},
                    "https-cookie-secure": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "id": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "ldb-method": {
                        "v_range": [["7.2.1", ""]],
                        "choices": ["static", "round-robin", "weighted", "first-alive", "http-host"],
                        "type": "str"
                    },
                    "persistence": {"v_range": [["7.2.1", ""]], "choices": ["none", "http-cookie"], "type": "str"},
                    "realservers": {
                        "v_range": [["7.2.1", ""]],
                        "type": "list",
                        "options": {
                            "addr-type": {"v_range": [["7.2.1", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                            "address": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "domain": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "health-check": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "health-check-proto": {"v_range": [["7.2.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                            "holddown-interval": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "http-host": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "id": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "ip": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "mappedport": {"v_range": [["7.2.1", ""]], "type": "raw"},
                            "port": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "ssh-client-cert": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "ssh-host-key": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
                            "ssh-host-key-validation": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "status": {"v_range": [["7.2.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                            "type": {"v_range": [["7.2.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                            "weight": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "saml-redirect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "saml-server": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "service": {"v_range": [["7.2.1", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
                    "ssl-algorithm": {"v_range": [["7.2.1", ""]], "choices": ["high", "medium", "low"], "type": "str"},
                    "ssl-cipher-suites": {
                        "v_range": [["7.2.1", ""]],
                        "type": "list",
                        "options": {
                            "cipher": {
                                "v_range": [["7.2.1", ""]],
                                "choices": [
                                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                                    "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA", "TLS-AES-128-GCM-SHA256",
                                    "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                                ],
                                "type": "str"
                            },
                            "priority": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "versions": {
                                "v_range": [["7.2.1", ""]],
                                "type": "list",
                                "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                                "elements": "str"
                            }
                        },
                        "elements": "dict"
                    },
                    "ssl-dh-bits": {"v_range": [["7.2.1", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
                    "ssl-max-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-min-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-vpn-web-portal": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "url-map": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "url-map-type": {"v_range": [["7.2.1", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
                    "virtual-host": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "quic": {
                        "v_range": [["7.4.1", ""]],
                        "type": "dict",
                        "options": {
                            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                        }
                    }
                },
                "elements": "dict"
            },
            "api-gateway6": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "http-cookie-age": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "http-cookie-domain": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "http-cookie-domain-from-host": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-cookie-generation": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "http-cookie-path": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "http-cookie-share": {"v_range": [["7.2.1", ""]], "choices": ["disable", "same-ip"], "type": "str"},
                    "https-cookie-secure": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "id": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "ldb-method": {
                        "v_range": [["7.2.1", ""]],
                        "choices": ["static", "round-robin", "weighted", "first-alive", "http-host"],
                        "type": "str"
                    },
                    "persistence": {"v_range": [["7.2.1", ""]], "choices": ["none", "http-cookie"], "type": "str"},
                    "realservers": {
                        "v_range": [["7.2.1", ""]],
                        "type": "list",
                        "options": {
                            "addr-type": {"v_range": [["7.2.1", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                            "address": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "domain": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "health-check": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "health-check-proto": {"v_range": [["7.2.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                            "holddown-interval": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "http-host": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "id": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "ip": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "mappedport": {"v_range": [["7.2.1", ""]], "type": "raw"},
                            "port": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "ssh-client-cert": {"v_range": [["7.2.1", ""]], "type": "str"},
                            "ssh-host-key": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
                            "ssh-host-key-validation": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "status": {"v_range": [["7.2.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                            "type": {"v_range": [["7.2.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                            "weight": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "saml-redirect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "saml-server": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "service": {"v_range": [["7.2.1", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
                    "ssl-algorithm": {"v_range": [["7.2.1", ""]], "choices": ["high", "medium", "low"], "type": "str"},
                    "ssl-cipher-suites": {
                        "v_range": [["7.2.1", ""]],
                        "type": "list",
                        "options": {
                            "cipher": {
                                "v_range": [["7.2.1", ""]],
                                "choices": [
                                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                                    "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA", "TLS-AES-128-GCM-SHA256",
                                    "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                                ],
                                "type": "str"
                            },
                            "priority": {"v_range": [["7.2.1", ""]], "type": "int"},
                            "versions": {
                                "v_range": [["7.2.1", ""]],
                                "type": "list",
                                "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                                "elements": "str"
                            }
                        },
                        "elements": "dict"
                    },
                    "ssl-dh-bits": {"v_range": [["7.2.1", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
                    "ssl-max-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-min-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-vpn-web-portal": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "url-map": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "url-map-type": {"v_range": [["7.2.1", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
                    "virtual-host": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "quic": {
                        "v_range": [["7.4.1", ""]],
                        "type": "dict",
                        "options": {
                            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                        }
                    }
                },
                "elements": "dict"
            },
            "auth-portal": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "auth-virtual-host": {"v_range": [["7.2.1", ""]], "type": "str"},
            "client-cert": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "decrypted-traffic-mirror": {"v_range": [["7.2.1", ""]], "type": "str"},
            "empty-cert-action": {"v_range": [["7.2.1", ""]], "choices": ["block", "accept", "accept-unmanageable"], "type": "str"},
            "log-blocked-traffic": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["7.2.1", ""]], "required": true, "type": "str"},
            "user-agent-detect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "vip": {"v_range": [["7.2.1", ""]], "type": "str"},
            "http-supported-max-version": {"v_range": [["7.2.2", ""]], "choices": ["http1", "http2"], "type": "str"},
            "svr-pool-multiplex": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "svr-pool-server-max-request": {"v_range": [["7.2.2", ""]], "type": "int"},
            "svr-pool-ttl": {"v_range": [["7.2.2", ""]], "type": "int"},
            "svr-pool-server-max-concurrent-request": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_accessproxy6_apigateway": {
        "stated": true,
        "options": {
            "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "http-cookie-age": {"v_range": [["7.2.1", ""]], "type": "int"},
            "http-cookie-domain": {"v_range": [["7.2.1", ""]], "type": "str"},
            "http-cookie-domain-from-host": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"v_range": [["7.2.1", ""]], "type": "int"},
            "http-cookie-path": {"v_range": [["7.2.1", ""]], "type": "str"},
            "http-cookie-share": {"v_range": [["7.2.1", ""]], "choices": ["disable", "same-ip"], "type": "str"},
            "https-cookie-secure": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "id": {"v_range": [["7.2.1", ""]], "required": true, "type": "int"},
            "ldb-method": {"v_range": [["7.2.1", ""]], "choices": ["static", "round-robin", "weighted", "first-alive", "http-host"], "type": "str"},
            "persistence": {"v_range": [["7.2.1", ""]], "choices": ["none", "http-cookie"], "type": "str"},
            "realservers": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "addr-type": {"v_range": [["7.2.1", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                    "address": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "domain": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "health-check": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "health-check-proto": {"v_range": [["7.2.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                    "holddown-interval": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-host": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "id": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "ip": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "mappedport": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "port": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "ssh-client-cert": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "ssh-host-key": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
                    "ssh-host-key-validation": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["7.2.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                    "type": {"v_range": [["7.2.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                    "weight": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "saml-redirect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "saml-server": {"v_range": [["7.2.1", ""]], "type": "str"},
            "service": {"v_range": [["7.2.1", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
            "ssl-algorithm": {"v_range": [["7.2.1", ""]], "choices": ["high", "medium", "low"], "type": "str"},
            "ssl-cipher-suites": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "cipher": {
                        "v_range": [["7.2.1", ""]],
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "versions": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "ssl-dh-bits": {"v_range": [["7.2.1", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-max-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-vpn-web-portal": {"v_range": [["7.2.1", ""]], "type": "str"},
            "url-map": {"v_range": [["7.2.1", ""]], "type": "str"},
            "url-map-type": {"v_range": [["7.2.1", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
            "virtual-host": {"v_range": [["7.2.1", ""]], "type": "str"},
            "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "quic": {
                "v_range": [["7.4.1", ""]],
                "type": "dict",
                "options": {
                    "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                }
            }
        }
    },
    "firewall_accessproxy6_apigateway6": {
        "stated": true,
        "options": {
            "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "http-cookie-age": {"v_range": [["7.2.1", ""]], "type": "int"},
            "http-cookie-domain": {"v_range": [["7.2.1", ""]], "type": "str"},
            "http-cookie-domain-from-host": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"v_range": [["7.2.1", ""]], "type": "int"},
            "http-cookie-path": {"v_range": [["7.2.1", ""]], "type": "str"},
            "http-cookie-share": {"v_range": [["7.2.1", ""]], "choices": ["disable", "same-ip"], "type": "str"},
            "https-cookie-secure": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "id": {"v_range": [["7.2.1", ""]], "required": true, "type": "int"},
            "ldb-method": {"v_range": [["7.2.1", ""]], "choices": ["static", "round-robin", "weighted", "first-alive", "http-host"], "type": "str"},
            "persistence": {"v_range": [["7.2.1", ""]], "choices": ["none", "http-cookie"], "type": "str"},
            "realservers": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "addr-type": {"v_range": [["7.2.1", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                    "address": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "domain": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "health-check": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "health-check-proto": {"v_range": [["7.2.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                    "holddown-interval": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-host": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "id": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "ip": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "mappedport": {"v_range": [["7.2.1", ""]], "type": "raw"},
                    "port": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "ssh-client-cert": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "ssh-host-key": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
                    "ssh-host-key-validation": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["7.2.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                    "type": {"v_range": [["7.2.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                    "weight": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "saml-redirect": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "saml-server": {"v_range": [["7.2.1", ""]], "type": "str"},
            "service": {"v_range": [["7.2.1", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
            "ssl-algorithm": {"v_range": [["7.2.1", ""]], "choices": ["high", "medium", "low"], "type": "str"},
            "ssl-cipher-suites": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "cipher": {
                        "v_range": [["7.2.1", ""]],
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "versions": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "ssl-dh-bits": {"v_range": [["7.2.1", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-max-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"v_range": [["7.2.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-vpn-web-portal": {"v_range": [["7.2.1", ""]], "type": "str"},
            "url-map": {"v_range": [["7.2.1", ""]], "type": "str"},
            "url-map-type": {"v_range": [["7.2.1", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
            "virtual-host": {"v_range": [["7.2.1", ""]], "type": "str"},
            "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "quic": {
                "v_range": [["7.4.1", ""]],
                "type": "dict",
                "options": {
                    "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                }
            }
        }
    },
    "firewall_accessproxy6_apigateway6_quic": {
        "stated": false,
        "options": {
            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_accessproxy6_apigateway6_realservers": {
        "stated": true,
        "options": {
            "addr-type": {"v_range": [["7.2.1", ""]], "choices": ["fqdn", "ip"], "type": "str"},
            "address": {"v_range": [["7.2.1", ""]], "type": "str"},
            "domain": {"v_range": [["7.2.1", ""]], "type": "str"},
            "health-check": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "health-check-proto": {"v_range": [["7.2.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
            "holddown-interval": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-host": {"v_range": [["7.2.1", ""]], "type": "str"},
            "id": {"v_range": [["7.2.1", ""]], "required": true, "type": "int"},
            "ip": {"v_range": [["7.2.1", ""]], "type": "str"},
            "mappedport": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "port": {"v_range": [["7.2.1", ""]], "type": "int"},
            "ssh-client-cert": {"v_range": [["7.2.1", ""]], "type": "str"},
            "ssh-host-key": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
            "ssh-host-key-validation": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["7.2.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
            "type": {"v_range": [["7.2.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
            "weight": {"v_range": [["7.2.1", ""]], "type": "int"},
            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_accessproxy6_apigateway6_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "v_range": [["7.2.1", ""]],
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"v_range": [["7.2.1", ""]], "type": "int"},
            "versions": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
        }
    },
    "firewall_accessproxy6_apigateway_quic": {
        "stated": false,
        "options": {
            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_accessproxy6_apigateway_realservers": {
        "stated": true,
        "options": {
            "addr-type": {"v_range": [["7.2.1", ""]], "choices": ["fqdn", "ip"], "type": "str"},
            "address": {"v_range": [["7.2.1", ""]], "type": "str"},
            "domain": {"v_range": [["7.2.1", ""]], "type": "str"},
            "health-check": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "health-check-proto": {"v_range": [["7.2.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
            "holddown-interval": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-host": {"v_range": [["7.2.1", ""]], "type": "str"},
            "id": {"v_range": [["7.2.1", ""]], "required": true, "type": "int"},
            "ip": {"v_range": [["7.2.1", ""]], "type": "str"},
            "mappedport": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "port": {"v_range": [["7.2.1", ""]], "type": "int"},
            "ssh-client-cert": {"v_range": [["7.2.1", ""]], "type": "str"},
            "ssh-host-key": {"v_range": [["7.2.1", ""]], "no_log": true, "type": "raw"},
            "ssh-host-key-validation": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["7.2.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
            "type": {"v_range": [["7.2.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
            "weight": {"v_range": [["7.2.1", ""]], "type": "int"},
            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_accessproxy6_apigateway_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "v_range": [["7.2.1", ""]],
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"v_range": [["7.2.1", ""]], "type": "int"},
            "versions": {"v_range": [["7.2.1", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
        }
    },
    "firewall_accessproxy_apigateway": {
        "stated": true,
        "options": {
            "http-cookie-age": {"v_range": [["7.0.0", ""]], "type": "int"},
            "http-cookie-domain": {"v_range": [["7.0.0", ""]], "type": "str"},
            "http-cookie-domain-from-host": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"v_range": [["7.0.0", ""]], "type": "int"},
            "http-cookie-path": {"v_range": [["7.0.0", ""]], "type": "str"},
            "http-cookie-share": {"v_range": [["7.0.0", ""]], "choices": ["disable", "same-ip"], "type": "str"},
            "https-cookie-secure": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "id": {"v_range": [["7.0.0", ""]], "required": true, "type": "int"},
            "ldb-method": {
                "v_range": [["7.0.0", ""]],
                "choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"],
                "type": "str"
            },
            "persistence": {"v_range": [["7.0.0", ""]], "choices": ["none", "http-cookie"], "type": "str"},
            "realservers": {
                "v_range": [["7.0.0", ""]],
                "type": "list",
                "options": {
                    "address": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "health-check": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "health-check-proto": {"v_range": [["7.0.0", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                    "http-host": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "id": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "ip": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "mappedport": {"v_range": [["7.0.0", ""]], "type": "raw"},
                    "port": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "status": {"v_range": [["7.0.0", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "addr-type": {"v_range": [["7.0.2", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                    "domain": {"v_range": [["7.0.3", ""]], "type": "str"},
                    "holddown-interval": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssh-client-cert": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "ssh-host-key": {"v_range": [["7.0.1", ""]], "no_log": true, "type": "raw"},
                    "ssh-host-key-validation": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "type": {"v_range": [["7.0.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "saml-server": {"v_range": [["7.0.0", ""]], "type": "str"},
            "service": {"v_range": [["7.0.0", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
            "ssl-algorithm": {"v_range": [["7.0.0", ""]], "choices": ["high", "medium", "low", "custom"], "type": "str"},
            "ssl-cipher-suites": {
                "v_range": [["7.0.0", ""]],
                "type": "list",
                "options": {
                    "cipher": {
                        "v_range": [["7.0.0", ""]],
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "versions": {"v_range": [["7.0.0", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "ssl-dh-bits": {"v_range": [["7.0.0", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-max-version": {"v_range": [["7.0.0", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"v_range": [["7.0.0", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "url-map": {"v_range": [["7.0.0", ""]], "type": "str"},
            "url-map-type": {"v_range": [["7.0.0", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
            "virtual-host": {"v_range": [["7.0.0", ""]], "type": "str"},
            "saml-redirect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-vpn-web-portal": {"v_range": [["7.0.3", ""]], "type": "str"},
            "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "quic": {
                "v_range": [["7.4.1", ""]],
                "type": "dict",
                "options": {
                    "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                }
            }
        }
    },
    "firewall_accessproxy_apigateway6": {
        "stated": true,
        "options": {
            "http-cookie-age": {"v_range": [["7.0.1", ""]], "type": "int"},
            "http-cookie-domain": {"v_range": [["7.0.1", ""]], "type": "str"},
            "http-cookie-domain-from-host": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"v_range": [["7.0.1", ""]], "type": "int"},
            "http-cookie-path": {"v_range": [["7.0.1", ""]], "type": "str"},
            "http-cookie-share": {"v_range": [["7.0.1", ""]], "choices": ["disable", "same-ip"], "type": "str"},
            "https-cookie-secure": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "id": {"v_range": [["7.0.1", ""]], "required": true, "type": "int"},
            "ldb-method": {"v_range": [["7.0.1", ""]], "choices": ["static", "round-robin", "weighted", "first-alive", "http-host"], "type": "str"},
            "persistence": {"v_range": [["7.0.1", ""]], "choices": ["none", "http-cookie"], "type": "str"},
            "realservers": {
                "v_range": [["7.0.1", ""]],
                "type": "list",
                "options": {
                    "addr-type": {"v_range": [["7.0.2", ""]], "choices": ["fqdn", "ip"], "type": "str"},
                    "address": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "domain": {"v_range": [["7.0.3", ""]], "type": "str"},
                    "health-check": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "health-check-proto": {"v_range": [["7.0.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
                    "holddown-interval": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-host": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "id": {"v_range": [["7.0.1", ""]], "type": "int"},
                    "ip": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "mappedport": {"v_range": [["7.0.1", ""]], "type": "raw"},
                    "port": {"v_range": [["7.0.1", ""]], "type": "int"},
                    "ssh-client-cert": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "ssh-host-key": {"v_range": [["7.0.1", ""]], "no_log": true, "type": "raw"},
                    "ssh-host-key-validation": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["7.0.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                    "type": {"v_range": [["7.0.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
                    "weight": {"v_range": [["7.0.1", ""]], "type": "int"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "saml-redirect": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "saml-server": {"v_range": [["7.0.1", ""]], "type": "str"},
            "service": {"v_range": [["7.0.1", ""]], "choices": ["http", "https", "tcp-forwarding", "samlsp", "web-portal", "saas"], "type": "str"},
            "ssl-algorithm": {"v_range": [["7.0.1", ""]], "choices": ["high", "medium", "low"], "type": "str"},
            "ssl-cipher-suites": {
                "v_range": [["7.0.1", ""]],
                "type": "list",
                "options": {
                    "cipher": {
                        "v_range": [["7.0.1", ""]],
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"v_range": [["7.0.1", ""]], "type": "int"},
                    "versions": {"v_range": [["7.0.1", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "ssl-dh-bits": {"v_range": [["7.0.1", ""]], "choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-max-version": {"v_range": [["7.0.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"v_range": [["7.0.1", ""]], "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-vpn-web-portal": {"v_range": [["7.0.3", ""]], "type": "str"},
            "url-map": {"v_range": [["7.0.1", ""]], "type": "str"},
            "url-map-type": {"v_range": [["7.0.1", ""]], "choices": ["sub-string", "wildcard", "regex"], "type": "str"},
            "virtual-host": {"v_range": [["7.0.1", ""]], "type": "str"},
            "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "ssl-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "quic": {
                "v_range": [["7.4.1", ""]],
                "type": "dict",
                "options": {
                    "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                }
            }
        }
    },
    "firewall_accessproxy_apigateway6_quic": {
        "stated": false,
        "options": {
            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_accessproxy_apigateway6_realservers": {
        "stated": true,
        "options": {
            "addr-type": {"v_range": [["7.0.2", ""]], "choices": ["fqdn", "ip"], "type": "str"},
            "address": {"v_range": [["7.0.1", ""]], "type": "str"},
            "domain": {"v_range": [["7.0.3", ""]], "type": "str"},
            "health-check": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "health-check-proto": {"v_range": [["7.0.1", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
            "holddown-interval": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-host": {"v_range": [["7.0.1", ""]], "type": "str"},
            "id": {"v_range": [["7.0.1", ""]], "required": true, "type": "int"},
            "ip": {"v_range": [["7.0.1", ""]], "type": "str"},
            "mappedport": {"v_range": [["7.0.1", ""]], "type": "raw"},
            "port": {"v_range": [["7.0.1", ""]], "type": "int"},
            "ssh-client-cert": {"v_range": [["7.0.1", ""]], "type": "str"},
            "ssh-host-key": {"v_range": [["7.0.1", ""]], "no_log": true, "type": "raw"},
            "ssh-host-key-validation": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["7.0.1", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
            "type": {"v_range": [["7.0.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
            "weight": {"v_range": [["7.0.1", ""]], "type": "int"},
            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_accessproxy_apigateway6_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "v_range": [["7.0.1", ""]],
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"v_range": [["7.0.1", ""]], "type": "int"},
            "versions": {"v_range": [["7.0.1", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
        }
    },
    "firewall_accessproxy_apigateway_quic": {
        "stated": false,
        "options": {
            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_accessproxy_apigateway_realservers": {
        "stated": true,
        "options": {
            "address": {"v_range": [["7.0.0", ""]], "type": "str"},
            "health-check": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "health-check-proto": {"v_range": [["7.0.0", ""]], "choices": ["ping", "http", "tcp-connect"], "type": "str"},
            "http-host": {"v_range": [["7.0.0", ""]], "type": "str"},
            "id": {"v_range": [["7.0.0", ""]], "required": true, "type": "int"},
            "ip": {"v_range": [["7.0.0", ""]], "type": "str"},
            "mappedport": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "port": {"v_range": [["7.0.0", ""]], "type": "int"},
            "status": {"v_range": [["7.0.0", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"v_range": [["7.0.0", ""]], "type": "int"},
            "addr-type": {"v_range": [["7.0.2", ""]], "choices": ["fqdn", "ip"], "type": "str"},
            "domain": {"v_range": [["7.0.3", ""]], "type": "str"},
            "holddown-interval": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-client-cert": {"v_range": [["7.0.1", ""]], "type": "str"},
            "ssh-host-key": {"v_range": [["7.0.1", ""]], "no_log": true, "type": "raw"},
            "ssh-host-key-validation": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "type": {"v_range": [["7.0.1", ""]], "choices": ["tcp-forwarding", "ssh"], "type": "str"},
            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-auth": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tunnel-encryption": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_accessproxy_apigateway_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "v_range": [["7.0.0", ""]],
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"v_range": [["7.0.0", ""]], "type": "int"},
            "versions": {"v_range": [["7.0.0", ""]], "type": "list", "choices": ["tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
        }
    },
    "firewall_accessproxy_realservers": {
        "stated": true,
        "options": {
            "id": {"v_range": [["7.0.0", ""]], "required": true, "type": "int"},
            "ip": {"v_range": [["7.0.0", ""]], "type": "str"},
            "port": {"v_range": [["7.0.0", ""]], "type": "int"},
            "status": {"v_range": [["7.0.0", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"v_range": [["7.0.0", ""]], "type": "int"}
        }
    },
    "firewall_accessproxy_serverpubkeyauthsettings": {
        "stated": false,
        "options": {
            "auth-ca": {"v_range": [["7.0.0", ""]], "type": "str"},
            "cert-extension": {
                "v_range": [["7.0.0", ""]],
                "type": "list",
                "options": {
                    "critical": {"v_range": [["7.0.0", ""]], "choices": ["no", "yes"], "type": "str"},
                    "data": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "name": {"v_range": [["7.0.0", ""]], "type": "str"},
                    "type": {"v_range": [["7.0.0", ""]], "choices": ["fixed", "user"], "type": "str"}
                },
                "elements": "dict"
            },
            "permit-agent-forwarding": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-port-forwarding": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-pty": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-user-rc": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-x11-forwarding": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "source-address": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_accessproxy_serverpubkeyauthsettings_certextension": {
        "stated": true,
        "options": {
            "critical": {"v_range": [["7.0.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "data": {"v_range": [["7.0.0", ""]], "type": "str"},
            "name": {"v_range": [["7.0.0", ""]], "required": true, "type": "str"},
            "type": {"v_range": [["7.0.0", ""]], "choices": ["fixed", "user"], "type": "str"}
        }
    },
    "firewall_accessproxysshclientcert": {
        "stated": true,
        "options": {
            "auth-ca": {"v_range": [["7.4.2", ""]], "type": "str"},
            "cert-extension": {
                "v_range": [["7.4.2", ""]],
                "type": "list",
                "options": {
                    "critical": {"v_range": [["7.4.2", ""]], "choices": ["no", "yes"], "type": "str"},
                    "data": {"v_range": [["7.4.2", ""]], "type": "str"},
                    "name": {"v_range": [["7.4.2", ""]], "type": "str"},
                    "type": {"v_range": [["7.4.2", ""]], "choices": ["fixed", "user"], "type": "str"}
                },
                "elements": "dict"
            },
            "name": {"v_range": [["7.4.2", ""]], "required": true, "type": "str"},
            "permit-agent-forwarding": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-port-forwarding": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-pty": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-user-rc": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "permit-x11-forwarding": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "source-address": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_accessproxysshclientcert_certextension": {
        "stated": true,
        "options": {
            "critical": {"v_range": [["7.4.2", ""]], "choices": ["no", "yes"], "type": "str"},
            "data": {"v_range": [["7.4.2", ""]], "type": "str"},
            "name": {"v_range": [["7.4.2", ""]], "required": true, "type": "str"},
            "type": {"v_range": [["7.4.2", ""]], "choices": ["fixed", "user"], "type": "str"}
        }
    },
    "firewall_accessproxyvirtualhost": {
        "stated": true,
        "options": {
            "host": {"v_range": [["7.0.1", ""]], "type": "str"},
            "host-type": {"v_range": [["7.0.1", ""]], "choices": ["sub-string", "wildcard"], "type": "str"},
            "name": {"v_range": [["7.0.1", ""]], "required": true, "type": "str"},
            "ssl-certificate": {"v_range": [["7.0.1", ""]], "type": "str"},
            "replacemsg-group": {"v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]], "type": "str"},
            "client-cert": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "empty-cert-action": {"v_range": [["7.6.2", ""]], "choices": ["block", "accept", "accept-unmanageable"], "type": "str"},
            "user-agent-detect": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_address": {
        "stated": true,
        "options": {
            "allow-routing": {"choices": ["disable", "enable"], "type": "str"},
            "associated-interface": {"type": "str"},
            "cache-ttl": {"type": "int"},
            "color": {"type": "int"},
            "comment": {"type": "raw"},
            "country": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "allow-routing": {"choices": ["disable", "enable"], "type": "str"},
                    "associated-interface": {"type": "str"},
                    "cache-ttl": {"type": "int"},
                    "color": {"type": "int"},
                    "comment": {"type": "raw"},
                    "country": {"type": "str"},
                    "end-ip": {"type": "str"},
                    "end-mac": {"type": "str"},
                    "epg-name": {"type": "str"},
                    "filter": {"type": "str"},
                    "fqdn": {"type": "str"},
                    "interface": {"type": "str"},
                    "obj-id": {"type": "str"},
                    "organization": {"type": "str"},
                    "policy-group": {"type": "str"},
                    "sdn": {"choices": ["aci", "aws", "nsx", "nuage", "azure", "gcp", "oci", "openstack"], "type": "str"},
                    "sdn-addr-type": {"choices": ["private", "public", "all"], "type": "str"},
                    "sdn-tag": {"type": "str"},
                    "start-ip": {"type": "str"},
                    "start-mac": {"type": "str"},
                    "subnet": {"type": "str"},
                    "subnet-name": {"type": "str"},
                    "tags": {"type": "raw"},
                    "tenant": {"type": "str"},
                    "type": {
                        "choices": [
                            "ipmask", "iprange", "fqdn", "wildcard", "geography", "url", "wildcard-fqdn", "nsx", "aws", "dynamic", "interface-subnet",
                            "mac", "fqdn-group", "route-tag"
                        ],
                        "type": "str"
                    },
                    "url": {"type": "str"},
                    "uuid": {"type": "str"},
                    "visibility": {"choices": ["disable", "enable"], "type": "str"},
                    "wildcard": {"type": "str"},
                    "wildcard-fqdn": {"type": "str"},
                    "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
                    "clearpass-spt": {
                        "v_range": [["6.2.2", ""]],
                        "choices": ["unknown", "healthy", "quarantine", "checkup", "transition", "infected", "transient"],
                        "type": "str"
                    },
                    "fsso-group": {"v_range": [["6.2.2", ""]], "type": "raw"},
                    "sub-type": {
                        "v_range": [["6.2.2", ""]],
                        "choices": [
                            "sdn", "clearpass-spt", "fsso", "ems-tag", "swc-tag", "fortivoice-tag", "fortinac-tag", "fortipolicy-tag",
                            "device-identification", "rsso", "external-resource", "obsolete"
                        ],
                        "type": "str"
                    },
                    "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
                    "obj-tag": {"v_range": [["6.4.2", ""]], "type": "str"},
                    "obj-type": {"v_range": [["6.4.2", ""]], "choices": ["ip", "mac"], "type": "str"},
                    "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "macaddr": {"v_range": [["7.0.0", ""]], "type": "raw"},
                    "node-ip-only": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "dirty": {"v_range": [["7.0.3", ""]], "choices": ["dirty", "clean"], "type": "str"},
                    "pattern-end": {"v_range": [["7.0.3", ""]], "type": "int"},
                    "pattern-start": {"v_range": [["7.0.3", ""]], "type": "int"},
                    "tag-detection-level": {"v_range": [["7.0.3", ""]], "type": "str"},
                    "tag-type": {"v_range": [["7.0.3", ""]], "type": "str"},
                    "hw-model": {"v_range": [["7.4.0", ""]], "type": "str"},
                    "hw-vendor": {"v_range": [["7.4.0", ""]], "type": "str"},
                    "os": {"v_range": [["7.4.0", ""]], "type": "str"},
                    "route-tag": {"v_range": [["7.4.0", ""]], "type": "int"},
                    "sw-version": {"v_range": [["7.4.0", ""]], "type": "str"},
                    "sso-attribute-value": {"v_range": [["7.6.2", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "end-ip": {"type": "str"},
            "epg-name": {"type": "str"},
            "filter": {"type": "str"},
            "fqdn": {"type": "str"},
            "list": {
                "type": "list",
                "options": {
                    "ip": {"type": "str"},
                    "net-id": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "obj-id": {"v_range": [["6.2.0", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "name": {"required": true, "type": "str"},
            "obj-id": {"type": "str"},
            "organization": {"type": "str"},
            "policy-group": {"type": "str"},
            "sdn": {"choices": ["aci", "aws", "nsx", "nuage", "azure", "gcp", "oci", "openstack"], "type": "str"},
            "sdn-tag": {"type": "str"},
            "start-ip": {"type": "str"},
            "subnet": {"type": "str"},
            "subnet-name": {"type": "str"},
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "tenant": {"type": "str"},
            "type": {
                "choices": [
                    "ipmask", "iprange", "fqdn", "wildcard", "geography", "url", "wildcard-fqdn", "nsx", "aws", "dynamic", "interface-subnet", "mac",
                    "fqdn-group", "route-tag"
                ],
                "type": "str"
            },
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "wildcard": {"type": "str"},
            "wildcard-fqdn": {"type": "str"},
            "end-mac": {"v_range": [["6.2.0", ""]], "type": "str"},
            "interface": {"v_range": [["6.2.0", ""]], "type": "str"},
            "sdn-addr-type": {"v_range": [["6.2.0", ""]], "choices": ["private", "public", "all"], "type": "str"},
            "start-mac": {"v_range": [["6.2.0", ""]], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
            "profile-list": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {"profile-id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}},
                "elements": "dict"
            },
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "clearpass-spt": {
                "v_range": [["6.2.2", ""]],
                "choices": ["unknown", "healthy", "quarantine", "checkup", "transition", "infected", "transient"],
                "type": "str"
            },
            "fsso-group": {"v_range": [["6.2.2", ""]], "type": "raw"},
            "sub-type": {
                "v_range": [["6.2.2", ""]],
                "choices": [
                    "sdn", "clearpass-spt", "fsso", "ems-tag", "swc-tag", "fortivoice-tag", "fortinac-tag", "fortipolicy-tag", "device-identification",
                    "rsso", "external-resource", "obsolete"
                ],
                "type": "str"
            },
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "obj-tag": {"v_range": [["6.4.2", ""]], "type": "str"},
            "obj-type": {"v_range": [["6.4.2", ""]], "choices": ["ip", "mac"], "type": "str"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "macaddr": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "node-ip-only": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "dirty": {"v_range": [["7.0.3", ""]], "choices": ["dirty", "clean"], "type": "str"},
            "tag-detection-level": {"v_range": [["7.0.3", ""]], "type": "str"},
            "tag-type": {"v_range": [["7.0.3", ""]], "type": "str"},
            "hw-model": {"v_range": [["7.4.0", ""]], "type": "str"},
            "hw-vendor": {"v_range": [["7.4.0", ""]], "type": "str"},
            "os": {"v_range": [["7.4.0", ""]], "type": "str"},
            "route-tag": {"v_range": [["7.4.0", ""]], "type": "int"},
            "sw-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "sso-attribute-value": {"v_range": [["7.6.2", ""]], "type": "raw"}
        }
    },
    "firewall_address6": {
        "stated": true,
        "options": {
            "cache-ttl": {"type": "int"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "cache-ttl": {"type": "int"},
                    "color": {"type": "int"},
                    "comment": {"type": "str"},
                    "end-ip": {"type": "str"},
                    "fqdn": {"type": "str"},
                    "host": {"type": "str"},
                    "host-type": {"choices": ["any", "specific"], "type": "str"},
                    "ip6": {"type": "str"},
                    "obj-id": {"type": "str"},
                    "sdn": {"choices": ["nsx"], "type": "str"},
                    "start-ip": {"type": "str"},
                    "tags": {"type": "raw"},
                    "template": {"type": "str"},
                    "type": {"choices": ["ipprefix", "iprange", "nsx", "dynamic", "fqdn", "template", "mac", "geography", "route-tag"], "type": "str"},
                    "uuid": {"type": "str"},
                    "visibility": {"choices": ["disable", "enable"], "type": "str"},
                    "subnet-segment": {
                        "v_range": [["6.2.1", ""]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["6.2.1", ""]], "type": "str"},
                            "type": {"v_range": [["6.2.1", ""]], "choices": ["any", "specific"], "type": "str"},
                            "value": {"v_range": [["6.2.1", ""]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
                    "end-mac": {"v_range": [["6.2.5", "6.2.13"], ["6.4.1", ""]], "type": "str"},
                    "start-mac": {"v_range": [["6.2.5", "6.2.13"], ["6.4.1", ""]], "type": "str"},
                    "country": {"v_range": [["6.4.0", ""]], "type": "str"},
                    "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
                    "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "macaddr": {"v_range": [["7.0.0", ""]], "type": "raw"},
                    "epg-name": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "sdn-tag": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "tenant": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "route-tag": {"v_range": [["7.4.0", ""]], "type": "int"},
                    "filter": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "type": "str"},
                    "sdn-addr-type": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "choices": ["all", "private", "public"], "type": "str"}
                },
                "elements": "dict"
            },
            "end-ip": {"type": "str"},
            "fqdn": {"type": "str"},
            "host": {"type": "str"},
            "host-type": {"choices": ["any", "specific"], "type": "str"},
            "ip6": {"type": "str"},
            "list": {
                "type": "list",
                "options": {
                    "ip": {"type": "str"},
                    "net-id": {"v_range": [["6.2.1", ""]], "type": "str"},
                    "obj-id": {"v_range": [["6.2.1", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "name": {"required": true, "type": "str"},
            "obj-id": {"type": "str"},
            "sdn": {"choices": ["nsx"], "type": "str"},
            "start-ip": {"type": "str"},
            "subnet-segment": {
                "type": "list",
                "options": {"name": {"type": "str"}, "type": {"choices": ["any", "specific"], "type": "str"}, "value": {"type": "str"}},
                "elements": "dict"
            },
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "template": {"type": "str"},
            "type": {"choices": ["ipprefix", "iprange", "nsx", "dynamic", "fqdn", "template", "mac", "geography", "route-tag"], "type": "str"},
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
            "profile-list": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {"profile-id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}},
                "elements": "dict"
            },
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "end-mac": {"v_range": [["6.2.5", "6.2.13"], ["6.4.1", ""]], "type": "str"},
            "start-mac": {"v_range": [["6.2.5", "6.2.13"], ["6.4.1", ""]], "type": "str"},
            "country": {"v_range": [["6.4.0", ""]], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "macaddr": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "epg-name": {"v_range": [["7.2.1", ""]], "type": "str"},
            "sdn-tag": {"v_range": [["7.2.1", ""]], "type": "str"},
            "tenant": {"v_range": [["7.2.1", ""]], "type": "str"},
            "route-tag": {"v_range": [["7.4.0", ""]], "type": "int"},
            "filter": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "type": "str"},
            "sdn-addr-type": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "choices": ["all", "private", "public"], "type": "str"}
        }
    },
    "firewall_address6_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "cache-ttl": {"type": "int"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "end-ip": {"type": "str"},
            "fqdn": {"type": "str"},
            "host": {"type": "str"},
            "host-type": {"choices": ["any", "specific"], "type": "str"},
            "ip6": {"type": "str"},
            "obj-id": {"type": "str"},
            "sdn": {"choices": ["nsx"], "type": "str"},
            "start-ip": {"type": "str"},
            "tags": {"type": "raw"},
            "template": {"type": "str"},
            "type": {"choices": ["ipprefix", "iprange", "nsx", "dynamic", "fqdn", "template", "mac", "geography", "route-tag"], "type": "str"},
            "uuid": {"type": "str"},
            "visibility": {"choices": ["disable", "enable"], "type": "str"},
            "subnet-segment": {
                "v_range": [["6.2.1", ""]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["6.2.1", ""]], "type": "str"},
                    "type": {"v_range": [["6.2.1", ""]], "choices": ["any", "specific"], "type": "str"},
                    "value": {"v_range": [["6.2.1", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "end-mac": {"v_range": [["6.2.5", "6.2.13"], ["6.4.1", ""]], "type": "str"},
            "start-mac": {"v_range": [["6.2.5", "6.2.13"], ["6.4.1", ""]], "type": "str"},
            "country": {"v_range": [["6.4.0", ""]], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "macaddr": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "epg-name": {"v_range": [["7.2.1", ""]], "type": "str"},
            "sdn-tag": {"v_range": [["7.2.1", ""]], "type": "str"},
            "tenant": {"v_range": [["7.2.1", ""]], "type": "str"},
            "route-tag": {"v_range": [["7.4.0", ""]], "type": "int"},
            "filter": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "type": "str"},
            "sdn-addr-type": {"v_range": [["7.4.4", "7.4.7"], ["7.6.2", ""]], "choices": ["all", "private", "public"], "type": "str"}
        }
    },
    "firewall_address6_dynamicmapping_subnetsegment": {
        "stated": true,
        "options": {
            "name": {"v_range": [["6.2.1", "7.2.5"], ["7.4.0", "7.4.0"]], "required": true, "type": "str"},
            "type": {"v_range": [["6.2.1", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["any", "specific"], "type": "str"},
            "value": {"v_range": [["6.2.1", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "str"}
        }
    },
    "firewall_address6_list": {
        "stated": true,
        "options": {
            "ip": {"required": true, "type": "str"},
            "net-id": {"v_range": [["6.2.1", ""]], "type": "str"},
            "obj-id": {"v_range": [["6.2.1", ""]], "type": "str"}
        }
    },
    "firewall_address6_profilelist": {"stated": true, "options": {"profile-id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}}},
    "firewall_address6_subnetsegment": {
        "stated": true,
        "options": {"name": {"required": true, "type": "str"}, "type": {"choices": ["any", "specific"], "type": "str"}, "value": {"type": "str"}}
    },
    "firewall_address6_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_address6template": {
        "stated": true,
        "options": {
            "ip6": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "subnet-segment": {
                "type": "list",
                "options": {
                    "bits": {"type": "int"},
                    "exclusive": {"choices": ["disable", "enable"], "type": "str"},
                    "id": {"type": "int"},
                    "name": {"type": "str"},
                    "values": {"type": "list", "options": {"name": {"type": "str"}, "value": {"type": "str"}}, "elements": "dict"}
                },
                "elements": "dict"
            },
            "subnet-segment-count": {"type": "int"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "fabric-object": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "uuid": {"v_range": [["7.6.0", ""]], "type": "str"}
        }
    },
    "firewall_address6template_subnetsegment": {
        "stated": true,
        "options": {
            "bits": {"type": "int"},
            "exclusive": {"choices": ["disable", "enable"], "type": "str"},
            "id": {"required": true, "type": "int"},
            "name": {"type": "str"},
            "values": {"type": "list", "options": {"name": {"type": "str"}, "value": {"type": "str"}}, "elements": "dict"}
        }
    },
    "firewall_address6template_subnetsegment_values": {"stated": true, "options": {"name": {"required": true, "type": "str"}, "value": {"type": "str"}}},
    "firewall_address_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "allow-routing": {"choices": ["disable", "enable"], "type": "str"},
            "associated-interface": {"type": "str"},
            "cache-ttl": {"type": "int"},
            "color": {"type": "int"},
            "comment": {"type": "raw"},
            "country": {"type": "str"},
            "end-ip": {"type": "str"},
            "end-mac": {"type": "str"},
            "epg-name": {"type": "str"},
            "filter": {"type": "str"},
            "fqdn": {"type": "str"},
            "interface": {"type": "str"},
            "obj-id": {"type": "str"},
            "organization": {"type": "str"},
            "policy-group": {"type": "str"},
            "sdn": {"choices": ["aci", "aws", "nsx", "nuage", "azure", "gcp", "oci", "openstack"], "type": "str"},
            "sdn-addr-type": {"choices": ["private", "public", "all"], "type": "str"},
            "sdn-tag": {"type": "str"},
            "start-ip": {"type": "str"},
            "start-mac": {"type": "str"},
            "subnet": {"type": "str"},
            "subnet-name": {"type": "str"},
            "tags": {"type": "raw"},
            "tenant": {"type": "str"},
            "type": {
                "choices": [
                    "ipmask", "iprange", "fqdn", "wildcard", "geography", "url", "wildcard-fqdn", "nsx", "aws", "dynamic", "interface-subnet", "mac",
                    "fqdn-group", "route-tag"
                ],
                "type": "str"
            },
            "url": {"type": "str"},
            "uuid": {"type": "str"},
            "visibility": {"choices": ["disable", "enable"], "type": "str"},
            "wildcard": {"type": "str"},
            "wildcard-fqdn": {"type": "str"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "clearpass-spt": {
                "v_range": [["6.2.2", ""]],
                "choices": ["unknown", "healthy", "quarantine", "checkup", "transition", "infected", "transient"],
                "type": "str"
            },
            "fsso-group": {"v_range": [["6.2.2", ""]], "type": "raw"},
            "sub-type": {
                "v_range": [["6.2.2", ""]],
                "choices": [
                    "sdn", "clearpass-spt", "fsso", "ems-tag", "swc-tag", "fortivoice-tag", "fortinac-tag", "fortipolicy-tag", "device-identification",
                    "rsso", "external-resource", "obsolete"
                ],
                "type": "str"
            },
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "obj-tag": {"v_range": [["6.4.2", ""]], "type": "str"},
            "obj-type": {"v_range": [["6.4.2", ""]], "choices": ["ip", "mac"], "type": "str"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "macaddr": {"v_range": [["7.0.0", ""]], "type": "raw"},
            "node-ip-only": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "dirty": {"v_range": [["7.0.3", ""]], "choices": ["dirty", "clean"], "type": "str"},
            "pattern-end": {"v_range": [["7.0.3", ""]], "type": "int"},
            "pattern-start": {"v_range": [["7.0.3", ""]], "type": "int"},
            "tag-detection-level": {"v_range": [["7.0.3", ""]], "type": "str"},
            "tag-type": {"v_range": [["7.0.3", ""]], "type": "str"},
            "hw-model": {"v_range": [["7.4.0", ""]], "type": "str"},
            "hw-vendor": {"v_range": [["7.4.0", ""]], "type": "str"},
            "os": {"v_range": [["7.4.0", ""]], "type": "str"},
            "route-tag": {"v_range": [["7.4.0", ""]], "type": "int"},
            "sw-version": {"v_range": [["7.4.0", ""]], "type": "str"},
            "sso-attribute-value": {"v_range": [["7.6.2", ""]], "type": "raw"}
        }
    },
    "firewall_address_list": {
        "stated": true,
        "options": {
            "ip": {"required": true, "type": "str"},
            "net-id": {"v_range": [["6.2.0", ""]], "type": "str"},
            "obj-id": {"v_range": [["6.2.0", ""]], "type": "str"}
        }
    },
    "firewall_address_profilelist": {"stated": true, "options": {"profile-id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}}},
    "firewall_address_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_addrgrp": {
        "stated": true,
        "options": {
            "allow-routing": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "raw"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "allow-routing": {"choices": ["disable", "enable"], "type": "str"},
                    "color": {"type": "int"},
                    "comment": {"type": "raw"},
                    "exclude": {"choices": ["disable", "enable"], "type": "str"},
                    "exclude-member": {"type": "raw"},
                    "member": {"type": "list", "elements": "str"},
                    "tags": {"type": "raw"},
                    "uuid": {"type": "str"},
                    "visibility": {"choices": ["disable", "enable"], "type": "str"},
                    "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
                    "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
                    "type": {"v_range": [["6.4.0", ""]], "choices": ["default", "array", "folder"], "type": "str"},
                    "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "category": {"v_range": [["7.0.0", ""]], "choices": ["default", "ztna-ems-tag", "ztna-geo-tag"], "type": "str"}
                },
                "elements": "dict"
            },
            "member": {"type": "list", "elements": "str"},
            "name": {"required": true, "type": "str"},
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "exclude": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude-member": {"v_range": [["6.2.0", ""]], "type": "raw"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "type": {"v_range": [["6.4.0", ""]], "choices": ["default", "array", "folder"], "type": "str"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "category": {"v_range": [["7.0.0", ""]], "choices": ["default", "ztna-ems-tag", "ztna-geo-tag"], "type": "str"}
        }
    },
    "firewall_addrgrp6": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "color": {"type": "int"},
                    "comment": {"type": "str"},
                    "member": {"type": "raw"},
                    "tags": {"type": "raw"},
                    "uuid": {"type": "str"},
                    "visibility": {"choices": ["disable", "enable"], "type": "str"},
                    "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
                    "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
                    "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "exclude": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "exclude-member": {"v_range": [["7.4.0", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude-member": {"v_range": [["7.4.0", ""]], "type": "raw"}
        }
    },
    "firewall_addrgrp6_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "member": {"type": "raw"},
            "tags": {"type": "raw"},
            "uuid": {"type": "str"},
            "visibility": {"choices": ["disable", "enable"], "type": "str"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude-member": {"v_range": [["7.4.0", ""]], "type": "raw"}
        }
    },
    "firewall_addrgrp6_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_addrgrp_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "allow-routing": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "raw"},
            "exclude": {"choices": ["disable", "enable"], "type": "str"},
            "exclude-member": {"type": "raw"},
            "member": {"type": "raw"},
            "tags": {"type": "raw"},
            "uuid": {"type": "str"},
            "visibility": {"choices": ["disable", "enable"], "type": "str"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "type": {"v_range": [["6.4.0", ""]], "choices": ["default", "array", "folder"], "type": "str"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "category": {"v_range": [["7.0.0", ""]], "choices": ["default", "ztna-ems-tag", "ztna-geo-tag"], "type": "str"}
        }
    },
    "firewall_addrgrp_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_carrierendpointbwl": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "entries": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.0.0", "7.6.2"]], "type": "list", "choices": ["block", "exempt", "exempt-mass-mms"], "elements": "str"},
                    "carrier-endpoint": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "log-action": {"v_range": [["6.0.0", "7.6.2"]], "type": "list", "choices": ["archive", "intercept"], "elements": "str"},
                    "pattern-type": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["wildcard", "regexp", "simple"], "type": "str"},
                    "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "int"},
            "name": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"}
        }
    },
    "firewall_carrierendpointbwl_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.0.0", "7.6.2"]], "type": "list", "choices": ["block", "exempt", "exempt-mass-mms"], "elements": "str"},
            "carrier-endpoint": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "str"},
            "log-action": {"v_range": [["6.0.0", "7.6.2"]], "type": "list", "choices": ["archive", "intercept"], "elements": "str"},
            "pattern-type": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["wildcard", "regexp", "simple"], "type": "str"},
            "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_casbprofile": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.4.1", "7.4.1"]], "required": true, "type": "str"},
            "saas-application": {
                "v_range": [["7.4.1", "7.4.1"]],
                "type": "list",
                "options": {
                    "access-rule": {
                        "v_range": [["7.4.1", "7.4.1"]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                            "bypass": {
                                "v_range": [["7.4.1", "7.4.1"]],
                                "type": "list",
                                "choices": ["av", "dlp", "web-filter", "file-filter", "video-filter"],
                                "elements": "str"
                            },
                            "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "custom-control": {
                        "v_range": [["7.4.1", "7.4.1"]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"},
                            "option": {
                                "v_range": [["7.4.1", "7.4.1"]],
                                "type": "list",
                                "options": {
                                    "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"},
                                    "user-input": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"}
                                },
                                "elements": "dict"
                            }
                        },
                        "elements": "dict"
                    },
                    "domain-control": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "domain-control-domains": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"},
                    "log": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"},
                    "safe-search": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "safe-search-control": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"},
                    "tenant-control": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "tenant-control-tenants": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"}
                },
                "elements": "dict"
            }
        }
    },
    "firewall_casbprofile_saasapplication": {
        "stated": true,
        "options": {
            "access-rule": {
                "v_range": [["7.4.1", "7.4.1"]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["block", "monitor", "bypass"], "type": "str"},
                    "bypass": {
                        "v_range": [["7.4.1", "7.4.1"]],
                        "type": "list",
                        "choices": ["av", "dlp", "web-filter", "file-filter", "video-filter"],
                        "elements": "str"
                    },
                    "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"}
                },
                "elements": "dict"
            },
            "custom-control": {
                "v_range": [["7.4.1", "7.4.1"]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"},
                    "option": {
                        "v_range": [["7.4.1", "7.4.1"]],
                        "type": "list",
                        "options": {
                            "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"},
                            "user-input": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"}
                        },
                        "elements": "dict"
                    }
                },
                "elements": "dict"
            },
            "domain-control": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
            "domain-control-domains": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"},
            "log": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["7.4.1", "7.4.1"]], "required": true, "type": "str"},
            "safe-search": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
            "safe-search-control": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"},
            "tenant-control": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["disable", "enable"], "type": "str"},
            "tenant-control-tenants": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"}
        }
    },
    "firewall_casbprofile_saasapplication_accessrule": {
        "stated": true,
        "options": {
            "action": {"v_range": [["7.4.1", "7.4.1"]], "choices": ["block", "monitor", "bypass"], "type": "str"},
            "bypass": {
                "v_range": [["7.4.1", "7.4.1"]],
                "type": "list",
                "choices": ["av", "dlp", "web-filter", "file-filter", "video-filter"],
                "elements": "str"
            },
            "name": {"v_range": [["7.4.1", "7.4.1"]], "required": true, "type": "str"}
        }
    },
    "firewall_casbprofile_saasapplication_customcontrol": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.4.1", "7.4.1"]], "required": true, "type": "str"},
            "option": {
                "v_range": [["7.4.1", "7.4.1"]],
                "type": "list",
                "options": {
                    "name": {"v_range": [["7.4.1", "7.4.1"]], "type": "str"},
                    "user-input": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"}
                },
                "elements": "dict"
            }
        }
    },
    "firewall_casbprofile_saasapplication_customcontrol_option": {
        "stated": true,
        "options": {
            "name": {"v_range": [["7.4.1", "7.4.1"]], "required": true, "type": "str"},
            "user-input": {"v_range": [["7.4.1", "7.4.1"]], "type": "list", "elements": "str"}
        }
    },
    "firewall_decryptedtrafficmirror": {
        "stated": true,
        "options": {
            "dstmac": {"v_range": [["6.4.1", ""]], "type": "str"},
            "interface": {"v_range": [["6.4.1", ""]], "type": "raw"},
            "name": {"v_range": [["6.4.1", ""]], "required": true, "type": "str"},
            "traffic-source": {"v_range": [["6.4.1", ""]], "choices": ["client", "server", "both"], "type": "str"},
            "traffic-type": {"v_range": [["6.4.1", ""]], "type": "list", "choices": ["ssl", "ssh"], "elements": "str"}
        }
    },
    "firewall_explicitproxyaddress": {
        "stated": true,
        "options": {
            "case-sensitivity": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "category": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "color": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
            "comment": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "header": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "header-group": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "options": {
                    "case-sensitivity": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
                    "header": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
                    "header-name": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
                    "id": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"}
                },
                "elements": "dict"
            },
            "header-name": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "host": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "host-regex": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "method": {
                "v_range": [["6.2.0", "6.2.13"]],
                "type": "list",
                "choices": ["delete", "get", "head", "options", "post", "put", "trace", "connect"],
                "elements": "str"
            },
            "name": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "str"},
            "path": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "type": {
                "v_range": [["6.2.0", "6.2.13"]],
                "choices": ["host-regex", "url", "category", "method", "ua", "header", "src-advanced", "dst-advanced"],
                "type": "str"
            },
            "ua": {"v_range": [["6.2.0", "6.2.13"]], "type": "list", "choices": ["chrome", "ms", "firefox", "safari", "other"], "elements": "str"},
            "uuid": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "visibility": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_explicitproxyaddress_headergroup": {
        "stated": true,
        "options": {
            "case-sensitivity": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "header": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "header-name": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "id": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "int"}
        }
    },
    "firewall_explicitproxyaddrgrp": {
        "stated": true,
        "options": {
            "color": {"v_range": [["6.2.0", "6.2.13"]], "type": "int"},
            "comment": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "member": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "name": {"v_range": [["6.2.0", "6.2.13"]], "required": true, "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "type": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["src", "dst"], "type": "str"},
            "uuid": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "visibility": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_gtp": {
        "stated": true,
        "options": {
            "addr-notify": {"type": "str"},
            "apn": {
                "type": "list",
                "options": {
                    "action": {"choices": ["allow", "deny"], "type": "str"},
                    "apnmember": {"type": "raw"},
                    "id": {"type": "int"},
                    "selection-mode": {"type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"}
                },
                "elements": "dict"
            },
            "apn-filter": {"choices": ["disable", "enable"], "type": "str"},
            "authorized-ggsns": {"type": "str"},
            "authorized-sgsns": {"type": "str"},
            "comment": {"type": "str"},
            "context-id": {"type": "int"},
            "control-plane-message-rate-limit": {"type": "int"},
            "default-apn-action": {"choices": ["allow", "deny"], "type": "str"},
            "default-imsi-action": {"choices": ["allow", "deny"], "type": "str"},
            "default-ip-action": {"choices": ["allow", "deny"], "type": "str"},
            "default-noip-action": {"choices": ["allow", "deny"], "type": "str"},
            "default-policy-action": {"choices": ["allow", "deny"], "type": "str"},
            "denied-log": {"choices": ["disable", "enable"], "type": "str"},
            "echo-request-interval": {"type": "int"},
            "extension-log": {"choices": ["disable", "enable"], "type": "str"},
            "forwarded-log": {"choices": ["disable", "enable"], "type": "str"},
            "global-tunnel-limit": {"type": "str"},
            "gtp-in-gtp": {"choices": ["allow", "deny"], "type": "str"},
            "gtpu-denied-log": {"choices": ["disable", "enable"], "type": "str"},
            "gtpu-forwarded-log": {"choices": ["disable", "enable"], "type": "str"},
            "gtpu-log-freq": {"type": "int"},
            "half-close-timeout": {"type": "int"},
            "half-open-timeout": {"type": "int"},
            "handover-group": {"type": "str"},
            "ie-remove-policy": {
                "type": "list",
                "options": {
                    "id": {"type": "int"},
                    "remove-ies": {"type": "list", "choices": ["apn-restriction", "rat-type", "rai", "uli", "imei"], "elements": "str"},
                    "sgsn-addr": {"type": "str"},
                    "sgsn-addr6": {"v_range": [["6.4.2", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "ie-remover": {"choices": ["disable", "enable"], "type": "str"},
            "ie-white-list-v0v1": {"type": "str"},
            "ie-white-list-v2": {"type": "str"},
            "imsi": {
                "type": "list",
                "options": {
                    "action": {"choices": ["allow", "deny"], "type": "str"},
                    "apnmember": {"type": "raw"},
                    "id": {"type": "int"},
                    "mcc-mnc": {"type": "str"},
                    "msisdn-prefix": {"type": "str"},
                    "selection-mode": {"type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"}
                },
                "elements": "dict"
            },
            "imsi-filter": {"choices": ["disable", "enable"], "type": "str"},
            "interface-notify": {"type": "str"},
            "invalid-reserved-field": {"choices": ["allow", "deny"], "type": "str"},
            "invalid-sgsns-to-log": {"type": "str"},
            "ip-filter": {"choices": ["disable", "enable"], "type": "str"},
            "ip-policy": {
                "type": "list",
                "options": {
                    "action": {"choices": ["allow", "deny"], "type": "str"},
                    "dstaddr": {"type": "str"},
                    "id": {"type": "int"},
                    "srcaddr": {"type": "str"},
                    "dstaddr6": {"v_range": [["6.4.2", ""]], "type": "str"},
                    "srcaddr6": {"v_range": [["6.4.2", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "log-freq": {"type": "int"},
            "log-gtpu-limit": {"type": "int"},
            "log-imsi-prefix": {"type": "str"},
            "log-msisdn-prefix": {"type": "str"},
            "max-message-length": {"type": "int"},
            "message-filter-v0v1": {"type": "str"},
            "message-filter-v2": {"type": "str"},
            "min-message-length": {"type": "int"},
            "miss-must-ie": {"choices": ["allow", "deny"], "type": "str"},
            "monitor-mode": {"choices": ["disable", "enable", "vdom"], "type": "str"},
            "name": {"required": true, "type": "str"},
            "noip-filter": {"choices": ["disable", "enable"], "type": "str"},
            "noip-policy": {
                "type": "list",
                "options": {
                    "action": {"choices": ["allow", "deny"], "type": "str"},
                    "end": {"type": "int"},
                    "id": {"type": "int"},
                    "start": {"type": "int"},
                    "type": {"choices": ["etsi", "ietf"], "type": "str"}
                },
                "elements": "dict"
            },
            "out-of-state-ie": {"choices": ["allow", "deny"], "type": "str"},
            "out-of-state-message": {"choices": ["allow", "deny"], "type": "str"},
            "per-apn-shaper": {
                "type": "list",
                "options": {"apn": {"type": "str"}, "id": {"type": "int"}, "rate-limit": {"type": "int"}, "version": {"type": "int"}},
                "elements": "dict"
            },
            "policy": {
                "type": "list",
                "options": {
                    "action": {"choices": ["allow", "deny"], "type": "str"},
                    "apn-sel-mode": {"type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"},
                    "apnmember": {"type": "raw"},
                    "id": {"type": "int"},
                    "imei": {"type": "str"},
                    "imsi": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
                    "max-apn-restriction": {"choices": ["all", "public-1", "public-2", "private-1", "private-2"], "type": "str"},
                    "messages": {"type": "list", "choices": ["create-req", "create-res", "update-req", "update-res"], "elements": "str"},
                    "msisdn": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
                    "rai": {"type": "str"},
                    "rat-type": {
                        "type": "list",
                        "choices": ["any", "utran", "geran", "wlan", "gan", "hspa", "eutran", "virtual", "nbiot"],
                        "elements": "str"
                    },
                    "uli": {"type": "str"},
                    "imsi-prefix": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "msisdn-prefix": {"v_range": [["6.2.0", ""]], "type": "str"},
                    "apn": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
                },
                "elements": "dict"
            },
            "policy-filter": {"choices": ["disable", "enable"], "type": "str"},
            "port-notify": {"type": "int"},
            "rate-limit-mode": {"choices": ["per-profile", "per-stream", "per-apn"], "type": "str"},
            "rate-limited-log": {"choices": ["disable", "enable"], "type": "str"},
            "rate-sampling-interval": {"type": "int"},
            "remove-if-echo-expires": {"choices": ["disable", "enable"], "type": "str"},
            "remove-if-recovery-differ": {"choices": ["disable", "enable"], "type": "str"},
            "reserved-ie": {"choices": ["allow", "deny"], "type": "str"},
            "send-delete-when-timeout": {"choices": ["disable", "enable"], "type": "str"},
            "send-delete-when-timeout-v2": {"choices": ["disable", "enable"], "type": "str"},
            "spoof-src-addr": {"choices": ["allow", "deny"], "type": "str"},
            "state-invalid-log": {"choices": ["disable", "enable"], "type": "str"},
            "traffic-count-log": {"choices": ["disable", "enable"], "type": "str"},
            "tunnel-limit": {"type": "int"},
            "tunnel-limit-log": {"choices": ["disable", "enable"], "type": "str"},
            "tunnel-timeout": {"type": "int"},
            "unknown-version-action": {"choices": ["allow", "deny"], "type": "str"},
            "user-plane-message-rate-limit": {"type": "int"},
            "warning-threshold": {"type": "int"},
            "policy-v2": {
                "v_range": [["6.2.1", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.2.1", ""]], "choices": ["deny", "allow"], "type": "str"},
                    "apn-sel-mode": {"v_range": [["6.2.1", ""]], "type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"},
                    "apnmember": {"v_range": [["6.2.1", ""]], "type": "raw"},
                    "id": {"v_range": [["6.2.1", ""]], "type": "int"},
                    "imsi-prefix": {"v_range": [["6.2.1", ""]], "type": "str"},
                    "max-apn-restriction": {
                        "v_range": [["6.2.1", ""]],
                        "choices": ["all", "public-1", "public-2", "private-1", "private-2"],
                        "type": "str"
                    },
                    "mei": {"v_range": [["6.2.1", ""]], "type": "str"},
                    "messages": {
                        "v_range": [["6.2.1", ""]],
                        "type": "list",
                        "choices": ["create-ses-req", "create-ses-res", "modify-bearer-req", "modify-bearer-res"],
                        "elements": "str"
                    },
                    "msisdn-prefix": {"v_range": [["6.2.1", ""]], "type": "str"},
                    "rat-type": {
                        "v_range": [["6.2.1", ""]],
                        "type": "list",
                        "choices": ["any", "utran", "geran", "wlan", "gan", "hspa", "eutran", "virtual", "nbiot", "ltem", "nr"],
                        "elements": "str"
                    },
                    "uli": {"v_range": [["6.2.1", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "sub-second-interval": {"v_range": [["6.2.2", ""]], "choices": ["0.1", "0.25", "0.5"], "type": "str"},
            "sub-second-sampling": {"v_range": [["6.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "authorized-ggsns6": {"v_range": [["6.4.2", ""]], "type": "str"},
            "authorized-sgsns6": {"v_range": [["6.4.2", ""]], "type": "str"},
            "handover-group6": {"v_range": [["6.4.2", ""]], "type": "str"},
            "invalid-sgsns6-to-log": {"v_range": [["6.4.2", ""]], "type": "str"},
            "ie-validation": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "apn-restriction": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "charging-ID": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "charging-gateway-addr": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "end-user-addr": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "gsn-addr": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "imei": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "imsi": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "mm-context": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ms-tzone": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ms-validated": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "msisdn": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "nsapi": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "pdp-context": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "qos-profile": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "rai": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "rat-type": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "reordering-required": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "selection-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uli": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "message-rate-limit": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "create-aa-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "create-aa-pdp-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "create-mbms-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "create-mbms-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "create-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "create-pdp-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-aa-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-aa-pdp-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-mbms-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-mbms-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-pdp-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "echo-reponse": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "echo-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "error-indication": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "failure-report-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "failure-report-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "fwd-reloc-complete-ack": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "fwd-relocation-complete": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "fwd-relocation-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "fwd-relocation-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "fwd-srns-context": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "fwd-srns-context-ack": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "g-pdu": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "identification-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "identification-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-de-reg-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-de-reg-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-notify-rej-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-notify-rej-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-notify-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-notify-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-reg-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-reg-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-ses-start-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-ses-start-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-ses-stop-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "mbms-ses-stop-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "note-ms-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "note-ms-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "pdu-notify-rej-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "pdu-notify-rej-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "pdu-notify-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "pdu-notify-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ran-info": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "relocation-cancel-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "relocation-cancel-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "send-route-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "send-route-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "sgsn-context-ack": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "sgsn-context-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "sgsn-context-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "support-ext-hdr-notify": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "update-mbms-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "update-mbms-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "update-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "update-pdp-response": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "version-not-support": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "echo-response": {"v_range": [["7.4.3", ""]], "type": "int"}
                }
            },
            "message-rate-limit-v0": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "create-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "echo-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "message-rate-limit-v1": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "create-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-pdp-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "echo-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "message-rate-limit-v2": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "create-session-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "delete-session-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "echo-request": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "ie-allow-list-v0v1": {"v_range": [["7.0.0", ""]], "type": "str"},
            "ie-allow-list-v2": {"v_range": [["7.0.0", ""]], "type": "str"},
            "rat-timeout-profile": {"v_range": [["7.0.1", ""]], "type": "str"},
            "message-filter": {
                "v_range": [["6.2.8", "6.2.13"]],
                "type": "dict",
                "options": {
                    "create-aa-pdp": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "create-mbms": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "create-pdp": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "data-record": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "delete-aa-pdp": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "delete-mbms": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "delete-pdp": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "echo": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "error-indication": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "failure-report": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "fwd-relocation": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "fwd-srns-context": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "gtp-pdu": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "identification": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "mbms-notification": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "node-alive": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "note-ms-present": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "pdu-notification": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "ran-info": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "redirection": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "relocation-cancel": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "send-route": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "sgsn-context": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "support-extension": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "unknown-message-action": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "update-mbms": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "update-pdp": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
                    "version-not-support": {"v_range": [["6.2.8", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"}
                }
            },
            "gtpv0": {"v_range": [["7.6.0", ""]], "choices": ["allow", "deny"], "type": "str"},
            "echo-requires-path-in-use": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_gtp_apn": {
        "stated": true,
        "options": {
            "action": {"choices": ["allow", "deny"], "type": "str"},
            "apnmember": {"type": "raw"},
            "id": {"required": true, "type": "int"},
            "selection-mode": {"type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"}
        }
    },
    "firewall_gtp_ieremovepolicy": {
        "stated": true,
        "options": {
            "id": {"required": true, "type": "int"},
            "remove-ies": {"type": "list", "choices": ["apn-restriction", "rat-type", "rai", "uli", "imei"], "elements": "str"},
            "sgsn-addr": {"type": "str"},
            "sgsn-addr6": {"v_range": [["6.4.2", ""]], "type": "str"}
        }
    },
    "firewall_gtp_ievalidation": {
        "stated": false,
        "options": {
            "apn-restriction": {"choices": ["disable", "enable"], "type": "str"},
            "charging-ID": {"choices": ["disable", "enable"], "type": "str"},
            "charging-gateway-addr": {"choices": ["disable", "enable"], "type": "str"},
            "end-user-addr": {"choices": ["disable", "enable"], "type": "str"},
            "gsn-addr": {"choices": ["disable", "enable"], "type": "str"},
            "imei": {"choices": ["disable", "enable"], "type": "str"},
            "imsi": {"choices": ["disable", "enable"], "type": "str"},
            "mm-context": {"choices": ["disable", "enable"], "type": "str"},
            "ms-tzone": {"choices": ["disable", "enable"], "type": "str"},
            "ms-validated": {"choices": ["disable", "enable"], "type": "str"},
            "msisdn": {"choices": ["disable", "enable"], "type": "str"},
            "nsapi": {"choices": ["disable", "enable"], "type": "str"},
            "pdp-context": {"choices": ["disable", "enable"], "type": "str"},
            "qos-profile": {"choices": ["disable", "enable"], "type": "str"},
            "rai": {"choices": ["disable", "enable"], "type": "str"},
            "rat-type": {"choices": ["disable", "enable"], "type": "str"},
            "reordering-required": {"choices": ["disable", "enable"], "type": "str"},
            "selection-mode": {"choices": ["disable", "enable"], "type": "str"},
            "uli": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_gtp_imsi": {
        "stated": true,
        "options": {
            "action": {"choices": ["allow", "deny"], "type": "str"},
            "apnmember": {"type": "raw"},
            "id": {"required": true, "type": "int"},
            "mcc-mnc": {"type": "str"},
            "msisdn-prefix": {"type": "str"},
            "selection-mode": {"type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"}
        }
    },
    "firewall_gtp_ippolicy": {
        "stated": true,
        "options": {
            "action": {"choices": ["allow", "deny"], "type": "str"},
            "dstaddr": {"type": "str"},
            "id": {"required": true, "type": "int"},
            "srcaddr": {"type": "str"},
            "dstaddr6": {"v_range": [["6.4.2", ""]], "type": "str"},
            "srcaddr6": {"v_range": [["6.4.2", ""]], "type": "str"}
        }
    },
    "firewall_gtp_messagefilter": {
        "stated": false,
        "options": {
            "create-aa-pdp": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "create-mbms": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "create-pdp": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "data-record": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "delete-aa-pdp": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "delete-mbms": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "delete-pdp": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "echo": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "error-indication": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "failure-report": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "fwd-relocation": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "fwd-srns-context": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "gtp-pdu": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "identification": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "mbms-notification": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "node-alive": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "note-ms-present": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "pdu-notification": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "ran-info": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "redirection": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "relocation-cancel": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "send-route": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "sgsn-context": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "support-extension": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "unknown-message-action": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "update-mbms": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "update-pdp": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"},
            "version-not-support": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["allow", "deny"], "type": "str"}
        }
    },
    "firewall_gtp_messageratelimit": {
        "stated": false,
        "options": {
            "create-aa-pdp-request": {"type": "int"},
            "create-aa-pdp-response": {"type": "int"},
            "create-mbms-request": {"type": "int"},
            "create-mbms-response": {"type": "int"},
            "create-pdp-request": {"type": "int"},
            "create-pdp-response": {"type": "int"},
            "delete-aa-pdp-request": {"type": "int"},
            "delete-aa-pdp-response": {"type": "int"},
            "delete-mbms-request": {"type": "int"},
            "delete-mbms-response": {"type": "int"},
            "delete-pdp-request": {"type": "int"},
            "delete-pdp-response": {"type": "int"},
            "echo-reponse": {"type": "int"},
            "echo-request": {"type": "int"},
            "error-indication": {"type": "int"},
            "failure-report-request": {"type": "int"},
            "failure-report-response": {"type": "int"},
            "fwd-reloc-complete-ack": {"type": "int"},
            "fwd-relocation-complete": {"type": "int"},
            "fwd-relocation-request": {"type": "int"},
            "fwd-relocation-response": {"type": "int"},
            "fwd-srns-context": {"type": "int"},
            "fwd-srns-context-ack": {"type": "int"},
            "g-pdu": {"type": "int"},
            "identification-request": {"type": "int"},
            "identification-response": {"type": "int"},
            "mbms-de-reg-request": {"type": "int"},
            "mbms-de-reg-response": {"type": "int"},
            "mbms-notify-rej-request": {"type": "int"},
            "mbms-notify-rej-response": {"type": "int"},
            "mbms-notify-request": {"type": "int"},
            "mbms-notify-response": {"type": "int"},
            "mbms-reg-request": {"type": "int"},
            "mbms-reg-response": {"type": "int"},
            "mbms-ses-start-request": {"type": "int"},
            "mbms-ses-start-response": {"type": "int"},
            "mbms-ses-stop-request": {"type": "int"},
            "mbms-ses-stop-response": {"type": "int"},
            "note-ms-request": {"type": "int"},
            "note-ms-response": {"type": "int"},
            "pdu-notify-rej-request": {"type": "int"},
            "pdu-notify-rej-response": {"type": "int"},
            "pdu-notify-request": {"type": "int"},
            "pdu-notify-response": {"type": "int"},
            "ran-info": {"type": "int"},
            "relocation-cancel-request": {"type": "int"},
            "relocation-cancel-response": {"type": "int"},
            "send-route-request": {"type": "int"},
            "send-route-response": {"type": "int"},
            "sgsn-context-ack": {"type": "int"},
            "sgsn-context-request": {"type": "int"},
            "sgsn-context-response": {"type": "int"},
            "support-ext-hdr-notify": {"type": "int"},
            "update-mbms-request": {"type": "int"},
            "update-mbms-response": {"type": "int"},
            "update-pdp-request": {"type": "int"},
            "update-pdp-response": {"type": "int"},
            "version-not-support": {"type": "int"},
            "echo-response": {"v_range": [["7.4.3", ""]], "type": "int"}
        }
    },
    "firewall_gtp_messageratelimitv0": {
        "stated": false,
        "options": {"create-pdp-request": {"type": "int"}, "delete-pdp-request": {"type": "int"}, "echo-request": {"type": "int"}}
    },
    "firewall_gtp_messageratelimitv1": {
        "stated": false,
        "options": {"create-pdp-request": {"type": "int"}, "delete-pdp-request": {"type": "int"}, "echo-request": {"type": "int"}}
    },
    "firewall_gtp_messageratelimitv2": {
        "stated": false,
        "options": {"create-session-request": {"type": "int"}, "delete-session-request": {"type": "int"}, "echo-request": {"type": "int"}}
    },
    "firewall_gtp_noippolicy": {
        "stated": true,
        "options": {
            "action": {"choices": ["allow", "deny"], "type": "str"},
            "end": {"type": "int"},
            "id": {"required": true, "type": "int"},
            "start": {"type": "int"},
            "type": {"choices": ["etsi", "ietf"], "type": "str"}
        }
    },
    "firewall_gtp_perapnshaper": {
        "stated": true,
        "options": {"apn": {"type": "str"}, "id": {"required": true, "type": "int"}, "rate-limit": {"type": "int"}, "version": {"type": "int"}}
    },
    "firewall_gtp_policy": {
        "stated": true,
        "options": {
            "action": {"choices": ["allow", "deny"], "type": "str"},
            "apn-sel-mode": {"type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"},
            "apnmember": {"type": "raw"},
            "id": {"required": true, "type": "int"},
            "imei": {"type": "str"},
            "imsi": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
            "max-apn-restriction": {"choices": ["all", "public-1", "public-2", "private-1", "private-2"], "type": "str"},
            "messages": {"type": "list", "choices": ["create-req", "create-res", "update-req", "update-res"], "elements": "str"},
            "msisdn": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
            "rai": {"type": "str"},
            "rat-type": {"type": "list", "choices": ["any", "utran", "geran", "wlan", "gan", "hspa", "eutran", "virtual", "nbiot"], "elements": "str"},
            "uli": {"type": "str"},
            "imsi-prefix": {"v_range": [["6.2.0", ""]], "type": "str"},
            "msisdn-prefix": {"v_range": [["6.2.0", ""]], "type": "str"},
            "apn": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"}
        }
    },
    "firewall_gtp_policyv2": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.2.1", ""]], "choices": ["deny", "allow"], "type": "str"},
            "apn-sel-mode": {"v_range": [["6.2.1", ""]], "type": "list", "choices": ["ms", "net", "vrf"], "elements": "str"},
            "apnmember": {"v_range": [["6.2.1", ""]], "type": "raw"},
            "id": {"v_range": [["6.2.1", ""]], "required": true, "type": "int"},
            "imsi-prefix": {"v_range": [["6.2.1", ""]], "type": "str"},
            "max-apn-restriction": {"v_range": [["6.2.1", ""]], "choices": ["all", "public-1", "public-2", "private-1", "private-2"], "type": "str"},
            "mei": {"v_range": [["6.2.1", ""]], "type": "str"},
            "messages": {
                "v_range": [["6.2.1", ""]],
                "type": "list",
                "choices": ["create-ses-req", "create-ses-res", "modify-bearer-req", "modify-bearer-res"],
                "elements": "str"
            },
            "msisdn-prefix": {"v_range": [["6.2.1", ""]], "type": "str"},
            "rat-type": {
                "v_range": [["6.2.1", ""]],
                "type": "list",
                "choices": ["any", "utran", "geran", "wlan", "gan", "hspa", "eutran", "virtual", "nbiot", "ltem", "nr"],
                "elements": "str"
            },
            "uli": {"v_range": [["6.2.1", ""]], "type": "raw"}
        }
    },
    "firewall_identitybasedroute": {
        "stated": true,
        "options": {
            "comments": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "rule": {
                "type": "list",
                "options": {"device": {"type": "str"}, "gateway": {"type": "str"}, "groups": {"type": "raw"}, "id": {"type": "int"}},
                "elements": "dict"
            }
        }
    },
    "firewall_identitybasedroute_rule": {
        "stated": true,
        "options": {"device": {"type": "str"}, "gateway": {"type": "str"}, "groups": {"type": "raw"}, "id": {"required": true, "type": "int"}}
    },
    "firewall_internetservice": {
        "stated": false,
        "options": {
            "database": {"choices": ["isdb", "irdb"], "type": "str"},
            "direction": {"choices": ["src", "dst", "both"], "type": "str"},
            "entry": {
                "v_range": [["6.0.0", "7.2.1"]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
                    "ip-number": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
                    "ip-range-number": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
                    "port": {"v_range": [["6.0.0", "7.2.1"]], "type": "raw"},
                    "protocol": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"}
                },
                "elements": "dict"
            },
            "icon-id": {"type": "int"},
            "id": {"type": "int"},
            "name": {"type": "str"},
            "offset": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
            "reputation": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "sld-id": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "extra-ip-range-number": {"v_range": [["6.2.0", ""]], "type": "int"},
            "ip-number": {"v_range": [["6.2.0", ""]], "type": "int"},
            "ip-range-number": {"v_range": [["6.2.0", ""]], "type": "int"},
            "jitter-threshold": {"v_range": [["6.2.0", "7.2.0"]], "type": "int"},
            "latency-threshold": {"v_range": [["6.2.0", "7.2.0"]], "type": "int"},
            "obsolete": {"v_range": [["6.2.0", ""]], "type": "int"},
            "packetloss-threshold": {"v_range": [["6.2.0", "7.2.0"]], "type": "int"},
            "singularity": {"v_range": [["6.2.0", ""]], "type": "int"},
            "city": {"v_range": [["6.4.0", "7.2.5"], ["7.4.0", "7.4.2"]], "type": "raw"},
            "country": {"v_range": [["6.4.0", "7.2.5"], ["7.4.0", "7.4.2"]], "type": "raw"},
            "region": {"v_range": [["6.4.0", "7.2.5"], ["7.4.0", "7.4.2"]], "type": "raw"},
            "city6": {"v_range": [["7.2.1", "7.2.5"], ["7.4.0", "7.4.2"]], "type": "raw"},
            "country6": {"v_range": [["7.2.1", "7.2.5"], ["7.4.0", "7.4.2"]], "type": "raw"},
            "extra-ip6-range-number": {"v_range": [["7.2.1", ""]], "type": "int"},
            "ip6-range-number": {"v_range": [["7.2.1", ""]], "type": "int"},
            "region6": {"v_range": [["7.2.1", "7.2.5"], ["7.4.0", "7.4.2"]], "type": "raw"}
        }
    },
    "firewall_internetservice_entry": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.0.0", "7.2.1"]], "required": true, "type": "int"},
            "ip-number": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
            "ip-range-number": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
            "port": {"v_range": [["6.0.0", "7.2.1"]], "type": "raw"},
            "protocol": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"}
        }
    },
    "firewall_internetserviceaddition": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["6.2.2", ""]], "type": "str"},
            "entry": {
                "v_range": [["6.2.2", ""]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.2.2", ""]], "type": "int"},
                    "port-range": {
                        "v_range": [["6.2.2", ""]],
                        "type": "list",
                        "options": {
                            "end-port": {"v_range": [["6.2.2", ""]], "type": "int"},
                            "id": {"v_range": [["6.2.2", ""]], "type": "int"},
                            "start-port": {"v_range": [["6.2.2", ""]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "protocol": {"v_range": [["6.2.2", ""]], "type": "int"},
                    "addr-mode": {"v_range": [["7.2.1", ""]], "choices": ["ipv4", "ipv6"], "type": "str"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["6.2.2", ""]], "required": true, "type": "str"}
        }
    },
    "firewall_internetserviceaddition_entry": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.2.2", ""]], "required": true, "type": "int"},
            "port-range": {
                "v_range": [["6.2.2", ""]],
                "type": "list",
                "options": {
                    "end-port": {"v_range": [["6.2.2", ""]], "type": "int"},
                    "id": {"v_range": [["6.2.2", ""]], "type": "int"},
                    "start-port": {"v_range": [["6.2.2", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "protocol": {"v_range": [["6.2.2", ""]], "type": "int"},
            "addr-mode": {"v_range": [["7.2.1", ""]], "choices": ["ipv4", "ipv6"], "type": "str"}
        }
    },
    "firewall_internetserviceaddition_entry_portrange": {
        "stated": true,
        "options": {
            "end-port": {"v_range": [["6.2.2", ""]], "type": "int"},
            "id": {"v_range": [["6.2.2", ""]], "required": true, "type": "int"},
            "start-port": {"v_range": [["6.2.2", ""]], "type": "int"}
        }
    },
    "firewall_internetservicecustom": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "disable-entry": {
                "v_range": [["6.0.0", "7.2.1"]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
                    "ip-range": {
                        "v_range": [["6.0.0", "7.2.1"]],
                        "type": "list",
                        "options": {
                            "end-ip": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
                            "id": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
                            "start-ip": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "port": {"v_range": [["6.0.0", "7.2.1"]], "type": "raw"},
                    "protocol": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"}
                },
                "elements": "dict"
            },
            "entry": {
                "type": "list",
                "options": {
                    "dst": {"type": "raw"},
                    "id": {"type": "int"},
                    "port-range": {
                        "type": "list",
                        "options": {"end-port": {"type": "int"}, "id": {"type": "int"}, "start-port": {"type": "int"}},
                        "elements": "dict"
                    },
                    "protocol": {"type": "int"},
                    "addr-mode": {"v_range": [["7.2.1", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
                    "dst6": {"v_range": [["7.2.1", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "master-service-id": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
            "name": {"required": true, "type": "str"},
            "reputation": {"v_range": [["6.2.0", ""]], "type": "int"},
            "id": {"v_range": [["6.4.2", ""]], "type": "int"}
        }
    },
    "firewall_internetservicecustom_disableentry": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.0.0", "7.2.1"]], "required": true, "type": "int"},
            "ip-range": {
                "v_range": [["6.0.0", "7.2.1"]],
                "type": "list",
                "options": {
                    "end-ip": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
                    "id": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"},
                    "start-ip": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"}
                },
                "elements": "dict"
            },
            "port": {"v_range": [["6.0.0", "7.2.1"]], "type": "raw"},
            "protocol": {"v_range": [["6.0.0", "7.2.1"]], "type": "int"}
        }
    },
    "firewall_internetservicecustom_disableentry_iprange": {
        "stated": true,
        "options": {
            "end-ip": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
            "id": {"v_range": [["6.0.0", "7.2.1"]], "required": true, "type": "int"},
            "start-ip": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"}
        }
    },
    "firewall_internetservicecustom_entry": {
        "stated": true,
        "options": {
            "dst": {"type": "raw"},
            "id": {"required": true, "type": "int"},
            "port-range": {
                "type": "list",
                "options": {"end-port": {"type": "int"}, "id": {"type": "int"}, "start-port": {"type": "int"}},
                "elements": "dict"
            },
            "protocol": {"type": "int"},
            "addr-mode": {"v_range": [["7.2.1", ""]], "choices": ["ipv4", "ipv6"], "type": "str"},
            "dst6": {"v_range": [["7.2.1", ""]], "type": "raw"}
        }
    },
    "firewall_internetservicecustom_entry_portrange": {
        "stated": true,
        "options": {"end-port": {"type": "int"}, "id": {"required": true, "type": "int"}, "start-port": {"type": "int"}}
    },
    "firewall_internetservicecustomgroup": {
        "stated": true,
        "options": {"comment": {"type": "str"}, "member": {"type": "raw"}, "name": {"required": true, "type": "str"}}
    },
    "firewall_internetserviceextension": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"},
            "disable-entry": {
                "v_range": [["7.4.7", "7.4.7"]],
                "type": "list",
                "options": {
                    "addr-mode": {"v_range": [["7.4.7", "7.4.7"]], "choices": ["ipv4", "ipv6"], "type": "str"},
                    "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "ip-range": {
                        "v_range": [["7.4.7", "7.4.7"]],
                        "type": "list",
                        "options": {
                            "end-ip": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"},
                            "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                            "start-ip": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "ip6-range": {
                        "v_range": [["7.4.7", "7.4.7"]],
                        "type": "list",
                        "options": {
                            "end-ip6": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"},
                            "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                            "start-ip6": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "port-range": {
                        "v_range": [["7.4.7", "7.4.7"]],
                        "type": "list",
                        "options": {
                            "end-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                            "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                            "start-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "protocol": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
                },
                "elements": "dict"
            },
            "entry": {
                "v_range": [["7.4.7", "7.4.7"]],
                "type": "list",
                "options": {
                    "addr-mode": {"v_range": [["7.4.7", "7.4.7"]], "choices": ["ipv4", "ipv6"], "type": "str"},
                    "dst": {"v_range": [["7.4.7", "7.4.7"]], "type": "list", "elements": "str"},
                    "dst6": {"v_range": [["7.4.7", "7.4.7"]], "type": "list", "elements": "str"},
                    "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "port-range": {
                        "v_range": [["7.4.7", "7.4.7"]],
                        "type": "list",
                        "options": {
                            "end-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                            "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                            "start-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "protocol": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
                },
                "elements": "dict"
            },
            "id": {"v_range": [["7.4.7", "7.4.7"]], "required": true, "type": "list", "elements": "str"}
        }
    },
    "firewall_internetserviceextension_disableentry": {
        "stated": true,
        "options": {
            "addr-mode": {"v_range": [["7.4.7", "7.4.7"]], "choices": ["ipv4", "ipv6"], "type": "str"},
            "id": {"v_range": [["7.4.7", "7.4.7"]], "required": true, "type": "int"},
            "ip-range": {
                "v_range": [["7.4.7", "7.4.7"]],
                "type": "list",
                "options": {
                    "end-ip": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"},
                    "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "start-ip": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
                },
                "elements": "dict"
            },
            "ip6-range": {
                "v_range": [["7.4.7", "7.4.7"]],
                "type": "list",
                "options": {
                    "end-ip6": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"},
                    "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "start-ip6": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
                },
                "elements": "dict"
            },
            "port-range": {
                "v_range": [["7.4.7", "7.4.7"]],
                "type": "list",
                "options": {
                    "end-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "start-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
                },
                "elements": "dict"
            },
            "protocol": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
        }
    },
    "firewall_internetserviceextension_disableentry_ip6range": {
        "stated": true,
        "options": {
            "end-ip6": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"},
            "id": {"v_range": [["7.4.7", "7.4.7"]], "required": true, "type": "int"},
            "start-ip6": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
        }
    },
    "firewall_internetserviceextension_disableentry_iprange": {
        "stated": true,
        "options": {
            "end-ip": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"},
            "id": {"v_range": [["7.4.7", "7.4.7"]], "required": true, "type": "int"},
            "start-ip": {"v_range": [["7.4.7", "7.4.7"]], "type": "str"}
        }
    },
    "firewall_internetserviceextension_disableentry_portrange": {
        "stated": true,
        "options": {
            "end-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
            "id": {"v_range": [["7.4.7", "7.4.7"]], "required": true, "type": "int"},
            "start-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
        }
    },
    "firewall_internetserviceextension_entry": {
        "stated": true,
        "options": {
            "addr-mode": {"v_range": [["7.4.7", "7.4.7"]], "choices": ["ipv4", "ipv6"], "type": "str"},
            "dst": {"v_range": [["7.4.7", "7.4.7"]], "type": "list", "elements": "str"},
            "dst6": {"v_range": [["7.4.7", "7.4.7"]], "type": "list", "elements": "str"},
            "id": {"v_range": [["7.4.7", "7.4.7"]], "required": true, "type": "int"},
            "port-range": {
                "v_range": [["7.4.7", "7.4.7"]],
                "type": "list",
                "options": {
                    "end-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "id": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
                    "start-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
                },
                "elements": "dict"
            },
            "protocol": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
        }
    },
    "firewall_internetserviceextension_entry_portrange": {
        "stated": true,
        "options": {
            "end-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"},
            "id": {"v_range": [["7.4.7", "7.4.7"]], "required": true, "type": "int"},
            "start-port": {"v_range": [["7.4.7", "7.4.7"]], "type": "int"}
        }
    },
    "firewall_internetservicegroup": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "direction": {"v_range": [["6.2.0", ""]], "choices": ["both", "source", "destination"], "type": "str"}
        }
    },
    "firewall_internetservicename": {
        "stated": true,
        "options": {
            "city-id": {"v_range": [["6.4.0", ""]], "type": "int"},
            "country-id": {"v_range": [["6.4.0", ""]], "type": "int"},
            "internet-service-id": {"v_range": [["6.4.0", ""]], "type": "str"},
            "name": {"v_range": [["6.4.0", ""]], "required": true, "type": "str"},
            "region-id": {"v_range": [["6.4.0", ""]], "type": "int"},
            "type": {"v_range": [["6.4.0", ""]], "choices": ["default", "location"], "type": "str"}
        }
    },
    "firewall_ippool": {
        "stated": true,
        "options": {
            "arp-intf": {"type": "str"},
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "associated-interface": {"type": "str"},
            "block-size": {"type": "int"},
            "comments": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "arp-intf": {"type": "str"},
                    "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
                    "associated-interface": {"type": "str"},
                    "block-size": {"type": "int"},
                    "comments": {"type": "str"},
                    "endip": {"type": "str"},
                    "num-blocks-per-user": {"type": "int"},
                    "pba-timeout": {"type": "int"},
                    "permit-any-host": {"choices": ["disable", "enable"], "type": "str"},
                    "source-endip": {"type": "str"},
                    "source-startip": {"type": "str"},
                    "startip": {"type": "str"},
                    "type": {"choices": ["overload", "one-to-one", "fixed-port-range", "port-block-allocation", "cgn-resource-allocation"], "type": "str"},
                    "cgn-block-size": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
                    "cgn-client-endip": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "str"},
                    "cgn-client-startip": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "str"},
                    "cgn-fixedalloc": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "cgn-overload": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "cgn-port-end": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
                    "cgn-port-start": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
                    "cgn-spa": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "utilization-alarm-clear": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
                    "utilization-alarm-raise": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
                    "endport": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "port-per-user": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "startport": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "add-nat64-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "cgn-client-ipv6shift": {"v_range": [["6.2.9", "6.2.13"], ["6.4.7", "6.4.15"], ["7.0.2", ""]], "type": "int"},
                    "nat64": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "subnet-broadcast-in-ippool": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "exclude-ip": {"v_range": [["7.2.2", ""]], "type": "raw"},
                    "pba-interim-log": {"v_range": [["7.4.3", ""]], "type": "int"},
                    "client-prefix-length": {"v_range": [["7.6.0", ""]], "type": "int"},
                    "icmp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"},
                    "privileged-port-use-pba": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "source-prefix6": {"v_range": [["7.6.0", ""]], "type": "str"},
                    "tcp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"},
                    "udp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "endip": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "num-blocks-per-user": {"type": "int"},
            "pba-timeout": {"type": "int"},
            "permit-any-host": {"choices": ["disable", "enable"], "type": "str"},
            "source-endip": {"type": "str"},
            "source-startip": {"type": "str"},
            "startip": {"type": "str"},
            "type": {"choices": ["overload", "one-to-one", "fixed-port-range", "port-block-allocation", "cgn-resource-allocation"], "type": "str"},
            "utilization-alarm-clear": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "cgn-fixedalloc": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cgn-client-startip": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "str"},
            "cgn-client-endip": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "str"},
            "cgn-overload": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cgn-block-size": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "utilization-alarm-raise": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "cgn-port-start": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "cgn-spa": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cgn-port-end": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "endport": {"v_range": [["7.0.0", ""]], "type": "int"},
            "port-per-user": {"v_range": [["7.0.0", ""]], "type": "int"},
            "startport": {"v_range": [["7.0.0", ""]], "type": "int"},
            "add-nat64-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "nat64": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cgn-client-ipv6shift": {"v_range": [["6.2.9", "6.2.13"], ["6.4.7", "6.4.15"], ["7.0.2", ""]], "type": "int"},
            "subnet-broadcast-in-ippool": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude-ip": {"v_range": [["7.2.2", ""]], "type": "raw"},
            "pba-interim-log": {"v_range": [["7.4.3", ""]], "type": "int"},
            "client-prefix-length": {"v_range": [["7.6.0", ""]], "type": "int"},
            "icmp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"},
            "privileged-port-use-pba": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "source-prefix6": {"v_range": [["7.6.0", ""]], "type": "str"},
            "tcp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"},
            "udp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"}
        }
    },
    "firewall_ippool6": {
        "stated": true,
        "options": {
            "comments": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "comments": {"type": "str"},
                    "endip": {"type": "str"},
                    "startip": {"type": "str"},
                    "add-nat46-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "nat46": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "external-prefix": {"v_range": [["7.6.0", ""]], "type": "str"},
                    "internal-prefix": {"v_range": [["7.6.0", ""]], "type": "str"},
                    "type": {"v_range": [["7.6.0", ""]], "choices": ["overload", "nptv6"], "type": "str"}
                },
                "elements": "dict"
            },
            "endip": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "startip": {"type": "str"},
            "add-nat46-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "nat46": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-prefix": {"v_range": [["7.6.0", ""]], "type": "str"},
            "internal-prefix": {"v_range": [["7.6.0", ""]], "type": "str"},
            "type": {"v_range": [["7.6.0", ""]], "choices": ["overload", "nptv6"], "type": "str"}
        }
    },
    "firewall_ippool6_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "comments": {"type": "str"},
            "endip": {"type": "str"},
            "startip": {"type": "str"},
            "add-nat46-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "nat46": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "external-prefix": {"v_range": [["7.6.0", ""]], "type": "str"},
            "internal-prefix": {"v_range": [["7.6.0", ""]], "type": "str"},
            "type": {"v_range": [["7.6.0", ""]], "choices": ["overload", "nptv6"], "type": "str"}
        }
    },
    "firewall_ippool_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "arp-intf": {"type": "str"},
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "associated-interface": {"type": "str"},
            "block-size": {"type": "int"},
            "comments": {"type": "str"},
            "endip": {"type": "str"},
            "num-blocks-per-user": {"type": "int"},
            "pba-timeout": {"type": "int"},
            "permit-any-host": {"choices": ["disable", "enable"], "type": "str"},
            "source-endip": {"type": "str"},
            "source-startip": {"type": "str"},
            "startip": {"type": "str"},
            "type": {"choices": ["overload", "one-to-one", "fixed-port-range", "port-block-allocation", "cgn-resource-allocation"], "type": "str"},
            "cgn-block-size": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "cgn-client-endip": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "str"},
            "cgn-client-startip": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "str"},
            "cgn-fixedalloc": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cgn-overload": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cgn-port-end": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "cgn-port-start": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "cgn-spa": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "utilization-alarm-clear": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "utilization-alarm-raise": {"v_range": [["6.2.6", "6.2.13"], ["6.4.2", ""]], "type": "int"},
            "endport": {"v_range": [["7.0.0", ""]], "type": "int"},
            "port-per-user": {"v_range": [["7.0.0", ""]], "type": "int"},
            "startport": {"v_range": [["7.0.0", ""]], "type": "int"},
            "add-nat64-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cgn-client-ipv6shift": {"v_range": [["6.2.9", "6.2.13"], ["6.4.7", "6.4.15"], ["7.0.2", ""]], "type": "int"},
            "nat64": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "subnet-broadcast-in-ippool": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "exclude-ip": {"v_range": [["7.2.2", ""]], "type": "raw"},
            "pba-interim-log": {"v_range": [["7.4.3", ""]], "type": "int"},
            "client-prefix-length": {"v_range": [["7.6.0", ""]], "type": "int"},
            "icmp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"},
            "privileged-port-use-pba": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "source-prefix6": {"v_range": [["7.6.0", ""]], "type": "str"},
            "tcp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"},
            "udp-session-quota": {"v_range": [["7.6.0", ""]], "type": "int"}
        }
    },
    "firewall_ippoolgrp": {
        "stated": true,
        "options": {
            "comments": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"},
            "member": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "raw"},
            "name": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "required": true, "type": "str"},
            "uuid": {"v_range": [["6.4.7", "6.4.15"], ["7.0.1", ""]], "type": "str"}
        }
    },
    "firewall_ldbmonitor": {
        "stated": true,
        "options": {
            "http-get": {"type": "str"},
            "http-match": {"type": "str"},
            "http-max-redirects": {"type": "int"},
            "interval": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "port": {"type": "int"},
            "retry": {"type": "int"},
            "timeout": {"type": "int"},
            "type": {"choices": ["ping", "tcp", "http", "passive-sip", "https", "dns"], "type": "str"},
            "src-ip": {"v_range": [["6.4.0", ""]], "type": "str"},
            "dns-match-ip": {"v_range": [["7.0.0", ""]], "type": "str"},
            "dns-protocol": {"v_range": [["7.0.0", ""]], "choices": ["udp", "tcp"], "type": "str"},
            "dns-request-domain": {"v_range": [["7.0.0", ""]], "type": "str"}
        }
    },
    "firewall_mmsprofile": {
        "stated": true,
        "options": {
            "avnotificationtable": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "bwordtable": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "carrier-endpoint-prefix": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "carrier-endpoint-prefix-range-max": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "carrier-endpoint-prefix-range-min": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "carrier-endpoint-prefix-string": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "carrierendpointbwltable": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "comment": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "mm1": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": [
                    "avmonitor", "block", "oversize", "quarantine", "scan", "avquery", "bannedword", "no-content-summary", "archive-summary",
                    "archive-full", "carrier-endpoint-bwl", "remove-blocked", "chunkedbypass", "clientcomfort", "servercomfort", "strict-file",
                    "mms-checksum"
                ],
                "elements": "str"
            },
            "mm1-addr-hdr": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "mm1-addr-source": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["http-header", "cookie"], "type": "str"},
            "mm1-convert-hex": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mm1-outbreak-prevention": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disabled", "files", "full-archive"], "type": "str"},
            "mm1-retr-dupe": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mm1-retrieve-scan": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mm1comfortamount": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mm1comfortinterval": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mm1oversizelimit": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mm3": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": [
                    "avmonitor", "block", "oversize", "quarantine", "scan", "avquery", "bannedword", "no-content-summary", "archive-summary",
                    "archive-full", "carrier-endpoint-bwl", "remove-blocked", "fragmail", "splice", "mms-checksum"
                ],
                "elements": "str"
            },
            "mm3-outbreak-prevention": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disabled", "files", "full-archive"], "type": "str"},
            "mm3oversizelimit": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mm4": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": [
                    "avmonitor", "block", "oversize", "quarantine", "scan", "avquery", "bannedword", "no-content-summary", "archive-summary",
                    "archive-full", "carrier-endpoint-bwl", "remove-blocked", "fragmail", "splice", "mms-checksum"
                ],
                "elements": "str"
            },
            "mm4-outbreak-prevention": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disabled", "files", "full-archive"], "type": "str"},
            "mm4oversizelimit": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mm7": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": [
                    "avmonitor", "block", "oversize", "quarantine", "scan", "avquery", "bannedword", "no-content-summary", "archive-summary",
                    "archive-full", "carrier-endpoint-bwl", "remove-blocked", "chunkedbypass", "clientcomfort", "servercomfort", "strict-file",
                    "mms-checksum"
                ],
                "elements": "str"
            },
            "mm7-addr-hdr": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "mm7-addr-source": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["http-header", "cookie"], "type": "str"},
            "mm7-convert-hex": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mm7-outbreak-prevention": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disabled", "files", "full-archive"], "type": "str"},
            "mm7comfortamount": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mm7comfortinterval": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mm7oversizelimit": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mms-antispam-mass-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-av-block-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-av-oversize-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-av-virus-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-carrier-endpoint-filter-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-checksum-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-checksum-table": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "mms-notification-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-web-content-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mmsbwordthreshold": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "name": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "str"},
            "notif-msisdn": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "options": {
                    "msisdn": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "threshold": {
                        "v_range": [["6.0.0", "7.6.2"]],
                        "type": "list",
                        "choices": ["flood-thresh-1", "flood-thresh-2", "flood-thresh-3", "dupe-thresh-1", "dupe-thresh-2", "dupe-thresh-3"],
                        "elements": "str"
                    }
                },
                "elements": "dict"
            },
            "remove-blocked-const-length": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "replacemsg-group": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "dupe": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                "type": "dict",
                "options": {
                    "action1": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                        "elements": "str"
                    },
                    "action2": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                        "elements": "str"
                    },
                    "action3": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                        "elements": "str"
                    },
                    "block-time1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "block-time2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "block-time3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "limit1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "limit2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "limit3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "protocol": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "status1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "status2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "status3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "window1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "window2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "window3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"}
                }
            },
            "flood": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                "type": "dict",
                "options": {
                    "action1": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                        "elements": "str"
                    },
                    "action2": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                        "elements": "str"
                    },
                    "action3": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                        "elements": "str"
                    },
                    "block-time1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "block-time2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "block-time3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "limit1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "limit2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "limit3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "protocol": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "status1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "status2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "status3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "window1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "window2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "window3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"}
                }
            },
            "notification": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                "type": "dict",
                "options": {
                    "alert-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "alert-int-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
                    "alert-src-msisdn": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "alert-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "bword-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "bword-int-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
                    "bword-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "carrier-endpoint-bwl-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "carrier-endpoint-bwl-int-mode": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "choices": ["hours", "minutes"],
                        "type": "str"
                    },
                    "carrier-endpoint-bwl-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "days-allowed": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "type": "list",
                        "choices": ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"],
                        "elements": "str"
                    },
                    "detect-server": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "dupe-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "dupe-int-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
                    "dupe-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "file-block-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "file-block-int-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
                    "file-block-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "flood-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "flood-int-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
                    "flood-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "from-in-header": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "mms-checksum-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "mms-checksum-int-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
                    "mms-checksum-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "mmsc-hostname": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "mmsc-password": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "no_log": true, "type": "raw"},
                    "mmsc-port": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "mmsc-url": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "mmsc-username": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "msg-protocol": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["mm1", "mm3", "mm4", "mm7"], "type": "str"},
                    "msg-type": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["submit-req", "deliver-req"], "type": "str"},
                    "protocol": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "rate-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "tod-window-duration": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "tod-window-end": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.0"]], "type": "str"},
                    "tod-window-start": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "user-domain": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "vas-id": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "vasp-id": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "str"},
                    "virus-int": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "type": "int"},
                    "virus-int-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
                    "virus-status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "outbreak-prevention": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                "type": "dict",
                "options": {
                    "external-blocklist": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
                    "ftgd-service": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                }
            }
        }
    },
    "firewall_mmsprofile_dupe": {
        "stated": false,
        "options": {
            "action1": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                "elements": "str"
            },
            "action2": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                "elements": "str"
            },
            "action3": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                "elements": "str"
            },
            "block-time1": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "block-time2": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "block-time3": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "limit1": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "limit2": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "limit3": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "protocol": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "status1": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "status2": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "status3": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "window1": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "window2": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "window3": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"}
        }
    },
    "firewall_mmsprofile_flood": {
        "stated": false,
        "options": {
            "action1": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                "elements": "str"
            },
            "action2": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                "elements": "str"
            },
            "action3": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["log", "archive", "intercept", "block", "archive-first", "alert-notif"],
                "elements": "str"
            },
            "block-time1": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "block-time2": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "block-time3": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "limit1": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "limit2": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "limit3": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "protocol": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "status1": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "status2": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "status3": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "window1": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "window2": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "window3": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"}
        }
    },
    "firewall_mmsprofile_notification": {
        "stated": false,
        "options": {
            "alert-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "alert-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "alert-src-msisdn": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "alert-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "bword-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "bword-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "bword-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "carrier-endpoint-bwl-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "carrier-endpoint-bwl-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "carrier-endpoint-bwl-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "days-allowed": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"],
                "elements": "str"
            },
            "detect-server": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "dupe-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "dupe-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "dupe-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "file-block-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "file-block-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "file-block-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "flood-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "flood-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "flood-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "from-in-header": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mms-checksum-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mms-checksum-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "mms-checksum-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "mmsc-hostname": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "mmsc-password": {"v_range": [["6.0.0", "7.6.2"]], "no_log": true, "type": "raw"},
            "mmsc-port": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "mmsc-url": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "mmsc-username": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "msg-protocol": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["mm1", "mm3", "mm4", "mm7"], "type": "str"},
            "msg-type": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["submit-req", "deliver-req"], "type": "str"},
            "protocol": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "rate-limit": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "tod-window-duration": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "tod-window-end": {"v_range": [["6.0.0", "7.2.0"]], "type": "str"},
            "tod-window-start": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "user-domain": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "vas-id": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "vasp-id": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "virus-int": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "virus-int-mode": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["hours", "minutes"], "type": "str"},
            "virus-status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_mmsprofile_notifmsisdn": {
        "stated": true,
        "options": {
            "msisdn": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "str"},
            "threshold": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "choices": ["flood-thresh-1", "flood-thresh-2", "flood-thresh-3", "dupe-thresh-1", "dupe-thresh-2", "dupe-thresh-3"],
                "elements": "str"
            }
        }
    },
    "firewall_mmsprofile_outbreakprevention": {
        "stated": false,
        "options": {
            "external-blocklist": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "ftgd-service": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_multicastaddress": {
        "stated": true,
        "options": {
            "associated-interface": {"type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "end-ip": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "start-ip": {"type": "str"},
            "subnet": {"type": "str"},
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "type": {"choices": ["multicastrange", "broadcastmask"], "type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"}
        }
    },
    "firewall_multicastaddress6": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "ip6": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"}
        }
    },
    "firewall_multicastaddress6_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_multicastaddress_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_networkservicedynamic": {
        "stated": true,
        "options": {
            "comment": {"v_range": [["7.2.2", ""]], "type": "str"},
            "filter": {"v_range": [["7.2.2", ""]], "type": "str"},
            "id": {"v_range": [["7.2.2", ""]], "required": true, "type": "int"},
            "name": {"v_range": [["7.2.2", ""]], "type": "str"},
            "sdn": {"v_range": [["7.2.2", ""]], "type": "str"}
        }
    },
    "firewall_profilegroup": {
        "stated": true,
        "options": {
            "application-list": {"type": "str"},
            "av-profile": {"type": "str"},
            "dlp-sensor": {"type": "str"},
            "dnsfilter-profile": {"type": "str"},
            "icap-profile": {"type": "str"},
            "ips-sensor": {"type": "str"},
            "mms-profile": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "name": {"required": true, "type": "str"},
            "profile-protocol-options": {"type": "str"},
            "spamfilter-profile": {"v_range": [["6.0.0", "7.2.1"]], "type": "str"},
            "ssh-filter-profile": {"type": "str"},
            "ssl-ssh-profile": {"type": "str"},
            "voip-profile": {"type": "str"},
            "waf-profile": {"type": "str"},
            "webfilter-profile": {"type": "str"},
            "cifs-profile": {"v_range": [["6.2.0", ""]], "type": "str"},
            "emailfilter-profile": {"v_range": [["6.2.0", ""]], "type": "str"},
            "casi-profile": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "file-filter-profile": {"v_range": [["6.4.1", ""]], "type": "str"},
            "videofilter-profile": {"v_range": [["7.0.0", ""]], "type": "str"},
            "dlp-profile": {"v_range": [["7.2.0", ""]], "type": "str"},
            "sctp-filter-profile": {"v_range": [["7.0.1", ""]], "type": "str"},
            "ips-voip-filter": {"v_range": [["7.2.3", ""]], "type": "str"},
            "casb-profile": {"v_range": [["7.4.1", ""]], "type": "str"},
            "virtual-patch-profile": {"v_range": [["7.4.1", ""]], "type": "str"},
            "diameter-filter-profile": {"v_range": [["7.4.2", ""]], "type": "str"},
            "telemetry-profile": {"v_range": [["7.6.3", ""]], "type": "raw"}
        }
    },
    "firewall_profileprotocoloptions": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "oversize-log": {"choices": ["disable", "enable"], "type": "str"},
            "replacemsg-group": {"type": "str"},
            "rpc-over-http": {"choices": ["disable", "enable"], "type": "str"},
            "switching-protocols-log": {"choices": ["disable", "enable"], "type": "str"},
            "feature-set": {"v_range": [["6.4.0", ""]], "choices": ["proxy", "flow"], "type": "str"},
            "cifs": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "domain-controller": {"v_range": [["6.4.5", ""]], "type": "str"},
                    "file-filter": {
                        "v_range": [["6.4.5", ""]],
                        "type": "dict",
                        "options": {
                            "entries": {
                                "v_range": [["6.4.5", ""]],
                                "type": "list",
                                "options": {
                                    "action": {"v_range": [["6.4.5", ""]], "choices": ["log", "block"], "type": "str"},
                                    "comment": {"v_range": [["6.4.5", ""]], "type": "str"},
                                    "direction": {"v_range": [["6.4.5", ""]], "choices": ["any", "incoming", "outgoing"], "type": "str"},
                                    "file-type": {"v_range": [["6.4.5", ""]], "type": "raw"},
                                    "filter": {"v_range": [["6.4.5", ""]], "type": "str"},
                                    "protocol": {"v_range": [["6.4.5", ""]], "type": "list", "choices": ["cifs"], "elements": "str"}
                                },
                                "elements": "dict"
                            },
                            "log": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "status": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                        }
                    },
                    "options": {"v_range": [["6.4.5", ""]], "type": "list", "choices": ["oversize"], "elements": "str"},
                    "oversize-limit": {"v_range": [["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "scan-bzip2": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "server-credential-type": {
                        "v_range": [["6.4.5", ""]],
                        "choices": ["none", "credential-replication", "credential-keytab"],
                        "type": "str"
                    },
                    "server-keytab": {
                        "v_range": [["6.4.5", ""]],
                        "no_log": true,
                        "type": "list",
                        "options": {
                            "keytab": {"v_range": [["6.4.5", ""]], "no_log": true, "type": "str"},
                            "password": {"v_range": [["6.4.5", ""]], "no_log": true, "type": "raw"},
                            "principal": {"v_range": [["6.4.5", ""]], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "tcp-window-maximum": {"v_range": [["6.4.5", ""]], "type": "int"},
                    "tcp-window-minimum": {"v_range": [["6.4.5", ""]], "type": "int"},
                    "tcp-window-size": {"v_range": [["6.4.5", ""]], "type": "int"},
                    "tcp-window-type": {"v_range": [["6.4.5", ""]], "choices": ["system", "static", "dynamic", "auto-tuning"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.4.5", ""]], "type": "int"}
                }
            },
            "dns": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "ftp": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "comfort-amount": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "comfort-interval": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "inspect-all": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["clientcomfort", "no-content-summary", "oversize", "splice", "bypass-rest-command", "bypass-mode-command"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-offloaded": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["no", "yes"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "stream-based-uncompressed-limit": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-maximum": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-minimum": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-size": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-type": {"v_range": [["7.0.0", ""]], "choices": ["system", "static", "dynamic", "auto-tuning"], "type": "str"},
                    "explicit-ftp-tls": {"v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "http": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "block-page-status-code": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "comfort-amount": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "comfort-interval": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "fortinet-bar": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "fortinet-bar-port": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "inspect-all": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["oversize", "chunkedbypass", "clientcomfort", "no-content-summary", "servercomfort"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "post-lang": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": [
                            "jisx0201", "jisx0208", "jisx0212", "gb2312", "ksc5601-ex", "euc-jp", "sjis", "iso2022-jp", "iso2022-jp-1", "iso2022-jp-2",
                            "euc-cn", "ces-gbk", "hz", "ces-big5", "euc-kr", "iso2022-jp-3", "iso8859-1", "tis620", "cp874", "cp1252", "cp1251"
                        ],
                        "elements": "str"
                    },
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "range-block": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "retry-count": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-offloaded": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["no", "yes"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "stream-based-uncompressed-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "streaming-content-bypass": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "strip-x-forwarded-for": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "switching-protocols": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["bypass", "block"], "type": "str"},
                    "tcp-window-maximum": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "tcp-window-minimum": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "tcp-window-size": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "tcp-window-type": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["system", "static", "dynamic", "auto-tuning"],
                        "type": "str"
                    },
                    "tunnel-non-http": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "unknown-http-version": {"v_range": [["6.4.5", ""]], "choices": ["best-effort", "reject", "tunnel"], "type": "str"},
                    "http-policy": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "address-ip-rating": {"v_range": [["7.0.4", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h2c": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "verify-dns-for-policy-matching": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "unknown-content-encoding": {"v_range": [["7.2.2", ""]], "choices": ["block", "inspect", "bypass"], "type": "str"},
                    "domain-fronting": {"v_range": [["7.6.0", ""]], "choices": ["block", "monitor", "allow"], "type": "str"},
                    "http-0.9": {"v_range": [["7.6.2", ""]], "choices": ["block", "allow"], "type": "str"}
                }
            },
            "imap": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "inspect-all": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["oversize", "fragmail", "no-content-summary"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-offloaded": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["no", "yes"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "mail-signature": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "signature": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "mapi": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["fragmail", "oversize", "no-content-summary"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "nntp": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "inspect-all": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["oversize", "no-content-summary", "splice"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "pop3": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "inspect-all": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["oversize", "fragmail", "no-content-summary"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-offloaded": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["no", "yes"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "smtp": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "inspect-all": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["oversize", "fragmail", "no-content-summary", "splice"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "server-busy": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-offloaded": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["no", "yes"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"}
                }
            },
            "ssh": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "comfort-amount": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "comfort-interval": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "options": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "list",
                        "choices": ["oversize", "clientcomfort", "servercomfort"],
                        "elements": "str"
                    },
                    "oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "scan-bzip2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "uncompressed-nest-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "uncompressed-oversize-limit": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                    "ssl-offloaded": {"v_range": [["7.0.0", ""]], "choices": ["no", "yes"], "type": "str"},
                    "stream-based-uncompressed-limit": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-maximum": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-minimum": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-size": {"v_range": [["7.0.0", ""]], "type": "int"},
                    "tcp-window-type": {"v_range": [["7.0.0", ""]], "choices": ["system", "static", "dynamic", "auto-tuning"], "type": "str"}
                }
            }
        }
    },
    "firewall_profileprotocoloptions_cifs": {
        "stated": false,
        "options": {
            "ports": {"v_range": [["6.2.0", ""]], "type": "raw"},
            "status": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "options": {"v_range": [["6.4.0", ""]], "type": "list", "choices": ["oversize"], "elements": "str"},
            "oversize-limit": {"v_range": [["6.4.0", ""]], "type": "int"},
            "scan-bzip2": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tcp-window-maximum": {"v_range": [["6.4.0", ""]], "type": "int"},
            "tcp-window-minimum": {"v_range": [["6.4.0", ""]], "type": "int"},
            "tcp-window-size": {"v_range": [["6.4.0", ""]], "type": "int"},
            "tcp-window-type": {"v_range": [["6.4.0", ""]], "choices": ["system", "static", "dynamic", "auto-tuning"], "type": "str"},
            "uncompressed-nest-limit": {"v_range": [["6.4.0", ""]], "type": "int"},
            "uncompressed-oversize-limit": {"v_range": [["6.4.0", ""]], "type": "int"},
            "domain-controller": {"v_range": [["6.4.2", ""]], "type": "str"},
            "file-filter": {
                "v_range": [["6.4.2", ""]],
                "type": "dict",
                "options": {
                    "entries": {
                        "v_range": [["6.4.2", ""]],
                        "type": "list",
                        "options": {
                            "action": {"v_range": [["6.4.2", ""]], "choices": ["log", "block"], "type": "str"},
                            "comment": {"v_range": [["6.4.2", ""]], "type": "str"},
                            "direction": {"v_range": [["6.4.2", ""]], "choices": ["any", "incoming", "outgoing"], "type": "str"},
                            "file-type": {"v_range": [["6.4.2", ""]], "type": "raw"},
                            "filter": {"v_range": [["6.4.2", ""]], "type": "str"},
                            "protocol": {"v_range": [["6.4.2", ""]], "type": "list", "choices": ["cifs"], "elements": "str"}
                        },
                        "elements": "dict"
                    },
                    "log": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "server-credential-type": {"v_range": [["6.4.2", ""]], "choices": ["none", "credential-replication", "credential-keytab"], "type": "str"},
            "server-keytab": {
                "v_range": [["6.4.2", ""]],
                "no_log": true,
                "type": "list",
                "options": {
                    "keytab": {"v_range": [["6.4.2", ""]], "no_log": true, "type": "str"},
                    "password": {"v_range": [["6.4.2", ""]], "no_log": true, "type": "raw"},
                    "principal": {"v_range": [["6.4.2", ""]], "type": "str"}
                },
                "elements": "dict"
            }
        }
    },
    "firewall_profileprotocoloptions_cifs_filefilter": {
        "stated": false,
        "options": {
            "entries": {
                "v_range": [["6.4.2", ""]],
                "type": "list",
                "options": {
                    "action": {"v_range": [["6.4.2", ""]], "choices": ["log", "block"], "type": "str"},
                    "comment": {"v_range": [["6.4.2", ""]], "type": "str"},
                    "direction": {"v_range": [["6.4.2", ""]], "choices": ["any", "incoming", "outgoing"], "type": "str"},
                    "file-type": {"v_range": [["6.4.2", ""]], "type": "raw"},
                    "filter": {"v_range": [["6.4.2", ""]], "type": "str"},
                    "protocol": {"v_range": [["6.4.2", ""]], "type": "list", "choices": ["cifs"], "elements": "str"}
                },
                "elements": "dict"
            },
            "log": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "status": {"v_range": [["6.4.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_cifs_filefilter_entries": {
        "stated": true,
        "options": {
            "action": {"v_range": [["6.4.2", ""]], "choices": ["log", "block"], "type": "str"},
            "comment": {"v_range": [["6.4.2", ""]], "type": "str"},
            "direction": {"v_range": [["6.4.2", ""]], "choices": ["any", "incoming", "outgoing"], "type": "str"},
            "file-type": {"v_range": [["6.4.2", ""]], "type": "raw"},
            "filter": {"v_range": [["6.4.2", ""]], "type": "str"},
            "protocol": {"v_range": [["6.4.2", ""]], "type": "list", "choices": ["cifs"], "elements": "str"}
        }
    },
    "firewall_profileprotocoloptions_cifs_serverkeytab": {
        "stated": true,
        "options": {
            "keytab": {"v_range": [["6.4.2", ""]], "no_log": true, "type": "str"},
            "password": {"v_range": [["6.4.2", ""]], "no_log": true, "type": "raw"},
            "principal": {"v_range": [["6.4.2", ""]], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_dns": {
        "stated": false,
        "options": {"ports": {"type": "raw"}, "status": {"choices": ["disable", "enable"], "type": "str"}}
    },
    "firewall_profileprotocoloptions_ftp": {
        "stated": false,
        "options": {
            "comfort-amount": {"type": "int"},
            "comfort-interval": {"type": "int"},
            "inspect-all": {"choices": ["disable", "enable"], "type": "str"},
            "options": {
                "type": "list",
                "choices": ["clientcomfort", "no-content-summary", "oversize", "splice", "bypass-rest-command", "bypass-mode-command"],
                "elements": "str"
            },
            "oversize-limit": {"type": "int"},
            "ports": {"type": "raw"},
            "scan-bzip2": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "uncompressed-nest-limit": {"type": "int"},
            "uncompressed-oversize-limit": {"type": "int"},
            "ssl-offloaded": {"v_range": [["6.2.2", ""]], "choices": ["no", "yes"], "type": "str"},
            "stream-based-uncompressed-limit": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-maximum": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-minimum": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-size": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-type": {"v_range": [["7.0.0", ""]], "choices": ["system", "static", "dynamic", "auto-tuning"], "type": "str"},
            "explicit-ftp-tls": {"v_range": [["7.0.5", "7.0.14"], ["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_http": {
        "stated": false,
        "options": {
            "block-page-status-code": {"type": "int"},
            "comfort-amount": {"type": "int"},
            "comfort-interval": {"type": "int"},
            "fortinet-bar": {"choices": ["disable", "enable"], "type": "str"},
            "fortinet-bar-port": {"type": "int"},
            "http-policy": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "inspect-all": {"choices": ["disable", "enable"], "type": "str"},
            "options": {
                "type": "list",
                "choices": ["oversize", "chunkedbypass", "clientcomfort", "no-content-summary", "servercomfort"],
                "elements": "str"
            },
            "oversize-limit": {"type": "int"},
            "ports": {"type": "raw"},
            "post-lang": {
                "type": "list",
                "choices": [
                    "jisx0201", "jisx0208", "jisx0212", "gb2312", "ksc5601-ex", "euc-jp", "sjis", "iso2022-jp", "iso2022-jp-1", "iso2022-jp-2", "euc-cn",
                    "ces-gbk", "hz", "ces-big5", "euc-kr", "iso2022-jp-3", "iso8859-1", "tis620", "cp874", "cp1252", "cp1251"
                ],
                "elements": "str"
            },
            "range-block": {"choices": ["disable", "enable"], "type": "str"},
            "retry-count": {"type": "int"},
            "scan-bzip2": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "streaming-content-bypass": {"choices": ["disable", "enable"], "type": "str"},
            "strip-x-forwarded-for": {"choices": ["disable", "enable"], "type": "str"},
            "switching-protocols": {"choices": ["bypass", "block"], "type": "str"},
            "uncompressed-nest-limit": {"type": "int"},
            "uncompressed-oversize-limit": {"type": "int"},
            "tcp-window-maximum": {"v_range": [["6.2.0", ""]], "type": "int"},
            "tcp-window-minimum": {"v_range": [["6.2.0", ""]], "type": "int"},
            "tcp-window-size": {"v_range": [["6.2.0", ""]], "type": "int"},
            "tcp-window-type": {"v_range": [["6.2.0", ""]], "choices": ["system", "static", "dynamic", "auto-tuning"], "type": "str"},
            "ssl-offloaded": {"v_range": [["6.2.2", ""]], "choices": ["no", "yes"], "type": "str"},
            "stream-based-uncompressed-limit": {"v_range": [["6.2.2", ""]], "type": "int"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tunnel-non-http": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "unknown-http-version": {"v_range": [["6.4.0", ""]], "choices": ["best-effort", "reject", "tunnel"], "type": "str"},
            "address-ip-rating": {"v_range": [["7.0.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2c": {"v_range": [["7.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "verify-dns-for-policy-matching": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "unknown-content-encoding": {"v_range": [["7.2.2", ""]], "choices": ["block", "inspect", "bypass"], "type": "str"},
            "domain-fronting": {"v_range": [["7.6.0", ""]], "choices": ["block", "monitor", "allow"], "type": "str"},
            "http-0.9": {"v_range": [["7.6.2", ""]], "choices": ["block", "allow"], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_imap": {
        "stated": false,
        "options": {
            "inspect-all": {"choices": ["disable", "enable"], "type": "str"},
            "options": {"type": "list", "choices": ["oversize", "fragmail", "no-content-summary"], "elements": "str"},
            "oversize-limit": {"type": "int"},
            "ports": {"type": "raw"},
            "scan-bzip2": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "uncompressed-nest-limit": {"type": "int"},
            "uncompressed-oversize-limit": {"type": "int"},
            "ssl-offloaded": {"v_range": [["6.2.2", ""]], "choices": ["no", "yes"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_mailsignature": {
        "stated": false,
        "options": {"signature": {"type": "str"}, "status": {"choices": ["disable", "enable"], "type": "str"}}
    },
    "firewall_profileprotocoloptions_mapi": {
        "stated": false,
        "options": {
            "options": {"type": "list", "choices": ["fragmail", "oversize", "no-content-summary"], "elements": "str"},
            "oversize-limit": {"type": "int"},
            "ports": {"type": "raw"},
            "scan-bzip2": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "uncompressed-nest-limit": {"type": "int"},
            "uncompressed-oversize-limit": {"type": "int"}
        }
    },
    "firewall_profileprotocoloptions_nntp": {
        "stated": false,
        "options": {
            "inspect-all": {"choices": ["disable", "enable"], "type": "str"},
            "options": {"type": "list", "choices": ["oversize", "no-content-summary", "splice"], "elements": "str"},
            "oversize-limit": {"type": "int"},
            "ports": {"type": "raw"},
            "scan-bzip2": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "uncompressed-nest-limit": {"type": "int"},
            "uncompressed-oversize-limit": {"type": "int"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_pop3": {
        "stated": false,
        "options": {
            "inspect-all": {"choices": ["disable", "enable"], "type": "str"},
            "options": {"type": "list", "choices": ["oversize", "fragmail", "no-content-summary"], "elements": "str"},
            "oversize-limit": {"type": "int"},
            "ports": {"type": "raw"},
            "scan-bzip2": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "uncompressed-nest-limit": {"type": "int"},
            "uncompressed-oversize-limit": {"type": "int"},
            "ssl-offloaded": {"v_range": [["6.2.2", ""]], "choices": ["no", "yes"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_smtp": {
        "stated": false,
        "options": {
            "inspect-all": {"choices": ["disable", "enable"], "type": "str"},
            "options": {"type": "list", "choices": ["oversize", "fragmail", "no-content-summary", "splice"], "elements": "str"},
            "oversize-limit": {"type": "int"},
            "ports": {"type": "raw"},
            "scan-bzip2": {"choices": ["disable", "enable"], "type": "str"},
            "server-busy": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "uncompressed-nest-limit": {"type": "int"},
            "uncompressed-oversize-limit": {"type": "int"},
            "ssl-offloaded": {"v_range": [["6.2.2", ""]], "choices": ["no", "yes"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_profileprotocoloptions_ssh": {
        "stated": false,
        "options": {
            "comfort-amount": {"v_range": [["6.2.2", ""]], "type": "int"},
            "comfort-interval": {"v_range": [["6.2.2", ""]], "type": "int"},
            "options": {"v_range": [["6.2.2", ""]], "type": "list", "choices": ["oversize", "clientcomfort", "servercomfort"], "elements": "str"},
            "oversize-limit": {"v_range": [["6.2.2", ""]], "type": "int"},
            "scan-bzip2": {"v_range": [["6.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "uncompressed-nest-limit": {"v_range": [["6.2.2", ""]], "type": "int"},
            "uncompressed-oversize-limit": {"v_range": [["6.2.2", ""]], "type": "int"},
            "ssl-offloaded": {"v_range": [["7.0.0", ""]], "choices": ["no", "yes"], "type": "str"},
            "stream-based-uncompressed-limit": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-maximum": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-minimum": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-size": {"v_range": [["7.0.0", ""]], "type": "int"},
            "tcp-window-type": {"v_range": [["7.0.0", ""]], "choices": ["system", "static", "dynamic", "auto-tuning"], "type": "str"}
        }
    },
    "firewall_proxyaddress": {
        "stated": true,
        "options": {
            "case-sensitivity": {"choices": ["disable", "enable"], "type": "str"},
            "category": {"type": "raw"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "header": {"type": "str"},
            "header-group": {
                "type": "list",
                "options": {
                    "case-sensitivity": {"choices": ["disable", "enable"], "type": "str"},
                    "header": {"type": "str"},
                    "header-name": {"type": "str"},
                    "id": {"type": "int"}
                },
                "elements": "dict"
            },
            "header-name": {"type": "str"},
            "host": {"type": "str"},
            "host-regex": {"type": "str"},
            "method": {
                "type": "list",
                "choices": ["delete", "get", "head", "options", "post", "put", "trace", "connect", "other", "patch", "update"],
                "elements": "str"
            },
            "name": {"required": true, "type": "str"},
            "path": {"type": "str"},
            "query": {"type": "str"},
            "referrer": {"choices": ["disable", "enable"], "type": "str"},
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "type": {
                "choices": ["host-regex", "url", "category", "method", "ua", "header", "src-advanced", "dst-advanced", "url-list", "saas"],
                "type": "str"
            },
            "ua": {"type": "list", "choices": ["chrome", "ms", "firefox", "safari", "other", "ie", "edge"], "elements": "str"},
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"},
            "application": {"v_range": [["7.2.1", ""]], "type": "raw"},
            "ua-max-ver": {"v_range": [["7.2.2", ""]], "type": "str"},
            "ua-min-ver": {"v_range": [["7.2.2", ""]], "type": "str"}
        }
    },
    "firewall_proxyaddress_headergroup": {
        "stated": true,
        "options": {
            "case-sensitivity": {"choices": ["disable", "enable"], "type": "str"},
            "header": {"type": "str"},
            "header-name": {"type": "str"},
            "id": {"required": true, "type": "int"}
        }
    },
    "firewall_proxyaddress_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_proxyaddrgrp": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "tagging": {"type": "list", "options": {"category": {"type": "str"}, "name": {"type": "str"}, "tags": {"type": "raw"}}, "elements": "dict"},
            "type": {"choices": ["src", "dst"], "type": "str"},
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "tags": {"v_range": [["6.2.0", "6.4.15"]], "type": "str"},
            "_image-base64": {"v_range": [["6.2.2", ""]], "type": "str"}
        }
    },
    "firewall_proxyaddrgrp_tagging": {
        "stated": true,
        "options": {"category": {"type": "str"}, "name": {"required": true, "type": "str"}, "tags": {"type": "raw"}}
    },
    "firewall_schedule_group": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "uuid": {"v_range": [["7.6.0", ""]], "type": "str"}
        }
    },
    "firewall_schedule_onetime": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "end": {"type": "str"},
            "expiration-days": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "start": {"type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "end-utc": {"v_range": [["7.2.2", ""]], "type": "str"},
            "start-utc": {"v_range": [["7.2.2", ""]], "type": "str"},
            "uuid": {"v_range": [["7.6.0", ""]], "type": "str"}
        }
    },
    "firewall_schedule_recurring": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "day": {"type": "list", "choices": ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "none"], "elements": "str"},
            "end": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "start": {"type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "uuid": {"v_range": [["7.6.0", ""]], "type": "str"}
        }
    },
    "firewall_service_category": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "uuid": {"v_range": [["7.6.0", ""]], "type": "str"}
        }
    },
    "firewall_service_custom": {
        "stated": true,
        "options": {
            "app-category": {"type": "raw"},
            "app-service-type": {"choices": ["disable", "app-id", "app-category"], "type": "str"},
            "application": {"type": "raw"},
            "category": {"type": "str"},
            "check-reset-range": {"choices": ["disable", "default", "strict"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "raw"},
            "fqdn": {"type": "str"},
            "helper": {
                "choices": [
                    "disable", "auto", "ftp", "tftp", "ras", "h323", "tns", "mms", "sip", "pptp", "rtsp", "dns-udp", "dns-tcp", "pmap", "rsh", "dcerpc",
                    "mgcp", "gtp-c", "gtp-u", "gtp-b", "pfcp"
                ],
                "type": "str"
            },
            "icmpcode": {"type": "int"},
            "icmptype": {"type": "int"},
            "iprange": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "protocol": {
                "choices": [
                    "ICMP", "IP", "TCP/UDP/SCTP", "ICMP6", "HTTP", "FTP", "CONNECT", "SOCKS", "ALL", "SOCKS-TCP", "SOCKS-UDP", "TCP/UDP/UDP-Lite/SCTP"
                ],
                "type": "str"
            },
            "protocol-number": {"type": "int"},
            "proxy": {"choices": ["disable", "enable"], "type": "str"},
            "sctp-portrange": {"type": "str"},
            "session-ttl": {"type": "raw"},
            "tcp-halfclose-timer": {"type": "int"},
            "tcp-halfopen-timer": {"type": "int"},
            "tcp-portrange": {"type": "str"},
            "tcp-timewait-timer": {"type": "int"},
            "udp-idle-timer": {"type": "int"},
            "udp-portrange": {"type": "str"},
            "visibility": {"choices": ["disable", "enable"], "type": "str"},
            "explicit-proxy": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "tcp-rst-timer": {"v_range": [["7.0.0", ""]], "type": "int"},
            "uuid": {"v_range": [["7.4.2", ""]], "type": "str"},
            "udplite-portrange": {"v_range": [["7.6.0", ""]], "type": "str"}
        }
    },
    "firewall_service_group": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comment": {"type": "raw"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "proxy": {"choices": ["disable", "enable"], "type": "str"},
            "explicit-proxy": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "global-object": {"v_range": [["6.4.0", ""]], "type": "int"},
            "fabric-object": {"v_range": [["6.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "uuid": {"v_range": [["7.4.2", ""]], "type": "str"}
        }
    },
    "firewall_shaper_peripshaper": {
        "stated": true,
        "options": {
            "bandwidth-unit": {"choices": ["kbps", "mbps", "gbps"], "type": "str"},
            "diffserv-forward": {"choices": ["disable", "enable"], "type": "str"},
            "diffserv-reverse": {"choices": ["disable", "enable"], "type": "str"},
            "diffservcode-forward": {"type": "str"},
            "diffservcode-rev": {"type": "str"},
            "max-bandwidth": {"type": "int"},
            "max-concurrent-session": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "max-concurrent-tcp-session": {"v_range": [["7.0.0", ""]], "type": "int"},
            "max-concurrent-udp-session": {"v_range": [["7.0.0", ""]], "type": "int"}
        }
    },
    "firewall_shaper_trafficshaper": {
        "stated": true,
        "options": {
            "bandwidth-unit": {"choices": ["kbps", "mbps", "gbps"], "type": "str"},
            "diffserv": {"choices": ["disable", "enable"], "type": "str"},
            "diffservcode": {"type": "str"},
            "guaranteed-bandwidth": {"type": "int"},
            "maximum-bandwidth": {"type": "int"},
            "name": {"required": true, "type": "str"},
            "per-policy": {"choices": ["disable", "enable"], "type": "str"},
            "priority": {"choices": ["high", "medium", "low"], "type": "str"},
            "dscp-marking-method": {"v_range": [["6.2.1", ""]], "choices": ["multi-stage", "static"], "type": "str"},
            "exceed-bandwidth": {"v_range": [["6.2.1", ""]], "type": "int"},
            "exceed-class-id": {"v_range": [["6.2.1", ""]], "type": "int"},
            "exceed-dscp": {"v_range": [["6.2.1", ""]], "type": "str"},
            "maximum-dscp": {"v_range": [["6.2.1", ""]], "type": "str"},
            "overhead": {"v_range": [["6.2.1", ""]], "type": "int"},
            "cos": {"v_range": [["7.4.0", ""]], "type": "str"},
            "cos-marking": {"v_range": [["7.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "cos-marking-method": {"v_range": [["7.4.0", ""]], "choices": ["multi-stage", "static"], "type": "str"},
            "exceed-cos": {"v_range": [["7.4.0", ""]], "type": "str"},
            "maximum-cos": {"v_range": [["7.4.0", ""]], "type": "str"}
        }
    },
    "firewall_shapingprofile": {
        "stated": true,
        "options": {
            "comment": {"type": "str"},
            "default-class-id": {"type": "raw"},
            "profile-name": {"required": true, "type": "str"},
            "shaping-entries": {
                "type": "list",
                "options": {
                    "class-id": {"type": "raw"},
                    "guaranteed-bandwidth-percentage": {"type": "int"},
                    "id": {"type": "int"},
                    "maximum-bandwidth-percentage": {"type": "int"},
                    "priority": {"choices": ["low", "medium", "high", "critical", "top"], "type": "str"},
                    "burst-in-msec": {"v_range": [["6.2.1", ""]], "type": "int"},
                    "cburst-in-msec": {"v_range": [["6.2.1", ""]], "type": "int"},
                    "limit": {"v_range": [["6.2.1", ""]], "type": "int"},
                    "max": {"v_range": [["6.2.1", ""]], "type": "int"},
                    "min": {"v_range": [["6.2.1", ""]], "type": "int"},
                    "red-probability": {"v_range": [["6.2.1", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "type": {"v_range": [["6.2.1", ""]], "choices": ["policing", "queuing"], "type": "str"},
            "npu-offloading": {"v_range": [["7.2.6", "7.2.11"], ["7.4.4", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_shapingprofile_shapingentries": {
        "stated": true,
        "options": {
            "class-id": {"type": "raw"},
            "guaranteed-bandwidth-percentage": {"type": "int"},
            "id": {"required": true, "type": "int"},
            "maximum-bandwidth-percentage": {"type": "int"},
            "priority": {"choices": ["low", "medium", "high", "critical", "top"], "type": "str"},
            "burst-in-msec": {"v_range": [["6.2.1", ""]], "type": "int"},
            "cburst-in-msec": {"v_range": [["6.2.1", ""]], "type": "int"},
            "limit": {"v_range": [["6.2.1", ""]], "type": "int"},
            "max": {"v_range": [["6.2.1", ""]], "type": "int"},
            "min": {"v_range": [["6.2.1", ""]], "type": "int"},
            "red-probability": {"v_range": [["6.2.1", ""]], "type": "int"}
        }
    },
    "firewall_ssh_localca": {
        "stated": true,
        "options": {
            "name": {"v_range": [["6.2.1", ""]], "required": true, "type": "str"},
            "password": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "raw"},
            "private-key": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "str"},
            "public-key": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "str"},
            "source": {"v_range": [["6.2.1", ""]], "choices": ["built-in", "user"], "type": "str"}
        }
    },
    "firewall_sslsshprofile": {
        "stated": true,
        "options": {
            "caname": {"type": "str"},
            "comment": {"type": "str"},
            "mapi-over-https": {"choices": ["disable", "enable"], "type": "str"},
            "name": {"required": true, "type": "str"},
            "rpc-over-https": {"choices": ["disable", "enable"], "type": "str"},
            "server-cert": {"type": "raw"},
            "server-cert-mode": {"choices": ["re-sign", "replace"], "type": "str"},
            "ssl-anomalies-log": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-exempt": {
                "type": "list",
                "options": {
                    "address": {"type": "str"},
                    "address6": {"type": "str"},
                    "fortiguard-category": {"type": "str"},
                    "id": {"type": "int"},
                    "regex": {"type": "str"},
                    "type": {"choices": ["fortiguard-category", "address", "address6", "wildcard-fqdn", "regex", "finger-print"], "type": "str"},
                    "wildcard-fqdn": {"type": "str"}
                },
                "elements": "dict"
            },
            "ssl-exemptions-log": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-server": {
                "type": "list",
                "options": {
                    "ftps-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "https-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "id": {"type": "int"},
                    "imaps-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "ip": {"type": "str"},
                    "pop3s-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "smtps-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "ssl-other-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "ftps-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "https-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "imaps-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "pop3s-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "smtps-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "ssl-other-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"}
                },
                "elements": "dict"
            },
            "untrusted-caname": {"type": "str"},
            "use-ssl-server": {"choices": ["disable", "enable"], "type": "str"},
            "whitelist": {"choices": ["disable", "enable"], "type": "str"},
            "block-blacklisted-certificates": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "certname": {"v_range": [["6.2.0", "6.2.13"]], "type": "str"},
            "ssl-invalid-server-cert-log": {"v_range": [["6.2.0", "6.2.13"]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-negotiation-log": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ftps": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "cert-validation-failure": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-validation-timeout": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "client-certificate": {"v_range": [["6.4.5", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "expired-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "revoked-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "sni-server-cert-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
                    "unsupported-ssl-cipher": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "unsupported-ssl-negotiation": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "untrusted-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "client-cert-request": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "choices": ["bypass", "inspect", "block"],
                        "type": "str"
                    },
                    "invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
                    "allow-invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "untrusted-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "min-allowed-ssl-version": {
                        "v_range": [["7.0.3", ""]],
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "type": "str"
                    },
                    "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"}
                }
            },
            "https": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "cert-validation-failure": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-validation-timeout": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "client-certificate": {"v_range": [["6.4.5", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "expired-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "revoked-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "sni-server-cert-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
                    "status": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disable", "certificate-inspection", "deep-inspection"],
                        "type": "str"
                    },
                    "unsupported-ssl-cipher": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "unsupported-ssl-negotiation": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "untrusted-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "client-cert-request": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "choices": ["bypass", "inspect", "block"],
                        "type": "str"
                    },
                    "invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
                    "allow-invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "untrusted-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-probe-failure": {"v_range": [["7.0.0", ""]], "choices": ["block", "allow"], "type": "str"},
                    "min-allowed-ssl-version": {
                        "v_range": [["7.0.3", ""]],
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "type": "str"
                    },
                    "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
                    "quic": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable", "bypass", "block", "inspect"], "type": "str"},
                    "encrypted-client-hello": {"v_range": [["7.4.3", ""]], "choices": ["block", "allow"], "type": "str"},
                    "udp-not-quic": {"v_range": [["7.6.2", ""]], "choices": ["block", "allow"], "type": "str"}
                }
            },
            "imaps": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "cert-validation-failure": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-validation-timeout": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "client-certificate": {"v_range": [["6.4.5", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "expired-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "revoked-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "sni-server-cert-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
                    "unsupported-ssl-cipher": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "unsupported-ssl-negotiation": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "untrusted-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "client-cert-request": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "choices": ["bypass", "inspect", "block"],
                        "type": "str"
                    },
                    "invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
                    "allow-invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "untrusted-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
                    "min-allowed-ssl-version": {
                        "v_range": [["7.0.3", ""]],
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "type": "str"
                    }
                }
            },
            "pop3s": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "cert-validation-failure": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-validation-timeout": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "client-certificate": {"v_range": [["6.4.5", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "expired-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "revoked-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "sni-server-cert-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
                    "unsupported-ssl-cipher": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "unsupported-ssl-negotiation": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "untrusted-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "client-cert-request": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "choices": ["bypass", "inspect", "block"],
                        "type": "str"
                    },
                    "invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
                    "allow-invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "untrusted-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
                    "min-allowed-ssl-version": {
                        "v_range": [["7.0.3", ""]],
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "type": "str"
                    }
                }
            },
            "smtps": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "cert-validation-failure": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-validation-timeout": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "client-certificate": {"v_range": [["6.4.5", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "expired-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "revoked-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "sni-server-cert-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
                    "unsupported-ssl-cipher": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "unsupported-ssl-negotiation": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "untrusted-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "client-cert-request": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "choices": ["bypass", "inspect", "block"],
                        "type": "str"
                    },
                    "invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
                    "allow-invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "untrusted-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
                    "min-allowed-ssl-version": {
                        "v_range": [["7.0.3", ""]],
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "type": "str"
                    }
                }
            },
            "ssh": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "inspect-all": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
                    "ports": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                    "proxy-after-tcp-handshake": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssh-algorithm": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["compatible", "high-encryption"], "type": "str"},
                    "ssh-tun-policy-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "status": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
                    "unsupported-version": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["block", "bypass"], "type": "str"},
                    "ssh-policy-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "block": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "6.4.15"]],
                        "type": "list",
                        "choices": ["x11-filter", "ssh-shell", "exec", "port-forward"],
                        "elements": "str"
                    },
                    "log": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "6.4.15"]],
                        "type": "list",
                        "choices": ["x11-filter", "ssh-shell", "exec", "port-forward"],
                        "elements": "str"
                    }
                }
            },
            "ssl": {
                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                "type": "dict",
                "options": {
                    "cert-validation-failure": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-validation-timeout": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "client-certificate": {"v_range": [["6.4.5", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "expired-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "inspect-all": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "choices": ["disable", "certificate-inspection", "deep-inspection"],
                        "type": "str"
                    },
                    "revoked-server-cert": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "sni-server-cert-check": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
                    "unsupported-ssl-cipher": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "unsupported-ssl-negotiation": {"v_range": [["6.4.5", ""]], "choices": ["allow", "block"], "type": "str"},
                    "untrusted-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "client-cert-request": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]],
                        "choices": ["bypass", "inspect", "block"],
                        "type": "str"
                    },
                    "invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
                    "allow-invalid-server-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
                    "untrusted-cert": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-probe-failure": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow"], "type": "str"},
                    "min-allowed-ssl-version": {
                        "v_range": [["7.0.3", ""]],
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "type": "str"
                    },
                    "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
                    "encrypted-client-hello": {"v_range": [["7.4.3", ""]], "choices": ["block", "allow"], "type": "str"}
                }
            },
            "allowlist": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "block-blocklisted-certificates": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "dot": {
                "v_range": [["7.0.0", ""]],
                "type": "dict",
                "options": {
                    "cert-validation-failure": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "cert-validation-timeout": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "client-certificate": {"v_range": [["7.0.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
                    "expired-server-cert": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "proxy-after-tcp-handshake": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "revoked-server-cert": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "sni-server-cert-check": {"v_range": [["7.0.0", ""]], "choices": ["enable", "strict", "disable"], "type": "str"},
                    "status": {"v_range": [["7.0.0", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
                    "unsupported-ssl-cipher": {"v_range": [["7.0.0", ""]], "choices": ["block", "allow"], "type": "str"},
                    "unsupported-ssl-negotiation": {"v_range": [["7.0.0", ""]], "choices": ["block", "allow"], "type": "str"},
                    "untrusted-server-cert": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
                    "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
                    "min-allowed-ssl-version": {
                        "v_range": [["7.0.3", ""]],
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "type": "str"
                    },
                    "quic": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable", "bypass", "block", "inspect"], "type": "str"},
                    "udp-not-quic": {"v_range": [["7.6.2", ""]], "choices": ["block", "allow"], "type": "str"}
                }
            },
            "supported-alpn": {"v_range": [["7.0.0", ""]], "choices": ["none", "http1-1", "http2", "all"], "type": "str"},
            "ssl-anomaly-log": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-exemption-ip-rating": {"v_range": [["7.0.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-exemption-log": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-handshake-log": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-server-cert-log": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ech-outer-sni": {
                "v_range": [["7.4.3", ""]],
                "type": "list",
                "options": {"name": {"v_range": [["7.4.3", ""]], "type": "str"}, "sni": {"v_range": [["7.4.3", ""]], "type": "str"}},
                "elements": "dict"
            }
        }
    },
    "firewall_sslsshprofile_dot": {
        "stated": false,
        "options": {
            "cert-validation-failure": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-timeout": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "client-certificate": {"v_range": [["7.0.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "expired-server-cert": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "revoked-server-cert": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "sni-server-cert-check": {"v_range": [["7.0.0", ""]], "choices": ["enable", "strict", "disable"], "type": "str"},
            "status": {"v_range": [["7.0.0", ""]], "choices": ["disable", "deep-inspection"], "type": "str"},
            "unsupported-ssl-cipher": {"v_range": [["7.0.0", ""]], "choices": ["block", "allow"], "type": "str"},
            "unsupported-ssl-negotiation": {"v_range": [["7.0.0", ""]], "choices": ["block", "allow"], "type": "str"},
            "untrusted-server-cert": {"v_range": [["7.0.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
            "min-allowed-ssl-version": {"v_range": [["7.0.3", ""]], "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "quic": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable", "bypass", "block", "inspect"], "type": "str"},
            "udp-not-quic": {"v_range": [["7.6.2", ""]], "choices": ["block", "allow"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_echoutersni": {
        "stated": true,
        "options": {"name": {"v_range": [["7.4.3", ""]], "required": true, "type": "str"}, "sni": {"v_range": [["7.4.3", ""]], "type": "str"}}
    },
    "firewall_sslsshprofile_ftps": {
        "stated": false,
        "options": {
            "allow-invalid-server-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ports": {"type": "raw"},
            "status": {"choices": ["disable", "deep-inspection"], "type": "str"},
            "unsupported-ssl": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "untrusted-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "invalid-server-cert": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
            "sni-server-cert-check": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
            "untrusted-server-cert": {"v_range": [["6.2.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-failure": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-timeout": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "expired-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "revoked-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "unsupported-ssl-cipher": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-negotiation": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "min-allowed-ssl-version": {"v_range": [["7.0.3", ""]], "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_https": {
        "stated": false,
        "options": {
            "allow-invalid-server-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ports": {"type": "raw"},
            "status": {"choices": ["disable", "certificate-inspection", "deep-inspection"], "type": "str"},
            "unsupported-ssl": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "untrusted-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "invalid-server-cert": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
            "sni-server-cert-check": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
            "untrusted-server-cert": {"v_range": [["6.2.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-failure": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-timeout": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "expired-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "revoked-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "unsupported-ssl-cipher": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-negotiation": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "cert-probe-failure": {"v_range": [["7.0.0", ""]], "choices": ["block", "allow"], "type": "str"},
            "min-allowed-ssl-version": {"v_range": [["7.0.3", ""]], "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
            "quic": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable", "bypass", "block", "inspect"], "type": "str"},
            "encrypted-client-hello": {"v_range": [["7.4.3", ""]], "choices": ["block", "allow"], "type": "str"},
            "udp-not-quic": {"v_range": [["7.6.2", ""]], "choices": ["block", "allow"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_imaps": {
        "stated": false,
        "options": {
            "allow-invalid-server-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ports": {"type": "raw"},
            "status": {"choices": ["disable", "deep-inspection"], "type": "str"},
            "unsupported-ssl": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "untrusted-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "invalid-server-cert": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
            "sni-server-cert-check": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
            "untrusted-server-cert": {"v_range": [["6.2.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-failure": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-timeout": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "expired-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "revoked-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "unsupported-ssl-cipher": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-negotiation": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
            "min-allowed-ssl-version": {"v_range": [["7.0.3", ""]], "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_pop3s": {
        "stated": false,
        "options": {
            "allow-invalid-server-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ports": {"type": "raw"},
            "status": {"choices": ["disable", "deep-inspection"], "type": "str"},
            "unsupported-ssl": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "untrusted-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "invalid-server-cert": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
            "sni-server-cert-check": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
            "untrusted-server-cert": {"v_range": [["6.2.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-failure": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-timeout": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "expired-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "revoked-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "unsupported-ssl-cipher": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-negotiation": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
            "min-allowed-ssl-version": {"v_range": [["7.0.3", ""]], "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_smtps": {
        "stated": false,
        "options": {
            "allow-invalid-server-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ports": {"type": "raw"},
            "status": {"choices": ["disable", "deep-inspection"], "type": "str"},
            "unsupported-ssl": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "untrusted-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "invalid-server-cert": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
            "sni-server-cert-check": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
            "untrusted-server-cert": {"v_range": [["6.2.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-failure": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-timeout": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "expired-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "revoked-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "unsupported-ssl-cipher": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-negotiation": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
            "min-allowed-ssl-version": {"v_range": [["7.0.3", ""]], "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_ssh": {
        "stated": false,
        "options": {
            "inspect-all": {"choices": ["disable", "deep-inspection"], "type": "str"},
            "ports": {"type": "raw"},
            "ssh-algorithm": {"choices": ["compatible", "high-encryption"], "type": "str"},
            "ssh-policy-check": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "ssh-tun-policy-check": {"choices": ["disable", "enable"], "type": "str"},
            "status": {"choices": ["disable", "deep-inspection"], "type": "str"},
            "unsupported-version": {"choices": ["block", "bypass"], "type": "str"},
            "block": {"v_range": [["6.2.0", "6.4.15"]], "type": "list", "choices": ["x11-filter", "ssh-shell", "exec", "port-forward"], "elements": "str"},
            "log": {"v_range": [["6.2.0", "6.4.15"]], "type": "list", "choices": ["x11-filter", "ssh-shell", "exec", "port-forward"], "elements": "str"},
            "proxy-after-tcp-handshake": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_ssl": {
        "stated": false,
        "options": {
            "allow-invalid-server-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "inspect-all": {"choices": ["disable", "certificate-inspection", "deep-inspection"], "type": "str"},
            "unsupported-ssl": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "untrusted-cert": {"v_range": [["6.0.0", "7.2.1"]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "invalid-server-cert": {"v_range": [["6.2.0", "7.6.2"]], "choices": ["allow", "block"], "type": "str"},
            "sni-server-cert-check": {"v_range": [["6.2.0", ""]], "choices": ["disable", "enable", "strict"], "type": "str"},
            "untrusted-server-cert": {"v_range": [["6.2.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-failure": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "cert-validation-timeout": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "expired-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "revoked-server-cert": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block", "ignore"], "type": "str"},
            "unsupported-ssl-cipher": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "unsupported-ssl-negotiation": {"v_range": [["6.4.0", ""]], "choices": ["allow", "block"], "type": "str"},
            "cert-probe-failure": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow"], "type": "str"},
            "min-allowed-ssl-version": {"v_range": [["7.0.3", ""]], "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "unsupported-ssl-version": {"v_range": [["7.0.1", ""]], "choices": ["block", "allow", "inspect"], "type": "str"},
            "encrypted-client-hello": {"v_range": [["7.4.3", ""]], "choices": ["block", "allow"], "type": "str"}
        }
    },
    "firewall_sslsshprofile_sslexempt": {
        "stated": true,
        "options": {
            "address": {"type": "str"},
            "address6": {"type": "str"},
            "fortiguard-category": {"type": "str"},
            "id": {"required": true, "type": "int"},
            "regex": {"type": "str"},
            "type": {"choices": ["fortiguard-category", "address", "address6", "wildcard-fqdn", "regex", "finger-print"], "type": "str"},
            "wildcard-fqdn": {"type": "str"}
        }
    },
    "firewall_sslsshprofile_sslserver": {
        "stated": true,
        "options": {
            "ftps-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "https-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "id": {"required": true, "type": "int"},
            "imaps-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ip": {"type": "str"},
            "pop3s-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "smtps-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ssl-other-client-cert-request": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ftps-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "https-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "imaps-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "pop3s-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "smtps-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"},
            "ssl-other-client-certificate": {"v_range": [["6.4.0", ""]], "choices": ["bypass", "inspect", "block"], "type": "str"}
        }
    },
    "firewall_trafficclass": {
        "stated": true,
        "options": {"class-id": {"v_range": [["6.2.2", ""]], "type": "int"}, "class-name": {"v_range": [["6.2.2", ""]], "type": "str"}}
    },
    "firewall_vendormac": {
        "stated": false,
        "options": {
            "id": {"v_range": [["7.2.4", "7.2.11"], ["7.4.1", ""]], "type": "int"},
            "mac-number": {"v_range": [["7.2.4", "7.2.11"], ["7.4.1", ""]], "type": "int"},
            "name": {"v_range": [["7.2.4", "7.2.11"], ["7.4.1", ""]], "type": "str"},
            "obsolete": {"v_range": [["7.2.4", "7.2.11"], ["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_vip": {
        "stated": true,
        "options": {
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "dns-mapping-ttl": {"type": "int"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
                    "color": {"type": "int"},
                    "comment": {"type": "str"},
                    "dns-mapping-ttl": {"type": "int"},
                    "extaddr": {"type": "raw"},
                    "extintf": {"type": "str"},
                    "extip": {"type": "str"},
                    "extport": {"type": "str"},
                    "gratuitous-arp-interval": {"type": "int"},
                    "http-cookie-age": {"type": "int"},
                    "http-cookie-domain": {"type": "str"},
                    "http-cookie-domain-from-host": {"choices": ["disable", "enable"], "type": "str"},
                    "http-cookie-generation": {"type": "int"},
                    "http-cookie-path": {"type": "str"},
                    "http-cookie-share": {"choices": ["disable", "same-ip"], "type": "str"},
                    "http-ip-header": {"choices": ["disable", "enable"], "type": "str"},
                    "http-ip-header-name": {"type": "str"},
                    "http-multiplex": {"choices": ["disable", "enable"], "type": "str"},
                    "https-cookie-secure": {"choices": ["disable", "enable"], "type": "str"},
                    "id": {"type": "int"},
                    "ldb-method": {
                        "choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"],
                        "type": "str"
                    },
                    "mapped-addr": {"type": "str"},
                    "mappedip": {"type": "raw"},
                    "mappedport": {"type": "str"},
                    "max-embryonic-connections": {"type": "int"},
                    "monitor": {"type": "raw"},
                    "nat-source-vip": {"choices": ["disable", "enable"], "type": "str"},
                    "outlook-web-access": {"choices": ["disable", "enable"], "type": "str"},
                    "persistence": {"choices": ["none", "http-cookie", "ssl-session-id"], "type": "str"},
                    "portforward": {"choices": ["disable", "enable"], "type": "str"},
                    "portmapping-type": {"choices": ["1-to-1", "m-to-n"], "type": "str"},
                    "protocol": {"choices": ["tcp", "udp", "sctp", "icmp"], "type": "str"},
                    "realservers": {
                        "type": "list",
                        "options": {
                            "client-ip": {"type": "raw"},
                            "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
                            "holddown-interval": {"type": "int"},
                            "http-host": {"type": "str"},
                            "ip": {"type": "str"},
                            "max-connections": {"type": "int"},
                            "monitor": {"type": "raw"},
                            "port": {"type": "int"},
                            "seq": {"type": "int"},
                            "status": {"choices": ["active", "standby", "disable"], "type": "str"},
                            "weight": {"type": "int"},
                            "address": {"v_range": [["6.4.0", ""]], "type": "str"},
                            "id": {"v_range": [["6.4.0", ""]], "type": "int"},
                            "type": {"v_range": [["6.4.0", ""]], "choices": ["ip", "address"], "type": "str"},
                            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "health-check-proto": {"v_range": [["7.2.3", ""]], "choices": ["ping", "http"], "type": "str"},
                            "verify-cert": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "server-type": {"choices": ["http", "https", "ssl", "tcp", "udp", "ip", "imaps", "pop3s", "smtps", "ssh"], "type": "str"},
                    "service": {"type": "raw"},
                    "src-filter": {"type": "raw"},
                    "srcintf-filter": {"type": "raw"},
                    "ssl-algorithm": {"choices": ["high", "medium", "low", "custom"], "type": "str"},
                    "ssl-certificate": {"type": "str"},
                    "ssl-cipher-suites": {
                        "type": "list",
                        "options": {
                            "cipher": {
                                "choices": [
                                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                                    "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA", "TLS-AES-128-GCM-SHA256",
                                    "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                                ],
                                "type": "str"
                            },
                            "id": {"type": "int"},
                            "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"},
                            "priority": {"v_range": [["6.4.0", ""]], "type": "int"}
                        },
                        "elements": "dict"
                    },
                    "ssl-client-fallback": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-client-renegotiation": {"choices": ["deny", "allow", "secure"], "type": "str"},
                    "ssl-client-session-state-max": {"type": "int"},
                    "ssl-client-session-state-timeout": {"type": "int"},
                    "ssl-client-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
                    "ssl-dh-bits": {"choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
                    "ssl-hpkp": {"choices": ["disable", "enable", "report-only"], "type": "str"},
                    "ssl-hpkp-age": {"type": "int"},
                    "ssl-hpkp-backup": {"type": "str"},
                    "ssl-hpkp-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-hpkp-primary": {"type": "str"},
                    "ssl-hpkp-report-uri": {"type": "str"},
                    "ssl-hsts": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-hsts-age": {"type": "int"},
                    "ssl-hsts-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-http-location-conversion": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-http-match-host": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-mode": {"choices": ["half", "full"], "type": "str"},
                    "ssl-pfs": {"choices": ["require", "deny", "allow"], "type": "str"},
                    "ssl-send-empty-frags": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-server-algorithm": {"choices": ["high", "low", "medium", "custom", "client"], "type": "str"},
                    "ssl-server-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
                    "ssl-server-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
                    "ssl-server-session-state-max": {"type": "int"},
                    "ssl-server-session-state-timeout": {"type": "int"},
                    "ssl-server-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
                    "type": {"choices": ["static-nat", "load-balance", "server-load-balance", "dns-translation", "fqdn", "access-proxy"], "type": "str"},
                    "uuid": {"type": "str"},
                    "weblogic-server": {"choices": ["disable", "enable"], "type": "str"},
                    "websphere-server": {"choices": ["disable", "enable"], "type": "str"},
                    "http-redirect": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-client-rekey-count": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "int"},
                    "status": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "add-nat46-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ipv6-mappedip": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "ipv6-mappedport": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "nat44": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "nat46": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-accept-ffdhe-groups": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-multiplex-max-request": {"v_range": [["7.2.2", ""]], "type": "int"},
                    "http-multiplex-ttl": {"v_range": [["7.2.2", ""]], "type": "int"},
                    "http-supported-max-version": {"v_range": [["7.2.2", ""]], "choices": ["http1", "http2"], "type": "str"},
                    "ssl-server-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "http-multiplex-max-concurrent-request": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "gslb-domain-name": {"v_range": [["7.4.2", ""]], "type": "str"},
                    "gslb-hostname": {"v_range": [["7.4.2", ""]], "type": "str"},
                    "one-click-gslb-server": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "src-vip-filter": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "client-cert": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "empty-cert-action": {"v_range": [["7.6.2", ""]], "choices": ["accept", "block", "accept-unmanageable"], "type": "str"},
                    "user-agent-detect": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "extaddr": {"type": "raw"},
            "extintf": {"type": "str"},
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "gratuitous-arp-interval": {"type": "int"},
            "http-cookie-age": {"type": "int"},
            "http-cookie-domain": {"type": "str"},
            "http-cookie-domain-from-host": {"choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"type": "int"},
            "http-cookie-path": {"type": "str"},
            "http-cookie-share": {"choices": ["disable", "same-ip"], "type": "str"},
            "http-ip-header": {"choices": ["disable", "enable"], "type": "str"},
            "http-ip-header-name": {"type": "str"},
            "http-multiplex": {"choices": ["disable", "enable"], "type": "str"},
            "https-cookie-secure": {"choices": ["disable", "enable"], "type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"], "type": "str"},
            "mapped-addr": {"type": "str"},
            "mappedip": {"type": "raw"},
            "mappedport": {"type": "str"},
            "max-embryonic-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "nat-source-vip": {"choices": ["disable", "enable"], "type": "str"},
            "outlook-web-access": {"choices": ["disable", "enable"], "type": "str"},
            "persistence": {"choices": ["none", "http-cookie", "ssl-session-id"], "type": "str"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "portmapping-type": {"choices": ["1-to-1", "m-to-n"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp", "sctp", "icmp"], "type": "str"},
            "realservers": {
                "type": "list",
                "options": {
                    "client-ip": {"type": "raw"},
                    "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
                    "holddown-interval": {"type": "int"},
                    "http-host": {"type": "str"},
                    "ip": {"type": "str"},
                    "max-connections": {"type": "int"},
                    "monitor": {"type": "raw"},
                    "port": {"type": "int"},
                    "seq": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
                    "status": {"choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"type": "int"},
                    "address": {"v_range": [["6.4.0", ""]], "type": "str"},
                    "id": {"v_range": [["6.4.0", ""]], "type": "int"},
                    "type": {"v_range": [["6.4.0", ""]], "choices": ["ip", "address"], "type": "str"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "server-type": {"choices": ["http", "https", "ssl", "tcp", "udp", "ip", "imaps", "pop3s", "smtps", "ssh"], "type": "str"},
            "service": {"type": "raw"},
            "src-filter": {"type": "raw"},
            "srcintf-filter": {"type": "raw"},
            "ssl-algorithm": {"choices": ["high", "medium", "low", "custom"], "type": "str"},
            "ssl-certificate": {"type": "str"},
            "ssl-cipher-suites": {
                "type": "list",
                "options": {
                    "cipher": {
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "id": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
                    "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"},
                    "priority": {"v_range": [["6.4.0", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "ssl-client-fallback": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-client-renegotiation": {"choices": ["deny", "allow", "secure"], "type": "str"},
            "ssl-client-session-state-max": {"type": "int"},
            "ssl-client-session-state-timeout": {"type": "int"},
            "ssl-client-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "ssl-dh-bits": {"choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-hpkp": {"choices": ["disable", "enable", "report-only"], "type": "str"},
            "ssl-hpkp-age": {"type": "int"},
            "ssl-hpkp-backup": {"type": "str"},
            "ssl-hpkp-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hpkp-primary": {"type": "str"},
            "ssl-hpkp-report-uri": {"type": "str"},
            "ssl-hsts": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hsts-age": {"type": "int"},
            "ssl-hsts-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-location-conversion": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-match-host": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-mode": {"choices": ["half", "full"], "type": "str"},
            "ssl-pfs": {"choices": ["require", "deny", "allow"], "type": "str"},
            "ssl-send-empty-frags": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-server-algorithm": {"choices": ["high", "low", "medium", "custom", "client"], "type": "str"},
            "ssl-server-cipher-suites": {
                "type": "list",
                "options": {
                    "cipher": {
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"type": "int"},
                    "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "ssl-server-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-session-state-max": {"type": "int"},
            "ssl-server-session-state-timeout": {"type": "int"},
            "ssl-server-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "type": {"choices": ["static-nat", "load-balance", "server-load-balance", "dns-translation", "fqdn", "access-proxy"], "type": "str"},
            "uuid": {"type": "str"},
            "weblogic-server": {"choices": ["disable", "enable"], "type": "str"},
            "websphere-server": {"choices": ["disable", "enable"], "type": "str"},
            "http-redirect": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-client-rekey-count": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "int"},
            "status": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "add-nat46-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ipv6-mappedip": {"v_range": [["7.0.1", ""]], "type": "str"},
            "ipv6-mappedport": {"v_range": [["7.0.1", ""]], "type": "str"},
            "nat44": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "nat46": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-accept-ffdhe-groups": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-multiplex-max-request": {"v_range": [["7.2.2", ""]], "type": "int"},
            "http-multiplex-ttl": {"v_range": [["7.2.2", ""]], "type": "int"},
            "http-supported-max-version": {"v_range": [["7.2.2", ""]], "choices": ["http1", "http2"], "type": "str"},
            "ssl-server-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-multiplex-max-concurrent-request": {"v_range": [["7.4.1", ""]], "type": "int"},
            "quic": {
                "v_range": [["7.4.1", ""]],
                "type": "dict",
                "options": {
                    "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
                    "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
                }
            },
            "gslb-domain-name": {"v_range": [["7.4.2", ""]], "type": "str"},
            "gslb-hostname": {"v_range": [["7.4.2", ""]], "type": "str"},
            "gslb-public-ips": {
                "v_range": [["7.4.2", ""]],
                "type": "list",
                "options": {"index": {"v_range": [["7.4.2", ""]], "type": "int"}, "ip": {"v_range": [["7.4.2", ""]], "type": "str"}},
                "elements": "dict"
            },
            "one-click-gslb-server": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "src-vip-filter": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "empty-cert-action": {"v_range": [["7.6.2", ""]], "choices": ["accept", "block", "accept-unmanageable"], "type": "str"},
            "user-agent-detect": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_vip46": {
        "stated": true,
        "options": {
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
                    "color": {"type": "int"},
                    "comment": {"type": "str"},
                    "extip": {"type": "str"},
                    "extport": {"type": "str"},
                    "id": {"type": "int"},
                    "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive"], "type": "str"},
                    "mappedip": {"type": "str"},
                    "mappedport": {"type": "str"},
                    "monitor": {"type": "raw"},
                    "portforward": {"choices": ["disable", "enable"], "type": "str"},
                    "protocol": {"choices": ["tcp", "udp"], "type": "str"},
                    "server-type": {"choices": ["http", "tcp", "udp", "ip"], "type": "str"},
                    "src-filter": {"type": "raw"},
                    "type": {"choices": ["static-nat", "server-load-balance"], "type": "str"},
                    "uuid": {"type": "str"},
                    "srcintf-filter": {"v_range": [["6.2.7", "6.2.13"], ["6.4.4", ""]], "type": "raw"}
                },
                "elements": "dict"
            },
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive"], "type": "str"},
            "mappedip": {"type": "str"},
            "mappedport": {"type": "str"},
            "monitor": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp"], "type": "str"},
            "realservers": {
                "type": "list",
                "options": {
                    "client-ip": {"type": "str"},
                    "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
                    "holddown-interval": {"type": "int"},
                    "id": {"type": "int"},
                    "ip": {"type": "str"},
                    "max-connections": {"type": "int"},
                    "monitor": {"type": "raw"},
                    "port": {"type": "int"},
                    "status": {"choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"type": "int"}
                },
                "elements": "dict"
            },
            "server-type": {"choices": ["http", "tcp", "udp", "ip"], "type": "str"},
            "src-filter": {"type": "raw"},
            "type": {"choices": ["static-nat", "server-load-balance"], "type": "str"},
            "uuid": {"type": "str"},
            "srcintf-filter": {"v_range": [["6.2.7", "6.2.13"], ["6.4.4", ""]], "type": "raw"}
        }
    },
    "firewall_vip46_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive"], "type": "str"},
            "mappedip": {"type": "str"},
            "mappedport": {"type": "str"},
            "monitor": {"type": "raw"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp"], "type": "str"},
            "server-type": {"choices": ["http", "tcp", "udp", "ip"], "type": "str"},
            "src-filter": {"type": "raw"},
            "type": {"choices": ["static-nat", "server-load-balance"], "type": "str"},
            "uuid": {"type": "str"},
            "srcintf-filter": {"v_range": [["6.2.7", "6.2.13"], ["6.4.4", ""]], "type": "raw"}
        }
    },
    "firewall_vip46_realservers": {
        "stated": true,
        "options": {
            "client-ip": {"type": "str"},
            "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
            "holddown-interval": {"type": "int"},
            "id": {"required": true, "type": "int"},
            "ip": {"type": "str"},
            "max-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "port": {"type": "int"},
            "status": {"choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"type": "int"}
        }
    },
    "firewall_vip6": {
        "stated": true,
        "options": {
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
                    "color": {"type": "int"},
                    "comment": {"type": "str"},
                    "extip": {"type": "str"},
                    "extport": {"type": "str"},
                    "http-cookie-age": {"type": "int"},
                    "http-cookie-domain": {"type": "str"},
                    "http-cookie-domain-from-host": {"choices": ["disable", "enable"], "type": "str"},
                    "http-cookie-generation": {"type": "int"},
                    "http-cookie-path": {"type": "str"},
                    "http-cookie-share": {"choices": ["disable", "same-ip"], "type": "str"},
                    "http-ip-header": {"choices": ["disable", "enable"], "type": "str"},
                    "http-ip-header-name": {"type": "str"},
                    "http-multiplex": {"choices": ["disable", "enable"], "type": "str"},
                    "https-cookie-secure": {"choices": ["disable", "enable"], "type": "str"},
                    "id": {"type": "int"},
                    "ldb-method": {
                        "choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"],
                        "type": "str"
                    },
                    "mappedip": {"type": "str"},
                    "mappedport": {"type": "str"},
                    "max-embryonic-connections": {"type": "int"},
                    "monitor": {"type": "raw"},
                    "outlook-web-access": {"choices": ["disable", "enable"], "type": "str"},
                    "persistence": {"choices": ["none", "http-cookie", "ssl-session-id"], "type": "str"},
                    "portforward": {"choices": ["disable", "enable"], "type": "str"},
                    "protocol": {"choices": ["tcp", "udp", "sctp"], "type": "str"},
                    "server-type": {"choices": ["http", "https", "ssl", "tcp", "udp", "ip", "imaps", "pop3s", "smtps"], "type": "str"},
                    "src-filter": {"type": "raw"},
                    "ssl-algorithm": {"choices": ["high", "low", "medium", "custom"], "type": "str"},
                    "ssl-certificate": {"type": "str"},
                    "ssl-client-fallback": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-client-renegotiation": {"choices": ["deny", "allow", "secure"], "type": "str"},
                    "ssl-client-session-state-max": {"type": "int"},
                    "ssl-client-session-state-timeout": {"type": "int"},
                    "ssl-client-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
                    "ssl-dh-bits": {"choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
                    "ssl-hpkp": {"choices": ["disable", "enable", "report-only"], "type": "str"},
                    "ssl-hpkp-age": {"type": "int"},
                    "ssl-hpkp-backup": {"type": "str"},
                    "ssl-hpkp-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-hpkp-primary": {"type": "str"},
                    "ssl-hpkp-report-uri": {"type": "str"},
                    "ssl-hsts": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-hsts-age": {"type": "int"},
                    "ssl-hsts-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-http-location-conversion": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-http-match-host": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
                    "ssl-mode": {"choices": ["half", "full"], "type": "str"},
                    "ssl-pfs": {"choices": ["require", "deny", "allow"], "type": "str"},
                    "ssl-send-empty-frags": {"choices": ["disable", "enable"], "type": "str"},
                    "ssl-server-algorithm": {"choices": ["high", "low", "medium", "custom", "client"], "type": "str"},
                    "ssl-server-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
                    "ssl-server-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
                    "ssl-server-session-state-max": {"type": "int"},
                    "ssl-server-session-state-timeout": {"type": "int"},
                    "ssl-server-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
                    "type": {"choices": ["static-nat", "server-load-balance", "access-proxy"], "type": "str"},
                    "uuid": {"type": "str"},
                    "weblogic-server": {"choices": ["disable", "enable"], "type": "str"},
                    "websphere-server": {"choices": ["disable", "enable"], "type": "str"},
                    "http-redirect": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-client-rekey-count": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "int"},
                    "nat-source-vip": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "add-nat64-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "embedded-ipv4-address": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ipv4-mappedip": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "ipv4-mappedport": {"v_range": [["7.0.1", ""]], "type": "str"},
                    "nat64": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "nat66": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "realservers": {
                        "v_range": [["7.0.2", ""]],
                        "type": "list",
                        "options": {
                            "client-ip": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "healthcheck": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable", "vip"], "type": "str"},
                            "holddown-interval": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "http-host": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "id": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "ip": {"v_range": [["7.0.2", ""]], "type": "str"},
                            "max-connections": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "monitor": {"v_range": [["7.0.2", ""]], "type": "raw"},
                            "port": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "status": {"v_range": [["7.0.2", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                            "weight": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "ssl-accept-ffdhe-groups": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-cipher-suites": {
                        "v_range": [["7.0.2", ""]],
                        "type": "list",
                        "options": {
                            "cipher": {
                                "v_range": [["7.0.2", ""]],
                                "choices": [
                                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                                    "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                                    "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                                    "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256",
                                    "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                                    "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384",
                                    "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA", "TLS-AES-128-GCM-SHA256",
                                    "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                                ],
                                "type": "str"
                            },
                            "priority": {"v_range": [["7.0.2", ""]], "type": "int"},
                            "versions": {
                                "v_range": [["7.0.2", ""]],
                                "type": "list",
                                "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                                "elements": "str"
                            }
                        },
                        "elements": "dict"
                    },
                    "ndp-reply": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "ssl-server-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h2-support": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "h3-support": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "src-vip-filter": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "client-cert": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "empty-cert-action": {"v_range": [["7.6.2", ""]], "choices": ["accept", "block", "accept-unmanageable"], "type": "str"},
                    "user-agent-detect": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "http-cookie-age": {"type": "int"},
            "http-cookie-domain": {"type": "str"},
            "http-cookie-domain-from-host": {"choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"type": "int"},
            "http-cookie-path": {"type": "str"},
            "http-cookie-share": {"choices": ["disable", "same-ip"], "type": "str"},
            "http-ip-header": {"choices": ["disable", "enable"], "type": "str"},
            "http-ip-header-name": {"type": "str"},
            "http-multiplex": {"choices": ["disable", "enable"], "type": "str"},
            "https-cookie-secure": {"choices": ["disable", "enable"], "type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"], "type": "str"},
            "mappedip": {"type": "str"},
            "mappedport": {"type": "str"},
            "max-embryonic-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "outlook-web-access": {"choices": ["disable", "enable"], "type": "str"},
            "persistence": {"choices": ["none", "http-cookie", "ssl-session-id"], "type": "str"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp", "sctp"], "type": "str"},
            "realservers": {
                "type": "list",
                "options": {
                    "client-ip": {"type": "str"},
                    "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
                    "holddown-interval": {"type": "int"},
                    "http-host": {"type": "str"},
                    "id": {"type": "int"},
                    "ip": {"type": "str"},
                    "max-connections": {"type": "int"},
                    "monitor": {"type": "raw"},
                    "port": {"type": "int"},
                    "status": {"choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"type": "int"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "server-type": {"choices": ["http", "https", "ssl", "tcp", "udp", "ip", "imaps", "pop3s", "smtps"], "type": "str"},
            "src-filter": {"type": "raw"},
            "ssl-algorithm": {"choices": ["high", "low", "medium", "custom"], "type": "str"},
            "ssl-certificate": {"type": "str"},
            "ssl-cipher-suites": {
                "type": "list",
                "options": {
                    "cipher": {
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"type": "int"},
                    "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "ssl-client-fallback": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-client-renegotiation": {"choices": ["deny", "allow", "secure"], "type": "str"},
            "ssl-client-session-state-max": {"type": "int"},
            "ssl-client-session-state-timeout": {"type": "int"},
            "ssl-client-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "ssl-dh-bits": {"choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-hpkp": {"choices": ["disable", "enable", "report-only"], "type": "str"},
            "ssl-hpkp-age": {"type": "int"},
            "ssl-hpkp-backup": {"type": "str"},
            "ssl-hpkp-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hpkp-primary": {"type": "str"},
            "ssl-hpkp-report-uri": {"type": "str"},
            "ssl-hsts": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hsts-age": {"type": "int"},
            "ssl-hsts-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-location-conversion": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-match-host": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-mode": {"choices": ["half", "full"], "type": "str"},
            "ssl-pfs": {"choices": ["require", "deny", "allow"], "type": "str"},
            "ssl-send-empty-frags": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-server-algorithm": {"choices": ["high", "low", "medium", "custom", "client"], "type": "str"},
            "ssl-server-cipher-suites": {
                "type": "list",
                "options": {
                    "cipher": {
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"type": "int"},
                    "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
                },
                "elements": "dict"
            },
            "ssl-server-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-session-state-max": {"type": "int"},
            "ssl-server-session-state-timeout": {"type": "int"},
            "ssl-server-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "type": {"choices": ["static-nat", "server-load-balance", "access-proxy"], "type": "str"},
            "uuid": {"type": "str"},
            "weblogic-server": {"choices": ["disable", "enable"], "type": "str"},
            "websphere-server": {"choices": ["disable", "enable"], "type": "str"},
            "http-redirect": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-client-rekey-count": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "int"},
            "nat-source-vip": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "add-nat64-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "embedded-ipv4-address": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ipv4-mappedip": {"v_range": [["7.0.1", ""]], "type": "str"},
            "ipv4-mappedport": {"v_range": [["7.0.1", ""]], "type": "str"},
            "nat64": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "nat66": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-accept-ffdhe-groups": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ndp-reply": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-server-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "quic": {
                "v_range": [["7.4.2", ""]],
                "type": "dict",
                "options": {
                    "ack-delay-exponent": {"v_range": [["7.4.2", ""]], "type": "int"},
                    "active-connection-id-limit": {"v_range": [["7.4.2", ""]], "type": "int"},
                    "active-migration": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "grease-quic-bit": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "max-ack-delay": {"v_range": [["7.4.2", ""]], "type": "int"},
                    "max-datagram-frame-size": {"v_range": [["7.4.2", ""]], "type": "int"},
                    "max-idle-timeout": {"v_range": [["7.4.2", ""]], "type": "int"},
                    "max-udp-payload-size": {"v_range": [["7.4.2", ""]], "type": "int"}
                }
            },
            "src-vip-filter": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "empty-cert-action": {"v_range": [["7.6.2", ""]], "choices": ["accept", "block", "accept-unmanageable"], "type": "str"},
            "user-agent-detect": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_vip64": {
        "stated": true,
        "options": {
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
                    "color": {"type": "int"},
                    "comment": {"type": "str"},
                    "extip": {"type": "str"},
                    "extport": {"type": "str"},
                    "id": {"type": "int"},
                    "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive"], "type": "str"},
                    "mappedip": {"type": "str"},
                    "mappedport": {"type": "str"},
                    "monitor": {"type": "raw"},
                    "portforward": {"choices": ["disable", "enable"], "type": "str"},
                    "protocol": {"choices": ["tcp", "udp"], "type": "str"},
                    "server-type": {"choices": ["http", "tcp", "udp", "ip"], "type": "str"},
                    "src-filter": {"type": "raw"},
                    "type": {"choices": ["static-nat", "server-load-balance"], "type": "str"},
                    "uuid": {"type": "str"}
                },
                "elements": "dict"
            },
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive"], "type": "str"},
            "mappedip": {"type": "str"},
            "mappedport": {"type": "str"},
            "monitor": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp"], "type": "str"},
            "realservers": {
                "type": "list",
                "options": {
                    "client-ip": {"type": "str"},
                    "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
                    "holddown-interval": {"type": "int"},
                    "id": {"type": "int"},
                    "ip": {"type": "str"},
                    "max-connections": {"type": "int"},
                    "monitor": {"type": "raw"},
                    "port": {"type": "int"},
                    "status": {"choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"type": "int"}
                },
                "elements": "dict"
            },
            "server-type": {"choices": ["http", "tcp", "udp", "ip"], "type": "str"},
            "src-filter": {"type": "raw"},
            "type": {"choices": ["static-nat", "server-load-balance"], "type": "str"},
            "uuid": {"type": "str"}
        }
    },
    "firewall_vip64_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive"], "type": "str"},
            "mappedip": {"type": "str"},
            "mappedport": {"type": "str"},
            "monitor": {"type": "raw"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp"], "type": "str"},
            "server-type": {"choices": ["http", "tcp", "udp", "ip"], "type": "str"},
            "src-filter": {"type": "raw"},
            "type": {"choices": ["static-nat", "server-load-balance"], "type": "str"},
            "uuid": {"type": "str"}
        }
    },
    "firewall_vip64_realservers": {
        "stated": true,
        "options": {
            "client-ip": {"type": "str"},
            "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
            "holddown-interval": {"type": "int"},
            "id": {"required": true, "type": "int"},
            "ip": {"type": "str"},
            "max-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "port": {"type": "int"},
            "status": {"choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"type": "int"}
        }
    },
    "firewall_vip6_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "http-cookie-age": {"type": "int"},
            "http-cookie-domain": {"type": "str"},
            "http-cookie-domain-from-host": {"choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"type": "int"},
            "http-cookie-path": {"type": "str"},
            "http-cookie-share": {"choices": ["disable", "same-ip"], "type": "str"},
            "http-ip-header": {"choices": ["disable", "enable"], "type": "str"},
            "http-ip-header-name": {"type": "str"},
            "http-multiplex": {"choices": ["disable", "enable"], "type": "str"},
            "https-cookie-secure": {"choices": ["disable", "enable"], "type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"], "type": "str"},
            "mappedip": {"type": "str"},
            "mappedport": {"type": "str"},
            "max-embryonic-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "outlook-web-access": {"choices": ["disable", "enable"], "type": "str"},
            "persistence": {"choices": ["none", "http-cookie", "ssl-session-id"], "type": "str"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp", "sctp"], "type": "str"},
            "server-type": {"choices": ["http", "https", "ssl", "tcp", "udp", "ip", "imaps", "pop3s", "smtps"], "type": "str"},
            "src-filter": {"type": "raw"},
            "ssl-algorithm": {"choices": ["high", "low", "medium", "custom"], "type": "str"},
            "ssl-certificate": {"type": "str"},
            "ssl-client-fallback": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-client-renegotiation": {"choices": ["deny", "allow", "secure"], "type": "str"},
            "ssl-client-session-state-max": {"type": "int"},
            "ssl-client-session-state-timeout": {"type": "int"},
            "ssl-client-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "ssl-dh-bits": {"choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-hpkp": {"choices": ["disable", "enable", "report-only"], "type": "str"},
            "ssl-hpkp-age": {"type": "int"},
            "ssl-hpkp-backup": {"type": "str"},
            "ssl-hpkp-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hpkp-primary": {"type": "str"},
            "ssl-hpkp-report-uri": {"type": "str"},
            "ssl-hsts": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hsts-age": {"type": "int"},
            "ssl-hsts-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-location-conversion": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-match-host": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-mode": {"choices": ["half", "full"], "type": "str"},
            "ssl-pfs": {"choices": ["require", "deny", "allow"], "type": "str"},
            "ssl-send-empty-frags": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-server-algorithm": {"choices": ["high", "low", "medium", "custom", "client"], "type": "str"},
            "ssl-server-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-session-state-max": {"type": "int"},
            "ssl-server-session-state-timeout": {"type": "int"},
            "ssl-server-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "type": {"choices": ["static-nat", "server-load-balance", "access-proxy"], "type": "str"},
            "uuid": {"type": "str"},
            "weblogic-server": {"choices": ["disable", "enable"], "type": "str"},
            "websphere-server": {"choices": ["disable", "enable"], "type": "str"},
            "http-redirect": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-client-rekey-count": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "int"},
            "nat-source-vip": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "add-nat64-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "embedded-ipv4-address": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ipv4-mappedip": {"v_range": [["7.0.1", ""]], "type": "str"},
            "ipv4-mappedport": {"v_range": [["7.0.1", ""]], "type": "str"},
            "nat64": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "nat66": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "realservers": {
                "v_range": [["7.0.2", ""]],
                "type": "list",
                "options": {
                    "client-ip": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "healthcheck": {"v_range": [["7.0.2", ""]], "choices": ["disable", "enable", "vip"], "type": "str"},
                    "holddown-interval": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "http-host": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "id": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "ip": {"v_range": [["7.0.2", ""]], "type": "str"},
                    "max-connections": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "monitor": {"v_range": [["7.0.2", ""]], "type": "raw"},
                    "port": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "status": {"v_range": [["7.0.2", ""]], "choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "ssl-accept-ffdhe-groups": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-cipher-suites": {
                "v_range": [["7.0.2", ""]],
                "type": "list",
                "options": {
                    "cipher": {
                        "v_range": [["7.0.2", ""]],
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "priority": {"v_range": [["7.0.2", ""]], "type": "int"},
                    "versions": {
                        "v_range": [["7.0.2", ""]],
                        "type": "list",
                        "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                        "elements": "str"
                    }
                },
                "elements": "dict"
            },
            "ndp-reply": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-server-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "src-vip-filter": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "empty-cert-action": {"v_range": [["7.6.2", ""]], "choices": ["accept", "block", "accept-unmanageable"], "type": "str"},
            "user-agent-detect": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_vip6_dynamicmapping_realservers": {
        "stated": true,
        "options": {
            "client-ip": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "str"},
            "healthcheck": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["disable", "enable", "vip"], "type": "str"},
            "holddown-interval": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "http-host": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "str"},
            "id": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "required": true, "type": "int"},
            "ip": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "str"},
            "max-connections": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "monitor": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "raw"},
            "port": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "status": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "translate-host": {"v_range": [["7.2.2", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_vip6_dynamicmapping_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]],
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "versions": {
                "v_range": [["7.0.2", "7.2.5"], ["7.4.0", "7.4.0"]],
                "type": "list",
                "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                "elements": "str"
            }
        }
    },
    "firewall_vip6_quic": {
        "stated": false,
        "options": {
            "ack-delay-exponent": {"v_range": [["7.4.2", ""]], "type": "int"},
            "active-connection-id-limit": {"v_range": [["7.4.2", ""]], "type": "int"},
            "active-migration": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "grease-quic-bit": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "max-ack-delay": {"v_range": [["7.4.2", ""]], "type": "int"},
            "max-datagram-frame-size": {"v_range": [["7.4.2", ""]], "type": "int"},
            "max-idle-timeout": {"v_range": [["7.4.2", ""]], "type": "int"},
            "max-udp-payload-size": {"v_range": [["7.4.2", ""]], "type": "int"}
        }
    },
    "firewall_vip6_realservers": {
        "stated": true,
        "options": {
            "client-ip": {"type": "str"},
            "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
            "holddown-interval": {"type": "int"},
            "http-host": {"type": "str"},
            "id": {"required": true, "type": "int"},
            "ip": {"type": "str"},
            "max-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "port": {"type": "int"},
            "status": {"choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"type": "int"},
            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_vip6_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"required": true, "type": "int"},
            "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
        }
    },
    "firewall_vip6_sslserverciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"required": true, "type": "int"},
            "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
        }
    },
    "firewall_vip_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "arp-reply": {"choices": ["disable", "enable"], "type": "str"},
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "dns-mapping-ttl": {"type": "int"},
            "extaddr": {"type": "raw"},
            "extintf": {"type": "str"},
            "extip": {"type": "str"},
            "extport": {"type": "str"},
            "gratuitous-arp-interval": {"type": "int"},
            "http-cookie-age": {"type": "int"},
            "http-cookie-domain": {"type": "str"},
            "http-cookie-domain-from-host": {"choices": ["disable", "enable"], "type": "str"},
            "http-cookie-generation": {"type": "int"},
            "http-cookie-path": {"type": "str"},
            "http-cookie-share": {"choices": ["disable", "same-ip"], "type": "str"},
            "http-ip-header": {"choices": ["disable", "enable"], "type": "str"},
            "http-ip-header-name": {"type": "str"},
            "http-multiplex": {"choices": ["disable", "enable"], "type": "str"},
            "https-cookie-secure": {"choices": ["disable", "enable"], "type": "str"},
            "id": {"type": "int"},
            "ldb-method": {"choices": ["static", "round-robin", "weighted", "least-session", "least-rtt", "first-alive", "http-host"], "type": "str"},
            "mapped-addr": {"type": "str"},
            "mappedip": {"type": "raw"},
            "mappedport": {"type": "str"},
            "max-embryonic-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "nat-source-vip": {"choices": ["disable", "enable"], "type": "str"},
            "outlook-web-access": {"choices": ["disable", "enable"], "type": "str"},
            "persistence": {"choices": ["none", "http-cookie", "ssl-session-id"], "type": "str"},
            "portforward": {"choices": ["disable", "enable"], "type": "str"},
            "portmapping-type": {"choices": ["1-to-1", "m-to-n"], "type": "str"},
            "protocol": {"choices": ["tcp", "udp", "sctp", "icmp"], "type": "str"},
            "realservers": {
                "type": "list",
                "options": {
                    "client-ip": {"type": "raw"},
                    "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
                    "holddown-interval": {"type": "int"},
                    "http-host": {"type": "str"},
                    "ip": {"type": "str"},
                    "max-connections": {"type": "int"},
                    "monitor": {"type": "raw"},
                    "port": {"type": "int"},
                    "seq": {"type": "int"},
                    "status": {"choices": ["active", "standby", "disable"], "type": "str"},
                    "weight": {"type": "int"},
                    "address": {"v_range": [["6.4.0", ""]], "type": "str"},
                    "id": {"v_range": [["6.4.0", ""]], "type": "int"},
                    "type": {"v_range": [["6.4.0", ""]], "choices": ["ip", "address"], "type": "str"},
                    "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                    "health-check-proto": {"v_range": [["7.2.3", ""]], "choices": ["ping", "http"], "type": "str"},
                    "verify-cert": {"v_range": [["7.4.7", "7.4.7"], ["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                },
                "elements": "dict"
            },
            "server-type": {"choices": ["http", "https", "ssl", "tcp", "udp", "ip", "imaps", "pop3s", "smtps", "ssh"], "type": "str"},
            "service": {"type": "raw"},
            "src-filter": {"type": "raw"},
            "srcintf-filter": {"type": "raw"},
            "ssl-algorithm": {"choices": ["high", "medium", "low", "custom"], "type": "str"},
            "ssl-certificate": {"type": "str"},
            "ssl-cipher-suites": {
                "type": "list",
                "options": {
                    "cipher": {
                        "choices": [
                            "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-RSA-WITH-AES-256-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA",
                            "TLS-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA",
                            "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA",
                            "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA", "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA", "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA",
                            "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA", "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256",
                            "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256",
                            "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384",
                            "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384", "TLS-RSA-WITH-AES-128-GCM-SHA256",
                            "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA",
                            "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-DSS-WITH-SEED-CBC-SHA",
                            "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                            "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                            "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                        ],
                        "type": "str"
                    },
                    "id": {"type": "int"},
                    "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"},
                    "priority": {"v_range": [["6.4.0", ""]], "type": "int"}
                },
                "elements": "dict"
            },
            "ssl-client-fallback": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-client-renegotiation": {"choices": ["deny", "allow", "secure"], "type": "str"},
            "ssl-client-session-state-max": {"type": "int"},
            "ssl-client-session-state-timeout": {"type": "int"},
            "ssl-client-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "ssl-dh-bits": {"choices": ["768", "1024", "1536", "2048", "3072", "4096"], "type": "str"},
            "ssl-hpkp": {"choices": ["disable", "enable", "report-only"], "type": "str"},
            "ssl-hpkp-age": {"type": "int"},
            "ssl-hpkp-backup": {"type": "str"},
            "ssl-hpkp-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hpkp-primary": {"type": "str"},
            "ssl-hpkp-report-uri": {"type": "str"},
            "ssl-hsts": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-hsts-age": {"type": "int"},
            "ssl-hsts-include-subdomains": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-location-conversion": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-http-match-host": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "type": "str"},
            "ssl-mode": {"choices": ["half", "full"], "type": "str"},
            "ssl-pfs": {"choices": ["require", "deny", "allow"], "type": "str"},
            "ssl-send-empty-frags": {"choices": ["disable", "enable"], "type": "str"},
            "ssl-server-algorithm": {"choices": ["high", "low", "medium", "custom", "client"], "type": "str"},
            "ssl-server-max-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-min-version": {"choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "client", "tls-1.3"], "type": "str"},
            "ssl-server-session-state-max": {"type": "int"},
            "ssl-server-session-state-timeout": {"type": "int"},
            "ssl-server-session-state-type": {"choices": ["disable", "time", "count", "both"], "type": "str"},
            "type": {"choices": ["static-nat", "load-balance", "server-load-balance", "dns-translation", "fqdn", "access-proxy"], "type": "str"},
            "uuid": {"type": "str"},
            "weblogic-server": {"choices": ["disable", "enable"], "type": "str"},
            "websphere-server": {"choices": ["disable", "enable"], "type": "str"},
            "http-redirect": {"v_range": [["6.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-client-rekey-count": {"v_range": [["6.2.1", ""]], "no_log": true, "type": "int"},
            "status": {"v_range": [["7.0.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "add-nat46-route": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ipv6-mappedip": {"v_range": [["7.0.1", ""]], "type": "str"},
            "ipv6-mappedport": {"v_range": [["7.0.1", ""]], "type": "str"},
            "nat44": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "nat46": {"v_range": [["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ssl-accept-ffdhe-groups": {"v_range": [["7.0.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-multiplex-max-request": {"v_range": [["7.2.2", ""]], "type": "int"},
            "http-multiplex-ttl": {"v_range": [["7.2.2", ""]], "type": "int"},
            "http-supported-max-version": {"v_range": [["7.2.2", ""]], "choices": ["http1", "http2"], "type": "str"},
            "ssl-server-renegotiation": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h2-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "h3-support": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "http-multiplex-max-concurrent-request": {"v_range": [["7.4.1", ""]], "type": "int"},
            "gslb-domain-name": {"v_range": [["7.4.2", ""]], "type": "str"},
            "gslb-hostname": {"v_range": [["7.4.2", ""]], "type": "str"},
            "one-click-gslb-server": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "src-vip-filter": {"v_range": [["7.4.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "client-cert": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "empty-cert-action": {"v_range": [["7.6.2", ""]], "choices": ["accept", "block", "accept-unmanageable"], "type": "str"},
            "user-agent-detect": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_vip_dynamicmapping_realservers": {
        "stated": true,
        "options": {
            "client-ip": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "raw"},
            "healthcheck": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["disable", "enable", "vip"], "type": "str"},
            "holddown-interval": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "http-host": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "str"},
            "ip": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "str"},
            "max-connections": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "monitor": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "raw"},
            "port": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "seq": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "required": true, "type": "int"},
            "status": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "address": {"v_range": [["6.4.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "str"},
            "id": {"v_range": [["6.4.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"},
            "type": {"v_range": [["6.4.0", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["ip", "address"], "type": "str"},
            "translate-host": {"v_range": [["7.2.2", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["disable", "enable"], "type": "str"},
            "health-check-proto": {"v_range": [["7.2.3", "7.2.5"], ["7.4.0", "7.4.0"]], "choices": ["ping", "http"], "type": "str"}
        }
    },
    "firewall_vip_dynamicmapping_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]],
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "id": {"v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]], "required": true, "type": "int"},
            "versions": {
                "v_range": [["6.0.0", "7.2.5"], ["7.4.0", "7.4.0"]],
                "type": "list",
                "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"],
                "elements": "str"
            },
            "priority": {"v_range": [["6.4.0", "7.2.5"], ["7.4.0", "7.4.0"]], "type": "int"}
        }
    },
    "firewall_vip_gslbpublicips": {
        "stated": true,
        "options": {"index": {"v_range": [["7.4.2", ""]], "type": "int"}, "ip": {"v_range": [["7.4.2", ""]], "type": "str"}}
    },
    "firewall_vip_quic": {
        "stated": false,
        "options": {
            "ack-delay-exponent": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-connection-id-limit": {"v_range": [["7.4.1", ""]], "type": "int"},
            "active-migration": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "grease-quic-bit": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "max-ack-delay": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-datagram-frame-size": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-idle-timeout": {"v_range": [["7.4.1", ""]], "type": "int"},
            "max-udp-payload-size": {"v_range": [["7.4.1", ""]], "type": "int"}
        }
    },
    "firewall_vip_realservers": {
        "stated": true,
        "options": {
            "client-ip": {"type": "raw"},
            "healthcheck": {"choices": ["disable", "enable", "vip"], "type": "str"},
            "holddown-interval": {"type": "int"},
            "http-host": {"type": "str"},
            "ip": {"type": "str"},
            "max-connections": {"type": "int"},
            "monitor": {"type": "raw"},
            "port": {"type": "int"},
            "seq": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "int"},
            "status": {"choices": ["active", "standby", "disable"], "type": "str"},
            "weight": {"type": "int"},
            "address": {"v_range": [["6.4.0", ""]], "type": "str"},
            "id": {"v_range": [["6.4.0", ""]], "type": "int"},
            "type": {"v_range": [["6.4.0", ""]], "choices": ["ip", "address"], "type": "str"},
            "translate-host": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "verify-cert": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "firewall_vip_sslciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "id": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "int"},
            "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"},
            "priority": {"v_range": [["6.4.0", ""]], "type": "int"}
        }
    },
    "firewall_vip_sslserverciphersuites": {
        "stated": true,
        "options": {
            "cipher": {
                "choices": [
                    "TLS-RSA-WITH-RC4-128-MD5", "TLS-RSA-WITH-RC4-128-SHA", "TLS-RSA-WITH-DES-CBC-SHA", "TLS-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-RSA-WITH-AES-128-CBC-SHA", "TLS-RSA-WITH-AES-256-CBC-SHA", "TLS-RSA-WITH-AES-128-CBC-SHA256", "TLS-RSA-WITH-AES-256-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA", "TLS-RSA-WITH-CAMELLIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-RSA-WITH-SEED-CBC-SHA", "TLS-RSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-RSA-WITH-DES-CBC-SHA", "TLS-DHE-RSA-WITH-3DES-EDE-CBC-SHA",
                    "TLS-DHE-RSA-WITH-AES-128-CBC-SHA", "TLS-DHE-RSA-WITH-AES-256-CBC-SHA", "TLS-DHE-RSA-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-RSA-WITH-AES-256-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA",
                    "TLS-DHE-RSA-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-CAMELLIA-256-CBC-SHA256", "TLS-DHE-RSA-WITH-SEED-CBC-SHA",
                    "TLS-DHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-RSA-WITH-RC4-128-SHA",
                    "TLS-ECDHE-RSA-WITH-3DES-EDE-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA",
                    "TLS-ECDHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-CHACHA20-POLY1305-SHA256",
                    "TLS-DHE-RSA-WITH-CHACHA20-POLY1305-SHA256", "TLS-DHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-DHE-RSA-WITH-AES-256-GCM-SHA384",
                    "TLS-DHE-DSS-WITH-AES-128-CBC-SHA", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA", "TLS-DHE-DSS-WITH-AES-128-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-AES-128-GCM-SHA256", "TLS-DHE-DSS-WITH-AES-256-CBC-SHA256", "TLS-DHE-DSS-WITH-AES-256-GCM-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-RSA-WITH-AES-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-AES-256-GCM-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA", "TLS-ECDHE-ECDSA-WITH-AES-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-AES-128-GCM-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-AES-256-GCM-SHA384",
                    "TLS-RSA-WITH-AES-128-GCM-SHA256", "TLS-RSA-WITH-AES-256-GCM-SHA384", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA",
                    "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA", "TLS-DHE-DSS-WITH-CAMELLIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-CAMELLIA-256-CBC-SHA256",
                    "TLS-DHE-DSS-WITH-SEED-CBC-SHA", "TLS-DHE-DSS-WITH-ARIA-128-CBC-SHA256", "TLS-DHE-DSS-WITH-ARIA-256-CBC-SHA384",
                    "TLS-ECDHE-RSA-WITH-ARIA-128-CBC-SHA256", "TLS-ECDHE-RSA-WITH-ARIA-256-CBC-SHA384", "TLS-ECDHE-ECDSA-WITH-ARIA-128-CBC-SHA256",
                    "TLS-ECDHE-ECDSA-WITH-ARIA-256-CBC-SHA384", "TLS-DHE-DSS-WITH-3DES-EDE-CBC-SHA", "TLS-DHE-DSS-WITH-DES-CBC-SHA",
                    "TLS-AES-128-GCM-SHA256", "TLS-AES-256-GCM-SHA384", "TLS-CHACHA20-POLY1305-SHA256", "TLS-ECDHE-ECDSA-WITH-AES-256-CBC-SHA"
                ],
                "type": "str"
            },
            "priority": {"required": true, "type": "int"},
            "versions": {"type": "list", "choices": ["ssl-3.0", "tls-1.0", "tls-1.1", "tls-1.2", "tls-1.3"], "elements": "str"}
        }
    },
    "firewall_vipgrp": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comments": {"type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "color": {"type": "int"},
                    "comments": {"type": "str"},
                    "interface": {"type": "str"},
                    "member": {"type": "raw"},
                    "uuid": {"type": "str"}
                },
                "elements": "dict"
            },
            "interface": {"type": "str"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "uuid": {"type": "str"}
        }
    },
    "firewall_vipgrp46": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comments": {"type": "str"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "uuid": {"type": "str"}
        }
    },
    "firewall_vipgrp6": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comments": {"type": "str"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "uuid": {"type": "str"}
        }
    },
    "firewall_vipgrp64": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comments": {"type": "str"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "uuid": {"type": "str"}
        }
    },
    "firewall_vipgrp_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
            "color": {"type": "int"},
            "comments": {"type": "str"},
            "interface": {"type": "str"},
            "member": {"type": "raw"},
            "uuid": {"type": "str"}
        }
    },
    "firewall_wildcardfqdn_custom": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "name": {"required": true, "type": "str"},
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "wildcard-fqdn": {"type": "str"}
        }
    },
    "firewall_wildcardfqdn_group": {
        "stated": true,
        "options": {
            "color": {"type": "int"},
            "comment": {"type": "str"},
            "member": {"type": "raw"},
            "name": {"required": true, "type": "str"},
            "uuid": {"type": "str"},
            "visibility": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmg_device_blueprint": {
        "stated": true,
        "options": {
            "cliprofs": {"v_range": [["7.2.0", ""]], "type": "raw"},
            "description": {"v_range": [["7.2.0", ""]], "type": "str"},
            "dev-group": {"v_range": [["7.2.0", ""]], "type": "raw"},
            "folder": {"v_range": [["7.2.0", ""]], "type": "str"},
            "name": {"v_range": [["7.2.0", ""]], "required": true, "type": "str"},
            "pkg": {"v_range": [["7.2.0", ""]], "type": "str"},
            "platform": {"v_range": [["7.2.0", ""]], "type": "str"},
            "prefer-img-ver": {"v_range": [["7.2.0", ""]], "type": "str"},
            "prerun-cliprof": {"v_range": [["7.2.0", ""]], "type": "raw"},
            "prov-type": {"v_range": [["7.2.0", ""]], "choices": ["none", "templates", "template-group"], "type": "str"},
            "template-group": {"v_range": [["7.2.0", ""]], "type": "str"},
            "templates": {"v_range": [["7.2.0", ""]], "type": "raw"},
            "enforce-device-config": {"v_range": [["7.2.5", "7.2.11"], ["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "auth-template": {"v_range": [["7.4.1", ""]], "type": "raw"},
            "ha-config": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "ha-hbdev": {"v_range": [["7.4.1", ""]], "type": "raw"},
            "ha-monitor": {"v_range": [["7.4.1", ""]], "type": "raw"},
            "ha-password": {"v_range": [["7.4.1", ""]], "no_log": true, "type": "raw"},
            "linked-to-model": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "port-provisioning": {"v_range": [["7.4.4", ""]], "type": "int"},
            "sdwan-management": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "split-switch-port": {"v_range": [["7.4.4", ""]], "choices": ["disable", "enable"], "type": "str"},
            "vm-log-disk": {"v_range": [["7.6.2", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmg_fabric_authorization_template": {
        "stated": true,
        "options": {
            "description": {"v_range": [["7.2.1", ""]], "type": "str"},
            "extender-controller": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "name": {"v_range": [["7.2.1", ""]], "required": true, "type": "str"},
            "platforms": {
                "v_range": [["7.2.1", ""]],
                "type": "list",
                "options": {
                    "count": {"v_range": [["7.2.1", ""]], "type": "int"},
                    "extension-type": {"v_range": [["7.2.1", ""]], "choices": ["wan-extension", "lan-extension"], "type": "str"},
                    "fortilink": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "prefix": {"v_range": [["7.2.1", ""]], "type": "str"},
                    "type": {"v_range": [["7.2.1", ""]], "choices": ["ap", "extender", "switch"], "type": "str"}
                },
                "elements": "dict"
            },
            "switch-controller": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "wireless-controller": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmg_fabric_authorization_template_platforms": {
        "stated": true,
        "options": {
            "count": {"v_range": [["7.2.1", ""]], "type": "int"},
            "extension-type": {"v_range": [["7.2.1", ""]], "choices": ["wan-extension", "lan-extension"], "type": "str"},
            "fortilink": {"v_range": [["7.2.1", ""]], "type": "str"},
            "prefix": {"v_range": [["7.2.1", ""]], "type": "str"},
            "type": {"v_range": [["7.2.1", ""]], "choices": ["ap", "extender", "switch"], "type": "str"}
        }
    },
    "fmg_sasemanager_settings": {
        "stated": false,
        "options": {
            "address": {"v_range": [["7.6.0", "7.6.1"]], "type": "list", "elements": "str"},
            "profile-group": {"v_range": [["7.6.0", "7.6.1"]], "type": "list", "elements": "str"},
            "sync-address": {"v_range": [["7.6.0", "7.6.1"]], "choices": ["disable", "specify", "all"], "type": "str"},
            "sync-profile-group": {"v_range": [["7.6.0", "7.6.1"]], "choices": ["disable", "specify", "all"], "type": "str"},
            "sync-user": {"v_range": [["7.6.0", "7.6.1"]], "choices": ["disable", "specify", "all"], "type": "str"},
            "user": {"v_range": [["7.6.0", "7.6.1"]], "type": "list", "elements": "str"}
        }
    },
    "fmg_sasemanager_status": {
        "stated": false,
        "options": {
            "forticlient-ver": {"v_range": [["7.6.0", "7.6.1"]], "type": "str"},
            "forticloud-id": {"v_range": [["7.6.0", "7.6.1"]], "type": "int"},
            "license-type": {"v_range": [["7.6.0", "7.6.1"]], "choices": ["standard_license", "advanced_license", "comprehensive_license"], "type": "str"},
            "spa-hubs": {"v_range": [["7.6.0", "7.6.1"]], "type": "int"}
        }
    },
    "fmg_variable": {
        "stated": true,
        "options": {
            "description": {"v_range": [["7.2.0", ""]], "type": "str"},
            "dynamic_mapping": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "options": {
                    "_scope": {
                        "v_range": [["7.2.0", ""]],
                        "type": "list",
                        "options": {"name": {"v_range": [["7.2.0", ""]], "type": "str"}, "vdom": {"v_range": [["7.2.0", ""]], "type": "str"}},
                        "elements": "dict"
                    },
                    "value": {"v_range": [["7.2.0", ""]], "type": "str"}
                },
                "elements": "dict"
            },
            "name": {"v_range": [["7.2.0", ""]], "required": true, "type": "str"},
            "value": {"v_range": [["7.2.0", ""]], "type": "str"}
        }
    },
    "fmg_variable_dynamicmapping": {
        "stated": true,
        "options": {
            "_scope": {
                "v_range": [["7.2.0", ""]],
                "type": "list",
                "options": {"name": {"v_range": [["7.2.0", ""]], "type": "str"}, "vdom": {"v_range": [["7.2.0", ""]], "type": "str"}},
                "elements": "dict"
            },
            "value": {"v_range": [["7.2.0", ""]], "type": "str"}
        }
    },
    "fmupdate_analyzer_virusreport": {"stated": false, "options": {"status": {"choices": ["disable", "enable"], "type": "str"}}},
    "fmupdate_avips_advancedlog": {
        "stated": false,
        "options": {"log-fortigate": {"choices": ["disable", "enable"], "type": "str"}, "log-server": {"choices": ["disable", "enable"], "type": "str"}}
    },
    "fmupdate_avips_webproxy": {
        "stated": false,
        "options": {
            "ip": {"v_range": [["6.0.0", "6.2.1"]], "type": "str"},
            "ip6": {"v_range": [["6.0.0", "6.2.1"]], "type": "str"},
            "mode": {"v_range": [["6.0.0", "7.4.0"]], "choices": ["proxy", "tunnel"], "type": "str"},
            "password": {"v_range": [["6.0.0", "7.4.0"]], "no_log": true, "type": "raw"},
            "port": {"v_range": [["6.0.0", "7.4.0"]], "type": "int"},
            "status": {"v_range": [["6.0.0", "7.4.0"]], "choices": ["disable", "enable"], "type": "str"},
            "username": {"v_range": [["6.0.0", "7.4.0"]], "type": "str"},
            "address": {"v_range": [["6.2.2", "7.4.0"]], "type": "str"}
        }
    },
    "fmupdate_customurllist": {
        "stated": false,
        "options": {"db_selection": {"type": "list", "choices": ["both", "custom-url", "fortiguard-db"], "elements": "str"}}
    },
    "fmupdate_diskquota": {"stated": false, "options": {"value": {"type": "int"}}},
    "fmupdate_fctservices": {"stated": false, "options": {"port": {"type": "int"}, "status": {"choices": ["disable", "enable"], "type": "str"}}},
    "fmupdate_fdssetting": {
        "stated": false,
        "options": {
            "User-Agent": {"type": "str"},
            "fds-clt-ssl-protocol": {"choices": ["sslv3", "tlsv1.0", "tlsv1.1", "tlsv1.2", "tlsv1.3"], "type": "str"},
            "fds-ssl-protocol": {"choices": ["sslv3", "tlsv1.0", "tlsv1.1", "tlsv1.2", "tlsv1.3"], "type": "str"},
            "fmtr-log": {"choices": ["emergency", "alert", "critical", "error", "warn", "notice", "info", "debug", "disable"], "type": "str"},
            "linkd-log": {"choices": ["emergency", "alert", "critical", "error", "warn", "notice", "info", "debug", "disable"], "type": "str"},
            "max-av-ips-version": {"type": "int"},
            "max-work": {"type": "int"},
            "push-override": {
                "type": "dict",
                "options": {"ip": {"type": "str"}, "port": {"type": "int"}, "status": {"choices": ["disable", "enable"], "type": "str"}}
            },
            "push-override-to-client": {
                "type": "dict",
                "options": {
                    "announce-ip": {
                        "type": "list",
                        "options": {"id": {"type": "int"}, "ip": {"type": "str"}, "port": {"type": "int"}},
                        "elements": "dict"
                    },
                    "status": {"choices": ["disable", "enable"], "type": "str"}
                }
            },
            "send_report": {"choices": ["disable", "enable"], "type": "str"},
            "send_setup": {"choices": ["disable", "enable"], "type": "str"},
            "server-override": {
                "type": "dict",
                "options": {
                    "servlist": {
                        "type": "list",
                        "options": {
                            "id": {"type": "int"},
                            "ip": {"type": "str"},
                            "ip6": {"type": "str"},
                            "port": {"type": "int"},
                            "service-type": {"type": "raw", "choices": ["fds", "fct", "fai"]}
                        },
                        "elements": "dict"
                    },
                    "status": {"choices": ["disable", "enable"], "type": "str"}
                }
            },
            "system-support-fct": {
                "type": "list",
                "choices": ["4.x", "5.0", "5.2", "5.4", "5.6", "6.0", "6.2", "6.4", "7.0", "7.2", "7.4"],
                "elements": "str"
            },
            "system-support-fgt": {"type": "list", "choices": ["5.4", "5.6", "6.0", "6.2", "6.4", "7.0", "7.2", "7.4", "7.6"], "elements": "str"},
            "system-support-fml": {"type": "list", "choices": ["4.x", "5.x", "6.x", "6.0", "6.2", "6.4", "7.0", "7.2", "7.x"], "elements": "str"},
            "system-support-fsa": {"type": "list", "choices": ["1.x", "2.x", "3.x", "4.x", "3.0", "3.1", "3.2"], "elements": "str"},
            "system-support-fsw": {
                "v_range": [["6.0.0", "6.4.5"], ["7.0.0", "7.0.0"]],
                "type": "list",
                "choices": ["5.4", "5.6", "6.0", "6.2", "4.x", "5.0", "5.2", "6.4"],
                "elements": "str"
            },
            "umsvc-log": {"choices": ["emergency", "alert", "critical", "error", "warn", "notice", "info", "debug", "disable"], "type": "str"},
            "unreg-dev-option": {"choices": ["ignore", "svc-only", "add-service"], "type": "str"},
            "update-schedule": {
                "type": "dict",
                "options": {
                    "day": {"choices": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], "type": "str"},
                    "frequency": {"choices": ["every", "daily", "weekly"], "type": "str"},
                    "status": {"choices": ["disable", "enable"], "type": "str"},
                    "time": {"type": "raw"}
                }
            },
            "wanip-query-mode": {"choices": ["disable", "ipify"], "type": "str"},
            "fortiguard-anycast": {"v_range": [["6.4.0", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fortiguard-anycast-source": {"v_range": [["6.4.0", ""]], "choices": ["fortinet", "aws"], "type": "str"},
            "system-support-fdc": {
                "v_range": [["6.4.6", "6.4.15"], ["7.0.1", ""]],
                "type": "list",
                "choices": ["3.x", "4.x", "5.x", "6.x"],
                "elements": "str"
            },
            "system-support-fts": {"v_range": [["6.4.6", "6.4.15"], ["7.0.1", ""]], "type": "list", "choices": ["3.x", "4.x", "7.x"], "elements": "str"},
            "system-support-faz": {"v_range": [["7.0.7", "7.0.14"], ["7.2.2", ""]], "type": "list", "choices": ["6.x", "7.x"], "elements": "str"},
            "system-support-fis": {"v_range": [["7.4.0", ""]], "type": "list", "choices": ["1.x", "2.x"], "elements": "str"},
            "system-support-fai": {"v_range": [["7.6.0", ""]], "type": "list", "choices": ["7.x"], "elements": "str"}
        }
    },
    "fmupdate_fdssetting_pushoverride": {
        "stated": false,
        "options": {"ip": {"type": "str"}, "port": {"type": "int"}, "status": {"choices": ["disable", "enable"], "type": "str"}}
    },
    "fmupdate_fdssetting_pushoverridetoclient": {
        "stated": false,
        "options": {
            "announce-ip": {"type": "list", "options": {"id": {"type": "int"}, "ip": {"type": "str"}, "port": {"type": "int"}}, "elements": "dict"},
            "status": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_fdssetting_pushoverridetoclient_announceip": {
        "stated": true,
        "options": {"id": {"required": true, "type": "int"}, "ip": {"type": "str"}, "port": {"type": "int"}}
    },
    "fmupdate_fdssetting_serveroverride": {
        "stated": false,
        "options": {
            "servlist": {
                "type": "list",
                "options": {
                    "id": {"type": "int"},
                    "ip": {"type": "str"},
                    "ip6": {"type": "str"},
                    "port": {"type": "int"},
                    "service-type": {"type": "raw", "choices": ["fds", "fct", "fai"]}
                },
                "elements": "dict"
            },
            "status": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_fdssetting_serveroverride_servlist": {
        "stated": true,
        "options": {
            "id": {"required": true, "type": "int"},
            "ip": {"type": "str"},
            "ip6": {"type": "str"},
            "port": {"type": "int"},
            "service-type": {"type": "raw", "choices": ["fds", "fct", "fai"]}
        }
    },
    "fmupdate_fdssetting_updateschedule": {
        "stated": false,
        "options": {
            "day": {"choices": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], "type": "str"},
            "frequency": {"choices": ["every", "daily", "weekly"], "type": "str"},
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "time": {"type": "raw"}
        }
    },
    "fmupdate_fgdsetting": {
        "stated": false,
        "options": {
            "as-cache": {"v_range": [["7.6.3", ""]], "type": "int"},
            "as-log": {"v_range": [["7.6.3", ""]], "choices": ["disable", "nospam", "all"], "type": "str"},
            "as-preload": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "av-cache": {"v_range": [["7.6.3", ""]], "type": "int"},
            "av-log": {"v_range": [["7.6.3", ""]], "choices": ["disable", "novirus", "all"], "type": "str"},
            "av-preload": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "av2-cache": {"v_range": [["7.6.3", ""]], "type": "int"},
            "av2-log": {"v_range": [["7.6.3", ""]], "choices": ["disable", "noav2", "all"], "type": "str"},
            "av2-preload": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "eventlog-query": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fgd-pull-interval": {"v_range": [["7.6.3", ""]], "type": "int"},
            "fq-cache": {"v_range": [["7.6.3", ""]], "type": "int"},
            "fq-log": {"v_range": [["7.6.3", ""]], "choices": ["disable", "nofilequery", "all"], "type": "str"},
            "fq-preload": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "iot-cache": {"v_range": [["7.6.3", ""]], "type": "int"},
            "iot-log": {"v_range": [["7.6.3", ""]], "choices": ["disable", "noiot", "all"], "type": "str"},
            "iot-preload": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "iotv-preload": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "linkd-log": {
                "v_range": [["7.6.3", ""]],
                "choices": ["emergency", "alert", "critical", "error", "warn", "notice", "info", "debug", "disable"],
                "type": "str"
            },
            "max-client-worker": {"v_range": [["7.6.3", ""]], "type": "int"},
            "max-log-quota": {"v_range": [["7.6.3", ""]], "type": "int"},
            "max-unrated-site": {"v_range": [["7.6.3", ""]], "type": "int"},
            "restrict-as1-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "restrict-as2-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "restrict-as4-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "restrict-av-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "restrict-av2-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "restrict-fq-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "restrict-iots-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "restrict-wf-dbver": {"v_range": [["7.6.3", ""]], "type": "str"},
            "server-override": {
                "v_range": [["7.6.3", ""]],
                "type": "dict",
                "options": {
                    "servlist": {
                        "v_range": [["7.6.3", ""]],
                        "type": "list",
                        "options": {
                            "id": {"v_range": [["7.6.3", ""]], "type": "int"},
                            "ip": {"v_range": [["7.6.3", ""]], "type": "str"},
                            "ip6": {"v_range": [["7.6.3", ""]], "type": "str"},
                            "port": {"v_range": [["7.6.3", ""]], "type": "int"},
                            "service-type": {"v_range": [["7.6.3", ""]], "choices": ["fgd", "fsa", "fgfq", "geoip", "iot-collect"], "type": "str"}
                        },
                        "elements": "dict"
                    },
                    "status": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "stat-log": {
                "v_range": [["7.6.3", ""]],
                "choices": ["emergency", "alert", "critical", "error", "warn", "notice", "info", "debug", "disable"],
                "type": "str"
            },
            "stat-log-interval": {"v_range": [["7.6.3", ""]], "type": "int"},
            "stat-sync-interval": {"v_range": [["7.6.3", ""]], "type": "int"},
            "update-interval": {"v_range": [["7.6.3", ""]], "type": "int"},
            "update-log": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"},
            "wf-cache": {"v_range": [["7.6.3", ""]], "type": "int"},
            "wf-dn-cache-expire-time": {"v_range": [["7.6.3", ""]], "type": "int"},
            "wf-dn-cache-max-number": {"v_range": [["7.6.3", ""]], "type": "int"},
            "wf-log": {"v_range": [["7.6.3", ""]], "choices": ["disable", "nourl", "all"], "type": "str"},
            "wf-preload": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_fgdsetting_serveroverride": {
        "stated": false,
        "options": {
            "servlist": {
                "v_range": [["7.6.3", ""]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["7.6.3", ""]], "type": "int"},
                    "ip": {"v_range": [["7.6.3", ""]], "type": "str"},
                    "ip6": {"v_range": [["7.6.3", ""]], "type": "str"},
                    "port": {"v_range": [["7.6.3", ""]], "type": "int"},
                    "service-type": {"v_range": [["7.6.3", ""]], "choices": ["fgd", "fsa", "fgfq", "geoip", "iot-collect"], "type": "str"}
                },
                "elements": "dict"
            },
            "status": {"v_range": [["7.6.3", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_fwmsetting": {
        "stated": false,
        "options": {
            "fds-image-timeout": {"v_range": [["6.2.2", ""]], "type": "int"},
            "max-fds-retry": {"v_range": [["6.2.2", "6.2.3"]], "type": "int"},
            "multiple-steps-interval": {"v_range": [["6.2.2", ""]], "type": "int"},
            "skip-disk-check": {"v_range": [["6.2.2", "6.2.3"]], "choices": ["disable", "enable"], "type": "str"},
            "auto-scan-fgt-disk": {"v_range": [["6.2.5", ""]], "choices": ["disable", "enable"], "type": "str"},
            "check-fgt-disk": {"v_range": [["6.2.5", ""]], "choices": ["disable", "enable"], "type": "str"},
            "fds-failover-fmg": {"v_range": [["6.2.5", ""]], "choices": ["disable", "enable"], "type": "str"},
            "immx-source": {"v_range": [["6.4.2", ""]], "choices": ["fmg", "fgt", "cloud"], "type": "str"},
            "log": {"v_range": [["6.4.8", "6.4.15"], ["7.0.1", ""]], "choices": ["fwm", "fwm_dm", "fwm_dm_json"], "type": "str"},
            "upgrade-timeout": {
                "v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]],
                "type": "dict",
                "options": {
                    "check-status-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "ctrl-check-status-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "ctrl-put-image-by-fds-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "ha-sync-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "license-check-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "prepare-image-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "put-image-by-fds-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "put-image-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "reboot-of-fsck-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "reboot-of-upgrade-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "retrieve-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "rpc-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "total-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
                    "health-check-timeout": {"v_range": [["7.4.2", ""]], "type": "int"}
                }
            },
            "retry-interval": {"v_range": [["7.0.10", "7.0.14"], ["7.2.5", "7.2.11"], ["7.4.2", ""]], "type": "int"},
            "retry-max": {"v_range": [["7.0.10", "7.0.14"], ["7.2.5", "7.2.11"], ["7.4.2", ""]], "type": "int"},
            "health-check": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "max-device-history": {"v_range": [["7.4.2", ""]], "type": "int"},
            "max-profile-history": {"v_range": [["7.4.2", ""]], "type": "int"},
            "retrieve": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "revision-diff": {"v_range": [["7.4.2", ""]], "choices": ["disable", "enable"], "type": "str"},
            "send-image-retry": {"v_range": [["7.2.6", "7.2.11"], ["7.4.4", "7.4.7"], ["7.6.2", ""]], "type": "int"}
        }
    },
    "fmupdate_fwmsetting_upgradetimeout": {
        "stated": false,
        "options": {
            "check-status-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "ctrl-check-status-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "ctrl-put-image-by-fds-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "ha-sync-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "license-check-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "prepare-image-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "put-image-by-fds-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "put-image-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "reboot-of-fsck-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "reboot-of-upgrade-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "retrieve-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "rpc-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "total-timeout": {"v_range": [["7.0.5", "7.0.14"], ["7.2.2", ""]], "type": "int"},
            "health-check-timeout": {"v_range": [["7.4.2", ""]], "type": "int"}
        }
    },
    "fmupdate_multilayer": {"stated": false, "options": {"webspam-rating": {"choices": ["disable", "enable"], "type": "str"}}},
    "fmupdate_publicnetwork": {
        "stated": false,
        "options": {
            "status": {"choices": ["disable", "enable"], "type": "str"},
            "update-server-location": {"v_range": [["7.6.2", ""]], "choices": ["global", "usa", "eu"], "type": "str"}
        }
    },
    "fmupdate_serveraccesspriorities": {
        "stated": false,
        "options": {
            "access-public": {"choices": ["disable", "enable"], "type": "str"},
            "av-ips": {"choices": ["disable", "enable"], "type": "str"},
            "private-server": {
                "type": "list",
                "options": {"id": {"type": "int"}, "ip": {"type": "str"}, "ip6": {"type": "str"}, "time_zone": {"type": "int"}},
                "elements": "dict"
            },
            "web-spam": {"choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_serveraccesspriorities_privateserver": {
        "stated": true,
        "options": {"id": {"required": true, "type": "int"}, "ip": {"type": "str"}, "ip6": {"type": "str"}, "time_zone": {"type": "int"}}
    },
    "fmupdate_serveroverridestatus": {"stated": false, "options": {"mode": {"choices": ["strict", "loose"], "type": "str"}}},
    "fmupdate_service": {
        "stated": false,
        "options": {
            "avips": {"choices": ["disable", "enable"], "type": "str"},
            "query-antispam": {"choices": ["disable", "enable"], "type": "str"},
            "query-antivirus": {"choices": ["disable", "enable"], "type": "str"},
            "query-filequery": {"choices": ["disable", "enable"], "type": "str"},
            "query-geoip": {"v_range": [["6.0.0", "6.4.1"]], "choices": ["disable", "enable"], "type": "str"},
            "query-outbreak-prevention": {"choices": ["disable", "enable"], "type": "str"},
            "query-webfilter": {"choices": ["disable", "enable"], "type": "str"},
            "webfilter-https-traversal": {"choices": ["disable", "enable"], "type": "str"},
            "query-iot": {"v_range": [["6.4.6", "6.4.15"], ["7.0.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "query-iot-collection": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "query-iot-vulnerability": {"v_range": [["7.4.1", ""]], "choices": ["disable", "enable"], "type": "str"},
            "query-ioc": {"v_range": [["7.6.0", ""]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_webspam_fgdsetting": {
        "stated": false,
        "options": {
            "as-cache": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "as-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "nospam", "all"], "type": "str"},
            "as-preload": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "av-cache": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "av-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "novirus", "all"], "type": "str"},
            "av-preload": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "av2-cache": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "av2-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "noav2", "all"], "type": "str"},
            "av2-preload": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "eventlog-query": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "fgd-pull-interval": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "fq-cache": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "fq-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "nofilequery", "all"], "type": "str"},
            "fq-preload": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "linkd-log": {
                "v_range": [["6.0.0", "7.6.2"]],
                "choices": ["emergency", "alert", "critical", "error", "warn", "notice", "info", "debug", "disable"],
                "type": "str"
            },
            "max-client-worker": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "max-log-quota": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "max-unrated-site": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "restrict-as1-dbver": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "restrict-as2-dbver": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "restrict-as4-dbver": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "restrict-av-dbver": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "restrict-av2-dbver": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "restrict-fq-dbver": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "restrict-wf-dbver": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "server-override": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "dict",
                "options": {
                    "servlist": {
                        "v_range": [["6.0.0", "7.6.2"]],
                        "type": "list",
                        "options": {
                            "id": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
                            "ip": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                            "ip6": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                            "port": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
                            "service-type": {
                                "v_range": [["6.0.0", "7.6.2"]],
                                "type": "raw",
                                "choices": ["fgd", "fgc", "fsa", "fgfq", "geoip", "iot-collect"]
                            }
                        },
                        "elements": "dict"
                    },
                    "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
                }
            },
            "stat-log-interval": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "stat-sync-interval": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "update-interval": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "update-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "wf-cache": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "wf-dn-cache-expire-time": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "wf-dn-cache-max-number": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "wf-log": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "nourl", "all"], "type": "str"},
            "wf-preload": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "iot-cache": {"v_range": [["6.4.6", "6.4.15"], ["7.0.1", "7.6.2"]], "type": "int"},
            "iot-log": {"v_range": [["6.4.6", "6.4.15"], ["7.0.1", "7.6.2"]], "choices": ["disable", "nofilequery", "all", "noiot"], "type": "str"},
            "iot-preload": {"v_range": [["6.4.6", "6.4.15"], ["7.0.1", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"},
            "restrict-iots-dbver": {"v_range": [["6.4.6", "6.4.15"], ["7.0.1", "7.6.2"]], "type": "str"},
            "stat-log": {
                "v_range": [["7.0.10", "7.0.14"], ["7.2.5", "7.2.11"], ["7.4.2", "7.6.2"]],
                "choices": ["emergency", "alert", "critical", "error", "warn", "notice", "info", "debug", "disable"],
                "type": "str"
            },
            "iotv-preload": {"v_range": [["7.2.2", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_webspam_fgdsetting_serveroverride": {
        "stated": false,
        "options": {
            "servlist": {
                "v_range": [["6.0.0", "7.6.2"]],
                "type": "list",
                "options": {
                    "id": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
                    "ip": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "ip6": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
                    "port": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
                    "service-type": {"v_range": [["6.0.0", "7.6.2"]], "type": "raw", "choices": ["fgd", "fgc", "fsa", "fgfq", "geoip", "iot-collect"]}
                },
                "elements": "dict"
            },
            "status": {"v_range": [["6.0.0", "7.6.2"]], "choices": ["disable", "enable"], "type": "str"}
        }
    },
    "fmupdate_webspam_fgdsetting_serveroverride_servlist": {
        "stated": true,
        "options": {
            "id": {"v_range": [["6.0.0", "7.6.2"]], "required": true, "type": "int"},
            "ip": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "ip6": {"v_range": [["6.0.0", "7.6.2"]], "type": "str"},
            "port": {"v_range": [["6.0.0", "7.6.2"]], "type": "int"},
            "service-type": {"v_range": [["6.0.0", "7.6.2"]], "type": "raw", "choices": ["fgd", "fgc", "fsa", "fgfq", "geoip", "iot-collect"]}
        }
    },
    "fmupdate_webspam_webproxy": {
        "stated": false,
        "options": {
            "ip": {"v_range": [["6.0.0", "6.2.1"]], "type": "str"},
            "ip6": {"v_range": [["6.0.0", "6.2.1"]], "type": "str"},
            "mode": {"v_range": [["6.0.0", "7.4.0"]], "choices": ["proxy", "tunnel"], "type": "str"},
            "password": {"v_range": [["6.0.0", "7.4.0"]], "no_log": true, "type": "raw"},
            "port": {"v_range": [["6.0.0", "7.4.0"]], "type": "int"},
            "status": {"v_range": [["6.0.0", "7.4.0"]], "choices": ["disable", "enable"], "type": "str"},
            "username": {"v_range": [["6.0.0", "7.4.0"]], "type": "str"},
            "address": {"v_range": [["6.2.2", "7.4.0"]], "type": "str"}
        }
    },
    "fsp_vlan": {
        "stated": true,
        "options": {
            "_dhcp-status": {"choices": ["disable", "enable"], "type": "str"},
            "auth": {"v_range": [["6.0.0", "6.2.1"]], "choices": ["radius", "usergroup"], "type": "str"},
            "color": {"type": "int"},
            "comments": {"v_range": [["6.0.0", "6.2.1"]], "type": "str"},
            "dynamic_mapping": {
                "type": "list",
                "options": {
                    "_dhcp-status": {"choices": ["disable", "enable"], "type": "str"},
                    "_scope": {"type": "list", "options": {"name": {"type": "str"}, "vdom": {"type": "str"}}, "elements": "dict"},
                    "dhcp-server": {
                        "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                        "type": "dict",
                        "options": {
                            "auto-configuration": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "auto-managed-status": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "conflicted-ip-timeout": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                            "ddns-auth": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "tsig"], "type": "str"},
                            "ddns-key": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "no_log": true, "type": "raw"},
                            "ddns-keyname": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "no_log": true, "type": "str"},
                            "ddns-server-ip": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "ddns-ttl": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                            "ddns-update": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "ddns-update-override": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "ddns-zone": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "default-gateway": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "dhcp-settings-from-fortiipam": {"v_range": [["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "dns-server1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "dns-server2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "dns-server3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "dns-server4": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "dns-service": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["default", "specify", "local"], "type": "str"},
                            "domain": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "enable": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["disable", "enable"], "type": "str"},
                            "exclude-range": {
                                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                                "type": "list",
                                "options": {
                                    "end-ip": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                                    "id": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                                    "start-ip": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                                    "vci-match": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "vci-string": {"v_range": [["7.2.1", ""]], "type": "raw"},
                                    "lease-time": {"v_range": [["7.2.2", ""]], "type": "int"},
                                    "uci-match": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "uci-string": {"v_range": [["7.2.2", ""]], "type": "raw"}
                                },
                                "elements": "dict"
                            },
                            "filename": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "forticlient-on-net-status": {
                                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                                "choices": ["disable", "enable"],
                                "type": "str"
                            },
                            "id": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                            "ip-mode": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["range", "usrgrp"], "type": "str"},
                            "ip-range": {
                                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                                "type": "list",
                                "options": {
                                    "end-ip": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                                    "id": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                                    "start-ip": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                                    "vci-match": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "vci-string": {"v_range": [["7.2.1", ""]], "type": "raw"},
                                    "lease-time": {"v_range": [["7.2.2", ""]], "type": "int"},
                                    "uci-match": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "uci-string": {"v_range": [["7.2.2", ""]], "type": "raw"}
                                },
                                "elements": "dict"
                            },
                            "ipsec-lease-hold": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                            "lease-time": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                            "mac-acl-default-action": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["assign", "block"], "type": "str"},
                            "netmask": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "next-server": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "ntp-server1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "ntp-server2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "ntp-server3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "ntp-service": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["default", "specify", "local"], "type": "str"},
                            "option1": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                            "option2": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                            "option3": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                            "option4": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "option5": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "option6": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                            "options": {
                                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                                "type": "list",
                                "options": {
                                    "code": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                                    "id": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "int"},
                                    "ip": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "raw"},
                                    "type": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "choices": ["hex", "string", "ip", "fqdn"], "type": "str"},
                                    "value": {"v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]], "type": "str"},
                                    "vci-match": {"v_range": [["7.2.1", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "vci-string": {"v_range": [["7.2.1", ""]], "type": "raw"},
                                    "uci-match": {"v_range": [["7.2.2", ""]], "choices": ["disable", "enable"], "type": "str"},
                                    "uci-string": {"v_range": [["7.2.2", ""]], "type": "raw"}
                                },
                                "elements": "dict"
                            },
                            "reserved-address": {
                                "v_range": [["6.2.8", "6.2.13"], ["6.4.5", ""]],
                                "type": "list