/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.UnaryOp;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;

class Distinct
extends UnaryOp {
    private static final long serialVersionUID = 1L;

    public Distinct(Val val) {
        super(val, true);
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return this.initializeValue(sel, ctx, 4);
    }

    @Override
    protected String getOperator() {
        return "DISTINCT";
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        Val val = this.getValue();
        if (val instanceof PCPath) {
            boolean noParen = this.getNoParen();
            sql2.append(this.getOperator());
            sql2.append(noParen ? " " : "(");
            ((PCPath)val).appendTo(sel, ctx, state, sql2);
            sql2.addCastForParam(this.getOperator(), val);
            if (!noParen) {
                sql2.append(")");
            }
        } else {
            super.appendTo(sel, ctx, state, sql2, index);
        }
    }
}

