/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableSupplier;

@Internal
public class SimpleVersionedSerializerTypeSerializerProxy<T>
extends TypeSerializer<T> {
    private final SerializableSupplier<SimpleVersionedSerializer<T>> serializerSupplier;
    private transient SimpleVersionedSerializer<T> cachedSerializer;

    public SimpleVersionedSerializerTypeSerializerProxy(SerializableSupplier<SimpleVersionedSerializer<T>> serializerSupplier) {
        this.serializerSupplier = Preconditions.checkNotNull(serializerSupplier, "serializerSupplier");
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<T> duplicate() {
        try {
            return new SimpleVersionedSerializerTypeSerializerProxy<T>(InstantiationUtil.clone(this.serializerSupplier, this.serializerSupplier.getClass().getClassLoader()));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Could not duplicate SimpleVersionedSerializer.", e);
        }
    }

    @Override
    public T createInstance() {
        return null;
    }

    @Override
    public T copy(T from) {
        SimpleVersionedSerializer<T> serializer = this.getSerializer();
        try {
            byte[] serializedFrom = serializer.serialize(from);
            return serializer.deserialize(serializer.getVersion(), serializedFrom);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy element.", e);
        }
    }

    @Override
    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        SimpleVersionedSerializer<T> serializer = this.getSerializer();
        SimpleVersionedSerialization.writeVersionAndSerialize(serializer, record, target);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        SimpleVersionedSerializer<T> serializer = this.getSerializer();
        return SimpleVersionedSerialization.readVersionAndDeSerialize(serializer, source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        T record = this.deserialize(source);
        this.serialize(record, target);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SimpleVersionedSerializerTypeSerializerProxy && ((SimpleVersionedSerializer)((SimpleVersionedSerializerTypeSerializerProxy)other).serializerSupplier.get()).equals(this.serializerSupplier.get());
    }

    @Override
    public int hashCode() {
        return ((SimpleVersionedSerializer)this.serializerSupplier.get()).hashCode();
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        throw new UnsupportedOperationException("SimpleVersionedSerializerWrapper is not meant to be used as a general TypeSerializer for state.");
    }

    private SimpleVersionedSerializer<T> getSerializer() {
        if (this.cachedSerializer != null) {
            return this.cachedSerializer;
        }
        this.cachedSerializer = (SimpleVersionedSerializer)this.serializerSupplier.get();
        return this.cachedSerializer;
    }
}

