/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement;
import io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirementBuilder;
import io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirementFluent;
import io.fabric8.kubernetes.api.model.TopologySelectorTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TopologySelectorTermFluent<A extends TopologySelectorTermFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<TopologySelectorLabelRequirementBuilder> matchLabelExpressions = new ArrayList();

    public TopologySelectorTermFluent() {
    }

    public TopologySelectorTermFluent(TopologySelectorTerm instance) {
        this.copyInstance(instance);
    }

    public A addAllToMatchLabelExpressions(Collection<TopologySelectorLabelRequirement> items) {
        if (this.matchLabelExpressions == null) {
            this.matchLabelExpressions = new ArrayList();
        }
        for (TopologySelectorLabelRequirement item : items) {
            TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
            this._visitables.get((Object)"matchLabelExpressions").add(builder);
            this.matchLabelExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public MatchLabelExpressionsNested<A> addNewMatchLabelExpression() {
        return new MatchLabelExpressionsNested(-1, null);
    }

    public MatchLabelExpressionsNested<A> addNewMatchLabelExpressionLike(TopologySelectorLabelRequirement item) {
        return new MatchLabelExpressionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMatchLabelExpressions(TopologySelectorLabelRequirement ... items) {
        if (this.matchLabelExpressions == null) {
            this.matchLabelExpressions = new ArrayList();
        }
        for (TopologySelectorLabelRequirement item : items) {
            TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
            this._visitables.get((Object)"matchLabelExpressions").add(builder);
            this.matchLabelExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToMatchLabelExpressions(int index, TopologySelectorLabelRequirement item) {
        if (this.matchLabelExpressions == null) {
            this.matchLabelExpressions = new ArrayList();
        }
        TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
        if (index < 0 || index >= this.matchLabelExpressions.size()) {
            this._visitables.get((Object)"matchLabelExpressions").add(builder);
            this.matchLabelExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchLabelExpressions").add(builder);
            this.matchLabelExpressions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TopologySelectorLabelRequirement buildFirstMatchLabelExpression() {
        return this.matchLabelExpressions.get(0).build();
    }

    public TopologySelectorLabelRequirement buildLastMatchLabelExpression() {
        return this.matchLabelExpressions.get(this.matchLabelExpressions.size() - 1).build();
    }

    public TopologySelectorLabelRequirement buildMatchLabelExpression(int index) {
        return this.matchLabelExpressions.get(index).build();
    }

    public List<TopologySelectorLabelRequirement> buildMatchLabelExpressions() {
        return this.matchLabelExpressions != null ? TopologySelectorTermFluent.build(this.matchLabelExpressions) : null;
    }

    public TopologySelectorLabelRequirement buildMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
        for (TopologySelectorLabelRequirementBuilder item : this.matchLabelExpressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(TopologySelectorTerm instance) {
        TopologySelectorTerm topologySelectorTerm = instance = instance != null ? instance : new TopologySelectorTerm();
        if (instance != null) {
            this.withMatchLabelExpressions(instance.getMatchLabelExpressions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MatchLabelExpressionsNested<A> editFirstMatchLabelExpression() {
        if (this.matchLabelExpressions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "matchLabelExpressions"));
        }
        return this.setNewMatchLabelExpressionLike(0, this.buildMatchLabelExpression(0));
    }

    public MatchLabelExpressionsNested<A> editLastMatchLabelExpression() {
        int index = this.matchLabelExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "matchLabelExpressions"));
        }
        return this.setNewMatchLabelExpressionLike(index, this.buildMatchLabelExpression(index));
    }

    public MatchLabelExpressionsNested<A> editMatchLabelExpression(int index) {
        if (this.matchLabelExpressions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "matchLabelExpressions"));
        }
        return this.setNewMatchLabelExpressionLike(index, this.buildMatchLabelExpression(index));
    }

    public MatchLabelExpressionsNested<A> editMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchLabelExpressions.size(); ++i) {
            if (!predicate.test(this.matchLabelExpressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "matchLabelExpressions"));
        }
        return this.setNewMatchLabelExpressionLike(index, this.buildMatchLabelExpression(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopologySelectorTermFluent that = (TopologySelectorTermFluent)((Object)o);
        if (!Objects.equals(this.matchLabelExpressions, that.matchLabelExpressions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchLabelExpressions() {
        return this.matchLabelExpressions != null && !this.matchLabelExpressions.isEmpty();
    }

    public boolean hasMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
        for (TopologySelectorLabelRequirementBuilder item : this.matchLabelExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.matchLabelExpressions, this.additionalProperties);
    }

    public A removeAllFromMatchLabelExpressions(Collection<TopologySelectorLabelRequirement> items) {
        if (this.matchLabelExpressions == null) {
            return (A)((Object)this);
        }
        for (TopologySelectorLabelRequirement item : items) {
            TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
            this._visitables.get((Object)"matchLabelExpressions").remove((Object)builder);
            this.matchLabelExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromMatchLabelExpressions(TopologySelectorLabelRequirement ... items) {
        if (this.matchLabelExpressions == null) {
            return (A)((Object)this);
        }
        for (TopologySelectorLabelRequirement item : items) {
            TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
            this._visitables.get((Object)"matchLabelExpressions").remove((Object)builder);
            this.matchLabelExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatchLabelExpressions(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
        if (this.matchLabelExpressions == null) {
            return (A)((Object)this);
        }
        Iterator<TopologySelectorLabelRequirementBuilder> each = this.matchLabelExpressions.iterator();
        List visitables = this._visitables.get((Object)"matchLabelExpressions");
        while (each.hasNext()) {
            TopologySelectorLabelRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public MatchLabelExpressionsNested<A> setNewMatchLabelExpressionLike(int index, TopologySelectorLabelRequirement item) {
        return new MatchLabelExpressionsNested(index, item);
    }

    public A setToMatchLabelExpressions(int index, TopologySelectorLabelRequirement item) {
        if (this.matchLabelExpressions == null) {
            this.matchLabelExpressions = new ArrayList();
        }
        TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
        if (index < 0 || index >= this.matchLabelExpressions.size()) {
            this._visitables.get((Object)"matchLabelExpressions").add(builder);
            this.matchLabelExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchLabelExpressions").add(builder);
            this.matchLabelExpressions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchLabelExpressions != null && !this.matchLabelExpressions.isEmpty()) {
            sb.append("matchLabelExpressions:");
            sb.append(this.matchLabelExpressions);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withMatchLabelExpressions(List<TopologySelectorLabelRequirement> matchLabelExpressions) {
        if (this.matchLabelExpressions != null) {
            this._visitables.get((Object)"matchLabelExpressions").clear();
        }
        if (matchLabelExpressions != null) {
            this.matchLabelExpressions = new ArrayList();
            for (TopologySelectorLabelRequirement item : matchLabelExpressions) {
                this.addToMatchLabelExpressions(item);
            }
        } else {
            this.matchLabelExpressions = null;
        }
        return (A)((Object)this);
    }

    public A withMatchLabelExpressions(TopologySelectorLabelRequirement ... matchLabelExpressions) {
        if (this.matchLabelExpressions != null) {
            this.matchLabelExpressions.clear();
            this._visitables.remove((Object)"matchLabelExpressions");
        }
        if (matchLabelExpressions != null) {
            for (TopologySelectorLabelRequirement item : matchLabelExpressions) {
                this.addToMatchLabelExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public class MatchLabelExpressionsNested<N>
    extends TopologySelectorLabelRequirementFluent<MatchLabelExpressionsNested<N>>
    implements Nested<N> {
        TopologySelectorLabelRequirementBuilder builder;
        int index;

        MatchLabelExpressionsNested(int index, TopologySelectorLabelRequirement item) {
            this.index = index;
            this.builder = new TopologySelectorLabelRequirementBuilder(this, item);
        }

        public N and() {
            return (N)TopologySelectorTermFluent.this.setToMatchLabelExpressions(this.index, this.builder.build());
        }

        public N endMatchLabelExpression() {
            return this.and();
        }
    }
}

