/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.types.PhysicalNumericType$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.ArrayImplicits$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate `percentile` of the numeric or\n      ansi interval column `col` which is the smallest value in the ordered `col` values (sorted\n      from least to greatest) such that no more than `percentage` of `col` values is less than\n      the value or equal to that value. The value of percentage must be between 0.0 and 1.0.\n      The `accuracy` parameter (default: 10000) is a positive numeric literal which controls\n      approximation accuracy at the cost of memory. Higher value of `accuracy` yields better\n      accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col, array(0.5, 0.4, 0.1), 100) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [1,1,0]\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (0), (6), (7), (9), (10) AS tab(col);\n       7\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '1' MONTH), (INTERVAL '2' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-1\n      > SELECT _FUNC_(col, array(0.5, 0.7), 100) FROM VALUES (INTERVAL '0' SECOND), (INTERVAL '1' SECOND), (INTERVAL '2' SECOND), (INTERVAL '10' SECOND) AS tab(col);\n       [0 00:00:01.000000000,0 00:00:02.000000000]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0005\r\u001de\u0001B'O\u0001vC!\"!3\u0001\u0005+\u0007I\u0011\u0001B\u0012\u0011)\u0011)\u0003\u0001B\tB\u0003%\u00111\u001a\u0005\u000b\u0003+\u0004!Q3A\u0005\u0002\t\r\u0002B\u0003B\u0014\u0001\tE\t\u0015!\u0003\u0002L\"Q\u0011\u0011\u001c\u0001\u0003\u0016\u0004%\tAa\t\t\u0015\t%\u0002A!E!\u0002\u0013\tY\r\u0003\u0006\u0002^\u0002\u0011)\u001a!C!\u0003'A!Ba\u000b\u0001\u0005#\u0005\u000b\u0011BA\u000b\u0011)\t\t\u000f\u0001BK\u0002\u0013\u0005\u00131\u0003\u0005\u000b\u0005[\u0001!\u0011#Q\u0001\n\u0005U\u0001bBA\u0007\u0001\u0011\u0005!q\u0006\u0005\b\u0003\u001b\u0001A\u0011\u0001B\u001e\u0011\u001d\ti\u0001\u0001C\u0001\u0005\u0007B!B!\u0013\u0001\u0011\u000b\u0007I\u0011\u0002B&\u0011)\u0011\u0019\u0006\u0001EC\u0002\u0013%!Q\u000b\u0005\b\u0005;\u0002A\u0011\tB0\u00111\ti\u0004\u0001I\u0001\u0012\u000f\u0007K\u0011\u0002B8\u0011)\u00119\b\u0001EC\u0002\u0013%\u0011q\u000b\u0005\u000b\u0003\u0013\u0003\u0001R1A\u0005\n\te\u0004b\u0002B>\u0001\u0011\u0005#Q\u0010\u0005\b\u0005\u0017\u0003A\u0011\tBG\u0011\u001d\u0011y\t\u0001C!\u0005#Cq!!\u001b\u0001\t\u0003\u0012\u0019\u000bC\u0004\u0003*\u0002!\tEa+\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!Q\u0018\u0001\u0005B\t}\u0006b\u0002Bb\u0001\u0011\u0005#1\u0005\u0005\b\u0005\u000b\u0004A\u0011\tB\u0012\u0011\u001d\u00119\r\u0001C!\u0005GAqA!3\u0001\t\u0003\n9\u0006\u0003\u0006\u0003L\u0002A)\u0019!C\u0005\u0005\u001bDqA!6\u0001\t\u0003\u0012i\rC\u0004\u0003X\u0002!\tE!7\t\u000f\u0005\r\u0006\u0001\"\u0011\u0003l\"9\u00111\u0017\u0001\u0005B\t=\bb\u0002Bz\u0001\u0011E#Q\u001f\u0005\n\u0007\u0007\u0001\u0011\u0011!C\u0001\u0007\u000bA\u0011b!\u0005\u0001#\u0003%\taa\u0005\t\u0013\r%\u0002!%A\u0005\u0002\rM\u0001\"CB\u0016\u0001E\u0005I\u0011AB\n\u0011%\u0019i\u0003AI\u0001\n\u0003\u0019y\u0003C\u0005\u00044\u0001\t\n\u0011\"\u0001\u00040!I1Q\u0007\u0001\u0002\u0002\u0013\u00053q\u0007\u0005\n\u0007{\u0001\u0011\u0011!C\u0001\u0003'A\u0011ba\u0010\u0001\u0003\u0003%\ta!\u0011\t\u0013\r\u0015\u0003!!A\u0005B\r\u001d\u0003\"CB+\u0001\u0005\u0005I\u0011AB,\u0011%\u0019Y\u0006AA\u0001\n\u0003\u001ai\u0006C\u0005\u0004b\u0001\t\t\u0011\"\u0011\u0004d\u001d)QO\u0014E\u0001m\u001a)QJ\u0014E\u0001o\"9\u0011QB\u001a\u0005\u0002\u0005=\u0001\"CA\tg\t\u0007I\u0011AA\n\u0011!\tYb\rQ\u0001\n\u0005UaABA\u000fg\u0001\ty\u0002\u0003\u0006\u0002\"]\u0012\t\u0019!C\u0005\u0003GA!\"!\r8\u0005\u0003\u0007I\u0011BA\u001a\u0011)\tyd\u000eB\u0001B\u0003&\u0011Q\u0005\u0005\b\u0003\u001b9D\u0011AA!\u0011\u001d\tia\u000eC\u0001\u0003\u0013B\u0001\"!\u00168\t\u0003!\u0016q\u000b\u0005\b\u0003?:D\u0011AA\u0012\u0011\u001d\t\tg\u000eC\u0001\u0003GBq!!\u001b8\t\u0003\tY\u0007C\u0004\u0002r]\"\t!a\u001d\t\u000f\u0005Eu\u0007\"\u0004\u0002\u0014\u001a1\u0011QS\u001a\u0001\u0003/Cq!!\u0004D\t\u0003\tI\nC\u0004\u0002\u001e\u000e#i!a(\t\u000f\u0005\r6\t\"\u0002\u0002&\"9\u00111W\"\u0005\u0006\u0005U\u0006\"CA^g\t\u0007I\u0011AA_\u0011!\tyl\rQ\u0001\n\u0005m\u0005\"CAag\u0005\u0005I\u0011QAb\u0011%\t\u0019oMA\u0001\n\u0003\u000b)\u000fC\u0005\u0002xN\n\t\u0011\"\u0003\u0002z\n)\u0012\t\u001d9s_bLW.\u0019;f!\u0016\u00148-\u001a8uS2,'BA(Q\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002R%\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019F+\u0001\u0005dCR\fG._:u\u0015\t)f+A\u0002tc2T!a\u0016-\u0002\u000bM\u0004\u0018M]6\u000b\u0005eS\u0016AB1qC\u000eDWMC\u0001\\\u0003\ry'oZ\u0002\u0001')\u0001aLa\u0002\u0003\u000e\te!q\u0004\t\u0004?\u0002\u0014W\"\u0001(\n\u0005\u0005t%\u0001\u0007+za\u0016$\u0017*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uKB\u00111m\u000e\b\u0003IJr!!\u001a;\u000f\u0005\u0019\u001chBA4s\u001d\tA\u0017O\u0004\u0002ja:\u0011!n\u001c\b\u0003W:l\u0011\u0001\u001c\u0006\u0003[r\u000ba\u0001\u0010:p_Rt\u0014\"A.\n\u0005eS\u0016BA,Y\u0013\t)f+\u0003\u0002T)&\u0011\u0011KU\u0005\u0003\u001fB\u000bQ#\u00119qe>D\u0018.\\1uKB+'oY3oi&dW\r\u0005\u0002`gM\u00191\u0007\u001f@\u0011\u0005edX\"\u0001>\u000b\u0003m\fQa]2bY\u0006L!! >\u0003\r\u0005s\u0017PU3g!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u000f\tAA[1wC&!\u00111BA\u0001\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\ta/A\u000eE\u000b\u001a\u000bU\u000b\u0014+`!\u0016\u00136)\u0012(U\u00132+u,Q\"D+J\u000b5)W\u000b\u0003\u0003+\u00012!_A\f\u0013\r\tIB\u001f\u0002\u0004\u0013:$\u0018\u0001\b#F\r\u0006+F\nV0Q\u000bJ\u001bUI\u0014+J\u0019\u0016{\u0016iQ\"V%\u0006\u001b\u0015\f\t\u0002\u0011!\u0016\u00148-\u001a8uS2,G)[4fgR\u001c\"a\u000e=\u0002\u0013M,X.\\1sS\u0016\u001cXCAA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016%\u0006!Q\u000f^5m\u0013\u0011\ty#!\u000b\u0003#E+\u0018M\u001c;jY\u0016\u001cV/\\7be&,7/A\u0007tk6l\u0017M]5fg~#S-\u001d\u000b\u0005\u0003k\tY\u0004E\u0002z\u0003oI1!!\u000f{\u0005\u0011)f.\u001b;\t\u0013\u0005u\u0012(!AA\u0002\u0005\u0015\u0012a\u0001=%c\u0005Q1/^7nCJLWm\u001d\u0011\u0015\t\u0005\r\u0013q\t\t\u0004\u0003\u000b:T\"A\u001a\t\u000f\u0005\u00052\b1\u0001\u0002&Q!\u00111IA&\u0011\u001d\ti\u0005\u0010a\u0001\u0003\u001f\nQB]3mCRLg/Z#se>\u0014\bcA=\u0002R%\u0019\u00111\u000b>\u0003\r\u0011{WO\u00197f\u00031I7oQ8naJ,7o]3e+\t\tI\u0006E\u0002z\u00037J1!!\u0018{\u0005\u001d\u0011un\u001c7fC:\f\u0011#];b]RLG.Z*v[6\f'/[3t\u0003\r\tG\r\u001a\u000b\u0005\u0003k\t)\u0007C\u0004\u0002h}\u0002\r!a\u0014\u0002\u000bY\fG.^3\u0002\u000b5,'oZ3\u0015\t\u0005U\u0012Q\u000e\u0005\b\u0003_\u0002\u0005\u0019AA\"\u0003\u0015yG\u000f[3s\u000399W\r\u001e)fe\u000e,g\u000e^5mKN$B!!\u001e\u0002\bB1\u0011qOAA\u0003\u001frA!!\u001f\u0002~9\u00191.a\u001f\n\u0003mL1!a {\u0003\u001d\u0001\u0018mY6bO\u0016LA!a!\u0002\u0006\n\u00191+Z9\u000b\u0007\u0005}$\u0010C\u0004\u0002\n\u0006\u0003\r!a#\u0002\u0017A,'oY3oi\u0006<Wm\u001d\t\u0006s\u00065\u0015qJ\u0005\u0004\u0003\u001fS(!B!se\u0006L\u0018\u0001C2p[B\u0014Xm]:\u0015\u0005\u0005U\"A\u0007)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\u0016\u0014\u0018.\u00197ju\u0016\u00148CA\"y)\t\tY\nE\u0002\u0002F\r\u000ba\u0001\\3oORDG\u0003BA\u000b\u0003CCq!!\tF\u0001\u0004\t)#A\u0005tKJL\u0017\r\\5{KR!\u0011qUAX!\u0015I\u0018QRAU!\rI\u00181V\u0005\u0004\u0003[S(\u0001\u0002\"zi\u0016Dq!!-G\u0001\u0004\t\u0019%A\u0002pE*\f1\u0002Z3tKJL\u0017\r\\5{KR!\u00111IA\\\u0011\u001d\tIl\u0012a\u0001\u0003O\u000bQAY=uKN\f!b]3sS\u0006d\u0017N_3s+\t\tY*A\u0006tKJL\u0017\r\\5{KJ\u0004\u0013!B1qa2LH\u0003DAc\u0003\u000f\f\u0019.a6\u0002\\\u0006}\u0007CA0\u0001\u0011\u001d\tIM\u0013a\u0001\u0003\u0017\fQa\u00195jY\u0012\u0004B!!4\u0002P6\t\u0001+C\u0002\u0002RB\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\t)N\u0013a\u0001\u0003\u0017\fA\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0007bBAm\u0015\u0002\u0007\u00111Z\u0001\u0013C\u000e\u001cWO]1ds\u0016C\bO]3tg&|g\u000eC\u0004\u0002^*\u0003\r!!\u0006\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRDq!!9K\u0001\u0004\t)\"\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9/a=\u0011\u000be\fI/!<\n\u0007\u0005-(P\u0001\u0004PaRLwN\u001c\t\u000es\u0006=\u00181ZAf\u0003\u0017\f)\"!\u0006\n\u0007\u0005E(P\u0001\u0004UkBdW-\u000e\u0005\n\u0003k\\\u0015\u0011!a\u0001\u0003\u000b\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u0010\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\u0011\u0011\t!!\u0002\u0002\t1\fgnZ\u0005\u0005\u0005\u000b\tyP\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u001b\u0014I!C\u0002\u0003\fA\u0013a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0007\u0005\u001f\u0011)\"a3\u000e\u0005\tE!b\u0001B\n%\u0006)AO]3fg&!!q\u0003B\t\u0005-!VM\u001d8befd\u0015n[3\u0011\u0007e\u0014Y\"C\u0002\u0003\u001ei\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002x\t\u0005\u0012\u0002BA\u0006\u0003\u000b+\"!a3\u0002\r\rD\u0017\u000e\u001c3!\u0003U\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0002\n1#Y2dkJ\f7-_#yaJ,7o]5p]\u0002\nq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uAQa\u0011Q\u0019B\u0019\u0005g\u0011)Da\u000e\u0003:!9\u0011\u0011Z\u0006A\u0002\u0005-\u0007bBAk\u0017\u0001\u0007\u00111\u001a\u0005\b\u00033\\\u0001\u0019AAf\u0011\u001d\tin\u0003a\u0001\u0003+Aq!!9\f\u0001\u0004\t)\u0002\u0006\u0005\u0002F\nu\"q\bB!\u0011\u001d\tI\r\u0004a\u0001\u0003\u0017Dq!!6\r\u0001\u0004\tY\rC\u0004\u0002Z2\u0001\r!a3\u0015\r\u0005\u0015'Q\tB$\u0011\u001d\tI-\u0004a\u0001\u0003\u0017Dq!!6\u000e\u0001\u0004\tY-A\u0006bG\u000e,(/Y2z\u001dVlWC\u0001B'!\u0011\tiPa\u0014\n\t\tE\u0013q \u0002\u0007\u001dVl'-\u001a:\u0002\u0011\u0005\u001c7-\u001e:bGf,\"Aa\u0016\u0011\u0007e\u0014I&C\u0002\u0003\\i\u0014A\u0001T8oO\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\t\u0005\u0004CBA<\u0003\u0003\u0013\u0019\u0007\u0005\u0003\u0003f\t-TB\u0001B4\u0015\r\u0011I\u0007V\u0001\u0006if\u0004Xm]\u0005\u0005\u0005[\u00129G\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qKV\u0011!\u0011\u000f\t\bs\nM\u0014\u0011LAF\u0013\r\u0011)H\u001f\u0002\u0007)V\u0004H.\u001a\u001a\u0002+I,G/\u001e:o!\u0016\u00148-\u001a8uS2,\u0017I\u001d:bsV\u0011\u00111R\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0005\u007f\u0002BA!!\u0003\b6\u0011!1\u0011\u0006\u0004\u0005\u000b\u0013\u0016\u0001C1oC2L8/[:\n\t\t%%1\u0011\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002E\u00061Q\u000f\u001d3bi\u0016$RA\u0019BJ\u0005/CaA!&\u0017\u0001\u0004\u0011\u0017A\u00022vM\u001a,'\u000fC\u0004\u0003\u001aZ\u0001\rAa'\u0002\u0011%t\u0007/\u001e;S_^\u0004BA!(\u0003 6\t!+C\u0002\u0003\"J\u00131\"\u00138uKJt\u0017\r\u001c*poR)!M!*\u0003(\"1!QS\fA\u0002\tDa!a\u001c\u0018\u0001\u0004\u0011\u0017\u0001B3wC2$BA!,\u00034B\u0019\u0011Pa,\n\u0007\tE&PA\u0002B]fDaA!&\u0019\u0001\u0004\u0011\u0017!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005\u0015'\u0011\u0018\u0005\b\u0005wK\u0002\u0019AA\u000b\u0003%qWm^(gMN,G/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003\u000b\u0014\t\rC\u0004\u0003<j\u0001\r!!\u0006\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003!qW\u000f\u001c7bE2,\u0017\u0001E5oi\u0016\u0014h.\u00197ECR\fG+\u001f9f+\t\u0011y\r\u0005\u0003\u0003f\tE\u0017\u0002\u0002Bj\u0005O\u0012\u0001\u0002R1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\tm\u0007\u0003\u0002Bo\u0005KtAAa8\u0003bB\u00111N_\u0005\u0004\u0005GT\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0003h\n%(AB*ue&twMC\u0002\u0003dj$B!a*\u0003n\"1\u0011\u0011\u0017\u0012A\u0002\t$2A\u0019By\u0011\u001d\tIl\ta\u0001\u0003O\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0011\u0005\u0015'q\u001fB~\u0005\u007fDqA!?%\u0001\u0004\tY-\u0001\u0005oK^4\u0015N]:u\u0011\u001d\u0011i\u0010\na\u0001\u0003\u0017\f\u0011B\\3x'\u0016\u001cwN\u001c3\t\u000f\r\u0005A\u00051\u0001\u0002L\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLH\u0003DAc\u0007\u000f\u0019Iaa\u0003\u0004\u000e\r=\u0001\"CAeKA\u0005\t\u0019AAf\u0011%\t).\nI\u0001\u0002\u0004\tY\rC\u0005\u0002Z\u0016\u0002\n\u00111\u0001\u0002L\"I\u0011Q\\\u0013\u0011\u0002\u0003\u0007\u0011Q\u0003\u0005\n\u0003C,\u0003\u0013!a\u0001\u0003+\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u0016)\"\u00111ZB\fW\t\u0019I\u0002\u0005\u0003\u0004\u001c\r\u0015RBAB\u000f\u0015\u0011\u0019yb!\t\u0002\u0013Ut7\r[3dW\u0016$'bAB\u0012u\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r\u001d2Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"a!\r+\t\u0005U1qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111\u0011\b\t\u0005\u0003{\u001cY$\u0003\u0003\u0003h\u0006}\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005[\u001b\u0019\u0005C\u0005\u0002>5\n\t\u00111\u0001\u0002\u0016\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004JA111JB)\u0005[k!a!\u0014\u000b\u0007\r=#0\u0001\u0006d_2dWm\u0019;j_:LAaa\u0015\u0004N\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tIf!\u0017\t\u0013\u0005ur&!AA\u0002\t5\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$Ba!\u000f\u0004`!I\u0011Q\b\u0019\u0002\u0002\u0003\u0007\u0011QC\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e3Q\r\u0005\n\u0003{\t\u0014\u0011!a\u0001\u0005[C3\u0003AB5\u0007_\u001a\th!\u001e\u0004x\rm4QPBA\u0007\u0007\u0003B!!4\u0004l%\u00191Q\u000e)\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u001211O\u0001\u0007>*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015d_2d\u0003\u0005]3sG\u0016tG/Y4fAmc\u0003%Y2dkJ\f7-_/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0005\u0004\bO]8yS6\fG/\u001a\u0011aa\u0016\u00148-\u001a8uS2,\u0007\rI8gAQDW\r\t8v[\u0016\u0014\u0018n\u0019\u0011pe*\u0001\u0003\u0005\t\u0011!A\u0005t7/\u001b\u0011j]R,'O^1mA\r|G.^7oA\u0001\u001cw\u000e\u001c1!o\"L7\r\u001b\u0011jg\u0002\"\b.\u001a\u0011t[\u0006dG.Z:uAY\fG.^3!S:\u0004C\u000f[3!_J$WM]3eA\u0001\u001cw\u000e\u001c1!m\u0006dW/Z:!QM|'\u000f^3e\u0015\u0001\u0002\u0003\u0005\t\u0011!MJ|W\u000e\t7fCN$\b\u0005^8!OJ,\u0017\r^3ti&\u00023/^2iAQD\u0017\r\u001e\u0011o_\u0002jwN]3!i\"\fg\u000e\t1qKJ\u001cWM\u001c;bO\u0016\u0004\u0007e\u001c4!A\u000e|G\u000e\u0019\u0011wC2,Xm\u001d\u0011jg\u0002bWm]:!i\"\fgN\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e5fAY\fG.^3!_J\u0004S-];bY\u0002\"x\u000e\t;iCR\u0004c/\u00197vK:\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u0002\u0002XM]2f]R\fw-\u001a\u0011nkN$\bEY3!E\u0016$x/Z3oAAr\u0003\u0007I1oI\u0002\nd\u0006\r\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004\u0003-Y2dkJ\f7-\u001f1!a\u0006\u0014\u0018-\\3uKJ\u0004\u0003\u0006Z3gCVdGO\u000f\u00112aA\u0002\u0004'\u000b\u0011jg\u0002\n\u0007\u0005]8tSRLg/\u001a\u0011ok6,'/[2!Y&$XM]1mA]D\u0017n\u00195!G>tGO]8mg*\u0001\u0003\u0005\t\u0011!A\u0005\u0004\bO]8yS6\fG/[8oA\u0005\u001c7-\u001e:bGf\u0004\u0013\r\u001e\u0011uQ\u0016\u00043m\\:uA=4\u0007%\\3n_JLh\u0006\t%jO\",'\u000f\t<bYV,\u0007e\u001c4!A\u0006\u001c7-\u001e:bGf\u0004\u0007%_5fY\u0012\u001c\bEY3ui\u0016\u0014(\u0002\t\u0011!A\u0001\u0002\u0013mY2ve\u0006\u001c\u0017\u0010\f\u0011ac9\u0002t&Y2dkJ\f7-\u001f1!SN\u0004C\u000f[3!e\u0016d\u0017\r^5wK\u0002*'O]8sA=4\u0007\u0005\u001e5fA\u0005\u0004\bO]8yS6\fG/[8o])\u0001\u0003\u0005\t\u0011!A]CWM\u001c\u0011aa\u0016\u00148-\u001a8uC\u001e,\u0007\rI5tA\u0005t\u0007%\u0019:sCfd\u0003%Z1dQ\u00022\u0018\r\\;fA=4\u0007\u0005\u001e5fAA,'oY3oi\u0006<W\rI1se\u0006L\b%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0011!A\u0001\u0002\u0003%\u00138!i\"L7\u000fI2bg\u0016d\u0003E]3ukJt7\u000f\t;iK\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^3!a\u0016\u00148-\u001a8uS2,\u0007%\u0019:sCf\u0004sN\u001a\u0011d_2,XN\u001c\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t'\u0002\t\u0011!A\u0001\u0002\u0003/\u001a:dK:$\u0018mZ3!CJ\u0014\u0018-\u001f\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0007s\nA1\u0018\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006I1se\u0006L\b\u0006\r\u00186Y\u0001\u0002d\u0006\u000e\u0017!a9\n\u0014\u0006\f\u00112aAJ\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0003'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003&\r\u0019*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Fb\u0013\u0007\f\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!a9*D\u0006I\u00191a%\u0002cIU(NAY\u000bE*V#TA!\u0002\u0014\u0006\f\u0011)m%b\u0003\u0005K\u001c*Y\u0001B\u0013(\u000b\u0017!QE\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006\t\u0019/k1\u0002\u0013\u0007\r\u0019*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)\u0013:#VI\u0015,B\u0019\u0002:\u0003g\n\u0011N\u001f:#\u0006*\u000b\u0017!Q%sE+\u0012*W\u00032\u0003s%M\u0014!\u001b>sE\u000bS\u0015-A!Je\nV#S-\u0006c\u0005e\n\u001a(A5{e\n\u0016%*Y\u0001B\u0013J\u0014+F%Z\u000bE\nI\u00142a\u001d\u0002Sj\u0014(U\u0011&\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002T&\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006I1se\u0006L\b\u0006\r\u00186Y\u0001\u0002dfN\u0015-AE\u0002\u0004'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K%O)\u0016\u0013f+\u0011'!OA:\u0003eU#D\u001f:#\u0015\u0006\f\u0011)\u0013:#VI\u0015,B\u0019\u0002:\u0013g\n\u0011T\u000b\u000e{e\nR\u0015-A!Je\nV#S-\u0006c\u0005e\n\u001a(AM+5i\u0014(ES1\u0002\u0003&\u0013(U\u000bJ3\u0016\t\u0014\u0011(cA:\u0003eU#D\u001f:#\u0015\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0019!aAR\u0004\u0007\r\u001e1c9\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\f\u0019!aAR\u0004\u0007\r\u001e1e9\u0002\u0004\u0007\r\u00191aA\u0002\u0004'\u0018\u0006!A\u0005)qM]8va\u0006\u00121qP\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#a!\"\u0002\u000bIr\u0013G\f\u0019")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
Serializable {
    private Number accuracyNum;
    private long accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private DataType internalDataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient scala.collection.immutable.Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile x$0) {
        return ApproximatePercentile$.MODULE$.unapply(x$0);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private scala.collection.immutable.Seq<Expression> children$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final scala.collection.immutable.Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private Number accuracyNum$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracyNum = (Number)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracyNum;
    }

    private Number accuracyNum() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.accuracyNum$lzycompute();
        }
        return this.accuracyNum;
    }

    private long accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.accuracy = this.accuracyNum().longValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.accuracy;
    }

    private long accuracy() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.accuracy$lzycompute();
        }
        return this.accuracy;
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, new ArrayType((DataType)DoubleType$.MODULE$, false)})), (List)new .colon.colon((Object)IntegralType$.MODULE$, (List)Nil$.MODULE$)));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Tuple2 tuple2;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), null);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                } else {
                    throw new MatchError(object);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                boolean returnPercentileArray = tuple22._1$mcZ$sp();
                double[] percentages = (double[])tuple22._2();
                this.x$1 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)returnPercentileArray), (Object)percentages);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.returnPercentileArray$lzycompute();
        }
        return this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.percentages$lzycompute();
        }
        return this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!this.percentageExpression().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("percentage")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.percentageExpression().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.percentageExpression()))}))));
        }
        if (!this.accuracyExpression().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("accuracy")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.accuracyExpression().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.accuracyExpression()))}))));
        }
        if (this.accuracyNum() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"accuracy")}))));
        }
        if (this.accuracy() <= 0L || this.accuracy() > Integer.MAX_VALUE) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"accuracy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("(0, " + Integer.MAX_VALUE + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Cast$.MODULE$.toSQLValue(BoxesRunTime.boxToLong((long)this.accuracy()), (DataType)LongType$.MODULE$))}))));
        }
        if (this.percentages() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage")}))));
        }
        if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1)(JFunction1.mcZD.sp & Serializable)percentage -> percentage < 0.0 || percentage > 1.0)) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)"[0.0, 1.0]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1 & Serializable)x$2 -> Cast$.MODULE$.toSQLValue(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$2)), (DataType)DoubleType$.MODULE$), ClassTag$.MODULE$.apply(String.class))).mkString(","))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            if (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else if (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType)) {
                d = BoxesRunTime.unboxToLong((Object)value);
            } else if (dataType instanceof NumericType) {
                NumericType numericType = (NumericType)dataType;
                d = PhysicalNumericType$.MODULE$.numeric(numericType).toDouble(value);
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw SparkException$.MODULE$.internalError("Unexpected data type " + dataType2);
                }
                throw new MatchError((Object)dataType);
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        scala.collection.immutable.Seq seq;
        scala.collection.immutable.Seq doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        if (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable)x$3 -> (int)x$3);
        } else if (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType)) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable)x$4 -> (long)x$4);
        } else if (ByteType$.MODULE$.equals(dataType)) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$5))));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$6))));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable)x$7 -> (int)x$7);
        } else if (LongType$.MODULE$.equals(dataType)) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable)x$8 -> (long)x$8);
        } else if (FloatType$.MODULE$.equals(dataType)) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1)(JFunction1.mcFD.sp & Serializable)x$9 -> (float)x$9);
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            seq = doubleResult;
        } else if (dataType instanceof DecimalType) {
            seq = (scala.collection.immutable.Seq)doubleResult.map((Function1 & Serializable)x$10 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$10)));
        } else {
            if (dataType != null) {
                DataType dataType2 = dataType;
                throw SparkException$.MODULE$.internalError("Unexpected data type " + dataType2);
            }
            throw new MatchError((Object)dataType);
        }
        scala.collection.immutable.Seq result = seq;
        if (result.length() == 0) {
            return null;
        }
        if (this.returnPercentileArray()) {
            return new GenericArrayData((Seq<Object>)result);
        }
        return result.apply(0);
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.accuracyExpression();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType internalDataType$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.internalDataType = this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.internalDataType$lzycompute();
        }
        return this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "percentile_approx");
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    @Override
    public ApproximatePercentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5());
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.percentageExpression();
            }
            case 2: {
                return this.accuracyExpression();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "percentageExpression";
            }
            case 2: {
                return "accuracyExpression";
            }
            case 3: {
                return "mutableAggBufferOffset";
            }
            case 4: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$5) {
        return (byte)x$5;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$6) {
        return (short)x$6;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        public scala.collection.immutable.Seq<Object> getPercentiles(double[] percentages) {
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                return ArrayImplicits$.MODULE$.SparkArrayOps((Object)Array$.MODULE$.emptyDoubleArray()).toImmutableArraySeq();
            }
            return (scala.collection.immutable.Seq)this.summaries().query((scala.collection.immutable.Seq<Object>)ArrayImplicits$.MODULE$.SparkArrayOps((Object)percentages).toImmutableArraySeq()).get();
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, true));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

