/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.client.RequestConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RequestConfigFluent<A extends RequestConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, List<String>> impersonateExtras;
    private List<String> impersonateGroups;
    private String impersonateUsername;
    private Integer loggingInterval;
    private Integer requestRetryBackoffInterval;
    private Integer requestRetryBackoffLimit;
    private Integer requestTimeout;
    private Long scaleTimeout;
    private Integer uploadRequestTimeout;
    private Integer watchReconnectInterval;
    private Integer watchReconnectLimit;

    public RequestConfigFluent() {
    }

    public RequestConfigFluent(RequestConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A addToImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null && map != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToImpersonateExtras(String key, List<String> value) {
        if (this.impersonateExtras == null && key != null && value != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)((Object)this);
    }

    public A addToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(RequestConfig instance) {
        RequestConfig requestConfig = instance = instance != null ? instance : new RequestConfig();
        if (instance != null) {
            this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
            this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
            this.withRequestTimeout(instance.getRequestTimeout());
            this.withScaleTimeout(instance.getScaleTimeout());
            this.withLoggingInterval(instance.getLoggingInterval());
            this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
            this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
            this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
            this.withImpersonateUsername(instance.getImpersonateUsername());
            this.withImpersonateGroups(instance.getImpersonateGroups());
            this.withImpersonateExtras(instance.getImpersonateExtras());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestConfigFluent that = (RequestConfigFluent)((Object)o);
        if (!Objects.equals(this.impersonateUsername, that.impersonateUsername)) {
            return false;
        }
        if (!Objects.equals(this.impersonateGroups, that.impersonateGroups)) {
            return false;
        }
        if (!Objects.equals(this.impersonateExtras, that.impersonateExtras)) {
            return false;
        }
        if (!Objects.equals(this.watchReconnectInterval, that.watchReconnectInterval)) {
            return false;
        }
        if (!Objects.equals(this.watchReconnectLimit, that.watchReconnectLimit)) {
            return false;
        }
        if (!Objects.equals(this.uploadRequestTimeout, that.uploadRequestTimeout)) {
            return false;
        }
        if (!Objects.equals(this.requestRetryBackoffLimit, that.requestRetryBackoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.requestRetryBackoffInterval, that.requestRetryBackoffInterval)) {
            return false;
        }
        if (!Objects.equals(this.requestTimeout, that.requestTimeout)) {
            return false;
        }
        if (!Objects.equals(this.scaleTimeout, that.scaleTimeout)) {
            return false;
        }
        return Objects.equals(this.loggingInterval, that.loggingInterval);
    }

    public Map<String, List<String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    public String[] getImpersonateGroups() {
        int size = this.impersonateGroups != null ? this.impersonateGroups.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    public Integer getLoggingInterval() {
        return this.loggingInterval;
    }

    public Integer getRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval;
    }

    public Integer getRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit;
    }

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public Long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public Integer getUploadRequestTimeout() {
        return this.uploadRequestTimeout;
    }

    public Integer getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public Integer getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    public boolean hasImpersonateGroups() {
        return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
    }

    public boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    public boolean hasLoggingInterval() {
        return this.loggingInterval != null;
    }

    public boolean hasRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval != null;
    }

    public boolean hasRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit != null;
    }

    public boolean hasRequestTimeout() {
        return this.requestTimeout != null;
    }

    public boolean hasScaleTimeout() {
        return this.scaleTimeout != null;
    }

    public boolean hasUploadRequestTimeout() {
        return this.uploadRequestTimeout != null;
    }

    public boolean hasWatchReconnectInterval() {
        return this.watchReconnectInterval != null;
    }

    public boolean hasWatchReconnectLimit() {
        return this.watchReconnectLimit != null;
    }

    public int hashCode() {
        return Objects.hash(this.impersonateUsername, this.impersonateGroups, this.impersonateExtras, this.watchReconnectInterval, this.watchReconnectLimit, this.uploadRequestTimeout, this.requestRetryBackoffLimit, this.requestRetryBackoffInterval, this.requestTimeout, this.scaleTimeout, this.loggingInterval);
    }

    public A removeAllFromImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromImpersonateExtras(String key) {
        if (this.impersonateExtras == null) {
            return (A)((Object)this);
        }
        if (key != null && this.impersonateExtras != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.impersonateExtras == null) continue;
                this.impersonateExtras.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.impersonateUsername != null) {
            sb.append("impersonateUsername:");
            sb.append(this.impersonateUsername);
            sb.append(",");
        }
        if (this.impersonateGroups != null && !this.impersonateGroups.isEmpty()) {
            sb.append("impersonateGroups:");
            sb.append(this.impersonateGroups);
            sb.append(",");
        }
        if (this.impersonateExtras != null && !this.impersonateExtras.isEmpty()) {
            sb.append("impersonateExtras:");
            sb.append(this.impersonateExtras);
            sb.append(",");
        }
        if (this.watchReconnectInterval != null) {
            sb.append("watchReconnectInterval:");
            sb.append(this.watchReconnectInterval);
            sb.append(",");
        }
        if (this.watchReconnectLimit != null) {
            sb.append("watchReconnectLimit:");
            sb.append(this.watchReconnectLimit);
            sb.append(",");
        }
        if (this.uploadRequestTimeout != null) {
            sb.append("uploadRequestTimeout:");
            sb.append(this.uploadRequestTimeout);
            sb.append(",");
        }
        if (this.requestRetryBackoffLimit != null) {
            sb.append("requestRetryBackoffLimit:");
            sb.append(this.requestRetryBackoffLimit);
            sb.append(",");
        }
        if (this.requestRetryBackoffInterval != null) {
            sb.append("requestRetryBackoffInterval:");
            sb.append(this.requestRetryBackoffInterval);
            sb.append(",");
        }
        if (this.requestTimeout != null) {
            sb.append("requestTimeout:");
            sb.append(this.requestTimeout);
            sb.append(",");
        }
        if (this.scaleTimeout != null) {
            sb.append("scaleTimeout:");
            sb.append(this.scaleTimeout);
            sb.append(",");
        }
        if (this.loggingInterval != null) {
            sb.append("loggingInterval:");
            sb.append(this.loggingInterval);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = impersonateExtras == null ? null : new LinkedHashMap<String, List<String>>(impersonateExtras);
        return (A)((Object)this);
    }

    public A withImpersonateGroups(String ... impersonateGroups) {
        if (this.impersonateGroups != null) {
            this.impersonateGroups.clear();
            this._visitables.remove((Object)"impersonateGroups");
        }
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)((Object)this);
    }

    public A withLoggingInterval(Integer loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)((Object)this);
    }

    public A withRequestRetryBackoffInterval(Integer requestRetryBackoffInterval) {
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
        return (A)((Object)this);
    }

    public A withRequestRetryBackoffLimit(Integer requestRetryBackoffLimit) {
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
        return (A)((Object)this);
    }

    public A withRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)((Object)this);
    }

    public A withScaleTimeout(Long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)((Object)this);
    }

    public A withUploadRequestTimeout(Integer uploadRequestTimeout) {
        this.uploadRequestTimeout = uploadRequestTimeout;
        return (A)((Object)this);
    }

    public A withWatchReconnectInterval(Integer watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)((Object)this);
    }

    public A withWatchReconnectLimit(Integer watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)((Object)this);
    }
}

