/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.TempVariableManager;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue!B\u0013'\u0001)\u0012\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011-\u0003!Q1A\u0005\u00021C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019i\u0007\u0001)A\u00055\"9a\u000e\u0001b\u0001\n\u0003y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0003(\u0001\u0011\u0005A\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0003~\u0001\u0011%a\u0010C\u0004\u0000\u0001\u0011\u0005!&!\u0001\t\u0013\u0005\r\u0001\u00011A\u0005\n\u0005\u0015\u0001\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0011!\t\t\u0003\u0001Q!\n\u0005\u001d\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\ty\u0003\u0001C\u0001\u0003cA\u0011\"!\u000e\u0001\u0001\u0004%I!a\u000e\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\u0002CA!\u0001\u0001\u0006K!!\u000f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002\u0002!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\t\u0003O\u0002A\u0011\u0001\u0016\u0002j\u001dA\u00111\u000e\u0014\t\u0002)\niGB\u0004&M!\u0005!&a\u001c\t\rM[B\u0011AA9\u0011%\t\u0019h\u0007b\u0001\n\u0003\t)\bC\u0004\u0002xm\u0001\u000b\u0011\u00022\t\u0013\u0005e4D1A\u0005\u0002\u0005m\u0004\u0002CAF7\u0001\u0006I!! \t\u0013\u000555D1A\u0005\u0002\u0005m\u0004\u0002CAH7\u0001\u0006I!! \t\u0013\u0005E5D1A\u0005\u0002\u0005m\u0004\u0002CAJ7\u0001\u0006I!! \u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe*\u0011q\u0005K\u0001\bG\u0006$\u0018\r\\8h\u0015\tI#&A\u0005d_:tWm\u0019;pe*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\u0014\t\u0001\u0019\u0014h\u0010\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ijT\"A\u001e\u000b\u0005qR\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005yZ$!D*R\u0019\u000e{gN\u001a%fYB,'\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002CY\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002E\u0003\n9Aj\\4hS:<\u0017!\u00063fM\u0006,H\u000e^*fgNLwN\\\"bi\u0006dwnZ\u0002\u0001!\tA\u0015*D\u0001'\u0013\tQeEA\u0007DCR\fGn\\4QYV<\u0017N\\\u0001\u0011mF\u001aVm]:j_:\u001c\u0015\r^1m_\u001e,\u0012!\u0014\t\u0003\u001dBk\u0011a\u0014\u0006\u0003OmJ!!U(\u0003\u001dM+7o]5p]\u000e\u000bG/\u00197pO\u0006\tb/M*fgNLwN\\\"bi\u0006dwn\u001a\u0011\u0002\rqJg.\u001b;?)\r)fk\u0016\t\u0003\u0011\u0002AQ!\u0012\u0003A\u0002\u001dCQa\u0013\u0003A\u00025\u000b\u0001bY1uC2|wm]\u000b\u00025B!1\f\u00192H\u001b\u0005a&BA/_\u0003\u001diW\u000f^1cY\u0016T!aX\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002b9\n9\u0001*Y:i\u001b\u0006\u0004\bCA2k\u001d\t!\u0007\u000e\u0005\u0002fk5\taM\u0003\u0002h\r\u00061AH]8pizJ!![\u001b\u0002\rA\u0013X\rZ3g\u0013\tYGN\u0001\u0004TiJLgn\u001a\u0006\u0003SV\n\u0011bY1uC2|wm\u001d\u0011\u0002'Q,W\u000e\u001d,be&\f'\r\\3NC:\fw-\u001a:\u0016\u0003A\u0004\"AT9\n\u0005I|%a\u0005+f[B4\u0016M]5bE2,W*\u00198bO\u0016\u0014\u0018\u0001\u0006;f[B4\u0016M]5bE2,W*\u00198bO\u0016\u0014\b\u0005\u0006\u0002Hk\")a/\u0003a\u0001E\u0006!a.Y7f\u0003MI7oQ1uC2|wMU3hSN$XM]3e)\tIH\u0010\u0005\u00025u&\u001110\u000e\u0002\b\u0005>|G.Z1o\u0011\u00151(\u00021\u0001c\u0003Qaw.\u00193WeM+7o]5p]\u000e\u000bG/\u00197pOR\tq)\u0001\tweM+7o]5p]\u000e\u000bG/\u00197pOV\tq)A\t`GV\u0014(/\u001a8u\u001d\u0006lWm\u001d9bG\u0016,\"!a\u0002\u0011\u000bQ\nI!!\u0004\n\u0007\u0005-QG\u0001\u0004PaRLwN\u001c\t\u0005i\u0005=!-C\u0002\u0002\u0012U\u0012Q!\u0011:sCf\fQcX2veJ,g\u000e\u001e(b[\u0016\u001c\b/Y2f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0018\u0005u\u0001c\u0001\u001b\u0002\u001a%\u0019\u00111D\u001b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003?q\u0011\u0011!a\u0001\u0003\u000f\t1\u0001\u001f\u00132\u0003Iy6-\u001e:sK:$h*Y7fgB\f7-\u001a\u0011\u0002!\r,(O]3oi:\u000bW.Z:qC\u000e,WCAA\u0007\u0003Q\t7o]3si:\u000bW.Z:qC\u000e,W\t_5tiR!\u0011qCA\u0016\u0011\u001d\ti#\u0005a\u0001\u0003\u001b\t\u0011B\\1nKN\u0004\u0018mY3\u0002'M,GoQ;se\u0016tGOT1nKN\u0004\u0018mY3\u0015\t\u0005]\u00111\u0007\u0005\b\u0003[\u0011\u0002\u0019AA\u0007\u0003My6-\u001e:sK:$8)\u0019;bY><g*Y7f+\t\tI\u0004\u0005\u00035\u0003\u0013\u0011\u0017aF0dkJ\u0014XM\u001c;DCR\fGn\\4OC6,w\fJ3r)\u0011\t9\"a\u0010\t\u0013\u0005}A#!AA\u0002\u0005e\u0012\u0001F0dkJ\u0014XM\u001c;DCR\fGn\\4OC6,\u0007%\u0001\bdkJ\u0014XM\u001c;DCR\fGn\\4\u0002#M,GoQ;se\u0016tGoQ1uC2|w\r\u0006\u0003\u0002\u0018\u0005%\u0003BBA&/\u0001\u0007!-A\u0006dCR\fGn\\4OC6,\u0017\u0001\u00047jgR\u001c\u0015\r^1m_\u001e\u001cH\u0003BA)\u0003G\u0002R!a\u0015\u0002^\ttA!!\u0016\u0002Z9\u0019Q-a\u0016\n\u0003YJ1!a\u00176\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0018\u0002b\t\u00191+Z9\u000b\u0007\u0005mS\u0007C\u0004\u0002fa\u0001\r!!\u000f\u0002\u000fA\fG\u000f^3s]\u0006)!/Z:fiR\u0011\u0011qC\u0001\u000f\u0007\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s!\tA5d\u0005\u0002\u001cgQ\u0011\u0011QN\u0001\u0015'\u0016\u001b6+S(O?\u000e\u000bE+\u0011'P\u000f~s\u0015)T#\u0016\u0003\t\fQcU#T'&{ejX\"B)\u0006cujR0O\u00036+\u0005%A\nT3N#V)T0D\u0003R\u000bEjT$`\u001d\u0006kU)\u0006\u0002\u0002~A!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015\u0001\u00027b]\u001eT!!a\"\u0002\t)\fg/Y\u0005\u0004W\u0006\u0005\u0015\u0001F*Z'R+UjX\"B)\u0006cujR0O\u00036+\u0005%A\tT\u000bN\u001b\u0016j\u0014(`\u001d\u0006kUi\u0015)B\u0007\u0016\u000b!cU#T'&{ej\u0018(B\u001b\u0016\u001b\u0006+Q\"FA\u0005\t\")V%M)&suLT!N\u000bN\u0003\u0016iQ#\u0002%\t+\u0016\n\u0014+J\u001d~s\u0015)T#T!\u0006\u001bU\t\t")
public class CatalogManager
implements SQLConfHelper,
Logging {
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final HashMap<String, CatalogPlugin> catalogs;
    private final TempVariableManager tempVariableManager;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String BUILTIN_NAMESPACE() {
        return CatalogManager$.MODULE$.BUILTIN_NAMESPACE();
    }

    public static String SESSION_NAMESPACE() {
        return CatalogManager$.MODULE$.SESSION_NAMESPACE();
    }

    public static String SYSTEM_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SYSTEM_CATALOG_NAME();
    }

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public TempVariableManager tempVariableManager() {
        return this.tempVariableManager;
    }

    public synchronized CatalogPlugin catalog(String name) {
        if (name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())) {
            return this.v2SessionCatalog();
        }
        return (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> Catalogs$.MODULE$.load(name, this.conf()));
    }

    public boolean isCatalogRegistered(String name) {
        boolean bl;
        try {
            this.catalog(name);
            bl = true;
        }
        catch (CatalogNotFoundException catalogNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin = Catalogs$.MODULE$.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf());
        if (catalogPlugin instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            return catalogExtension;
        }
        return catalogPlugin;
    }

    public CatalogPlugin v2SessionCatalog() {
        String string = this.conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION());
        switch (string == null ? 0 : string.hashCode()) {
            case 230960163: {
                if (!"builtin".equals(string)) break;
                return this.defaultSessionCatalog;
            }
        }
        return (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable)() -> this.loadV2SessionCatalog());
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public String[] currentNamespace() {
        String[] stringArray;
        String string = this.currentCatalog().name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] defaultNamespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.currentCatalog().defaultNamespace();
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            stringArray = (String[])this._currentNamespace().getOrElse((Function0 & Serializable)() -> defaultNamespace);
        }
        return stringArray;
    }

    private void assertNamespaceExist(String[] namespace) {
        SupportsNamespaces supportsNamespaces;
        CatalogPlugin catalogPlugin = this.currentCatalog();
        if (catalogPlugin instanceof SupportsNamespaces && !(supportsNamespaces = (SupportsNamespaces)catalogPlugin).namespaceExists(namespace)) {
            String string = supportsNamespaces.name();
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError((String[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])namespace), (Object)string, ClassTag$.MODULE$.apply(String.class)));
        }
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog()) && namespace.length == 1) {
            this.v1SessionCatalog().setCurrentDatabaseWithNameCheck((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace)), (Function1<String, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                this.assertNamespaceExist(namespace);
                return BoxedUnit.UNIT;
            });
        } else {
            this.assertNamespaceExist(namespace);
        }
        this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return this.catalog((String)this._currentCatalogName().getOrElse((Function0 & Serializable)() -> this.conf().getConf(SQLConf$.MODULE$.DEFAULT_CATALOG())));
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        String string = this.currentCatalog().name();
        String string2 = catalogName;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.catalog(catalogName);
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
            return;
        }
    }

    public Seq<String> listCatalogs(Option<String> pattern) {
        Seq seq;
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            seq = this.catalogs().keys().toSeq();
        }
        Seq allCatalogs = (Seq)((SeqOps)((SeqOps)seq.$colon$plus((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        return (Seq)pattern.map((Function1 & Serializable)x$2 -> StringUtils$.MODULE$.filterPattern((Seq<String>)allCatalogs, (String)x$2)).getOrElse((Function0 & Serializable)() -> allCatalogs);
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
    }

    public CatalogManager(CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        SQLConfHelper.$init$(this);
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this.tempVariableManager = new TempVariableManager();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

