/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext$;
import org.apache.spark.sql.catalyst.expressions.Pmod$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns the positive value of `expr1` mod `expr2`.", examples="\n    Examples:\n      > SELECT _FUNC_(10, 3);\n       1\n      > SELECT _FUNC_(-10, 3);\n       2\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\tuf\u0001\u0002\u00192\u0001zB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003X\u0011!i\u0006A!f\u0001\n\u0003q\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B0\t\u000b\r\u0004A\u0011\u00013\t\u000b\r\u0004A\u0011A5\t\u000b1\u0004A\u0011I7\t\u000bY\u0004A\u0011I<\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!1\u00111\u0002\u0001\u0005B]Dq!!\u0004\u0001\t\u0003\ny\u0001\u0003\u0006\u0002.\u0001A)\u0019!C\u0005\u0003_A!\"!\u0010\u0001\u0011\u000b\u0007I\u0011BA \u0011\u001d\t9\u0005\u0001C#\u0003\u0013Bq!a\u0016\u0001\t\u0003\nI\u0006C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005U\u0004\u0001\"\u0003\u0002\u0002\"9\u0011Q\u000f\u0001\u0005\n\u00055\u0005bBA;\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003k\u0002A\u0011BAS\u0011\u001d\t)\b\u0001C\u0005\u0003cCq!!\u001e\u0001\t\u0013\ti\fC\u00037\u0001\u0011\u0005s\u000fC\u0004\u0002J\u0002!\t&a3\t\u0013\u0005U\u0007!!A\u0005\u0002\u0005]\u0007\"CAp\u0001E\u0005I\u0011AAq\u0011%\t9\u0010AI\u0001\n\u0003\t\t\u000fC\u0005\u0002z\u0002\t\n\u0011\"\u0001\u0002|\"I\u0011q \u0001\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\n\u0005#\u0001\u0011\u0011!C\u0001\u0005'A\u0011B!\u0006\u0001\u0003\u0003%\tAa\u0006\t\u0013\tu\u0001!!A\u0005B\t}\u0001\"\u0003B\u0017\u0001\u0005\u0005I\u0011\u0001B\u0018\u0011%\u0011\u0019\u0004AA\u0001\n\u0003\u0012)\u0004C\u0005\u0003:\u0001\t\t\u0011\"\u0011\u0003<\u001d9!qL\u0019\t\u0002\t\u0005dA\u0002\u00192\u0011\u0003\u0011\u0019\u0007\u0003\u0004dQ\u0011\u0005!Q\u000f\u0005\b\u0005oBC\u0011\u0001B=\u0011%\u00119\bKA\u0001\n\u0003\u0013\u0019\nC\u0005\u0003\u001c\"\n\n\u0011\"\u0001\u0002|\"I!Q\u0014\u0015\u0002\u0002\u0013\u0005%q\u0014\u0005\n\u0005cC\u0013\u0013!C\u0001\u0003wD\u0011Ba-)\u0003\u0003%IA!.\u0003\tAkw\u000e\u001a\u0006\u0003eM\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A'N\u0001\tG\u0006$\u0018\r\\=ti*\u0011agN\u0001\u0004gFd'B\u0001\u001d:\u0003\u0015\u0019\b/\u0019:l\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0004\u0001M!\u0001aP\"J!\t\u0001\u0015)D\u00012\u0013\t\u0011\u0015G\u0001\tCS:\f'/_!sSRDW.\u001a;jGB\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n9\u0001K]8ek\u000e$\bC\u0001&S\u001d\tY\u0005K\u0004\u0002M\u001f6\tQJ\u0003\u0002O{\u00051AH]8pizJ\u0011AR\u0005\u0003#\u0016\u000bq\u0001]1dW\u0006<W-\u0003\u0002T)\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011+R\u0001\u0005Y\u00164G/F\u0001X!\t\u0001\u0005,\u0003\u0002Zc\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003-)g/\u00197D_:$X\r\u001f;\u0016\u0003}\u0003\"\u0001\u00111\n\u0005\u0005\f$A\u0005(v[\u0016\u0014\u0018nY#wC2\u001cuN\u001c;fqR\fA\"\u001a<bY\u000e{g\u000e^3yi\u0002\na\u0001P5oSRtD\u0003B3gO\"\u0004\"\u0001\u0011\u0001\t\u000bU;\u0001\u0019A,\t\u000bm;\u0001\u0019A,\t\u000fu;\u0001\u0013!a\u0001?R\u0019QM[6\t\u000bUC\u0001\u0019A,\t\u000bmC\u0001\u0019A,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001c\t\u0003_Nt!\u0001]9\u0011\u00051+\u0015B\u0001:F\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I,\u0015AB:z[\n|G.F\u0001o\u0003%Ig\u000e];u)f\u0004X-F\u0001{!\tYh0D\u0001}\u0015\tiX'A\u0003usB,7/\u0003\u0002\u0000y\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\t]VdG.\u00192mKV\u0011\u0011Q\u0001\t\u0004\t\u0006\u001d\u0011bAA\u0005\u000b\n9!i\\8mK\u0006t\u0017!\u00043fG&l\u0017\r\\'fi\"|G-A\tsKN,H\u000e\u001e#fG&l\u0017\r\u001c+za\u0016$\"\"!\u0005\u0002\u0018\u0005\u0005\u0012QEA\u0015!\rY\u00181C\u0005\u0004\u0003+a(a\u0003#fG&l\u0017\r\u001c+za\u0016Dq!!\u0007\u000f\u0001\u0004\tY\"\u0001\u0002qcA\u0019A)!\b\n\u0007\u0005}QIA\u0002J]RDq!a\t\u000f\u0001\u0004\tY\"\u0001\u0002tc!9\u0011q\u0005\bA\u0002\u0005m\u0011A\u000193\u0011\u001d\tYC\u0004a\u0001\u00037\t!a\u001d\u001a\u0002\r%\u001c(,\u001a:p+\t\t\t\u0004E\u0004E\u0003g\t9$!\u0002\n\u0007\u0005URIA\u0005Gk:\u001cG/[8ocA\u0019A)!\u000f\n\u0007\u0005mRIA\u0002B]f\f\u0001\u0002]7pI\u001a+hnY\u000b\u0003\u0003\u0003\u0002\u0012\u0002RA\"\u0003o\t9$a\u000e\n\u0007\u0005\u0015SIA\u0005Gk:\u001cG/[8oe\u0005!QM^1m)\u0011\t9$a\u0013\t\u0013\u00055\u0013\u0003%AA\u0002\u0005=\u0013!B5oaV$\b\u0003BA)\u0003'j\u0011aM\u0005\u0004\u0003+\u001a$aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005m\u0013qMA9!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1c\u000591m\u001c3fO\u0016t\u0017\u0002BA3\u0003?\u0012\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003S\u0012\u0002\u0019AA6\u0003\r\u0019G\u000f\u001f\t\u0005\u0003;\ni'\u0003\u0003\u0002p\u0005}#AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003g\u0012\u0002\u0019AA.\u0003\t)g/\u0001\u0003q[>$GCBA\u000e\u0003s\ni\bC\u0004\u0002|M\u0001\r!a\u0007\u0002\u0003\u0005Dq!a \u0014\u0001\u0004\tY\"A\u0001o)\u0019\t\u0019)!#\u0002\fB\u0019A)!\"\n\u0007\u0005\u001dUI\u0001\u0003M_:<\u0007bBA>)\u0001\u0007\u00111\u0011\u0005\b\u0003\u007f\"\u0002\u0019AAB)\u0019\ty)!&\u0002\u0018B\u0019A)!%\n\u0007\u0005MUI\u0001\u0003CsR,\u0007bBA>+\u0001\u0007\u0011q\u0012\u0005\b\u0003\u007f*\u0002\u0019AAH)\u0019\tY*!)\u0002$B\u0019A)!(\n\u0007\u0005}UI\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003w2\u0002\u0019AAN\u0011\u001d\tyH\u0006a\u0001\u00037#b!a*\u0002.\u0006=\u0006c\u0001#\u0002*&\u0019\u00111V#\u0003\u000bMCwN\u001d;\t\u000f\u0005mt\u00031\u0001\u0002(\"9\u0011qP\fA\u0002\u0005\u001dFCBAZ\u0003s\u000bY\fE\u0002E\u0003kK1!a.F\u0005\u00151En\\1u\u0011\u001d\tY\b\u0007a\u0001\u0003gCq!a \u0019\u0001\u0004\t\u0019\f\u0006\u0004\u0002@\u0006\u0015\u0017q\u0019\t\u0004w\u0006\u0005\u0017bAAby\n9A)Z2j[\u0006d\u0007bBA>3\u0001\u0007\u0011q\u0018\u0005\b\u0003\u007fJ\u0002\u0019AA`\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003f\u0003\u001b\f\t\u000e\u0003\u0004\u0002Pn\u0001\raV\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\u0019n\u0007a\u0001/\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLHcB3\u0002Z\u0006m\u0017Q\u001c\u0005\b+r\u0001\n\u00111\u0001X\u0011\u001dYF\u0004%AA\u0002]Cq!\u0018\u000f\u0011\u0002\u0003\u0007q,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r(fA,\u0002f.\u0012\u0011q\u001d\t\u0005\u0003S\f\u00190\u0004\u0002\u0002l*!\u0011Q^Ax\u0003%)hn\u00195fG.,GMC\u0002\u0002r\u0016\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)0a;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q \u0016\u0004?\u0006\u0015\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0004A!!Q\u0001B\b\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011\u0001\u00027b]\u001eT!A!\u0004\u0002\t)\fg/Y\u0005\u0004i\n\u001d\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u000e\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u000e\u0003\u001a!I!1\u0004\u0012\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0002C\u0002B\u0012\u0005S\t9$\u0004\u0002\u0003&)\u0019!qE#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003,\t\u0015\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0002\u00032!I!1\u0004\u0013\u0002\u0002\u0003\u0007\u0011qG\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0004\t]\u0002\"\u0003B\u000eK\u0005\u0005\t\u0019AA\u000e\u0003\u0019)\u0017/^1mgR!\u0011Q\u0001B\u001f\u0011%\u0011YBJA\u0001\u0002\u0004\t9\u0004K\n\u0001\u0005\u0003\u00129E!\u0013\u0003N\t=#1\u000bB+\u00053\u0012Y\u0006E\u0002A\u0005\u0007J1A!\u00122\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u0013\u0002\u0013~3UKT\"`Q\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAA|7/\u001b;jm\u0016\u0004c/\u00197vK\u0002zg\r\t1fqB\u0014\u0018\u0007\u0019\u0011n_\u0012\u0004\u0003-\u001a=qeJ\u0002g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t&\u00011\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QE\u0002D\u0006I\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00172a1\u00023'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!e)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003X\u0005)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012!QL\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\u0018\u0001\u0002)n_\u0012\u0004\"\u0001\u0011\u0015\u0014\u000b!\u0012)Ga\u001b\u0011\u0007\u0011\u00139'C\u0002\u0003j\u0015\u0013a!\u00118z%\u00164\u0007\u0003\u0002B7\u0005gj!Aa\u001c\u000b\t\tE$1B\u0001\u0003S>L1a\u0015B8)\t\u0011\t'A\u0003baBd\u0017\u0010F\u0004f\u0005w\u0012iHa \t\u000bUS\u0003\u0019A,\t\u000bmS\u0003\u0019A,\t\u000f\t\u0005%\u00061\u0001\u0003\u0004\u0006AQM^1m\u001b>$W\r\u0005\u0003\u0003\u0006\n-eb\u0001!\u0003\b&\u0019!\u0011R\u0019\u0002\u0011\u00153\u0018\r\\'pI\u0016LAA!$\u0003\u0010\n)a+\u00197vK&\u0019!\u0011S#\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u000b\bK\nU%q\u0013BM\u0011\u0015)6\u00061\u0001X\u0011\u0015Y6\u00061\u0001X\u0011\u001di6\u0006%AA\u0002}\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tK!,\u0011\u000b\u0011\u0013\u0019Ka*\n\u0007\t\u0015VI\u0001\u0004PaRLwN\u001c\t\u0007\t\n%vkV0\n\u0007\t-VI\u0001\u0004UkBdWm\r\u0005\t\u0005_k\u0013\u0011!a\u0001K\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00119\f\u0005\u0003\u0003\u0006\te\u0016\u0002\u0002B^\u0005\u000f\u0011aa\u00142kK\u000e$\b")
public class Pmod
extends BinaryArithmetic {
    private Function1<Object, Object> isZero;
    private Function2<Object, Object, Object> pmodFunc;
    private final Expression left;
    private final Expression right;
    private final NumericEvalContext evalContext;
    private volatile byte bitmap$0;

    public static NumericEvalContext $lessinit$greater$default$3() {
        return Pmod$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, NumericEvalContext>> unapply(Pmod x$0) {
        return Pmod$.MODULE$.unapply(x$0);
    }

    public static NumericEvalContext apply$default$3() {
        return Pmod$.MODULE$.apply$default$3();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public NumericEvalContext evalContext() {
        return this.evalContext;
    }

    @Override
    public String toString() {
        return "pmod(" + this.left() + ", " + this.right() + ")";
    }

    @Override
    public String symbol() {
        return "pmod";
    }

    @Override
    public AbstractDataType inputType() {
        return NumericType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String decimalMethod() {
        return "remainder";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int resultScale = package$.MODULE$.max(s1, s2);
        int resultPrecision = package$.MODULE$.min(p1 - s1, p2 - s2) + resultScale;
        if (this.allowPrecisionLoss()) {
            return DecimalType$.MODULE$.adjustPrecisionScale(resultPrecision, resultScale);
        }
        return DecimalType$.MODULE$.bounded(resultPrecision, resultScale);
    }

    private Function1<Object, Object> isZero$lzycompute() {
        Pmod pmod = this;
        synchronized (pmod) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.right().dataType();
                this.isZero = dataType instanceof DecimalType ? (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Pmod.$anonfun$isZero$3(x)) : (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Pmod.$anonfun$isZero$4(x));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isZero;
    }

    private Function1<Object, Object> isZero() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.isZero$lzycompute();
        }
        return this.isZero;
    }

    private Function2<Object, Object, Object> pmodFunc$lzycompute() {
        Pmod pmod = this;
        synchronized (pmod) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DecimalType decimalType;
                Option option;
                Function2 & Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof IntegerType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToInteger((int)this.pmod(BoxesRunTime.unboxToInt((Object)l), BoxesRunTime.unboxToInt((Object)r)));
                } else if (dataType instanceof LongType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToLong((long)this.pmod(BoxesRunTime.unboxToLong((Object)l), BoxesRunTime.unboxToLong((Object)r)));
                } else if (dataType instanceof ShortType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToShort((short)this.pmod(BoxesRunTime.unboxToShort((Object)l), BoxesRunTime.unboxToShort((Object)r)));
                } else if (dataType instanceof ByteType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToByte((byte)this.pmod(BoxesRunTime.unboxToByte((Object)l), BoxesRunTime.unboxToByte((Object)r)));
                } else if (dataType instanceof FloatType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToFloat((float)this.pmod(BoxesRunTime.unboxToFloat((Object)l), BoxesRunTime.unboxToFloat((Object)r)));
                } else if (dataType instanceof DoubleType) {
                    intersect = (Function2 & Serializable)(l, r) -> BoxesRunTime.boxToDouble((double)this.pmod(BoxesRunTime.unboxToDouble((Object)l), BoxesRunTime.unboxToDouble((Object)r)));
                } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = (Function2 & Serializable)(l, r) -> this.checkDecimalOverflow(this.pmod((Decimal)l, (Decimal)r), precision, scale);
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.pmodFunc = intersect;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.pmodFunc;
    }

    private Function2<Object, Object, Object> pmodFunc() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.pmodFunc$lzycompute();
        }
        return this.pmodFunc;
    }

    @Override
    public final Object eval(InternalRow input) {
        Object input2 = this.right().eval(input);
        if (input2 == null || !this.failOnError() && BoxesRunTime.unboxToBoolean((Object)this.isZero().apply(input2))) {
            return null;
        }
        Object input1 = this.left().eval(input);
        if (input1 == null) {
            return null;
        }
        if (BoxesRunTime.unboxToBoolean((Object)this.isZero().apply(input2))) {
            throw QueryExecutionErrors$.MODULE$.remainderByZeroError(this.getContextOrNull());
        }
        return this.pmodFunc().apply(input1, input2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String result;
        DecimalType decimalType;
        Option option;
        ExprCode eval1 = this.left().genCode(ctx);
        ExprCode eval2 = this.right().genCode(ctx);
        String isZero = this.dataType() instanceof DecimalType ? eval2.value() + ".isZero()" : eval2.value() + " == 0";
        String remainder = ctx.freshName("remainder");
        String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            String decimalAdd = "$plus";
            v0 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + javaType + " " + remainder + " = " + eval1.value() + "." + this.decimalMethod() + "(" + eval2.value() + ");\n           |if (" + remainder + ".compare(new org.apache.spark.sql.types.Decimal().set(0)) < 0) {\n           |  " + ev.value() + "=(" + remainder + "." + decimalAdd + "(" + eval2.value() + "))." + this.decimalMethod() + "(" + eval2.value() + ");\n           |} else {\n           |  " + ev.value() + "=" + remainder + ";\n           |}\n           |" + ev.value() + " = " + ev.value() + ".toPrecision(\n           |  " + precision + ", " + scale + ", Decimal.ROUND_HALF_UP(), " + !this.failOnError() + ", " + errorContext + ");\n           |" + ev.isNull() + " = " + ev.value() + " == null;\n           |"));
        } else {
            v0 = result = (ByteType$.MODULE$.equals(dataType) ? true : ShortType$.MODULE$.equals(dataType)) ? "\n          " + javaType + " " + remainder + " = (" + javaType + ")(" + eval1.value() + " % " + eval2.value() + ");\n          if (" + remainder + " < 0) {\n            " + ev.value() + "=(" + javaType + ")((" + remainder + " + " + eval2.value() + ") % " + eval2.value() + ");\n          } else {\n            " + ev.value() + "=" + remainder + ";\n          }\n        " : "\n          " + javaType + " " + remainder + " = " + eval1.value() + " % " + eval2.value() + ";\n          if (" + remainder + " < 0) {\n            " + ev.value() + "=(" + remainder + " + " + eval2.value() + ") % " + eval2.value() + ";\n          } else {\n            " + ev.value() + "=" + remainder + ";\n          }\n        ";
        }
        if (!this.left().nullable() && !this.right().nullable()) {
            String divByZero = this.failOnError() ? "throw QueryExecutionErrors.remainderByZeroError(" + errorContext + ");" : ev.isNull() + " = true;";
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (", ") {\n          ", "\n        } else {\n          ", "\n          ", "\n        }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), isZero, divByZero, eval1.code(), result})), ev.copy$default$2(), ev.copy$default$3());
        }
        Object nullOnErrorCondition = this.failOnError() ? "" : " || " + isZero;
        String failOnErrorBranch = this.failOnError() ? "if (" + isZero + ") throw QueryExecutionErrors.remainderByZeroError(" + errorContext + ");" : "";
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        boolean ", " = false;\n        ", " ", " = ", ";\n        if (", "", ") {\n          ", " = true;\n        } else {\n          ", "\n          if (", ") {\n            ", " = true;\n          } else {\n            ", "\n            ", "\n          }\n        }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), eval2.isNull(), nullOnErrorCondition, ev.isNull(), eval1.code(), eval1.isNull(), ev.isNull(), failOnErrorBranch, result})), ev.copy$default$2(), ev.copy$default$3());
    }

    private int pmod(int a, int n) {
        int r = a % n;
        if (r < 0) {
            return (r + n) % n;
        }
        return r;
    }

    private long pmod(long a, long n) {
        long r = a % n;
        if (r < 0L) {
            return (r + n) % n;
        }
        return r;
    }

    private byte pmod(byte a, byte n) {
        int r = a % n;
        if (r < 0) {
            return (byte)((r + n) % n);
        }
        return (byte)r;
    }

    private double pmod(double a, double n) {
        double r = a % n;
        if (r < 0.0) {
            return (r + n) % n;
        }
        return r;
    }

    private short pmod(short a, short n) {
        int r = a % n;
        if (r < 0) {
            return (short)((r + n) % n);
        }
        return (short)r;
    }

    private float pmod(float a, float n) {
        float r = a % n;
        if (r < 0.0f) {
            return (r + n) % n;
        }
        return r;
    }

    private Decimal pmod(Decimal a, Decimal n) {
        Decimal r = a.$percent(n);
        if (r != null && r.compare(Decimal$.MODULE$.ZERO()) < 0) {
            return r.$plus(n).$percent(n);
        }
        return r;
    }

    @Override
    public String sql() {
        return this.prettyName() + "(" + this.left().sql() + ", " + this.right().sql() + ")";
    }

    @Override
    public Pmod withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Pmod copy(Expression left, Expression right, NumericEvalContext evalContext) {
        return new Pmod(left, right, evalContext);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public NumericEvalContext copy$default$3() {
        return this.evalContext();
    }

    @Override
    public String productPrefix() {
        return "Pmod";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalContext();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Pmod;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "evalContext";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Pmod)) return false;
        boolean bl = true;
        if (!bl) return false;
        Pmod pmod = (Pmod)x$1;
        Expression expression = this.left();
        Expression expression2 = pmod.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = pmod.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        NumericEvalContext numericEvalContext = this.evalContext();
        NumericEvalContext numericEvalContext2 = pmod.evalContext();
        if (numericEvalContext == null) {
            if (numericEvalContext2 != null) {
                return false;
            }
        } else if (!((Object)numericEvalContext).equals(numericEvalContext2)) return false;
        if (!pmod.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isZero$3(Object x) {
        return ((Decimal)x).isZero();
    }

    public static final /* synthetic */ boolean $anonfun$isZero$4(Object x) {
        return BoxesRunTime.equals((Object)x, (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public Pmod(Expression left, Expression right, NumericEvalContext evalContext) {
        this.left = left;
        this.right = right;
        this.evalContext = evalContext;
    }

    public Pmod(Expression left, Expression right) {
        this(left, right, NumericEvalContext$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

