/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.FieldName;
import org.apache.spark.sql.catalyst.analysis.FieldPosition;
import org.apache.spark.sql.catalyst.analysis.ResolvedFieldName;
import org.apache.spark.sql.catalyst.analysis.ResolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.ResolvedIdentifier$;
import org.apache.spark.sql.catalyst.analysis.ResolvedPersistentView;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.analysis.ResolvedTempView;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFieldName;
import org.apache.spark.sql.catalyst.analysis.ViewSchemaMode;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.AddColumns;
import org.apache.spark.sql.catalyst.plans.logical.AlterColumnSpec;
import org.apache.spark.sql.catalyst.plans.logical.AlterColumns;
import org.apache.spark.sql.catalyst.plans.logical.AlterViewAs;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.CreateTempView;
import org.apache.spark.sql.catalyst.plans.logical.CreateView;
import org.apache.spark.sql.catalyst.plans.logical.DefaultValueExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.QualifiedColType;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceColumns;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.catalyst.plans.logical.TableSpec;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.V2CreateTablePlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.streaming.StreamingSourceIdentifyingName;
import org.apache.spark.sql.catalyst.trees.CurrentOrigin$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.IdentityColumnSpec;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringHelper$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

public final class ApplyDefaultCollation$
extends Rule<LogicalPlan> {
    public static final ApplyDefaultCollation$ MODULE$ = new ApplyDefaultCollation$();

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        LogicalPlan preprocessedPlan = this.resolveDefaultCollation(this.pruneRedundantAlterColumnTypes(plan2));
        Option<String> option = this.fetchDefaultCollation(preprocessedPlan);
        if (option instanceof Some) {
            Some some = (Some)option;
            String collation = (String)some.value();
            return this.transform(preprocessedPlan, collation);
        }
        if (None$.MODULE$.equals(option)) {
            return preprocessedPlan;
        }
        throw new MatchError(option);
    }

    public boolean needsResolution(Seq<Expression> expressions) {
        return expressions.exists((Function1 & Serializable)expression -> BoxesRunTime.boxToBoolean((boolean)ApplyDefaultCollation$.MODULE$.needsResolution(expression)));
    }

    public boolean needsResolution(Expression expression) {
        return this.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$transformExpression().isDefinedAt((Object)expression);
    }

    private Option<String> fetchDefaultCollation(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof CreateTable) {
            CreateTable createTable = (CreateTable)logicalPlan;
            TableSpecBase tableSpec = createTable.tableSpec();
            if (createTable.name() instanceof ResolvedIdentifier && tableSpec instanceof TableSpec) {
                TableSpec tableSpec2 = (TableSpec)tableSpec;
                return tableSpec2.collation();
            }
        }
        if (logicalPlan instanceof CreateTableAsSelect) {
            CreateTableAsSelect createTableAsSelect = (CreateTableAsSelect)logicalPlan;
            TableSpecBase tableSpec = createTableAsSelect.tableSpec();
            if (createTableAsSelect.name() instanceof ResolvedIdentifier && tableSpec instanceof TableSpec) {
                TableSpec tableSpec3 = (TableSpec)tableSpec;
                return tableSpec3.collation();
            }
        }
        if (logicalPlan instanceof ReplaceTableAsSelect) {
            ReplaceTableAsSelect replaceTableAsSelect = (ReplaceTableAsSelect)logicalPlan;
            TableSpecBase tableSpec = replaceTableAsSelect.tableSpec();
            if (replaceTableAsSelect.name() instanceof ResolvedIdentifier && tableSpec instanceof TableSpec) {
                TableSpec tableSpec4 = (TableSpec)tableSpec;
                return tableSpec4.collation();
            }
        }
        if (logicalPlan instanceof CreateView) {
            CreateView createView = (CreateView)logicalPlan;
            return createView.collation();
        }
        if (logicalPlan instanceof ReplaceTable) {
            ReplaceTable replaceTable = (ReplaceTable)logicalPlan;
            TableSpecBase tableSpec = replaceTable.tableSpec();
            if (replaceTable.name() instanceof ResolvedIdentifier && tableSpec instanceof TableSpec) {
                TableSpec tableSpec5 = (TableSpec)tableSpec;
                return tableSpec5.collation();
            }
        }
        if (logicalPlan instanceof CreateTempView) {
            LogicalPlan logicalPlan2 = logicalPlan;
            return ((CreateTempView)((Object)logicalPlan2)).collation();
        }
        if (logicalPlan instanceof AddColumns) {
            AddColumns addColumns = (AddColumns)logicalPlan;
            return this.getCollationFromTableProps(addColumns.table());
        }
        if (logicalPlan instanceof ReplaceColumns) {
            ReplaceColumns replaceColumns = (ReplaceColumns)logicalPlan;
            return this.getCollationFromTableProps(replaceColumns.table());
        }
        if (logicalPlan instanceof AlterColumns) {
            AlterColumns alterColumns = (AlterColumns)logicalPlan;
            return this.getCollationFromTableProps(alterColumns.table());
        }
        if (logicalPlan instanceof AlterViewAs) {
            AlterViewAs alterViewAs = (AlterViewAs)logicalPlan;
            LogicalPlan logicalPlan3 = alterViewAs.child();
            if (logicalPlan3 instanceof ResolvedPersistentView) {
                ResolvedPersistentView resolvedPersistentView = (ResolvedPersistentView)logicalPlan3;
                return resolvedPersistentView.metadata().collation();
            }
            if (logicalPlan3 instanceof ResolvedTempView) {
                ResolvedTempView resolvedTempView = (ResolvedTempView)logicalPlan3;
                return resolvedTempView.metadata().collation();
            }
            return None$.MODULE$;
        }
        if (AnalysisContext$.MODULE$.get().collation().isDefined()) {
            return AnalysisContext$.MODULE$.get().collation();
        }
        return None$.MODULE$;
    }

    private Option<String> getCollationFromTableProps(LogicalPlan t) {
        ResolvedTable resolvedTable;
        LogicalPlan logicalPlan = t;
        if (logicalPlan instanceof ResolvedTable && (resolvedTable = (ResolvedTable)logicalPlan).table().properties().containsKey("collation")) {
            return new Some((Object)resolvedTable.table().properties().get("collation"));
        }
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LogicalPlan resolveDefaultCollation(LogicalPlan plan2) {
        LogicalPlan logicalPlan;
        try {
            AlterViewAs alterViewAs;
            LogicalPlan resolvedPersistentView;
            ResolvedIdentifier resolvedIdentifier;
            Option<Tuple2<CatalogPlugin, Identifier>> option;
            CreateView createView;
            LogicalPlan logicalPlan2;
            LogicalPlan logicalPlan3 = plan2;
            if (logicalPlan3 instanceof CreateTable) {
                ResolvedIdentifier resolvedIdentifier2;
                Option<Tuple2<CatalogPlugin, Identifier>> option2;
                CreateTable createTable = (CreateTable)logicalPlan3;
                LogicalPlan logicalPlan4 = createTable.name();
                TableSpecBase tableSpec = createTable.tableSpec();
                if (logicalPlan4 instanceof ResolvedIdentifier && !(option2 = ResolvedIdentifier$.MODULE$.unapply(resolvedIdentifier2 = (ResolvedIdentifier)logicalPlan4)).isEmpty()) {
                    CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option2.get())._1();
                    Identifier identifier = (Identifier)((Tuple2)option2.get())._2();
                    if (catalog instanceof SupportsNamespaces) {
                        TableSpec tableSpec2;
                        SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalog;
                        if (tableSpec instanceof TableSpec && (tableSpec2 = (TableSpec)tableSpec).collation().isEmpty()) {
                            Option<String> x$1 = this.getCollationFromSchemaMetadata(supportsNamespaces, identifier.namespace());
                            scala.collection.immutable.Map<String, String> x$2 = tableSpec2.copy$default$1();
                            Option<String> x$3 = tableSpec2.copy$default$2();
                            scala.collection.immutable.Map<String, String> x$4 = tableSpec2.copy$default$3();
                            Option<String> x$5 = tableSpec2.copy$default$4();
                            Option<String> x$6 = tableSpec2.copy$default$5();
                            Option<SerdeInfo> x$7 = tableSpec2.copy$default$7();
                            boolean x$8 = tableSpec2.copy$default$8();
                            Seq<Constraint> x$9 = tableSpec2.copy$default$9();
                            TableSpec x$10 = tableSpec2.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9);
                            LogicalPlan x$11 = createTable.copy$default$1();
                            Seq<ColumnDefinition> x$12 = createTable.copy$default$2();
                            Seq<Transform> x$13 = createTable.copy$default$3();
                            boolean x$14 = createTable.copy$default$5();
                            logicalPlan = createTable.copy(x$11, x$12, x$13, x$10, x$14);
                            return logicalPlan;
                        }
                    }
                }
            }
            if (logicalPlan3 instanceof CreateTableAsSelect) {
                ResolvedIdentifier resolvedIdentifier3;
                Option<Tuple2<CatalogPlugin, Identifier>> option3;
                CreateTableAsSelect createTableAsSelect = (CreateTableAsSelect)logicalPlan3;
                LogicalPlan logicalPlan5 = createTableAsSelect.name();
                TableSpecBase tableSpec = createTableAsSelect.tableSpec();
                if (logicalPlan5 instanceof ResolvedIdentifier && !(option3 = ResolvedIdentifier$.MODULE$.unapply(resolvedIdentifier3 = (ResolvedIdentifier)logicalPlan5)).isEmpty()) {
                    CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option3.get())._1();
                    Identifier identifier = (Identifier)((Tuple2)option3.get())._2();
                    if (catalog instanceof SupportsNamespaces) {
                        TableSpec tableSpec3;
                        SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalog;
                        if (tableSpec instanceof TableSpec && (tableSpec3 = (TableSpec)tableSpec).collation().isEmpty()) {
                            Option<String> x$15 = this.getCollationFromSchemaMetadata(supportsNamespaces, identifier.namespace());
                            scala.collection.immutable.Map<String, String> x$16 = tableSpec3.copy$default$1();
                            Option<String> x$17 = tableSpec3.copy$default$2();
                            scala.collection.immutable.Map<String, String> x$18 = tableSpec3.copy$default$3();
                            Option<String> x$19 = tableSpec3.copy$default$4();
                            Option<String> x$20 = tableSpec3.copy$default$5();
                            Option<SerdeInfo> x$21 = tableSpec3.copy$default$7();
                            boolean x$22 = tableSpec3.copy$default$8();
                            Seq<Constraint> x$23 = tableSpec3.copy$default$9();
                            TableSpec x$24 = tableSpec3.copy(x$16, x$17, x$18, x$19, x$20, x$15, x$21, x$22, x$23);
                            LogicalPlan x$25 = createTableAsSelect.copy$default$1();
                            Seq<Transform> x$26 = createTableAsSelect.copy$default$2();
                            LogicalPlan x$27 = createTableAsSelect.copy$default$3();
                            scala.collection.immutable.Map<String, String> x$28 = createTableAsSelect.copy$default$5();
                            boolean x$29 = createTableAsSelect.copy$default$6();
                            boolean x$30 = createTableAsSelect.copy$default$7();
                            logicalPlan = createTableAsSelect.copy(x$25, x$26, x$27, x$24, x$28, x$29, x$30);
                            return logicalPlan;
                        }
                    }
                }
            }
            if (logicalPlan3 instanceof ReplaceTableAsSelect) {
                ResolvedIdentifier resolvedIdentifier4;
                Option<Tuple2<CatalogPlugin, Identifier>> option4;
                ReplaceTableAsSelect replaceTableAsSelect = (ReplaceTableAsSelect)logicalPlan3;
                LogicalPlan logicalPlan6 = replaceTableAsSelect.name();
                TableSpecBase tableSpec = replaceTableAsSelect.tableSpec();
                if (logicalPlan6 instanceof ResolvedIdentifier && !(option4 = ResolvedIdentifier$.MODULE$.unapply(resolvedIdentifier4 = (ResolvedIdentifier)logicalPlan6)).isEmpty()) {
                    CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option4.get())._1();
                    Identifier identifier = (Identifier)((Tuple2)option4.get())._2();
                    if (catalog instanceof SupportsNamespaces) {
                        TableSpec tableSpec4;
                        SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalog;
                        if (tableSpec instanceof TableSpec && (tableSpec4 = (TableSpec)tableSpec).collation().isEmpty()) {
                            Option<String> x$31 = this.getCollationFromSchemaMetadata(supportsNamespaces, identifier.namespace());
                            scala.collection.immutable.Map<String, String> x$32 = tableSpec4.copy$default$1();
                            Option<String> x$33 = tableSpec4.copy$default$2();
                            scala.collection.immutable.Map<String, String> x$34 = tableSpec4.copy$default$3();
                            Option<String> x$35 = tableSpec4.copy$default$4();
                            Option<String> x$36 = tableSpec4.copy$default$5();
                            Option<SerdeInfo> x$37 = tableSpec4.copy$default$7();
                            boolean x$38 = tableSpec4.copy$default$8();
                            Seq<Constraint> x$39 = tableSpec4.copy$default$9();
                            TableSpec x$40 = tableSpec4.copy(x$32, x$33, x$34, x$35, x$36, x$31, x$37, x$38, x$39);
                            LogicalPlan x$41 = replaceTableAsSelect.copy$default$1();
                            Seq<Transform> x$42 = replaceTableAsSelect.copy$default$2();
                            LogicalPlan x$43 = replaceTableAsSelect.copy$default$3();
                            scala.collection.immutable.Map<String, String> x$44 = replaceTableAsSelect.copy$default$5();
                            boolean x$45 = replaceTableAsSelect.copy$default$6();
                            boolean x$46 = replaceTableAsSelect.copy$default$7();
                            logicalPlan = replaceTableAsSelect.copy(x$41, x$42, x$43, x$40, x$44, x$45, x$46);
                            return logicalPlan;
                        }
                    }
                }
            }
            if (logicalPlan3 instanceof ReplaceTable) {
                ResolvedIdentifier resolvedIdentifier5;
                Option<Tuple2<CatalogPlugin, Identifier>> option5;
                ReplaceTable replaceTable = (ReplaceTable)logicalPlan3;
                LogicalPlan logicalPlan7 = replaceTable.name();
                TableSpecBase tableSpec = replaceTable.tableSpec();
                if (logicalPlan7 instanceof ResolvedIdentifier && !(option5 = ResolvedIdentifier$.MODULE$.unapply(resolvedIdentifier5 = (ResolvedIdentifier)logicalPlan7)).isEmpty()) {
                    CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option5.get())._1();
                    Identifier identifier = (Identifier)((Tuple2)option5.get())._2();
                    if (catalog instanceof SupportsNamespaces) {
                        TableSpec tableSpec5;
                        SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalog;
                        if (tableSpec instanceof TableSpec && (tableSpec5 = (TableSpec)tableSpec).collation().isEmpty()) {
                            Option<String> x$47 = this.getCollationFromSchemaMetadata(supportsNamespaces, identifier.namespace());
                            scala.collection.immutable.Map<String, String> x$48 = tableSpec5.copy$default$1();
                            Option<String> x$49 = tableSpec5.copy$default$2();
                            scala.collection.immutable.Map<String, String> x$50 = tableSpec5.copy$default$3();
                            Option<String> x$51 = tableSpec5.copy$default$4();
                            Option<String> x$52 = tableSpec5.copy$default$5();
                            Option<SerdeInfo> x$53 = tableSpec5.copy$default$7();
                            boolean x$54 = tableSpec5.copy$default$8();
                            Seq<Constraint> x$55 = tableSpec5.copy$default$9();
                            TableSpec x$56 = tableSpec5.copy(x$48, x$49, x$50, x$51, x$52, x$47, x$53, x$54, x$55);
                            LogicalPlan x$57 = replaceTable.copy$default$1();
                            Seq<ColumnDefinition> x$58 = replaceTable.copy$default$2();
                            Seq<Transform> x$59 = replaceTable.copy$default$3();
                            boolean x$60 = replaceTable.copy$default$5();
                            logicalPlan = replaceTable.copy(x$57, x$58, x$59, x$56, x$60);
                            return logicalPlan;
                        }
                    }
                }
            }
            if (logicalPlan3 instanceof CreateView && (logicalPlan2 = (createView = (CreateView)logicalPlan3).child()) instanceof ResolvedIdentifier && !(option = ResolvedIdentifier$.MODULE$.unapply(resolvedIdentifier = (ResolvedIdentifier)logicalPlan2)).isEmpty()) {
                CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
                Identifier identifier = (Identifier)((Tuple2)option.get())._2();
                if (catalog instanceof SupportsNamespaces) {
                    SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalog;
                    if (createView.collation().isEmpty()) {
                        CreateView newCreateView = (CreateView)CurrentOrigin$.MODULE$.withOrigin(createView.origin(), (Function0 & Serializable)() -> {
                            Option<String> x$61 = MODULE$.getCollationFromSchemaMetadata(supportsNamespaces, identifier.namespace());
                            LogicalPlan x$62 = createView.copy$default$1();
                            Seq<Tuple2<String, Option<String>>> x$63 = createView.copy$default$2();
                            Option<String> x$64 = createView.copy$default$3();
                            scala.collection.immutable.Map<String, String> x$65 = createView.copy$default$5();
                            Option<String> x$66 = createView.copy$default$6();
                            LogicalPlan x$67 = createView.copy$default$7();
                            boolean x$68 = createView.copy$default$8();
                            boolean x$69 = createView.copy$default$9();
                            ViewSchemaMode x$70 = createView.copy$default$10();
                            return createView.copy(x$62, x$63, x$64, x$61, x$65, x$66, x$67, x$68, x$69, x$70);
                        });
                        newCreateView.copyTagsFrom(createView);
                        logicalPlan = newCreateView;
                        return logicalPlan;
                    }
                }
            }
            if (logicalPlan3 instanceof AlterViewAs && (resolvedPersistentView = (alterViewAs = (AlterViewAs)logicalPlan3).child()) instanceof ResolvedPersistentView) {
                ResolvedPersistentView resolvedPersistentView2 = (ResolvedPersistentView)resolvedPersistentView;
                CatalogPlugin catalog = resolvedPersistentView2.catalog();
                Identifier identifier = resolvedPersistentView2.identifier();
                if (catalog instanceof SupportsNamespaces) {
                    SupportsNamespaces supportsNamespaces = (SupportsNamespaces)catalog;
                    if (resolvedPersistentView2.metadata().collation().isEmpty()) {
                        Option<String> x$71 = this.getCollationFromSchemaMetadata(supportsNamespaces, identifier.namespace());
                        TableIdentifier x$72 = resolvedPersistentView2.metadata().copy$default$1();
                        CatalogTableType x$73 = resolvedPersistentView2.metadata().copy$default$2();
                        CatalogStorageFormat x$74 = resolvedPersistentView2.metadata().copy$default$3();
                        StructType x$75 = resolvedPersistentView2.metadata().copy$default$4();
                        Option<String> x$76 = resolvedPersistentView2.metadata().copy$default$5();
                        Seq<String> x$77 = resolvedPersistentView2.metadata().copy$default$6();
                        Option<BucketSpec> x$78 = resolvedPersistentView2.metadata().copy$default$7();
                        String x$79 = resolvedPersistentView2.metadata().copy$default$8();
                        long x$80 = resolvedPersistentView2.metadata().copy$default$9();
                        long x$81 = resolvedPersistentView2.metadata().copy$default$10();
                        String x$82 = resolvedPersistentView2.metadata().copy$default$11();
                        scala.collection.immutable.Map<String, String> x$83 = resolvedPersistentView2.metadata().copy$default$12();
                        Option<CatalogStatistics> x$84 = resolvedPersistentView2.metadata().copy$default$13();
                        Option<String> x$85 = resolvedPersistentView2.metadata().copy$default$14();
                        Option<String> x$86 = resolvedPersistentView2.metadata().copy$default$15();
                        Seq<String> x$87 = resolvedPersistentView2.metadata().copy$default$17();
                        boolean x$88 = resolvedPersistentView2.metadata().copy$default$18();
                        boolean x$89 = resolvedPersistentView2.metadata().copy$default$19();
                        scala.collection.immutable.Map<String, String> x$90 = resolvedPersistentView2.metadata().copy$default$20();
                        Option<String> x$91 = resolvedPersistentView2.metadata().copy$default$21();
                        Option<StreamingSourceIdentifyingName> x$92 = resolvedPersistentView2.metadata().copy$default$22();
                        CatalogTable x$93 = resolvedPersistentView2.metadata().copy(x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85, x$86, x$71, x$87, x$88, x$89, x$90, x$91, x$92);
                        CatalogPlugin x$94 = resolvedPersistentView2.copy$default$1();
                        Identifier x$95 = resolvedPersistentView2.copy$default$2();
                        ResolvedPersistentView newResolvedPersistentView = resolvedPersistentView2.copy(x$94, x$95, x$93);
                        AlterViewAs newAlterViewAs = (AlterViewAs)CurrentOrigin$.MODULE$.withOrigin(alterViewAs.origin(), (Function0 & Serializable)() -> alterViewAs.copy(newResolvedPersistentView, alterViewAs.copy$default$2(), alterViewAs.copy$default$3()));
                        newAlterViewAs.copyTagsFrom(alterViewAs);
                        logicalPlan = newAlterViewAs;
                        return logicalPlan;
                    }
                }
            }
            logicalPlan = logicalPlan3;
            return logicalPlan;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 == null) throw throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) throw throwable;
            logicalPlan = plan2;
            return logicalPlan;
        }
    }

    private Option<String> getCollationFromSchemaMetadata(SupportsNamespaces catalog, String[] schemaName) {
        Map<String, String> metadata = catalog.loadNamespaceMetadata(schemaName);
        return Option$.MODULE$.apply((Object)metadata.get("collation"));
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$isCreateOrAlterPlan(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        return logicalPlan instanceof V2CreateTablePlan ? true : (logicalPlan instanceof ReplaceTable ? true : (logicalPlan instanceof CreateView ? true : (logicalPlan instanceof AlterViewAs ? true : logicalPlan instanceof CreateTempView)));
    }

    private LogicalPlan transform(LogicalPlan plan2, String collation) {
        return plan2.resolveOperators((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(collation){
            private static final long serialVersionUID = 0L;
            private final String collation$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$isCreateOrAlterPlan(A1) || AnalysisContext$.MODULE$.get().collation().isDefined()) {
                    return (B1)ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$transformPlan(A1, this.collation$1);
                }
                if (A1 instanceof AddColumns) {
                    AddColumns addColumns = (AddColumns)A1;
                    Seq<QualifiedColType> x$1 = ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$replaceColumnTypes(addColumns.columnsToAdd(), this.collation$1);
                    LogicalPlan x$2 = addColumns.copy$default$1();
                    return (B1)addColumns.copy(x$2, x$1);
                }
                if (A1 instanceof ReplaceColumns) {
                    ReplaceColumns replaceColumns = (ReplaceColumns)A1;
                    Seq<QualifiedColType> x$3 = ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$replaceColumnTypes(replaceColumns.columnsToAdd(), this.collation$1);
                    LogicalPlan x$4 = replaceColumns.copy$default$1();
                    return (B1)replaceColumns.copy(x$4, x$3);
                }
                if (A1 instanceof AlterColumns) {
                    AlterColumns alterColumns = (AlterColumns)A1;
                    LogicalPlan logicalPlan = alterColumns.table();
                    Seq<AlterColumnSpec> specs = alterColumns.specs();
                    if (logicalPlan instanceof ResolvedTable && specs != null) {
                        Seq newSpecs;
                        Seq<AlterColumnSpec> seq = specs;
                        Seq x$12 = newSpecs = (Seq)seq.map((Function1 & Serializable)x0$1 -> {
                            AlterColumnSpec alterColumnSpec = x0$1;
                            if (ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$shouldApplyDefaultCollationToAlterColumn(alterColumnSpec)) {
                                Some x$5 = new Some((Object)DataTypeUtils$.MODULE$.replaceDefaultStringCharAndVarcharTypes((DataType)alterColumnSpec.newDataType().get(), $this.collation$1));
                                FieldName x$6 = alterColumnSpec.copy$default$1();
                                Option<Object> x$7 = alterColumnSpec.copy$default$3();
                                Option<String> x$8 = alterColumnSpec.copy$default$4();
                                Option<FieldPosition> x$9 = alterColumnSpec.copy$default$5();
                                Option<DefaultValueExpression> x$10 = alterColumnSpec.copy$default$6();
                                boolean x$11 = alterColumnSpec.copy$default$7();
                                return alterColumnSpec.copy(x$6, (Option<DataType>)x$5, x$7, x$8, x$9, x$10, x$11);
                            }
                            return alterColumnSpec;
                        });
                        LogicalPlan x$13 = alterColumns.copy$default$1();
                        return (B1)alterColumns.copy(x$13, (Seq<AlterColumnSpec>)x$12);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$isCreateOrAlterPlan(logicalPlan) || AnalysisContext$.MODULE$.get().collation().isDefined()) {
                    return true;
                }
                if (logicalPlan instanceof AddColumns) {
                    return true;
                }
                if (logicalPlan instanceof ReplaceColumns) {
                    return true;
                }
                if (logicalPlan instanceof AlterColumns) {
                    AlterColumns alterColumns = (AlterColumns)logicalPlan;
                    LogicalPlan logicalPlan2 = alterColumns.table();
                    Seq<AlterColumnSpec> specs = alterColumns.specs();
                    if (logicalPlan2 instanceof ResolvedTable && specs != null) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.collation$1 = collation$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollation$$anonfun$transform$1 org.apache.spark.sql.catalyst.plans.logical.AlterColumnSpec )}, serializedLambda);
            }
        });
    }

    private LogicalPlan pruneRedundantAlterColumnTypes(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof AlterColumns) {
            AlterColumns alterColumns = (AlterColumns)logicalPlan;
            LogicalPlan logicalPlan2 = alterColumns.table();
            Seq<AlterColumnSpec> specs = alterColumns.specs();
            if (logicalPlan2 instanceof ResolvedTable && specs != null) {
                Seq<AlterColumnSpec> seq = specs;
                Seq resolvedSpecs = (Seq)seq.map((Function1 & Serializable)spec -> {
                    if (MODULE$.isAlterColumnNOP((AlterColumnSpec)spec)) {
                        None$ x$1 = None$.MODULE$;
                        FieldName x$2 = spec.copy$default$1();
                        Option<Object> x$3 = spec.copy$default$3();
                        Option<String> x$4 = spec.copy$default$4();
                        Option<FieldPosition> x$5 = spec.copy$default$5();
                        Option<DefaultValueExpression> x$6 = spec.copy$default$6();
                        boolean x$7 = spec.copy$default$7();
                        return spec.copy(x$2, (Option<DataType>)x$1, x$3, x$4, x$5, x$6, x$7);
                    }
                    return spec;
                });
                AlterColumns newAlterColumns = (AlterColumns)CurrentOrigin$.MODULE$.withOrigin(alterColumns.origin(), (Function0 & Serializable)() -> {
                    Seq x$8 = resolvedSpecs;
                    LogicalPlan x$9 = alterColumns.copy$default$1();
                    return alterColumns.copy(x$9, (Seq<AlterColumnSpec>)x$8);
                });
                newAlterColumns.copyTagsFrom(alterColumns);
                return newAlterColumns;
            }
        }
        return plan2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAlterColumnNOP(AlterColumnSpec spec) {
        DataType colType = this.getFieldType(spec.column());
        if (!spec.newDataType().isDefined()) return false;
        if (!(colType instanceof StringType)) return false;
        if (!DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)spec.newDataType().get())) return false;
        StringType stringType = StringHelper$.MODULE$.removeCollation((StringType)colType);
        StringType stringType2 = StringHelper$.MODULE$.removeCollation((StringType)spec.newDataType().get());
        if (stringType != null) {
            if (!stringType.equals(stringType2)) return false;
            return true;
        }
        if (stringType2 == null) return true;
        return false;
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$shouldApplyDefaultCollationToAlterColumn(AlterColumnSpec alterColumnSpec) {
        DataType colType = this.getFieldType(alterColumnSpec.column());
        return alterColumnSpec.newDataType().isDefined() && DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType((DataType)alterColumnSpec.newDataType().get()) && (!(colType instanceof StringType) || !DataTypeUtils$.MODULE$.areSameBaseType((StringType)colType, (StringType)alterColumnSpec.newDataType().get()));
    }

    private DataType getFieldType(FieldName fieldName) {
        FieldName fieldName2 = fieldName;
        if (fieldName2 instanceof ResolvedFieldName) {
            ResolvedFieldName resolvedFieldName = (ResolvedFieldName)fieldName2;
            StructField field = resolvedFieldName.field();
            return (DataType)CharVarcharUtils$.MODULE$.getRawType(field.metadata()).getOrElse((Function0 & Serializable)() -> field.dataType());
        }
        if (fieldName2 instanceof UnresolvedFieldName) {
            UnresolvedFieldName unresolvedFieldName = (UnresolvedFieldName)fieldName2;
            Seq<String> name = unresolvedFieldName.name();
            throw SparkException$.MODULE$.internalError("Unexpected UnresolvedFieldName: " + name);
        }
        throw new MatchError((Object)fieldName2);
    }

    public LogicalPlan org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$transformPlan(LogicalPlan plan2, String collation) {
        LogicalPlan transformedPlan = plan2.resolveExpressionsUp((PartialFunction<Expression, Expression>)new Serializable(collation){
            private static final long serialVersionUID = 0L;
            private final String collation$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$transformExpression().andThen((Function1 & Serializable)x$1 -> (Expression)x$1.apply((Object)$this.collation$2)).applyOrElse(A1, (Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return true;
            }
            {
                this.collation$2 = collation$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollation$$anonfun$1 scala.Function1 ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
        return this.castDefaultStringExpressions(transformedPlan, StringType$.MODULE$.apply(collation));
    }

    public PartialFunction<Expression, Function1<String, Expression>> org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$transformExpression() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Cast cast;
                ColumnDefinition columnDefinition;
                A1 A1 = x1;
                if (A1 instanceof ColumnDefinition && ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType((columnDefinition = (ColumnDefinition)A1).dataType())) {
                    return (B1)(Function1 & Serializable)collation -> {
                        DataType x$1 = DataTypeUtils$.MODULE$.replaceDefaultStringCharAndVarcharTypes(columnDefinition.dataType(), (String)collation);
                        String x$2 = columnDefinition.copy$default$1();
                        boolean x$3 = columnDefinition.copy$default$3();
                        Option<String> x$4 = columnDefinition.copy$default$4();
                        Option<DefaultValueExpression> x$5 = columnDefinition.copy$default$5();
                        Option<String> x$6 = columnDefinition.copy$default$6();
                        Option<IdentityColumnSpec> x$7 = columnDefinition.copy$default$7();
                        Metadata x$8 = columnDefinition.copy$default$8();
                        return columnDefinition.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                    };
                }
                if (A1 instanceof Cast && ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType((cast = (Cast)A1).dataType()) && cast.containsTag(Cast$.MODULE$.USER_SPECIFIED_CAST())) {
                    return (B1)(Function1 & Serializable)collation -> {
                        DataType x$9 = DataTypeUtils$.MODULE$.replaceDefaultStringCharAndVarcharTypes(cast.dataType(), (String)collation);
                        Expression x$10 = cast.copy$default$1();
                        Option<String> x$11 = cast.copy$default$3();
                        Enumeration.Value x$12 = cast.copy$default$4();
                        return cast.copy(x$10, x$9, x$11, x$12);
                    };
                }
                if (A1 instanceof Literal) {
                    Literal literal = (Literal)A1;
                    Object value = literal.value();
                    DataType dt = literal.dataType();
                    if (ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType(dt)) {
                        return (B1)(Function1 & Serializable)collation -> new Literal(value, DataTypeUtils$.MODULE$.replaceDefaultStringCharAndVarcharTypes(dt, (String)collation));
                    }
                }
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    LogicalPlan plan2 = (LogicalPlan)subqueryExpression.plan();
                    return (B1)(Function1 & Serializable)collation -> {
                        LogicalPlan newPlan = plan2.resolveExpressionsUp((PartialFunction<Expression, Expression>)new Serializable(null, (String)collation){
                            private static final long serialVersionUID = 0L;
                            private final String collation$3;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                return (B1)ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$transformExpression().andThen((Function1 & Serializable)x$2 -> (Expression)x$2.apply((Object)$this.collation$3)).applyOrElse(A1, (Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
                            }

                            public final boolean isDefinedAt(Expression x1) {
                                Expression expression = x1;
                                return true;
                            }
                            {
                                this.collation$3 = collation$3;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollation$$anonfun$org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$transformExpression$1$$anonfun$2 scala.Function1 ), $anonfun$applyOrElse$9(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
                            }
                        });
                        return subqueryExpression.withNewPlan(newPlan);
                    };
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Literal literal;
                DataType dt;
                Cast cast;
                ColumnDefinition columnDefinition;
                Expression expression = x1;
                if (expression instanceof ColumnDefinition && ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType((columnDefinition = (ColumnDefinition)expression).dataType())) {
                    return true;
                }
                if (expression instanceof Cast && ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType((cast = (Cast)expression).dataType()) && cast.containsTag(Cast$.MODULE$.USER_SPECIFIED_CAST())) {
                    return true;
                }
                if (expression instanceof Literal && ApplyDefaultCollation$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType(dt = (literal = (Literal)expression).dataType())) {
                    return true;
                }
                return expression instanceof SubqueryExpression;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition java.lang.String ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.expressions.Cast java.lang.String ), $anonfun$applyOrElse$6(java.lang.Object org.apache.spark.sql.types.DataType java.lang.String ), $anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.expressions.SubqueryExpression java.lang.String )}, serializedLambda);
            }
        };
    }

    private LogicalPlan castDefaultStringExpressions(LogicalPlan plan2, StringType newType) {
        StringType stringType = newType;
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(stringType != null ? !stringType.equals(stringType$) : stringType$ != null)) {
            return plan2;
        }
        return plan2.resolveOperators((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(newType){
            private static final long serialVersionUID = 0L;
            private final StringType newType$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)A1.mapExpressions((Function1<Expression, Expression>)(Function1 & Serializable)ex -> ApplyDefaultCollation$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$inner$1(ex, $this.newType$1));
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return true;
            }
            {
                this.newType$1 = newType$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollation$$anonfun$castDefaultStringExpressions$4 org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType(DataType dataType2) {
        return dataType2.existsRecursively((Function1 & Serializable)dataType -> BoxesRunTime.boxToBoolean((boolean)DataTypeUtils$.MODULE$.isDefaultStringCharOrVarcharType(dataType)));
    }

    public Seq<QualifiedColType> org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$replaceColumnTypes(Seq<QualifiedColType> colTypes, String collation) {
        return (Seq)colTypes.map((Function1 & Serializable)x0$1 -> {
            QualifiedColType qualifiedColType = x0$1;
            if (MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$hasDefaultStringCharOrVarcharType(qualifiedColType.dataType())) {
                DataType replaced;
                DataType x$1 = replaced = DataTypeUtils$.MODULE$.replaceDefaultStringCharAndVarcharTypes(qualifiedColType.dataType(), collation);
                Option<FieldName> x$2 = qualifiedColType.copy$default$1();
                String x$3 = qualifiedColType.copy$default$2();
                boolean x$4 = qualifiedColType.copy$default$4();
                Option<String> x$5 = qualifiedColType.copy$default$5();
                Option<FieldPosition> x$6 = qualifiedColType.copy$default$6();
                Option<DefaultValueExpression> x$7 = qualifiedColType.copy$default$7();
                return qualifiedColType.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7);
            }
            return qualifiedColType;
        });
    }

    public static final Expression org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$inner$1(Expression ex2, StringType newType$1) {
        Expression expression = ex2;
        if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            Expression e = cast.child();
            DataType dt = cast.dataType();
            if (e instanceof DefaultStringProducingExpression) {
                DefaultStringProducingExpression defaultStringProducingExpression = (DefaultStringProducingExpression)((Object)e);
                StringType stringType = newType$1;
                DataType dataType = dt;
                if (!(stringType != null ? !stringType.equals(dataType) : dataType != null)) {
                    return cast.copy((Expression)((TreeNode)((Object)defaultStringProducingExpression)).withNewChildren((Seq)((TreeNode)((Object)defaultStringProducingExpression)).children().map((Function1 & Serializable)ex -> ApplyDefaultCollation$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$inner$1(ex, newType$1))), cast.copy$default$2(), cast.copy$default$3(), cast.copy$default$4());
                }
            }
        }
        if (expression instanceof DefaultStringProducingExpression) {
            DefaultStringProducingExpression defaultStringProducingExpression = (DefaultStringProducingExpression)((Object)expression);
            return new Cast((Expression)((TreeNode)((Object)defaultStringProducingExpression)).withNewChildren((Seq)((TreeNode)((Object)defaultStringProducingExpression)).children().map((Function1 & Serializable)ex -> ApplyDefaultCollation$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$inner$1(ex, newType$1))), (DataType)newType$1, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        }
        return (Expression)expression.withNewChildren((Seq)expression.children().map((Function1 & Serializable)ex -> ApplyDefaultCollation$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollation$$inner$1(ex, newType$1)));
    }

    private ApplyDefaultCollation$() {
    }
}

