/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.security.authentication;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.HttpMethod;
import org.sparkproject.jetty.security.AuthenticationState;
import org.sparkproject.jetty.security.RoleDelegateUserIdentity;
import org.sparkproject.jetty.security.SPNEGOUserPrincipal;
import org.sparkproject.jetty.security.ServerAuthException;
import org.sparkproject.jetty.security.UserIdentity;
import org.sparkproject.jetty.security.authentication.LoginAuthenticator;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.Session;
import org.sparkproject.jetty.util.Callback;

public class SPNEGOAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SPNEGOAuthenticator.class);
    private final String _type;
    private Duration _authenticationDuration = Duration.ofNanos(-1L);

    public SPNEGOAuthenticator() {
        this("SPNEGO");
    }

    public SPNEGOAuthenticator(String type) {
        this._type = type;
    }

    @Override
    public String getAuthenticationType() {
        return this._type;
    }

    public Duration getAuthenticationDuration() {
        return this._authenticationDuration;
    }

    public void setAuthenticationDuration(Duration authenticationDuration) {
        this._authenticationDuration = authenticationDuration;
    }

    @Override
    public UserIdentity login(String username, Object password, Request request, Response response) {
        RoleDelegateUserIdentity user = (RoleDelegateUserIdentity)this._loginService.login(username, password, request, request::getSession);
        if (user != null && user.isEstablished()) {
            this.updateSession(request, response);
        }
        return user;
    }

    @Override
    public AuthenticationState validateRequest(Request req, Response res, Callback callback) throws ServerAuthException {
        Duration authnDuration;
        UserIdentity identity;
        UserIdentityHolder holder;
        String header = req.getHeaders().get(this.getAuthorizationHeader());
        String spnegoToken = this.getSpnegoToken(header);
        Session httpSession = req.getSession(false);
        if (header != null && spnegoToken != null) {
            RoleDelegateUserIdentity identity2 = (RoleDelegateUserIdentity)this.login(null, spnegoToken, req, res);
            if (identity2.isEstablished()) {
                Duration authnDuration2;
                if (!AuthenticationState.Deferred.isDeferred(res)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending final token");
                    }
                    SPNEGOUserPrincipal principal = (SPNEGOUserPrincipal)identity2.getUserPrincipal();
                    this.setSpnegoToken(res, principal.getEncodedToken());
                }
                if (!(authnDuration2 = this.getAuthenticationDuration()).isNegative()) {
                    if (httpSession == null) {
                        httpSession = req.getSession(true);
                    }
                    httpSession.setAttribute(UserIdentityHolder.ATTRIBUTE, new UserIdentityHolder(identity2));
                }
                return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), identity2);
            }
            if (AuthenticationState.Deferred.isDeferred(res)) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending intermediate challenge");
            }
            SPNEGOUserPrincipal principal = (SPNEGOUserPrincipal)identity2.getUserPrincipal();
            this.sendChallenge(req, res, callback, principal.getEncodedToken());
            return AuthenticationState.CHALLENGE;
        }
        if (httpSession != null && (holder = (UserIdentityHolder)httpSession.getAttribute(UserIdentityHolder.ATTRIBUTE)) != null && (identity = holder._userIdentity) != null && !(authnDuration = this.getAuthenticationDuration()).isNegative()) {
            boolean expired;
            boolean bl = expired = !authnDuration.isZero() && Instant.now().isAfter(holder._validFrom.plus(authnDuration));
            if (!expired || !HttpMethod.GET.is(req.getMethod())) {
                return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), identity);
            }
        }
        if (AuthenticationState.Deferred.isDeferred(res)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending initial challenge");
        }
        this.sendChallenge(req, res, callback, null);
        return AuthenticationState.CHALLENGE;
    }

    private void sendChallenge(Request req, Response res, Callback callback, String token) {
        this.setSpnegoToken(res, token);
        Response.writeError(req, res, callback, this.getUnauthorizedStatusCode());
    }

    private void setSpnegoToken(Response response, String token) {
        Object value = HttpHeader.NEGOTIATE.asString();
        if (token != null) {
            value = (String)value + " " + token;
        }
        response.getHeaders().put(this.getChallengeHeader().asString(), (String)value);
    }

    private String getSpnegoToken(String header) {
        if (header == null) {
            return null;
        }
        String scheme = HttpHeader.NEGOTIATE.asString() + " ";
        if (header.regionMatches(true, 0, scheme, 0, scheme.length())) {
            return header.substring(scheme.length()).trim();
        }
        return null;
    }

    private static class UserIdentityHolder
    implements Serializable {
        private static final String ATTRIBUTE = UserIdentityHolder.class.getName();
        private final transient Instant _validFrom = Instant.now();
        private final transient UserIdentity _userIdentity;

        private UserIdentityHolder(UserIdentity userIdentity) {
            this._userIdentity = userIdentity;
        }
    }
}

