/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Bootstrap;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.BootstrapBuilder;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.BootstrapFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineReadinessGate;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineReadinessGateBuilder;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineReadinessGateFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineSpecFluent<A extends MachineSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private BootstrapBuilder bootstrap;
    private String clusterName;
    private String failureDomain;
    private ObjectReferenceBuilder infrastructureRef;
    private Duration nodeDeletionTimeout;
    private Duration nodeDrainTimeout;
    private Duration nodeVolumeDetachTimeout;
    private String providerID;
    private ArrayList<MachineReadinessGateBuilder> readinessGates = new ArrayList();
    private String version;

    public MachineSpecFluent() {
    }

    public MachineSpecFluent(MachineSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToReadinessGates(Collection<MachineReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (MachineReadinessGate item : items) {
            MachineReadinessGateBuilder builder = new MachineReadinessGateBuilder(item);
            this._visitables.get((Object)"readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)((Object)this);
    }

    public ReadinessGatesNested<A> addNewReadinessGate() {
        return new ReadinessGatesNested(-1, null);
    }

    public A addNewReadinessGate(String conditionType, String polarity) {
        return this.addToReadinessGates(new MachineReadinessGate(conditionType, polarity));
    }

    public ReadinessGatesNested<A> addNewReadinessGateLike(MachineReadinessGate item) {
        return new ReadinessGatesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToReadinessGates(MachineReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (MachineReadinessGate item : items) {
            MachineReadinessGateBuilder builder = new MachineReadinessGateBuilder(item);
            this._visitables.get((Object)"readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToReadinessGates(int index, MachineReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        MachineReadinessGateBuilder builder = new MachineReadinessGateBuilder(item);
        if (index < 0 || index >= this.readinessGates.size()) {
            this._visitables.get((Object)"readinessGates").add(builder);
            this.readinessGates.add(builder);
        } else {
            this._visitables.get((Object)"readinessGates").add(builder);
            this.readinessGates.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Bootstrap buildBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    public MachineReadinessGate buildFirstReadinessGate() {
        return this.readinessGates.get(0).build();
    }

    public ObjectReference buildInfrastructureRef() {
        return this.infrastructureRef != null ? this.infrastructureRef.build() : null;
    }

    public MachineReadinessGate buildLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1).build();
    }

    public MachineReadinessGate buildMatchingReadinessGate(Predicate<MachineReadinessGateBuilder> predicate) {
        for (MachineReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public MachineReadinessGate buildReadinessGate(int index) {
        return this.readinessGates.get(index).build();
    }

    public List<MachineReadinessGate> buildReadinessGates() {
        return this.readinessGates != null ? MachineSpecFluent.build(this.readinessGates) : null;
    }

    protected void copyInstance(MachineSpec instance) {
        MachineSpec machineSpec = instance = instance != null ? instance : new MachineSpec();
        if (instance != null) {
            this.withBootstrap(instance.getBootstrap());
            this.withClusterName(instance.getClusterName());
            this.withFailureDomain(instance.getFailureDomain());
            this.withInfrastructureRef(instance.getInfrastructureRef());
            this.withNodeDeletionTimeout(instance.getNodeDeletionTimeout());
            this.withNodeDrainTimeout(instance.getNodeDrainTimeout());
            this.withNodeVolumeDetachTimeout(instance.getNodeVolumeDetachTimeout());
            this.withProviderID(instance.getProviderID());
            this.withReadinessGates(instance.getReadinessGates());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public BootstrapNested<A> editBootstrap() {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(null));
    }

    public ReadinessGatesNested<A> editFirstReadinessGate() {
        if (this.readinessGates.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "readinessGates"));
        }
        return this.setNewReadinessGateLike(0, this.buildReadinessGate(0));
    }

    public InfrastructureRefNested<A> editInfrastructureRef() {
        return this.withNewInfrastructureRefLike(Optional.ofNullable(this.buildInfrastructureRef()).orElse(null));
    }

    public ReadinessGatesNested<A> editLastReadinessGate() {
        int index = this.readinessGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "readinessGates"));
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<MachineReadinessGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.readinessGates.size(); ++i) {
            if (!predicate.test(this.readinessGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "readinessGates"));
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public BootstrapNested<A> editOrNewBootstrap() {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(new BootstrapBuilder().build()));
    }

    public BootstrapNested<A> editOrNewBootstrapLike(Bootstrap item) {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(item));
    }

    public InfrastructureRefNested<A> editOrNewInfrastructureRef() {
        return this.withNewInfrastructureRefLike(Optional.ofNullable(this.buildInfrastructureRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public InfrastructureRefNested<A> editOrNewInfrastructureRefLike(ObjectReference item) {
        return this.withNewInfrastructureRefLike(Optional.ofNullable(this.buildInfrastructureRef()).orElse(item));
    }

    public ReadinessGatesNested<A> editReadinessGate(int index) {
        if (this.readinessGates.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "readinessGates"));
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineSpecFluent that = (MachineSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.bootstrap, (Object)that.bootstrap)) {
            return false;
        }
        if (!Objects.equals(this.clusterName, that.clusterName)) {
            return false;
        }
        if (!Objects.equals(this.failureDomain, that.failureDomain)) {
            return false;
        }
        if (!Objects.equals((Object)this.infrastructureRef, (Object)that.infrastructureRef)) {
            return false;
        }
        if (!Objects.equals(this.nodeDeletionTimeout, that.nodeDeletionTimeout)) {
            return false;
        }
        if (!Objects.equals(this.nodeDrainTimeout, that.nodeDrainTimeout)) {
            return false;
        }
        if (!Objects.equals(this.nodeVolumeDetachTimeout, that.nodeVolumeDetachTimeout)) {
            return false;
        }
        if (!Objects.equals(this.providerID, that.providerID)) {
            return false;
        }
        if (!Objects.equals(this.readinessGates, that.readinessGates)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getFailureDomain() {
        return this.failureDomain;
    }

    public Duration getNodeDeletionTimeout() {
        return this.nodeDeletionTimeout;
    }

    public Duration getNodeDrainTimeout() {
        return this.nodeDrainTimeout;
    }

    public Duration getNodeVolumeDetachTimeout() {
        return this.nodeVolumeDetachTimeout;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    public boolean hasClusterName() {
        return this.clusterName != null;
    }

    public boolean hasFailureDomain() {
        return this.failureDomain != null;
    }

    public boolean hasInfrastructureRef() {
        return this.infrastructureRef != null;
    }

    public boolean hasMatchingReadinessGate(Predicate<MachineReadinessGateBuilder> predicate) {
        for (MachineReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeDeletionTimeout() {
        return this.nodeDeletionTimeout != null;
    }

    public boolean hasNodeDrainTimeout() {
        return this.nodeDrainTimeout != null;
    }

    public boolean hasNodeVolumeDetachTimeout() {
        return this.nodeVolumeDetachTimeout != null;
    }

    public boolean hasProviderID() {
        return this.providerID != null;
    }

    public boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootstrap, this.clusterName, this.failureDomain, this.infrastructureRef, this.nodeDeletionTimeout, this.nodeDrainTimeout, this.nodeVolumeDetachTimeout, this.providerID, this.readinessGates, this.version, this.additionalProperties});
    }

    public A removeAllFromReadinessGates(Collection<MachineReadinessGate> items) {
        if (this.readinessGates == null) {
            return (A)((Object)this);
        }
        for (MachineReadinessGate item : items) {
            MachineReadinessGateBuilder builder = new MachineReadinessGateBuilder(item);
            this._visitables.get((Object)"readinessGates").remove((Object)builder);
            this.readinessGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromReadinessGates(MachineReadinessGate ... items) {
        if (this.readinessGates == null) {
            return (A)((Object)this);
        }
        for (MachineReadinessGate item : items) {
            MachineReadinessGateBuilder builder = new MachineReadinessGateBuilder(item);
            this._visitables.get((Object)"readinessGates").remove((Object)builder);
            this.readinessGates.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromReadinessGates(Predicate<MachineReadinessGateBuilder> predicate) {
        if (this.readinessGates == null) {
            return (A)((Object)this);
        }
        Iterator<MachineReadinessGateBuilder> each = this.readinessGates.iterator();
        List visitables = this._visitables.get((Object)"readinessGates");
        while (each.hasNext()) {
            MachineReadinessGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ReadinessGatesNested<A> setNewReadinessGateLike(int index, MachineReadinessGate item) {
        return new ReadinessGatesNested(index, item);
    }

    public A setToReadinessGates(int index, MachineReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        MachineReadinessGateBuilder builder = new MachineReadinessGateBuilder(item);
        if (index < 0 || index >= this.readinessGates.size()) {
            this._visitables.get((Object)"readinessGates").add(builder);
            this.readinessGates.add(builder);
        } else {
            this._visitables.get((Object)"readinessGates").add(builder);
            this.readinessGates.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrap != null) {
            sb.append("bootstrap:");
            sb.append((Object)this.bootstrap);
            sb.append(",");
        }
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName);
            sb.append(",");
        }
        if (this.failureDomain != null) {
            sb.append("failureDomain:");
            sb.append(this.failureDomain);
            sb.append(",");
        }
        if (this.infrastructureRef != null) {
            sb.append("infrastructureRef:");
            sb.append((Object)this.infrastructureRef);
            sb.append(",");
        }
        if (this.nodeDeletionTimeout != null) {
            sb.append("nodeDeletionTimeout:");
            sb.append(this.nodeDeletionTimeout);
            sb.append(",");
        }
        if (this.nodeDrainTimeout != null) {
            sb.append("nodeDrainTimeout:");
            sb.append(this.nodeDrainTimeout);
            sb.append(",");
        }
        if (this.nodeVolumeDetachTimeout != null) {
            sb.append("nodeVolumeDetachTimeout:");
            sb.append(this.nodeVolumeDetachTimeout);
            sb.append(",");
        }
        if (this.providerID != null) {
            sb.append("providerID:");
            sb.append(this.providerID);
            sb.append(",");
        }
        if (this.readinessGates != null && !this.readinessGates.isEmpty()) {
            sb.append("readinessGates:");
            sb.append(this.readinessGates);
            sb.append(",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBootstrap(Bootstrap bootstrap) {
        this._visitables.remove((Object)"bootstrap");
        if (bootstrap != null) {
            this.bootstrap = new BootstrapBuilder(bootstrap);
            this._visitables.get((Object)"bootstrap").add(this.bootstrap);
        } else {
            this.bootstrap = null;
            this._visitables.get((Object)"bootstrap").remove((Object)this.bootstrap);
        }
        return (A)((Object)this);
    }

    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)((Object)this);
    }

    public A withFailureDomain(String failureDomain) {
        this.failureDomain = failureDomain;
        return (A)((Object)this);
    }

    public A withInfrastructureRef(ObjectReference infrastructureRef) {
        this._visitables.remove((Object)"infrastructureRef");
        if (infrastructureRef != null) {
            this.infrastructureRef = new ObjectReferenceBuilder(infrastructureRef);
            this._visitables.get((Object)"infrastructureRef").add(this.infrastructureRef);
        } else {
            this.infrastructureRef = null;
            this._visitables.get((Object)"infrastructureRef").remove((Object)this.infrastructureRef);
        }
        return (A)((Object)this);
    }

    public BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNested(null);
    }

    public BootstrapNested<A> withNewBootstrapLike(Bootstrap item) {
        return new BootstrapNested(item);
    }

    public InfrastructureRefNested<A> withNewInfrastructureRef() {
        return new InfrastructureRefNested(null);
    }

    public InfrastructureRefNested<A> withNewInfrastructureRefLike(ObjectReference item) {
        return new InfrastructureRefNested(item);
    }

    public A withNodeDeletionTimeout(Duration nodeDeletionTimeout) {
        this.nodeDeletionTimeout = nodeDeletionTimeout;
        return (A)((Object)this);
    }

    public A withNodeDrainTimeout(Duration nodeDrainTimeout) {
        this.nodeDrainTimeout = nodeDrainTimeout;
        return (A)((Object)this);
    }

    public A withNodeVolumeDetachTimeout(Duration nodeVolumeDetachTimeout) {
        this.nodeVolumeDetachTimeout = nodeVolumeDetachTimeout;
        return (A)((Object)this);
    }

    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)((Object)this);
    }

    public A withReadinessGates(List<MachineReadinessGate> readinessGates) {
        if (this.readinessGates != null) {
            this._visitables.get((Object)"readinessGates").clear();
        }
        if (readinessGates != null) {
            this.readinessGates = new ArrayList();
            for (MachineReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)((Object)this);
    }

    public A withReadinessGates(MachineReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
            this._visitables.remove((Object)"readinessGates");
        }
        if (readinessGates != null) {
            for (MachineReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)((Object)this);
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public class ReadinessGatesNested<N>
    extends MachineReadinessGateFluent<ReadinessGatesNested<N>>
    implements Nested<N> {
        MachineReadinessGateBuilder builder;
        int index;

        ReadinessGatesNested(int index, MachineReadinessGate item) {
            this.index = index;
            this.builder = new MachineReadinessGateBuilder(this, item);
        }

        public N and() {
            return (N)MachineSpecFluent.this.setToReadinessGates(this.index, this.builder.build());
        }

        public N endReadinessGate() {
            return this.and();
        }
    }

    public class InfrastructureRefNested<N>
    extends ObjectReferenceFluent<InfrastructureRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        InfrastructureRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineSpecFluent.this.withInfrastructureRef(this.builder.build());
        }

        public N endInfrastructureRef() {
            return this.and();
        }
    }

    public class BootstrapNested<N>
    extends BootstrapFluent<BootstrapNested<N>>
    implements Nested<N> {
        BootstrapBuilder builder;

        BootstrapNested(Bootstrap item) {
            this.builder = new BootstrapBuilder(this, item);
        }

        public N and() {
            return (N)MachineSpecFluent.this.withBootstrap(this.builder.build());
        }

        public N endBootstrap() {
            return this.and();
        }
    }
}

