/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ContainerExtendedResourceRequest;
import io.fabric8.kubernetes.api.model.ContainerExtendedResourceRequestBuilder;
import io.fabric8.kubernetes.api.model.ContainerExtendedResourceRequestFluent;
import io.fabric8.kubernetes.api.model.PodExtendedResourceClaimStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodExtendedResourceClaimStatusFluent<A extends PodExtendedResourceClaimStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ContainerExtendedResourceRequestBuilder> requestMappings = new ArrayList();
    private String resourceClaimName;

    public PodExtendedResourceClaimStatusFluent() {
    }

    public PodExtendedResourceClaimStatusFluent(PodExtendedResourceClaimStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToRequestMappings(Collection<ContainerExtendedResourceRequest> items) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        for (ContainerExtendedResourceRequest item : items) {
            ContainerExtendedResourceRequestBuilder builder = new ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get((Object)"requestMappings").add(builder);
            this.requestMappings.add(builder);
        }
        return (A)((Object)this);
    }

    public RequestMappingsNested<A> addNewRequestMapping() {
        return new RequestMappingsNested(-1, null);
    }

    public A addNewRequestMapping(String containerName, String requestName, String resourceName) {
        return this.addToRequestMappings(new ContainerExtendedResourceRequest(containerName, requestName, resourceName));
    }

    public RequestMappingsNested<A> addNewRequestMappingLike(ContainerExtendedResourceRequest item) {
        return new RequestMappingsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRequestMappings(ContainerExtendedResourceRequest ... items) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        for (ContainerExtendedResourceRequest item : items) {
            ContainerExtendedResourceRequestBuilder builder = new ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get((Object)"requestMappings").add(builder);
            this.requestMappings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRequestMappings(int index, ContainerExtendedResourceRequest item) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        ContainerExtendedResourceRequestBuilder builder = new ContainerExtendedResourceRequestBuilder(item);
        if (index < 0 || index >= this.requestMappings.size()) {
            this._visitables.get((Object)"requestMappings").add(builder);
            this.requestMappings.add(builder);
        } else {
            this._visitables.get((Object)"requestMappings").add(builder);
            this.requestMappings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ContainerExtendedResourceRequest buildFirstRequestMapping() {
        return this.requestMappings.get(0).build();
    }

    public ContainerExtendedResourceRequest buildLastRequestMapping() {
        return this.requestMappings.get(this.requestMappings.size() - 1).build();
    }

    public ContainerExtendedResourceRequest buildMatchingRequestMapping(Predicate<ContainerExtendedResourceRequestBuilder> predicate) {
        for (ContainerExtendedResourceRequestBuilder item : this.requestMappings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ContainerExtendedResourceRequest buildRequestMapping(int index) {
        return this.requestMappings.get(index).build();
    }

    public List<ContainerExtendedResourceRequest> buildRequestMappings() {
        return this.requestMappings != null ? PodExtendedResourceClaimStatusFluent.build(this.requestMappings) : null;
    }

    protected void copyInstance(PodExtendedResourceClaimStatus instance) {
        PodExtendedResourceClaimStatus podExtendedResourceClaimStatus = instance = instance != null ? instance : new PodExtendedResourceClaimStatus();
        if (instance != null) {
            this.withRequestMappings(instance.getRequestMappings());
            this.withResourceClaimName(instance.getResourceClaimName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RequestMappingsNested<A> editFirstRequestMapping() {
        if (this.requestMappings.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(0, this.buildRequestMapping(0));
    }

    public RequestMappingsNested<A> editLastRequestMapping() {
        int index = this.requestMappings.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(index, this.buildRequestMapping(index));
    }

    public RequestMappingsNested<A> editMatchingRequestMapping(Predicate<ContainerExtendedResourceRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requestMappings.size(); ++i) {
            if (!predicate.test(this.requestMappings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(index, this.buildRequestMapping(index));
    }

    public RequestMappingsNested<A> editRequestMapping(int index) {
        if (this.requestMappings.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(index, this.buildRequestMapping(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodExtendedResourceClaimStatusFluent that = (PodExtendedResourceClaimStatusFluent)((Object)o);
        if (!Objects.equals(this.requestMappings, that.requestMappings)) {
            return false;
        }
        if (!Objects.equals(this.resourceClaimName, that.resourceClaimName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingRequestMapping(Predicate<ContainerExtendedResourceRequestBuilder> predicate) {
        for (ContainerExtendedResourceRequestBuilder item : this.requestMappings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRequestMappings() {
        return this.requestMappings != null && !this.requestMappings.isEmpty();
    }

    public boolean hasResourceClaimName() {
        return this.resourceClaimName != null;
    }

    public int hashCode() {
        return Objects.hash(this.requestMappings, this.resourceClaimName, this.additionalProperties);
    }

    public A removeAllFromRequestMappings(Collection<ContainerExtendedResourceRequest> items) {
        if (this.requestMappings == null) {
            return (A)((Object)this);
        }
        for (ContainerExtendedResourceRequest item : items) {
            ContainerExtendedResourceRequestBuilder builder = new ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get((Object)"requestMappings").remove((Object)builder);
            this.requestMappings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRequestMappings(ContainerExtendedResourceRequest ... items) {
        if (this.requestMappings == null) {
            return (A)((Object)this);
        }
        for (ContainerExtendedResourceRequest item : items) {
            ContainerExtendedResourceRequestBuilder builder = new ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get((Object)"requestMappings").remove((Object)builder);
            this.requestMappings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRequestMappings(Predicate<ContainerExtendedResourceRequestBuilder> predicate) {
        if (this.requestMappings == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerExtendedResourceRequestBuilder> each = this.requestMappings.iterator();
        List visitables = this._visitables.get((Object)"requestMappings");
        while (each.hasNext()) {
            ContainerExtendedResourceRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public RequestMappingsNested<A> setNewRequestMappingLike(int index, ContainerExtendedResourceRequest item) {
        return new RequestMappingsNested(index, item);
    }

    public A setToRequestMappings(int index, ContainerExtendedResourceRequest item) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        ContainerExtendedResourceRequestBuilder builder = new ContainerExtendedResourceRequestBuilder(item);
        if (index < 0 || index >= this.requestMappings.size()) {
            this._visitables.get((Object)"requestMappings").add(builder);
            this.requestMappings.add(builder);
        } else {
            this._visitables.get((Object)"requestMappings").add(builder);
            this.requestMappings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.requestMappings != null && !this.requestMappings.isEmpty()) {
            sb.append("requestMappings:");
            sb.append(this.requestMappings);
            sb.append(",");
        }
        if (this.resourceClaimName != null) {
            sb.append("resourceClaimName:");
            sb.append(this.resourceClaimName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withRequestMappings(List<ContainerExtendedResourceRequest> requestMappings) {
        if (this.requestMappings != null) {
            this._visitables.get((Object)"requestMappings").clear();
        }
        if (requestMappings != null) {
            this.requestMappings = new ArrayList();
            for (ContainerExtendedResourceRequest item : requestMappings) {
                this.addToRequestMappings(item);
            }
        } else {
            this.requestMappings = null;
        }
        return (A)((Object)this);
    }

    public A withRequestMappings(ContainerExtendedResourceRequest ... requestMappings) {
        if (this.requestMappings != null) {
            this.requestMappings.clear();
            this._visitables.remove((Object)"requestMappings");
        }
        if (requestMappings != null) {
            for (ContainerExtendedResourceRequest item : requestMappings) {
                this.addToRequestMappings(item);
            }
        }
        return (A)((Object)this);
    }

    public A withResourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return (A)((Object)this);
    }

    public class RequestMappingsNested<N>
    extends ContainerExtendedResourceRequestFluent<RequestMappingsNested<N>>
    implements Nested<N> {
        ContainerExtendedResourceRequestBuilder builder;
        int index;

        RequestMappingsNested(int index, ContainerExtendedResourceRequest item) {
            this.index = index;
            this.builder = new ContainerExtendedResourceRequestBuilder(this, item);
        }

        public N and() {
            return (N)PodExtendedResourceClaimStatusFluent.this.setToRequestMappings(this.index, this.builder.build());
        }

        public N endRequestMapping() {
            return this.and();
        }
    }
}

