/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllSketchAggBase;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllSketchAggBigint$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr[, k]) - Returns the KllLongsSketch compact binary representation.\n      The optional k parameter controls the size and accuracy of the sketch (default 200, range 8-65535).\n      Larger k values provide more accurate quantile estimates but result in larger, slower sketches.\n  ", examples="\n    Examples:\n      > SELECT LENGTH(kll_sketch_to_string_bigint(_FUNC_(col))) > 0 FROM VALUES (1), (2), (3), (4), (5) tab(col);\n       true\n      > SELECT LENGTH(kll_sketch_to_string_bigint(_FUNC_(col, 400))) > 0 FROM VALUES (1), (2), (3), (4), (5) tab(col);\n       true\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tMf\u0001\u0002\u001b6\u0001\u0012C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005Y\"A\u0001\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005v\u0001\tE\t\u0015!\u0003s\u0011!1\bA!f\u0001\n\u0003:\b\u0002C>\u0001\u0005#\u0005\u000b\u0011\u0002=\t\u0011q\u0004!Q3A\u0005B]D\u0001\" \u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\u0006}\u0002!\ta \u0005\u0007}\u0002!\t!a\u0003\t\ry\u0004A\u0011AA\b\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005=\u0002\u0001\"\u0015\u00022!9\u0011Q\b\u0001\u0005B\u0005}\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u00033\u0002A\u0011IA.\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!a\u001e\u0001\t\u0003\nI\bC\u0004\u0002\b\u0002!\t%!#\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\t9\r\u0001C!\u0003\u0013D\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005m\u0007!%A\u0005\u0002\u0005u\u0007\"CAz\u0001E\u0005I\u0011AA{\u0011%\tI\u0010AI\u0001\n\u0003\tY\u0010C\u0005\u0002\u0000\u0002\t\n\u0011\"\u0001\u0002|\"I!\u0011\u0001\u0001\u0002\u0002\u0013\u0005#1\u0001\u0005\t\u0005'\u0001\u0011\u0011!C\u0001o\"I!Q\u0003\u0001\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005;\u0001\u0011\u0011!C!\u0005?A\u0011B!\f\u0001\u0003\u0003%\tAa\f\t\u0013\tM\u0002!!A\u0005B\tU\u0002\"\u0003B\u001d\u0001\u0005\u0005I\u0011\tB\u001e\u000f%\u0011y&NA\u0001\u0012\u0003\u0011\tG\u0002\u00055k\u0005\u0005\t\u0012\u0001B2\u0011\u0019q\b\u0006\"\u0001\u0003|!I!Q\u0010\u0015\u0002\u0002\u0013\u0015#q\u0010\u0005\n\u0005\u0003C\u0013\u0011!CA\u0005\u0007C\u0011B!$)#\u0003%\t!!>\t\u0013\t=\u0005&%A\u0005\u0002\u0005m\b\"\u0003BIQE\u0005I\u0011AA~\u0011%\u0011\u0019\nKA\u0001\n\u0003\u0013)\nC\u0005\u0003$\"\n\n\u0011\"\u0001\u0002v\"I!Q\u0015\u0015\u0012\u0002\u0013\u0005\u00111 \u0005\n\u0005OC\u0013\u0013!C\u0001\u0003wD\u0011B!+)\u0003\u0003%IAa+\u0003%-cGnU6fi\u000eD\u0017iZ4CS\u001eLg\u000e\u001e\u0006\u0003m]\n\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005aJ\u0014aC3yaJ,7o]5p]NT!AO\u001e\u0002\u0011\r\fG/\u00197zgRT!\u0001P\u001f\u0002\u0007M\fHN\u0003\u0002?\u007f\u0005)1\u000f]1sW*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0007\u0001\u0019b\u0001A#R)bs\u0006c\u0001$H\u00136\tQ'\u0003\u0002Ik\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005){U\"A&\u000b\u00051k\u0015aA6mY*\u0011ajP\u0001\rI\u0006$\u0018m]6fi\u000eDWm]\u0005\u0003!.\u0013ab\u00137m\u0019>twm]*lKR\u001c\u0007\u000e\u0005\u0002G%&\u00111+\u000e\u0002\u0011\u00172d7k[3uG\"\fum\u001a\"bg\u0016\u0004\"!\u0016,\u000e\u0003]J!aV\u001c\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002Z96\t!LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&LA\u0004Qe>$Wo\u0019;\u0011\u0005};gB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u00197)\u0001\u0004=e>|GOP\u0005\u00027&\u0011aMW\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017N\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002g5\u0006)1\r[5mIV\tA\u000e\u0005\u0002V[&\u0011an\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%A\u0003l\u000bb\u0004(/F\u0001s!\rI6\u000f\\\u0005\u0003ij\u0013aa\u00149uS>t\u0017AB6FqB\u0014\b%\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\u0005A\bCA-z\u0013\tQ(LA\u0002J]R\fq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002)%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003UIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\na\u0001P5oSRtDCCA\u0001\u0003\u0007\t)!a\u0002\u0002\nA\u0011a\t\u0001\u0005\u0006U&\u0001\r\u0001\u001c\u0005\ba&\u0001\n\u00111\u0001s\u0011\u001d1\u0018\u0002%AA\u0002aDq\u0001`\u0005\u0011\u0002\u0003\u0007\u0001\u0010\u0006\u0003\u0002\u0002\u00055\u0001\"\u00026\u000b\u0001\u0004aGCBA\u0001\u0003#\t\u0019\u0002C\u0003k\u0017\u0001\u0007A\u000eC\u0003q\u0017\u0001\u0007A.\u0001\u0005dQ&dGM]3o+\t\tI\u0002\u0005\u0003`\u00037a\u0017bAA\u000fS\n\u00191+Z9\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!!\u0001\u0002$!1\u0011QE\u0007A\u0002a\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!!\u0001\u0002,!1\u0011Q\u0006\bA\u0002a\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG\u0003BA\u0001\u0003gAq!!\u000e\u0010\u0001\u0004\t9$A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007\u0003B0\u0002:1L1!a\u000fj\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011qI\u001e\u0002\u000bQL\b/Z:\n\t\u0005-\u0013Q\t\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005E\u0003#B0\u0002\u001c\u0005M\u0003\u0003BA\"\u0003+JA!a\u0016\u0002F\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\t]VdG.\u00192mKV\u0011\u0011Q\f\t\u00043\u0006}\u0013bAA15\n9!i\\8mK\u0006t\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011q\r\t\u0005\u0003S\n\tH\u0004\u0003\u0002l\u00055\u0004CA1[\u0013\r\tyGW\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0014Q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=$,A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002|A!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002f\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u000b\u000byHA\bUsB,7\t[3dWJ+7/\u001e7u\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001J\u0003\u0019)\b\u000fZ1uKR)\u0011*a$\u0002\u0014\"1\u0011\u0011\u0013\fA\u0002%\u000baa]6fi\u000eD\u0007bBAK-\u0001\u0007\u0011qS\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u00033\u000bY*D\u0001:\u0013\r\ti*\u000f\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003nKJ<W\rF\u0003J\u0003G\u000b9\u000b\u0003\u0004\u0002&^\u0001\r!S\u0001\rkB$\u0017\r^3Ck\u001a4WM\u001d\u0005\u0007\u0003+;\u0002\u0019A%\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003[\u000b\u0019\fE\u0002Z\u0003_K1!!-[\u0005\r\te.\u001f\u0005\u0007\u0003#C\u0002\u0019A%\u0002\u0013M,'/[1mSj,G\u0003BA]\u0003\u000b\u0004R!WA^\u0003\u007fK1!!0[\u0005\u0015\t%O]1z!\rI\u0016\u0011Y\u0005\u0004\u0003\u0007T&\u0001\u0002\"zi\u0016Da!!%\u001a\u0001\u0004I\u0015a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2!SAf\u0011\u001d\tiM\u0007a\u0001\u0003s\u000baAY;gM\u0016\u0014\u0018\u0001B2paf$\"\"!\u0001\u0002T\u0006U\u0017q[Am\u0011\u001dQ7\u0004%AA\u00021Dq\u0001]\u000e\u0011\u0002\u0003\u0007!\u000fC\u0004w7A\u0005\t\u0019\u0001=\t\u000fq\\\u0002\u0013!a\u0001q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAApU\ra\u0017\u0011]\u0016\u0003\u0003G\u0004B!!:\u0002p6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001e.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0006\u001d(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA|U\r\u0011\u0018\u0011]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiPK\u0002y\u0003C\fabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u000b\u0001BAa\u0002\u0003\u00125\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\u0011i!\u0001\u0003mC:<'B\u0001B\b\u0003\u0011Q\u0017M^1\n\t\u0005M$\u0011B\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tiK!\u0007\t\u0011\tm!%!AA\u0002a\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0011!\u0019\u0011\u0019C!\u000b\u0002.6\u0011!Q\u0005\u0006\u0004\u0005OQ\u0016AC2pY2,7\r^5p]&!!1\u0006B\u0013\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u#\u0011\u0007\u0005\n\u00057!\u0013\u0011!a\u0001\u0003[\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!Q\u0001B\u001c\u0011!\u0011Y\"JA\u0001\u0002\u0004A\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002^\tu\u0002\"\u0003B\u000eM\u0005\u0005\t\u0019AAWQM\u0001!\u0011\tB$\u0005\u0013\u0012iEa\u0014\u0003T\tU#\u0011\fB.!\r)&1I\u0005\u0004\u0005\u000b:$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005\u0017\n!1\n\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9s72\u00023.X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!\u00172dGj\u001c8hgN[W\r^2iA\r|W\u000e]1di\u0002\u0012\u0017N\\1ss\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:t#\u0002\t\u0011!A\u0001\u0002C\u000b[3!_B$\u0018n\u001c8bY\u0002Z\u0007\u0005]1sC6,G/\u001a:!G>tGO]8mg\u0002\"\b.\u001a\u0011tSj,\u0007%\u00198eA\u0005\u001c7-\u001e:bGf\u0004sN\u001a\u0011uQ\u0016\u00043o[3uG\"\u0004\u0003\u0006Z3gCVdG\u000f\t\u001a1a1\u0002#/\u00198hK\u0002BTFN\u001b6gUJcF\u0003\u0011!A\u0001\u0002\u0003\u0005T1sO\u0016\u0014\be\u001b\u0011wC2,Xm\u001d\u0011qe>4\u0018\u000eZ3![>\u0014X\rI1dGV\u0014\u0018\r^3!cV\fg\u000e^5mK\u0002*7\u000f^5nCR,7\u000f\t2vi\u0002\u0012Xm];mi\u0002Jg\u000e\t7be\u001e,'\u000f\f\u0011tY><XM\u001d\u0011tW\u0016$8\r[3t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t&\u0001B\u0013\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002bUIT$U\u0011\"ZG\u000e\\0tW\u0016$8\r[0u_~\u001bHO]5oO~\u0013\u0017nZ5oi\"zf)\u0016(D?\"\u001aw\u000e\\\u0015*S\u0001r\u0004\u0005\r\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B#'\u000b\u0017!QMJC\u0006\t\u00155S1\u0002\u0003&N\u0015!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002bUIT$U\u0011\"ZG\u000e\\0tW\u0016$8\r[0u_~\u001bHO]5oO~\u0013\u0017nZ5oi\"zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!iA\u0002\u0014&K\u0015!}\u0001\u0002\u0004E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QIJC\u0006\t\u00154S1\u0002\u0003\u0006N\u0015-A!*\u0014\u0006\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0005)qM]8va\u0006\u0012!qK\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#A!\u0018\u0002\u000bQr\u0013G\f\u0019\u0002%-cGnU6fi\u000eD\u0017iZ4CS\u001eLg\u000e\u001e\t\u0003\r\"\u001aR\u0001\u000bB3\u0005c\u0002\"Ba\u001a\u0003n1\u0014\b\u0010_A\u0001\u001b\t\u0011IGC\u0002\u0003li\u000bqA];oi&lW-\u0003\u0003\u0003p\t%$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!1\u000fB=\u001b\t\u0011)H\u0003\u0003\u0003x\t5\u0011AA5p\u0013\rA'Q\u000f\u000b\u0003\u0005C\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u000b\tQ!\u00199qYf$\"\"!\u0001\u0003\u0006\n\u001d%\u0011\u0012BF\u0011\u0015Q7\u00061\u0001m\u0011\u001d\u00018\u0006%AA\u0002IDqA^\u0016\u0011\u0002\u0003\u0007\u0001\u0010C\u0004}WA\u0005\t\u0019\u0001=\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002BL\u0005?\u0003B!W:\u0003\u001aB9\u0011La'mebD\u0018b\u0001BO5\n1A+\u001e9mKRB\u0011B!)0\u0003\u0003\u0005\r!!\u0001\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011i\u000b\u0005\u0003\u0003\b\t=\u0016\u0002\u0002BY\u0005\u0013\u0011aa\u00142kK\u000e$\b")
public class KllSketchAggBigint
extends TypedImperativeAggregate<KllLongsSketch>
implements KllSketchAggBase,
ExpectsInputTypes,
Serializable {
    private final Expression child;
    private final Option<Expression> kExpr;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K;
    private int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K;
    private int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K;
    private int kValue;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$4() {
        return KllSketchAggBigint$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return KllSketchAggBigint$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return KllSketchAggBigint$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<Expression, Option<Expression>, Object, Object>> unapply(KllSketchAggBigint x$0) {
        return KllSketchAggBigint$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return KllSketchAggBigint$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return KllSketchAggBigint$.MODULE$.apply$default$3();
    }

    public static Option<Expression> apply$default$2() {
        return KllSketchAggBigint$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, Object, Object>, KllSketchAggBigint> tupled() {
        return KllSketchAggBigint$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, Function1<Object, KllSketchAggBigint>>>> curried() {
        return KllSketchAggBigint$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkKInputDataTypes() {
        return KllSketchAggBase.checkKInputDataTypes$(this);
    }

    @Override
    public SparkUnsupportedOperationException unexpectedInputDataTypeError(Expression child) {
        return KllSketchAggBase.unexpectedInputDataTypeError$(this, child);
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K;
    }

    private int kValue$lzycompute() {
        KllSketchAggBigint kllSketchAggBigint = this;
        synchronized (kllSketchAggBigint) {
            if (!this.bitmap$0) {
                this.kValue = KllSketchAggBase.kValue$(this);
                this.bitmap$0 = true;
            }
        }
        return this.kValue;
    }

    @Override
    public int kValue() {
        if (!this.bitmap$0) {
            return this.kValue$lzycompute();
        }
        return this.kValue;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$_setter_$org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K_$eq(int x$1) {
        this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MIN_K = x$1;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$_setter_$org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K_$eq(int x$1) {
        this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$MAX_K = x$1;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$_setter_$org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K_$eq(int x$1) {
        this.org$apache$spark$sql$catalyst$expressions$aggregate$KllSketchAggBase$$DEFAULT_K = x$1;
    }

    public Expression child() {
        return this.child;
    }

    @Override
    public Option<Expression> kExpr() {
        return this.kExpr;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        return (Seq)Option$.MODULE$.option2Iterable(this.kExpr()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public KllSketchAggBigint withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public KllSketchAggBigint withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public KllSketchAggBigint withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (newChildren.length() == 1) {
            return this.copy((Expression)newChildren.apply(0), (Option<Expression>)None$.MODULE$, this.copy$default$3(), this.copy$default$4());
        }
        return this.copy((Expression)newChildren.apply(0), (Option<Expression>)new Some(newChildren.apply(1)), this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        .colon.colon baseTypes = new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ByteType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, ShortType$.MODULE$})), (List)Nil$.MODULE$);
        if (this.kExpr().isDefined()) {
            return (Seq)baseTypes.$colon$plus((Object)IntegerType$.MODULE$);
        }
        return baseTypes;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return "kll_sketch_agg_bigint";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        return this.checkKInputDataTypes();
    }

    @Override
    public KllLongsSketch createAggregationBuffer() {
        return KllLongsSketch.newHeapInstance((int)this.kValue());
    }

    @Override
    public KllLongsSketch update(KllLongsSketch sketch, InternalRow input) {
        Object v = this.child().eval(input);
        if (v == null) {
            return sketch;
        }
        DataType dataType = this.child().dataType();
        if (ByteType$.MODULE$.equals(dataType)) {
            sketch.update((long)BoxesRunTime.unboxToByte((Object)v));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            sketch.update((long)BoxesRunTime.unboxToInt((Object)v));
        } else if (LongType$.MODULE$.equals(dataType)) {
            sketch.update(BoxesRunTime.unboxToLong((Object)v));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            sketch.update((long)BoxesRunTime.unboxToShort((Object)v));
        } else {
            throw this.unexpectedInputDataTypeError(this.child());
        }
        return sketch;
    }

    @Override
    public KllLongsSketch merge(KllLongsSketch updateBuffer, KllLongsSketch input) {
        KllLongsSketch kllLongsSketch;
        try {
            updateBuffer.merge((KllSketch)input);
            kllLongsSketch = updateBuffer;
        }
        catch (Exception exception) {
            throw QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer(this.prettyName(), QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer$default$2());
        }
        return kllLongsSketch;
    }

    @Override
    public Object eval(KllLongsSketch sketch) {
        return sketch.toByteArray();
    }

    @Override
    public byte[] serialize(KllLongsSketch sketch) {
        return sketch.toByteArray();
    }

    @Override
    public KllLongsSketch deserialize(byte[] buffer) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(buffer))) {
            KllLongsSketch kllLongsSketch;
            try {
                kllLongsSketch = KllLongsSketch.heapify((Memory)Memory.wrap((byte[])buffer));
            }
            catch (Exception exception) {
                throw QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer(this.prettyName(), QueryExecutionErrors$.MODULE$.kllInvalidInputSketchBuffer$default$2());
            }
            return kllLongsSketch;
        }
        return this.createAggregationBuffer();
    }

    public KllSketchAggBigint copy(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new KllSketchAggBigint(child, kExpr, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Expression> copy$default$2() {
        return this.kExpr();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "KllSketchAggBigint";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.kExpr();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchAggBigint;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "kExpr";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchAggBigint)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchAggBigint kllSketchAggBigint = (KllSketchAggBigint)x$1;
        if (this.mutableAggBufferOffset() != kllSketchAggBigint.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != kllSketchAggBigint.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = kllSketchAggBigint.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.kExpr();
        Option<Expression> option2 = kllSketchAggBigint.kExpr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!kllSketchAggBigint.canEqual(this)) return false;
        return true;
    }

    public KllSketchAggBigint(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.kExpr = kExpr;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        KllSketchAggBase.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public KllSketchAggBigint(Expression child) {
        this(child, (Option<Expression>)None$.MODULE$, 0, 0);
    }

    public KllSketchAggBigint(Expression child, Expression kExpr) {
        this(child, (Option<Expression>)new Some((Object)kExpr), 0, 0);
    }
}

