/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllMergeAggBase;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllMergeAggDouble$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr[, k]) - Merges binary KllDoublesSketch representations and returns the merged sketch.\n      The input expression should contain binary sketch representations (e.g., from kll_sketch_agg_double).\n      The optional k parameter controls the size and accuracy of the merged sketch (range 8-65535).\n      If k is not specified, the merged sketch adopts the k value from the first input sketch.\n  ", examples="\n    Examples:\n      > SELECT kll_sketch_get_n_double(_FUNC_(sketch)) FROM (SELECT kll_sketch_agg_double(col) as sketch FROM VALUES (CAST(1.0 AS DOUBLE)), (CAST(2.0 AS DOUBLE)), (CAST(3.0 AS DOUBLE)) tab(col) UNION ALL SELECT kll_sketch_agg_double(col) as sketch FROM VALUES (CAST(4.0 AS DOUBLE)), (CAST(5.0 AS DOUBLE)), (CAST(6.0 AS DOUBLE)) tab(col)) t;\n       6\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001B\u0017/\u0001vB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tE\u0002\u0011\t\u0012)A\u0005=\"A1\r\u0001BK\u0002\u0013\u0005A\r\u0003\u0005i\u0001\tE\t\u0015!\u0003f\u0011!I\u0007A!f\u0001\n\u0003R\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B6\t\u0011=\u0004!Q3A\u0005B)D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t\u0001\u001f\u0005\u0006c\u0002!\tA\u001f\u0005\u0006{\u0002!\tE \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\tY\u0001\u0001C)\u0003\u001bAq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002.\u0001!\t\"a\f\t\u000f\u0005U\u0002\u0001\"\u0005\u00028!9\u0011\u0011\n\u0001\u0005\u0012\u0005-\u0003bBA(\u0001\u0011E\u0011\u0011\u000b\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"a\u0019\u0001#\u0003%\t!!\u001a\t\u0013\u0005m\u0004!%A\u0005\u0002\u0005u\u0004\"CAA\u0001E\u0005I\u0011AAB\u0011%\t9\tAI\u0001\n\u0003\t\u0019\tC\u0005\u0002\n\u0002\t\t\u0011\"\u0011\u0002\f\"A\u00111\u0014\u0001\u0002\u0002\u0013\u0005!\u000eC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0001\u0002 \"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003w\u0003\u0011\u0011!C\u0001\u0003{C\u0011\"a2\u0001\u0003\u0003%\t%!3\t\u0013\u00055\u0007!!A\u0005B\u0005=w!CAz]\u0005\u0005\t\u0012AA{\r!ic&!A\t\u0002\u0005]\bBB9\"\t\u0003\u0011y\u0001C\u0005\u0003\u0012\u0005\n\t\u0011\"\u0012\u0003\u0014!I!QC\u0011\u0002\u0002\u0013\u0005%q\u0003\u0005\n\u0005C\t\u0013\u0013!C\u0001\u0003{B\u0011Ba\t\"#\u0003%\t!a!\t\u0013\t\u0015\u0012%%A\u0005\u0002\u0005\r\u0005\"\u0003B\u0014C\u0005\u0005I\u0011\u0011B\u0015\u0011%\u00119$II\u0001\n\u0003\ti\bC\u0005\u0003:\u0005\n\n\u0011\"\u0001\u0002\u0004\"I!1H\u0011\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0005{\t\u0013\u0011!C\u0005\u0005\u007f\u0011\u0011c\u00137m\u001b\u0016\u0014x-Z!hO\u0012{WO\u00197f\u0015\ty\u0003'A\u0005bO\u001e\u0014XmZ1uK*\u0011\u0011GM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00024i\u0005A1-\u0019;bYf\u001cHO\u0003\u00026m\u0005\u00191/\u001d7\u000b\u0005]B\u0014!B:qCJ\\'BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001})\u0003\u0006cA A\u00056\ta&\u0003\u0002B]\ty1\n\u001c7NKJ<W-Q4h\u0005\u0006\u001cX\r\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006\u00191\u000e\u001c7\u000b\u0005\u001dC\u0014\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018BA%E\u0005AYE\u000e\u001c#pk\ndWm]*lKR\u001c\u0007\u000e\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJA\u0004Qe>$Wo\u0019;\u0011\u0005EKfB\u0001*X\u001d\t\u0019f+D\u0001U\u0015\t)F(\u0001\u0004=e>|GOP\u0005\u0002\u001b&\u0011\u0001\fT\u0001\ba\u0006\u001c7.Y4f\u0013\tQ6L\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Y\u0019\u0006)1\r[5mIV\ta\f\u0005\u0002`A6\t\u0001'\u0003\u0002ba\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0015YW\t\u001f9s+\u0005)\u0007cA&g=&\u0011q\r\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002\r-,\u0005\u0010\u001d:!\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A6\u0011\u0005-c\u0017BA7M\u0005\rIe\u000e^\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018!F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bM$XO^<\u0011\u0005}\u0002\u0001\"\u0002/\n\u0001\u0004q\u0006bB2\n!\u0003\u0005\r!\u001a\u0005\bS&\u0001\n\u00111\u0001l\u0011\u001dy\u0017\u0002%AA\u0002-$\"a]=\t\u000bqS\u0001\u0019\u00010\u0015\u0007M\\H\u0010C\u0003]\u0017\u0001\u0007a\fC\u0003d\u0017\u0001\u0007a,A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\t\u0019x\u0010\u0003\u0004\u0002\u00021\u0001\ra[\u0001\u001a]\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0004g\u0006\u001d\u0001BBA\u0005\u001b\u0001\u00071.A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004g\u0006=\u0001bBA\t\u001d\u0001\u0007\u00111C\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003R\u0003+q\u0016bAA\f7\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u001eA!\u0011qDA\u0014\u001d\u0011\t\t#a\t\u0011\u0005Mc\u0015bAA\u0013\u0019\u00061\u0001K]3eK\u001aLA!!\u000b\u0002,\t11\u000b\u001e:j]\u001eT1!!\nM\u0003=qWm\u001e%fCBLen\u001d;b]\u000e,Gc\u0001\"\u00022!1\u00111\u0007\tA\u0002-\f\u0011a[\u0001\u000boJ\f\u0007oU6fi\u000eDGc\u0001\"\u0002:!9\u00111H\tA\u0002\u0005u\u0012!\u00022zi\u0016\u001c\b#B&\u0002@\u0005\r\u0013bAA!\u0019\n)\u0011I\u001d:bsB\u00191*!\u0012\n\u0007\u0005\u001dCJ\u0001\u0003CsR,\u0017!\u00045fCBLg-_*lKR\u001c\u0007\u000eF\u0002C\u0003\u001bBq!a\u000f\u0013\u0001\u0004\ti$A\u0006u_\nKH/Z!se\u0006LH\u0003BA\u001f\u0003'Ba!!\u0016\u0014\u0001\u0004\u0011\u0015AB:lKR\u001c\u0007.\u0001\u0003d_BLH#C:\u0002\\\u0005u\u0013qLA1\u0011\u001daF\u0003%AA\u0002yCqa\u0019\u000b\u0011\u0002\u0003\u0007Q\rC\u0004j)A\u0005\t\u0019A6\t\u000f=$\u0002\u0013!a\u0001W\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA4U\rq\u0016\u0011N\u0016\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u000f'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0005=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA@U\r)\u0017\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)IK\u0002l\u0003S\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0003mC:<'BAAL\u0003\u0011Q\u0017M^1\n\t\u0005%\u0012\u0011S\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t+a*\u0011\u0007-\u000b\u0019+C\u0002\u0002&2\u00131!\u00118z\u0011!\tIkGA\u0001\u0002\u0004Y\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00020B1\u0011\u0011WA\\\u0003Ck!!a-\u000b\u0007\u0005UF*\u0001\u0006d_2dWm\u0019;j_:LA!!/\u00024\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty,!2\u0011\u0007-\u000b\t-C\u0002\u0002D2\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002*v\t\t\u00111\u0001\u0002\"\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ti)a3\t\u0011\u0005%f$!AA\u0002-\fa!Z9vC2\u001cH\u0003BA`\u0003#D\u0011\"!+ \u0003\u0003\u0005\r!!))'\u0001\t).a7\u0002^\u0006\u0005\u00181]At\u0003S\fi/a<\u0011\u0007}\u000b9.C\u0002\u0002ZB\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002`\u0006\u0019\tD\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:\\Y\u0001ZW,\u000b\u0011.A5+'oZ3tA\tLg.\u0019:zA-cG\u000eR8vE2,7oU6fi\u000eD\u0007E]3qe\u0016\u001cXM\u001c;bi&|gn\u001d\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b\u0005\u001e5fA5,'oZ3eAM\\W\r^2i])\u0001\u0003\u0005\t\u0011!AQCW\rI5oaV$\b%\u001a=qe\u0016\u001c8/[8oAMDw.\u001e7eA\r|g\u000e^1j]\u0002\u0012\u0017N\\1ss\u0002\u001a8.\u001a;dQ\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:\u001c\b\u0005K3/O:b\u0003E\u001a:p[\u0002ZG\u000e\\0tW\u0016$8\r[0bO\u001e|Fm\\;cY\u0016LcF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA=\u0004H/[8oC2\u00043\u000e\t9be\u0006lW\r^3sA\r|g\u000e\u001e:pYN\u0004C\u000f[3!g&TX\rI1oI\u0002\n7mY;sC\u000eL\be\u001c4!i\",\u0007%\\3sO\u0016$\u0007e]6fi\u000eD\u0007\u0005\u000b:b]\u001e,\u0007\u0005O\u00177kU\u001aT'\u000b\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011JM\u0002Z\u0007%[:!]>$\be\u001d9fG&4\u0017.\u001a3-AQDW\rI7fe\u001e,G\rI:lKR\u001c\u0007\u000eI1e_B$8\u000f\t;iK\u0002Z\u0007E^1mk\u0016\u0004cM]8nAQDW\r\t4jeN$\b%\u001b8qkR\u00043o[3uG\"t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!:\u0002\u0005?T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u001b7m?N\\W\r^2i?\u001e,Go\u00188`I>,(\r\\3)?\u001a+fjQ0)g.,Go\u00195*S\u00012%kT'!QM+E*R\"UA-dGnX:lKR\u001c\u0007nX1hO~#w.\u001e2mK\"\u001aw\u000e\\\u0015!CN\u00043o[3uG\"\u0004cIU(NAY\u000bE*V#TA!\u001a\u0015i\u0015+)c9\u0002\u0004%Q*!\t>+&\tT#*S1\u0002\u0003fQ!T)\"\u0012d\u0006\r\u0011B'\u0002\"u*\u0016\"M\u000b&JC\u0006\t\u0015D\u0003N#\u0006f\r\u00181A\u0005\u001b\u0006\u0005R(V\u00052+\u0015&\u000b\u0011uC\nD3m\u001c7*AUs\u0015j\u0014(!\u00032c\u0005eU#M\u000b\u000e#\u0006e\u001b7m?N\\W\r^2i?\u0006<wm\u00183pk\ndW\rK2pY&\u0002\u0013m\u001d\u0011tW\u0016$8\r\u001b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\"B'RCCG\f\u0019!\u0003N\u0003CiT+C\u0019\u0016K\u0013\u0006\f\u0011)\u0007\u0006\u001bF\u000bK\u001b/a\u0001\n5\u000b\t#P+\ncU)K\u0015-A!\u001a\u0015i\u0015+)m9\u0002\u0004%Q*!\t>+&\tT#*S\u0001\"\u0018M\u0019\u0015d_2L\u0013\u0006\t;<\u0015\u0001\u0002\u0003\u0005\t\u0011!AYR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003W\f\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005E\u0018!\u0002\u001b/c9\u0002\u0014!E&mY6+'oZ3BO\u001e$u.\u001e2mKB\u0011q(I\n\u0006C\u0005e(Q\u0001\t\n\u0003w\u0014\tAX3lWNl!!!@\u000b\u0007\u0005}H*A\u0004sk:$\u0018.\\3\n\t\t\r\u0011Q \u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\t\t-\u0011QS\u0001\u0003S>L1A\u0017B\u0005)\t\t)0\u0001\u0005u_N#(/\u001b8h)\t\ti)A\u0003baBd\u0017\u0010F\u0005t\u00053\u0011YB!\b\u0003 !)A\f\na\u0001=\"91\r\nI\u0001\u0002\u0004)\u0007bB5%!\u0003\u0005\ra\u001b\u0005\b_\u0012\u0002\n\u00111\u0001l\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003,\tM\u0002\u0003B&g\u0005[\u0001ra\u0013B\u0018=\u0016\\7.C\u0002\u000321\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003B\u001bQ\u0005\u0005\t\u0019A:\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0005\u0005\u0003\u0002\u0010\n\r\u0013\u0002\u0002B#\u0003#\u0013aa\u00142kK\u000e$\b")
public class KllMergeAggDouble
extends KllMergeAggBase<KllDoublesSketch>
implements Serializable {
    private final Expression child;
    private final Option<Expression> kExpr;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;

    public static int $lessinit$greater$default$4() {
        return KllMergeAggDouble$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return KllMergeAggDouble$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return KllMergeAggDouble$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<Expression, Option<Expression>, Object, Object>> unapply(KllMergeAggDouble x$0) {
        return KllMergeAggDouble$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return KllMergeAggDouble$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return KllMergeAggDouble$.MODULE$.apply$default$3();
    }

    public static Option<Expression> apply$default$2() {
        return KllMergeAggDouble$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, Object, Object>, KllMergeAggDouble> tupled() {
        return KllMergeAggDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, Function1<Object, KllMergeAggDouble>>>> curried() {
        return KllMergeAggDouble$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<Expression> kExpr() {
        return this.kExpr;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public KllMergeAggDouble withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public KllMergeAggDouble withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public KllMergeAggDouble withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (newChildren.length() == 1) {
            return this.copy((Expression)newChildren.apply(0), (Option<Expression>)None$.MODULE$, this.copy$default$3(), this.copy$default$4());
        }
        return this.copy((Expression)newChildren.apply(0), (Option<Expression>)new Some(newChildren.apply(1)), this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "kll_merge_agg_double";
    }

    @Override
    public KllDoublesSketch newHeapInstance(int k) {
        return KllDoublesSketch.newHeapInstance((int)k);
    }

    @Override
    public KllDoublesSketch wrapSketch(byte[] bytes) {
        return KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])bytes));
    }

    @Override
    public KllDoublesSketch heapifySketch(byte[] bytes) {
        return KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
    }

    @Override
    public byte[] toByteArray(KllDoublesSketch sketch) {
        return sketch.toByteArray();
    }

    public KllMergeAggDouble copy(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new KllMergeAggDouble(child, kExpr, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Expression> copy$default$2() {
        return this.kExpr();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "KllMergeAggDouble";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.kExpr();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllMergeAggDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "kExpr";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllMergeAggDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllMergeAggDouble kllMergeAggDouble = (KllMergeAggDouble)x$1;
        if (this.mutableAggBufferOffset() != kllMergeAggDouble.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != kllMergeAggDouble.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = kllMergeAggDouble.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.kExpr();
        Option<Expression> option2 = kllMergeAggDouble.kExpr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!kllMergeAggDouble.canEqual(this)) return false;
        return true;
    }

    public KllMergeAggDouble(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.kExpr = kExpr;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public KllMergeAggDouble(Expression child) {
        this(child, (Option<Expression>)None$.MODULE$, 0, 0);
    }

    public KllMergeAggDouble(Expression child, Expression kExpr) {
        this(child, (Option<Expression>)new Some((Object)kExpr), 0, 0);
    }
}

