/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.VectorAvg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array) - Returns the element-wise mean of float vectors in a group.\n    All vectors must have the same dimension.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (array(1.0F, 2.0F)), (array(3.0F, 4.0F)) AS tab(col);\n       [2.0,3.0]\n  ", since="4.2.0", group="vector_funcs")
@ScalaSignature(bytes="\u0006\u0005\tme\u0001B\u001c9\u0001\u0016C\u0001B\u001c\u0001\u0003\u0016\u0004%\ta\u001c\u0005\ta\u0002\u0011\t\u0012)A\u0005%\"A\u0011\u000f\u0001BK\u0002\u0013\u0005!\u000f\u0003\u0005w\u0001\tE\t\u0015!\u0003t\u0011!9\bA!f\u0001\n\u0003\u0011\b\u0002\u0003=\u0001\u0005#\u0005\u000b\u0011B:\t\u000be\u0004A\u0011\u0001>\t\u000be\u0004A\u0011A@\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011)\t\t\u0005\u0001EC\u0002\u0013%\u00111\t\u0005\u000b\u0003\u0017\u0002\u0001R1A\u0005\n\u0005\r\u0003BCA'\u0001!\u0015\r\u0011\"\u0003\u0002D!9\u0011q\n\u0001\u0005B\u0005E\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\u000b\u0003G\u0002\u0001R1A\u0005B\u0005E\u0003\u0002CA3\u0001\t\u0007I\u0011\u0002:\t\u000f\u0005\u001d\u0004\u0001)A\u0005g\"A\u0011\u0011\u000e\u0001C\u0002\u0013%!\u000fC\u0004\u0002l\u0001\u0001\u000b\u0011B:\t\u0011\u00055\u0004A1A\u0005\nIDq!a\u001c\u0001A\u0003%1\u000fC\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0005BCAL\u0001!\u0015\r\u0011\"\u0003\u0002\u001a!9\u0011\u0011\u0014\u0001\u0005B\u0005m\u0005bBAR\u0001\u0011\u0005\u0013Q\u0015\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\tI\f\u0001C)\u0003wC\u0011\"!1\u0001\u0003\u0003%\t!a1\t\u0013\u0005-\u0007!%A\u0005\u0002\u00055\u0007\"CAr\u0001E\u0005I\u0011AAs\u0011%\tI\u000fAI\u0001\n\u0003\t)\u000fC\u0005\u0002l\u0002\t\t\u0011\"\u0011\u0002n\"A\u0011Q \u0001\u0002\u0002\u0013\u0005!\u000fC\u0005\u0002\u0000\u0002\t\t\u0011\"\u0001\u0003\u0002!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005/\u0001\u0011\u0011!C\u0001\u00053A\u0011B!\b\u0001\u0003\u0003%\tEa\b\t\u0013\t\r\u0002!!A\u0005B\t\u0015r!\u0003B%q\u0005\u0005\t\u0012\u0001B&\r!9\u0004(!A\t\u0002\t5\u0003BB=.\t\u0003\u0011)\u0007C\u0005\u0003h5\n\t\u0011\"\u0012\u0003j!I!1N\u0017\u0002\u0002\u0013\u0005%Q\u000e\u0005\n\u0005kj\u0013\u0013!C\u0001\u0003KD\u0011Ba\u001e.#\u0003%\t!!:\t\u0013\teT&!A\u0005\u0002\nm\u0004\"\u0003BG[E\u0005I\u0011AAs\u0011%\u0011y)LI\u0001\n\u0003\t)\u000fC\u0005\u0003\u00126\n\t\u0011\"\u0003\u0003\u0014\nIa+Z2u_J\feo\u001a\u0006\u0003si\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\bP\u0001\tG\u0006$\u0018\r\\=ti*\u0011QHP\u0001\u0004gFd'BA A\u0003\u0015\u0019\b/\u0019:l\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\u0004\u0001M1\u0001A\u0012'W9\n\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u001d\u0002\u0013\u0005<wM]3hCR,\u0017BA&I\u0005MIU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\ri\u0005KU\u0007\u0002\u001d*\u0011qJO\u0001\u0006iJ,Wm]\u0005\u0003#:\u0013\u0011\"\u00168befd\u0015n[3\u0011\u0005M#V\"\u0001\u001d\n\u0005UC$AC#yaJ,7o]5p]B\u0011qKW\u0007\u00021*\u0011\u0011\fP\u0001\u0007KJ\u0014xN]:\n\u0005mC&aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005u\u0003W\"\u00010\u000b\u0003}\u000bQa]2bY\u0006L!!\u00190\u0003\u000fA\u0013x\u000eZ;diB\u00111m\u001b\b\u0003I&t!!\u001a5\u000e\u0003\u0019T!a\u001a#\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0016B\u00016_\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005)t\u0016!B2iS2$W#\u0001*\u0002\r\rD\u0017\u000e\u001c3!\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A:\u0011\u0005u#\u0018BA;_\u0005\rIe\u000e^\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018!F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmdXP \t\u0003'\u0002AQA\\\u0004A\u0002ICq!]\u0004\u0011\u0002\u0003\u00071\u000fC\u0004x\u000fA\u0005\t\u0019A:\u0015\u0007m\f\t\u0001C\u0003o\u0011\u0001\u0007!+\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0002\u0011\t\u0005%\u0011\u0011\u0003\b\u0005\u0003\u0017\ti\u0001\u0005\u0002f=&\u0019\u0011q\u00020\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019\"!\u0006\u0003\rM#(/\u001b8h\u0015\r\tyAX\u0001\t]VdG.\u00192mKV\u0011\u00111\u0004\t\u0004;\u0006u\u0011bAA\u0010=\n9!i\\8mK\u0006t\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-B(A\u0003usB,7/\u0003\u0003\u00020\u0005%\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\"(\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\ty$!\u000f\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fq!\u0019<h\u0003R$(/\u0006\u0002\u0002FA\u00191+a\u0012\n\u0007\u0005%\u0003H\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0017a\u00023j[\u0006#HO]\u0001\nG>,h\u000e^!uiJ\f1#Y4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN,\"!a\u0015\u0011\u000b\r\f)&!\u0012\n\u0007\u0005]SNA\u0002TKF\fq\"Y4h\u0005V4g-\u001a:TG\",W.Y\u000b\u0003\u0003;\u0002B!a\n\u0002`%!\u0011\u0011MA\u0015\u0005)\u0019FO];diRK\b/Z\u0001\u0019S:\u0004X\u000f^!hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\u0018\u0001C1wO&sG-\u001a=\u0002\u0013\u00054x-\u00138eKb\u0004\u0013\u0001\u00033j[&sG-\u001a=\u0002\u0013\u0011LW.\u00138eKb\u0004\u0013AC2pk:$\u0018J\u001c3fq\u0006Y1m\\;oi&sG-\u001a=!\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$Hc\u0001$\u0002v!1\u0011qO\rA\u0002M\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2ARA?\u0011\u0019\tyH\u0007a\u0001g\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u000bS:LG/[1mSj,G\u0003BAC\u0003\u0017\u00032!XAD\u0013\r\tII\u0018\u0002\u0005+:LG\u000fC\u0004\u0002\u000en\u0001\r!a$\u0002\r\t,hMZ3s!\u0011\t\t*a%\u000e\u0003iJ1!!&;\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002#%t\u0007/\u001e;D_:$\u0018-\u001b8t\u001dVdG.\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003\u000b\u000bi*a(\t\u000f\u00055U\u00041\u0001\u0002\u0010\"9\u0011\u0011U\u000fA\u0002\u0005=\u0015!B5oaV$\u0018!B7fe\u001e,GCBAC\u0003O\u000bI\u000bC\u0004\u0002\u000ez\u0001\r!a$\t\u000f\u0005-f\u00041\u0001\u0002\u0010\u0006Y\u0011N\u001c9vi\n+hMZ3s\u0003\u0011)g/\u00197\u0015\t\u0005E\u0016q\u0017\t\u0004;\u0006M\u0016bAA[=\n\u0019\u0011I\\=\t\u0013\u00055u\u0004%AA\u0002\u0005=\u0015\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002|\u0003{Ca!a0!\u0001\u0004\u0011\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\bw\u0006\u0015\u0017qYAe\u0011\u001dq\u0017\u0005%AA\u0002ICq!]\u0011\u0011\u0002\u0003\u00071\u000fC\u0004xCA\u0005\t\u0019A:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001a\u0016\u0004%\u0006E7FAAj!\u0011\t).a8\u000e\u0005\u0005]'\u0002BAm\u00037\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005ug,\u0001\u0006b]:|G/\u0019;j_:LA!!9\u0002X\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u001d\u0016\u0004g\u0006E\u0017AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\b\u0003BAy\u0003wl!!a=\u000b\t\u0005U\u0018q_\u0001\u0005Y\u0006twM\u0003\u0002\u0002z\u0006!!.\u0019<b\u0013\u0011\t\u0019\"a=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011\u0017B\u0002\u0011!\u0011)aJA\u0001\u0002\u0004\u0019\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\fA1!Q\u0002B\n\u0003ck!Aa\u0004\u000b\u0007\tEa,\u0001\u0006d_2dWm\u0019;j_:LAA!\u0006\u0003\u0010\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tYBa\u0007\t\u0013\t\u0015\u0011&!AA\u0002\u0005E\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a<\u0003\"!A!Q\u0001\u0016\u0002\u0002\u0003\u00071/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\u00119\u0003C\u0005\u0003\u0006-\n\t\u00111\u0001\u00022\"\u001a\u0002Aa\u000b\u00032\tM\"q\u0007B\u001d\u0005{\u0011yDa\u0011\u0003FA\u00191K!\f\n\u0007\t=\u0002HA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tU\u0012!!\u0001\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u0019:sCfL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u001a7f[\u0016tG/L<jg\u0016\u0004S.Z1oA=4\u0007E\u001a7pCR\u0004c/Z2u_J\u001c\b%\u001b8!C\u0002:'o\\;q])\u0001\u0003\u0005\t\u0011BY2\u0004c/Z2u_J\u001c\b%\\;ti\u0002B\u0017M^3!i\",\u0007e]1nK\u0002\"\u0017.\\3og&|gN\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003<\u0005y(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY&\u0002cIU(NAY\u000bE*V#TA!\n'O]1zQEr\u0003G\u0012\u0017!e9\u0002d)K\u0015-A!\n'O]1zQMr\u0003G\u0012\u0017!i9\u0002d)K\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\e9\u0002Df\r\u00181;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003B\u0005)AG\f\u001a/a\u0005)qM]8va\u0006\u0012!qI\u0001\rm\u0016\u001cGo\u001c:`MVt7m]\u0001\n-\u0016\u001cGo\u001c:Bm\u001e\u0004\"aU\u0017\u0014\u000b5\u0012yEa\u0017\u0011\u0011\tE#q\u000b*tgnl!Aa\u0015\u000b\u0007\tUc,A\u0004sk:$\u0018.\\3\n\t\te#1\u000b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\t\t\u0005\u0014q_\u0001\u0003S>L1\u0001\u001cB0)\t\u0011Y%\u0001\u0005u_N#(/\u001b8h)\t\ty/A\u0003baBd\u0017\u0010F\u0004|\u0005_\u0012\tHa\u001d\t\u000b9\u0004\u0004\u0019\u0001*\t\u000fE\u0004\u0004\u0013!a\u0001g\"9q\u000f\rI\u0001\u0002\u0004\u0019\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003~\t%\u0005#B/\u0003\u0000\t\r\u0015b\u0001BA=\n1q\n\u001d;j_:\u0004b!\u0018BC%N\u001c\u0018b\u0001BD=\n1A+\u001e9mKNB\u0001Ba#4\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005+\u0003B!!=\u0003\u0018&!!\u0011TAz\u0005\u0019y%M[3di\u0002")
public class VectorAvg
extends ImperativeAggregate
implements UnaryLike<Expression>,
QueryErrorsBase,
Serializable {
    private AttributeReference avgAttr;
    private AttributeReference dimAttr;
    private AttributeReference countAttr;
    private Seq<AttributeReference> inputAggBufferAttributes;
    private boolean inputContainsNull;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final int avgIndex;
    private final int dimIndex;
    private final int countIndex;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$3() {
        return VectorAvg$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return VectorAvg$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(VectorAvg x$0) {
        return VectorAvg$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return VectorAvg$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return VectorAvg$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, VectorAvg> tupled() {
        return VectorAvg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, VectorAvg>>> curried() {
        return VectorAvg$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        VectorAvg vectorAvg = this;
        synchronized (vectorAvg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "vector_avg";
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType((DataType)FloatType$.MODULE$, false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = this.child().dataType();
        if (dataType2 instanceof ArrayType && FloatType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.child())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.child().dataType()))}))));
    }

    private AttributeReference avgAttr$lzycompute() {
        VectorAvg vectorAvg = this;
        synchronized (vectorAvg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String x$1 = "avg";
                BinaryType$ x$2 = BinaryType$.MODULE$;
                boolean x$3 = true;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("avg", (DataType)x$2, true, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("avg", (DataType)x$2, true, x$4);
                this.avgAttr = new AttributeReference("avg", (DataType)x$2, true, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.avgAttr;
    }

    private AttributeReference avgAttr() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.avgAttr$lzycompute();
        }
        return this.avgAttr;
    }

    private AttributeReference dimAttr$lzycompute() {
        VectorAvg vectorAvg = this;
        synchronized (vectorAvg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$1 = "dim";
                IntegerType$ x$2 = IntegerType$.MODULE$;
                boolean x$3 = true;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("dim", (DataType)x$2, true, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("dim", (DataType)x$2, true, x$4);
                this.dimAttr = new AttributeReference("dim", (DataType)x$2, true, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dimAttr;
    }

    private AttributeReference dimAttr() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dimAttr$lzycompute();
        }
        return this.dimAttr;
    }

    private AttributeReference countAttr$lzycompute() {
        VectorAvg vectorAvg = this;
        synchronized (vectorAvg) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("count", (DataType)x$2, false, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("count", (DataType)x$2, false, x$4);
                this.countAttr = new AttributeReference("count", (DataType)x$2, false, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.countAttr;
    }

    private AttributeReference countAttr() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.countAttr$lzycompute();
        }
        return this.countAttr;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return new .colon.colon((Object)this.avgAttr(), (List)new .colon.colon((Object)this.dimAttr(), (List)new .colon.colon((Object)this.countAttr(), (List)Nil$.MODULE$)));
    }

    @Override
    public StructType aggBufferSchema() {
        return DataTypeUtils$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    private Seq<AttributeReference> inputAggBufferAttributes$lzycompute() {
        VectorAvg vectorAvg = this;
        synchronized (vectorAvg) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable)x$1 -> x$1.newInstance());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.inputAggBufferAttributes$lzycompute();
        }
        return this.inputAggBufferAttributes;
    }

    private int avgIndex() {
        return this.avgIndex;
    }

    private int dimIndex() {
        return this.dimIndex;
    }

    private int countIndex() {
        return this.countIndex;
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public void initialize(InternalRow buffer) {
        buffer.update(this.mutableAggBufferOffset() + this.avgIndex(), null);
        buffer.update(this.mutableAggBufferOffset() + this.dimIndex(), null);
        buffer.setLong(this.mutableAggBufferOffset() + this.countIndex(), 0L);
    }

    private boolean inputContainsNull$lzycompute() {
        VectorAvg vectorAvg = this;
        synchronized (vectorAvg) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.inputContainsNull = ((ArrayType)this.child().dataType()).containsNull();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.inputContainsNull;
    }

    private boolean inputContainsNull() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.inputContainsNull$lzycompute();
        }
        return this.inputContainsNull;
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object inputValue = this.child().eval(input);
        if (inputValue == null) {
            return;
        }
        ArrayData inputArray = (ArrayData)inputValue;
        int inputLen = inputArray.numElements();
        if (this.inputContainsNull()) {
            for (int i = 0; i < inputLen; ++i) {
                if (!inputArray.isNullAt(i)) continue;
                return;
            }
        }
        int avgOffset = this.mutableAggBufferOffset() + this.avgIndex();
        int dimOffset = this.mutableAggBufferOffset() + this.dimIndex();
        int countOffset = this.mutableAggBufferOffset() + this.countIndex();
        long currentCount = buffer.getLong(countOffset);
        if (currentCount == 0L) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(inputLen * 4).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < inputLen; ++i) {
                byteBuffer.putFloat(inputArray.getFloat(i));
            }
            buffer.update(avgOffset, byteBuffer.array());
            buffer.setInt(dimOffset, inputLen);
            buffer.setLong(countOffset, 1L);
            return;
        }
        int currentDim = buffer.getInt(dimOffset);
        if (currentDim == 0 && inputLen == 0) {
            buffer.setLong(countOffset, currentCount + 1L);
            return;
        }
        if (currentDim != inputLen) {
            throw QueryExecutionErrors$.MODULE$.vectorDimensionMismatchError(this.prettyName(), currentDim, inputLen);
        }
        long newCount = currentCount + 1L;
        float invCount = 1.0f / (float)newCount;
        byte[] currentAvgBytes = buffer.getBinary(avgOffset);
        ByteBuffer avgBuffer = ByteBuffer.wrap(currentAvgBytes).order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        int idx = 0;
        while (i < currentDim) {
            float oldAvg = avgBuffer.getFloat(idx);
            float newVal = inputArray.getFloat(i);
            avgBuffer.putFloat(idx, oldAvg + (newVal - oldAvg) * invCount);
            ++i;
            idx += 4;
        }
        buffer.setLong(countOffset, newCount);
    }

    @Override
    public void merge(InternalRow buffer, InternalRow inputBuffer) {
        int avgOffset = this.mutableAggBufferOffset() + this.avgIndex();
        int dimOffset = this.mutableAggBufferOffset() + this.dimIndex();
        int countOffset = this.mutableAggBufferOffset() + this.countIndex();
        int inputAvgOffset = this.inputAggBufferOffset() + this.avgIndex();
        int inputDimOffset = this.inputAggBufferOffset() + this.dimIndex();
        int inputCountOffset = this.inputAggBufferOffset() + this.countIndex();
        long inputCount = inputBuffer.getLong(inputCountOffset);
        if (inputCount == 0L) {
            return;
        }
        byte[] inputAvgBytes = inputBuffer.getBinary(inputAvgOffset);
        int inputDim = inputBuffer.getInt(inputDimOffset);
        long currentCount = buffer.getLong(countOffset);
        if (currentCount == 0L) {
            buffer.update(avgOffset, inputAvgBytes.clone());
            buffer.setInt(dimOffset, inputDim);
            buffer.setLong(countOffset, inputCount);
            return;
        }
        int currentDim = buffer.getInt(dimOffset);
        if (currentDim == 0 && inputDim == 0) {
            buffer.setLong(countOffset, currentCount + inputCount);
            return;
        }
        if (currentDim != inputDim) {
            throw QueryExecutionErrors$.MODULE$.vectorDimensionMismatchError(this.prettyName(), currentDim, inputDim);
        }
        long newCount = currentCount + inputCount;
        float leftWeight = (float)currentCount / (float)newCount;
        float rightWeight = (float)inputCount / (float)newCount;
        byte[] currentAvgBytes = buffer.getBinary(avgOffset);
        ByteBuffer avgBuffer = ByteBuffer.wrap(currentAvgBytes).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer inputAvgBuffer = ByteBuffer.wrap(inputAvgBytes).order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        int idx = 0;
        while (i < currentDim) {
            float leftAvg = avgBuffer.getFloat(idx);
            float rightAvg = inputAvgBuffer.getFloat(idx);
            avgBuffer.putFloat(idx, leftAvg * leftWeight + rightAvg * rightWeight);
            ++i;
            idx += 4;
        }
        buffer.setLong(countOffset, newCount);
    }

    @Override
    public Object eval(InternalRow buffer) {
        int countOffset = this.mutableAggBufferOffset() + this.countIndex();
        long count = buffer.getLong(countOffset);
        if (count == 0L) {
            return null;
        }
        int dim = buffer.getInt(this.mutableAggBufferOffset() + this.dimIndex());
        byte[] avgBytes = buffer.getBinary(this.mutableAggBufferOffset() + this.avgIndex());
        ByteBuffer avgBuffer = ByteBuffer.wrap(avgBytes).order(ByteOrder.LITTLE_ENDIAN);
        float[] result = new float[dim];
        for (int i = 0; i < dim; ++i) {
            result[i] = avgBuffer.getFloat();
        }
        return ArrayData$.MODULE$.toArrayData(result);
    }

    @Override
    public VectorAvg withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public VectorAvg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new VectorAvg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "VectorAvg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VectorAvg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof VectorAvg)) return false;
        boolean bl = true;
        if (!bl) return false;
        VectorAvg vectorAvg = (VectorAvg)x$1;
        if (this.mutableAggBufferOffset() != vectorAvg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != vectorAvg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = vectorAvg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!vectorAvg.canEqual(this)) return false;
        return true;
    }

    public VectorAvg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.avgIndex = 0;
        this.dimIndex = 1;
        this.countIndex = 2;
    }

    public VectorAvg(Expression child) {
        this(child, 0, 0);
    }
}

