/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TupleDifferenceBase;
import org.apache.spark.sql.catalyst.expressions.TupleDifferenceInteger$;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(tupleSketch1, tupleSketch2) - Subtracts two binary representations of Datasketches\n    TupleSketch objects with integer summary data type using a TupleSketch AnotB object.\n    Returns elements in the first sketch that are not in the second sketch. ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_integer(_FUNC_(tuple_sketch_agg_integer(col1, val1), tuple_sketch_agg_integer(col2, val2))) FROM VALUES (5, 5, 4, 4), (1, 1, 4, 4), (2, 2, 5, 5), (3, 3, 1, 1) tab(col1, val1, col2, val2);\n       2.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001dY\b!!A\u0005\u0002qD\u0001b \u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0001\u0005\n\u0003/\u0001\u0011\u0013!C\u0001\u0003\u0003A\u0011\"!\u0007\u0001\u0003\u0003%\t%a\u0007\t\u0013\u0005-\u0002!!A\u0005\u0002\u00055\u0002\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u0011%\t\u0019\u0005AA\u0001\n\u0003\n)\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0013\u0011\r\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003O:\u0011\"a#\u001c\u0003\u0003E\t!!$\u0007\u0011iY\u0012\u0011!E\u0001\u0003\u001fCa!\u0015\u000b\u0005\u0002\u0005\u001d\u0006\"CAU)\u0005\u0005IQIAV\u0011%\ti\u000bFA\u0001\n\u0003\u000by\u000bC\u0005\u00026R\t\t\u0011\"!\u00028\"I\u0011\u0011\u001a\u000b\u0002\u0002\u0013%\u00111\u001a\u0002\u0017)V\u0004H.\u001a#jM\u001a,'/\u001a8dK&sG/Z4fe*\u0011A$H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001f?\u0005A1-\u0019;bYf\u001cHO\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001S]j\u0004c\u0001\u0016,[5\t1$\u0003\u0002-7\t\u0019B+\u001e9mK\u0012KgMZ3sK:\u001cWMQ1tKB\u0011a&N\u0007\u0002_)\u0011\u0001'M\u0001\nC:Lg\u000e^3hKJT!AM\u001a\u0002\u000bQ,\b\u000f\\3\u000b\u0005Q\u001a\u0013\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018B\u0001\u001c0\u00059Ie\u000e^3hKJ\u001cV/\\7bef\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\r:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005\u0015K\u0014a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!R\u001d\u0002\t1,g\r^\u000b\u0002\u0017B\u0011!\u0006T\u0005\u0003\u001bn\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2a\u0015+V!\tQ\u0003\u0001C\u0003J\u000b\u0001\u00071\nC\u0003P\u000b\u0001\u00071*A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00191\u000b\u0017.\t\u000be3\u0001\u0019A&\u0002\u000f9,w\u000fT3gi\")1L\u0002a\u0001\u0017\u0006Aa.Z<SS\u001eDG/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A\u0018\t\u0003?\u000et!\u0001Y1\u0011\u0005\u0001K\u0014B\u00012:\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tL\u0014A\u00053jM\u001a,'/\u001a8dKN[W\r^2iKN$B\u0001[6tkB\u0011\u0001([\u0005\u0003Uf\u0012A!\u00168ji\")A\u000e\u0003a\u0001[\u0006a1o[3uG\"\f$)\u001f;fgB\u0019\u0001H\u001c9\n\u0005=L$!B!se\u0006L\bC\u0001\u001dr\u0013\t\u0011\u0018H\u0001\u0003CsR,\u0007\"\u0002;\t\u0001\u0004i\u0017\u0001D:lKR\u001c\u0007N\r\"zi\u0016\u001c\b\"\u0002<\t\u0001\u00049\u0018!B1O_R\u0014\u0005c\u0001=z[5\t\u0011'\u0003\u0002{c\t)\u0011I\\8u\u0005\u0006!1m\u001c9z)\r\u0019VP \u0005\b\u0013&\u0001\n\u00111\u0001L\u0011\u001dy\u0015\u0002%AA\u0002-\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0004)\u001a1*!\u0002,\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0005:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tYAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003mC:<'BAA\u0014\u0003\u0011Q\u0017M^1\n\u0007\u0011\f\t#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00020A\u0019\u0001(!\r\n\u0007\u0005M\u0012HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002:\u0005}\u0002c\u0001\u001d\u0002<%\u0019\u0011QH\u001d\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002B9\t\t\u00111\u0001\u00020\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0012\u0011\r\u0005%\u0013qJA\u001d\u001b\t\tYEC\u0002\u0002Ne\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t&a\u0013\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003/\ni\u0006E\u00029\u00033J1!a\u0017:\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0011\u0011\u0003\u0003\u0005\r!!\u000f\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003;\t\u0019\u0007C\u0005\u0002BE\t\t\u00111\u0001\u00020\u00051Q-];bYN$B!a\u0016\u0002j!I\u0011\u0011\t\n\u0002\u0002\u0003\u0007\u0011\u0011\b\u0015\u0014\u0001\u00055\u00141OA;\u0003s\nY(a \u0002\u0002\u0006\u0015\u0015q\u0011\t\u0004U\u0005=\u0014bAA97\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA<\u0003\t%!\u0002\t\u0011!A}3UKT\"`QQ,\b\u000f\\3TW\u0016$8\r[\u0019-AQ,\b\u000f\\3TW\u0016$8\r\u001b\u001a*A5\u00023+\u001e2ue\u0006\u001cGo\u001d\u0011uo>\u0004#-\u001b8bef\u0004#/\u001a9sKN,g\u000e^1uS>t7\u000fI8gA\u0011\u000bG/Y:lKR\u001c\u0007.Z:\u000bA\u0001\u0002\u0003\u0005V;qY\u0016\u001c6.\u001a;dQ\u0002z'M[3diN\u0004s/\u001b;iA%tG/Z4fe\u0002\u001aX/\\7bef\u0004C-\u0019;bAQL\b/\u001a\u0011vg&tw\rI1!)V\u0004H.Z*lKR\u001c\u0007\u000eI!o_R\u0014\u0005e\u001c2kK\u000e$hF\u0003\u0011!A\u0001\u0012V\r^;s]N\u0004S\r\\3nK:$8\u000fI5oAQDW\r\t4jeN$\be]6fi\u000eD\u0007\u0005\u001e5bi\u0002\n'/\u001a\u0011o_R\u0004\u0013N\u001c\u0011uQ\u0016\u00043/Z2p]\u0012\u00043o[3uG\"t\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti(AA~\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\"X\u000f\u001d7f?N\\W\r^2i?\u0016\u001cH/[7bi\u0016|\u0016N\u001c;fO\u0016\u0014\bf\u0018$V\u001d\u000e{\u0006\u0006^;qY\u0016|6o[3uG\"|\u0016mZ4`S:$XmZ3sQ\r|G.\r\u0017!m\u0006d\u0017'\u000b\u0017!iV\u0004H.Z0tW\u0016$8\r[0bO\u001e|\u0016N\u001c;fO\u0016\u0014\bfY8me1\u0002c/\u001973S%J\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002BS\u0007\f\u00116Y\u0001\"D\u0006\t\u001b*Y\u0001B\u0013\u0007\f\u00112Y\u0001\"D\u0006\t\u001b*Y\u0001B#\u0007\f\u00113Y\u0001*D\u0006I\u001b*Y\u0001B3\u0007\f\u00114Y\u0001\nD\u0006I\u0019*AQ\f'\rK2pYFb\u0003E^1mc1\u00023m\u001c73Y\u00012\u0018\r\u001c\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012d\u0006\r\u0006!A\u0005)qM]8va\u0006\u0012\u00111Q\u0001\rg.,Go\u00195`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0013\u000bQ\u0001\u000e\u00183]A\na\u0003V;qY\u0016$\u0015N\u001a4fe\u0016t7-Z%oi\u0016<WM\u001d\t\u0003UQ\u0019R\u0001FAI\u0003;\u0003r!a%\u0002\u001a.[5+\u0004\u0002\u0002\u0016*\u0019\u0011qS\u001d\u0002\u000fI,h\u000e^5nK&!\u00111TAK\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*!\u00111UA\u0013\u0003\tIw.C\u0002H\u0003C#\"!!$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bM\u000b\t,a-\t\u000b%;\u0002\u0019A&\t\u000b=;\u0002\u0019A&\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011XAc!\u0015A\u00141XA`\u0013\r\ti,\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\n\tmS&\n\u0007\u0005\r\u0017H\u0001\u0004UkBdWM\r\u0005\t\u0003\u000fD\u0012\u0011!a\u0001'\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u00055\u0007\u0003BA\u0010\u0003\u001fLA!!5\u0002\"\t1qJ\u00196fGR\u0004")
public class TupleDifferenceInteger
extends TupleDifferenceBase<IntegerSummary>
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(TupleDifferenceInteger x$0) {
        return TupleDifferenceInteger$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, TupleDifferenceInteger> tupled() {
        return TupleDifferenceInteger$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TupleDifferenceInteger>> curried() {
        return TupleDifferenceInteger$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public TupleDifferenceInteger withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    @Override
    public String prettyName() {
        return "tuple_difference_integer";
    }

    @Override
    public void differenceSketches(byte[] sketch1Bytes, byte[] sketch2Bytes, AnotB<IntegerSummary> aNotB) {
        Sketch<IntegerSummary> tupleSketch1 = TupleSketchUtils$.MODULE$.heapifyIntegerSketch(sketch1Bytes, this.prettyName());
        Sketch<IntegerSummary> tupleSketch2 = TupleSketchUtils$.MODULE$.heapifyIntegerSketch(sketch2Bytes, this.prettyName());
        aNotB.setA(tupleSketch1);
        aNotB.notB(tupleSketch2);
    }

    public TupleDifferenceInteger copy(Expression left, Expression right) {
        return new TupleDifferenceInteger(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "TupleDifferenceInteger";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleDifferenceInteger;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleDifferenceInteger)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleDifferenceInteger tupleDifferenceInteger = (TupleDifferenceInteger)x$1;
        Expression expression = this.left();
        Expression expression2 = tupleDifferenceInteger.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = tupleDifferenceInteger.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!tupleDifferenceInteger.canEqual(this)) return false;
        return true;
    }

    public TupleDifferenceInteger(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

