/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.DeserializerBuildHelper$;
import org.apache.spark.sql.catalyst.SerializerBuildHelper;
import org.apache.spark.sql.catalyst.WalkedTypePath;
import org.apache.spark.sql.catalyst.WalkedTypePath$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.AgnosticExpressionPathEncoder;
import org.apache.spark.sql.catalyst.encoders.Codec;
import org.apache.spark.sql.catalyst.encoders.EncoderUtils$;
import org.apache.spark.sql.catalyst.encoders.JavaSerializationCodec$;
import org.apache.spark.sql.catalyst.encoders.KryoSerializationCodec$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull$;
import org.apache.spark.sql.catalyst.expressions.objects.EncodeUsingSerializer;
import org.apache.spark.sql.catalyst.expressions.objects.ExternalMapToCatalyst$;
import org.apache.spark.sql.catalyst.expressions.objects.GetExternalRowField;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.objects.UnwrapOption;
import org.apache.spark.sql.catalyst.expressions.objects.ValidateExternalType;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.CharVarcharCodegenUtils;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.STUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.CharType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VarcharType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class SerializerBuildHelper$ {
    public static final SerializerBuildHelper$ MODULE$ = new SerializerBuildHelper$();

    private boolean nullOnOverflow() {
        return !SQLConf$.MODULE$.get().ansiEnabled();
    }

    public Expression createSerializerForBoolean(Expression inputObject) {
        return new Invoke(inputObject, "booleanValue", (DataType)BooleanType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForByte(Expression inputObject) {
        return new Invoke(inputObject, "byteValue", (DataType)ByteType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForShort(Expression inputObject) {
        return new Invoke(inputObject, "shortValue", (DataType)ShortType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForInteger(Expression inputObject) {
        return new Invoke(inputObject, "intValue", (DataType)IntegerType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForLong(Expression inputObject) {
        return new Invoke(inputObject, "longValue", (DataType)LongType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForFloat(Expression inputObject) {
        return new Invoke(inputObject, "floatValue", (DataType)FloatType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForDouble(Expression inputObject) {
        return new Invoke(inputObject, "doubleValue", (DataType)DoubleType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForGeographyType(Expression inputObject, GeographyType gt) {
        Class<STUtils> x$1 = STUtils.class;
        GeographyType x$2 = gt;
        String x$3 = "serializeGeogFromWKB";
        Expression expression = inputObject;
        Literal literal = Literal$.MODULE$.fromObject(gt);
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(STUtils.class, (DataType)x$2, "serializeGeogFromWKB", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForGeometryType(Expression inputObject, GeometryType gt) {
        Class<STUtils> x$1 = STUtils.class;
        GeometryType x$2 = gt;
        String x$3 = "serializeGeomFromWKB";
        Expression expression = inputObject;
        Literal literal = Literal$.MODULE$.fromObject(gt);
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(STUtils.class, (DataType)x$2, "serializeGeomFromWKB", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForChar(Expression inputObject, int length) {
        Class<CharVarcharCodegenUtils> x$1 = CharVarcharCodegenUtils.class;
        CharType x$2 = CharType$.MODULE$.apply(length);
        String x$3 = "charTypeWriteSideCheck";
        Expression expression = this.createSerializerForString(inputObject);
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(CharVarcharCodegenUtils.class, (DataType)x$2, "charTypeWriteSideCheck", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForVarchar(Expression inputObject, int length) {
        Class<CharVarcharCodegenUtils> x$1 = CharVarcharCodegenUtils.class;
        VarcharType x$2 = VarcharType$.MODULE$.apply(length);
        String x$3 = "varcharTypeWriteSideCheck";
        Expression expression = this.createSerializerForString(inputObject);
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(CharVarcharCodegenUtils.class, (DataType)x$2, "varcharTypeWriteSideCheck", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForString(Expression inputObject) {
        Class<UTF8String> x$1 = UTF8String.class;
        StringType$ x$2 = StringType$.MODULE$;
        String x$3 = "fromString";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(UTF8String.class, (DataType)x$2, "fromString", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForJavaInstant(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimestampType$ x$2 = TimestampType$.MODULE$;
        String x$3 = "instantToMicros";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "instantToMicros", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForLocalTime(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimeType x$2 = TimeType$.MODULE$.apply();
        String x$3 = "localTimeToNanos";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "localTimeToNanos", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForScalaEnum(Expression inputObject) {
        Expression x$1 = inputObject;
        String x$2 = "toString";
        ObjectType x$3 = new ObjectType(String.class);
        boolean x$4 = false;
        scala.collection.immutable.Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        scala.collection.immutable.Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return this.createSerializerForString(new Invoke(x$1, "toString", (DataType)x$3, x$5, x$6, x$7, false, x$8));
    }

    public Expression createSerializerForJavaEnum(Expression inputObject) {
        return this.createSerializerForString(new Invoke(inputObject, "name", (DataType)new ObjectType(String.class), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()));
    }

    public Expression createSerializerForSqlTimestamp(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimestampType$ x$2 = TimestampType$.MODULE$;
        String x$3 = "fromJavaTimestamp";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "fromJavaTimestamp", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForAnyTimestamp(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimestampType$ x$2 = TimestampType$.MODULE$;
        String x$3 = "anyToMicros";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "anyToMicros", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForLocalDateTime(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimestampNTZType$ x$2 = TimestampNTZType$.MODULE$;
        String x$3 = "localDateTimeToMicros";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "localDateTimeToMicros", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForJavaLocalDate(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        DateType$ x$2 = DateType$.MODULE$;
        String x$3 = "localDateToDays";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "localDateToDays", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForSqlDate(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        DateType$ x$2 = DateType$.MODULE$;
        String x$3 = "fromJavaDate";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "fromJavaDate", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForAnyDate(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        DateType$ x$2 = DateType$.MODULE$;
        String x$3 = "anyToDays";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "anyToDays", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForJavaDuration(Expression inputObject) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        DayTimeIntervalType x$2 = DayTimeIntervalType$.MODULE$.apply();
        String x$3 = "durationToMicros";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "durationToMicros", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForJavaPeriod(Expression inputObject) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        YearMonthIntervalType x$2 = YearMonthIntervalType$.MODULE$.apply();
        String x$3 = "periodToMonths";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "periodToMonths", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForBigDecimal(Expression inputObject) {
        return this.createSerializerForBigDecimal(inputObject, DecimalType$.MODULE$.SYSTEM_DEFAULT());
    }

    public Expression createSerializerForBigDecimal(Expression inputObject, DecimalType dt) {
        Class x$1 = Decimal$.MODULE$.getClass();
        DecimalType x$2 = dt;
        String x$3 = "apply";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new CheckOverflow(new StaticInvoke(x$1, (DataType)x$2, "apply", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9), dt, this.nullOnOverflow());
    }

    public Expression createSerializerForAnyDecimal(Expression inputObject, DecimalType dt) {
        Class x$1 = Decimal$.MODULE$.getClass();
        DecimalType x$2 = dt;
        String x$3 = "fromDecimal";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new CheckOverflow(new StaticInvoke(x$1, (DataType)x$2, "fromDecimal", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9), dt, this.nullOnOverflow());
    }

    public Expression createSerializerForBigInteger(Expression inputObject) {
        Class x$1 = Decimal$.MODULE$.getClass();
        DecimalType x$2 = DecimalType$.MODULE$.BigIntDecimal();
        String x$3 = "apply";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new CheckOverflow(new StaticInvoke(x$1, (DataType)x$2, "apply", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9), DecimalType$.MODULE$.BigIntDecimal(), this.nullOnOverflow());
    }

    public Expression createSerializerForPrimitiveArray(Expression inputObject, DataType dataType) {
        Class<UnsafeArrayData> x$1 = UnsafeArrayData.class;
        ArrayType x$2 = new ArrayType(dataType, false);
        String x$3 = "fromPrimitiveArray";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        scala.collection.immutable.Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(UnsafeArrayData.class, (DataType)x$2, "fromPrimitiveArray", (scala.collection.immutable.Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createSerializerForGenericArray(Expression inputObject, DataType dataType, boolean nullable) {
        Expression expression = inputObject;
        return NewInstance$.MODULE$.apply(GenericArrayData.class, (scala.collection.immutable.Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), (DataType)new ArrayType(dataType, nullable), NewInstance$.MODULE$.apply$default$4());
    }

    public Expression createSerializerForMapObjects(Expression inputObject, ObjectType dataType, Function1<Expression, Expression> funcForNewExpr) {
        return MapObjects$.MODULE$.apply(funcForNewExpr, inputObject, (DataType)dataType, MapObjects$.MODULE$.apply$default$4(), MapObjects$.MODULE$.apply$default$5());
    }

    public Expression createSerializerForMap(Expression inputObject, SerializerBuildHelper.MapElementInformation keyInformation, SerializerBuildHelper.MapElementInformation valueInformation) {
        return ExternalMapToCatalyst$.MODULE$.apply(inputObject, keyInformation.dataType(), keyInformation.funcForNewExpr(), keyInformation.nullable(), valueInformation.dataType(), valueInformation.funcForNewExpr(), valueInformation.nullable());
    }

    private scala.collection.immutable.Seq<Expression> argumentsForFieldSerializer(String fieldName, Expression serializerForFieldValue) {
        Literal literal = Literal$.MODULE$.apply(fieldName);
        Expression expression = serializerForFieldValue;
        return Nil$.MODULE$.$colon$colon((Object)expression).$colon$colon((Object)literal);
    }

    public Expression createSerializerForObject(Expression inputObject, scala.collection.immutable.Seq<Tuple2<String, Expression>> fields) {
        CreateNamedStruct nonNullOutput = new CreateNamedStruct((scala.collection.immutable.Seq<Expression>)((scala.collection.immutable.Seq)fields.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String fieldName = (String)tuple2._1();
                Expression fieldExpr = (Expression)tuple2._2();
                return MODULE$.argumentsForFieldSerializer(fieldName, fieldExpr);
            }
            throw new MatchError((Object)tuple2);
        })));
        if (inputObject.nullable()) {
            Literal nullOutput = Literal$.MODULE$.create(null, (DataType)nonNullOutput.dataType());
            return new If(new IsNull(inputObject), nullOutput, nonNullOutput);
        }
        return nonNullOutput;
    }

    public Expression createSerializerForUserDefinedType(Expression inputObject, UserDefinedType<?> udt, Class<?> udtClass) {
        NewInstance obj = NewInstance$.MODULE$.apply(udtClass, (scala.collection.immutable.Seq<Expression>)Nil$.MODULE$, (DataType)new ObjectType(udtClass), NewInstance$.MODULE$.apply$default$4());
        Expression expression = inputObject;
        return new Invoke(obj, "serialize", (DataType)udt, (scala.collection.immutable.Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializer(AgnosticEncoder<?> enc) {
        BoundReference input = new BoundReference(0, EncoderUtils$.MODULE$.lenientExternalDataTypeFor(enc), enc.nullable());
        return this.createSerializer(enc, input);
    }

    private Expression createSerializer(AgnosticEncoder<?> enc, Expression input) {
        AgnosticEncoder agnosticEncoder;
        while (true) {
            AgnosticEncoders.InstantEncoder instantEncoder;
            boolean bl;
            AgnosticEncoders.TimestampEncoder timestampEncoder;
            boolean bl2;
            AgnosticEncoders.InstantEncoder instantEncoder2;
            boolean bl3;
            AgnosticEncoders.TimestampEncoder timestampEncoder2;
            boolean bl4;
            AgnosticEncoders.LocalDateEncoder localDateEncoder;
            boolean bl5;
            AgnosticEncoders.DateEncoder dateEncoder;
            boolean bl6;
            AgnosticEncoders.LocalDateEncoder localDateEncoder2;
            boolean bl7;
            AgnosticEncoders.DateEncoder dateEncoder2;
            boolean bl8;
            boolean bl9 = false;
            AgnosticEncoders.JavaDecimalEncoder javaDecimalEncoder = null;
            boolean bl10 = false;
            AgnosticEncoder agnosticEncoder2 = null;
            boolean bl11 = false;
            AgnosticEncoders.TransformingEncoder transformingEncoder = null;
            agnosticEncoder = enc;
            if (agnosticEncoder instanceof AgnosticExpressionPathEncoder) {
                AgnosticExpressionPathEncoder agnosticExpressionPathEncoder = (AgnosticExpressionPathEncoder)agnosticEncoder;
                return agnosticExpressionPathEncoder.toCatalyst(input);
            }
            if (EncoderUtils$.MODULE$.isNativeEncoder(enc)) {
                return input;
            }
            if (AgnosticEncoders.BoxedBooleanEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForBoolean(input);
            }
            if (AgnosticEncoders.BoxedByteEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForByte(input);
            }
            if (AgnosticEncoders.BoxedShortEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForShort(input);
            }
            if (AgnosticEncoders.BoxedIntEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForInteger(input);
            }
            if (AgnosticEncoders.BoxedLongEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForLong(input);
            }
            if (AgnosticEncoders.BoxedFloatEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForFloat(input);
            }
            if (AgnosticEncoders.BoxedDoubleEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForDouble(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.JavaEnumEncoder) {
                return this.createSerializerForJavaEnum(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.ScalaEnumEncoder) {
                return this.createSerializerForScalaEnum(input);
            }
            if ((agnosticEncoder instanceof AgnosticEncoders.GeographyEncoder ? true : agnosticEncoder instanceof AgnosticEncoders.GeometryEncoder) && !SQLConf$.MODULE$.get().geospatialEnabled()) {
                throw new AnalysisException("UNSUPPORTED_FEATURE.GEOSPATIAL_DISABLED", Map$.MODULE$.empty());
            }
            if (agnosticEncoder instanceof AgnosticEncoders.GeographyEncoder) {
                AgnosticEncoders.GeographyEncoder geographyEncoder = (AgnosticEncoders.GeographyEncoder)agnosticEncoder;
                return this.createSerializerForGeographyType(input, geographyEncoder.dt());
            }
            if (agnosticEncoder instanceof AgnosticEncoders.GeometryEncoder) {
                AgnosticEncoders.GeometryEncoder geometryEncoder = (AgnosticEncoders.GeometryEncoder)agnosticEncoder;
                return this.createSerializerForGeometryType(input, geometryEncoder.dt());
            }
            if (agnosticEncoder instanceof AgnosticEncoders.CharEncoder) {
                AgnosticEncoders.CharEncoder charEncoder = (AgnosticEncoders.CharEncoder)agnosticEncoder;
                int length = charEncoder.length();
                return this.createSerializerForChar(input, length);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.VarcharEncoder) {
                AgnosticEncoders.VarcharEncoder varcharEncoder = (AgnosticEncoders.VarcharEncoder)agnosticEncoder;
                int length = varcharEncoder.length();
                return this.createSerializerForVarchar(input, length);
            }
            if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForString(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.ScalaDecimalEncoder) {
                AgnosticEncoders.ScalaDecimalEncoder scalaDecimalEncoder = (AgnosticEncoders.ScalaDecimalEncoder)agnosticEncoder;
                DecimalType dt = scalaDecimalEncoder.dt();
                return this.createSerializerForBigDecimal(input, dt);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.JavaDecimalEncoder) {
                bl9 = true;
                javaDecimalEncoder = (AgnosticEncoders.JavaDecimalEncoder)agnosticEncoder;
                DecimalType dt = javaDecimalEncoder.dt();
                boolean bl12 = javaDecimalEncoder.lenientSerialization();
                if (!bl12) {
                    return this.createSerializerForBigDecimal(input, dt);
                }
            }
            if (bl9) {
                DecimalType dt = javaDecimalEncoder.dt();
                boolean bl13 = javaDecimalEncoder.lenientSerialization();
                if (bl13) {
                    return this.createSerializerForAnyDecimal(input, dt);
                }
            }
            if (AgnosticEncoders.ScalaBigIntEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForBigInteger(input);
            }
            if (AgnosticEncoders.JavaBigIntEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForBigInteger(input);
            }
            if (AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForJavaDuration(input);
            }
            if (AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForJavaPeriod(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.DateEncoder && true == (bl8 = (dateEncoder2 = (AgnosticEncoders.DateEncoder)agnosticEncoder).lenientSerialization()) ? true : agnosticEncoder instanceof AgnosticEncoders.LocalDateEncoder && true == (bl7 = (localDateEncoder2 = (AgnosticEncoders.LocalDateEncoder)agnosticEncoder).lenientSerialization())) {
                return this.createSerializerForAnyDate(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.DateEncoder && !(bl6 = (dateEncoder = (AgnosticEncoders.DateEncoder)agnosticEncoder).lenientSerialization())) {
                return this.createSerializerForSqlDate(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.LocalDateEncoder && !(bl5 = (localDateEncoder = (AgnosticEncoders.LocalDateEncoder)agnosticEncoder).lenientSerialization())) {
                return this.createSerializerForJavaLocalDate(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.TimestampEncoder && true == (bl4 = (timestampEncoder2 = (AgnosticEncoders.TimestampEncoder)agnosticEncoder).lenientSerialization()) ? true : agnosticEncoder instanceof AgnosticEncoders.InstantEncoder && true == (bl3 = (instantEncoder2 = (AgnosticEncoders.InstantEncoder)agnosticEncoder).lenientSerialization())) {
                return this.createSerializerForAnyTimestamp(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.TimestampEncoder && !(bl2 = (timestampEncoder = (AgnosticEncoders.TimestampEncoder)agnosticEncoder).lenientSerialization())) {
                return this.createSerializerForSqlTimestamp(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.InstantEncoder && !(bl = (instantEncoder = (AgnosticEncoders.InstantEncoder)agnosticEncoder).lenientSerialization())) {
                return this.createSerializerForJavaInstant(input);
            }
            if (AgnosticEncoders.LocalDateTimeEncoder$.MODULE$.equals(agnosticEncoder)) {
                return this.createSerializerForLocalDateTime(input);
            }
            if (AgnosticEncoders.LocalTimeEncoder$.MODULE$.equals(agnosticEncoder)) {
                bl10 = true;
                agnosticEncoder2 = agnosticEncoder;
                if (!SQLConf$.MODULE$.get().isTimeTypeEnabled()) {
                    throw QueryCompilationErrors$.MODULE$.unsupportedTimeTypeError();
                }
            }
            if (bl10) {
                return this.createSerializerForLocalTime(input);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.UDTEncoder) {
                AgnosticEncoders.UDTEncoder uDTEncoder = (AgnosticEncoders.UDTEncoder)agnosticEncoder;
                UserDefinedType udt = uDTEncoder.udt();
                Class udtClass = uDTEncoder.udtClass();
                return this.createSerializerForUserDefinedType(input, udt, udtClass);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.OptionEncoder) {
                AgnosticEncoders.OptionEncoder optionEncoder = (AgnosticEncoders.OptionEncoder)agnosticEncoder;
                AgnosticEncoder valueEnc = optionEncoder.elementEncoder();
                input = new UnwrapOption(EncoderUtils$.MODULE$.externalDataTypeFor(valueEnc), input);
                enc = valueEnc;
                continue;
            }
            if (agnosticEncoder instanceof AgnosticEncoders.ArrayEncoder) {
                AgnosticEncoders.ArrayEncoder arrayEncoder = (AgnosticEncoders.ArrayEncoder)agnosticEncoder;
                AgnosticEncoder elementEncoder = arrayEncoder.element();
                boolean containsNull = arrayEncoder.containsNull();
                if (elementEncoder.isPrimitive()) {
                    return this.createSerializerForPrimitiveArray(input, elementEncoder.dataType());
                }
                return this.serializerForArray(elementEncoder, containsNull, input, false);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.IterableEncoder) {
                AgnosticEncoders.IterableEncoder iterableEncoder = (AgnosticEncoders.IterableEncoder)agnosticEncoder;
                ClassTag ctag = iterableEncoder.clsTag();
                AgnosticEncoder elementEncoder = iterableEncoder.element();
                boolean containsNull = iterableEncoder.containsNull();
                boolean lenientSerialization = iterableEncoder.lenientSerialization();
                Expression getter = Set.class.isAssignableFrom(ctag.runtimeClass()) ? new Invoke(input, "toSeq", (DataType)new ObjectType(Seq.class), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()) : input;
                return this.serializerForArray(elementEncoder, containsNull, getter, lenientSerialization);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.MapEncoder) {
                AgnosticEncoders.MapEncoder mapEncoder = (AgnosticEncoders.MapEncoder)agnosticEncoder;
                AgnosticEncoder keyEncoder = mapEncoder.keyEncoder();
                AgnosticEncoder valueEncoder = mapEncoder.valueEncoder();
                boolean valueContainsNull = mapEncoder.valueContainsNull();
                return this.createSerializerForMap(input, new SerializerBuildHelper.MapElementInformation((DataType)new ObjectType(Object.class), keyEncoder.nullable(), this.validateAndSerializeElement(keyEncoder, keyEncoder.nullable())), new SerializerBuildHelper.MapElementInformation((DataType)new ObjectType(Object.class), valueContainsNull, this.validateAndSerializeElement(valueEncoder, valueContainsNull)));
            }
            if (agnosticEncoder instanceof AgnosticEncoders.ProductEncoder) {
                AgnosticEncoders.ProductEncoder productEncoder = (AgnosticEncoders.ProductEncoder)agnosticEncoder;
                scala.collection.immutable.Seq fields = productEncoder.fields();
                scala.collection.immutable.Seq serializedFields = (scala.collection.immutable.Seq)fields.map((Function1 & Serializable)field -> {
                    KnownNotNull x$1 = new KnownNotNull(input);
                    String x$2 = field.name();
                    DataType x$3 = EncoderUtils$.MODULE$.externalDataTypeFor(field.enc());
                    boolean x$4 = field.nullable();
                    scala.collection.immutable.Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
                    scala.collection.immutable.Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
                    boolean x$7 = Invoke$.MODULE$.apply$default$6();
                    boolean x$8 = Invoke$.MODULE$.apply$default$8();
                    Invoke getter = new Invoke(x$1, x$2, x$3, x$5, x$6, x$7, x$4, x$8);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)MODULE$.createSerializer(field.enc(), getter));
                });
                return this.createSerializerForObject(input, (scala.collection.immutable.Seq<Tuple2<String, Expression>>)serializedFields);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.RowEncoder) {
                AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)agnosticEncoder;
                scala.collection.immutable.Seq fields = rowEncoder.fields();
                scala.collection.immutable.Seq serializedFields = (scala.collection.immutable.Seq)((IterableOps)fields.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Expression expression;
                        AgnosticEncoders.EncoderField field = (AgnosticEncoders.EncoderField)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Expression fieldValue = MODULE$.createSerializer(field.enc(), new ValidateExternalType(new GetExternalRowField(input, index, field.name()), field.enc().dataType(), EncoderUtils$.MODULE$.lenientExternalDataTypeFor(field.enc())));
                        if (field.nullable()) {
                            Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)index));
                            If if_ = new If(new Invoke(input, "isNullAt", (DataType)BooleanType$.MODULE$, (scala.collection.immutable.Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()), Literal$.MODULE$.create(null, fieldValue.dataType()), fieldValue);
                            expression = if_;
                        } else {
                            expression = new AssertNotNull(fieldValue, AssertNotNull$.MODULE$.apply$default$2());
                        }
                        Expression convertedField = expression;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)convertedField);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return this.createSerializerForObject(input, (scala.collection.immutable.Seq<Tuple2<String, Expression>>)serializedFields);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.JavaBeanEncoder) {
                AgnosticEncoders.JavaBeanEncoder javaBeanEncoder = (AgnosticEncoders.JavaBeanEncoder)agnosticEncoder;
                scala.collection.immutable.Seq fields = javaBeanEncoder.fields();
                scala.collection.immutable.Seq serializedFields = (scala.collection.immutable.Seq)fields.map((Function1 & Serializable)f -> {
                    KnownNotNull x$9 = new KnownNotNull(input);
                    String x$10 = (String)f.readMethod().get();
                    DataType x$11 = EncoderUtils$.MODULE$.externalDataTypeFor(f.enc());
                    boolean x$12 = f.nullable();
                    boolean x$13 = f.nullable();
                    scala.collection.immutable.Seq<Expression> x$14 = Invoke$.MODULE$.apply$default$4();
                    scala.collection.immutable.Seq<AbstractDataType> x$15 = Invoke$.MODULE$.apply$default$5();
                    boolean x$16 = Invoke$.MODULE$.apply$default$8();
                    Invoke fieldValue = new Invoke(x$9, x$10, x$11, x$14, x$15, x$12, x$13, x$16);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)MODULE$.createSerializer(f.enc(), fieldValue));
                });
                return this.createSerializerForObject(input, (scala.collection.immutable.Seq<Tuple2<String, Expression>>)serializedFields);
            }
            if (agnosticEncoder instanceof AgnosticEncoders.TransformingEncoder) {
                Function0 codec;
                bl11 = true;
                transformingEncoder = (AgnosticEncoders.TransformingEncoder)agnosticEncoder;
                Function0 function0 = codec = transformingEncoder.codecProvider();
                JavaSerializationCodec$ javaSerializationCodec$ = JavaSerializationCodec$.MODULE$;
                if (!(function0 != null ? !function0.equals(javaSerializationCodec$) : javaSerializationCodec$ != null)) {
                    return new EncodeUsingSerializer(input, false);
                }
            }
            if (bl11) {
                Function0 codec;
                Function0 function0 = codec = transformingEncoder.codecProvider();
                KryoSerializationCodec$ kryoSerializationCodec$ = KryoSerializationCodec$.MODULE$;
                if (!(function0 != null ? !function0.equals(kryoSerializationCodec$) : kryoSerializationCodec$ != null)) {
                    return new EncodeUsingSerializer(input, true);
                }
            }
            if (!bl11) break;
            AgnosticEncoder encoder = transformingEncoder.transformed();
            Function0 codecProvider = transformingEncoder.codecProvider();
            Literal x$17 = new Literal(codecProvider.apply(), (DataType)new ObjectType(Codec.class));
            String x$18 = "encode";
            DataType x$19 = EncoderUtils$.MODULE$.externalDataTypeFor(encoder);
            Expression expression = input;
            List x$20 = Nil$.MODULE$.$colon$colon((Object)expression);
            boolean x$21 = input.nullable();
            boolean x$22 = input.nullable();
            scala.collection.immutable.Seq<AbstractDataType> x$23 = Invoke$.MODULE$.apply$default$5();
            boolean x$24 = Invoke$.MODULE$.apply$default$8();
            Invoke encoded = new Invoke(x$17, "encode", x$19, (scala.collection.immutable.Seq<Expression>)x$20, x$23, x$21, x$22, x$24);
            input = encoded;
            enc = encoder;
        }
        throw new MatchError((Object)agnosticEncoder);
    }

    private Expression serializerForArray(AgnosticEncoder<?> elementEnc, boolean elementNullable, Expression input, boolean lenientSerialization) {
        None$ primitiveEncoderOption;
        None$ none$;
        Expression genericSerializer = this.createSerializerForMapObjects(input, new ObjectType(Object.class), this.validateAndSerializeElement(elementEnc, elementNullable));
        AgnosticEncoder<?> agnosticEncoder = elementEnc;
        if (!lenientSerialization) {
            none$ = None$.MODULE$;
        } else if (agnosticEncoder instanceof AgnosticEncoders.PrimitiveLeafEncoder) {
            AgnosticEncoders.PrimitiveLeafEncoder primitiveLeafEncoder = (AgnosticEncoders.PrimitiveLeafEncoder)agnosticEncoder;
            none$ = Option$.MODULE$.apply((Object)primitiveLeafEncoder);
        } else if (agnosticEncoder instanceof AgnosticEncoders.BoxedLeafEncoder) {
            AgnosticEncoders.BoxedLeafEncoder boxedLeafEncoder = (AgnosticEncoders.BoxedLeafEncoder)agnosticEncoder;
            none$ = Option$.MODULE$.apply((Object)boxedLeafEncoder.primitive());
        } else {
            none$ = None$.MODULE$;
        }
        None$ none$2 = primitiveEncoderOption = none$;
        if (none$2 instanceof Some) {
            Some some = (Some)none$2;
            AgnosticEncoders.PrimitiveLeafEncoder primitiveEncoder = (AgnosticEncoders.PrimitiveLeafEncoder)some.value();
            Class primitiveArrayClass = primitiveEncoder.clsTag().wrap().runtimeClass();
            Literal x$1 = Literal$.MODULE$.fromObject(primitiveArrayClass);
            String x$2 = "isInstance";
            BooleanType$ x$3 = BooleanType$.MODULE$;
            Expression expression = input;
            List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
            boolean x$5 = false;
            boolean x$6 = false;
            scala.collection.immutable.Seq<AbstractDataType> x$7 = Invoke$.MODULE$.apply$default$5();
            boolean x$8 = Invoke$.MODULE$.apply$default$8();
            Invoke check = new Invoke(x$1, "isInstance", (DataType)x$3, (scala.collection.immutable.Seq<Expression>)x$4, x$7, false, false, x$8);
            Class<ArrayData> x$9 = ArrayData.class;
            ArrayType x$10 = new ArrayType(elementEnc.dataType(), false);
            String x$11 = "toArrayData";
            Expression expression2 = input;
            List x$12 = Nil$.MODULE$.$colon$colon((Object)expression2);
            boolean x$13 = false;
            boolean x$14 = false;
            scala.collection.immutable.Seq<AbstractDataType> x$15 = StaticInvoke$.MODULE$.apply$default$5();
            boolean x$16 = StaticInvoke$.MODULE$.apply$default$8();
            Option<ScalarFunction<?>> x$17 = StaticInvoke$.MODULE$.apply$default$9();
            return new If(check, new StaticInvoke(ArrayData.class, (DataType)x$10, "toArrayData", (scala.collection.immutable.Seq<Expression>)x$12, x$15, false, false, x$16, x$17), genericSerializer);
        }
        if (None$.MODULE$.equals(none$2)) {
            return genericSerializer;
        }
        throw new MatchError((Object)none$2);
    }

    private Function1<Expression, Expression> validateAndSerializeElement(AgnosticEncoder<?> enc, boolean nullable) {
        return (Function1 & Serializable)input -> {
            DataType dataType;
            AgnosticEncoder agnosticEncoder = enc;
            if (agnosticEncoder instanceof AgnosticEncoders.OptionEncoder) {
                dataType = EncoderUtils$.MODULE$.lenientExternalDataTypeFor(enc);
            } else if (agnosticEncoder instanceof AgnosticEncoders.TransformingEncoder) {
                AgnosticEncoders.TransformingEncoder transformingEncoder = (AgnosticEncoders.TransformingEncoder)agnosticEncoder;
                AgnosticEncoder transformed = transformingEncoder.transformed();
                dataType = EncoderUtils$.MODULE$.lenientExternalDataTypeFor(transformed);
            } else {
                dataType = enc.dataType();
            }
            DataType expected = dataType;
            return DeserializerBuildHelper$.MODULE$.expressionWithNullSafety(MODULE$.createSerializer(enc, new ValidateExternalType((Expression)input, expected, EncoderUtils$.MODULE$.lenientExternalDataTypeFor(enc))), nullable, new WalkedTypePath(WalkedTypePath$.MODULE$.apply$default$1()));
        };
    }

    private SerializerBuildHelper$() {
    }
}

