/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.truncate;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateMapper;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.Mapper;

@Explain(displayName="Column Truncate", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ColumnTruncateWork
extends MapWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Path inputDir;
    private Path outputDir;
    private boolean hasDynamicPartitions;
    private DynamicPartitionCtx dynPartCtx;
    private boolean isListBucketingAlterTableConcatenate;
    private ListBucketingCtx listBucketingCtx;
    private List<Integer> droppedColumns;

    public ColumnTruncateWork() {
    }

    public ColumnTruncateWork(List<Integer> droppedColumns, Path inputDir, Path outputDir) {
        this(droppedColumns, inputDir, outputDir, false, null);
    }

    public ColumnTruncateWork(List<Integer> droppedColumns, Path inputDir, Path outputDir, boolean hasDynamicPartitions, DynamicPartitionCtx dynPartCtx) {
        this.droppedColumns = droppedColumns;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.hasDynamicPartitions = hasDynamicPartitions;
        this.dynPartCtx = dynPartCtx;
        PartitionDesc partDesc = new PartitionDesc();
        partDesc.setInputFileFormatClass(RCFileBlockMergeInputFormat.class);
        this.addPathToPartitionInfo(inputDir, partDesc);
    }

    public Path getInputDir() {
        return this.inputDir;
    }

    public void setInputPaths(Path inputDir) {
        this.inputDir = inputDir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(Path outputDir) {
        this.outputDir = outputDir;
    }

    public Class<? extends Mapper> getMapperClass() {
        return ColumnTruncateMapper.class;
    }

    @Override
    public Long getMinSplitSize() {
        return null;
    }

    @Override
    public String getInputformat() {
        return BucketizedHiveInputFormat.class.getName();
    }

    @Override
    public boolean isGatheringStats() {
        return false;
    }

    public boolean hasDynamicPartitions() {
        return this.hasDynamicPartitions;
    }

    public void setHasDynamicPartitions(boolean hasDynamicPartitions) {
        this.hasDynamicPartitions = hasDynamicPartitions;
    }

    public DynamicPartitionCtx getDynPartCtx() {
        return this.dynPartCtx;
    }

    public void setDynPartCtx(DynamicPartitionCtx dynPartCtx) {
        this.dynPartCtx = dynPartCtx;
    }

    public ListBucketingCtx getListBucketingCtx() {
        return this.listBucketingCtx;
    }

    public void setListBucketingCtx(ListBucketingCtx listBucketingCtx) {
        this.listBucketingCtx = listBucketingCtx;
    }

    public boolean isListBucketingAlterTableConcatenate() {
        return this.isListBucketingAlterTableConcatenate;
    }

    public List<Integer> getDroppedColumns() {
        return this.droppedColumns;
    }

    public void setDroppedColumns(List<Integer> droppedColumns) {
        this.droppedColumns = droppedColumns;
    }
}

