/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ParamValidators$ {
    public static final ParamValidators$ MODULE$ = new ParamValidators$();

    public <T> Function1<T, Object> alwaysTrue() {
        return (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$alwaysTrue$1(x$2));
    }

    private <T> double getDouble(T value) {
        T t = value;
        if (t instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(t);
            return n;
        }
        if (t instanceof Long) {
            long l = BoxesRunTime.unboxToLong(t);
            return l;
        }
        if (t instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(t);
            return f;
        }
        if (t instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(t);
            return d;
        }
        throw new IllegalArgumentException("Numerical Param validation failed because of unexpected input type: " + value.getClass());
    }

    public <T> Function1<T, Object> gt(double lowerBound) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$gt$1(lowerBound, value));
    }

    public <T> Function1<T, Object> gtEq(double lowerBound) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$gtEq$1(lowerBound, value));
    }

    public <T> Function1<T, Object> lt(double upperBound) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$lt$1(upperBound, value));
    }

    public <T> Function1<T, Object> ltEq(double upperBound) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$ltEq$1(upperBound, value));
    }

    public <T> Function1<T, Object> inRange(double lowerBound, double upperBound, boolean lowerInclusive, boolean upperInclusive) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$inRange$1(lowerInclusive, lowerBound, upperInclusive, upperBound, value));
    }

    public <T> Function1<T, Object> inRange(double lowerBound, double upperBound) {
        return this.inRange(lowerBound, upperBound, true, true);
    }

    public <T> Function1<T, Object> inArray(Object allowed) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.genericArrayOps(allowed), value));
    }

    public <T> Function1<T, Object> inArray(List<T> allowed) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)allowed.contains(value));
    }

    public <T> Function1<Object, Object> arrayLengthGt(double lowerBound) {
        return (Function1 & Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$arrayLengthGt$1(lowerBound, value));
    }

    public void checkSingleVsMultiColumnParams(Params model, Seq<Param<?>> singleColumnParams, Seq<Param<?>> multiColumnParams) {
        String name = model.getClass().getSimpleName() + " " + model;
        Param<Object> inputCol = model.getParam("inputCol");
        Param<Object> inputCols = model.getParam("inputCols");
        if (model.isSet(inputCol)) {
            Predef$.MODULE$.require(!model.isSet(inputCols), (Function0 & Serializable)() -> name + " requires exactly one of inputCol, inputCols Params to be set, but both are set.");
            ParamValidators$.checkExclusiveParams$1(true, singleColumnParams, multiColumnParams, model, name);
            return;
        }
        if (model.isSet(inputCols)) {
            ParamValidators$.checkExclusiveParams$1(false, multiColumnParams, singleColumnParams, model, name);
            return;
        }
        throw new IllegalArgumentException(name + " requires exactly one of inputCol, inputCols Params to be set, but neither is set.");
    }

    public static final /* synthetic */ boolean $anonfun$alwaysTrue$1(Object x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$gt$1(double lowerBound$1, Object value) {
        return MODULE$.getDouble(value) > lowerBound$1;
    }

    public static final /* synthetic */ boolean $anonfun$gtEq$1(double lowerBound$2, Object value) {
        return MODULE$.getDouble(value) >= lowerBound$2;
    }

    public static final /* synthetic */ boolean $anonfun$lt$1(double upperBound$1, Object value) {
        return MODULE$.getDouble(value) < upperBound$1;
    }

    public static final /* synthetic */ boolean $anonfun$ltEq$1(double upperBound$2, Object value) {
        return MODULE$.getDouble(value) <= upperBound$2;
    }

    public static final /* synthetic */ boolean $anonfun$inRange$1(boolean lowerInclusive$1, double lowerBound$3, boolean upperInclusive$1, double upperBound$3, Object value) {
        boolean lowerValid;
        double x = MODULE$.getDouble(value);
        boolean bl = lowerInclusive$1 ? x >= lowerBound$3 : (lowerValid = x > lowerBound$3);
        boolean upperValid = upperInclusive$1 ? x <= upperBound$3 : x < upperBound$3;
        return lowerValid && upperValid;
    }

    public static final /* synthetic */ boolean $anonfun$arrayLengthGt$1(double lowerBound$4, Object value) {
        return (double)ScalaRunTime$.MODULE$.array_length(value) > lowerBound$4;
    }

    public static final /* synthetic */ boolean $anonfun$checkSingleVsMultiColumnParams$3(Params model$1, Param p) {
        return !model$1.isDefined(p);
    }

    private static final void checkExclusiveParams$1(boolean isSingleCol, Seq requiredParams, Seq excludedParams, Params model$1, String name$1) {
        StringBuilder badParamsMsgBuilder = new StringBuilder();
        String mustUnsetParams = ((IterableOnceOps)((IterableOps)excludedParams.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)model$1.isSet(p)))).map((Function1 & Serializable)x$3 -> x$3.name())).mkString(", ");
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mustUnsetParams)) ? badParamsMsgBuilder.$plus$plus$eq("The following Params are not applicable and should not be set: " + mustUnsetParams + ".") : BoxedUnit.UNIT;
        String mustSetParams = ((IterableOnceOps)((IterableOps)requiredParams.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$checkSingleVsMultiColumnParams$3(model$1, p)))).map((Function1 & Serializable)x$4 -> x$4.name())).mkString(", ");
        Object object2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mustSetParams)) ? badParamsMsgBuilder.$plus$plus$eq("The following Params must be defined but are not set: " + mustSetParams + ".") : BoxedUnit.UNIT;
        String badParamsMsg = badParamsMsgBuilder.toString();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(badParamsMsg))) {
            String errPrefix = isSingleCol ? name$1 + " has the inputCol Param set for single-column transform." : name$1 + " has the inputCols Param set for multi-column transform.";
            throw new IllegalArgumentException(errPrefix + " " + badParamsMsg);
        }
    }

    private ParamValidators$() {
    }
}

