/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.security;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sparkproject.jetty.security.Authenticator;
import org.sparkproject.jetty.security.MultiAuthenticator;
import org.sparkproject.jetty.security.SecurityHandler;
import org.sparkproject.jetty.security.authentication.BasicAuthenticator;
import org.sparkproject.jetty.security.authentication.DigestAuthenticator;
import org.sparkproject.jetty.security.authentication.FormAuthenticator;
import org.sparkproject.jetty.security.authentication.SPNEGOAuthenticator;
import org.sparkproject.jetty.security.authentication.SslClientCertAuthenticator;
import org.sparkproject.jetty.server.Context;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.ssl.SslContextFactory;

public class DefaultAuthenticatorFactory
implements Authenticator.Factory {
    @Override
    public Authenticator getAuthenticator(Server server, Context context, Authenticator.Configuration configuration) {
        String auth = StringUtil.asciiToUpperCase(configuration.getAuthenticationType());
        if (auth == null) {
            return null;
        }
        return switch (auth) {
            case "BASIC" -> new BasicAuthenticator();
            case "DIGEST" -> new DigestAuthenticator();
            case "FORM" -> new FormAuthenticator();
            case "SPNEGO" -> new SPNEGOAuthenticator();
            case "NEGOTIATE" -> new SPNEGOAuthenticator("NEGOTIATE");
            case "MULTI" -> this.getMultiAuthenticator(server, context, configuration);
            case "CLIENT_CERT", "CLIENT-CERT" -> {
                Collection<SslContextFactory> sslContextFactories = server.getBeans(SslContextFactory.class);
                if (sslContextFactories.size() != 1) {
                    throw new IllegalStateException("SslClientCertAuthenticator requires a single SslContextFactory instances.");
                }
                yield new SslClientCertAuthenticator(sslContextFactories.iterator().next());
            }
            default -> null;
        };
    }

    private Authenticator getMultiAuthenticator(Server server, Context context, Authenticator.Configuration configuration) {
        SecurityHandler securityHandler = SecurityHandler.getCurrentSecurityHandler();
        if (securityHandler == null) {
            return null;
        }
        String auth = configuration.getAuthenticationType();
        if ("MULTI".equalsIgnoreCase(auth)) {
            MultiAuthenticator multiAuthenticator = new MultiAuthenticator();
            String authenticatorConfig = configuration.getParameter("org.sparkproject.jetty.security.multi.authenticators");
            for (String config : StringUtil.csvSplit(authenticatorConfig)) {
                Authenticator.Factory factory;
                String[] parts = config.split(":");
                if (parts.length != 2) {
                    throw new IllegalArgumentException();
                }
                final String authType = parts[0].trim();
                String pathSpec = parts[1].trim();
                Authenticator.Configuration.Wrapper authConfig = new Authenticator.Configuration.Wrapper(this, configuration){
                    final /* synthetic */ DefaultAuthenticatorFactory this$0;
                    {
                        this.this$0 = this$0;
                        super(configuration);
                    }

                    @Override
                    public String getAuthenticationType() {
                        return authType;
                    }
                };
                Authenticator authenticator = null;
                List<Authenticator.Factory> authenticatorFactories = securityHandler.getKnownAuthenticatorFactories();
                Iterator<Authenticator.Factory> iterator = authenticatorFactories.iterator();
                while (iterator.hasNext() && (authenticator = (factory = iterator.next()).getAuthenticator(server, context, authConfig)) == null) {
                }
                if (authenticator == null) {
                    throw new IllegalStateException();
                }
                multiAuthenticator.addAuthenticator(pathSpec, authenticator);
            }
            return multiAuthenticator;
        }
        return null;
    }
}

