/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.ServletRequest;
import java.util.concurrent.atomic.AtomicInteger;
import org.sparkproject.jetty.ee10.servlet.ServletContextRequest;
import org.sparkproject.jetty.ee10.servlet.ServletMultiPartFormData;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.server.FormFields;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.Fields;
import org.sparkproject.jetty.util.Promise;
import org.sparkproject.jetty.util.thread.Invocable;

@Deprecated(forRemoval=true, since="12.1.0")
public class EagerFormHandler
extends Handler.Wrapper {
    public EagerFormHandler() {
        this((Handler)null);
    }

    public EagerFormHandler(Handler handler) {
        super(handler);
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (contentType == null) {
            return super.handle(request, response, callback);
        }
        MimeTypes.Type mimeType = MimeTypes.getBaseType(contentType);
        if (mimeType == null) {
            return super.handle(request, response, callback);
        }
        return switch (mimeType) {
            case MimeTypes.Type.FORM_ENCODED -> this.handleFormFields(request, response, callback);
            case MimeTypes.Type.MULTIPART_FORM_DATA -> this.handleMultiPartFormData(request, contentType, response, callback);
            default -> super.handle(request, response, callback);
        };
    }

    protected boolean handleFormFields(final Request request, final Response response, final Callback callback) {
        final Handler handler = this.getHandler();
        final Invocable.InvocationType invocationType = handler.getInvocationType();
        final AtomicInteger done = new AtomicInteger(2);
        var onFields = new Promise.Invocable<Fields>(){
            final /* synthetic */ EagerFormHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void failed(Throwable x) {
                this.succeeded(null);
            }

            @Override
            public void succeeded(Fields result) {
                if (done.decrementAndGet() == 0) {
                    invocationType.runWithoutBlocking(this::handle, request.getContext());
                }
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }

            void handle() {
                try {
                    if (!handler.handle(request, response, callback)) {
                        callback.failed(new IllegalStateException("Not Handled"));
                    }
                }
                catch (Throwable t) {
                    callback.failed(t);
                }
            }
        };
        FormFields.onFields(request, onFields);
        if (done.decrementAndGet() == 0) {
            onFields.handle();
        }
        return true;
    }

    protected boolean handleMultiPartFormData(final Request request, String contentType, final Response response, final Callback callback) {
        final Handler handler = this.getHandler();
        final Invocable.InvocationType invocationType = handler.getInvocationType();
        final AtomicInteger done = new AtomicInteger(2);
        var onParts = new Promise.Invocable<ServletMultiPartFormData.Parts>(){
            final /* synthetic */ EagerFormHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void failed(Throwable x) {
                this.succeeded(null);
            }

            @Override
            public void succeeded(ServletMultiPartFormData.Parts result) {
                if (done.decrementAndGet() == 0) {
                    invocationType.runWithoutBlocking(this::handle, request.getContext());
                }
            }

            void handle() {
                try {
                    if (!handler.handle(request, response, callback)) {
                        callback.failed(new IllegalStateException("Not Handled"));
                    }
                }
                catch (Throwable t) {
                    callback.failed(t);
                }
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }
        };
        ServletMultiPartFormData.onParts((ServletRequest)Request.asInContext(request, ServletContextRequest.class).getServletApiRequest(), contentType, onParts);
        if (done.decrementAndGet() == 0) {
            onParts.handle();
        }
        return true;
    }
}

