/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaFormatter;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.CustomDecimal;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.avro.SchemaConverters;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@DeveloperApi
public final class SchemaConverters$
implements Logging {
    public static final SchemaConverters$ MODULE$ = new SchemaConverters$();
    private static Schema nullSchema;
    private static final String CATALYST_TYPE_PROP_NAME;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        CATALYST_TYPE_PROP_NAME = "spark.sql.catalyst.type";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Schema nullSchema$lzycompute() {
        SchemaConverters$ schemaConverters$ = this;
        synchronized (schemaConverters$) {
            if (!bitmap$0) {
                nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
                bitmap$0 = true;
            }
        }
        return nullSchema;
    }

    private Schema nullSchema() {
        if (!bitmap$0) {
            return this.nullSchema$lzycompute();
        }
        return nullSchema;
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema, boolean useStableIdForUnionType, String stableIdPrefixForUnionType, int recursiveFieldMaxDepth) {
        SchemaConverters.SchemaType schema = this.toSqlTypeHelper(avroSchema, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty(), useStableIdForUnionType, stableIdPrefixForUnionType, recursiveFieldMaxDepth);
        Predef$.MODULE$.assert(schema != null);
        return schema;
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema) {
        return this.toSqlType(avroSchema, false, "", -1);
    }

    public SchemaConverters.SchemaType toSqlType(Schema avroSchema, scala.collection.immutable.Map<String, String> options) {
        AvroOptions avroOptions = AvroOptions$.MODULE$.apply(options);
        return this.toSqlType(avroSchema, avroOptions.useStableIdForUnionType(), avroOptions.stableIdPrefixForUnionType(), avroOptions.recursiveFieldMaxDepth());
    }

    public int toSqlType$default$4() {
        return -1;
    }

    private String CATALYST_TYPE_PROP_NAME() {
        return CATALYST_TYPE_PROP_NAME;
    }

    private SchemaConverters.SchemaType toSqlTypeHelper(Schema avroSchema, scala.collection.immutable.Map<String, Object> existingRecordNames, boolean useStableIdForUnionType, String stableIdPrefixForUnionType, int recursiveFieldMaxDepth) {
        Schema.Type type;
        block29: {
            SeqOps seqOps;
            SeqOps seqOps2;
            Seq seq;
            while (true) {
                SeqOps seqOps3;
                if (Schema.Type.INT.equals(type = avroSchema.getType())) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Date) {
                        return new SchemaConverters.SchemaType((DataType)DateType$.MODULE$, false);
                    }
                    String catalystTypeAttrValue = avroSchema.getProp(this.CATALYST_TYPE_PROP_NAME());
                    IntegerType$ catalystType = catalystTypeAttrValue == null ? IntegerType$.MODULE$ : CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
                    return new SchemaConverters.SchemaType((DataType)catalystType, false);
                }
                if (Schema.Type.STRING.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.BOOLEAN.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)BooleanType$.MODULE$, false);
                }
                if (Schema.Type.BYTES.equals(type) ? true : Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Decimal) {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return new SchemaConverters.SchemaType((DataType)new DecimalType(decimal.getPrecision(), decimal.getScale()), false);
                    }
                    return new SchemaConverters.SchemaType((DataType)BinaryType$.MODULE$, false);
                }
                if (Schema.Type.DOUBLE.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
                if (Schema.Type.FLOAT.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)FloatType$.MODULE$, false);
                }
                if (Schema.Type.LONG.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof CustomDecimal) {
                        CustomDecimal customDecimal = (CustomDecimal)logicalType;
                        return new SchemaConverters.SchemaType((DataType)new DecimalType(customDecimal.precision(), customDecimal.scale()), false);
                    }
                    if (logicalType instanceof LogicalTypes.TimestampMillis ? true : logicalType instanceof LogicalTypes.TimestampMicros) {
                        return new SchemaConverters.SchemaType((DataType)TimestampType$.MODULE$, false);
                    }
                    if (logicalType instanceof LogicalTypes.LocalTimestampMillis ? true : logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                        return new SchemaConverters.SchemaType((DataType)TimestampNTZType$.MODULE$, false);
                    }
                    if (logicalType instanceof LogicalTypes.TimeMicros) {
                        String catalystTypeAttrValue = avroSchema.getProp(this.CATALYST_TYPE_PROP_NAME());
                        TimeType timeType = catalystTypeAttrValue == null ? new TimeType(TimeType$.MODULE$.MICROS_PRECISION()) : (TimeType)CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
                        return new SchemaConverters.SchemaType((DataType)timeType, false);
                    }
                    String catalystTypeAttrValue = avroSchema.getProp(this.CATALYST_TYPE_PROP_NAME());
                    LongType$ catalystType = catalystTypeAttrValue == null ? LongType$.MODULE$ : CatalystSqlParser$.MODULE$.parseDataType(catalystTypeAttrValue);
                    return new SchemaConverters.SchemaType((DataType)catalystType, false);
                }
                if (Schema.Type.ENUM.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.NULL.equals(type)) {
                    return new SchemaConverters.SchemaType((DataType)NullType$.MODULE$, true);
                }
                if (Schema.Type.RECORD.equals(type)) {
                    int recursiveDepth = BoxesRunTime.unboxToInt((Object)existingRecordNames.getOrElse((Object)avroSchema.getFullName(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
                    if (recursiveDepth > 0 && recursiveFieldMaxDepth <= 0) {
                        String formattedAvroSchema = SchemaFormatter.format((String)AvroUtils$.MODULE$.JSON_PRETTY_FORMAT(), (Schema)avroSchema);
                        throw new IncompatibleSchemaException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |Found recursive reference in Avro schema, which can not be processed by Spark by\n            | default: " + formattedAvroSchema + ". Try setting the option `recursiveFieldMaxDepth`\n            | to 1 - " + AvroOptions$.MODULE$.RECURSIVE_FIELD_MAX_DEPTH_LIMIT() + ".\n          ")), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (recursiveDepth > 0 && recursiveDepth >= recursiveFieldMaxDepth) {
                        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The field ", " of type "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_NAME, avroSchema.getFullName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " is dropped at recursive depth "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_TYPE, avroSchema.getType().getName())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.RECURSIVE_DEPTH, BoxesRunTime.boxToInteger((int)recursiveDepth))})))));
                        return null;
                    }
                    scala.collection.immutable.Map newRecordNames = (scala.collection.immutable.Map)existingRecordNames.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)avroSchema.getFullName()), (Object)BoxesRunTime.boxToInteger((int)(recursiveDepth + 1))));
                    Seq fields = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().map((Function1 & Serializable)f -> {
                        SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(f.schema(), (scala.collection.immutable.Map<String, Object>)newRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType, recursiveFieldMaxDepth);
                        if (schemaType == null) {
                            return null;
                        }
                        return new StructField(f.name(), schemaType.dataType(), schemaType.nullable(), StructField$.MODULE$.apply$default$4());
                    })).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$toSqlTypeHelper$4(x$1)))).toSeq();
                    return new SchemaConverters.SchemaType((DataType)StructType$.MODULE$.apply(fields), false);
                }
                if (Schema.Type.ARRAY.equals(type)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getElementType(), existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType, recursiveFieldMaxDepth);
                    if (schemaType == null) {
                        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping ", " of type "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_NAME, avroSchema.getFullName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " as it does not have any "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_TYPE, avroSchema.getType().getName())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fields left likely due to recursive depth limit."}))).log((Seq)Nil$.MODULE$))));
                        return null;
                    }
                    return new SchemaConverters.SchemaType((DataType)new ArrayType(schemaType.dataType(), schemaType.nullable()), false);
                }
                if (Schema.Type.MAP.equals(type)) {
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getValueType(), existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType, recursiveFieldMaxDepth);
                    if (schemaType == null) {
                        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping ", " of type "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_NAME, avroSchema.getFullName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " as it does not have any "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_TYPE, avroSchema.getType().getName())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fields left likely due to recursive depth limit."}))).log((Seq)Nil$.MODULE$))));
                        return null;
                    }
                    return new SchemaConverters.SchemaType((DataType)new MapType((DataType)StringType$.MODULE$, schemaType.dataType(), schemaType.nullable()), false);
                }
                if (!Schema.Type.UNION.equals(type)) break block29;
                if (CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$toSqlTypeHelper$7(x$2)))) {
                    Seq<Schema> remainingUnionTypes = AvroUtils$.MODULE$.nonNullUnionBranches(avroSchema);
                    Schema remainingSchema = remainingUnionTypes.size() == 1 ? (Schema)remainingUnionTypes.head() : Schema.createUnion((List)CollectionConverters$.MODULE$.SeqHasAsJava(remainingUnionTypes).asJava());
                    SchemaConverters.SchemaType schemaType = this.toSqlTypeHelper(remainingSchema, existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType, recursiveFieldMaxDepth);
                    if (schemaType == null) {
                        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping ", " of type "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_NAME, avroSchema.getFullName())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " as it does not have any "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FIELD_TYPE, avroSchema.getType().getName())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fields left likely due to recursive depth limit."}))).log((Seq)Nil$.MODULE$))));
                        return null;
                    }
                    boolean x$12 = true;
                    DataType x$22 = schemaType.copy$default$1();
                    return schemaType.copy(x$22, true);
                }
                seq = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().map((Function1 & Serializable)x$3 -> x$3.getType())).toSeq();
                if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) != 0) break;
                avroSchema = (Schema)avroSchema.getTypes().get(0);
            }
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Schema.Type t1 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Schema.Type t2 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (BoxesRunTime.equals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2})), (Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG})))) {
                    return new SchemaConverters.SchemaType((DataType)LongType$.MODULE$, false);
                }
            }
            if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Schema.Type t1 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Schema.Type t2 = (Schema.Type)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (BoxesRunTime.equals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{t1, t2})), (Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE})))) {
                    return new SchemaConverters.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
            }
            Set fieldNameSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            Seq fields = ((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String string;
                    Schema s = (Schema)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    SchemaConverters.SchemaType schemaType = MODULE$.toSqlTypeHelper(s, existingRecordNames, useStableIdForUnionType, stableIdPrefixForUnionType, recursiveFieldMaxDepth);
                    if (schemaType == null) {
                        return null;
                    }
                    if (useStableIdForUnionType) {
                        String tempFieldName = stableIdPrefixForUnionType + s.getName();
                        if (!fieldNameSet.add((Object)tempFieldName.toLowerCase(Locale.ROOT))) {
                            throw new IncompatibleSchemaException("Cannot generate stable identifier for Avro union type due to name conflict of type name " + s.getName(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                        }
                        string = tempFieldName;
                    } else {
                        string = "member" + i;
                    }
                    String fieldName = string;
                    return new StructField(fieldName, schemaType.dataType(), true, StructField$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)tuple2);
            })).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverters$.$anonfun$toSqlTypeHelper$11(x$4)))).toSeq();
            return new SchemaConverters.SchemaType((DataType)StructType$.MODULE$.apply(fields), false);
        }
        throw new IncompatibleSchemaException("Unsupported type " + type, IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    /*
     * Unable to fully structure code
     */
    public Schema toAvroType(DataType catalystType, boolean nullable, String recordName, String nameSpace) {
        block14: {
            block28: {
                block27: {
                    block25: {
                        block26: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        block17: {
                                                            block16: {
                                                                block15: {
                                                                    block13: {
                                                                        builder = SchemaBuilder.builder();
                                                                        var10_6 = catalystType;
                                                                        if (!BooleanType$.MODULE$.equals(var10_6)) break block13;
                                                                        v0 = (Schema)builder.booleanType();
                                                                        break block14;
                                                                    }
                                                                    if (!(ByteType$.MODULE$.equals(var10_6) != false ? true : (ShortType$.MODULE$.equals(var10_6) != false ? true : IntegerType$.MODULE$.equals(var10_6) != false))) break block15;
                                                                    v0 = (Schema)builder.intType();
                                                                    break block14;
                                                                }
                                                                if (!LongType$.MODULE$.equals(var10_6)) break block16;
                                                                v0 = (Schema)builder.longType();
                                                                break block14;
                                                            }
                                                            if (!DateType$.MODULE$.equals(var10_6)) break block17;
                                                            v0 = LogicalTypes.date().addToSchema((Schema)builder.intType());
                                                            break block14;
                                                        }
                                                        if (!TimestampType$.MODULE$.equals(var10_6)) break block18;
                                                        v0 = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                                                        break block14;
                                                    }
                                                    if (!TimestampNTZType$.MODULE$.equals(var10_6)) break block19;
                                                    v0 = LogicalTypes.localTimestampMicros().addToSchema((Schema)builder.longType());
                                                    break block14;
                                                }
                                                if (!(var10_6 instanceof TimeType)) break block20;
                                                var11_7 = (TimeType)var10_6;
                                                timeSchema = LogicalTypes.timeMicros().addToSchema((Schema)builder.longType());
                                                timeSchema.addProp(this.CATALYST_TYPE_PROP_NAME(), var11_7.typeName());
                                                v0 = timeSchema;
                                                break block14;
                                            }
                                            if (!FloatType$.MODULE$.equals(var10_6)) break block21;
                                            v0 = (Schema)builder.floatType();
                                            break block14;
                                        }
                                        if (!DoubleType$.MODULE$.equals(var10_6)) break block22;
                                        v0 = (Schema)builder.doubleType();
                                        break block14;
                                    }
                                    if (!StringType$.MODULE$.equals(var10_6)) break block23;
                                    v0 = (Schema)builder.stringType();
                                    break block14;
                                }
                                if (!NullType$.MODULE$.equals(var10_6)) break block24;
                                v0 = (Schema)builder.nullType();
                                break block14;
                            }
                            if (!(var10_6 instanceof DecimalType)) break block25;
                            var13_9 = (DecimalType)var10_6;
                            avroType = LogicalTypes.decimal((int)var13_9.precision(), (int)var13_9.scale());
                            fixedSize = Decimal$.MODULE$.minBytesForPrecision()[var13_9.precision()];
                            var17_12 = nameSpace;
                            switch (var17_12 == null ? 0 : var17_12.hashCode()) {
                                case 0: {
                                    if (!"".equals(var17_12)) break;
                                    v1 = recordName + ".fixed";
                                    break block26;
                                }
                            }
                            v1 = nameSpace + "." + recordName + ".fixed";
                        }
                        name = v1;
                        v0 = avroType.addToSchema((Schema)SchemaBuilder.fixed((String)name).size(fixedSize));
                        break block14;
                    }
                    if (!BinaryType$.MODULE$.equals(var10_6)) break block27;
                    v0 = (Schema)builder.bytesType();
                    break block14;
                }
                if (!(var10_6 instanceof ArrayType)) break block28;
                var18_14 = (ArrayType)var10_6;
                et = var18_14.elementType();
                containsNull = var18_14.containsNull();
                v0 = (Schema)builder.array().items(this.toAvroType(et, containsNull, recordName, nameSpace));
                break block14;
            }
            if (!(var10_6 instanceof MapType)) ** GOTO lbl-1000
            var21_17 = (MapType)var10_6;
            var22_18 = var21_17.keyType();
            vt = var21_17.valueType();
            valueContainsNull = var21_17.valueContainsNull();
            if (StringType$.MODULE$.equals(var22_18)) {
                v0 = (Schema)builder.map().values(this.toAvroType(vt, valueContainsNull, recordName, nameSpace));
            } else if (var10_6 instanceof StructType) {
                var25_21 = (StructType)var10_6;
                v2 = nameSpace;
                var27_22 = "";
                childNameSpace = (v2 == null ? var27_22 != null : v2.equals(var27_22) == false) ? nameSpace + "." + recordName : recordName;
                fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(nameSpace)).fields();
                var25_21.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toAvroType$1(java.lang.String org.apache.avro.SchemaBuilder$FieldAssembler org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/avro/SchemaBuilder$FieldAssembler;)((String)childNameSpace, (SchemaBuilder.FieldAssembler)fieldsAssembler));
                v0 = (Schema)fieldsAssembler.endRecord();
            } else if (var10_6 instanceof YearMonthIntervalType) {
                var29_25 = (YearMonthIntervalType)var10_6;
                ymIntervalType = (Schema)builder.intType();
                ymIntervalType.addProp(this.CATALYST_TYPE_PROP_NAME(), var29_25.typeName());
                v0 = ymIntervalType;
            } else if (var10_6 instanceof DayTimeIntervalType) {
                var31_27 = (DayTimeIntervalType)var10_6;
                dtIntervalType = (Schema)builder.longType();
                dtIntervalType.addProp(this.CATALYST_TYPE_PROP_NAME(), var31_27.typeName());
                v0 = dtIntervalType;
            } else {
                throw new IncompatibleSchemaException("Unexpected type " + var10_6 + ".", IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        schema = v0;
        if (nullable) {
            v3 = catalystType;
            var33_30 = NullType$.MODULE$;
            if (v3 == null ? var33_30 != null : v3.equals(var33_30) == false) {
                return Schema.createUnion((Schema[])new Schema[]{schema, this.nullSchema()});
            }
        }
        return schema;
    }

    public boolean toAvroType$default$2() {
        return false;
    }

    public String toAvroType$default$3() {
        return "topLevelRecord";
    }

    public String toAvroType$default$4() {
        return "";
    }

    public Schema toAvroTypeWithDefaults(StructType structType) {
        return this.toAvroTypeWithDefaults((DataType)structType, "topLevelRecord", "", 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Schema toAvroTypeWithDefaults(DataType catalystType, String recordName, String namespace, int nestingLevel) {
        Schema schema;
        SchemaBuilder.TypeBuilder builder = SchemaBuilder.builder();
        DataType dataType = catalystType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            SchemaBuilder.FieldAssembler fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(namespace)).fields();
            SchemaConverters$.processStructFields$1(structType, fieldsAssembler, namespace, nestingLevel);
            Schema recordSchema = (Schema)fieldsAssembler.endRecord();
            schema = nestingLevel > 0 ? Schema.createUnion((Schema[])new Schema[]{this.nullSchema(), recordSchema}) : recordSchema;
            return schema;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            schema = (Schema)builder.booleanType();
            return schema;
        } else if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : IntegerType$.MODULE$.equals(dataType))) {
            schema = (Schema)builder.intType();
            return schema;
        } else if (LongType$.MODULE$.equals(dataType)) {
            schema = (Schema)builder.longType();
            return schema;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            schema = (Schema)builder.floatType();
            return schema;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            schema = (Schema)builder.doubleType();
            return schema;
        } else if (StringType$.MODULE$.equals(dataType)) {
            schema = (Schema)builder.stringType();
            return schema;
        } else if (NullType$.MODULE$.equals(dataType)) {
            schema = (Schema)builder.nullType();
            return schema;
        } else if (DateType$.MODULE$.equals(dataType)) {
            schema = LogicalTypes.date().addToSchema((Schema)builder.intType());
            return schema;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            schema = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
            return schema;
        } else if (TimestampNTZType$.MODULE$.equals(dataType)) {
            schema = LogicalTypes.localTimestampMicros().addToSchema((Schema)builder.longType());
            return schema;
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            LogicalTypes.Decimal avroType = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
            int fixedSize = Decimal$.MODULE$.minBytesForPrecision()[decimalType.precision()];
            String name = namespace.isEmpty() ? recordName + ".fixed" : namespace + "." + recordName + ".fixed";
            schema = avroType.addToSchema((Schema)SchemaBuilder.fixed((String)name).size(fixedSize));
            return schema;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            schema = (Schema)builder.bytesType();
            return schema;
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            Schema arraySchema = (Schema)builder.array().items(this.toAvroTypeWithDefaults(elementType, recordName, namespace, nestingLevel + 1));
            schema = Schema.createUnion((Schema[])new Schema[]{this.nullSchema(), arraySchema});
            return schema;
        } else {
            if (!(dataType instanceof MapType)) throw new IncompatibleSchemaException("Unexpected type " + dataType + ".", IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            MapType mapType = (MapType)dataType;
            DataType dataType2 = mapType.keyType();
            DataType valueType = mapType.valueType();
            if (!StringType$.MODULE$.equals(dataType2)) throw new IncompatibleSchemaException("Unexpected type " + dataType + ".", IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            Schema mapSchema = (Schema)builder.map().values(this.toAvroTypeWithDefaults(valueType, recordName, namespace, nestingLevel + 1));
            schema = Schema.createUnion((Schema[])new Schema[]{this.nullSchema(), mapSchema});
        }
        return schema;
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$4(StructField x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$7(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$11(StructField x$4) {
        return x$4 != null;
    }

    public static final /* synthetic */ SchemaBuilder.FieldAssembler $anonfun$toAvroType$1(String childNameSpace$1, SchemaBuilder.FieldAssembler fieldsAssembler$1, StructField f) {
        Schema fieldAvroType = MODULE$.toAvroType(f.dataType(), f.nullable(), f.name(), childNameSpace$1);
        return fieldsAssembler$1.name(f.name()).type(fieldAvroType).noDefault();
    }

    private static final void processStructFields$1(StructType st, SchemaBuilder.FieldAssembler fieldsAssembler, String namespace$1, int nestingLevel$1) {
        st.foreach((Function1 & Serializable)field -> {
            Schema innerType = MODULE$.toAvroTypeWithDefaults(field.dataType(), field.name(), namespace$1, nestingLevel$1 + 1);
            DataType dataType = field.dataType();
            NullType$ nullType$ = NullType$.MODULE$;
            Schema fieldType = (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) && !innerType.getType().equals((Object)Schema.Type.UNION) ? Schema.createUnion((Schema[])new Schema[]{MODULE$.nullSchema(), innerType}) : innerType;
            return fieldsAssembler.name(field.name()).type(fieldType).withDefault(null);
        });
    }

    private SchemaConverters$() {
    }
}

