/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.state.AllColumnFamiliesReaderInfo;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSource$;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreReaderInfo;
import org.apache.spark.sql.execution.datasources.v2.state.StateTable;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataTableEntry;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataBase;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorsUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManager$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateStoreColumnFamilySchemaUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateVariableType$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.timers.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.InMemoryStateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionErrors$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\n\u0014\u0001\u0011BQ!\u0011\u0001\u0005\u0002\tC\u0001\"\u0012\u0001\t\u0006\u0004%IA\u0012\u0005\t\u0017\u0002A)\u0019!C\u0005\u0019\")Q\u000b\u0001C!-\")A\r\u0001C!K\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!a\u001a\u0001\t\u0013\tI\u0007C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\u001e9\u0011\u0011T\n\t\u0002\u0005meA\u0002\n\u0014\u0011\u0003\ti\n\u0003\u0004B\u001d\u0011\u0005\u0011Q\u0015\u0005\b\u0003OsA\u0011BAU\u0011\u001d\t\tL\u0004C\u0001\u0003g\u0013qb\u0015;bi\u0016$\u0015\r^1T_V\u00148-\u001a\u0006\u0003)U\tQa\u001d;bi\u0016T!AF\f\u0002\u0005Y\u0014$B\u0001\r\u001a\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005iY\u0012!C3yK\u000e,H/[8o\u0015\taR$A\u0002tc2T!AH\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0002\u0001'\u0015\u0001Q%L\u001b<!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003mC:<'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u0012aa\u00142kK\u000e$\bC\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u001d\u0019\u0017\r^1m_\u001eT!AM\u000e\u0002\u0013\r|gN\\3di>\u0014\u0018B\u0001\u001b0\u00055!\u0016M\u00197f!J|g/\u001b3feB\u0011a'O\u0007\u0002o)\u0011\u0001hG\u0001\bg>,(oY3t\u0013\tQtG\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u001e\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001!>\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\"\u0011\u0005\u0011\u0003Q\"A\n\u0002\u000fM,7o]5p]V\tq\t\u0005\u0002I\u00136\t1$\u0003\u0002K7\ta1\u000b]1sWN+7o]5p]\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\t\r|gN\u001a\u0006\u0003%~\ta\u0001[1e_>\u0004\u0018B\u0001+P\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006I1\u000f[8si:\u000bW.\u001a\u000b\u0002/B\u0011\u0001,\u0019\b\u00033~\u0003\"AW/\u000e\u0003mS!\u0001X\u0012\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001l\u0016\u0001C4fiR\u000b'\r\\3\u0015\t\u0019L\u0017/ \t\u0003]\u001dL!\u0001[\u0018\u0003\u000bQ\u000b'\r\\3\t\u000b),\u0001\u0019A6\u0002\rM\u001c\u0007.Z7b!\taw.D\u0001n\u0015\tq7$A\u0003usB,7/\u0003\u0002q[\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bI,\u0001\u0019A:\u0002\u0019A\f'\u000f^5uS>t\u0017N\\4\u0011\u0007Q,x/D\u0001^\u0013\t1XLA\u0003BeJ\f\u0017\u0010\u0005\u0002yw6\t\u0011P\u0003\u0002{c\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\ta\u0018PA\u0005Ue\u0006t7OZ8s[\")a0\u0002a\u0001\u007f\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\r\u0005\u0005\u0011qA,X\u001b\t\t\u0019AC\u0002\u0002\u0006%\nA!\u001e;jY&!\u0011\u0011BA\u0002\u0005\ri\u0015\r]\u0001\fS:4WM]*dQ\u0016l\u0017\rF\u0002l\u0003\u001fAq!!\u0005\u0007\u0001\u0004\t\u0019\"A\u0004paRLwN\\:\u0011\t\u0005U\u0011\u0011D\u0007\u0003\u0003/Q1!!\u0002\u001c\u0013\u0011\tY\"a\u0006\u00031\r\u000b7/Z%og\u0016t7/\u001b;jm\u0016\u001cFO]5oO6\u000b\u0007/\u0001\rtkB\u0004xN\u001d;t\u000bb$XM\u001d8bY6+G/\u00193bi\u0006$\"!!\t\u0011\u0007Q\f\u0019#C\u0002\u0002&u\u0013qAQ8pY\u0016\fg.\u0001\u000fjgJ+\u0017\rZ!mY\u000e{GNR1nS2LWm](o\u0015>LgNV\u001a\u0015\r\u0005\u0005\u00121FA\u001b\u0011\u001d\ti\u0003\u0003a\u0001\u0003_\tQb]8ve\u000e,w\n\u001d;j_:\u001c\bc\u0001#\u00022%\u0019\u00111G\n\u0003%M#\u0018\r^3T_V\u00148-Z(qi&|gn\u001d\u0005\b\u0003oA\u0001\u0019AA\u001d\u00035\u0019Ho\u001c:f\u001b\u0016$\u0018\rZ1uCB!A/^A\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!'\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002F\u0005}\"aF*uCR,W*\u001a;bI\u0006$\u0018\rV1cY\u0016,e\u000e\u001e:z\u0003M\u0011W/\u001b7e'R\fG/Z*u_J,7i\u001c8g)\u0019\tY%!\u0017\u0002^A!\u0011QJA+\u001b\t\tyEC\u0002\u0015\u0003#R1!a\u0015\u001a\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002X\u0005=#AD*uCR,7\u000b^8sK\u000e{gN\u001a\u0005\u0007\u00037J\u0001\u0019A,\u0002%\rDWmY6q_&tG\u000fT8dCRLwN\u001c\u0005\b\u0003?J\u0001\u0019AA1\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\u00042\u0001^A2\u0013\r\t)'\u0018\u0002\u0005\u0019>tw-A\tsk:\u001cF/\u0019;f-\u0006\u00148\t[3dWN$b!a\u001b\u0002r\u0005M\u0004c\u0001;\u0002n%\u0019\u0011qN/\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003[Q\u0001\u0019AA\u0018\u0011\u001d\t)H\u0003a\u0001\u0003s\t!c\u001d;bi\u0016\u001cFo\u001c:f\u001b\u0016$\u0018\rZ1uC\u0006ar-\u001a;Ti>\u0014X-T3uC\u0012\fG/Y!oIJ+hn\u00115fG.\u001cH\u0003BA>\u0003\u0003\u00032\u0001RA?\u0013\r\tyh\u0005\u0002\u0015'R\fG/Z*u_J,'+Z1eKJLeNZ8\t\u000f\u000552\u00021\u0001\u00020\u00051r-\u001a;LKf\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s'B,7\r\u0006\u0004\u0002\b\u00065\u0015q\u0013\t\u0005\u0003\u001b\nI)\u0003\u0003\u0002\f\u0006=#aE&fsN#\u0018\r^3F]\u000e|G-\u001a:Ta\u0016\u001c\u0007bBAH\u0019\u0001\u0007\u0011\u0011S\u0001\u0010G>dg)Y7jYf\u001c6\r[3nCB!\u0011QJAJ\u0013\u0011\t)*a\u0014\u00033M#\u0018\r^3Ti>\u0014XmQ8m\r\u0006l\u0017\u000e\\=TG\",W.\u0019\u0005\b\u0003oa\u0001\u0019AA\u001d\u0003=\u0019F/\u0019;f\t\u0006$\u0018mU8ve\u000e,\u0007C\u0001#\u000f'\rq\u0011q\u0014\t\u0004i\u0006\u0005\u0016bAAR;\n1\u0011I\\=SK\u001a$\"!a'\u0002+\u001d,Go\u0015;bi\u0016\u001cFo\u001c:f\u001b\u0016$\u0018\rZ1uCR1\u0011\u0011HAV\u0003_Cq!!,\u0011\u0001\u0004\ty#\u0001\nti\u0006$XmU8ve\u000e,w\n\u001d;j_:\u001c\b\"B&\u0011\u0001\u0004i\u0015!F4fi>cGmU2iK6\fg)\u001b7f!\u0006$\bn\u001d\u000b\u0007\u0003k\u000b\u0019.!6\u0011\r\u0005]\u0016\u0011YAd\u001d\u0011\tI,!0\u000f\u0007i\u000bY,C\u0001_\u0013\r\ty,X\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019-!2\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u007fk\u0006\u0003BAe\u0003\u001fl!!a3\u000b\u0007\u00055\u0017+\u0001\u0002gg&!\u0011\u0011[Af\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u00055\u0016\u00031\u0001\u00020!)1*\u0005a\u0001\u001b\u0002")
public class StateDataSource
implements TableProvider,
DataSourceRegister,
Logging {
    private SparkSession session;
    private Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static List<Path> getOldSchemaFilePaths(StateSourceOptions stateSourceOptions, Configuration hadoopConf) {
        return StateDataSource$.MODULE$.getOldSchemaFilePaths(stateSourceOptions, hadoopConf);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap x$1) {
        return super.inferPartitioning(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession session$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.session = SparkSession$.MODULE$.active();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.session;
    }

    private SparkSession session() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    private Configuration hadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopConf = this.session().sessionState().newHadoopConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hadoopConf;
    }

    private Configuration hadoopConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hadoopConf$lzycompute();
        }
        return this.hadoopConf;
    }

    @Override
    public String shortName() {
        return "statestore";
    }

    public Table getTable(StructType schema, Transform[] partitioning2, Map<String, String> properties) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        StateStoreReaderInfo stateStoreReaderInfo;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.modifySourceOptions(this.hadoopConf(), StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), properties));
        StateStoreConf stateConf = this.buildStateStoreConf(sourceOptions.resolvedCpLocation(), sourceOptions.batchId());
        if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
            String string = stateConf.providerClass();
            String string2 = RocksDBStateStoreProvider.class.getName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw OfflineStateRepartitionErrors$.MODULE$.unsupportedStateStoreProviderError(sourceOptions.resolvedCpLocation(), stateConf.providerClass());
            }
        }
        if ((stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions)).keyStateEncoderSpecOpt().isDefined()) {
            keyStateEncoderSpec = (KeyStateEncoderSpec)stateStoreReaderInfo.keyStateEncoderSpecOpt().get();
        } else {
            StructType keySchema = (StructType)SchemaUtil$.MODULE$.getSchemaAsDataType(schema, "key");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(keySchema);
        }
        KeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return new StateTable(this.session(), schema, sourceOptions, stateConf, keyStateEncoderSpec2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt(), stateStoreReaderInfo.stateSchemaProviderOpt(), stateStoreReaderInfo.joinColFamilyOpt(), (Option<AllColumnFamiliesReaderInfo>)Option$.MODULE$.apply((Object)stateStoreReaderInfo.allColumnFamiliesReaderInfo()));
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        StructType structType;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.modifySourceOptions(this.hadoopConf(), StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), options));
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        List<Path> oldSchemaFilePaths = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
        Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
        try {
            Tuple2 tuple2;
            Enumeration.Value value = sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, oldSchemaFilePaths, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$6());
            } else {
                Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, oldSchemaFilePaths, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$6());
                } else {
                    Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Predef$.MODULE$.require(stateStoreReaderInfo.stateStoreColFamilySchemaOpt().isDefined());
                        StateStoreColFamilySchema resultSchema = (StateStoreColFamilySchema)stateStoreReaderInfo.stateStoreColFamilySchemaOpt().get();
                        tuple2 = new Tuple2((Object)resultSchema.keySchema(), (Object)resultSchema.valueSchema());
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            StructType keySchema = (StructType)tuple22._1();
            StructType valueSchema = (StructType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)keySchema, (Object)valueSchema);
            StructType keySchema2 = (StructType)tuple23._1();
            StructType valueSchema2 = (StructType)tuple23._2();
            structType = SchemaUtil$.MODULE$.getSourceSchema(sourceOptions, keySchema2, valueSchema2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
            }
            throw throwable;
        }
        return structType;
    }

    public boolean supportsExternalMetadata() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isReadAllColFamiliesOnJoinV3(StateSourceOptions sourceOptions, StateMetadataTableEntry[] storeMetadata) {
        if (!sourceOptions.internalOnlyReadAllColumnFamilies()) return false;
        String string = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
        String string2 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!StreamStreamJoinStateHelper$.MODULE$.usesVirtualColumnFamilies(this.hadoopConf(), sourceOptions.stateCheckpointLocation().toString(), sourceOptions.operatorId())) return false;
        return true;
    }

    private StateStoreConf buildStateStoreConf(String checkpointLocation, long batchId) {
        OffsetSeqLog offsetLog = new StreamingQueryCheckpointMetadata(this.session(), checkpointLocation).offsetLog();
        Option option = offsetLog.get(batchId);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetSeqBase value = (OffsetSeqBase)some.value();
            OffsetSeqMetadataBase metadata = (OffsetSeqMetadataBase)value.metadataOpt().getOrElse((Function0 & Serializable)() -> {
                throw StateDataSourceErrors$.MODULE$.offsetMetadataLogUnavailable(batchId, checkpointLocation);
            });
            SQLConf clonedSqlConf = this.session().sessionState().conf().clone();
            OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, clonedSqlConf);
            return StateStoreConf$.MODULE$.apply(clonedSqlConf);
        }
        throw StateDataSourceErrors$.MODULE$.offsetLogUnavailable(batchId, checkpointLocation);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runStateVarChecks(StateSourceOptions sourceOptions, StateMetadataTableEntry[] stateStoreMetadata) {
        Option<String> option = sourceOptions.stateVarName();
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
            StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
            String string = opMetadata.operatorName();
            if (string != null) {
                String string2;
                String string3 = string2 = string;
                String string4 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    Seq<String> possibleStoreNames = SymmetricHashJoinStateManager$.MODULE$.allStateStoreNames((Seq<StreamingSymmetricHashJoinHelper.JoinSide>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamingSymmetricHashJoinHelper.JoinSide[]{StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, StreamingSymmetricHashJoinHelper$RightSide$.MODULE$}));
                    if (possibleStoreNames.contains((Object)name)) return;
                    String errorMsg = "Store name " + name + " not allowed for join operator. Allowed names are " + possibleStoreNames + ". Please remove this option and re-run the query.";
                    throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STORE_NAME(), errorMsg);
                }
            }
            if (string != null) {
                String string5 = string;
                if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)string5)) {
                    StateDataSource.runTWSChecks$1(opMetadata, sourceOptions);
                    return;
                }
            }
            String errorMsg = "Providing state variable names is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), errorMsg);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (!sourceOptions.readRegisteredTimers()) {
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) != 1) return;
            if (!StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata))).operatorName())) return;
            throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified("stateVarName");
        }
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
        StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
        String string = opMetadata.operatorName();
        if (string != null) {
            String string6 = string;
            if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)string6)) {
                StateDataSource.runTWSChecks$1(opMetadata, sourceOptions);
                return;
            }
        }
        String errorMsg = "Providing readRegisteredTimers=true is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
        throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.READ_REGISTERED_TIMERS(), errorMsg);
    }

    private StateStoreReaderInfo getStoreMetadataAndRunChecks(StateSourceOptions sourceOptions) {
        StateMetadataTableEntry[] storeMetadata = StateDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$v2$state$StateDataSource$$getStateStoreMetadata(sourceOptions, this.hadoopConf());
        if (!sourceOptions.internalOnlyReadAllColumnFamilies()) {
            this.runStateVarChecks(sourceOptions, storeMetadata);
        }
        None$ keyStateEncoderSpecOpt = None$.MODULE$;
        None$ stateStoreColFamilySchemaOpt = None$.MODULE$;
        None$ transformWithStateVariableInfoOpt = None$.MODULE$;
        None$ stateSchemaProvider = None$.MODULE$;
        None$ joinColFamilyOpt = None$.MODULE$;
        String timeMode = TimeMode.None().toString();
        Set stateStoreColFamilySchemas = Predef$.MODULE$.Set().empty();
        List<TransformWithStateVariableInfo> stateVariableInfos = package$.MODULE$.List().empty();
        Enumeration.Value value = sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            List list;
            ObjectRef stateVarName = ObjectRef.create((Object)((String)sourceOptions.stateVarName().getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME())));
            if (storeMetadata.length > 0 && ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).version() == 2) {
                String opName = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
                if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)opName.contains(x$1)))) {
                    StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
                    TransformWithStateOperatorProperties operatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(storeMetadataEntry.operatorPropertiesJson());
                    timeMode = operatorProperties.timeMode();
                    if (sourceOptions.readRegisteredTimers()) {
                        stateVarName.elem = (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1();
                    }
                    if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
                        stateVariableInfos = operatorProperties.stateVariables();
                    } else {
                        List stateVarInfoList = operatorProperties.stateVariables().filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$3(stateVarName, stateVar)));
                        if (stateVarInfoList.isEmpty() && StateStoreColumnFamilySchemaUtils$.MODULE$.isTestingInternalColFamily((String)stateVarName.elem)) {
                            stateVarInfoList = new .colon.colon((Object)new TransformWithStateVariableInfo((String)stateVarName.elem, StateVariableType$.MODULE$.ValueState(), false), (List)Nil$.MODULE$);
                        }
                        Predef$.MODULE$.require(stateVarInfoList.size() == 1, (Function0 & Serializable)() -> "Failed to find unique state variable info for state variable " + (String)stateVarName$2.elem + " in operator " + sourceOptions.operatorId());
                        TransformWithStateVariableInfo stateVarInfo = (TransformWithStateVariableInfo)stateVarInfoList.head();
                        transformWithStateVariableInfoOpt = new Some((Object)stateVarInfo);
                    }
                    List<String> schemaFilePaths = storeMetadataEntry.stateSchemaFilePaths();
                    StateSchemaMetadata stateSchemaMetadata = StateSchemaMetadata$.MODULE$.createStateSchemaMetadata(sourceOptions.stateCheckpointLocation().toString(), this.hadoopConf(), schemaFilePaths);
                    stateSchemaProvider = new Some((Object)new InMemoryStateSchemaProvider(stateSchemaMetadata));
                    list = schemaFilePaths.map((Function1 & Serializable)x$2 -> new Path(x$2));
                } else {
                    String string = opName;
                    String string2 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        joinColFamilyOpt = new Some((Object)((String)stateVarName.elem));
                    }
                    list = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
                }
            } else {
                list = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
            }
            List oldSchemaFilePaths = list;
            try {
                int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
                Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
                StateStoreId storeId = new StateStoreId(stateCheckpointLocation.toString(), sourceOptions.operatorId(), partitionId, sourceOptions.storeName());
                StateStoreProviderId providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
                StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerId, this.hadoopConf(), oldSchemaFilePaths, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
                List<StateStoreColFamilySchema> stateSchema = manager.readSchemaFile();
                if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
                    stateStoreColFamilySchemas = stateSchema.toSet();
                }
                StateStoreColFamilySchema resultSchema = this.isReadAllColFamiliesOnJoinV3(sourceOptions, storeMetadata) ? (StateStoreColFamilySchema)stateSchema.head() : (StateStoreColFamilySchema)stateSchema.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$6(stateVarName, x$3))).head();
                keyStateEncoderSpecOpt = new Some((Object)this.getKeyStateEncoderSpec(resultSchema, storeMetadata));
                stateStoreColFamilySchemaOpt = new Some((Object)resultSchema);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
                }
                throw throwable;
            }
        }
        return new StateStoreReaderInfo((Option<KeyStateEncoderSpec>)keyStateEncoderSpecOpt, (Option<StateStoreColFamilySchema>)stateStoreColFamilySchemaOpt, (Option<TransformWithStateVariableInfo>)transformWithStateVariableInfoOpt, (Option<StateSchemaProvider>)stateSchemaProvider, (Option<String>)joinColFamilyOpt, new AllColumnFamiliesReaderInfo((Set<StateStoreColFamilySchema>)stateStoreColFamilySchemas, stateVariableInfos));
    }

    private KeyStateEncoderSpec getKeyStateEncoderSpec(StateStoreColFamilySchema colFamilySchema, StateMetadataTableEntry[] storeMetadata) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        if (storeMetadata.length == 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Metadata for state store not found, possible cause is this checkpoint is created by older version of spark. If the query has session window aggregation, the state can't be read correctly and runtime exception will be thrown. Run the streaming query in newer spark version to generate state metadata can fix the issue.");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
        } else {
            Predef$.MODULE$.require(storeMetadata.length == 1);
            StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
            if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() == 0) {
                keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
            } else if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() > 0) {
                keyStateEncoderSpec = new PrefixKeyScanStateEncoderSpec(colFamilySchema.keySchema(), storeMetadataEntry.numColsPrefixKey());
            } else if (storeMetadataEntry.version() == 2) {
                Predef$.MODULE$.require(colFamilySchema.keyStateEncoderSpec().isDefined());
                keyStateEncoderSpec = (KeyStateEncoderSpec)colFamilySchema.keyStateEncoderSpec().get();
            } else {
                throw StateDataSourceErrors$.MODULE$.internalError("Failed to read key state encoder spec for operator=" + storeMetadataEntry.operatorId());
            }
        }
        NoPrefixKeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return keyStateEncoderSpec2;
    }

    public static final /* synthetic */ boolean $anonfun$runStateVarChecks$1(String stateVarName$1, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = stateVarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final void runTWSChecks$1(StateMetadataTableEntry opMetadata, StateSourceOptions sourceOptions$1) {
        String operatorProperties = opMetadata.operatorPropertiesJson();
        if (operatorProperties.isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "No state variable names are defined for the transformWithState operator");
        }
        TransformWithStateOperatorProperties twsOperatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(operatorProperties);
        String timeMode = twsOperatorProperties.timeMode();
        if (sourceOptions$1.readRegisteredTimers()) {
            String string = timeMode;
            String string2 = TimeMode.None().toString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.READ_REGISTERED_TIMERS(), "Registered timers are not available in TimeMode=None.");
            }
        }
        String stateVarName = sourceOptions$1.readRegisteredTimers() ? (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1() : (String)sourceOptions$1.stateVarName().get();
        List<TransformWithStateVariableInfo> stateVars = twsOperatorProperties.stateVariables();
        List stateVarInfo = stateVars.filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$runStateVarChecks$1(stateVarName, stateVar)));
        if (stateVarInfo.size() != 1 && !StateStoreColumnFamilySchemaUtils$.MODULE$.isTestingInternalColFamily(stateVarName)) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "State variable " + stateVarName + " is not defined for the transformWithState operator.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$3(ObjectRef stateVarName$2, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$6(ObjectRef stateVarName$2, StateStoreColFamilySchema x$3) {
        String string = x$3.colFamilyName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public StateDataSource() {
        Logging.$init$((Logging)this);
    }
}

