/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.segmenter;

import com.ibm.icu.segmenter.BoundarySpliterator;
import com.ibm.icu.segmenter.Segment;
import com.ibm.icu.segmenter.SegmentIterable;
import com.ibm.icu.segmenter.Segments;
import com.ibm.icu.text.BreakIterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class SegmentsImpl
implements Segments {
    private CharSequence source;
    private BreakIterator breakIterPrototype;

    SegmentsImpl(BreakIterator breakIter, CharSequence source) {
        this.source = source;
        this.breakIterPrototype = breakIter.clone();
        this.breakIterPrototype.setText(source);
    }

    @Override
    public Segment segmentAt(int i) {
        int limit;
        int start;
        BreakIterator breakIter = this.breakIterPrototype.clone();
        if (i < 0 || i >= this.source.length()) {
            throw new IndexOutOfBoundsException(i);
        }
        boolean isBoundary = breakIter.isBoundary(i);
        if (isBoundary) {
            start = i;
            limit = breakIter.next();
        } else {
            limit = breakIter.current();
            start = breakIter.previous();
        }
        assert (start != -1 && limit != -1);
        return new Segment(start, limit, this.source);
    }

    @Override
    public boolean isBoundary(int i) {
        return this.breakIterPrototype.clone().isBoundary(i);
    }

    @Override
    public Stream<Segment> segmentsFrom(int i) {
        BreakIterator breakIter = this.breakIterPrototype.clone();
        SegmentIterable iterable = new SegmentIterable(breakIter, Segments.IterationDirection.FORWARDS, i, this.source);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Override
    public Stream<Segment> segmentsBefore(int i) {
        BreakIterator breakIter = this.breakIterPrototype.clone();
        SegmentIterable iterable = new SegmentIterable(breakIter, Segments.IterationDirection.BACKWARDS, i, this.source);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Override
    public IntStream boundariesAfter(int i) {
        BreakIterator breakIter = this.breakIterPrototype.clone();
        return StreamSupport.intStream(new BoundarySpliterator(breakIter, this.source, Segments.IterationDirection.FORWARDS, i), false);
    }

    @Override
    public IntStream boundariesBackFrom(int i) {
        BreakIterator breakIter = this.breakIterPrototype.clone();
        return StreamSupport.intStream(new BoundarySpliterator(breakIter, this.source, Segments.IterationDirection.BACKWARDS, i), false);
    }
}

