/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ConvertTimezone$;
import org.apache.spark.sql.catalyst.expressions.CurrentTimeZone;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([sourceTz, ]targetTz, sourceTs) - Converts the timestamp without time zone `sourceTs` from the `sourceTz` time zone to `targetTz`. ", arguments="\n    Arguments:\n      * sourceTz - the time zone for the input timestamp.\n                   If it is missed, the current session time zone is used as the source time zone.\n      * targetTz - the time zone to which the input timestamp should be converted\n      * sourceTs - a timestamp without time zone\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Europe/Brussels', 'America/Los_Angeles', timestamp_ntz'2021-12-06 00:00:00');\n       2021-12-05 15:00:00\n      > SELECT _FUNC_('Europe/Brussels', timestamp_ntz'2021-12-05 15:00:00');\n       2021-12-06 00:00:00\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001B\u0013'\u0001NB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011!)\u0006A!f\u0001\n\u0003q\u0005\u0002\u0003,\u0001\u0005#\u0005\u000b\u0011B(\t\u000b]\u0003A\u0011\u0001-\t\u000bu\u0003A\u0011\t0\t\u000b]\u0003A\u0011\u00012\t\u000b\u0015\u0004A\u0011\t(\t\u000b\u0019\u0004A\u0011\t(\t\u000b\u001d\u0004A\u0011\t(\t\u000b!\u0004A\u0011I5\t\u000bM\u0004A\u0011\t;\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0002bBA\u001d\u0001\u0011E\u00131\b\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"a\u0015\u0001#\u0003%\t!!\u0016\t\u0013\u0005-\u0004!%A\u0005\u0002\u0005U\u0003\"CA7\u0001E\u0005I\u0011AA+\u0011%\ty\u0007AA\u0001\n\u0003\n\t\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0001\u0002\u0004\"I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003'\u0003\u0011\u0011!C!\u0003+C\u0011\"a)\u0001\u0003\u0003%\t!!*\t\u0013\u0005%\u0006!!A\u0005B\u0005-\u0006\"CAX\u0001\u0005\u0005I\u0011IAY\u000f%\tYNJA\u0001\u0012\u0003\tiN\u0002\u0005&M\u0005\u0005\t\u0012AAp\u0011\u00199v\u0004\"\u0001\u0002x\"I\u0011\u0011`\u0010\u0002\u0002\u0013\u0015\u00131 \u0005\n\u0003{|\u0012\u0011!CA\u0003\u007fD\u0011Ba\u0002 \u0003\u0003%\tI!\u0003\t\u0013\tmq$!A\u0005\n\tu!aD\"p]Z,'\u000f\u001e+j[\u0016TxN\\3\u000b\u0005\u001dB\u0013aC3yaJ,7o]5p]NT!!\u000b\u0016\u0002\u0011\r\fG/\u00197zgRT!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u001b9w\u0005\u0003\"!\u000e\u001c\u000e\u0003\u0019J!a\u000e\u0014\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00026s%\u0011!H\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\"K\u001d\t\u0019\u0005J\u0004\u0002E\u000f6\tQI\u0003\u0002Ge\u00051AH]8pizJ\u0011AP\u0005\u0003\u0013v\nq\u0001]1dW\u0006<W-\u0003\u0002L\u0019\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011*P\u0001\tg>,(oY3UuV\tq\n\u0005\u00026!&\u0011\u0011K\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!C:pkJ\u001cW\r\u0016>!\u0003!!\u0018M]4fiRS\u0018!\u0003;be\u001e,G\u000f\u0016>!\u0003!\u0019x.\u001e:dKR\u001b\u0018!C:pkJ\u001cW\rV:!\u0003\u0019a\u0014N\\5u}Q!\u0011LW.]!\t)\u0004\u0001C\u0003N\u000f\u0001\u0007q\nC\u0003T\u000f\u0001\u0007q\nC\u0003V\u000f\u0001\u0007q*\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u0003}\u0003\"\u0001\u00101\n\u0005\u0005l$a\u0002\"p_2,\u0017M\u001c\u000b\u00043\u000e$\u0007\"B*\n\u0001\u0004y\u0005\"B+\n\u0001\u0004y\u0015!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001b\t\u0004\u0005.l\u0017B\u00017M\u0005\r\u0019V-\u001d\t\u0003]Fl\u0011a\u001c\u0006\u0003a*\nQ\u0001^=qKNL!A]8\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003U\u0004\"A\u001c<\n\u0005]|'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u000bilx0a\u0001\u0011\u0005qZ\u0018B\u0001?>\u0005\r\te.\u001f\u0005\u0006}>\u0001\rA_\u0001\u0006gJ\u001cGK\u001f\u0005\u0007\u0003\u0003y\u0001\u0019\u0001>\u0002\u000bQ<G\u000f\u0016>\t\r\u0005\u0015q\u00021\u0001{\u0003\u0019i\u0017n\u0019:pg\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0017\t9\"!\t\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005'\u0003\u001d\u0019w\u000eZ3hK:LA!!\u0006\u0002\u0010\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\u001aA\u0001\r!a\u0007\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u000e\u0005u\u0011\u0002BA\u0010\u0003\u001f\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002$A\u0001\r!a\u0003\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\u0019D\u0004\u0003\u0002.\u0005=\u0002C\u0001#>\u0013\r\t\t$P\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ER(A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9\u0011,!\u0010\u0002B\u0005\u0015\u0003BBA %\u0001\u0007q*\u0001\u0005oK^4\u0015N]:u\u0011\u0019\t\u0019E\u0005a\u0001\u001f\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003\u000f\u0012\u0002\u0019A(\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9\u0011,!\u0014\u0002P\u0005E\u0003bB'\u0014!\u0003\u0005\ra\u0014\u0005\b'N\u0001\n\u00111\u0001P\u0011\u001d)6\u0003%AA\u0002=\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002X)\u001aq*!\u0017,\u0005\u0005m\u0003\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001a>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\nyFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\nAA[1wC&!\u0011QGA<\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\tE\u0002=\u0003\u000fK1!!#>\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rQ\u0018q\u0012\u0005\n\u0003#K\u0012\u0011!a\u0001\u0003\u000b\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAL!\u0015\tI*a({\u001b\t\tYJC\u0002\u0002\u001ev\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t+a'\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004?\u0006\u001d\u0006\u0002CAI7\u0005\u0005\t\u0019\u0001>\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003g\ni\u000bC\u0005\u0002\u0012r\t\t\u00111\u0001\u0002\u0006\u00061Q-];bYN$2aXAZ\u0011!\t\t*HA\u0001\u0002\u0004Q\bf\u0006\u0001\u00028\u0006u\u0016qXAb\u0003\u000b\fI-a3\u0002P\u0006E\u0017Q[Al!\r)\u0014\u0011X\u0005\u0004\u0003w3#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0003\f\u0011QC0G+:\u001bu\fK.t_V\u00148-\u001a+{Y\u0001jF/\u0019:hKR$&\u0010\f\u0011t_V\u00148-\u001a+tS\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011uQ\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011xSRDw.\u001e;!i&lW\r\t>p]\u0016\u0004\u0003m]8ve\u000e,Gk\u001d1!MJ|W\u000e\t;iK\u0002\u00027o\\;sG\u0016$&\u0010\u0019\u0011uS6,\u0007E_8oK\u0002\"x\u000e\t1uCJ<W\r\u001e+{A:\u0002\u0013!C1sOVlWM\u001c;tC\t\t9-\u0001B3\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023o\\;sG\u0016$&\u0010I\u0017!i\",\u0007\u0005^5nK\u0002RxN\\3!M>\u0014\b\u0005\u001e5fA%t\u0007/\u001e;!i&lWm\u001d;b[Bt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Je\rI5uA%\u001c\b%\\5tg\u0016$G\u0006\t;iK\u0002\u001aWO\u001d:f]R\u00043/Z:tS>t\u0007\u0005^5nK\u0002RxN\\3!SN\u0004So]3eA\u0005\u001c\b\u0005\u001e5fAM|WO]2fAQLW.\u001a\u0011{_:,gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uCJ<W\r\u001e+{A5\u0002C\u000f[3!i&lW\r\t>p]\u0016\u0004Co\u001c\u0011xQ&\u001c\u0007\u000e\t;iK\u0002Jg\u000e];uAQLW.Z:uC6\u0004\be\u001d5pk2$\u0007EY3!G>tg/\u001a:uK\u0012T\u0001\u0005\t\u0011!A\u0001R\u0003e]8ve\u000e,Gk\u001d\u0011.A\u0005\u0004C/[7fgR\fW\u000e\u001d\u0011xSRDw.\u001e;!i&lW\r\t>p]\u0016T\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QZ\u0001\u0002v*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%R;s_B,wF\u0011:vgN,Gn]\u0014-A\u001d\nU.\u001a:jG\u0006|Cj\\:`\u0003:<W\r\\3tO1\u0002C/[7fgR\fW\u000e]0oij<#\u0007\r\u001a2[E\u0012T\u0006\r\u001c!aAR\u0004\u0007\r\u001e1a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1eEj\u0013GM\u00171k\u0001\nTG\u000f\u00191uA\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014FkJ|\u0007/Z\u0018CeV\u001c8/\u001a7tO1\u0002C/[7fgR\fW\u000e]0oij<#\u0007\r\u001a2[E\u0012T\u0006M\u001b!cUR\u0004\u0007\r\u001e1a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1eEj\u0013GM\u00171m\u0001\u0002\u0004G\u000f\u00191uA\u0002$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005M\u0017A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u00033\fQa\r\u00185]A\nqbQ8om\u0016\u0014H\u000fV5nKj|g.\u001a\t\u0003k}\u0019RaHAq\u0003[\u0004\u0002\"a9\u0002j>{u*W\u0007\u0003\u0003KT1!a:>\u0003\u001d\u0011XO\u001c;j[\u0016LA!a;\u0002f\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005=\u0018Q_\u0007\u0003\u0003cTA!a=\u0002|\u0005\u0011\u0011n\\\u0005\u0004\u0017\u0006EHCAAo\u0003!!xn\u0015;sS:<GCAA:\u0003\u0015\t\u0007\u000f\u001d7z)\u001dI&\u0011\u0001B\u0002\u0005\u000bAQ!\u0014\u0012A\u0002=CQa\u0015\u0012A\u0002=CQ!\u0016\u0012A\u0002=\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\f\t]\u0001#\u0002\u001f\u0003\u000e\tE\u0011b\u0001B\b{\t1q\n\u001d;j_:\u0004b\u0001\u0010B\n\u001f>{\u0015b\u0001B\u000b{\t1A+\u001e9mKNB\u0001B!\u0007$\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0010!\u0011\t)H!\t\n\t\t\r\u0012q\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class ConvertTimezone
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression sourceTz;
    private final Expression targetTz;
    private final Expression sourceTs;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ConvertTimezone x$0) {
        return ConvertTimezone$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ConvertTimezone> tupled() {
        return ConvertTimezone$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ConvertTimezone>>> curried() {
        return ConvertTimezone$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression sourceTz() {
        return this.sourceTz;
    }

    public Expression targetTz() {
        return this.targetTz;
    }

    public Expression sourceTs() {
        return this.sourceTs;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression first() {
        return this.sourceTz();
    }

    @Override
    public Expression second() {
        return this.targetTz();
    }

    @Override
    public Expression third() {
        return this.sourceTs();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)TimestampNTZType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return TimestampNTZType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object srcTz, Object tgtTz, Object micros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.convertTimestampNtzToAnotherTz(((UTF8String)srcTz).toString(), ((UTF8String)tgtTz).toString(), BoxesRunTime.unboxToLong((Object)micros)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(srcTz, tgtTz, micros) -> dtu + ".convertTimestampNtzToAnotherTz(" + srcTz + ".toString(), " + tgtTz + ".toString(), " + micros + ")");
    }

    @Override
    public String prettyName() {
        return "convert_timezone";
    }

    @Override
    public ConvertTimezone withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public ConvertTimezone copy(Expression sourceTz, Expression targetTz, Expression sourceTs) {
        return new ConvertTimezone(sourceTz, targetTz, sourceTs);
    }

    public Expression copy$default$1() {
        return this.sourceTz();
    }

    public Expression copy$default$2() {
        return this.targetTz();
    }

    public Expression copy$default$3() {
        return this.sourceTs();
    }

    @Override
    public String productPrefix() {
        return "ConvertTimezone";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sourceTz();
            }
            case 1: {
                return this.targetTz();
            }
            case 2: {
                return this.sourceTs();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ConvertTimezone;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "sourceTz";
            }
            case 1: {
                return "targetTz";
            }
            case 2: {
                return "sourceTs";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ConvertTimezone)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConvertTimezone convertTimezone = (ConvertTimezone)x$1;
        Expression expression = this.sourceTz();
        Expression expression2 = convertTimezone.sourceTz();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.targetTz();
        Expression expression4 = convertTimezone.targetTz();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.sourceTs();
        Expression expression6 = convertTimezone.sourceTs();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!convertTimezone.canEqual(this)) return false;
        return true;
    }

    public ConvertTimezone(Expression sourceTz, Expression targetTz, Expression sourceTs) {
        this.sourceTz = sourceTz;
        this.targetTz = targetTz;
        this.sourceTs = sourceTs;
        ExpectsInputTypes.$init$(this);
    }

    public ConvertTimezone(Expression targetTz, Expression sourceTs) {
        this(new CurrentTimeZone(), targetTz, sourceTs);
    }
}

