/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;

public final class JavaStructuredKerberizedKafkaWordCount {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: JavaStructuredKerberizedKafkaWordCount <bootstrap-servers> <subscribe-type> <topics>");
            System.exit(1);
        }
        String bootstrapServers = args[0];
        String subscribeType = args[1];
        String topics = args[2];
        SparkSession spark = SparkSession.builder().appName("JavaStructuredKerberizedKafkaWordCount").getOrCreate();
        Dataset lines = spark.readStream().format("kafka").option("kafka.bootstrap.servers", bootstrapServers).option(subscribeType, topics).option("kafka.security.protocol", SecurityProtocol.SASL_PLAINTEXT.name).load().selectExpr(new String[]{"CAST(value AS STRING)"}).as(Encoders.STRING());
        Dataset wordCounts = lines.flatMap((FlatMapFunction & Serializable)x -> Arrays.asList(x.split(" ")).iterator(), Encoders.STRING()).groupBy("value", new String[0]).count();
        StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").start();
        query.awaitTermination();
    }
}

