/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.examples.ml.DecisionTreeExample$;
import org.apache.spark.examples.ml.LinearRegressionExample;
import org.apache.spark.examples.ml.LinearRegressionExample$;
import org.apache.spark.examples.ml.LinearRegressionExample$Params$;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class LinearRegressionExample$ {
    public static final LinearRegressionExample$ MODULE$ = new LinearRegressionExample$();

    public void main(String[] args) {
        LinearRegressionExample.Params defaultParams = new LinearRegressionExample.Params(LinearRegressionExample$Params$.MODULE$.apply$default$1(), LinearRegressionExample$Params$.MODULE$.apply$default$2(), LinearRegressionExample$Params$.MODULE$.apply$default$3(), LinearRegressionExample$Params$.MODULE$.apply$default$4(), LinearRegressionExample$Params$.MODULE$.apply$default$5(), LinearRegressionExample$Params$.MODULE$.apply$default$6(), LinearRegressionExample$Params$.MODULE$.apply$default$7(), LinearRegressionExample$Params$.MODULE$.apply$default$8());
        OptionParser<LinearRegressionExample.Params> parser = new OptionParser<LinearRegressionExample.Params>(defaultParams){

            public static final /* synthetic */ LinearRegressionExample.Params $anonfun$new$1(double x, LinearRegressionExample.Params c) {
                double x$1 = x;
                String x$2 = c.copy$default$1();
                String x$3 = c.copy$default$2();
                String x$4 = c.copy$default$3();
                double x$5 = c.copy$default$5();
                int x$6 = c.copy$default$6();
                double x$7 = c.copy$default$7();
                double x$8 = c.copy$default$8();
                return c.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8);
            }

            public static final /* synthetic */ LinearRegressionExample.Params $anonfun$new$2(double x, LinearRegressionExample.Params c) {
                double x$9 = x;
                String x$10 = c.copy$default$1();
                String x$11 = c.copy$default$2();
                String x$12 = c.copy$default$3();
                double x$13 = c.copy$default$4();
                int x$14 = c.copy$default$6();
                double x$15 = c.copy$default$7();
                double x$16 = c.copy$default$8();
                return c.copy(x$10, x$11, x$12, x$13, x$9, x$14, x$15, x$16);
            }

            public static final /* synthetic */ LinearRegressionExample.Params $anonfun$new$3(int x, LinearRegressionExample.Params c) {
                int x$17 = x;
                String x$18 = c.copy$default$1();
                String x$19 = c.copy$default$2();
                String x$20 = c.copy$default$3();
                double x$21 = c.copy$default$4();
                double x$22 = c.copy$default$5();
                double x$23 = c.copy$default$7();
                double x$24 = c.copy$default$8();
                return c.copy(x$18, x$19, x$20, x$21, x$22, x$17, x$23, x$24);
            }

            public static final /* synthetic */ LinearRegressionExample.Params $anonfun$new$4(double x, LinearRegressionExample.Params c) {
                double x$25 = x;
                String x$26 = c.copy$default$1();
                String x$27 = c.copy$default$2();
                String x$28 = c.copy$default$3();
                double x$29 = c.copy$default$4();
                double x$30 = c.copy$default$5();
                int x$31 = c.copy$default$6();
                double x$32 = c.copy$default$8();
                return c.copy(x$26, x$27, x$28, x$29, x$30, x$31, x$25, x$32);
            }

            public static final /* synthetic */ LinearRegressionExample.Params $anonfun$new$5(double x, LinearRegressionExample.Params c) {
                double x$33 = x;
                String x$34 = c.copy$default$1();
                String x$35 = c.copy$default$2();
                String x$36 = c.copy$default$3();
                double x$37 = c.copy$default$4();
                double x$38 = c.copy$default$5();
                int x$39 = c.copy$default$6();
                double x$40 = c.copy$default$7();
                return c.copy(x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$33);
            }
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"LinearRegressionExample: an example Linear Regression with Elastic-Net app."}));
                this.opt("regParam", Read$.MODULE$.doubleRead()).text("regularization parameter, default: " + defaultParams$1.regParam()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$1(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("elasticNetParam", Read$.MODULE$.doubleRead()).text("ElasticNet mixing parameter. For alpha = 0, the penalty is an L2 penalty. For alpha = 1, it is an L1 penalty. For 0 < alpha < 1, the penalty is a combination of L1 and L2, default: " + defaultParams$1.elasticNetParam()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$2(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("maxIter", Read$.MODULE$.intRead()).text("maximum number of iterations, default: " + defaultParams$1.maxIter()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("tol", Read$.MODULE$.doubleRead()).text("the convergence tolerance of iterations, Smaller value will lead to higher accuracy with the cost of more iterations, default: " + defaultParams$1.tol()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text("fraction of data to hold out for testing. If given option testInput, this option is ignored. default: " + defaultParams$1.fracTest()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("testInput", Read$.MODULE$.stringRead()).text("input path to test dataset. If given, option fracTest is ignored. default: " + defaultParams$1.testInput()).action((Function2 & Serializable)(x, c) -> {
                    String x$41 = x;
                    String x$42 = c.copy$default$1();
                    String x$43 = c.copy$default$3();
                    double x$44 = c.copy$default$4();
                    double x$45 = c.copy$default$5();
                    int x$46 = c.copy$default$6();
                    double x$47 = c.copy$default$7();
                    double x$48 = c.copy$default$8();
                    return c.copy(x$42, x$41, x$43, x$44, x$45, x$46, x$47, x$48);
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2 & Serializable)(x, c) -> {
                    String x$49 = x;
                    String x$50 = c.copy$default$1();
                    String x$51 = c.copy$default$2();
                    double x$52 = c.copy$default$4();
                    double x$53 = c.copy$default$5();
                    int x$54 = c.copy$default$6();
                    double x$55 = c.copy$default$7();
                    double x$56 = c.copy$default$8();
                    return c.copy(x$50, x$51, x$49, x$52, x$53, x$54, x$55, x$56);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8()));
                this.checkConfig((Function1 & Serializable)params -> {
                    if (params.fracTest() < 0.0 || params.fracTest() >= 1.0) {
                        return this.failure("fracTest " + params.fracTest() + " value incorrect; should be in [0,1).");
                    }
                    return this.success();
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(java.lang.Object org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$2$adapted(java.lang.Object org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$6(java.lang.String org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$7(java.lang.String org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$8(java.lang.String org.apache.spark.examples.ml.LinearRegressionExample$Params ), $anonfun$new$9(org.apache.spark.examples.ml.LinearRegressionExample$$anon$1 org.apache.spark.examples.ml.LinearRegressionExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            LinearRegressionExample.Params params = (LinearRegressionExample.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(LinearRegressionExample.Params params) {
        Dataset dataset;
        Dataset test;
        SparkSession spark;
        block3: {
            Tuple2<Dataset<Row>, Dataset<Row>> tuple2;
            block2: {
                spark = SparkSession$.MODULE$.builder().appName("LinearRegressionExample with " + params).getOrCreate();
                Predef$.MODULE$.println((Object)("LinearRegressionExample with parameters:\n" + params));
                tuple2 = DecisionTreeExample$.MODULE$.loadDatasets(params.input(), params.dataFormat(), params.testInput(), "regression", params.fracTest());
                if (tuple2 == null) break block2;
                Dataset training = (Dataset)tuple2._1();
                test = (Dataset)tuple2._2();
                if (training == null) break block2;
                dataset = training;
                if (test != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Dataset dataset2 = test;
        Tuple2 tuple2 = new Tuple2((Object)dataset, (Object)dataset2);
        Dataset training = (Dataset)tuple2._1();
        Dataset test2 = (Dataset)tuple2._2();
        LinearRegression lir = ((LinearRegression)new LinearRegression().setFeaturesCol("features").setLabelCol("label")).setRegParam(params.regParam()).setElasticNetParam(params.elasticNetParam()).setMaxIter(params.maxIter()).setTol(params.tol());
        long startTime = System.nanoTime();
        LinearRegressionModel lirModel = (LinearRegressionModel)lir.fit(training);
        double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
        Predef$.MODULE$.println((Object)("Training time: " + elapsedTime + " seconds"));
        Predef$.MODULE$.println((Object)("Weights: " + lirModel.coefficients() + " Intercept: " + lirModel.intercept()));
        Predef$.MODULE$.println((Object)"Training data results:");
        DecisionTreeExample$.MODULE$.evaluateRegressionModel((Transformer)lirModel, (Dataset<Row>)training, "label");
        Predef$.MODULE$.println((Object)"Test data results:");
        DecisionTreeExample$.MODULE$.evaluateRegressionModel((Transformer)lirModel, (Dataset<Row>)test2, "label");
        spark.stop();
    }

    private LinearRegressionExample$() {
    }
}

