/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.UnivariateFeatureSelector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaUnivariateFeatureSelectorExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaUnivariateFeatureSelectorExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{1, Vectors.dense((double)1.7, (double[])new double[]{4.4, 7.6, 5.8, 9.6, 2.3}), 3.0}), RowFactory.create((Object[])new Object[]{2, Vectors.dense((double)8.8, (double[])new double[]{7.3, 5.7, 7.3, 2.2, 4.1}), 2.0}), RowFactory.create((Object[])new Object[]{3, Vectors.dense((double)1.2, (double[])new double[]{9.5, 2.5, 3.1, 8.7, 2.5}), 3.0}), RowFactory.create((Object[])new Object[]{4, Vectors.dense((double)3.7, (double[])new double[]{9.2, 6.1, 4.1, 7.5, 3.8}), 2.0}), RowFactory.create((Object[])new Object[]{5, Vectors.dense((double)8.9, (double[])new double[]{5.2, 7.8, 8.3, 5.2, 3.0}), 4.0}), RowFactory.create((Object[])new Object[]{6, Vectors.dense((double)7.9, (double[])new double[]{8.5, 9.2, 4.0, 9.4, 2.1}), 4.0}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty()), new StructField("label", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        UnivariateFeatureSelector selector = new UnivariateFeatureSelector().setFeatureType("continuous").setLabelType("categorical").setSelectionMode("numTopFeatures").setSelectionThreshold(1.0).setFeaturesCol("features").setLabelCol("label").setOutputCol("selectedFeatures");
        Dataset result = selector.fit(df).transform(df);
        System.out.println("UnivariateFeatureSelector output with top " + selector.getSelectionThreshold() + " features selected using f_classif");
        result.show();
        spark.stop();
    }
}

